"use strict";
(self["webpackChunkafterlogic_aurora_platform"] = self["webpackChunkafterlogic_aurora_platform"] || []).push([[28],{

/***/ "/bge":
/*!****************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/COpenPgpKey.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  AddressUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Address.js */ "rBrp");

/**
 * @todo
 * @param {Object} oOpenPgpKey
 * @constructor
 */
function COpenPgpKey(oOpenPgpKey) {
  this.pgpKey = oOpenPgpKey;
  var oPrimaryUser = this.pgpKey.getPrimaryUser();
  this.user = oPrimaryUser && oPrimaryUser.user ? oPrimaryUser.user.userId.userid : this.pgpKey.users && this.pgpKey.users[0] ? this.pgpKey.users[0].userId.userid : '';
  this.userName = oPrimaryUser && oPrimaryUser.user ? oPrimaryUser.user.userId.name : this.pgpKey.users && this.pgpKey.users[0] ? this.pgpKey.users[0].userId.name : '';
  this.emailParts = AddressUtils.getEmailParts(this.user);
}

/**
 * @type {Object}
 */
COpenPgpKey.prototype.pgpKey = null;

/**
 * @type {string}
 */
COpenPgpKey.prototype.passphrase = null;

/**
 * @type {Object}
 */
COpenPgpKey.prototype.emailParts = null;

/**
 * @type {string}
 */
COpenPgpKey.prototype.user = '';

/**
 * @type {string}
 */
COpenPgpKey.prototype.userName = '';

/**
 * @type {boolean}
 */
COpenPgpKey.prototype.isFromContacts = false;

/**
 * @return {string}
 */
COpenPgpKey.prototype.getId = function () {
  return this.pgpKey.primaryKey.getKeyId().toHex().toLowerCase();
};

/**
 * @param {string} sId
 * @returns {Boolean}
 */
COpenPgpKey.prototype.hasId = function (sId) {
  return !!_.find(this.pgpKey.getKeyIds(), function (sKeyId) {
    return sKeyId.toHex() === sId;
  });
};

/**
 * @return {string}
 */
COpenPgpKey.prototype.getEmail = function () {
  return this.emailParts['email'] || this.user;
};

/**
 * @return {string}
 */
COpenPgpKey.prototype.getUser = function () {
  return this.user;
};

/**
 * @return {string}
 */
COpenPgpKey.prototype.getUserName = function () {
  return this.userName;
};

/**
 * @return {string}
 */
COpenPgpKey.prototype.getFingerprint = function () {
  return this.pgpKey.primaryKey.getFingerprint();
};

/**
 * @return {number}
 */
COpenPgpKey.prototype.getBitSize = function () {
  var aAlgorithmInfo = this.pgpKey.primaryKey.getAlgorithmInfo(),
    iBitSize = aAlgorithmInfo.bits ? aAlgorithmInfo.bits : 0;
  return iBitSize;
};

/**
 * @return {string}
 */
COpenPgpKey.prototype.getArmor = function () {
  return this.pgpKey.armor();
};

/**
 * @return {boolean}
 */
COpenPgpKey.prototype.isPrivate = function () {
  return !!this.pgpKey.isPrivate();
};

/**
 * @return {boolean}
 */
COpenPgpKey.prototype.isPublic = function () {
  return !this.isPrivate();
};

/**
 * @return {string}
 */
COpenPgpKey.prototype.getPassphrase = function () {
  return this.passphrase;
};
COpenPgpKey.prototype.setPassphrase = function (sPassphrase) {
  this.passphrase = sPassphrase;
};
module.exports = COpenPgpKey;

/***/ }),

/***/ "BPV1":
/*!*******************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/COpenPgpResult.js ***!
  \*******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var Enums = __webpack_require__(/*! modules/OpenPgpWebclient/js/Enums.js */ "vfpp");

/**
 * @todo
 * @constructor
 */
function COpenPgpResult() {
  this.result = true;
  this.errors = null;
  this.notices = null;
  this.exceptions = null;
}

/**
 * @type {mixed}
 */
COpenPgpResult.prototype.result = false;

/**
 * @type {Array|null}
 */
COpenPgpResult.prototype.errors = null;

/**
 * @type {Array|null}
 */
COpenPgpResult.prototype.notices = null;

/**
 * @param {number} iCode
 * @param {string} sValue
 * @return {COpenPgpResult}
 */
COpenPgpResult.prototype.addError = function (iCode, sValue) {
  this.result = false;
  this.errors = this.errors || [];
  this.errors.push([iCode || Enums.OpenPgpErrors.UnknownError, sValue || '']);
  return this;
};

/**
 * @param {number} iCode
 * @param {string} sValue
 * @return {COpenPgpResult}
 */
COpenPgpResult.prototype.addNotice = function (iCode, sValue) {
  this.notices = this.notices || [];
  this.notices.push([iCode || Enums.OpenPgpErrors.UnknownNotice, sValue || '']);
  return this;
};

/**
 * @param {Error} e
 * @param {number=} iErrorCode
 * @param {string=} sErrorMessage
 * @return {COpenPgpResult}
 */
COpenPgpResult.prototype.addExceptionMessage = function (e, iErrorCode, sErrorMessage) {
  if (e) {
    this.result = false;
    this.exceptions = this.exceptions || [];
    this.exceptions.push('' + (e.name || 'unknown') + ': ' + (e.message || ''));
  }
  if (iErrorCode) {
    this.addError(iErrorCode, sErrorMessage);
  }
  return this;
};

/**
 *  @return {boolean}
 */
COpenPgpResult.prototype.hasErrors = function () {
  return this.errors && 0 < this.errors.length;
};

/**
 *  @return {boolean}
 */
COpenPgpResult.prototype.hasNotices = function () {
  return this.notices && 0 < this.notices.length;
};
module.exports = COpenPgpResult;

/***/ }),

/***/ "E7cO":
/*!************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/OpenPgp.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorValues(e) { if (null != e) { var t = e["function" == typeof Symbol && Symbol.iterator || "@@iterator"], r = 0; if (t) return t.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) return { next: function next() { return e && r >= e.length && (e = void 0), { value: e && e[r++], done: !e }; } }; } throw new TypeError(_typeof(e) + " is not iterable"); }
function _createForOfIteratorHelper(r, e) { var t = "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (!t) { if (Array.isArray(r) || (t = _unsupportedIterableToArray(r)) || e && r && "number" == typeof r.length) { t && (r = t); var _n = 0, F = function F() {}; return { s: F, n: function n() { return _n >= r.length ? { done: !0 } : { done: !1, value: r[_n++] }; }, e: function e(r) { throw r; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var o, a = !0, u = !1; return { s: function s() { t = t.call(r); }, n: function n() { var r = t.next(); return a = r.done, r; }, e: function e(r) { u = !0, o = r; }, f: function f() { try { a || null == t["return"] || t["return"](); } finally { if (u) throw o; } } }; }
function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
var _ = __webpack_require__(/*! underscore */ "C3HO"),
  $ = __webpack_require__(/*! jquery */ "M4cL"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  AddressUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Address.js */ "rBrp"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  openpgp = __webpack_require__(/*! modules/CoreWebclient/js/vendors/openpgp.js */ "h/lg"),
  Ajax = __webpack_require__(/*! modules/CoreWebclient/js/Ajax.js */ "8QQh"),
  App = __webpack_require__(/*! modules/CoreWebclient/js/App.js */ "yU9o"),
  ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
  Popups = __webpack_require__(/*! modules/CoreWebclient/js/Popups.js */ "PMEU"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  ErrorsUtils = __webpack_require__(/*! modules/OpenPgpWebclient/js/utils/Errors.js */ "RIpb"),
  COpenPgpKey = __webpack_require__(/*! modules/OpenPgpWebclient/js/COpenPgpKey.js */ "/bge"),
  COpenPgpResult = __webpack_require__(/*! modules/OpenPgpWebclient/js/COpenPgpResult.js */ "BPV1"),
  Enums = __webpack_require__(/*! modules/OpenPgpWebclient/js/Enums.js */ "vfpp"),
  PGPKeyPasswordPopup = __webpack_require__(/*! modules/OpenPgpWebclient/js/popups/PGPKeyPasswordPopup.js */ "avF0"),
  Settings = __webpack_require__(/*! modules/OpenPgpWebclient/js/Settings.js */ "a9Z8"),
  isTeamContactsAvailable = ModulesManager.isModuleAvailable('TeamContacts');
function getKeysFromArmors(_x) {
  return _getKeysFromArmors.apply(this, arguments);
}
function _getKeysFromArmors() {
  _getKeysFromArmors = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee28(armorsData) {
    var openPgpKeys, _iterator5, _step5, key, nativeKey, openPgpKey, _t16;
    return _regenerator().w(function (_context31) {
      while (1) switch (_context31.p = _context31.n) {
        case 0:
          openPgpKeys = [];
          _iterator5 = _createForOfIteratorHelper(armorsData);
          _context31.p = 1;
          _iterator5.s();
        case 2:
          if ((_step5 = _iterator5.n()).done) {
            _context31.n = 5;
            break;
          }
          key = _step5.value;
          _context31.n = 3;
          return openpgp.key.readArmored(key.PublicPgpKey);
        case 3:
          nativeKey = _context31.v;
          if (nativeKey && !nativeKey.err && nativeKey.keys && nativeKey.keys[0]) {
            openPgpKey = new COpenPgpKey(nativeKey.keys[0]);
            if (openPgpKey) {
              openPgpKey.isFromContacts = true;
              openPgpKeys.push(openPgpKey);
            }
          }
        case 4:
          _context31.n = 2;
          break;
        case 5:
          _context31.n = 7;
          break;
        case 6:
          _context31.p = 6;
          _t16 = _context31.v;
          _iterator5.e(_t16);
        case 7:
          _context31.p = 7;
          _iterator5.f();
          return _context31.f(7);
        case 8:
          return _context31.a(2, openPgpKeys);
      }
    }, _callee28, null, [[1, 6, 7, 8]]);
  }));
  return _getKeysFromArmors.apply(this, arguments);
}
;
function importExternalKeys(_x2) {
  return _importExternalKeys.apply(this, arguments);
}
function _importExternalKeys() {
  _importExternalKeys = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee29(externalKeys) {
    var addKeysPromise;
    return _regenerator().w(function (_context32) {
      while (1) switch (_context32.n) {
        case 0:
          addKeysPromise = new Promise(function (resolve, reject) {
            var parameters = {
                Keys: externalKeys.map(function (key) {
                  return {
                    Email: key.getEmail(),
                    Key: key.getArmor(),
                    Name: key.getUserName()
                  };
                })
              },
              responseHandler = function responseHandler(response) {
                return resolve(response && response.Result);
              };
            Ajax.send('OpenPgpWebclient', 'AddPublicKeysToContacts', parameters, responseHandler);
          });
          _context32.n = 1;
          return addKeysPromise;
        case 1:
          return _context32.a(2, _context32.v);
      }
    }, _callee29);
  }));
  return _importExternalKeys.apply(this, arguments);
}
function updateContactPublicKey(_x3, _x4) {
  return _updateContactPublicKey.apply(this, arguments);
}
function _updateContactPublicKey() {
  _updateContactPublicKey = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee30(publicPgpKeyArmor, UUID) {
    var updateOwnPublicKeyPromise;
    return _regenerator().w(function (_context33) {
      while (1) switch (_context33.n) {
        case 0:
          updateOwnPublicKeyPromise = new Promise(function (resolve, reject) {
            var parameters = {
                UUID: UUID,
                Key: publicPgpKeyArmor
              },
              responseHandler = function responseHandler(response) {
                return resolve(response && response.Result);
              };
            Ajax.send('OpenPgpWebclient', 'AddPublicKeyToContactWithUUID', parameters, responseHandler);
          });
          _context33.n = 1;
          return updateOwnPublicKeyPromise;
        case 1:
          return _context33.a(2, _context33.v);
      }
    }, _callee30);
  }));
  return _updateContactPublicKey.apply(this, arguments);
}
function updateOwnContactPublicKey(_x5) {
  return _updateOwnContactPublicKey.apply(this, arguments);
}
function _updateOwnContactPublicKey() {
  _updateOwnContactPublicKey = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee31(publicPgpKeyArmor) {
    var updateOwnPublicKeyPromise;
    return _regenerator().w(function (_context34) {
      while (1) switch (_context34.n) {
        case 0:
          updateOwnPublicKeyPromise = new Promise(function (resolve, reject) {
            var parameters = {
                PublicPgpKey: publicPgpKeyArmor
              },
              responseHandler = function responseHandler(response) {
                return resolve(response && response.Result);
              };
            Ajax.send('OpenPgpWebclient', 'UpdateOwnContactPublicKey', parameters, responseHandler);
          });
          _context34.n = 1;
          return updateOwnPublicKeyPromise;
        case 1:
          return _context34.a(2, _context34.v);
      }
    }, _callee31);
  }));
  return _updateOwnContactPublicKey.apply(this, arguments);
}
function getPublicKeysFromContacts() {
  return _getPublicKeysFromContacts.apply(this, arguments);
}
function _getPublicKeysFromContacts() {
  _getPublicKeysFromContacts = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee33() {
    return _regenerator().w(function (_context36) {
      while (1) switch (_context36.n) {
        case 0:
          return _context36.a(2, new Promise(function (resolve) {
            var responseHandler = /*#__PURE__*/function () {
              var _ref28 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee32(response) {
                var armors, openPgpKeys;
                return _regenerator().w(function (_context35) {
                  while (1) switch (_context35.n) {
                    case 0:
                      armors = response && response.Result;
                      if (!Array.isArray(armors)) {
                        _context35.n = 2;
                        break;
                      }
                      _context35.n = 1;
                      return getKeysFromArmors(armors);
                    case 1:
                      openPgpKeys = _context35.v;
                      resolve(openPgpKeys);
                    case 2:
                      return _context35.a(2);
                  }
                }, _callee32);
              }));
              return function responseHandler(_x58) {
                return _ref28.apply(this, arguments);
              };
            }();
            Ajax.send('OpenPgpWebclient', 'GetPublicKeysFromContacts', {}, responseHandler);
          }));
      }
    }, _callee33);
  }));
  return _getPublicKeysFromContacts.apply(this, arguments);
}
function getOwnPublicKeyFromTeamContacts() {
  return _getOwnPublicKeyFromTeamContacts.apply(this, arguments);
}
/**
 * @constructor
 */
function _getOwnPublicKeyFromTeamContacts() {
  _getOwnPublicKeyFromTeamContacts = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee35() {
    return _regenerator().w(function (_context38) {
      while (1) switch (_context38.n) {
        case 0:
          return _context38.a(2, new Promise(function (resolve, reject) {
            if (isTeamContactsAvailable) {
              var responseHandler = /*#__PURE__*/function () {
                var _ref29 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee34(response) {
                  var result, armors, openPgpKeys;
                  return _regenerator().w(function (_context37) {
                    while (1) switch (_context37.n) {
                      case 0:
                        result = response && response.Result, armors = Types.isNonEmptyString(result) ? [{
                          Email: App.getUserPublicId(),
                          PublicPgpKey: result
                        }] : null;
                        if (!Array.isArray(armors)) {
                          _context37.n = 2;
                          break;
                        }
                        _context37.n = 1;
                        return getKeysFromArmors(armors);
                      case 1:
                        openPgpKeys = _context37.v;
                        resolve(openPgpKeys.length > 0 && openPgpKeys[0] || false);
                        _context37.n = 3;
                        break;
                      case 2:
                        resolve(false);
                      case 3:
                        return _context37.a(2);
                    }
                  }, _callee34);
                }));
                return function responseHandler(_x59) {
                  return _ref29.apply(this, arguments);
                };
              }();
              Ajax.send('OpenPgpWebclient', 'GetOwnContactPublicKey', {}, responseHandler);
            } else {
              resolve(null);
            }
          }));
      }
    }, _callee35);
  }));
  return _getOwnPublicKeyFromTeamContacts.apply(this, arguments);
}
function COpenPgp() {
  var _this = this;
  this.oKeyring = new openpgp.Keyring(new openpgp.Keyring.localstore("aurora_openpgp_user_".concat(App.getUserId() || 0, "_")));
  this.keys = ko.observableArray([]);
  this.ownKeyFromTeamContacts = ko.observable(null);
  this.oPromiseInitialised = this.initKeys();
  App.subscribeEvent('ContactsWebclient::createContactResponse', function (aParams) {
    var responseResult = aParams[0];
    if (responseResult) {
      _this.reloadKeysFromStorage();
    }
  });
  App.subscribeEvent('ContactsWebclient::updateContactResponse', function (aParams) {
    var responseResult = aParams[0];
    if (responseResult) {
      _this.reloadKeysFromStorage();
    }
  });
  App.subscribeEvent('ContactsWebclient::deleteContactsResponse', function (aParams) {
    var responseResult = aParams[0];
    if (responseResult) {
      _this.reloadKeysFromStorage();
    }
  });
}
COpenPgp.prototype.oKeyring = null;
COpenPgp.prototype.initKeys = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
  return _regenerator().w(function (_context) {
    while (1) switch (_context.n) {
      case 0:
        _context.n = 1;
        return this.oKeyring.load();
      case 1:
        _context.n = 2;
        return this.reloadKeysFromStorage();
      case 2:
        return _context.a(2);
    }
  }, _callee, this);
}));

/**
 * @return {Array}
 */
COpenPgp.prototype.getKeys = function () {
  return this.keys();
};

/**
 * @return {Array}
 */
COpenPgp.prototype.getPublicKeys = function () {
  return _.filter(this.keys(), function (oKey) {
    return oKey && oKey.isPublic() === true;
  });
};

/**
 * @return {Array}
 */
COpenPgp.prototype.getPrivateKeys = function () {
  return _.filter(this.keys(), function (oKey) {
    return oKey && oKey.isPublic() !== true;
  });
};

/**
 * @return {mixed}
 */
COpenPgp.prototype.getKeysObservable = function () {
  return this.keys;
};

/**
 * @private
 */
COpenPgp.prototype.reloadKeysFromStorage = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
  var keysFromLocalstorage, keysFromContacts, _t;
  return _regenerator().w(function (_context2) {
    while (1) switch (_context2.n) {
      case 0:
        if (!App.isUserNormalOrTenant()) {
          _context2.n = 3;
          break;
        }
        keysFromLocalstorage = this.oKeyring.getAllKeys().filter(function (key) {
          return key && key.primaryKey;
        }).map(function (key) {
          return new COpenPgpKey(key);
        });
        _context2.n = 1;
        return getPublicKeysFromContacts();
      case 1:
        keysFromContacts = _context2.v;
        this.keys([].concat(_toConsumableArray(keysFromLocalstorage), _toConsumableArray(keysFromContacts)));
        _t = this;
        _context2.n = 2;
        return getOwnPublicKeyFromTeamContacts();
      case 2:
        _t.ownKeyFromTeamContacts.call(_t, _context2.v);
        _context2.n = 4;
        break;
      case 3:
        this.keys([]);
      case 4:
        return _context2.a(2);
    }
  }, _callee2, this);
}));
COpenPgp.prototype.getKeysFromArmors = getKeysFromArmors;

/**
 * @private
 * @param {Array} aKeys
 * @return {Array}
 */
COpenPgp.prototype.convertToNativeKeys = function (aKeys) {
  return _.map(aKeys, function (oItem) {
    return oItem && oItem.pgpKey ? oItem.pgpKey : oItem;
  });
};

/**
 * @private
 * @param {Object} oKey
 */
COpenPgp.prototype.cloneKey = /*#__PURE__*/function () {
  var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(oKey) {
    var oPrivateKey;
    return _regenerator().w(function (_context3) {
      while (1) switch (_context3.n) {
        case 0:
          oPrivateKey = null;
          if (!oKey) {
            _context3.n = 2;
            break;
          }
          _context3.n = 1;
          return openpgp.key.readArmored(oKey.armor());
        case 1:
          oPrivateKey = _context3.v;
          if (oPrivateKey && !oPrivateKey.err && oPrivateKey.keys && oPrivateKey.keys[0]) {
            oPrivateKey = oPrivateKey.keys[0];
            if (!oPrivateKey || !oPrivateKey.primaryKey) {
              oPrivateKey = null;
            }
          } else {
            oPrivateKey = null;
          }
        case 2:
          return _context3.a(2, oPrivateKey);
      }
    }, _callee3);
  }));
  return function (_x6) {
    return _ref3.apply(this, arguments);
  };
}();

/**
 * @private
 * @param {Object} oResult
 * @param {Object} oKey
 * @param {string} sPassword
 * @param {string} sKeyEmail
 */
COpenPgp.prototype.decryptKeyHelper = /*#__PURE__*/function () {
  var _ref4 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(oResult, oKey, sPassword, sKeyEmail) {
    var _t2;
    return _regenerator().w(function (_context4) {
      while (1) switch (_context4.p = _context4.n) {
        case 0:
          if (!(oKey && oKey.primaryKey && oKey.primaryKey.isDecrypted() && sPassword === '')) {
            _context4.n = 1;
            break;
          }
          _context4.n = 7;
          break;
        case 1:
          if (!oKey) {
            _context4.n = 6;
            break;
          }
          _context4.p = 2;
          _context4.n = 3;
          return oKey.decrypt(Types.pString(sPassword));
        case 3:
          if (!oKey || !oKey.primaryKey || !oKey.primaryKey.isDecrypted()) {
            oResult.addError(Enums.OpenPgpErrors.KeyIsNotDecodedError, sKeyEmail || '');
          }
          _context4.n = 5;
          break;
        case 4:
          _context4.p = 4;
          _t2 = _context4.v;
          oResult.addExceptionMessage(_t2, Enums.OpenPgpErrors.KeyIsNotDecodedError, sKeyEmail || '');
        case 5:
          _context4.n = 7;
          break;
        case 6:
          oResult.addError(Enums.OpenPgpErrors.KeyIsNotDecodedError, sKeyEmail || '');
        case 7:
          return _context4.a(2);
      }
    }, _callee4, null, [[2, 4]]);
  }));
  return function (_x7, _x8, _x9, _x0) {
    return _ref4.apply(this, arguments);
  };
}();

/**
 * @private
 * @param {Object} oResult
 * @param {string} sFromEmail
 * @param {Object} oDecryptedMessage
 */
COpenPgp.prototype.verifyMessageHelper = /*#__PURE__*/function () {
  var _ref5 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(oResult, sFromEmail, oDecryptedMessage) {
    var bResult, oValidKey, aVerifyResult, aVerifyKeysId, aPublicKeys, aValidityPromises, _iterator, _step, _loop, _t3, _t4;
    return _regenerator().w(function (_context6) {
      while (1) switch (_context6.p = _context6.n) {
        case 0:
          bResult = false, oValidKey = null, aVerifyResult = [], aVerifyKeysId = [], aPublicKeys = [];
          if (!(oDecryptedMessage && oDecryptedMessage.getSigningKeyIds)) {
            _context6.n = 16;
            break;
          }
          aVerifyKeysId = oDecryptedMessage.getSigningKeyIds();
          if (!(aVerifyKeysId && 0 < aVerifyKeysId.length)) {
            _context6.n = 14;
            break;
          }
          aPublicKeys = this.findKeysByEmails([sFromEmail], true);
          if (!(!aPublicKeys || 0 === aPublicKeys.length)) {
            _context6.n = 1;
            break;
          }
          oResult.addNotice(Enums.OpenPgpErrors.PublicKeyNotFoundNotice, sFromEmail);
          _context6.n = 13;
          break;
        case 1:
          aVerifyResult = [];
          _context6.p = 2;
          _context6.n = 3;
          return oDecryptedMessage.verify(this.convertToNativeKeys(aPublicKeys));
        case 3:
          aVerifyResult = _context6.v;
          _context6.n = 5;
          break;
        case 4:
          _context6.p = 4;
          _t3 = _context6.v;
          oResult.addNotice(Enums.OpenPgpErrors.VerifyErrorNotice, sFromEmail);
        case 5:
          if (!(aVerifyResult && 0 < aVerifyResult.length)) {
            _context6.n = 13;
            break;
          }
          aValidityPromises = [];
          _iterator = _createForOfIteratorHelper(aVerifyResult);
          _context6.p = 6;
          _loop = /*#__PURE__*/_regenerator().m(function _loop() {
            var oKey;
            return _regenerator().w(function (_context5) {
              while (1) switch (_context5.n) {
                case 0:
                  oKey = _step.value;
                  aValidityPromises.push(oKey.verified.then(function (validity) {
                    return oKey && oKey.keyid && validity ? oKey : null;
                  }));
                case 1:
                  return _context5.a(2);
              }
            }, _loop);
          });
          _iterator.s();
        case 7:
          if ((_step = _iterator.n()).done) {
            _context6.n = 9;
            break;
          }
          return _context6.d(_regeneratorValues(_loop()), 8);
        case 8:
          _context6.n = 7;
          break;
        case 9:
          _context6.n = 11;
          break;
        case 10:
          _context6.p = 10;
          _t4 = _context6.v;
          _iterator.e(_t4);
        case 11:
          _context6.p = 11;
          _iterator.f();
          return _context6.f(11);
        case 12:
          _context6.n = 13;
          return Promise.all(aValidityPromises).then(function (aKeys) {
            oValidKey = _.find(aKeys, function (oKey) {
              return oKey !== null;
            });
            if (oValidKey && oValidKey.keyid && aPublicKeys && aPublicKeys[0] && aPublicKeys[0].hasId(oValidKey.keyid.toHex())) {
              bResult = true;
            } else {
              oResult.addNotice(Enums.OpenPgpErrors.VerifyErrorNotice, sFromEmail);
            }
          });
        case 13:
          _context6.n = 15;
          break;
        case 14:
          oResult.addNotice(Enums.OpenPgpErrors.NoSignDataNotice);
        case 15:
          _context6.n = 17;
          break;
        case 16:
          oResult.addError(Enums.OpenPgpErrors.UnknownError);
        case 17:
          if (!bResult && !oResult.hasNotices()) {
            oResult.addNotice(Enums.OpenPgpErrors.VerifyErrorNotice);
          }
          return _context6.a(2, bResult);
      }
    }, _callee5, this, [[6, 10, 11, 12], [2, 4]]);
  }));
  return function (_x1, _x10, _x11) {
    return _ref5.apply(this, arguments);
  };
}();

/**
 * @param {string} sUserID
 * @param {string} sPassword
 * @param {number} nKeyLength
 * @param {Function} fOkHandler
 * @param {Function} fErrorHandler
 *
 * @return {COpenPgpResult}
 */
COpenPgp.prototype.generateKey = function (sUserID, sPassword, nKeyLength, fOkHandler, fErrorHandler) {
  var _this2 = this;
  var oEmailParts = AddressUtils.getEmailParts(sUserID),
    oOptions = {
      userIds: [{
        name: oEmailParts.name,
        email: oEmailParts.email
      }],
      numBits: nKeyLength,
      passphrase: sPassword
    };
  openpgp.generateKey(oOptions).then(/*#__PURE__*/function () {
    var _ref6 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(oKeyPair) {
      return _regenerator().w(function (_context7) {
        while (1) switch (_context7.n) {
          case 0:
            _context7.n = 1;
            return _this2.oKeyring.privateKeys.importKey(oKeyPair.privateKeyArmored);
          case 1:
            _context7.n = 2;
            return _this2.oKeyring.publicKeys.importKey(oKeyPair.publicKeyArmored);
          case 2:
            _context7.n = 3;
            return _this2.oKeyring.store();
          case 3:
            if (_.isFunction(fOkHandler)) {
              fOkHandler();
            }
            _this2.reloadKeysFromStorage();
          case 4:
            return _context7.a(2);
        }
      }, _callee6);
    }));
    return function (_x12) {
      return _ref6.apply(this, arguments);
    };
  }(), function (err) {
    if (_.isFunction(fErrorHandler)) {
      fErrorHandler();
    }
  });
};

/**
 * @private
 * @param {string} sArmor
 * @return {Array}
 */
COpenPgp.prototype.splitKeys = function (sArmor) {
  var aResult = [],
    iCount = 0,
    iLimit = 30,
    aMatch = null,
    sKey = $.trim(sArmor),
    oReg = /[\-]{3,6}BEGIN[\s]PGP[\s](PRIVATE|PUBLIC)[\s]KEY[\s]BLOCK[\-]{3,6}[\s\S]+?[\-]{3,6}END[\s]PGP[\s](PRIVATE|PUBLIC)[\s]KEY[\s]BLOCK[\-]{3,6}/gi;

  //	If the key doesn't have any additional fields (for example "Version: 1.1"), this transformation corrupts the key.
  //	Seems like it is unnecessary transformation. Everything works fine without it.
  //	sKey = sKey.replace(/[\r\n]([a-zA-Z0-9]{2,}:[^\r\n]+)[\r\n]+([a-zA-Z0-9\/\\+=]{10,})/g, '\n$1---xyx---$2')
  //		.replace(/[\n\r]+/g, '\n').replace(/---xyx---/g, '\n\n');

  do {
    aMatch = oReg.exec(sKey);
    if (!aMatch || 0 > iLimit) {
      break;
    }
    if (aMatch[0] && aMatch[1] && aMatch[2] && aMatch[1] === aMatch[2]) {
      if ('PRIVATE' === aMatch[1] || 'PUBLIC' === aMatch[1]) {
        aResult.push([aMatch[1], aMatch[0]]);
        iCount++;
      }
    }
    iLimit--;
  } while (true);
  return aResult;
};
COpenPgp.prototype.isOwnEmail = function (sEmail) {
  if (sEmail === App.getUserPublicId()) {
    return true;
  }
  var ModulesManager = __webpack_require__(/*! modules/CoreWebclient/js/ModulesManager.js */ "5D2l"),
    aOwnEmails = ModulesManager.run('MailWebclient', 'getAllAccountsFullEmails') || [];
  return _.find(aOwnEmails, function (sOwnEmail) {
    var oEmailParts = AddressUtils.getEmailParts(sOwnEmail);
    return sEmail === oEmailParts.email;
  }) !== undefined ? true : false;
};

/**
 * Imports keys only to personal contatcs.
 * @param {string} armor
 * @param {string} contactUUID
 * @param {boolean} isOwnContact
 * @return {COpenPgpResult}
 */
COpenPgp.prototype.addKeyToContact = /*#__PURE__*/function () {
  var _ref7 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(armor) {
    var contactUUID,
      isOwnContact,
      importResult,
      armorsData,
      armorData,
      _armorData,
      publicKey,
      _args8 = arguments;
    return _regenerator().w(function (_context8) {
      while (1) switch (_context8.n) {
        case 0:
          contactUUID = _args8.length > 1 && _args8[1] !== undefined ? _args8[1] : '';
          isOwnContact = _args8.length > 2 && _args8[2] !== undefined ? _args8[2] : false;
          armor = $.trim(armor);
          importResult = new COpenPgpResult();
          if (armor) {
            _context8.n = 1;
            break;
          }
          return _context8.a(2, importResult.addError(Enums.OpenPgpErrors.InvalidArgumentErrors));
        case 1:
          armorsData = this.splitKeys(armor), armorData = armorsData.length === 1 ? armorsData[0] : null;
          if (!(Array.isArray(armorData) && armorData.length === 2 && 'PUBLIC' === armorData[0])) {
            _context8.n = 8;
            break;
          }
          _armorData = armorsData[0];
          _context8.n = 2;
          return openpgp.key.readArmored(_armorData[1]);
        case 2:
          publicKey = _context8.v;
          if (!(publicKey && !publicKey.err && publicKey.keys && publicKey.keys[0])) {
            _context8.n = 8;
            break;
          }
          if (!contactUUID) {
            _context8.n = 5;
            break;
          }
          _context8.n = 3;
          return updateContactPublicKey(_armorData[1], contactUUID);
        case 3:
          if (_context8.v) {
            _context8.n = 4;
            break;
          }
          importResult.addError(Enums.OpenPgpErrors.ImportKeyError);
        case 4:
          this.reloadKeysFromStorage();
          _context8.n = 8;
          break;
        case 5:
          if (!isOwnContact) {
            _context8.n = 8;
            break;
          }
          _context8.n = 6;
          return updateOwnContactPublicKey(_armorData[1]);
        case 6:
          if (_context8.v) {
            _context8.n = 7;
            break;
          }
          importResult.addError(Enums.OpenPgpErrors.ImportKeyError);
        case 7:
          this.reloadKeysFromStorage();
        case 8:
          return _context8.a(2, importResult);
      }
    }, _callee7, this);
  }));
  return function (_x13) {
    return _ref7.apply(this, arguments);
  };
}();

/**
 * @param {string} armorsText
 * @return {COpenPgpResult}
 */
COpenPgp.prototype.importKeys = /*#__PURE__*/function () {
  var _ref8 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8(armorsText) {
    var importResult, importedToLocalstorageCount, importedToContactsCount, armorsData, externalKeys, index, armorData, publicKey, openPgpKey, keyEmail, _t5, _t6;
    return _regenerator().w(function (_context9) {
      while (1) switch (_context9.p = _context9.n) {
        case 0:
          armorsText = $.trim(armorsText);
          importResult = new COpenPgpResult();
          if (armorsText) {
            _context9.n = 1;
            break;
          }
          return _context9.a(2, importResult.addError(Enums.OpenPgpErrors.InvalidArgumentErrors));
        case 1:
          importedToLocalstorageCount = 0, importedToContactsCount = 0, armorsData = this.splitKeys(armorsText), externalKeys = [];
          index = 0;
        case 2:
          if (!(index < armorsData.length)) {
            _context9.n = 15;
            break;
          }
          armorData = armorsData[index];
          if (!('PRIVATE' === armorData[0])) {
            _context9.n = 7;
            break;
          }
          _context9.p = 3;
          _context9.n = 4;
          return this.oKeyring.privateKeys.importKey(armorData[1]);
        case 4:
          importedToLocalstorageCount++;
          _context9.n = 6;
          break;
        case 5:
          _context9.p = 5;
          _t5 = _context9.v;
          importResult.addExceptionMessage(_t5, Enums.OpenPgpErrors.ImportKeyError, 'private');
        case 6:
          _context9.n = 14;
          break;
        case 7:
          if (!('PUBLIC' === armorData[0])) {
            _context9.n = 14;
            break;
          }
          _context9.n = 8;
          return openpgp.key.readArmored(armorData[1]);
        case 8:
          publicKey = _context9.v;
          if (!(publicKey && !publicKey.err && publicKey.keys && publicKey.keys[0])) {
            _context9.n = 14;
            break;
          }
          openPgpKey = new COpenPgpKey(publicKey.keys[0]), keyEmail = openPgpKey.getEmail();
          if (!this.isOwnEmail(keyEmail)) {
            _context9.n = 13;
            break;
          }
          _context9.p = 9;
          _context9.n = 10;
          return this.oKeyring.publicKeys.importKey(armorData[1]);
        case 10:
          importedToLocalstorageCount++;
          _context9.n = 12;
          break;
        case 11:
          _context9.p = 11;
          _t6 = _context9.v;
          importResult.addExceptionMessage(_t6, Enums.OpenPgpErrors.ImportKeyError, 'public');
        case 12:
          _context9.n = 14;
          break;
        case 13:
          externalKeys.push(openPgpKey);
          importedToContactsCount++;
        case 14:
          index++;
          _context9.n = 2;
          break;
        case 15:
          if (importedToLocalstorageCount + importedToContactsCount === 0) {
            importResult.addError(Enums.OpenPgpErrors.ImportNoKeysFoundError);
          }
          if (!(importedToLocalstorageCount > 0)) {
            _context9.n = 16;
            break;
          }
          _context9.n = 16;
          return this.oKeyring.store();
        case 16:
          if (!(externalKeys.length > 0)) {
            _context9.n = 19;
            break;
          }
          _context9.n = 17;
          return importExternalKeys(externalKeys);
        case 17:
          if (!_context9.v) {
            _context9.n = 18;
            break;
          }
          this.reloadKeysFromStorage();
        case 18:
          _context9.n = 20;
          break;
        case 19:
          this.reloadKeysFromStorage();
        case 20:
          return _context9.a(2, importResult);
      }
    }, _callee8, this, [[9, 11], [3, 5]]);
  }));
  return function (_x14) {
    return _ref8.apply(this, arguments);
  };
}();

/**
 * @param {string} sArmor
 * @return {Array|boolean}
 */
COpenPgp.prototype.getArmorInfo = /*#__PURE__*/function () {
  var _ref9 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee9(sArmor) {
    var iIndex, iCount, oKey, aResult, aData, aKeys, _t7, _t8;
    return _regenerator().w(function (_context0) {
      while (1) switch (_context0.p = _context0.n) {
        case 0:
          sArmor = $.trim(sArmor);
          iIndex = 0, iCount = 0, oKey = null, aResult = [], aData = null, aKeys = [];
          if (sArmor) {
            _context0.n = 1;
            break;
          }
          return _context0.a(2, false);
        case 1:
          aKeys = this.splitKeys(sArmor);
          iIndex = 0;
        case 2:
          if (!(iIndex < aKeys.length)) {
            _context0.n = 12;
            break;
          }
          aData = aKeys[iIndex];
          if (!('PRIVATE' === aData[0])) {
            _context0.n = 7;
            break;
          }
          _context0.p = 3;
          _context0.n = 4;
          return openpgp.key.readArmored(aData[1]);
        case 4:
          oKey = _context0.v;
          if (oKey && !oKey.err && oKey.keys && oKey.keys[0]) {
            aResult.push(new COpenPgpKey(oKey.keys[0]));
          }
          iCount++;
          _context0.n = 6;
          break;
        case 5:
          _context0.p = 5;
          _t7 = _context0.v;
        case 6:
          _context0.n = 11;
          break;
        case 7:
          if (!('PUBLIC' === aData[0])) {
            _context0.n = 11;
            break;
          }
          _context0.p = 8;
          _context0.n = 9;
          return openpgp.key.readArmored(aData[1]);
        case 9:
          oKey = _context0.v;
          if (oKey && !oKey.err && oKey.keys && oKey.keys[0]) {
            aResult.push(new COpenPgpKey(oKey.keys[0]));
          }
          iCount++;
          _context0.n = 11;
          break;
        case 10:
          _context0.p = 10;
          _t8 = _context0.v;
        case 11:
          iIndex++;
          _context0.n = 2;
          break;
        case 12:
          return _context0.a(2, aResult);
      }
    }, _callee9, this, [[8, 10], [3, 5]]);
  }));
  return function (_x15) {
    return _ref9.apply(this, arguments);
  };
}();

/**
 * @param {string} sID
 * @param {boolean} bPublic
 * @return {COpenPgpKey|null}
 */
COpenPgp.prototype.findKeyByID = function (sID, bPublic) {
  bPublic = !!bPublic;
  sID = sID.toLowerCase();
  var oKey = _.find(this.keys(), function (oKey) {
    return bPublic === oKey.isPublic() && oKey.hasId(sID);
  });
  return oKey ? oKey : null;
};

/**
 * @param {array} emails
 * @param {boolean} isPublicKey
 * @param {COpenPgpResult=} findKeysResult
 * @return {array}
 */
COpenPgp.prototype.findKeysByEmails = function (emails) {
  var isPublicKey = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  var findKeysResult = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  var openPgpKeys = this.keys().filter(function (key) {
    return key && isPublicKey === key.isPublic() && emails.includes(key.getEmail());
  });
  if (findKeysResult) {
    var emailsFromKeys = openPgpKeys.map(function (key) {
        return key.getEmail();
      }),
      diffEmails = emails.filter(function (email) {
        return !emailsFromKeys.includes(email);
      });
    diffEmails.forEach(function (email) {
      var errorCode = isPublicKey ? Enums.OpenPgpErrors.PublicKeyNotFoundError : Enums.OpenPgpErrors.PrivateKeyNotFoundError;
      findKeysResult.addError(errorCode, email);
    });
  }
  return openPgpKeys;
};

/**
 * @param {string} email
 * @returns {array}
 */
COpenPgp.prototype.getPublicKeysIfExistsByEmail = function (email) {
  var publicKeys = this.findKeysByEmails([email], true);
  return publicKeys.length > 1 ? [publicKeys[0]] : publicKeys;
};

/**
 * @param {object} oKey
 * @param {string} sPrivateKeyPassword
 * @returns {object}
 */
COpenPgp.prototype.verifyKeyPassword = /*#__PURE__*/function () {
  var _ref0 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee0(oKey, sPrivateKeyPassword) {
    var oResult, oPrivateKey, oPrivateKeyClone;
    return _regenerator().w(function (_context1) {
      while (1) switch (_context1.n) {
        case 0:
          oResult = new COpenPgpResult();
          oPrivateKey = this.convertToNativeKeys([oKey])[0];
          _context1.n = 1;
          return this.cloneKey(oPrivateKey);
        case 1:
          oPrivateKeyClone = _context1.v;
          _context1.n = 2;
          return this.decryptKeyHelper(oResult, oPrivateKeyClone, sPrivateKeyPassword, '');
        case 2:
          if (!oResult.hasErrors() && !oKey.getPassphrase() && Settings.rememberPassphrase()) {
            oKey.setPassphrase(sPrivateKeyPassword);
          }
          return _context1.a(2, oResult);
      }
    }, _callee0, this);
  }));
  return function (_x16, _x17) {
    return _ref0.apply(this, arguments);
  };
}();

/**
 * @param {string} sData
 * @param {object} oEncryptionKey
 * @param {string} sFromEmail
 * @param {string} sPrivateKeyPassword = ''
 * @param {Function} fOkHandler
 * @param {Function} fErrorHandler
 * @return {string}
 */
COpenPgp.prototype.decryptAndVerify = /*#__PURE__*/function () {
  var _ref1 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee1(sData, oEncryptionKey, sFromEmail, sPrivateKeyPassword, fOkHandler, fErrorHandler) {
    var oResult, aPublicKeys, oDecryptionResult, _t9;
    return _regenerator().w(function (_context10) {
      while (1) switch (_context10.p = _context10.n) {
        case 0:
          oResult = new COpenPgpResult(), aPublicKeys = this.getPublicKeysIfExistsByEmail(sFromEmail);
          _context10.p = 1;
          _context10.n = 2;
          return this.decryptData(sData, sPrivateKeyPassword, false,
          //bPasswordBasedEncryption
          [oEncryptionKey], aPublicKeys);
        case 2:
          oDecryptionResult = _context10.v;
          if (oDecryptionResult.result && _.isFunction(fOkHandler)) {
            fOkHandler(oDecryptionResult);
          } else if (_.isFunction(fErrorHandler)) {
            fErrorHandler(oDecryptionResult);
          }
          _context10.n = 4;
          break;
        case 3:
          _context10.p = 3;
          _t9 = _context10.v;
          oResult.addExceptionMessage(_t9, Enums.OpenPgpErrors.VerifyAndDecryptError);
          if (_.isFunction(fErrorHandler)) {
            fErrorHandler(oResult);
          }
        case 4:
          return _context10.a(2);
      }
    }, _callee1, this, [[1, 3]]);
  }));
  return function (_x18, _x19, _x20, _x21, _x22, _x23) {
    return _ref1.apply(this, arguments);
  };
}();

/**
 * @param {string} sData
 * @param {string} sFromEmail
 * @param {Function} fOkHandler
 * @param {Function} fErrorHandler
 * @return {string}
 */
COpenPgp.prototype.verify = /*#__PURE__*/function () {
  var _ref10 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee11(sData, sFromEmail, fOkHandler, fErrorHandler) {
    var oMessage, oResult, aPublicKeys, oOptions;
    return _regenerator().w(function (_context13) {
      while (1) switch (_context13.n) {
        case 0:
          _context13.n = 1;
          return openpgp.cleartext.readArmored(sData);
        case 1:
          oMessage = _context13.v;
          oResult = new COpenPgpResult();
          aPublicKeys = this.findKeysByEmails([sFromEmail], true, oResult);
          oOptions = {
            message: oMessage,
            publicKeys: this.convertToNativeKeys(aPublicKeys) // for verification
          };
          openpgp.verify(oOptions).then(_.bind(/*#__PURE__*/function () {
            var _ref11 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee10(oPgpResult) {
              var aValidityPromises, aValidSignatures, _iterator2, _step2, _loop2, _t0;
              return _regenerator().w(function (_context12) {
                while (1) switch (_context12.p = _context12.n) {
                  case 0:
                    aValidityPromises = [];
                    aValidSignatures = [];
                    _iterator2 = _createForOfIteratorHelper(oPgpResult.signatures);
                    _context12.p = 1;
                    _loop2 = /*#__PURE__*/_regenerator().m(function _loop2() {
                      var oSignature;
                      return _regenerator().w(function (_context11) {
                        while (1) switch (_context11.n) {
                          case 0:
                            oSignature = _step2.value;
                            aValidityPromises.push(oSignature.verified.then(function (validity) {
                              return oSignature && validity === true ? oSignature : null;
                            }));
                          case 1:
                            return _context11.a(2);
                        }
                      }, _loop2);
                    });
                    _iterator2.s();
                  case 2:
                    if ((_step2 = _iterator2.n()).done) {
                      _context12.n = 4;
                      break;
                    }
                    return _context12.d(_regeneratorValues(_loop2()), 3);
                  case 3:
                    _context12.n = 2;
                    break;
                  case 4:
                    _context12.n = 6;
                    break;
                  case 5:
                    _context12.p = 5;
                    _t0 = _context12.v;
                    _iterator2.e(_t0);
                  case 6:
                    _context12.p = 6;
                    _iterator2.f();
                    return _context12.f(6);
                  case 7:
                    _context12.n = 8;
                    return Promise.all(aValidityPromises).then(function (aSignatures) {
                      aValidSignatures = _.filter(aSignatures, function (oSignature) {
                        return oSignature !== null;
                      });
                    });
                  case 8:
                    if (!aValidSignatures.length) {
                      _context12.n = 10;
                      break;
                    }
                    _context12.n = 9;
                    return this.verifyMessageHelper(oResult, sFromEmail, oMessage);
                  case 9:
                    oResult.result = oMessage.getText();
                    if (oResult.notices && _.isFunction(fErrorHandler)) {
                      fErrorHandler(oResult);
                    } else if (_.isFunction(fOkHandler)) {
                      fOkHandler(oResult);
                    }
                    _context12.n = 11;
                    break;
                  case 10:
                    oResult.addError(Enums.OpenPgpErrors.CanNotReadMessage);
                    if (_.isFunction(fErrorHandler)) {
                      fErrorHandler(oResult);
                    }
                  case 11:
                    return _context12.a(2);
                }
              }, _callee10, this, [[1, 5, 6, 7]]);
            }));
            return function (_x28) {
              return _ref11.apply(this, arguments);
            };
          }(), this), function (e) {
            oResult.addExceptionMessage(e, Enums.OpenPgpErrors.CanNotReadMessage);
            if (_.isFunction(fErrorHandler)) {
              fErrorHandler(oResult);
            }
          });
        case 2:
          return _context13.a(2);
      }
    }, _callee11, this);
  }));
  return function (_x24, _x25, _x26, _x27) {
    return _ref10.apply(this, arguments);
  };
}();
COpenPgp.prototype.getPublicKeysByContactsAndEmails = /*#__PURE__*/function () {
  var _ref12 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee13(contactUUIDs, emails) {
    var _this3 = this;
    return _regenerator().w(function (_context15) {
      while (1) switch (_context15.n) {
        case 0:
          return _context15.a(2, new Promise(function (resolve, reject) {
            var parameters = {
                ContactUUIDs: contactUUIDs
              },
              responseHandler = /*#__PURE__*/function () {
                var _ref13 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee12(response) {
                  var publicKeysArmorsFromContacts, publicKeysFromContacts, publicKeysFromContactsEmails, notFoundPrincipalsEmails, publicKeysFromLocalStorage, allPublicKeys;
                  return _regenerator().w(function (_context14) {
                    while (1) switch (_context14.n) {
                      case 0:
                        publicKeysArmorsFromContacts = Array.isArray(response.Result) ? response.Result : [];
                        _context14.n = 1;
                        return getKeysFromArmors(publicKeysArmorsFromContacts);
                      case 1:
                        publicKeysFromContacts = _context14.v;
                        publicKeysFromContactsEmails = publicKeysFromContacts.map(function (publicKey) {
                          return publicKey.emailParts.email;
                        });
                        notFoundPrincipalsEmails = emails.filter(function (email) {
                          return !publicKeysFromContactsEmails.includes(email);
                        });
                        publicKeysFromLocalStorage = _this3.findKeysByEmails(notFoundPrincipalsEmails);
                        allPublicKeys = publicKeysFromContacts.concat(publicKeysFromLocalStorage);
                        resolve(allPublicKeys);
                      case 2:
                        return _context14.a(2);
                    }
                  }, _callee12);
                }));
                return function responseHandler(_x31) {
                  return _ref13.apply(this, arguments);
                };
              }();
            Ajax.send('OpenPgpWebclient', 'GetPublicKeysByCountactUUIDs', parameters, responseHandler);
          }));
      }
    }, _callee13);
  }));
  return function (_x29, _x30) {
    return _ref12.apply(this, arguments);
  };
}();

/**
 * @param {string} dataToEncrypt
 * @param {array} principalsEmails
 * @param {function} successCallback
 * @param {function} errorCallback
 * @param {array} contactsUUIDs
 * @return {string}
 */
COpenPgp.prototype.encrypt = /*#__PURE__*/function () {
  var _ref14 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee14(dataToEncrypt, principalsEmails, successCallback, errorCallback) {
    var contactsUUIDs,
      findKeysResult,
      allPublicKeys,
      oEncryptionResult,
      _oEncryptionResult$re,
      data,
      password,
      _args16 = arguments,
      _t1;
    return _regenerator().w(function (_context16) {
      while (1) switch (_context16.p = _context16.n) {
        case 0:
          contactsUUIDs = _args16.length > 4 && _args16[4] !== undefined ? _args16[4] : [];
          findKeysResult = new COpenPgpResult();
          _context16.n = 1;
          return this.getPublicKeysByContactsAndEmails(contactsUUIDs, principalsEmails);
        case 1:
          allPublicKeys = _context16.v;
          if (!findKeysResult.hasErrors()) {
            _context16.n = 2;
            break;
          }
          if (_.isFunction(errorCallback)) {
            errorCallback(findKeysResult);
          }
          return _context16.a(2);
        case 2:
          _context16.p = 2;
          _context16.n = 3;
          return this.encryptData(dataToEncrypt, allPublicKeys);
        case 3:
          oEncryptionResult = _context16.v;
          if (oEncryptionResult.result) {
            _oEncryptionResult$re = oEncryptionResult.result, data = _oEncryptionResult$re.data, password = _oEncryptionResult$re.password;
            oEncryptionResult.result = data;
            if (_.isFunction(successCallback)) {
              successCallback(oEncryptionResult);
            }
          } else if (_.isFunction(errorCallback)) {
            errorCallback(oEncryptionResult);
          }
          _context16.n = 5;
          break;
        case 4:
          _context16.p = 4;
          _t1 = _context16.v;
          findKeysResult.addExceptionMessage(_t1, Enums.OpenPgpErrors.EncryptError);
          if (_.isFunction(errorCallback)) {
            errorCallback(findKeysResult);
          }
        case 5:
          return _context16.a(2);
      }
    }, _callee14, this, [[2, 4]]);
  }));
  return function (_x32, _x33, _x34, _x35) {
    return _ref14.apply(this, arguments);
  };
}();

/**
 * @param {string} dataToSign
 * @param {string} fromEmail
 * @param {function} successCallback
 * @param {function} errorCallback
 * @param {string} passphrase
 * @return {string}
 */
COpenPgp.prototype.sign = /*#__PURE__*/function () {
  var _ref15 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee15(dataToSign, fromEmail, successCallback, errorCallback) {
    var passphrase,
      findKeysResult,
      aPrivateKeys,
      privateKey,
      privateKeyClone,
      oOptions,
      _args17 = arguments;
    return _regenerator().w(function (_context17) {
      while (1) switch (_context17.n) {
        case 0:
          passphrase = _args17.length > 4 && _args17[4] !== undefined ? _args17[4] : '';
          findKeysResult = new COpenPgpResult(), aPrivateKeys = this.findKeysByEmails([fromEmail], false, findKeysResult);
          if (!findKeysResult.hasErrors()) {
            _context17.n = 1;
            break;
          }
          if (_.isFunction(errorCallback)) {
            errorCallback(findKeysResult);
          }
          return _context17.a(2);
        case 1:
          privateKey = this.convertToNativeKeys(aPrivateKeys)[0];
          _context17.n = 2;
          return this.cloneKey(privateKey);
        case 2:
          privateKeyClone = _context17.v;
          if (!(passphrase === '')) {
            _context17.n = 5;
            break;
          }
          _context17.n = 3;
          return this.askForKeyPassword(aPrivateKeys[0].getUser());
        case 3:
          passphrase = _context17.v;
          if (!(passphrase === false)) {
            _context17.n = 4;
            break;
          }
          // returning userCanceled status so that error message won't be shown
          findKeysResult.userCanceled = true;
          return _context17.a(2, findKeysResult);
        case 4:
          // returning passphrase so that it won't be asked again until current action popup is closed
          findKeysResult.passphrase = passphrase;
        case 5:
          _context17.n = 6;
          return this.decryptKeyHelper(findKeysResult, privateKeyClone, passphrase, fromEmail);
        case 6:
          if (privateKeyClone && !findKeysResult.hasErrors()) {
            oOptions = {
              message: openpgp.cleartext.fromText(dataToSign),
              privateKeys: privateKeyClone
            };
            openpgp.sign(oOptions).then(function (signResult) {
              findKeysResult.result = signResult.data;
              if (_.isFunction(successCallback)) {
                successCallback(findKeysResult);
              }
            }, function (error) {
              findKeysResult.addExceptionMessage(error, Enums.OpenPgpErrors.SignError, fromEmail);
              if (_.isFunction(errorCallback)) {
                errorCallback(findKeysResult);
              }
            });
          } else if (_.isFunction(errorCallback)) {
            errorCallback(findKeysResult);
          }
        case 7:
          return _context17.a(2);
      }
    }, _callee15, this);
  }));
  return function (_x36, _x37, _x38, _x39) {
    return _ref15.apply(this, arguments);
  };
}();

/**
 * @param {string} dataToEncrypt
 * @param {string} fromEmail
 * @param {Array} principalsEmails
 * @param {string} passphrase
 * @param {Function} successCallback
 * @param {Function} errorHandler
 * @param {Array} contactsUUIDs
 * @return {string}
 */
COpenPgp.prototype.signAndEncrypt = /*#__PURE__*/function () {
  var _ref16 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee16(dataToEncrypt, fromEmail, principalsEmails, passphrase, successCallback, errorHandler) {
    var contactsUUIDs,
      findKeysResult,
      privateKeys,
      allPublicKeys,
      isPasswordBasedEncryption,
      needToSign,
      encryptionResult,
      _encryptionResult$res,
      data,
      password,
      _args18 = arguments,
      _t10;
    return _regenerator().w(function (_context18) {
      while (1) switch (_context18.p = _context18.n) {
        case 0:
          contactsUUIDs = _args18.length > 6 && _args18[6] !== undefined ? _args18[6] : [];
          findKeysResult = new COpenPgpResult();
          privateKeys = this.findKeysByEmails([fromEmail], false, findKeysResult);
          _context18.n = 1;
          return this.getPublicKeysByContactsAndEmails(contactsUUIDs, principalsEmails);
        case 1:
          allPublicKeys = _context18.v;
          if (!findKeysResult.hasErrors()) {
            _context18.n = 2;
            break;
          }
          if (_.isFunction(errorHandler)) {
            errorHandler(findKeysResult);
          }
          return _context18.a(2);
        case 2:
          _context18.p = 2;
          isPasswordBasedEncryption = false;
          needToSign = true;
          _context18.n = 3;
          return this.encryptData(dataToEncrypt, allPublicKeys, privateKeys, isPasswordBasedEncryption, needToSign, passphrase);
        case 3:
          encryptionResult = _context18.v;
          if (encryptionResult.result) {
            _encryptionResult$res = encryptionResult.result, data = _encryptionResult$res.data, password = _encryptionResult$res.password;
            if (_.isFunction(successCallback)) {
              successCallback({
                result: data
              });
            }
          } else if (_.isFunction(errorHandler)) {
            errorHandler(encryptionResult);
          }
          _context18.n = 5;
          break;
        case 4:
          _context18.p = 4;
          _t10 = _context18.v;
          findKeysResult.addExceptionMessage(_t10, Enums.OpenPgpErrors.SignAndEncryptError);
          if (_.isFunction(errorHandler)) {
            errorHandler(findKeysResult);
          }
        case 5:
          return _context18.a(2);
      }
    }, _callee16, this, [[2, 4]]);
  }));
  return function (_x40, _x41, _x42, _x43, _x44, _x45) {
    return _ref16.apply(this, arguments);
  };
}();

/**
 * @param {blob|string} Data
 * @param {array} aPublicKeys
 * @param {array} aPrivateKeys
 * @param {string} sPrincipalsEmail
 * @param {boolean} bPasswordBasedEncryption
 * @param {boolean} bSign
 * @param {string} sPassphrase
 * @return {COpenPgpResult}
 */
COpenPgp.prototype.encryptData = /*#__PURE__*/function () {
  var _ref17 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee17(Data) {
    var aPublicKeys,
      aPrivateKeys,
      bPasswordBasedEncryption,
      bSign,
      sPassphrase,
      oResult,
      sPassword,
      bIsBlob,
      buffer,
      oOptions,
      oPrivateKey,
      oPrivateKeyClone,
      sStoredPassphrase,
      oPgpResult,
      _args19 = arguments,
      _t11;
    return _regenerator().w(function (_context19) {
      while (1) switch (_context19.p = _context19.n) {
        case 0:
          aPublicKeys = _args19.length > 1 && _args19[1] !== undefined ? _args19[1] : [];
          aPrivateKeys = _args19.length > 2 && _args19[2] !== undefined ? _args19[2] : [];
          bPasswordBasedEncryption = _args19.length > 3 && _args19[3] !== undefined ? _args19[3] : false;
          bSign = _args19.length > 4 && _args19[4] !== undefined ? _args19[4] : false;
          sPassphrase = _args19.length > 5 && _args19[5] !== undefined ? _args19[5] : '';
          oResult = new COpenPgpResult(), sPassword = '', bIsBlob = Data instanceof Blob, buffer = null, oOptions = {};
          oResult.result = false;
          if (!bIsBlob) {
            _context19.n = 2;
            break;
          }
          _context19.n = 1;
          return new Response(Data).arrayBuffer();
        case 1:
          buffer = _context19.v;
          oOptions.message = openpgp.message.fromBinary(new Uint8Array(buffer));
          oOptions.armor = false;
          Data = null;
          buffer = null;
          _context19.n = 3;
          break;
        case 2:
          oOptions.message = openpgp.message.fromText(Data);
        case 3:
          if (bPasswordBasedEncryption) {
            sPassword = this.generatePassword();
            oOptions.passwords = [sPassword];
          } else if (Types.isNonEmptyArray(aPublicKeys)) {
            oOptions.publicKeys = this.convertToNativeKeys(aPublicKeys);
          }
          if (!(bSign && aPrivateKeys && aPrivateKeys.length > 0)) {
            _context19.n = 9;
            break;
          }
          oPrivateKey = this.convertToNativeKeys(aPrivateKeys)[0];
          _context19.n = 4;
          return this.cloneKey(oPrivateKey);
        case 4:
          oPrivateKeyClone = _context19.v;
          sStoredPassphrase = aPrivateKeys[0].getPassphrase();
          if (sStoredPassphrase && !sPassphrase) {
            sPassphrase = sStoredPassphrase;
          }
          if (sPassphrase) {
            _context19.n = 7;
            break;
          }
          _context19.n = 5;
          return this.askForKeyPassword(aPrivateKeys[0].getUser());
        case 5:
          sPassphrase = _context19.v;
          if (!(sPassphrase === false)) {
            _context19.n = 6;
            break;
          }
          // returning userCanceled status so that error message won't be shown
          oResult.userCanceled = true;
          return _context19.a(2, oResult);
        case 6:
          // returning passphrase so that it won't be asked again until current action popup is closed
          oResult.passphrase = sPassphrase;
        case 7:
          _context19.n = 8;
          return this.decryptKeyHelper(oResult, oPrivateKeyClone, sPassphrase, aPrivateKeys[0].getEmail());
        case 8:
          if (!oResult.hasErrors() && !sStoredPassphrase && Settings.rememberPassphrase()) {
            aPrivateKeys[0].setPassphrase(sPassphrase);
          }
          oOptions.privateKeys = [oPrivateKeyClone];
        case 9:
          if (oResult.hasErrors()) {
            _context19.n = 13;
            break;
          }
          _context19.p = 10;
          _context19.n = 11;
          return openpgp.encrypt(oOptions);
        case 11:
          oPgpResult = _context19.v;
          oResult.result = {
            data: bIsBlob ? oPgpResult.message.packets.write() : oPgpResult.data,
            passphrase: sPassphrase,
            password: sPassword
          };
          _context19.n = 13;
          break;
        case 12:
          _context19.p = 12;
          _t11 = _context19.v;
          oResult.addExceptionMessage(_t11, Enums.OpenPgpErrors.EncryptError);
        case 13:
          return _context19.a(2, oResult);
      }
    }, _callee17, this, [[10, 12]]);
  }));
  return function (_x46) {
    return _ref17.apply(this, arguments);
  };
}();

/**
 * @param {blob|string} Data
 * @param {string} sPassword
 * @param {boolean} bPasswordBasedEncryption
 * @param {array} aPublicKeys
 * @return {string}
 */
COpenPgp.prototype.decryptData = /*#__PURE__*/function () {
  var _ref18 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee18(Data) {
    var _this4 = this;
    var sPassword,
      bPasswordBasedEncryption,
      aPrivateKeys,
      aPublicKeys,
      oResult,
      bIsBlob,
      buffer,
      sEmail,
      oOptions,
      aKeyIds,
      oPrivateKey,
      oPrivateKeyClone,
      sStoredPassphrase,
      sPassphrase,
      oPgpResult,
      aValidityPromises,
      _iterator3,
      _step3,
      _loop3,
      _args21 = arguments,
      _t12,
      _t13;
    return _regenerator().w(function (_context21) {
      while (1) switch (_context21.p = _context21.n) {
        case 0:
          sPassword = _args21.length > 1 && _args21[1] !== undefined ? _args21[1] : '';
          bPasswordBasedEncryption = _args21.length > 2 && _args21[2] !== undefined ? _args21[2] : false;
          aPrivateKeys = _args21.length > 3 && _args21[3] !== undefined ? _args21[3] : [];
          aPublicKeys = _args21.length > 4 && _args21[4] !== undefined ? _args21[4] : [];
          oResult = new COpenPgpResult(), bIsBlob = Data instanceof Blob, buffer = null, sEmail = ''; //if public keys are not defined - use all public keys for verification
          aPublicKeys = Types.isNonEmptyArray(aPublicKeys) ? aPublicKeys : this.getPublicKeys();
          oOptions = {
            publicKeys: this.convertToNativeKeys(aPublicKeys) // for verification
          };
          if (!bIsBlob) {
            _context21.n = 3;
            break;
          }
          _context21.n = 1;
          return new Response(Data).arrayBuffer();
        case 1:
          buffer = _context21.v;
          _context21.n = 2;
          return openpgp.message.read(new Uint8Array(buffer));
        case 2:
          oOptions.message = _context21.v;
          oOptions.format = 'binary';
          _context21.n = 5;
          break;
        case 3:
          _context21.n = 4;
          return openpgp.message.readArmored(Data);
        case 4:
          oOptions.message = _context21.v;
        case 5:
          if (!Types.isNonEmptyArray(aPrivateKeys)) {
            aKeyIds = oOptions.message.getEncryptionKeyIds().map(function (oKeyId) {
              return oKeyId.toHex();
            });
            aPrivateKeys = aKeyIds.map(function (sKeyId) {
              return _this4.findKeyByID(sKeyId, /*bPublic*/false);
            }).filter(function (oKey) {
              return oKey !== null;
            });
          }
          oResult.result = false;
          if (!bPasswordBasedEncryption) {
            _context21.n = 6;
            break;
          }
          oOptions.passwords = [sPassword];
          _context21.n = 13;
          break;
        case 6:
          if (!(aPrivateKeys && aPrivateKeys.length > 0)) {
            _context21.n = 12;
            break;
          }
          oPrivateKey = this.convertToNativeKeys(aPrivateKeys)[0];
          _context21.n = 7;
          return this.cloneKey(oPrivateKey);
        case 7:
          oPrivateKeyClone = _context21.v;
          sStoredPassphrase = aPrivateKeys[0].getPassphrase();
          sPassphrase = sPassword;
          if (sStoredPassphrase && !sPassphrase) {
            sPassphrase = sStoredPassphrase;
          }
          if (sPassphrase) {
            _context21.n = 10;
            break;
          }
          _context21.n = 8;
          return this.askForKeyPassword(aPrivateKeys[0].getUser());
        case 8:
          sPassphrase = _context21.v;
          if (!(sPassphrase === false)) {
            _context21.n = 9;
            break;
          }
          // returning userCanceled status so that error message won't be shown
          oResult.userCanceled = true;
          return _context21.a(2, oResult);
        case 9:
          // returning passphrase so that it won't be asked again until current action popup is closed
          oResult.passphrase = sPassphrase;
        case 10:
          sEmail = aPrivateKeys[0].getEmail();
          _context21.n = 11;
          return this.decryptKeyHelper(oResult, oPrivateKeyClone, sPassphrase, sEmail);
        case 11:
          if (!oResult.hasErrors() && !sStoredPassphrase && Settings.rememberPassphrase()) {
            aPrivateKeys[0].setPassphrase(sPassphrase);
          }
          oOptions.privateKeys = oPrivateKeyClone;
          _context21.n = 13;
          break;
        case 12:
          oResult.addError(Enums.OpenPgpErrors.PrivateKeyNotFoundError);
          return _context21.a(2, oResult);
        case 13:
          if (oResult.hasErrors()) {
            _context21.n = 26;
            break;
          }
          _context21.p = 14;
          _context21.n = 15;
          return openpgp.decrypt(oOptions);
        case 15:
          oPgpResult = _context21.v;
          _context21.n = 16;
          return openpgp.stream.readToEnd(oPgpResult.data);
        case 16:
          oResult.result = _context21.v;
          //if result contains invalid signatures
          aValidityPromises = [];
          _iterator3 = _createForOfIteratorHelper(oPgpResult.signatures);
          _context21.p = 17;
          _loop3 = /*#__PURE__*/_regenerator().m(function _loop3() {
            var oSignature;
            return _regenerator().w(function (_context20) {
              while (1) switch (_context20.n) {
                case 0:
                  oSignature = _step3.value;
                  aValidityPromises.push(oSignature.verified.then(function (validity) {
                    oSignature.is_valid = validity;
                    return oSignature;
                  }));
                case 1:
                  return _context20.a(2);
              }
            }, _loop3);
          });
          _iterator3.s();
        case 18:
          if ((_step3 = _iterator3.n()).done) {
            _context21.n = 20;
            break;
          }
          return _context21.d(_regeneratorValues(_loop3()), 19);
        case 19:
          _context21.n = 18;
          break;
        case 20:
          _context21.n = 22;
          break;
        case 21:
          _context21.p = 21;
          _t12 = _context21.v;
          _iterator3.e(_t12);
        case 22:
          _context21.p = 22;
          _iterator3.f();
          return _context21.f(22);
        case 23:
          _context21.n = 24;
          return Promise.all(aValidityPromises).then(function (aSignatures) {
            var aInvalidSignatures = _.filter(aSignatures, function (oSignature) {
              return oSignature !== null && oSignature.is_valid !== true;
            });
            var aValidSignatures = _.filter(aSignatures, function (oSignature) {
              return oSignature !== null && oSignature.is_valid === true;
            });
            if (oPgpResult.signatures.length && aInvalidSignatures.length > 0) {
              oResult.addNotice(Enums.OpenPgpErrors.VerifyErrorNotice, sEmail);
            } else if (aValidSignatures.length > 0) {
              var aKeyNames = _.map(aValidSignatures, function (oSignature) {
                var sKeyID = oSignature.keyid.toHex();
                var oKey = _this4.findKeyByID(sKeyID, true);
                return oKey.getUser();
              });
              oResult.validKeyNames = aKeyNames;
            }
          });
        case 24:
          _context21.n = 26;
          break;
        case 25:
          _context21.p = 25;
          _t13 = _context21.v;
          oResult.addExceptionMessage(_t13, Enums.OpenPgpErrors.VerifyAndDecryptError);
        case 26:
          return _context21.a(2, oResult);
      }
    }, _callee18, this, [[17, 21, 22, 23], [14, 25]]);
  }));
  return function (_x47) {
    return _ref18.apply(this, arguments);
  };
}();
COpenPgp.prototype.getPrivateKeyPassword = /*#__PURE__*/function () {
  var _ref19 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee19(sEmail) {
    var oResult, aPrivateKeys, oPrivateKey, oPrivateKeyClone, sStoredPassphrase, sPassphrase;
    return _regenerator().w(function (_context22) {
      while (1) switch (_context22.n) {
        case 0:
          oResult = new COpenPgpResult(), aPrivateKeys = this.findKeysByEmails([sEmail], false, oResult);
          if (!Types.isNonEmptyArray(aPrivateKeys)) {
            _context22.n = 5;
            break;
          }
          oPrivateKey = this.convertToNativeKeys(aPrivateKeys)[0];
          _context22.n = 1;
          return this.cloneKey(oPrivateKey);
        case 1:
          oPrivateKeyClone = _context22.v;
          sStoredPassphrase = aPrivateKeys[0].getPassphrase();
          sPassphrase = null;
          if (sStoredPassphrase) {
            sPassphrase = sStoredPassphrase;
          }
          if (sPassphrase) {
            _context22.n = 3;
            break;
          }
          _context22.n = 2;
          return this.askForKeyPassword(aPrivateKeys[0].getUser());
        case 2:
          sPassphrase = _context22.v;
          if (!(sPassphrase === false)) {
            _context22.n = 3;
            break;
          }
          return _context22.a(2, null);
        case 3:
          _context22.n = 4;
          return this.decryptKeyHelper(oResult, oPrivateKeyClone, sPassphrase, sEmail);
        case 4:
          if (!oResult.hasErrors() && !sStoredPassphrase && Settings.rememberPassphrase()) {
            aPrivateKeys[0].setPassphrase(sPassphrase);
          }
          if (oResult.hasErrors()) {
            _context22.n = 5;
            break;
          }
          return _context22.a(2, sPassphrase);
        case 5:
          return _context22.a(2, null);
      }
    }, _callee19, this);
  }));
  return function (_x48) {
    return _ref19.apply(this, arguments);
  };
}();
COpenPgp.prototype.askForKeyPassword = /*#__PURE__*/function () {
  var _ref20 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee20(sKeyName) {
    var oPromiseKeyPassword, sPassword;
    return _regenerator().w(function (_context23) {
      while (1) switch (_context23.n) {
        case 0:
          oPromiseKeyPassword = new Promise(function (resolve, reject) {
            var fOnPasswordEnterCallback = function fOnPasswordEnterCallback(sKeyPassword) {
              resolve(sKeyPassword);
            };
            var fOnCancellCallback = function fOnCancellCallback() {
              resolve(false);
            };
            //showing popup
            Popups.showPopup(PGPKeyPasswordPopup, [sKeyName, fOnPasswordEnterCallback, fOnCancellCallback]);
          });
          _context23.n = 1;
          return oPromiseKeyPassword;
        case 1:
          sPassword = _context23.v;
          return _context23.a(2, sPassword);
      }
    }, _callee20);
  }));
  return function (_x49) {
    return _ref20.apply(this, arguments);
  };
}();

/**
 * @param {COpenPgpKey} openPgpKey
 */
COpenPgp.prototype.removeKeyFromContacts = /*#__PURE__*/function () {
  var _ref21 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee21(openPgpKey) {
    var _this5 = this;
    var result, parameters, responseHandler;
    return _regenerator().w(function (_context24) {
      while (1) switch (_context24.n) {
        case 0:
          result = new COpenPgpResult();
          if (openPgpKey) {
            _context24.n = 1;
            break;
          }
          return _context24.a(2, result.addError(Enums.OpenPgpErrors.InvalidArgumentError));
        case 1:
          if (!(isTeamContactsAvailable && openPgpKey.emailParts.email === App.getUserPublicId() && !openPgpKey.isPrivate())) {
            _context24.n = 4;
            break;
          }
          _context24.n = 2;
          return updateOwnContactPublicKey('');
        case 2:
          if (_context24.v) {
            _context24.n = 3;
            break;
          }
          result.addError(Enums.OpenPgpErrors.DeleteError);
        case 3:
          this.reloadKeysFromStorage();
          _context24.n = 5;
          break;
        case 4:
          parameters = {
            'Email': openPgpKey.getEmail()
          }, responseHandler = function responseHandler(response) {
            if (!response || !response.Result) {
              result.addError(Enums.OpenPgpErrors.DeleteError);
            }
            _this5.reloadKeysFromStorage();
          };
          Ajax.send('OpenPgpWebclient', 'RemovePublicKeyFromContact', parameters, responseHandler);
        case 5:
          return _context24.a(2, result);
      }
    }, _callee21, this);
  }));
  return function (_x50) {
    return _ref21.apply(this, arguments);
  };
}();

/**
 * @param {COpenPgpKey} openPgpKey
 */
COpenPgp.prototype.removeKeyFromThisDevice = /*#__PURE__*/function () {
  var _ref22 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee22(openPgpKey) {
    var result, _t14;
    return _regenerator().w(function (_context25) {
      while (1) switch (_context25.p = _context25.n) {
        case 0:
          result = new COpenPgpResult();
          if (openPgpKey) {
            _context25.n = 1;
            break;
          }
          return _context25.a(2, result.addError(Enums.OpenPgpErrors.InvalidArgumentError));
        case 1:
          _context25.p = 1;
          this.oKeyring[openPgpKey.isPrivate() ? 'privateKeys' : 'publicKeys'].removeForId(openPgpKey.getFingerprint());
          _context25.n = 2;
          return this.oKeyring.store();
        case 2:
          this.reloadKeysFromStorage();
          _context25.n = 4;
          break;
        case 3:
          _context25.p = 3;
          _t14 = _context25.v;
          result.addExceptionMessage(_t14, Enums.OpenPgpErrors.DeleteError);
        case 4:
          return _context25.a(2, result);
      }
    }, _callee22, this, [[1, 3]]);
  }));
  return function (_x51) {
    return _ref22.apply(this, arguments);
  };
}();
COpenPgp.prototype.getEncryptionKeyFromArmoredMessage = /*#__PURE__*/function () {
  var _ref23 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee23(sArmoredMessage) {
    var oMessage, aEncryptionKeys, oEncryptionKey, _iterator4, _step4, key, oKey, _t15;
    return _regenerator().w(function (_context26) {
      while (1) switch (_context26.p = _context26.n) {
        case 0:
          _context26.n = 1;
          return openpgp.message.readArmored(sArmoredMessage);
        case 1:
          oMessage = _context26.v;
          aEncryptionKeys = oMessage.getEncryptionKeyIds();
          oEncryptionKey = null;
          if (!(aEncryptionKeys.length > 0)) {
            _context26.n = 8;
            break;
          }
          _iterator4 = _createForOfIteratorHelper(aEncryptionKeys);
          _context26.p = 2;
          _iterator4.s();
        case 3:
          if ((_step4 = _iterator4.n()).done) {
            _context26.n = 5;
            break;
          }
          key = _step4.value;
          oKey = this.findKeyByID(key.toHex(), false);
          if (!oKey) {
            _context26.n = 4;
            break;
          }
          oEncryptionKey = oKey;
          return _context26.a(3, 5);
        case 4:
          _context26.n = 3;
          break;
        case 5:
          _context26.n = 7;
          break;
        case 6:
          _context26.p = 6;
          _t15 = _context26.v;
          _iterator4.e(_t15);
        case 7:
          _context26.p = 7;
          _iterator4.f();
          return _context26.f(7);
        case 8:
          return _context26.a(2, oEncryptionKey);
      }
    }, _callee23, this, [[2, 6, 7, 8]]);
  }));
  return function (_x52) {
    return _ref23.apply(this, arguments);
  };
}();
COpenPgp.prototype.generatePassword = function () {
  var sPassword = "";
  if (window.crypto) {
    var password = window.crypto.getRandomValues(new Uint8Array(10));
    sPassword = btoa(String.fromCharCode.apply(null, password));
    sPassword = sPassword.replace(/[^A-Za-z0-9]/g, "");
  } else {
    var sSymbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!;%:?*()_+=";
    for (var i = 0; i < this.iPasswordLength; i++) {
      sPassword += sSymbols.charAt(Math.floor(Math.random() * sSymbols.length));
    }
  }
  return sPassword;
};
COpenPgp.prototype.getCurrentUserPrivateKey = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee24() {
  var mResult, sUserEmail, aPrivateKeys, sError;
  return _regenerator().w(function (_context27) {
    while (1) switch (_context27.n) {
      case 0:
        mResult = null;
        sUserEmail = App.getUserPublicId ? App.getUserPublicId() : '';
        aPrivateKeys = this.findKeysByEmails([sUserEmail], /*bIsPublic*/false);
        if (aPrivateKeys.length < 1) {
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_NO_PRIVATE_KEYS_FOR_USERS_PLURAL', {
            'USERS': sUserEmail
          }, null, 1);
          Screens.showError(sError);
        } else {
          mResult = aPrivateKeys[0];
        }
        return _context27.a(2, mResult);
    }
  }, _callee24, this);
}));
COpenPgp.prototype.getCurrentUserPublicKey = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee25() {
  var mResult, sUserEmail, aPrivateKeys, aNativePrivateKeys, aPublicKeys, sError;
  return _regenerator().w(function (_context28) {
    while (1) switch (_context28.n) {
      case 0:
        mResult = null;
        sUserEmail = App.getUserPublicId ? App.getUserPublicId() : '';
        aPrivateKeys = this.findKeysByEmails([sUserEmail], /*bIsPublic*/false);
        if (aPrivateKeys.length > 0) {
          aNativePrivateKeys = this.convertToNativeKeys(aPrivateKeys);
          mResult = aNativePrivateKeys[0].toPublic();
        } else {
          aPublicKeys = this.findKeysByEmails([sUserEmail], /*bIsPublic*/true);
          if (aPublicKeys.length > 0) {
            mResult = aPublicKeys[0];
          }
        }
        if (!mResult) {
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_NO_PUBLIC_KEYS_FOR_USERS_PLURAL', {
            'USERS': sUserEmail
          }, null, 1);
          Screens.showError(sError);
        }
        return _context28.a(2, mResult);
    }
  }, _callee25, this);
}));
COpenPgp.prototype.isPrivateKeyAvailable = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee26() {
  var sUserEmail, aPrivateKeys;
  return _regenerator().w(function (_context29) {
    while (1) switch (_context29.n) {
      case 0:
        _context29.n = 1;
        return this.oPromiseInitialised;
      case 1:
        sUserEmail = App.getUserPublicId ? App.getUserPublicId() : '';
        aPrivateKeys = this.findKeysByEmails([sUserEmail], /*bIsPublic*/false);
        return _context29.a(2, !!aPrivateKeys.length);
    }
  }, _callee26, this);
}));
COpenPgp.prototype.showPgpErrorByCode = function (oOpenPgpResult, sPgpAction, sDefaultError) {
  ErrorsUtils.showPgpErrorByCode(oOpenPgpResult, sPgpAction, sDefaultError);
};

/**
 * @param {string} messageToEncrypt
 * @param {string} aPrincipalsEmail
 * @param {boolean} needToSign
 * @param {string} passphrase
 * @param {string} fromEmail
 * @param {string} contactUUID
 * @return {COpenPgpResult}
 */
COpenPgp.prototype.encryptMessage = /*#__PURE__*/function () {
  var _ref27 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee27(messageToEncrypt, principalEmail, needToSign, passphrase, fromEmail) {
    var contactUUID,
      publicKeys,
      privateKeys,
      isPasswordBasedEncryption,
      encryptionResult,
      _encryptionResult$res2,
      data,
      password,
      _args30 = arguments;
    return _regenerator().w(function (_context30) {
      while (1) switch (_context30.n) {
        case 0:
          contactUUID = _args30.length > 5 && _args30[5] !== undefined ? _args30[5] : '';
          _context30.n = 1;
          return this.getPublicKeysByContactsAndEmails([contactUUID], [principalEmail]);
        case 1:
          publicKeys = _context30.v;
          privateKeys = this.findKeysByEmails([fromEmail], false);
          isPasswordBasedEncryption = false;
          _context30.n = 2;
          return this.encryptData(messageToEncrypt, publicKeys, privateKeys, isPasswordBasedEncryption, needToSign, passphrase);
        case 2:
          encryptionResult = _context30.v;
          if (encryptionResult.result) {
            _encryptionResult$res2 = encryptionResult.result, data = _encryptionResult$res2.data, password = _encryptionResult$res2.password;
            encryptionResult.result = data;
          }
          return _context30.a(2, encryptionResult);
      }
    }, _callee27, this);
  }));
  return function (_x53, _x54, _x55, _x56, _x57) {
    return _ref27.apply(this, arguments);
  };
}();
module.exports = new COpenPgp();

/***/ }),

/***/ "RIpb":
/*!*****************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/utils/Errors.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var _ = __webpack_require__(/*! underscore */ "C3HO"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  Enums = __webpack_require__(/*! modules/OpenPgpWebclient/js/Enums.js */ "vfpp"),
  ErrorsUtils = {};
/**
 * @param {Object} oRes
 * @param {string} sPgpAction
 * @param {string=} sDefaultError
 */
ErrorsUtils.showPgpErrorByCode = function (oRes, sPgpAction, sDefaultError) {
  var aErrors = _.isArray(oRes.errors) ? oRes.errors : [],
    aNotices = _.isArray(oRes.notices) ? oRes.notices : [],
    aEmailsWithoutPublicKey = [],
    aEmailsWithoutPrivateKey = [],
    sError = '',
    bNoSignDataNotice = false,
    bNotice = true;
  _.each(_.union(aErrors, aNotices), function (aError) {
    if (aError.length === 2) {
      switch (aError[0]) {
        case Enums.OpenPgpErrors.GenerateKeyError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_GENERATE_KEY');
          break;
        case Enums.OpenPgpErrors.ImportKeyError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_KEY');
          break;
        case Enums.OpenPgpErrors.ImportNoKeysFoundError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_NO_KEY_FOUND');
          break;
        case Enums.OpenPgpErrors.PrivateKeyNotFoundError:
        case Enums.OpenPgpErrors.PrivateKeyNotFoundNotice:
          aEmailsWithoutPrivateKey.push(aError[1]);
          break;
        case Enums.OpenPgpErrors.PublicKeyNotFoundError:
          bNotice = false;
          aEmailsWithoutPublicKey.push(aError[1]);
          break;
        case Enums.OpenPgpErrors.PublicKeyNotFoundNotice:
          aEmailsWithoutPublicKey.push(aError[1]);
          break;
        case Enums.OpenPgpErrors.KeyIsNotDecodedError:
          if (sPgpAction === Enums.PgpAction.DecryptVerify) {
            sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_DECRYPT') + ' ' + TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_KEY_NOT_DECODED', {
              'USER': aError[1]
            });
          } else if (sPgpAction === Enums.PgpAction.Sign || sPgpAction === Enums.PgpAction.EncryptSign) {
            sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_SIGN') + ' ' + TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_KEY_NOT_DECODED', {
              'USER': aError[1]
            });
          } else {
            sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_KEY_NOT_DECODED', {
              'USER': aError[1]
            });
          }
          break;
        case Enums.OpenPgpErrors.SignError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_SIGN');
          break;
        case Enums.OpenPgpErrors.VerifyError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_VERIFY');
          break;
        case Enums.OpenPgpErrors.EncryptError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_ENCRYPT');
          break;
        case Enums.OpenPgpErrors.DecryptError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_DECRYPT');
          break;
        case Enums.OpenPgpErrors.SignAndEncryptError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_ENCRYPT_OR_SIGN');
          break;
        case Enums.OpenPgpErrors.VerifyAndDecryptError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_DECRYPT_OR_VERIFY');
          break;
        case Enums.OpenPgpErrors.DeleteError:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_DELETE_KEY');
          break;
        case Enums.OpenPgpErrors.VerifyErrorNotice:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_VERIFY');
          break;
        case Enums.OpenPgpErrors.NoSignDataNotice:
          bNoSignDataNotice = true;
          break;
        case Enums.OpenPgpErrors.CanNotReadMessage:
          sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_CAN_NOT_READ_MESSAGE');
          break;
        default:
          sError = TextUtils.i18n('COREWEBCLIENT/ERROR_UNKNOWN');
      }
    }
  });
  if (aEmailsWithoutPublicKey.length > 0) {
    aEmailsWithoutPublicKey = _.without(aEmailsWithoutPublicKey, '');
    if (aEmailsWithoutPublicKey.length > 0) {
      sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_NO_PUBLIC_KEYS_FOR_USERS_PLURAL', {
        'USERS': aEmailsWithoutPublicKey.join(', ')
      }, null, aEmailsWithoutPublicKey.length);
    } else if (sPgpAction === Enums.PgpAction.Verify) {
      sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_NO_PUBLIC_KEY_FOUND_FOR_VERIFY');
    }
    if (bNotice && sError !== '') {
      sError += ' ' + TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_MESSAGE_WAS_NOT_VERIFIED');
    }
  } else if (aEmailsWithoutPrivateKey.length > 0) {
    aEmailsWithoutPrivateKey = _.without(aEmailsWithoutPrivateKey, '');
    if (aEmailsWithoutPrivateKey.length > 0) {
      sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_NO_PRIVATE_KEYS_FOR_USERS_PLURAL', {
        'USERS': aEmailsWithoutPrivateKey.join(', ')
      }, null, aEmailsWithoutPrivateKey.length);
    } else if (sPgpAction === Enums.PgpAction.DecryptVerify) {
      sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_NO_PRIVATE_KEY_FOUND_FOR_DECRYPT');
    }
  }
  if (sError === '' && !bNoSignDataNotice) {
    switch (sPgpAction) {
      case Enums.PgpAction.Generate:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_GENERATE_KEY');
        break;
      case Enums.PgpAction.Import:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_KEY');
        break;
      case Enums.PgpAction.DecryptVerify:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_DECRYPT');
        break;
      case Enums.PgpAction.Verify:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_VERIFY');
        break;
      case Enums.PgpAction.Encrypt:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_ENCRYPT');
        break;
      case Enums.PgpAction.EncryptSign:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_ENCRYPT_OR_SIGN');
        break;
      case Enums.PgpAction.Sign:
        sError = TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_SIGN');
        break;
    }
  }
  if (sError === '' && sDefaultError) {
    sError = sDefaultError;
  }
  if (sError === '') {
    sError = TextUtils.i18n('COREWEBCLIENT/ERROR_UNKNOWN');
  }
  if (sError !== '') {
    Screens.showError(sError);
  }
  return bNoSignDataNotice;
};
module.exports = ErrorsUtils;

/***/ }),

/***/ "RqIR":
/*!**************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/popups/ImportKeyPopup.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; }
var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  AddressUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Address.js */ "rBrp"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av"),
  Screens = __webpack_require__(/*! modules/CoreWebclient/js/Screens.js */ "D2Gh"),
  ErrorsUtils = __webpack_require__(/*! modules/OpenPgpWebclient/js/utils/Errors.js */ "RIpb"),
  Enums = __webpack_require__(/*! modules/OpenPgpWebclient/js/Enums.js */ "vfpp"),
  OpenPgp = __webpack_require__(/*! modules/OpenPgpWebclient/js/OpenPgp.js */ "E7cO");

/**
 * @constructor
 */
function CImportKeyPopup() {
  var _this = this;
  CAbstractPopup.call(this);
  this.keyArmor = ko.observable('');
  this.keyArmorFocused = ko.observable(false);
  this.keysOwn = ko.observableArray([]);
  this.keysPublicExternal = ko.observableArray([]);
  this.keysPrivateExternal = ko.observableArray([]);
  this.keysAlreadyThere = ko.observableArray([]);
  this.keysForContact = ko.observableArray([]);
  this.keysNotForContact = ko.observableArray([]);
  this.selectedKeyForContact = ko.observable('');
  this.keysBroken = ko.observableArray([]);
  this.keysChecked = ko.observable(false);
  this.shouldAddToPersonalContact = ko.observable('');
  this.contactEmail = ko.observable('');
  this.contactUUID = '';
  this.fOnSuccessCallback = null;
  this.visibleImportKeysButton = ko.computed(function () {
    if (_this.shouldAddToPersonalContact()) {
      return _this.keysForContact().length > 0;
    } else {
      return _this.keysOwn().length > 0 || _this.keysPublicExternal().length > 0;
    }
  });
  this.disabledForContactHeading = ko.computed(function () {
    var langConst = 'OPENPGPWEBCLIENT/INFO_TEXT_CONTAINS_NOT_PUBLIC_KEYS_OR_WITHOUT_EMAIL';
    return TextUtils.i18n(langConst, {
      'EMAIL': this.contactEmail()
    });
  }, this);
}
_.extendOwn(CImportKeyPopup.prototype, CAbstractPopup.prototype);
CImportKeyPopup.prototype.PopupTemplate = 'OpenPgpWebclient_ImportKeyPopup';

/**
 * @param {string} armor
 * @param {function} onSuccessCallback
 * @param {boolean} shouldAddToPersonalContact
 * @param {string} contactEmail
 * @param {string} contactUUID
 */
CImportKeyPopup.prototype.onOpen = function (_ref) {
  var _ref$armor = _ref.armor,
    armor = _ref$armor === void 0 ? '' : _ref$armor,
    _ref$onSuccessCallbac = _ref.onSuccessCallback,
    onSuccessCallback = _ref$onSuccessCallbac === void 0 ? function () {} : _ref$onSuccessCallbac,
    _ref$shouldAddToPerso = _ref.shouldAddToPersonalContact,
    shouldAddToPersonalContact = _ref$shouldAddToPerso === void 0 ? false : _ref$shouldAddToPerso,
    _ref$contactEmail = _ref.contactEmail,
    contactEmail = _ref$contactEmail === void 0 ? '' : _ref$contactEmail,
    _ref$contactUUID = _ref.contactUUID,
    contactUUID = _ref$contactUUID === void 0 ? '' : _ref$contactUUID;
  this.keyArmor(armor);
  this.keyArmorFocused(true);
  this.keysOwn([]);
  this.keysPublicExternal([]);
  this.keysPrivateExternal([]);
  this.keysAlreadyThere([]);
  this.keysForContact([]);
  this.keysNotForContact([]);
  this.keysBroken([]);
  this.keysChecked(false);
  this.shouldAddToPersonalContact(shouldAddToPersonalContact);
  this.contactEmail(contactEmail);
  this.contactUUID = contactUUID;
  this.fOnSuccessCallback = onSuccessCallback;
  if (this.keyArmor() !== '') {
    this.checkArmor();
  }
};
CImportKeyPopup.prototype.checkArmor = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
  var keys;
  return _regenerator().w(function (_context) {
    while (1) switch (_context.n) {
      case 0:
        if (!(this.keyArmor() === '')) {
          _context.n = 1;
          break;
        }
        this.keyArmorFocused(true);
        return _context.a(2);
      case 1:
        _context.n = 2;
        return OpenPgp.getArmorInfo(this.keyArmor());
      case 2:
        keys = _context.v;
        if (Types.isNonEmptyArray(keys)) {
          if (this.shouldAddToPersonalContact()) {
            this.checkArmorForContact(keys);
          } else {
            this.checkArmorForSettings(keys);
          }
          this.keysChecked(true);
        } else {
          Screens.showError(TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_NO_KEY_FOUND'));
        }
      case 3:
        return _context.a(2);
    }
  }, _callee, this);
}));
function getKeyData(key) {
  var hasNoEmail = !AddressUtils.isCorrectEmail(key.getEmail()),
    hasSameKey = OpenPgp.findKeysByEmails([key.getEmail()], key.isPublic()).length > 0,
    isOwnKey = OpenPgp.isOwnEmail(key.getEmail()),
    addInfoLangKey = key.isPublic() ? 'OPENPGPWEBCLIENT/INFO_PUBLIC_KEY_LENGTH' : 'OPENPGPWEBCLIENT/INFO_PRIVATE_KEY_LENGTH';
  return {
    'armor': key.getArmor(),
    'email': key.user,
    'id': "".concat(key.getId(), "_").concat(key.isPublic() ? 'public' : 'private'),
    'addInfo': TextUtils.i18n(addInfoLangKey, {
      'LENGTH': key.getBitSize()
    }),
    'needToImport': ko.observable(!hasSameKey && !hasNoEmail),
    'isExternal': !isOwnKey
  };
}
CImportKeyPopup.prototype.checkArmorForSettings = function (keys) {
  var keysOwn = [],
    keysPublicExternal = [],
    keysPrivateExternal = [],
    keysAlreadyThere = [],
    keysBroken = [];
  keys.forEach(function (key) {
    var hasNoEmail = !AddressUtils.isCorrectEmail(key.getEmail()),
      hasSameKey = OpenPgp.findKeysByEmails([key.getEmail()], key.isPublic()).length > 0,
      isOwnKey = OpenPgp.isOwnEmail(key.getEmail()),
      keyData = getKeyData(key);
    if (hasNoEmail) {
      keysBroken.push(keyData);
    } else if (hasSameKey) {
      keysAlreadyThere.push(keyData);
    } else if (isOwnKey) {
      keysOwn.push(keyData);
    } else {
      if (key.isPublic()) {
        keysPublicExternal.push(keyData);
      } else {
        keysPrivateExternal.push(keyData);
      }
    }
  });
  this.keysBroken(keysBroken);
  this.keysAlreadyThere(keysAlreadyThere);
  this.keysOwn(keysOwn);
  this.keysPublicExternal(keysPublicExternal);
  this.keysPrivateExternal(keysPrivateExternal);
};
CImportKeyPopup.prototype.checkArmorForContact = function (keys) {
  var _this2 = this;
  var keysBroken = [],
    keysNotForContact = [],
    keysForContact = [];
  keys.forEach(function (key) {
    var hasNoEmail = !AddressUtils.isCorrectEmail(key.getEmail()),
      keyData = getKeyData(key);
    if (hasNoEmail) {
      keysBroken.push(keyData);
    } else if (_this2.shouldAddToPersonalContact() && key.isPublic() && (key.getEmail() === _this2.contactEmail() || _this2.contactEmail() === '')) {
      keysForContact.push(keyData);
    } else {
      keysNotForContact.push(keyData);
    }
  });
  this.keysBroken(keysBroken);
  this.keysNotForContact(keysNotForContact);
  this.keysForContact(keysForContact);
  if (keysForContact.length > 0) {
    this.selectedKeyForContact(keysForContact[0].id);
  }
};
CImportKeyPopup.prototype.getKeysDataForImport = function () {
  var _this3 = this;
  if (this.shouldAddToPersonalContact()) {
    return this.keysForContact().filter(function (keyData) {
      return keyData.id === _this3.selectedKeyForContact();
    });
  } else {
    return [].concat(_toConsumableArray(this.keysOwn()), _toConsumableArray(this.keysPublicExternal())).filter(function (keyData) {
      return keyData.needToImport();
    });
  }
};
CImportKeyPopup.prototype.importKey = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
  var armors, res;
  return _regenerator().w(function (_context2) {
    while (1) switch (_context2.n) {
      case 0:
        armors = this.getKeysDataForImport().map(function (keyData) {
          return keyData.armor;
        });
        if (!(armors.length > 0)) {
          _context2.n = 5;
          break;
        }
        res = null;
        if (!this.shouldAddToPersonalContact()) {
          _context2.n = 2;
          break;
        }
        _context2.n = 1;
        return OpenPgp.addKeyToContact(armors[0], this.contactUUID);
      case 1:
        res = _context2.v;
        _context2.n = 4;
        break;
      case 2:
        _context2.n = 3;
        return OpenPgp.importKeys(armors.join(''));
      case 3:
        res = _context2.v;
      case 4:
        if (res && res.result) {
          if (this.contactUUID) {
            Screens.showReport(TextUtils.i18n('OPENPGPWEBCLIENT/REPORT_KEY_SUCCESSFULLY_IMPORTED_PLURAL', {}, null, armors.length));
          }
          if (_.isFunction(this.fOnSuccessCallback)) {
            this.fOnSuccessCallback(armors[0]);
          }
        } else {
          if (res) {
            ErrorsUtils.showPgpErrorByCode(res, Enums.PgpAction.Import, TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_KEY'));
          } else {
            Screens.showError(TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_KEY'));
          }
        }
        this.closePopup();
        _context2.n = 6;
        break;
      case 5:
        Screens.showError(TextUtils.i18n('OPENPGPWEBCLIENT/ERROR_IMPORT_NO_KEY_SELECTED'));
      case 6:
        return _context2.a(2);
    }
  }, _callee2, this);
}));
module.exports = new CImportKeyPopup();

/***/ }),

/***/ "a9Z8":
/*!*************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/Settings.js ***!
  \*************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {



var ko = __webpack_require__(/*! knockout */ "p09A"),
  _ = __webpack_require__(/*! underscore */ "C3HO"),
  Types = __webpack_require__(/*! modules/CoreWebclient/js/utils/Types.js */ "ERH9");
module.exports = {
  ServerModuleName: 'OpenPgpWebclient',
  HashModuleName: 'openpgp',
  enableOpenPgpInMail: ko.observable(false),
  rememberPassphrase: ko.observable(false),
  /**
   * Initializes settings from AppData object sections.
   *
   * @param {Object} oAppData Object contained modules settings.
   */
  init: function init(oAppData) {
    var oAppDataSection = oAppData['OpenPgpWebclient'];
    if (!_.isEmpty(oAppDataSection)) {
      this.enableOpenPgpInMail(Types.pBool(oAppDataSection.EnableModule, this.enableOpenPgpInMail()));
      this.rememberPassphrase(Types.pBool(oAppDataSection.RememberPassphrase, this.rememberPassphrase()));
    }
  },
  /**
   * Updates new settings values after saving on server.
   *
   * @param {boolean} bEnableOpenPgpInMail
   */
  update: function update(bEnableOpenPgpInMail) {
    this.enableOpenPgpInMail(bEnableOpenPgpInMail);
  }
};

/***/ }),

/***/ "avF0":
/*!*******************************************************************!*\
  !*** ./modules/OpenPgpWebclient/js/popups/PGPKeyPasswordPopup.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

/* provided dependency */ var $ = __webpack_require__(/*! jquery */ "M4cL");


var _ = __webpack_require__(/*! underscore */ "C3HO"),
  ko = __webpack_require__(/*! knockout */ "p09A"),
  TextUtils = __webpack_require__(/*! modules/CoreWebclient/js/utils/Text.js */ "LKDt"),
  CAbstractPopup = __webpack_require__(/*! modules/CoreWebclient/js/popups/CAbstractPopup.js */ "69av");

/**
 * @constructor
 */
function PGPKeyPasswordPopup() {
  CAbstractPopup.call(this);
  this.keyPassword = ko.observable('');
  this.keyPasswordDom = ko.observable(null);
  this.keyPasswordFocused = ko.observable(false);
  this.fOnPasswordEnterCallback = null;
  this.fOnCancellCallback = null;
  this.sHintText = ko.observable('');
}
_.extendOwn(PGPKeyPasswordPopup.prototype, CAbstractPopup.prototype);
PGPKeyPasswordPopup.prototype.PopupTemplate = 'OpenPgpWebclient_PGPKeyPasswordPopup';
PGPKeyPasswordPopup.prototype.onOpen = function (sKeyName, fOnPasswordEnterCallback, fOnCancellCallback) {
  this.sHintText(TextUtils.i18n('OPENPGPWEBCLIENT/LABEL_ENTER_YOUR_PASSWORD', {
    'KEY': sKeyName
  }));
  this.fOnPasswordEnterCallback = fOnPasswordEnterCallback;
  this.fOnCancellCallback = fOnCancellCallback;
  this.keyPasswordFocused(true);
};
PGPKeyPasswordPopup.prototype.enterPassword = function () {
  if (_.isFunction(this.fOnPasswordEnterCallback)) {
    // sometimes nockoutjs conflicts with saved passwords in FF
    this.keyPassword($(this.keyPasswordDom()).val());
    this.fOnPasswordEnterCallback(this.keyPassword());
  }
  this.closePopup();
  return false; // stopPropagation
};
PGPKeyPasswordPopup.prototype.cancelPopup = function () {
  if (_.isFunction(this.fOnCancellCallback)) {
    this.fOnCancellCallback();
  }
  this.closePopup();
};
PGPKeyPasswordPopup.prototype.onShow = function () {
  this.keyPassword('');
};
module.exports = new PGPKeyPasswordPopup();

/***/ }),

/***/ "h/lg":
/*!*****************************************************!*\
  !*** ./modules/CoreWebclient/js/vendors/openpgp.js ***!
  \*****************************************************/
/***/ ((module, exports, __webpack_require__) => {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;

function _regeneratorRuntime() { "use strict"; var r = _regenerator(), e = r.m(_regeneratorRuntime), t = (Object.getPrototypeOf ? Object.getPrototypeOf(e) : e.__proto__).constructor; function n(r) { var e = "function" == typeof r && r.constructor; return !!e && (e === t || "GeneratorFunction" === (e.displayName || e.name)); } var o = { "throw": 1, "return": 2, "break": 3, "continue": 3 }; function a(r) { var e, t; return function (n) { e || (e = { stop: function stop() { return t(n.a, 2); }, "catch": function _catch() { return n.v; }, abrupt: function abrupt(r, e) { return t(n.a, o[r], e); }, delegateYield: function delegateYield(r, o, a) { return e.resultName = o, t(n.d, _regeneratorValues(r), a); }, finish: function finish(r) { return t(n.f, r); } }, t = function t(r, _t0, o) { n.p = e.prev, n.n = e.next; try { return r(_t0, o); } finally { e.next = n.n; } }), e.resultName && (e[e.resultName] = n.v, e.resultName = void 0), e.sent = n.v, e.next = n.n; try { return r.call(this, e); } finally { n.p = e.prev, n.n = e.next; } }; } return (_regeneratorRuntime = function _regeneratorRuntime() { return { wrap: function wrap(e, t, n, o) { return r.w(a(e), t, n, o && o.reverse()); }, isGeneratorFunction: n, mark: r.m, awrap: function awrap(r, e) { return new _OverloadYield(r, e); }, AsyncIterator: _regeneratorAsyncIterator, async: function async(r, e, t, o, u) { return (n(e) ? _regeneratorAsyncGen : _regeneratorAsync)(a(r), e, t, o, u); }, keys: _regeneratorKeys, values: _regeneratorValues }; })(); }
function _regeneratorValues(e) { if (null != e) { var t = e["function" == typeof Symbol && Symbol.iterator || "@@iterator"], r = 0; if (t) return t.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) return { next: function next() { return e && r >= e.length && (e = void 0), { value: e && e[r++], done: !e }; } }; } throw new TypeError(_typeof2(e) + " is not iterable"); }
function _regeneratorKeys(e) { var n = Object(e), r = []; for (var t in n) r.unshift(t); return function e() { for (; r.length;) if ((t = r.pop()) in n) return e.value = t, e.done = !1, e; return e.done = !0, e; }; }
function _regeneratorAsync(n, e, r, t, o) { var a = _regeneratorAsyncGen(n, e, r, t, o); return a.next().then(function (n) { return n.done ? n.value : a.next(); }); }
function _regeneratorAsyncGen(r, e, t, o, n) { return new _regeneratorAsyncIterator(_regenerator().w(r, e, t, o), n || Promise); }
function _regeneratorAsyncIterator(t, e) { function n(r, o, i, f) { try { var c = t[r](o), u = c.value; return u instanceof _OverloadYield ? e.resolve(u.v).then(function (t) { n("next", t, i, f); }, function (t) { n("throw", t, i, f); }) : e.resolve(u).then(function (t) { c.value = t, i(c); }, function (t) { return n("throw", t, i, f); }); } catch (t) { f(t); } } var r; this.next || (_regeneratorDefine2(_regeneratorAsyncIterator.prototype), _regeneratorDefine2(_regeneratorAsyncIterator.prototype, "function" == typeof Symbol && Symbol.asyncIterator || "@asyncIterator", function () { return this; })), _regeneratorDefine2(this, "_invoke", function (t, o, i) { function f() { return new e(function (e, r) { n(t, i, e, r); }); } return r = r ? r.then(f, f) : f(); }, !0); }
function _regenerator() { /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/babel/babel/blob/main/packages/babel-helpers/LICENSE */ var e, t, r = "function" == typeof Symbol ? Symbol : {}, n = r.iterator || "@@iterator", o = r.toStringTag || "@@toStringTag"; function i(r, n, o, i) { var c = n && n.prototype instanceof Generator ? n : Generator, u = Object.create(c.prototype); return _regeneratorDefine2(u, "_invoke", function (r, n, o) { var i, c, u, f = 0, p = o || [], y = !1, G = { p: 0, n: 0, v: e, a: d, f: d.bind(e, 4), d: function d(t, r) { return i = t, c = 0, u = e, G.n = r, a; } }; function d(r, n) { for (c = r, u = n, t = 0; !y && f && !o && t < p.length; t++) { var o, i = p[t], d = G.p, l = i[2]; r > 3 ? (o = l === n) && (u = i[(c = i[4]) ? 5 : (c = 3, 3)], i[4] = i[5] = e) : i[0] <= d && ((o = r < 2 && d < i[1]) ? (c = 0, G.v = n, G.n = i[1]) : d < l && (o = r < 3 || i[0] > n || n > l) && (i[4] = r, i[5] = n, G.n = l, c = 0)); } if (o || r > 1) return a; throw y = !0, n; } return function (o, p, l) { if (f > 1) throw TypeError("Generator is already running"); for (y && 1 === p && d(p, l), c = p, u = l; (t = c < 2 ? e : u) || !y;) { i || (c ? c < 3 ? (c > 1 && (G.n = -1), d(c, u)) : G.n = u : G.v = u); try { if (f = 2, i) { if (c || (o = "next"), t = i[o]) { if (!(t = t.call(i, u))) throw TypeError("iterator result is not an object"); if (!t.done) return t; u = t.value, c < 2 && (c = 0); } else 1 === c && (t = i["return"]) && t.call(i), c < 2 && (u = TypeError("The iterator does not provide a '" + o + "' method"), c = 1); i = e; } else if ((t = (y = G.n < 0) ? u : r.call(n, G)) !== a) break; } catch (t) { i = e, c = 1, u = t; } finally { f = 1; } } return { value: t, done: y }; }; }(r, o, i), !0), u; } var a = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} t = Object.getPrototypeOf; var c = [][n] ? t(t([][n]())) : (_regeneratorDefine2(t = {}, n, function () { return this; }), t), u = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(c); function f(e) { return Object.setPrototypeOf ? Object.setPrototypeOf(e, GeneratorFunctionPrototype) : (e.__proto__ = GeneratorFunctionPrototype, _regeneratorDefine2(e, o, "GeneratorFunction")), e.prototype = Object.create(u), e; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, _regeneratorDefine2(u, "constructor", GeneratorFunctionPrototype), _regeneratorDefine2(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = "GeneratorFunction", _regeneratorDefine2(GeneratorFunctionPrototype, o, "GeneratorFunction"), _regeneratorDefine2(u), _regeneratorDefine2(u, o, "Generator"), _regeneratorDefine2(u, n, function () { return this; }), _regeneratorDefine2(u, "toString", function () { return "[object Generator]"; }), (_regenerator = function _regenerator() { return { w: i, m: f }; })(); }
function _regeneratorDefine2(e, r, n, t) { var i = Object.defineProperty; try { i({}, "", {}); } catch (e) { i = 0; } _regeneratorDefine2 = function _regeneratorDefine(e, r, n, t) { function o(r, n) { _regeneratorDefine2(e, r, function (e) { return this._invoke(r, n, e); }); } r ? i ? i(e, r, { value: n, enumerable: !t, configurable: !t, writable: !t }) : e[r] = n : (o("next", 0), o("throw", 1), o("return", 2)); }, _regeneratorDefine2(e, r, n, t); }
function _OverloadYield(e, d) { this.v = e, this.k = d; }
function _typeof2(o) { "@babel/helpers - typeof"; return _typeof2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof2(o); }
function _slicedToArray2(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}
function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;
  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);
      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }
  return _arr;
}
function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}
function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}
function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}
function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
      arr2[i] = arr[i];
    }
    return arr2;
  }
}
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}
function _asyncToGenerator(fn) {
  return function () {
    var self = this,
      args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }
      _next(undefined);
    });
  };
}
function _possibleConstructorReturn(self, call) {
  if (call && (_typeof(call) === "object" || typeof call === "function")) {
    return call;
  }
  return _assertThisInitialized(self);
}
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _classCallCheck(instance, Constructor) {
  if (!_instanceof(instance, Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}
function _instanceof(left, right) {
  if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) {
    return !!right[Symbol.hasInstance](left);
  } else {
    return left instanceof right;
  }
}
function _typeof(obj) {
  if (typeof Symbol === "function" && _typeof2(Symbol.iterator) === "symbol") {
    _typeof = function _typeof(obj) {
      return _typeof2(obj);
    };
  } else {
    _typeof = function _typeof(obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : _typeof2(obj);
    };
  }
  return _typeof(obj);
}
(function (f) {
  if (( false ? 0 : _typeof(exports)) === "object" && "object" !== "undefined") {
    module.exports = f();
  } else if (true) {
    !(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_FACTORY__ = (f),
		__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
		(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
		__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
  } else // removed by dead control flow
{ var g; }
})(function () {
  var define, module, exports;
  return function () {
    function r(e, n, t) {
      function o(i, f) {
        if (!n[i]) {
          if (!e[i]) {
            var c = undefined;
            if (!f && c) return require(i, !0);
            if (u) return u(i, !0);
            var a = new Error("Cannot find module '" + i + "'");
            throw a.code = "MODULE_NOT_FOUND", a;
          }
          var p = n[i] = {
            exports: {}
          };
          e[i][0].call(p.exports, function (r) {
            var n = e[i][1][r];
            return o(n || r);
          }, p, p.exports, r, e, n, t);
        }
        return n[i].exports;
      }
      for (var u = undefined, i = 0; i < t.length; i++) {
        o(t[i]);
      }
      return o;
    }
    return r;
  }()({
    1: [function (require, module, exports) {
      (function (global) {
        "use strict";

        !function (e, t) {
          "object" == _typeof(exports) && "undefined" != typeof module ? t(exports) : "function" == typeof define && define.amd ? define(["exports"], t) : t((e = e || self).WebStreamsPolyfill = {});
        }(undefined, function (e) {
          "use strict";

          var t = "function" == typeof Symbol && "symbol" == _typeof(Symbol.iterator) ? Symbol : function (e) {
            return "Symbol(".concat(e, ")");
          };
          var r = "undefined" != typeof self ? self : "undefined" != typeof window ? window : "undefined" != typeof global ? global : void 0,
            o = Number.isNaN || function (e) {
              return e != e;
            };
          function n(e) {
            return "object" == _typeof(e) && null !== e || "function" == typeof e;
          }
          function i(e, t, r) {
            Object.defineProperty(e, t, {
              value: r,
              writable: !0,
              enumerable: !0,
              configurable: !0
            });
          }
          function a(e) {
            return e.slice();
          }
          function s(e, t, r, o, n) {
            new Uint8Array(e).set(new Uint8Array(r, o, n), t);
          }
          function l(e) {
            return !1 !== function (e) {
              if ("number" != typeof e) return !1;
              if (o(e)) return !1;
              if (e < 0) return !1;
              return !0;
            }(e) && e !== 1 / 0;
          }
          function c(e, t, r) {
            if ("function" != typeof e) throw new TypeError("Argument is not a function");
            return Function.prototype.apply.call(e, t, r);
          }
          function u(e, t, r, o) {
            var n = e[t];
            if (void 0 !== n) {
              if ("function" != typeof n) throw new TypeError("".concat(n, " is not a method"));
              switch (r) {
                case 0:
                  return function () {
                    return f(n, e, o);
                  };
                case 1:
                  return function (t) {
                    var r = [t].concat(o);
                    return f(n, e, r);
                  };
              }
            }
            return function () {
              return Promise.resolve();
            };
          }
          function d(e, t, r) {
            var o = e[t];
            if (void 0 !== o) return c(o, e, r);
          }
          function f(e, t, r) {
            try {
              return Promise.resolve(c(e, t, r));
            } catch (e) {
              return Promise.reject(e);
            }
          }
          function _(e) {
            return e;
          }
          function h(e) {
            if (e = Number(e), o(e) || e < 0) throw new RangeError("highWaterMark property of a queuing strategy must be non-negative and non-NaN");
            return e;
          }
          function b(e) {
            if (void 0 === e) return function () {
              return 1;
            };
            if ("function" != typeof e) throw new TypeError("size property of a queuing strategy must be a function");
            return function (t) {
              return e(t);
            };
          }
          function m(e, t, r) {
            return Promise.prototype.then.call(e, t, r);
          }
          function y(e, t, r) {
            var o, n;
            var i = new Promise(function (e, t) {
              o = e, n = t;
            });
            void 0 === r && (r = function r(e) {
              throw e;
            });
            return function (e, t, r) {
              var o = !1;
              var n = function n(e) {
                !1 === o && (o = !0, r(e));
              };
              var i = 0,
                a = 0;
              var s = e.length,
                l = new Array(s);
              var _iteratorNormalCompletion = true;
              var _didIteratorError = false;
              var _iteratorError = undefined;
              try {
                var _loop = function _loop() {
                  var r = _step.value;
                  var e = i;
                  m(r, function (r) {
                    l[e] = r, ++a === s && t(l);
                  }, n), ++i;
                };
                for (var _iterator = e[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                  _loop();
                }
              } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
              } finally {
                try {
                  if (!_iteratorNormalCompletion && _iterator["return"] != null) {
                    _iterator["return"]();
                  }
                } finally {
                  if (_didIteratorError) {
                    throw _iteratorError;
                  }
                }
              }
            }(e, function (e) {
              try {
                var _r = t(e);
                o(_r);
              } catch (e) {
                n(e);
              }
            }, function (e) {
              try {
                var _t2 = r(e);
                o(_t2);
              } catch (e) {
                n(e);
              }
            }), i;
          }
          function p(e) {}
          function w(e) {
            e && _instanceof(e, p.AssertionError) && setTimeout(function () {
              throw e;
            }, 0);
          }
          function g(e) {
            var t = e._queue.shift();
            return e._queueTotalSize -= t.size, e._queueTotalSize < 0 && (e._queueTotalSize = 0), t.value;
          }
          function S(e, t, r) {
            if (!l(r = Number(r))) throw new RangeError("Size must be a finite, non-NaN, non-negative number.");
            e._queue.push({
              value: t,
              size: r
            }), e._queueTotalSize += r;
          }
          function v(e) {
            e._queue = [], e._queueTotalSize = 0;
          }
          p.AssertionError = function () {};
          var R = t("[[AbortSteps]]"),
            P = t("[[ErrorSteps]]");
          var WritableStream = /*#__PURE__*/function () {
            function WritableStream() {
              var e = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
              var t = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
              _classCallCheck(this, WritableStream);
              q(this);
              var r = t.size;
              var o = t.highWaterMark;
              if (void 0 !== e.type) throw new RangeError("Invalid type is specified");
              var n = b(r);
              void 0 === o && (o = 1), function (e, t, r, o) {
                var n = Object.create(WritableStreamDefaultController.prototype);
                var i = u(t, "write", 1, [n]),
                  a = u(t, "close", 0, []),
                  s = u(t, "abort", 1, []);
                $(e, n, function () {
                  return d(t, "start", [n]);
                }, i, a, s, r, o);
              }(this, e, o = h(o), n);
            }
            _createClass(WritableStream, [{
              key: "abort",
              value: function abort(e) {
                return !1 === E(this) ? Promise.reject(G("abort")) : !0 === C(this) ? Promise.reject(new TypeError("Cannot abort a stream that already has a writer")) : j(this, e);
              }
            }, {
              key: "getWriter",
              value: function getWriter() {
                if (!1 === E(this)) throw G("getWriter");
                return T(this);
              }
            }, {
              key: "locked",
              get: function get() {
                if (!1 === E(this)) throw G("locked");
                return C(this);
              }
            }]);
            return WritableStream;
          }();
          function T(e) {
            return new WritableStreamDefaultWriter(e);
          }
          function q(e) {
            e._state = "writable", e._storedError = void 0, e._writer = void 0, e._writableStreamController = void 0, e._writeRequests = [], e._inFlightWriteRequest = void 0, e._closeRequest = void 0, e._inFlightCloseRequest = void 0, e._pendingAbortRequest = void 0, e._backpressure = !1;
          }
          function E(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_writableStreamController");
          }
          function C(e) {
            return void 0 !== e._writer;
          }
          function j(e, t) {
            var r = e._state;
            if ("closed" === r || "errored" === r) return Promise.resolve(void 0);
            if (void 0 !== e._pendingAbortRequest) return e._pendingAbortRequest._promise;
            var o = !1;
            "erroring" === r && (o = !0, t = void 0);
            var n = new Promise(function (r, n) {
              e._pendingAbortRequest = {
                _promise: void 0,
                _resolve: r,
                _reject: n,
                _reason: t,
                _wasAlreadyErroring: o
              };
            });
            return e._pendingAbortRequest._promise = n, !1 === o && W(e, t), n;
          }
          function A(e, t) {
            "writable" !== e._state ? B(e) : W(e, t);
          }
          function W(e, t) {
            var r = e._writableStreamController;
            e._state = "erroring", e._storedError = t;
            var o = e._writer;
            void 0 !== o && D(o, t), !1 === function (e) {
              if (void 0 === e._inFlightWriteRequest && void 0 === e._inFlightCloseRequest) return !1;
              return !0;
            }(e) && !0 === r._started && B(e);
          }
          function B(e) {
            e._state = "errored", e._writableStreamController[P]();
            var t = e._storedError;
            var _iteratorNormalCompletion2 = true;
            var _didIteratorError2 = false;
            var _iteratorError2 = undefined;
            try {
              for (var _iterator2 = e._writeRequests[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
                var _r2 = _step2.value;
                _r2._reject(t);
              }
            } catch (err) {
              _didIteratorError2 = true;
              _iteratorError2 = err;
            } finally {
              try {
                if (!_iteratorNormalCompletion2 && _iterator2["return"] != null) {
                  _iterator2["return"]();
                }
              } finally {
                if (_didIteratorError2) {
                  throw _iteratorError2;
                }
              }
            }
            if (e._writeRequests = [], void 0 === e._pendingAbortRequest) return void z(e);
            var r = e._pendingAbortRequest;
            if (e._pendingAbortRequest = void 0, !0 === r._wasAlreadyErroring) return r._reject(t), void z(e);
            e._writableStreamController[R](r._reason).then(function () {
              r._resolve(), z(e);
            }, function (t) {
              r._reject(t), z(e);
            });
          }
          function O(e) {
            return void 0 !== e._closeRequest || void 0 !== e._inFlightCloseRequest;
          }
          function z(e) {
            void 0 !== e._closeRequest && (e._closeRequest._reject(e._storedError), e._closeRequest = void 0);
            var t = e._writer;
            void 0 !== t && ee(t, e._storedError);
          }
          function k(e, t) {
            var r = e._writer;
            void 0 !== r && t !== e._backpressure && (!0 === t ? function (e) {
              re(e);
            }(r) : ae(r)), e._backpressure = t;
          }
          var WritableStreamDefaultWriter = /*#__PURE__*/function () {
            function WritableStreamDefaultWriter(e) {
              _classCallCheck(this, WritableStreamDefaultWriter);
              if (!1 === E(e)) throw new TypeError("WritableStreamDefaultWriter can only be constructed with a WritableStream instance");
              if (!0 === C(e)) throw new TypeError("This stream has already been locked for exclusive writing by another writer");
              this._ownerWritableStream = e, e._writer = this;
              var t = e._state;
              if ("writable" === t) !1 === O(e) && !0 === e._backpressure ? re(this) : ne(this), X(this);else if ("erroring" === t) oe(this, e._storedError), X(this);else if ("closed" === t) ne(this), function (e) {
                X(e), te(e);
              }(this);else {
                var _t3 = e._storedError;
                oe(this, _t3), Z(this, _t3);
              }
            }
            _createClass(WritableStreamDefaultWriter, [{
              key: "abort",
              value: function abort(e) {
                return !1 === F(this) ? Promise.reject(J("abort")) : void 0 === this._ownerWritableStream ? Promise.reject(K("abort")) : function (e, t) {
                  return j(e._ownerWritableStream, t);
                }(this, e);
              }
            }, {
              key: "close",
              value: function close() {
                if (!1 === F(this)) return Promise.reject(J("close"));
                var e = this._ownerWritableStream;
                return void 0 === e ? Promise.reject(K("close")) : !0 === O(e) ? Promise.reject(new TypeError("cannot close an already-closing stream")) : L(this);
              }
            }, {
              key: "releaseLock",
              value: function releaseLock() {
                if (!1 === F(this)) throw J("releaseLock");
                void 0 !== this._ownerWritableStream && M(this);
              }
            }, {
              key: "write",
              value: function write(e) {
                return !1 === F(this) ? Promise.reject(J("write")) : void 0 === this._ownerWritableStream ? Promise.reject(K("write to")) : Y(this, e);
              }
            }, {
              key: "closed",
              get: function get() {
                return !1 === F(this) ? Promise.reject(J("closed")) : this._closedPromise;
              }
            }, {
              key: "desiredSize",
              get: function get() {
                if (!1 === F(this)) throw J("desiredSize");
                if (void 0 === this._ownerWritableStream) throw K("desiredSize");
                return function (e) {
                  var t = e._ownerWritableStream,
                    r = t._state;
                  if ("errored" === r || "erroring" === r) return null;
                  if ("closed" === r) return 0;
                  return Q(t._writableStreamController);
                }(this);
              }
            }, {
              key: "ready",
              get: function get() {
                return !1 === F(this) ? Promise.reject(J("ready")) : this._readyPromise;
              }
            }]);
            return WritableStreamDefaultWriter;
          }();
          function F(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_ownerWritableStream");
          }
          function L(e) {
            var t = e._ownerWritableStream,
              r = t._state;
            if ("closed" === r || "errored" === r) return Promise.reject(new TypeError("The stream (in ".concat(r, " state) is not in the writable state and cannot be closed")));
            var o = new Promise(function (e, r) {
              var o = {
                _resolve: e,
                _reject: r
              };
              t._closeRequest = o;
            });
            return !0 === t._backpressure && "writable" === r && ae(e), function (e) {
              S(e, "close", 0), x(e);
            }(t._writableStreamController), o;
          }
          function I(e, t) {
            "pending" === e._closedPromiseState ? ee(e, t) : function (e, t) {
              Z(e, t);
            }(e, t);
          }
          function D(e, t) {
            "pending" === e._readyPromiseState ? ie(e, t) : function (e, t) {
              oe(e, t);
            }(e, t);
          }
          function M(e) {
            var t = e._ownerWritableStream,
              r = new TypeError("Writer was released and can no longer be used to monitor the stream's closedness");
            D(e, r), I(e, r), t._writer = void 0, e._ownerWritableStream = void 0;
          }
          function Y(e, t) {
            var r = e._ownerWritableStream,
              o = r._writableStreamController,
              n = function (e, t) {
                try {
                  return e._strategySizeAlgorithm(t);
                } catch (t) {
                  return H(e, t), 1;
                }
              }(o, t);
            if (r !== e._ownerWritableStream) return Promise.reject(K("write to"));
            var i = r._state;
            if ("errored" === i) return Promise.reject(r._storedError);
            if (!0 === O(r) || "closed" === i) return Promise.reject(new TypeError("The stream is closing or closed and cannot be written to"));
            if ("erroring" === i) return Promise.reject(r._storedError);
            var a = function (e) {
              return new Promise(function (t, r) {
                var o = {
                  _resolve: t,
                  _reject: r
                };
                e._writeRequests.push(o);
              });
            }(r);
            return function (e, t, r) {
              var o = {
                chunk: t
              };
              try {
                S(e, o, r);
              } catch (t) {
                return void H(e, t);
              }
              var n = e._controlledWritableStream;
              if (!1 === O(n) && "writable" === n._state) {
                var _t4 = U(e);
                k(n, _t4);
              }
              x(e);
            }(o, t, n), a;
          }
          var WritableStreamDefaultController = /*#__PURE__*/function () {
            function WritableStreamDefaultController() {
              _classCallCheck(this, WritableStreamDefaultController);
              throw new TypeError("WritableStreamDefaultController cannot be constructed explicitly");
            }
            _createClass(WritableStreamDefaultController, [{
              key: "error",
              value: function error(e) {
                if (!1 === function (e) {
                  if (!n(e)) return !1;
                  if (!Object.prototype.hasOwnProperty.call(e, "_controlledWritableStream")) return !1;
                  return !0;
                }(this)) throw new TypeError("WritableStreamDefaultController.prototype.error can only be used on a WritableStreamDefaultController");
                "writable" === this._controlledWritableStream._state && V(this, e);
              }
            }, {
              key: R,
              value: function value(e) {
                var t = this._abortAlgorithm(e);
                return N(this), t;
              }
            }, {
              key: P,
              value: function value() {
                v(this);
              }
            }]);
            return WritableStreamDefaultController;
          }();
          function $(e, t, r, o, n, i, a, s) {
            t._controlledWritableStream = e, e._writableStreamController = t, t._queue = void 0, t._queueTotalSize = void 0, v(t), t._started = !1, t._strategySizeAlgorithm = s, t._strategyHWM = a, t._writeAlgorithm = o, t._closeAlgorithm = n, t._abortAlgorithm = i;
            var l = U(t);
            k(e, l);
            var c = r();
            Promise.resolve(c).then(function () {
              t._started = !0, x(t);
            }, function (r) {
              t._started = !0, A(e, r);
            })["catch"](w);
          }
          function N(e) {
            e._writeAlgorithm = void 0, e._closeAlgorithm = void 0, e._abortAlgorithm = void 0, e._strategySizeAlgorithm = void 0;
          }
          function Q(e) {
            return e._strategyHWM - e._queueTotalSize;
          }
          function x(e) {
            var t = e._controlledWritableStream;
            if (!1 === e._started) return;
            if (void 0 !== t._inFlightWriteRequest) return;
            var r = t._state;
            if ("closed" === r || "errored" === r) return;
            if ("erroring" === r) return void B(t);
            if (0 === e._queue.length) return;
            var o = function (e) {
              return e._queue[0].value;
            }(e);
            "close" === o ? function (e) {
              var t = e._controlledWritableStream;
              (function (e) {
                e._inFlightCloseRequest = e._closeRequest, e._closeRequest = void 0;
              })(t), g(e);
              var r = e._closeAlgorithm();
              N(e), r.then(function () {
                !function (e) {
                  e._inFlightCloseRequest._resolve(void 0), e._inFlightCloseRequest = void 0, "erroring" === e._state && (e._storedError = void 0, void 0 !== e._pendingAbortRequest && (e._pendingAbortRequest._resolve(), e._pendingAbortRequest = void 0)), e._state = "closed";
                  var t = e._writer;
                  void 0 !== t && te(t);
                }(t);
              }, function (e) {
                !function (e, t) {
                  e._inFlightCloseRequest._reject(t), e._inFlightCloseRequest = void 0, void 0 !== e._pendingAbortRequest && (e._pendingAbortRequest._reject(t), e._pendingAbortRequest = void 0), A(e, t);
                }(t, e);
              })["catch"](w);
            }(e) : function (e, t) {
              var r = e._controlledWritableStream;
              (function (e) {
                e._inFlightWriteRequest = e._writeRequests.shift();
              })(r), e._writeAlgorithm(t).then(function () {
                !function (e) {
                  e._inFlightWriteRequest._resolve(void 0), e._inFlightWriteRequest = void 0;
                }(r);
                var t = r._state;
                if (g(e), !1 === O(r) && "writable" === t) {
                  var _t5 = U(e);
                  k(r, _t5);
                }
                x(e);
              }, function (t) {
                "writable" === r._state && N(e), function (e, t) {
                  e._inFlightWriteRequest._reject(t), e._inFlightWriteRequest = void 0, A(e, t);
                }(r, t);
              })["catch"](w);
            }(e, o.chunk);
          }
          function H(e, t) {
            "writable" === e._controlledWritableStream._state && V(e, t);
          }
          function U(e) {
            return Q(e) <= 0;
          }
          function V(e, t) {
            var r = e._controlledWritableStream;
            N(e), W(r, t);
          }
          function G(e) {
            return new TypeError("WritableStream.prototype.".concat(e, " can only be used on a WritableStream"));
          }
          function J(e) {
            return new TypeError("WritableStreamDefaultWriter.prototype.".concat(e, " can only be used on a WritableStreamDefaultWriter"));
          }
          function K(e) {
            return new TypeError("Cannot " + e + " a stream using a released writer");
          }
          function X(e) {
            e._closedPromise = new Promise(function (t, r) {
              e._closedPromise_resolve = t, e._closedPromise_reject = r, e._closedPromiseState = "pending";
            });
          }
          function Z(e, t) {
            X(e), ee(e, t);
          }
          function ee(e, t) {
            e._closedPromise["catch"](function () {}), e._closedPromise_reject(t), e._closedPromise_resolve = void 0, e._closedPromise_reject = void 0, e._closedPromiseState = "rejected";
          }
          function te(e) {
            e._closedPromise_resolve(void 0), e._closedPromise_resolve = void 0, e._closedPromise_reject = void 0, e._closedPromiseState = "resolved";
          }
          function re(e) {
            e._readyPromise = new Promise(function (t, r) {
              e._readyPromise_resolve = t, e._readyPromise_reject = r;
            }), e._readyPromiseState = "pending";
          }
          function oe(e, t) {
            re(e), ie(e, t);
          }
          function ne(e) {
            re(e), ae(e);
          }
          function ie(e, t) {
            e._readyPromise["catch"](function () {}), e._readyPromise_reject(t), e._readyPromise_resolve = void 0, e._readyPromise_reject = void 0, e._readyPromiseState = "rejected";
          }
          function ae(e) {
            e._readyPromise_resolve(void 0), e._readyPromise_resolve = void 0, e._readyPromise_reject = void 0, e._readyPromiseState = "fulfilled";
          }
          var se = Number.isInteger || function (e) {
              return "number" == typeof e && isFinite(e) && Math.floor(e) === e;
            },
            le = t("[[CancelSteps]]"),
            ce = t("[[PullSteps]]");
          var ReadableStream = /*#__PURE__*/function () {
            function ReadableStream() {
              var e = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
              var t = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
              _classCallCheck(this, ReadableStream);
              fe(this);
              var r = t.size;
              var o = t.highWaterMark;
              var n = e.type;
              if ("bytes" === String(n)) {
                if (void 0 !== r) throw new RangeError("The strategy for a byte stream cannot have a size function");
                void 0 === o && (o = 0), function (e, t, r) {
                  var o = Object.create(ReadableByteStreamController.prototype);
                  var n = u(t, "pull", 0, [o]),
                    i = u(t, "cancel", 1, []);
                  var a = t.autoAllocateChunkSize;
                  if (void 0 !== a && (a = Number(a), !1 === se(a) || a <= 0)) throw new RangeError("autoAllocateChunkSize must be a positive integer");
                  !function (e, t, r, o, n, i, a) {
                    t._controlledReadableByteStream = e, t._pullAgain = !1, t._pulling = !1, He(t), t._queue = t._queueTotalSize = void 0, v(t), t._closeRequested = !1, t._started = !1, t._strategyHWM = h(i), t._pullAlgorithm = o, t._cancelAlgorithm = n, t._autoAllocateChunkSize = a, t._pendingPullIntos = [], e._readableStreamController = t;
                    var s = r();
                    Promise.resolve(s).then(function () {
                      t._started = !0, xe(t);
                    }, function (e) {
                      nt(t, e);
                    })["catch"](w);
                  }(e, o, function () {
                    return d(t, "start", [o]);
                  }, n, i, r, a);
                }(this, e, o = h(o));
              } else {
                if (void 0 !== n) throw new RangeError("Invalid type is specified");
                {
                  var _t6 = b(r);
                  void 0 === o && (o = 1), function (e, t, r, o) {
                    var n = Object.create(ReadableStreamDefaultController.prototype);
                    var i = u(t, "pull", 0, [n]),
                      a = u(t, "cancel", 1, []);
                    $e(e, n, function () {
                      return d(t, "start", [n]);
                    }, i, a, r, o);
                  }(this, e, o = h(o), _t6);
                }
              }
            }
            _createClass(ReadableStream, [{
              key: "cancel",
              value: function cancel(e) {
                return !1 === _e(this) ? Promise.reject(st("cancel")) : !0 === he(this) ? Promise.reject(new TypeError("Cannot cancel a stream that already has a reader")) : pe(this, e);
              }
            }, {
              key: "getReader",
              value: function getReader() {
                var _ref7 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
                  e = _ref7.mode;
                if (!1 === _e(this)) throw st("getReader");
                if (void 0 === e) return ue(this);
                if ("byob" === (e = String(e))) return function (e) {
                  return new ReadableStreamBYOBReader(e);
                }(this);
                throw new RangeError("Invalid mode is specified");
              }
            }, {
              key: "pipeThrough",
              value: function pipeThrough(_ref8) {
                var e = _ref8.writable,
                  t = _ref8.readable;
                var _ref9 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                  r = _ref9.preventClose,
                  o = _ref9.preventAbort,
                  n = _ref9.preventCancel,
                  i = _ref9.signal;
                if (!1 === _e(this)) throw st("pipeThrough");
                if (!1 === E(e)) throw new TypeError("writable argument to pipeThrough must be a WritableStream");
                if (!1 === _e(t)) throw new TypeError("readable argument to pipeThrough must be a ReadableStream");
                if (r = Boolean(r), o = Boolean(o), n = Boolean(n), void 0 !== i && !at(i)) throw new TypeError("ReadableStream.prototype.pipeThrough's signal option must be an AbortSignal");
                if (!0 === he(this)) throw new TypeError("ReadableStream.prototype.pipeThrough cannot be used on a locked ReadableStream");
                if (!0 === C(e)) throw new TypeError("ReadableStream.prototype.pipeThrough cannot be used on a locked WritableStream");
                return be(this, e, r, o, n, i)["catch"](function () {}), t;
              }
            }, {
              key: "pipeTo",
              value: function pipeTo(e) {
                var _ref10 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                  t = _ref10.preventClose,
                  r = _ref10.preventAbort,
                  o = _ref10.preventCancel,
                  n = _ref10.signal;
                return !1 === _e(this) ? Promise.reject(st("pipeTo")) : !1 === E(e) ? Promise.reject(new TypeError("ReadableStream.prototype.pipeTo's first argument must be a WritableStream")) : (t = Boolean(t), r = Boolean(r), o = Boolean(o), void 0 === n || at(n) ? !0 === he(this) ? Promise.reject(new TypeError("ReadableStream.prototype.pipeTo cannot be used on a locked ReadableStream")) : !0 === C(e) ? Promise.reject(new TypeError("ReadableStream.prototype.pipeTo cannot be used on a locked WritableStream")) : be(this, e, t, r, o, n) : Promise.reject(new TypeError("ReadableStream.prototype.pipeTo's signal option must be an AbortSignal")));
              }
            }, {
              key: "tee",
              value: function tee() {
                if (!1 === _e(this)) throw st("tee");
                var e = function (e, t) {
                  var r = ue(e);
                  var o,
                    n,
                    i,
                    s,
                    l,
                    c = !1,
                    u = !1,
                    d = !1;
                  var f = new Promise(function (e) {
                    l = e;
                  });
                  function _() {
                    return Be(r).then(function (e) {
                      var t = e.value,
                        r = e.done;
                      if (!0 === r && !1 === c && (!1 === u && Le(i._readableStreamController), !1 === d && Le(s._readableStreamController), c = !0), !0 === c) return;
                      var o = t,
                        n = t;
                      !1 === u && Ie(i._readableStreamController, o), !1 === d && Ie(s._readableStreamController, n);
                    });
                  }
                  function h() {}
                  return i = de(h, _, function (t) {
                    if (u = !0, o = t, !0 === d) {
                      var _t7 = a([o, n]),
                        _r3 = pe(e, _t7);
                      l(_r3);
                    }
                    return f;
                  }), s = de(h, _, function (t) {
                    if (d = !0, n = t, !0 === u) {
                      var _t8 = a([o, n]),
                        _r4 = pe(e, _t8);
                      l(_r4);
                    }
                    return f;
                  }), r._closedPromise["catch"](function (e) {
                    !0 !== c && (De(i._readableStreamController, e), De(s._readableStreamController, e), c = !0);
                  }), [i, s];
                }(this);
                return a(e);
              }
            }, {
              key: "locked",
              get: function get() {
                if (!1 === _e(this)) throw st("locked");
                return he(this);
              }
            }]);
            return ReadableStream;
          }();
          function ue(e) {
            return new ReadableStreamDefaultReader(e);
          }
          function de(e, t, r) {
            var o = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
            var n = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : function () {
              return 1;
            };
            var i = Object.create(ReadableStream.prototype);
            return fe(i), $e(i, Object.create(ReadableStreamDefaultController.prototype), e, t, r, o, n), i;
          }
          function fe(e) {
            e._state = "readable", e._reader = void 0, e._storedError = void 0, e._disturbed = !1;
          }
          function _e(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_readableStreamController");
          }
          function he(e) {
            return void 0 !== e._reader;
          }
          function be(e, t, r, o, n, i) {
            var a = ue(e),
              s = T(t);
            var l = !1,
              c = Promise.resolve();
            return new Promise(function (u, d) {
              var f;
              if (void 0 !== i) {
                if (f = function f() {
                  var r = new DOMException("Aborted", "AbortError"),
                    i = [];
                  !1 === o && i.push(function () {
                    return "writable" === t._state ? j(t, r) : Promise.resolve();
                  }), !1 === n && i.push(function () {
                    return "readable" === e._state ? pe(e, r) : Promise.resolve();
                  }), b(function () {
                    return y(i.map(function (e) {
                      return e();
                    }), function (e) {
                      return e;
                    });
                  }, !0, r);
                }, !0 === i.aborted) return void f();
                i.addEventListener("abort", f);
              }
              if (h(e, a._closedPromise, function (e) {
                !1 === o ? b(function () {
                  return j(t, e);
                }, !0, e) : m(!0, e);
              }), h(t, s._closedPromise, function (t) {
                !1 === n ? b(function () {
                  return pe(e, t);
                }, !0, t) : m(!0, t);
              }), function (e, t, r) {
                "closed" === e._state ? r() : t.then(r)["catch"](w);
              }(e, a._closedPromise, function () {
                !1 === r ? b(function () {
                  return function (e) {
                    var t = e._ownerWritableStream,
                      r = t._state;
                    return !0 === O(t) || "closed" === r ? Promise.resolve() : "errored" === r ? Promise.reject(t._storedError) : L(e);
                  }(s);
                }) : m();
              }), !0 === O(t) || "closed" === t._state) {
                var _t9 = new TypeError("the destination writable stream closed before all data could be piped to it");
                !1 === n ? b(function () {
                  return pe(e, _t9);
                }, !0, _t9) : m(!0, _t9);
              }
              function _() {
                var e = c;
                return c.then(function () {
                  return e !== c ? _() : void 0;
                });
              }
              function h(e, t, r) {
                "errored" === e._state ? r(e._storedError) : t["catch"](r)["catch"](w);
              }
              function b(e, r, o) {
                function n() {
                  e().then(function () {
                    return p(r, o);
                  }, function (e) {
                    return p(!0, e);
                  })["catch"](w);
                }
                !0 !== l && (l = !0, "writable" === t._state && !1 === O(t) ? _().then(n) : n());
              }
              function m(e, r) {
                !0 !== l && (l = !0, "writable" === t._state && !1 === O(t) ? _().then(function () {
                  return p(e, r);
                })["catch"](w) : p(e, r));
              }
              function p(e, t) {
                M(s), We(a), void 0 !== i && i.removeEventListener("abort", f), e ? d(t) : u(void 0);
              }
              new Promise(function (e, t) {
                !function r(o) {
                  o ? e() : (!0 === l ? Promise.resolve(!0) : s._readyPromise.then(function () {
                    return Be(a).then(function (_ref11) {
                      var e = _ref11.value,
                        t = _ref11.done;
                      return !0 === t || (c = Y(s, e)["catch"](function () {}), !1);
                    });
                  })).then(r, t);
                }(!1);
              })["catch"](function (e) {
                c = Promise.resolve(), w(e);
              });
            });
          }
          function me(e, t) {
            return new Promise(function (r, o) {
              var n = {
                _resolve: r,
                _reject: o,
                _forAuthorCode: t
              };
              e._reader._readIntoRequests.push(n);
            });
          }
          function ye(e, t) {
            return new Promise(function (r, o) {
              var n = {
                _resolve: r,
                _reject: o,
                _forAuthorCode: t
              };
              e._reader._readRequests.push(n);
            });
          }
          function pe(e, t) {
            if (e._disturbed = !0, "closed" === e._state) return Promise.resolve(void 0);
            if ("errored" === e._state) return Promise.reject(e._storedError);
            return we(e), e._readableStreamController[le](t).then(function () {
              return void 0;
            });
          }
          function we(e) {
            e._state = "closed";
            var t = e._reader;
            if (void 0 !== t) {
              if (Ce(t)) {
                var _iteratorNormalCompletion3 = true;
                var _didIteratorError3 = false;
                var _iteratorError3 = undefined;
                try {
                  for (var _iterator3 = t._readRequests[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
                    var _ref = _step3.value;
                    var _e2 = _ref._resolve;
                    var _r5 = _ref._forAuthorCode;
                    _e2(ge(void 0, !0, _r5));
                  }
                } catch (err) {
                  _didIteratorError3 = true;
                  _iteratorError3 = err;
                } finally {
                  try {
                    if (!_iteratorNormalCompletion3 && _iterator3["return"] != null) {
                      _iterator3["return"]();
                    }
                  } finally {
                    if (_didIteratorError3) {
                      throw _iteratorError3;
                    }
                  }
                }
                t._readRequests = [];
              }
              _t(t);
            }
          }
          function ge(e, t, r) {
            var o = null;
            !0 === r && (o = Object.prototype);
            var n = Object.create(o);
            return Object.defineProperty(n, "value", {
              value: e,
              enumerable: !0,
              writable: !0,
              configurable: !0
            }), Object.defineProperty(n, "done", {
              value: t,
              enumerable: !0,
              writable: !0,
              configurable: !0
            }), n;
          }
          function Se(e, t) {
            e._state = "errored", e._storedError = t;
            var r = e._reader;
            if (void 0 !== r) {
              if (Ce(r)) {
                var _iteratorNormalCompletion4 = true;
                var _didIteratorError4 = false;
                var _iteratorError4 = undefined;
                try {
                  for (var _iterator4 = r._readRequests[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
                    var _e3 = _step4.value;
                    _e3._reject(t);
                  }
                } catch (err) {
                  _didIteratorError4 = true;
                  _iteratorError4 = err;
                } finally {
                  try {
                    if (!_iteratorNormalCompletion4 && _iterator4["return"] != null) {
                      _iterator4["return"]();
                    }
                  } finally {
                    if (_didIteratorError4) {
                      throw _iteratorError4;
                    }
                  }
                }
                r._readRequests = [];
              } else {
                var _iteratorNormalCompletion5 = true;
                var _didIteratorError5 = false;
                var _iteratorError5 = undefined;
                try {
                  for (var _iterator5 = r._readIntoRequests[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
                    var _e4 = _step5.value;
                    _e4._reject(t);
                  }
                } catch (err) {
                  _didIteratorError5 = true;
                  _iteratorError5 = err;
                } finally {
                  try {
                    if (!_iteratorNormalCompletion5 && _iterator5["return"] != null) {
                      _iterator5["return"]();
                    }
                  } finally {
                    if (_didIteratorError5) {
                      throw _iteratorError5;
                    }
                  }
                }
                r._readIntoRequests = [];
              }
              ft(r, t);
            }
          }
          function ve(e, t, r) {
            var o = e._reader._readRequests.shift();
            o._resolve(ge(t, r, o._forAuthorCode));
          }
          function Re(e) {
            return e._reader._readIntoRequests.length;
          }
          function Pe(e) {
            return e._reader._readRequests.length;
          }
          function Te(e) {
            var t = e._reader;
            return void 0 !== t && !!Ee(t);
          }
          function qe(e) {
            var t = e._reader;
            return void 0 !== t && !!Ce(t);
          }
          var ReadableStreamDefaultReader = /*#__PURE__*/function () {
            function ReadableStreamDefaultReader(e) {
              _classCallCheck(this, ReadableStreamDefaultReader);
              if (!1 === _e(e)) throw new TypeError("ReadableStreamDefaultReader can only be constructed with a ReadableStream instance");
              if (!0 === he(e)) throw new TypeError("This stream has already been locked for exclusive reading by another reader");
              je(this, e), this._readRequests = [];
            }
            _createClass(ReadableStreamDefaultReader, [{
              key: "cancel",
              value: function cancel(e) {
                return Ce(this) ? void 0 === this._ownerReadableStream ? Promise.reject(lt("cancel")) : Ae(this, e) : Promise.reject(ct("cancel"));
              }
            }, {
              key: "read",
              value: function read() {
                return Ce(this) ? void 0 === this._ownerReadableStream ? Promise.reject(lt("read from")) : Be(this, !0) : Promise.reject(ct("read"));
              }
            }, {
              key: "releaseLock",
              value: function releaseLock() {
                if (!Ce(this)) throw ct("releaseLock");
                if (void 0 !== this._ownerReadableStream) {
                  if (this._readRequests.length > 0) throw new TypeError("Tried to release a reader lock when that reader has pending read() calls un-settled");
                  We(this);
                }
              }
            }, {
              key: "closed",
              get: function get() {
                return Ce(this) ? this._closedPromise : Promise.reject(ct("closed"));
              }
            }]);
            return ReadableStreamDefaultReader;
          }();
          var ReadableStreamBYOBReader = /*#__PURE__*/function () {
            function ReadableStreamBYOBReader(e) {
              _classCallCheck(this, ReadableStreamBYOBReader);
              if (!_e(e)) throw new TypeError("ReadableStreamBYOBReader can only be constructed with a ReadableStream instance given a byte source");
              if (!1 === Ne(e._readableStreamController)) throw new TypeError("Cannot construct a ReadableStreamBYOBReader for a stream not constructed with a byte source");
              if (he(e)) throw new TypeError("This stream has already been locked for exclusive reading by another reader");
              je(this, e), this._readIntoRequests = [];
            }
            _createClass(ReadableStreamBYOBReader, [{
              key: "cancel",
              value: function cancel(e) {
                return Ee(this) ? void 0 === this._ownerReadableStream ? Promise.reject(lt("cancel")) : Ae(this, e) : Promise.reject(ht("cancel"));
              }
            }, {
              key: "read",
              value: function read(e) {
                return Ee(this) ? void 0 === this._ownerReadableStream ? Promise.reject(lt("read from")) : ArrayBuffer.isView(e) ? (e.buffer, 0 === e.byteLength ? Promise.reject(new TypeError("view must have non-zero byteLength")) : function (e, t) {
                  var r = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : !1;
                  var o = e._ownerReadableStream;
                  if (o._disturbed = !0, "errored" === o._state) return Promise.reject(o._storedError);
                  return function (e, t, r) {
                    var o = e._controlledReadableByteStream;
                    var n = 1;
                    t.constructor !== DataView && (n = t.constructor.BYTES_PER_ELEMENT);
                    var i = t.constructor,
                      a = {
                        buffer: _(t.buffer),
                        byteOffset: t.byteOffset,
                        byteLength: t.byteLength,
                        bytesFilled: 0,
                        elementSize: n,
                        ctor: i,
                        readerType: "byob"
                      };
                    if (e._pendingPullIntos.length > 0) return e._pendingPullIntos.push(a), me(o, r);
                    if ("closed" === o._state) {
                      var _e5 = new i(a.buffer, a.byteOffset, 0);
                      return Promise.resolve(ge(_e5, !0, r));
                    }
                    if (e._queueTotalSize > 0) {
                      if (!0 === Je(e, a)) {
                        var _t10 = Ve(a);
                        return Xe(e), Promise.resolve(ge(_t10, !1, r));
                      }
                      if (!0 === e._closeRequested) {
                        var _t11 = new TypeError("Insufficient bytes to fill elements in the given buffer");
                        return nt(e, _t11), Promise.reject(_t11);
                      }
                    }
                    e._pendingPullIntos.push(a);
                    var s = me(o, r);
                    return xe(e), s;
                  }(o._readableStreamController, t, r);
                }(this, e, !0)) : Promise.reject(new TypeError("view must be an array buffer view")) : Promise.reject(ht("read"));
              }
            }, {
              key: "releaseLock",
              value: function releaseLock() {
                if (!Ee(this)) throw ht("releaseLock");
                if (void 0 !== this._ownerReadableStream) {
                  if (this._readIntoRequests.length > 0) throw new TypeError("Tried to release a reader lock when that reader has pending read() calls un-settled");
                  We(this);
                }
              }
            }, {
              key: "closed",
              get: function get() {
                return Ee(this) ? this._closedPromise : Promise.reject(ht("closed"));
              }
            }]);
            return ReadableStreamBYOBReader;
          }();
          function Ee(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_readIntoRequests");
          }
          function Ce(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_readRequests");
          }
          function je(e, t) {
            e._ownerReadableStream = t, t._reader = e, "readable" === t._state ? ut(e) : "closed" === t._state ? function (e) {
              ut(e), _t(e);
            }(e) : dt(e, t._storedError);
          }
          function Ae(e, t) {
            return pe(e._ownerReadableStream, t);
          }
          function We(e) {
            "readable" === e._ownerReadableStream._state ? ft(e, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness")) : function (e, t) {
              dt(e, t);
            }(e, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness")), e._ownerReadableStream._reader = void 0, e._ownerReadableStream = void 0;
          }
          function Be(e) {
            var t = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : !1;
            var r = e._ownerReadableStream;
            return r._disturbed = !0, "closed" === r._state ? Promise.resolve(ge(void 0, !0, t)) : "errored" === r._state ? Promise.reject(r._storedError) : r._readableStreamController[ce](t);
          }
          var ReadableStreamDefaultController = /*#__PURE__*/function () {
            function ReadableStreamDefaultController() {
              _classCallCheck(this, ReadableStreamDefaultController);
              throw new TypeError();
            }
            _createClass(ReadableStreamDefaultController, [{
              key: "close",
              value: function close() {
                if (!1 === Oe(this)) throw bt("close");
                if (!1 === Ye(this)) throw new TypeError("The stream is not in a state that permits close");
                Le(this);
              }
            }, {
              key: "enqueue",
              value: function enqueue(e) {
                if (!1 === Oe(this)) throw bt("enqueue");
                if (!1 === Ye(this)) throw new TypeError("The stream is not in a state that permits enqueue");
                return Ie(this, e);
              }
            }, {
              key: "error",
              value: function error(e) {
                if (!1 === Oe(this)) throw bt("error");
                De(this, e);
              }
            }, {
              key: le,
              value: function value(e) {
                v(this);
                var t = this._cancelAlgorithm(e);
                return Fe(this), t;
              }
            }, {
              key: ce,
              value: function value(e) {
                var t = this._controlledReadableStream;
                if (this._queue.length > 0) {
                  var _r6 = g(this);
                  return !0 === this._closeRequested && 0 === this._queue.length ? (Fe(this), we(t)) : ze(this), Promise.resolve(ge(_r6, !1, e));
                }
                var r = ye(t, e);
                return ze(this), r;
              }
            }, {
              key: "desiredSize",
              get: function get() {
                if (!1 === Oe(this)) throw bt("desiredSize");
                return Me(this);
              }
            }]);
            return ReadableStreamDefaultController;
          }();
          function Oe(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_controlledReadableStream");
          }
          function ze(e) {
            !1 !== ke(e) && (!0 !== e._pulling ? (e._pulling = !0, e._pullAlgorithm().then(function () {
              if (e._pulling = !1, !0 === e._pullAgain) return e._pullAgain = !1, ze(e);
            }, function (t) {
              De(e, t);
            })["catch"](w)) : e._pullAgain = !0);
          }
          function ke(e) {
            var t = e._controlledReadableStream;
            return !1 !== Ye(e) && !1 !== e._started && (!0 === he(t) && Pe(t) > 0 || Me(e) > 0);
          }
          function Fe(e) {
            e._pullAlgorithm = void 0, e._cancelAlgorithm = void 0, e._strategySizeAlgorithm = void 0;
          }
          function Le(e) {
            var t = e._controlledReadableStream;
            e._closeRequested = !0, 0 === e._queue.length && (Fe(e), we(t));
          }
          function Ie(e, t) {
            var r = e._controlledReadableStream;
            if (!0 === he(r) && Pe(r) > 0) ve(r, t, !1);else {
              var _r7;
              try {
                _r7 = e._strategySizeAlgorithm(t);
              } catch (t) {
                throw De(e, t), t;
              }
              try {
                S(e, t, _r7);
              } catch (t) {
                throw De(e, t), t;
              }
            }
            ze(e);
          }
          function De(e, t) {
            var r = e._controlledReadableStream;
            "readable" === r._state && (v(e), Fe(e), Se(r, t));
          }
          function Me(e) {
            var t = e._controlledReadableStream._state;
            return "errored" === t ? null : "closed" === t ? 0 : e._strategyHWM - e._queueTotalSize;
          }
          function Ye(e) {
            var t = e._controlledReadableStream._state;
            return !1 === e._closeRequested && "readable" === t;
          }
          function $e(e, t, r, o, n, i, a) {
            t._controlledReadableStream = e, t._queue = void 0, t._queueTotalSize = void 0, v(t), t._started = !1, t._closeRequested = !1, t._pullAgain = !1, t._pulling = !1, t._strategySizeAlgorithm = a, t._strategyHWM = i, t._pullAlgorithm = o, t._cancelAlgorithm = n, e._readableStreamController = t;
            var s = r();
            Promise.resolve(s).then(function () {
              t._started = !0, ze(t);
            }, function (e) {
              De(t, e);
            })["catch"](w);
          }
          var ReadableStreamBYOBRequest = /*#__PURE__*/function () {
            function ReadableStreamBYOBRequest() {
              _classCallCheck(this, ReadableStreamBYOBRequest);
              throw new TypeError("ReadableStreamBYOBRequest cannot be used directly");
            }
            _createClass(ReadableStreamBYOBRequest, [{
              key: "respond",
              value: function respond(e) {
                if (!1 === Qe(this)) throw mt("respond");
                if (void 0 === this._associatedReadableByteStreamController) throw new TypeError("This BYOB request has been invalidated");
                this._view.buffer, function (e, t) {
                  if (!1 === l(t = Number(t))) throw new RangeError("bytesWritten must be a finite");
                  tt(e, t);
                }(this._associatedReadableByteStreamController, e);
              }
            }, {
              key: "respondWithNewView",
              value: function respondWithNewView(e) {
                if (!1 === Qe(this)) throw mt("respond");
                if (void 0 === this._associatedReadableByteStreamController) throw new TypeError("This BYOB request has been invalidated");
                if (!ArrayBuffer.isView(e)) throw new TypeError("You can only respond with array buffer views");
                e.buffer, function (e, t) {
                  var r = e._pendingPullIntos[0];
                  if (r.byteOffset + r.bytesFilled !== t.byteOffset) throw new RangeError("The region specified by view does not match byobRequest");
                  if (r.byteLength !== t.byteLength) throw new RangeError("The buffer of view has different capacity than byobRequest");
                  r.buffer = t.buffer, tt(e, t.byteLength);
                }(this._associatedReadableByteStreamController, e);
              }
            }, {
              key: "view",
              get: function get() {
                if (!1 === Qe(this)) throw mt("view");
                return this._view;
              }
            }]);
            return ReadableStreamBYOBRequest;
          }();
          var ReadableByteStreamController = /*#__PURE__*/function () {
            function ReadableByteStreamController() {
              _classCallCheck(this, ReadableByteStreamController);
              throw new TypeError("ReadableByteStreamController constructor cannot be used directly");
            }
            _createClass(ReadableByteStreamController, [{
              key: "close",
              value: function close() {
                if (!1 === Ne(this)) throw yt("close");
                if (!0 === this._closeRequested) throw new TypeError("The stream has already been closed; do not close it again!");
                var e = this._controlledReadableByteStream._state;
                if ("readable" !== e) throw new TypeError("The stream (in ".concat(e, " state) is not in the readable state and cannot be closed"));
                !function (e) {
                  var t = e._controlledReadableByteStream;
                  if (e._queueTotalSize > 0) return void (e._closeRequested = !0);
                  if (e._pendingPullIntos.length > 0) {
                    var _t12 = e._pendingPullIntos[0];
                    if (_t12.bytesFilled > 0) {
                      var _t13 = new TypeError("Insufficient bytes to fill elements in the given buffer");
                      throw nt(e, _t13), _t13;
                    }
                  }
                  ot(e), we(t);
                }(this);
              }
            }, {
              key: "enqueue",
              value: function enqueue(e) {
                if (!1 === Ne(this)) throw yt("enqueue");
                if (!0 === this._closeRequested) throw new TypeError("stream is closed or draining");
                var t = this._controlledReadableByteStream._state;
                if ("readable" !== t) throw new TypeError("The stream (in ".concat(t, " state) is not in the readable state and cannot be enqueued to"));
                if (!ArrayBuffer.isView(e)) throw new TypeError("You can only enqueue array buffer views when using a ReadableByteStreamController");
                e.buffer, function (e, t) {
                  var r = e._controlledReadableByteStream,
                    o = t.buffer,
                    n = t.byteOffset,
                    i = t.byteLength,
                    a = _(o);
                  if (!0 === qe(r)) {
                    if (0 === Pe(r)) Ge(e, a, n, i);else {
                      var _e6 = new Uint8Array(a, n, i);
                      ve(r, _e6, !1);
                    }
                  } else !0 === Te(r) ? (Ge(e, a, n, i), et(e)) : Ge(e, a, n, i);
                  xe(e);
                }(this, e);
              }
            }, {
              key: "error",
              value: function error(e) {
                if (!1 === Ne(this)) throw yt("error");
                nt(this, e);
              }
            }, {
              key: le,
              value: function value(e) {
                if (this._pendingPullIntos.length > 0) {
                  this._pendingPullIntos[0].bytesFilled = 0;
                }
                v(this);
                var t = this._cancelAlgorithm(e);
                return ot(this), t;
              }
            }, {
              key: ce,
              value: function value(e) {
                var t = this._controlledReadableByteStream;
                if (this._queueTotalSize > 0) {
                  var _t14 = this._queue.shift();
                  var _r8;
                  this._queueTotalSize -= _t14.byteLength, Xe(this);
                  try {
                    _r8 = new Uint8Array(_t14.buffer, _t14.byteOffset, _t14.byteLength);
                  } catch (e) {
                    return Promise.reject(e);
                  }
                  return Promise.resolve(ge(_r8, !1, e));
                }
                var r = this._autoAllocateChunkSize;
                if (void 0 !== r) {
                  var _e7;
                  try {
                    _e7 = new ArrayBuffer(r);
                  } catch (e) {
                    return Promise.reject(e);
                  }
                  var _t15 = {
                    buffer: _e7,
                    byteOffset: 0,
                    byteLength: r,
                    bytesFilled: 0,
                    elementSize: 1,
                    ctor: Uint8Array,
                    readerType: "default"
                  };
                  this._pendingPullIntos.push(_t15);
                }
                var o = ye(t, e);
                return xe(this), o;
              }
            }, {
              key: "byobRequest",
              get: function get() {
                if (!1 === Ne(this)) throw yt("byobRequest");
                if (void 0 === this._byobRequest && this._pendingPullIntos.length > 0) {
                  var _e8 = this._pendingPullIntos[0],
                    _t16 = new Uint8Array(_e8.buffer, _e8.byteOffset + _e8.bytesFilled, _e8.byteLength - _e8.bytesFilled),
                    _r9 = Object.create(ReadableStreamBYOBRequest.prototype);
                  !function (e, t, r) {
                    e._associatedReadableByteStreamController = t, e._view = r;
                  }(_r9, this, _t16), this._byobRequest = _r9;
                }
                return this._byobRequest;
              }
            }, {
              key: "desiredSize",
              get: function get() {
                if (!1 === Ne(this)) throw yt("desiredSize");
                return it(this);
              }
            }]);
            return ReadableByteStreamController;
          }();
          function Ne(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_controlledReadableByteStream");
          }
          function Qe(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_associatedReadableByteStreamController");
          }
          function xe(e) {
            !1 !== function (e) {
              var t = e._controlledReadableByteStream;
              if ("readable" !== t._state) return !1;
              if (!0 === e._closeRequested) return !1;
              if (!1 === e._started) return !1;
              if (!0 === qe(t) && Pe(t) > 0) return !0;
              if (!0 === Te(t) && Re(t) > 0) return !0;
              if (it(e) > 0) return !0;
              return !1;
            }(e) && (!0 !== e._pulling ? (e._pulling = !0, e._pullAlgorithm().then(function () {
              e._pulling = !1, !0 === e._pullAgain && (e._pullAgain = !1, xe(e));
            }, function (t) {
              nt(e, t);
            })["catch"](w)) : e._pullAgain = !0);
          }
          function He(e) {
            Ze(e), e._pendingPullIntos = [];
          }
          function Ue(e, t) {
            var r = !1;
            "closed" === e._state && (r = !0);
            var o = Ve(t);
            "default" === t.readerType ? ve(e, o, r) : function (e, t, r) {
              var o = e._reader._readIntoRequests.shift();
              o._resolve(ge(t, r, o._forAuthorCode));
            }(e, o, r);
          }
          function Ve(e) {
            var t = e.bytesFilled,
              r = e.elementSize;
            return new e.ctor(e.buffer, e.byteOffset, t / r);
          }
          function Ge(e, t, r, o) {
            e._queue.push({
              buffer: t,
              byteOffset: r,
              byteLength: o
            }), e._queueTotalSize += o;
          }
          function Je(e, t) {
            var r = t.elementSize,
              o = t.bytesFilled - t.bytesFilled % r,
              n = Math.min(e._queueTotalSize, t.byteLength - t.bytesFilled),
              i = t.bytesFilled + n,
              a = i - i % r;
            var l = n,
              c = !1;
            a > o && (l = a - t.bytesFilled, c = !0);
            var u = e._queue;
            for (; l > 0;) {
              var _r10 = u[0],
                _o = Math.min(l, _r10.byteLength),
                _n3 = t.byteOffset + t.bytesFilled;
              s(t.buffer, _n3, _r10.buffer, _r10.byteOffset, _o), _r10.byteLength === _o ? u.shift() : (_r10.byteOffset += _o, _r10.byteLength -= _o), e._queueTotalSize -= _o, Ke(e, _o, t), l -= _o;
            }
            return c;
          }
          function Ke(e, t, r) {
            Ze(e), r.bytesFilled += t;
          }
          function Xe(e) {
            0 === e._queueTotalSize && !0 === e._closeRequested ? (ot(e), we(e._controlledReadableByteStream)) : xe(e);
          }
          function Ze(e) {
            void 0 !== e._byobRequest && (e._byobRequest._associatedReadableByteStreamController = void 0, e._byobRequest._view = void 0, e._byobRequest = void 0);
          }
          function et(e) {
            for (; e._pendingPullIntos.length > 0;) {
              if (0 === e._queueTotalSize) return;
              var _t17 = e._pendingPullIntos[0];
              !0 === Je(e, _t17) && (rt(e), Ue(e._controlledReadableByteStream, _t17));
            }
          }
          function tt(e, t) {
            var r = e._pendingPullIntos[0];
            if ("closed" === e._controlledReadableByteStream._state) {
              if (0 !== t) throw new TypeError("bytesWritten must be 0 when calling respond() on a closed stream");
              !function (e, t) {
                t.buffer = _(t.buffer);
                var r = e._controlledReadableByteStream;
                if (!0 === Te(r)) for (; Re(r) > 0;) {
                  Ue(r, rt(e));
                }
              }(e, r);
            } else !function (e, t, r) {
              if (r.bytesFilled + t > r.byteLength) throw new RangeError("bytesWritten out of range");
              if (Ke(e, t, r), r.bytesFilled < r.elementSize) return;
              rt(e);
              var o = r.bytesFilled % r.elementSize;
              if (o > 0) {
                var _t18 = r.byteOffset + r.bytesFilled,
                  _n4 = r.buffer.slice(_t18 - o, _t18);
                Ge(e, _n4, 0, _n4.byteLength);
              }
              r.buffer = _(r.buffer), r.bytesFilled -= o, Ue(e._controlledReadableByteStream, r), et(e);
            }(e, t, r);
            xe(e);
          }
          function rt(e) {
            var t = e._pendingPullIntos.shift();
            return Ze(e), t;
          }
          function ot(e) {
            e._pullAlgorithm = void 0, e._cancelAlgorithm = void 0;
          }
          function nt(e, t) {
            var r = e._controlledReadableByteStream;
            "readable" === r._state && (He(e), v(e), ot(e), Se(r, t));
          }
          function it(e) {
            var t = e._controlledReadableByteStream._state;
            return "errored" === t ? null : "closed" === t ? 0 : e._strategyHWM - e._queueTotalSize;
          }
          function at(e) {
            if ("object" != _typeof(e) || null === e) return !1;
            var t = Object.getOwnPropertyDescriptor(AbortSignal.prototype, "aborted").get;
            try {
              return t.call(e), !0;
            } catch (e) {
              return !1;
            }
          }
          function st(e) {
            return new TypeError("ReadableStream.prototype.".concat(e, " can only be used on a ReadableStream"));
          }
          function lt(e) {
            return new TypeError("Cannot " + e + " a stream using a released reader");
          }
          function ct(e) {
            return new TypeError("ReadableStreamDefaultReader.prototype.".concat(e, " can only be used on a ReadableStreamDefaultReader"));
          }
          function ut(e) {
            e._closedPromise = new Promise(function (t, r) {
              e._closedPromise_resolve = t, e._closedPromise_reject = r;
            });
          }
          function dt(e, t) {
            ut(e), ft(e, t);
          }
          function ft(e, t) {
            e._closedPromise["catch"](function () {}), e._closedPromise_reject(t), e._closedPromise_resolve = void 0, e._closedPromise_reject = void 0;
          }
          function _t(e) {
            e._closedPromise_resolve(void 0), e._closedPromise_resolve = void 0, e._closedPromise_reject = void 0;
          }
          function ht(e) {
            return new TypeError("ReadableStreamBYOBReader.prototype.".concat(e, " can only be used on a ReadableStreamBYOBReader"));
          }
          function bt(e) {
            return new TypeError("ReadableStreamDefaultController.prototype.".concat(e, " can only be used on a ReadableStreamDefaultController"));
          }
          function mt(e) {
            return new TypeError("ReadableStreamBYOBRequest.prototype.".concat(e, " can only be used on a ReadableStreamBYOBRequest"));
          }
          function yt(e) {
            return new TypeError("ReadableByteStreamController.prototype.".concat(e, " can only be used on a ReadableByteStreamController"));
          }
          var ByteLengthQueuingStrategy = /*#__PURE__*/function () {
            function ByteLengthQueuingStrategy(_ref12) {
              var e = _ref12.highWaterMark;
              _classCallCheck(this, ByteLengthQueuingStrategy);
              i(this, "highWaterMark", e);
            }
            _createClass(ByteLengthQueuingStrategy, [{
              key: "size",
              value: function size(e) {
                return e.byteLength;
              }
            }]);
            return ByteLengthQueuingStrategy;
          }();
          var CountQueuingStrategy = /*#__PURE__*/function () {
            function CountQueuingStrategy(_ref13) {
              var e = _ref13.highWaterMark;
              _classCallCheck(this, CountQueuingStrategy);
              i(this, "highWaterMark", e);
            }
            _createClass(CountQueuingStrategy, [{
              key: "size",
              value: function size() {
                return 1;
              }
            }]);
            return CountQueuingStrategy;
          }();
          var TransformStream = /*#__PURE__*/function () {
            function TransformStream() {
              var e = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
              var t = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
              var r = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
              _classCallCheck(this, TransformStream);
              var o = t.size;
              var n = t.highWaterMark;
              var i = r.size;
              var a = r.highWaterMark;
              if (void 0 !== e.writableType) throw new RangeError("Invalid writable type specified");
              var s = b(o);
              if (void 0 === n && (n = 1), n = h(n), void 0 !== e.readableType) throw new RangeError("Invalid readable type specified");
              var l = b(i);
              var c;
              void 0 === a && (a = 0), a = h(a), function (e, t, r, o, n, i) {
                function a() {
                  return t;
                }
                e._writable = function (e, t, r, o) {
                  var n = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 1;
                  var i = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : function () {
                    return 1;
                  };
                  var a = Object.create(WritableStream.prototype);
                  return q(a), $(a, Object.create(WritableStreamDefaultController.prototype), e, t, r, o, n, i), a;
                }(a, function (t) {
                  return function (e, t) {
                    var r = e._transformStreamController;
                    if (!0 === e._backpressure) {
                      var _o2 = e._backpressureChangePromise;
                      return _o2.then(function () {
                        var o = e._writable,
                          n = o._state;
                        if ("erroring" === n) throw o._storedError;
                        return Tt(r, t);
                      });
                    }
                    return Tt(r, t);
                  }(e, t);
                }, function () {
                  return function (e) {
                    var t = e._readable,
                      r = e._transformStreamController,
                      o = r._flushAlgorithm();
                    return Rt(r), o.then(function () {
                      if ("errored" === t._state) throw t._storedError;
                      var e = t._readableStreamController;
                      !0 === Ye(e) && Le(e);
                    })["catch"](function (r) {
                      throw wt(e, r), t._storedError;
                    });
                  }(e);
                }, function (t) {
                  return function (e, t) {
                    return wt(e, t), Promise.resolve();
                  }(e, t);
                }, r, o), e._readable = de(a, function () {
                  return function (e) {
                    return St(e, !1), e._backpressureChangePromise;
                  }(e);
                }, function (t) {
                  return gt(e, t), Promise.resolve();
                }, n, i), e._backpressure = void 0, e._backpressureChangePromise = void 0, e._backpressureChangePromise_resolve = void 0, St(e, !0), e._transformStreamController = void 0;
              }(this, new Promise(function (e) {
                c = e;
              }), n, s, a, l), function (e, t) {
                var r = Object.create(TransformStreamDefaultController.prototype);
                var o = function o(e) {
                  try {
                    return Pt(r, e), Promise.resolve();
                  } catch (e) {
                    return Promise.reject(e);
                  }
                };
                var n = t.transform;
                if (void 0 !== n) {
                  if ("function" != typeof n) throw new TypeError("transform is not a method");
                  o = function o(e) {
                    return f(n, t, [e, r]);
                  };
                }
                var i = u(t, "flush", 0, [r]);
                !function (e, t, r, o) {
                  t._controlledTransformStream = e, e._transformStreamController = t, t._transformAlgorithm = r, t._flushAlgorithm = o;
                }(e, r, o, i);
              }(this, e);
              var _ = d(e, "start", [this._transformStreamController]);
              c(_);
            }
            _createClass(TransformStream, [{
              key: "readable",
              get: function get() {
                if (!1 === pt(this)) throw Et("readable");
                return this._readable;
              }
            }, {
              key: "writable",
              get: function get() {
                if (!1 === pt(this)) throw Et("writable");
                return this._writable;
              }
            }]);
            return TransformStream;
          }();
          function pt(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_transformStreamController");
          }
          function wt(e, t) {
            De(e._readable._readableStreamController, t), gt(e, t);
          }
          function gt(e, t) {
            Rt(e._transformStreamController), H(e._writable._writableStreamController, t), !0 === e._backpressure && St(e, !1);
          }
          function St(e, t) {
            void 0 !== e._backpressureChangePromise && e._backpressureChangePromise_resolve(), e._backpressureChangePromise = new Promise(function (t) {
              e._backpressureChangePromise_resolve = t;
            }), e._backpressure = t;
          }
          var TransformStreamDefaultController = /*#__PURE__*/function () {
            function TransformStreamDefaultController() {
              _classCallCheck(this, TransformStreamDefaultController);
              throw new TypeError("TransformStreamDefaultController instances cannot be created directly");
            }
            _createClass(TransformStreamDefaultController, [{
              key: "enqueue",
              value: function enqueue(e) {
                if (!1 === vt(this)) throw qt("enqueue");
                Pt(this, e);
              }
            }, {
              key: "error",
              value: function error(e) {
                if (!1 === vt(this)) throw qt("error");
                !function (e, t) {
                  wt(e._controlledTransformStream, t);
                }(this, e);
              }
            }, {
              key: "terminate",
              value: function terminate() {
                if (!1 === vt(this)) throw qt("terminate");
                !function (e) {
                  var t = e._controlledTransformStream,
                    r = t._readable._readableStreamController;
                  !0 === Ye(r) && Le(r);
                  var o = new TypeError("TransformStream terminated");
                  gt(t, o);
                }(this);
              }
            }, {
              key: "desiredSize",
              get: function get() {
                if (!1 === vt(this)) throw qt("desiredSize");
                return Me(this._controlledTransformStream._readable._readableStreamController);
              }
            }]);
            return TransformStreamDefaultController;
          }();
          function vt(e) {
            return !!n(e) && !!Object.prototype.hasOwnProperty.call(e, "_controlledTransformStream");
          }
          function Rt(e) {
            e._transformAlgorithm = void 0, e._flushAlgorithm = void 0;
          }
          function Pt(e, t) {
            var r = e._controlledTransformStream,
              o = r._readable._readableStreamController;
            if (!1 === Ye(o)) throw new TypeError("Readable side is not in a state that permits enqueue");
            try {
              Ie(o, t);
            } catch (e) {
              throw gt(r, e), r._readable._storedError;
            }
            (function (e) {
              return !0 !== ke(e);
            })(o) !== r._backpressure && St(r, !0);
          }
          function Tt(e, t) {
            return e._transformAlgorithm(t)["catch"](function (t) {
              throw wt(e._controlledTransformStream, t), t;
            });
          }
          function qt(e) {
            return new TypeError("TransformStreamDefaultController.prototype.".concat(e, " can only be used on a TransformStreamDefaultController"));
          }
          function Et(e) {
            return new TypeError("TransformStream.prototype.".concat(e, " can only be used on a TransformStream"));
          }
          var Ct = {
            ReadableStream: ReadableStream,
            WritableStream: WritableStream,
            ByteLengthQueuingStrategy: ByteLengthQueuingStrategy,
            CountQueuingStrategy: CountQueuingStrategy,
            TransformStream: TransformStream
          };
          void 0 !== r && Object.assign(r, Ct), e.ReadableStream = ReadableStream, e.WritableStream = WritableStream, e.ByteLengthQueuingStrategy = ByteLengthQueuingStrategy, e.CountQueuingStrategy = CountQueuingStrategy, e.TransformStream = TransformStream, Object.defineProperty(e, "__esModule", {
            value: !0
          });
        });
      }).call(this, typeof __webpack_require__.g !== "undefined" ? __webpack_require__.g : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {});
    }, {}],
    2: [function (require, module, exports) {
      'use strict';

      var ea_lib = require('email-addresses');
      exports.parse = function parse(line, startAt) {
        if (!line) throw 'Nothing to parse';
        line = line.trim();
        var addr = ea_lib({
          input: line,
          rfc6532: true,
          // unicode
          partial: false,
          // return failed parses
          simple: false,
          // simple AST
          strict: false,
          // turn off obs- features in the rfc
          rejectTLD: false,
          // domains require a "."
          startAt: startAt || null
        });
        if (!addr) throw 'No results'; // console.log("Parsed to: ", require('util').inspect(addr, {depth: 10, colors: true}));
        return addr.addresses.map(map_addresses);
      };
      function map_addresses(adr) {
        if (adr.type === 'group') {
          return new Group(adr.name, adr.addresses.map(map_addresses));
        }
        var comments;
        if (adr.parts.comments) {
          comments = adr.parts.comments.map(function (c) {
            return c.tokens.trim();
          }).join(' ').trim(); // if (comments.length) {
          //     comments = '(' + comments + ')';
          // }
        }
        var l = adr.local;
        if (!adr.name && /:/.test(l)) l = '"' + l + '"';
        return new Address(adr.name, l + '@' + adr.domain, comments);
      }
      exports.parseFrom = function (line) {
        return exports.parse(line, 'from');
      };
      exports.parseSender = function (line) {
        return exports.parse(line, 'sender');
      };
      exports.parseReplyTo = function (line) {
        return exports.parse(line, 'reply-to');
      };
      var Group = /*#__PURE__*/function () {
        function Group(display_name, addresses) {
          _classCallCheck(this, Group);
          this.phrase = display_name;
          this.addresses = addresses;
        }
        _createClass(Group, [{
          key: "format",
          value: function format() {
            return this.phrase + ":" + this.addresses.map(function (a) {
              return a.format();
            }).join(',');
          }
        }, {
          key: "name",
          value: function name() {
            var phrase = this.phrase;
            if (!(phrase && phrase.length)) {
              phrase = this.comment;
            }
            var name = _extract_name(phrase);
            return name;
          }
        }]);
        return Group;
      }();
      var Address = /*#__PURE__*/function () {
        function Address(phrase, address, comment) {
          _classCallCheck(this, Address);
          this.phrase = phrase || '';
          this.address = address || '';
          this.comment = comment || '';
        }
        _createClass(Address, [{
          key: "host",
          value: function host() {
            var match = /.*@(.*)$/.exec(this.address);
            if (!match) return null;
            return match[1];
          }
        }, {
          key: "user",
          value: function user() {
            var match = /^(.*)@/.exec(this.address);
            if (!match) return null;
            return match[1];
          }
        }, {
          key: "format",
          value: function format() {
            var phrase = this.phrase;
            var email = this.address;
            var comment = this.comment;
            var addr = [];
            var atext = new RegExp('^[\\-\\w !#$%&\'*+/=?^`{|}~]+$');
            if (phrase && phrase.length) {
              addr.push(atext.test(phrase.trim()) ? phrase : _quote_no_esc(phrase) ? phrase : '"' + phrase + '"');
              if (email && email.length) {
                addr.push("<" + email + ">");
              }
            } else if (email && email.length) {
              addr.push(email);
            }
            if (comment && /\S/.test(comment)) {
              comment = comment.replace(/^\s*\(?/, '(').replace(/\)?\s*$/, ')');
            }
            if (comment && comment.length) {
              addr.push(comment);
            }
            return addr.join(' ');
          }
        }, {
          key: "name",
          value: function name() {
            var phrase = this.phrase;
            var addr = this.address;
            if (!(phrase && phrase.length)) {
              phrase = this.comment;
            }
            var name = _extract_name(phrase); // first.last@domain address
            if (name === '') {
              var match = /([^%.@_]+([._][^%.@_]+)+)[@%]/.exec(addr);
              if (match) {
                name = match[1].replace(/[._]+/g, ' ');
                name = _extract_name(name);
              }
            }
            if (name === '' && /\/g=/i.test(addr)) {
              // X400 style address
              var _match = /\/g=([^/]*)/i.exec(addr);
              var f = _match[1];
              _match = /\/s=([^/]*)/i.exec(addr);
              var l = _match[1];
              name = _extract_name(f + " " + l);
            }
            return name;
          }
        }]);
        return Address;
      }();
      exports.Address = Address; // This is because JS regexps have no equivalent of
      // zero-width negative look-behind assertion for: /(?<!\\)"/
      function _quote_no_esc(str) {
        if (/^"/.test(str)) return true;
        var match;
        while (match = /^[\s\S]*?([\s\S])"/.exec(str)) {
          if (match[1] !== '\\') {
            return true;
          }
          str = str.substr(match[0].length);
        }
        return false;
      }
      exports.isAllLower = function (string) {
        return string === string.toLowerCase();
      };
      exports.isAllUpper = function (string) {
        return string === string.toUpperCase();
      };
      exports.nameCase = function (string) {
        return string.toLowerCase().replace(/\b(\w+)/g, function (_, d1) {
          // Set the case of the name to first char upper rest lower
          return d1.charAt(0).toUpperCase() + d1.slice(1);
        }).replace(/\bMc(\w)/gi, function (_, d1) {
          // Scottish names such as 'McLeod'
          return 'Mc' + d1.toUpperCase();
        }).replace(/\bo'(\w)/gi, function (_, d1) {
          // Irish names such as 'O'Malley, O'Reilly'
          return 'O\'' + d1.toUpperCase();
        }).replace(/\b(x*(ix)?v*(iv)?i*)\b/ig, function (_, d1) {
          // Roman numerals, eg 'Level III Support'
          return d1.toUpperCase();
        });
      }; // given a comment, attempt to extract a person's name
      function _extract_name(name) {
        // Using encodings, too hard. See Mail::Message::Field::Full.
        if (/=?.*?\?=/.test(name)) return ''; // trim whitespace
        name = name.trim();
        name = name.replace(/\s+/, ' '); // Disregard numeric names (e.g. 123456.1234@compuserve.com)
        if (/^[\d ]+$/.test(name)) return '';
        name = name.replace(/^\((.*)\)$/, '$1') // remove outermost parenthesis
        .replace(/^"(.*)"$/, '$1') // remove outer quotation marks
        .replace(/\(.*?\)/g, '') // remove minimal embedded comments
        .replace(/\\/g, '') // remove all escapes
        .replace(/^"(.*)"$/, '$1') // remove internal quotation marks
        .replace(/^([^\s]+) ?, ?(.*)$/, '$2 $1') // reverse "Last, First M." if applicable
        .replace(/,.*/, ''); // Change casing only when the name contains only upper or only
        // lower cased characters.
        if (exports.isAllUpper(name) || exports.isAllLower(name)) {
          // console.log("Changing case of: " + name);
          name = exports.nameCase(name); // console.log("Now: " + name);
        } // some cleanup
        name = name.replace(/\[[^\]]*\]/g, '').replace(/(^[\s'"]+|[\s'"]+$)/g, '').replace(/\s{2,}/g, ' ');
        return name;
      }
    }, {
      "email-addresses": 34
    }],
    3: [function (require, module, exports) {
      "use strict";

      Object.defineProperty(exports, "__esModule", {
        value: true
      }); /**
          * @file {@link http://asmjs.org Asm.js} implementation of the {@link https://en.wikipedia.org/wiki/Advanced_Encryption_Standard Advanced Encryption Standard}.
          * @author Artem S Vybornov <vybornov@gmail.com>
          * @license MIT
          */
      var AES_asm = exports.AES_asm = function () {
        "use strict";

        /**
        * Galois Field stuff init flag
        */
        var ginit_done = false; /**
                                * Galois Field exponentiation and logarithm tables for 3 (the generator)
                                */
        var gexp3, glog3; /**
                          * Init Galois Field tables
                          */
        function ginit() {
          gexp3 = [], glog3 = [];
          var a = 1,
            c,
            d;
          for (c = 0; c < 255; c++) {
            gexp3[c] = a; // Multiply by three
            d = a & 0x80, a <<= 1, a &= 255;
            if (d === 0x80) a ^= 0x1b;
            a ^= gexp3[c]; // Set the log table value
            glog3[gexp3[c]] = c;
          }
          gexp3[255] = gexp3[0];
          glog3[0] = 0;
          ginit_done = true;
        } /**
          * Galois Field multiplication
          * @param {number} a
          * @param {number} b
          * @return {number}
          */
        function gmul(a, b) {
          var c = gexp3[(glog3[a] + glog3[b]) % 255];
          if (a === 0 || b === 0) c = 0;
          return c;
        } /**
          * Galois Field reciprocal
          * @param {number} a
          * @return {number}
          */
        function ginv(a) {
          var i = gexp3[255 - glog3[a]];
          if (a === 0) i = 0;
          return i;
        } /**
          * AES stuff init flag
          */
        var aes_init_done = false; /**
                                   * Encryption, Decryption, S-Box and KeyTransform tables
                                   *
                                   * @type {number[]}
                                   */
        var aes_sbox; /**
                      * @type {number[]}
                      */
        var aes_sinv; /**
                      * @type {number[][]}
                      */
        var aes_enc; /**
                     * @type {number[][]}
                     */
        var aes_dec; /**
                     * Init AES tables
                     */
        function aes_init() {
          if (!ginit_done) ginit(); // Calculates AES S-Box value
          function _s(a) {
            var c, s, x;
            s = x = ginv(a);
            for (c = 0; c < 4; c++) {
              s = (s << 1 | s >>> 7) & 255;
              x ^= s;
            }
            x ^= 99;
            return x;
          } // Tables
          aes_sbox = [], aes_sinv = [], aes_enc = [[], [], [], []], aes_dec = [[], [], [], []];
          for (var i = 0; i < 256; i++) {
            var s = _s(i); // S-Box and its inverse
            aes_sbox[i] = s;
            aes_sinv[s] = i; // Ecryption and Decryption tables
            aes_enc[0][i] = gmul(2, s) << 24 | s << 16 | s << 8 | gmul(3, s);
            aes_dec[0][s] = gmul(14, i) << 24 | gmul(9, i) << 16 | gmul(13, i) << 8 | gmul(11, i); // Rotate tables
            for (var t = 1; t < 4; t++) {
              aes_enc[t][i] = aes_enc[t - 1][i] >>> 8 | aes_enc[t - 1][i] << 24;
              aes_dec[t][s] = aes_dec[t - 1][s] >>> 8 | aes_dec[t - 1][s] << 24;
            }
          }
          aes_init_done = true;
        } /**
          * Asm.js module constructor.
          *
          * <p>
          * Heap buffer layout by offset:
          * <pre>
          * 0x0000   encryption key schedule
          * 0x0400   decryption key schedule
          * 0x0800   sbox
          * 0x0c00   inv sbox
          * 0x1000   encryption tables
          * 0x2000   decryption tables
          * 0x3000   reserved (future GCM multiplication lookup table)
          * 0x4000   data
          * </pre>
          * Don't touch anything before <code>0x400</code>.
          * </p>
          *
          * @alias AES_asm
          * @class
          * @param foreign - <i>ignored</i>
          * @param buffer - heap buffer to link with
          */
        var wrapper = function wrapper(foreign, buffer) {
          // Init AES stuff for the first time
          if (!aes_init_done) aes_init(); // Fill up AES tables
          var heap = new Uint32Array(buffer);
          heap.set(aes_sbox, 0x0800 >> 2);
          heap.set(aes_sinv, 0x0c00 >> 2);
          for (var i = 0; i < 4; i++) {
            heap.set(aes_enc[i], 0x1000 + 0x400 * i >> 2);
            heap.set(aes_dec[i], 0x2000 + 0x400 * i >> 2);
          } /**
            * Calculate AES key schedules.
            * @instance
            * @memberof AES_asm
            * @param {number} ks - key size, 4/6/8 (for 128/192/256-bit key correspondingly)
            * @param {number} k0 - key vector components
            * @param {number} k1 - key vector components
            * @param {number} k2 - key vector components
            * @param {number} k3 - key vector components
            * @param {number} k4 - key vector components
            * @param {number} k5 - key vector components
            * @param {number} k6 - key vector components
            * @param {number} k7 - key vector components
            */
          function set_key(ks, k0, k1, k2, k3, k4, k5, k6, k7) {
            var ekeys = heap.subarray(0x000, 60),
              dkeys = heap.subarray(0x100, 0x100 + 60); // Encryption key schedule
            ekeys.set([k0, k1, k2, k3, k4, k5, k6, k7]);
            for (var i = ks, rcon = 1; i < 4 * ks + 28; i++) {
              var k = ekeys[i - 1];
              if (i % ks === 0 || ks === 8 && i % ks === 4) {
                k = aes_sbox[k >>> 24] << 24 ^ aes_sbox[k >>> 16 & 255] << 16 ^ aes_sbox[k >>> 8 & 255] << 8 ^ aes_sbox[k & 255];
              }
              if (i % ks === 0) {
                k = k << 8 ^ k >>> 24 ^ rcon << 24;
                rcon = rcon << 1 ^ (rcon & 0x80 ? 0x1b : 0);
              }
              ekeys[i] = ekeys[i - ks] ^ k;
            } // Decryption key schedule
            for (var j = 0; j < i; j += 4) {
              for (var jj = 0; jj < 4; jj++) {
                var k = ekeys[i - (4 + j) + (4 - jj) % 4];
                if (j < 4 || j >= i - 4) {
                  dkeys[j + jj] = k;
                } else {
                  dkeys[j + jj] = aes_dec[0][aes_sbox[k >>> 24]] ^ aes_dec[1][aes_sbox[k >>> 16 & 255]] ^ aes_dec[2][aes_sbox[k >>> 8 & 255]] ^ aes_dec[3][aes_sbox[k & 255]];
                }
              }
            } // Set rounds number
            asm.set_rounds(ks + 5);
          } // create library object with necessary properties
          var stdlib = {
            Uint8Array: Uint8Array,
            Uint32Array: Uint32Array
          };
          var asm = function (stdlib, foreign, buffer) {
            "use asm";

            var S0 = 0,
              S1 = 0,
              S2 = 0,
              S3 = 0,
              I0 = 0,
              I1 = 0,
              I2 = 0,
              I3 = 0,
              N0 = 0,
              N1 = 0,
              N2 = 0,
              N3 = 0,
              M0 = 0,
              M1 = 0,
              M2 = 0,
              M3 = 0,
              H0 = 0,
              H1 = 0,
              H2 = 0,
              H3 = 0,
              R = 0;
            var HEAP = new stdlib.Uint32Array(buffer),
              DATA = new stdlib.Uint8Array(buffer); /**
                                                    * AES core
                                                    * @param {number} k - precomputed key schedule offset
                                                    * @param {number} s - precomputed sbox table offset
                                                    * @param {number} t - precomputed round table offset
                                                    * @param {number} r - number of inner rounds to perform
                                                    * @param {number} x0 - 128-bit input block vector
                                                    * @param {number} x1 - 128-bit input block vector
                                                    * @param {number} x2 - 128-bit input block vector
                                                    * @param {number} x3 - 128-bit input block vector
                                                    */
            function _core(k, s, t, r, x0, x1, x2, x3) {
              k = k | 0;
              s = s | 0;
              t = t | 0;
              r = r | 0;
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              var t1 = 0,
                t2 = 0,
                t3 = 0,
                y0 = 0,
                y1 = 0,
                y2 = 0,
                y3 = 0,
                i = 0;
              t1 = t | 0x400, t2 = t | 0x800, t3 = t | 0xc00; // round 0
              x0 = x0 ^ HEAP[(k | 0) >> 2], x1 = x1 ^ HEAP[(k | 4) >> 2], x2 = x2 ^ HEAP[(k | 8) >> 2], x3 = x3 ^ HEAP[(k | 12) >> 2]; // round 1..r
              for (i = 16; (i | 0) <= r << 4; i = i + 16 | 0) {
                y0 = HEAP[(t | x0 >> 22 & 1020) >> 2] ^ HEAP[(t1 | x1 >> 14 & 1020) >> 2] ^ HEAP[(t2 | x2 >> 6 & 1020) >> 2] ^ HEAP[(t3 | x3 << 2 & 1020) >> 2] ^ HEAP[(k | i | 0) >> 2], y1 = HEAP[(t | x1 >> 22 & 1020) >> 2] ^ HEAP[(t1 | x2 >> 14 & 1020) >> 2] ^ HEAP[(t2 | x3 >> 6 & 1020) >> 2] ^ HEAP[(t3 | x0 << 2 & 1020) >> 2] ^ HEAP[(k | i | 4) >> 2], y2 = HEAP[(t | x2 >> 22 & 1020) >> 2] ^ HEAP[(t1 | x3 >> 14 & 1020) >> 2] ^ HEAP[(t2 | x0 >> 6 & 1020) >> 2] ^ HEAP[(t3 | x1 << 2 & 1020) >> 2] ^ HEAP[(k | i | 8) >> 2], y3 = HEAP[(t | x3 >> 22 & 1020) >> 2] ^ HEAP[(t1 | x0 >> 14 & 1020) >> 2] ^ HEAP[(t2 | x1 >> 6 & 1020) >> 2] ^ HEAP[(t3 | x2 << 2 & 1020) >> 2] ^ HEAP[(k | i | 12) >> 2];
                x0 = y0, x1 = y1, x2 = y2, x3 = y3;
              } // final round
              S0 = HEAP[(s | x0 >> 22 & 1020) >> 2] << 24 ^ HEAP[(s | x1 >> 14 & 1020) >> 2] << 16 ^ HEAP[(s | x2 >> 6 & 1020) >> 2] << 8 ^ HEAP[(s | x3 << 2 & 1020) >> 2] ^ HEAP[(k | i | 0) >> 2], S1 = HEAP[(s | x1 >> 22 & 1020) >> 2] << 24 ^ HEAP[(s | x2 >> 14 & 1020) >> 2] << 16 ^ HEAP[(s | x3 >> 6 & 1020) >> 2] << 8 ^ HEAP[(s | x0 << 2 & 1020) >> 2] ^ HEAP[(k | i | 4) >> 2], S2 = HEAP[(s | x2 >> 22 & 1020) >> 2] << 24 ^ HEAP[(s | x3 >> 14 & 1020) >> 2] << 16 ^ HEAP[(s | x0 >> 6 & 1020) >> 2] << 8 ^ HEAP[(s | x1 << 2 & 1020) >> 2] ^ HEAP[(k | i | 8) >> 2], S3 = HEAP[(s | x3 >> 22 & 1020) >> 2] << 24 ^ HEAP[(s | x0 >> 14 & 1020) >> 2] << 16 ^ HEAP[(s | x1 >> 6 & 1020) >> 2] << 8 ^ HEAP[(s | x2 << 2 & 1020) >> 2] ^ HEAP[(k | i | 12) >> 2];
            } /**
              * ECB mode encryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _ecb_enc(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              _core(0x0000, 0x0800, 0x1000, R, x0, x1, x2, x3);
            } /**
              * ECB mode decryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _ecb_dec(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              var t = 0;
              _core(0x0400, 0x0c00, 0x2000, R, x0, x3, x2, x1);
              t = S1, S1 = S3, S3 = t;
            } /**
              * CBC mode encryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _cbc_enc(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              _core(0x0000, 0x0800, 0x1000, R, I0 ^ x0, I1 ^ x1, I2 ^ x2, I3 ^ x3);
              I0 = S0, I1 = S1, I2 = S2, I3 = S3;
            } /**
              * CBC mode decryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _cbc_dec(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              var t = 0;
              _core(0x0400, 0x0c00, 0x2000, R, x0, x3, x2, x1);
              t = S1, S1 = S3, S3 = t;
              S0 = S0 ^ I0, S1 = S1 ^ I1, S2 = S2 ^ I2, S3 = S3 ^ I3;
              I0 = x0, I1 = x1, I2 = x2, I3 = x3;
            } /**
              * CFB mode encryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _cfb_enc(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              _core(0x0000, 0x0800, 0x1000, R, I0, I1, I2, I3);
              I0 = S0 = S0 ^ x0, I1 = S1 = S1 ^ x1, I2 = S2 = S2 ^ x2, I3 = S3 = S3 ^ x3;
            } /**
              * CFB mode decryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _cfb_dec(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              _core(0x0000, 0x0800, 0x1000, R, I0, I1, I2, I3);
              S0 = S0 ^ x0, S1 = S1 ^ x1, S2 = S2 ^ x2, S3 = S3 ^ x3;
              I0 = x0, I1 = x1, I2 = x2, I3 = x3;
            } /**
              * OFB mode encryption / decryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _ofb(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              _core(0x0000, 0x0800, 0x1000, R, I0, I1, I2, I3);
              I0 = S0, I1 = S1, I2 = S2, I3 = S3;
              S0 = S0 ^ x0, S1 = S1 ^ x1, S2 = S2 ^ x2, S3 = S3 ^ x3;
            } /**
              * CTR mode encryption / decryption
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _ctr(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              _core(0x0000, 0x0800, 0x1000, R, N0, N1, N2, N3);
              N3 = ~M3 & N3 | M3 & N3 + 1;
              N2 = ~M2 & N2 | M2 & N2 + ((N3 | 0) == 0);
              N1 = ~M1 & N1 | M1 & N1 + ((N2 | 0) == 0);
              N0 = ~M0 & N0 | M0 & N0 + ((N1 | 0) == 0);
              S0 = S0 ^ x0;
              S1 = S1 ^ x1;
              S2 = S2 ^ x2;
              S3 = S3 ^ x3;
            } /**
              * GCM mode MAC calculation
              * @param {number} x0 - 128-bit input block vector
              * @param {number} x1 - 128-bit input block vector
              * @param {number} x2 - 128-bit input block vector
              * @param {number} x3 - 128-bit input block vector
              */
            function _gcm_mac(x0, x1, x2, x3) {
              x0 = x0 | 0;
              x1 = x1 | 0;
              x2 = x2 | 0;
              x3 = x3 | 0;
              var y0 = 0,
                y1 = 0,
                y2 = 0,
                y3 = 0,
                z0 = 0,
                z1 = 0,
                z2 = 0,
                z3 = 0,
                i = 0,
                c = 0;
              x0 = x0 ^ I0, x1 = x1 ^ I1, x2 = x2 ^ I2, x3 = x3 ^ I3;
              y0 = H0 | 0, y1 = H1 | 0, y2 = H2 | 0, y3 = H3 | 0;
              for (; (i | 0) < 128; i = i + 1 | 0) {
                if (y0 >>> 31) {
                  z0 = z0 ^ x0, z1 = z1 ^ x1, z2 = z2 ^ x2, z3 = z3 ^ x3;
                }
                y0 = y0 << 1 | y1 >>> 31, y1 = y1 << 1 | y2 >>> 31, y2 = y2 << 1 | y3 >>> 31, y3 = y3 << 1;
                c = x3 & 1;
                x3 = x3 >>> 1 | x2 << 31, x2 = x2 >>> 1 | x1 << 31, x1 = x1 >>> 1 | x0 << 31, x0 = x0 >>> 1;
                if (c) x0 = x0 ^ 0xe1000000;
              }
              I0 = z0, I1 = z1, I2 = z2, I3 = z3;
            } /**
              * Set the internal rounds number.
              * @instance
              * @memberof AES_asm
              * @param {number} r - number if inner AES rounds
              */
            function set_rounds(r) {
              r = r | 0;
              R = r;
            } /**
              * Populate the internal state of the module.
              * @instance
              * @memberof AES_asm
              * @param {number} s0 - state vector
              * @param {number} s1 - state vector
              * @param {number} s2 - state vector
              * @param {number} s3 - state vector
              */
            function set_state(s0, s1, s2, s3) {
              s0 = s0 | 0;
              s1 = s1 | 0;
              s2 = s2 | 0;
              s3 = s3 | 0;
              S0 = s0, S1 = s1, S2 = s2, S3 = s3;
            } /**
              * Populate the internal iv of the module.
              * @instance
              * @memberof AES_asm
              * @param {number} i0 - iv vector
              * @param {number} i1 - iv vector
              * @param {number} i2 - iv vector
              * @param {number} i3 - iv vector
              */
            function set_iv(i0, i1, i2, i3) {
              i0 = i0 | 0;
              i1 = i1 | 0;
              i2 = i2 | 0;
              i3 = i3 | 0;
              I0 = i0, I1 = i1, I2 = i2, I3 = i3;
            } /**
              * Set nonce for CTR-family modes.
              * @instance
              * @memberof AES_asm
              * @param {number} n0 - nonce vector
              * @param {number} n1 - nonce vector
              * @param {number} n2 - nonce vector
              * @param {number} n3 - nonce vector
              */
            function set_nonce(n0, n1, n2, n3) {
              n0 = n0 | 0;
              n1 = n1 | 0;
              n2 = n2 | 0;
              n3 = n3 | 0;
              N0 = n0, N1 = n1, N2 = n2, N3 = n3;
            } /**
              * Set counter mask for CTR-family modes.
              * @instance
              * @memberof AES_asm
              * @param {number} m0 - counter mask vector
              * @param {number} m1 - counter mask vector
              * @param {number} m2 - counter mask vector
              * @param {number} m3 - counter mask vector
              */
            function set_mask(m0, m1, m2, m3) {
              m0 = m0 | 0;
              m1 = m1 | 0;
              m2 = m2 | 0;
              m3 = m3 | 0;
              M0 = m0, M1 = m1, M2 = m2, M3 = m3;
            } /**
              * Set counter for CTR-family modes.
              * @instance
              * @memberof AES_asm
              * @param {number} c0 - counter vector
              * @param {number} c1 - counter vector
              * @param {number} c2 - counter vector
              * @param {number} c3 - counter vector
              */
            function set_counter(c0, c1, c2, c3) {
              c0 = c0 | 0;
              c1 = c1 | 0;
              c2 = c2 | 0;
              c3 = c3 | 0;
              N3 = ~M3 & N3 | M3 & c3, N2 = ~M2 & N2 | M2 & c2, N1 = ~M1 & N1 | M1 & c1, N0 = ~M0 & N0 | M0 & c0;
            } /**
              * Store the internal state vector into the heap.
              * @instance
              * @memberof AES_asm
              * @param {number} pos - offset where to put the data
              * @return {number} The number of bytes have been written into the heap, always 16.
              */
            function get_state(pos) {
              pos = pos | 0;
              if (pos & 15) return -1;
              DATA[pos | 0] = S0 >>> 24, DATA[pos | 1] = S0 >>> 16 & 255, DATA[pos | 2] = S0 >>> 8 & 255, DATA[pos | 3] = S0 & 255, DATA[pos | 4] = S1 >>> 24, DATA[pos | 5] = S1 >>> 16 & 255, DATA[pos | 6] = S1 >>> 8 & 255, DATA[pos | 7] = S1 & 255, DATA[pos | 8] = S2 >>> 24, DATA[pos | 9] = S2 >>> 16 & 255, DATA[pos | 10] = S2 >>> 8 & 255, DATA[pos | 11] = S2 & 255, DATA[pos | 12] = S3 >>> 24, DATA[pos | 13] = S3 >>> 16 & 255, DATA[pos | 14] = S3 >>> 8 & 255, DATA[pos | 15] = S3 & 255;
              return 16;
            } /**
              * Store the internal iv vector into the heap.
              * @instance
              * @memberof AES_asm
              * @param {number} pos - offset where to put the data
              * @return {number} The number of bytes have been written into the heap, always 16.
              */
            function get_iv(pos) {
              pos = pos | 0;
              if (pos & 15) return -1;
              DATA[pos | 0] = I0 >>> 24, DATA[pos | 1] = I0 >>> 16 & 255, DATA[pos | 2] = I0 >>> 8 & 255, DATA[pos | 3] = I0 & 255, DATA[pos | 4] = I1 >>> 24, DATA[pos | 5] = I1 >>> 16 & 255, DATA[pos | 6] = I1 >>> 8 & 255, DATA[pos | 7] = I1 & 255, DATA[pos | 8] = I2 >>> 24, DATA[pos | 9] = I2 >>> 16 & 255, DATA[pos | 10] = I2 >>> 8 & 255, DATA[pos | 11] = I2 & 255, DATA[pos | 12] = I3 >>> 24, DATA[pos | 13] = I3 >>> 16 & 255, DATA[pos | 14] = I3 >>> 8 & 255, DATA[pos | 15] = I3 & 255;
              return 16;
            } /**
              * GCM initialization.
              * @instance
              * @memberof AES_asm
              */
            function gcm_init() {
              _ecb_enc(0, 0, 0, 0);
              H0 = S0, H1 = S1, H2 = S2, H3 = S3;
            } /**
              * Perform ciphering operation on the supplied data.
              * @instance
              * @memberof AES_asm
              * @param {number} mode - block cipher mode (see {@link AES_asm} mode constants)
              * @param {number} pos - offset of the data being processed
              * @param {number} len - length of the data being processed
              * @return {number} Actual amount of data have been processed.
              */
            function cipher(mode, pos, len) {
              mode = mode | 0;
              pos = pos | 0;
              len = len | 0;
              var ret = 0;
              if (pos & 15) return -1;
              while ((len | 0) >= 16) {
                _cipher_modes[mode & 7](DATA[pos | 0] << 24 | DATA[pos | 1] << 16 | DATA[pos | 2] << 8 | DATA[pos | 3], DATA[pos | 4] << 24 | DATA[pos | 5] << 16 | DATA[pos | 6] << 8 | DATA[pos | 7], DATA[pos | 8] << 24 | DATA[pos | 9] << 16 | DATA[pos | 10] << 8 | DATA[pos | 11], DATA[pos | 12] << 24 | DATA[pos | 13] << 16 | DATA[pos | 14] << 8 | DATA[pos | 15]);
                DATA[pos | 0] = S0 >>> 24, DATA[pos | 1] = S0 >>> 16 & 255, DATA[pos | 2] = S0 >>> 8 & 255, DATA[pos | 3] = S0 & 255, DATA[pos | 4] = S1 >>> 24, DATA[pos | 5] = S1 >>> 16 & 255, DATA[pos | 6] = S1 >>> 8 & 255, DATA[pos | 7] = S1 & 255, DATA[pos | 8] = S2 >>> 24, DATA[pos | 9] = S2 >>> 16 & 255, DATA[pos | 10] = S2 >>> 8 & 255, DATA[pos | 11] = S2 & 255, DATA[pos | 12] = S3 >>> 24, DATA[pos | 13] = S3 >>> 16 & 255, DATA[pos | 14] = S3 >>> 8 & 255, DATA[pos | 15] = S3 & 255;
                ret = ret + 16 | 0, pos = pos + 16 | 0, len = len - 16 | 0;
              }
              return ret | 0;
            } /**
              * Calculates MAC of the supplied data.
              * @instance
              * @memberof AES_asm
              * @param {number} mode - block cipher mode (see {@link AES_asm} mode constants)
              * @param {number} pos - offset of the data being processed
              * @param {number} len - length of the data being processed
              * @return {number} Actual amount of data have been processed.
              */
            function mac(mode, pos, len) {
              mode = mode | 0;
              pos = pos | 0;
              len = len | 0;
              var ret = 0;
              if (pos & 15) return -1;
              while ((len | 0) >= 16) {
                _mac_modes[mode & 1](DATA[pos | 0] << 24 | DATA[pos | 1] << 16 | DATA[pos | 2] << 8 | DATA[pos | 3], DATA[pos | 4] << 24 | DATA[pos | 5] << 16 | DATA[pos | 6] << 8 | DATA[pos | 7], DATA[pos | 8] << 24 | DATA[pos | 9] << 16 | DATA[pos | 10] << 8 | DATA[pos | 11], DATA[pos | 12] << 24 | DATA[pos | 13] << 16 | DATA[pos | 14] << 8 | DATA[pos | 15]);
                ret = ret + 16 | 0, pos = pos + 16 | 0, len = len - 16 | 0;
              }
              return ret | 0;
            } /**
              * AES cipher modes table (virual methods)
              */
            var _cipher_modes = [_ecb_enc, _ecb_dec, _cbc_enc, _cbc_dec, _cfb_enc, _cfb_dec, _ofb, _ctr]; /**
                                                                                                          * AES MAC modes table (virual methods)
                                                                                                          */
            var _mac_modes = [_cbc_enc, _gcm_mac]; /**
                                                   * Asm.js module exports
                                                   */
            return {
              set_rounds: set_rounds,
              set_state: set_state,
              set_iv: set_iv,
              set_nonce: set_nonce,
              set_mask: set_mask,
              set_counter: set_counter,
              get_state: get_state,
              get_iv: get_iv,
              gcm_init: gcm_init,
              cipher: cipher,
              mac: mac
            };
          }(stdlib, foreign, buffer);
          asm.set_key = set_key;
          return asm;
        }; /**
           * AES enciphering mode constants
           * @enum {number}
           * @const
           */
        wrapper.ENC = {
          ECB: 0,
          CBC: 2,
          CFB: 4,
          OFB: 6,
          CTR: 7
        },
        /**
        * AES deciphering mode constants
        * @enum {number}
        * @const
        */
        wrapper.DEC = {
          ECB: 1,
          CBC: 3,
          CFB: 5,
          OFB: 6,
          CTR: 7
        },
        /**
        * AES MAC mode constants
        * @enum {number}
        * @const
        */
        wrapper.MAC = {
          CBC: 0,
          GCM: 1
        }; /**
           * Heap data offset
           * @type {number}
           * @const
           */
        wrapper.HEAP_DATA = 0x4000;
        return wrapper;
      }();
    }, {}],
    4: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.AES = undefined;
      var _aes = require('./aes.asm');
      var _utils = require('../other/utils');
      var _errors = require('../other/errors');
      var heap_pool = [];
      var asm_pool = [];
      var AES = /** @class */function () {
        function AES(key, iv, padding, mode) {
          if (padding === void 0) {
            padding = true;
          }
          this.pos = 0;
          this.len = 0;
          this.mode = mode; // The AES object state
          this.pos = 0;
          this.len = 0;
          this.key = key;
          this.iv = iv;
          this.padding = padding; // The AES "worker"
          this.acquire_asm();
        }
        AES.prototype.acquire_asm = function () {
          if (this.heap === undefined && this.asm === undefined) {
            this.heap = heap_pool.pop() || (0, _utils._heap_init)().subarray(_aes.AES_asm.HEAP_DATA);
            this.asm = asm_pool.pop() || (0, _aes.AES_asm)(null, this.heap.buffer);
            this.reset(this.key, this.iv);
          }
        };
        AES.prototype.release_asm = function () {
          heap_pool.push(this.heap);
          ;
          asm_pool.push(this.asm);
          this.heap = undefined;
          this.asm = undefined;
        };
        AES.prototype.reset = function (key, iv) {
          // Key
          var keylen = key.length;
          if (keylen !== 16 && keylen !== 24 && keylen !== 32) throw new _errors.IllegalArgumentError('illegal key size');
          var keyview = new DataView(key.buffer, key.byteOffset, key.byteLength);
          this.asm.set_key(keylen >> 2, keyview.getUint32(0), keyview.getUint32(4), keyview.getUint32(8), keyview.getUint32(12), keylen > 16 ? keyview.getUint32(16) : 0, keylen > 16 ? keyview.getUint32(20) : 0, keylen > 24 ? keyview.getUint32(24) : 0, keylen > 24 ? keyview.getUint32(28) : 0); // IV
          if (iv !== undefined) {
            if (iv.length !== 16) throw new _errors.IllegalArgumentError('illegal iv size');
            var ivview = new DataView(iv.buffer, iv.byteOffset, iv.byteLength);
            this.asm.set_iv(ivview.getUint32(0), ivview.getUint32(4), ivview.getUint32(8), ivview.getUint32(12));
          } else {
            this.asm.set_iv(0, 0, 0, 0);
          }
        };
        AES.prototype.AES_Encrypt_process = function (data) {
          if (!(0, _utils.is_bytes)(data)) throw new TypeError("data isn't of expected type");
          this.acquire_asm();
          var asm = this.asm;
          var heap = this.heap;
          var amode = _aes.AES_asm.ENC[this.mode];
          var hpos = _aes.AES_asm.HEAP_DATA;
          var pos = this.pos;
          var len = this.len;
          var dpos = 0;
          var dlen = data.length || 0;
          var rpos = 0;
          var rlen = len + dlen & -16;
          var wlen = 0;
          var result = new Uint8Array(rlen);
          while (dlen > 0) {
            wlen = (0, _utils._heap_write)(heap, pos + len, data, dpos, dlen);
            len += wlen;
            dpos += wlen;
            dlen -= wlen;
            wlen = asm.cipher(amode, hpos + pos, len);
            if (wlen) result.set(heap.subarray(pos, pos + wlen), rpos);
            rpos += wlen;
            if (wlen < len) {
              pos += wlen;
              len -= wlen;
            } else {
              pos = 0;
              len = 0;
            }
          }
          this.pos = pos;
          this.len = len;
          return result;
        };
        AES.prototype.AES_Encrypt_finish = function () {
          this.acquire_asm();
          var asm = this.asm;
          var heap = this.heap;
          var amode = _aes.AES_asm.ENC[this.mode];
          var hpos = _aes.AES_asm.HEAP_DATA;
          var pos = this.pos;
          var len = this.len;
          var plen = 16 - len % 16;
          var rlen = len;
          if (this.hasOwnProperty('padding')) {
            if (this.padding) {
              for (var p = 0; p < plen; ++p) {
                heap[pos + len + p] = plen;
              }
              len += plen;
              rlen = len;
            } else if (len % 16) {
              throw new _errors.IllegalArgumentError('data length must be a multiple of the block size');
            }
          } else {
            len += plen;
          }
          var result = new Uint8Array(rlen);
          if (len) asm.cipher(amode, hpos + pos, len);
          if (rlen) result.set(heap.subarray(pos, pos + rlen));
          this.pos = 0;
          this.len = 0;
          this.release_asm();
          return result;
        };
        AES.prototype.AES_Decrypt_process = function (data) {
          if (!(0, _utils.is_bytes)(data)) throw new TypeError("data isn't of expected type");
          this.acquire_asm();
          var asm = this.asm;
          var heap = this.heap;
          var amode = _aes.AES_asm.DEC[this.mode];
          var hpos = _aes.AES_asm.HEAP_DATA;
          var pos = this.pos;
          var len = this.len;
          var dpos = 0;
          var dlen = data.length || 0;
          var rpos = 0;
          var rlen = len + dlen & -16;
          var plen = 0;
          var wlen = 0;
          if (this.padding) {
            plen = len + dlen - rlen || 16;
            rlen -= plen;
          }
          var result = new Uint8Array(rlen);
          while (dlen > 0) {
            wlen = (0, _utils._heap_write)(heap, pos + len, data, dpos, dlen);
            len += wlen;
            dpos += wlen;
            dlen -= wlen;
            wlen = asm.cipher(amode, hpos + pos, len - (!dlen ? plen : 0));
            if (wlen) result.set(heap.subarray(pos, pos + wlen), rpos);
            rpos += wlen;
            if (wlen < len) {
              pos += wlen;
              len -= wlen;
            } else {
              pos = 0;
              len = 0;
            }
          }
          this.pos = pos;
          this.len = len;
          return result;
        };
        AES.prototype.AES_Decrypt_finish = function () {
          this.acquire_asm();
          var asm = this.asm;
          var heap = this.heap;
          var amode = _aes.AES_asm.DEC[this.mode];
          var hpos = _aes.AES_asm.HEAP_DATA;
          var pos = this.pos;
          var len = this.len;
          var rlen = len;
          if (len > 0) {
            if (len % 16) {
              if (this.hasOwnProperty('padding')) {
                throw new _errors.IllegalArgumentError('data length must be a multiple of the block size');
              } else {
                len += 16 - len % 16;
              }
            }
            asm.cipher(amode, hpos + pos, len);
            if (this.hasOwnProperty('padding') && this.padding) {
              var pad = heap[pos + rlen - 1];
              if (pad < 1 || pad > 16 || pad > rlen) throw new _errors.SecurityError('bad padding');
              var pcheck = 0;
              for (var i = pad; i > 1; i--) {
                pcheck |= pad ^ heap[pos + rlen - i];
              }
              if (pcheck) throw new _errors.SecurityError('bad padding');
              rlen -= pad;
            }
          }
          var result = new Uint8Array(rlen);
          if (rlen > 0) {
            result.set(heap.subarray(pos, pos + rlen));
          }
          this.pos = 0;
          this.len = 0;
          this.release_asm();
          return result;
        };
        return AES;
      }();
      exports.AES = AES;
    }, {
      "../other/errors": 15,
      "../other/utils": 16,
      "./aes.asm": 3
    }],
    5: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.AES_CBC = undefined;
      var _aes = require('./aes');
      var _utils = require('../other/utils');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var AES_CBC = /** @class */function (_super) {
        __extends(AES_CBC, _super);
        function AES_CBC(key, iv, padding) {
          if (padding === void 0) {
            padding = true;
          }
          return _super.call(this, key, iv, padding, 'CBC') || this;
        }
        AES_CBC.encrypt = function (data, key, padding, iv) {
          if (padding === void 0) {
            padding = true;
          }
          return new AES_CBC(key, iv, padding).encrypt(data);
        };
        AES_CBC.decrypt = function (data, key, padding, iv) {
          if (padding === void 0) {
            padding = true;
          }
          return new AES_CBC(key, iv, padding).decrypt(data);
        };
        AES_CBC.prototype.encrypt = function (data) {
          var r1 = this.AES_Encrypt_process(data);
          var r2 = this.AES_Encrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        AES_CBC.prototype.decrypt = function (data) {
          var r1 = this.AES_Decrypt_process(data);
          var r2 = this.AES_Decrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        return AES_CBC;
      }(_aes.AES);
      exports.AES_CBC = AES_CBC;
    }, {
      "../other/utils": 16,
      "./aes": 4
    }],
    6: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.AES_CFB = undefined;
      var _aes = require('./aes');
      var _utils = require('../other/utils');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var AES_CFB = /** @class */function (_super) {
        __extends(AES_CFB, _super);
        function AES_CFB(key, iv) {
          var _this = _super.call(this, key, iv, true, 'CFB') || this;
          delete _this.padding;
          return _this;
        }
        AES_CFB.encrypt = function (data, key, iv) {
          return new AES_CFB(key, iv).encrypt(data);
        };
        AES_CFB.decrypt = function (data, key, iv) {
          return new AES_CFB(key, iv).decrypt(data);
        };
        AES_CFB.prototype.encrypt = function (data) {
          var r1 = this.AES_Encrypt_process(data);
          var r2 = this.AES_Encrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        AES_CFB.prototype.decrypt = function (data) {
          var r1 = this.AES_Decrypt_process(data);
          var r2 = this.AES_Decrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        return AES_CFB;
      }(_aes.AES);
      exports.AES_CFB = AES_CFB;
    }, {
      "../other/utils": 16,
      "./aes": 4
    }],
    7: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.AES_CTR = undefined;
      var _aes = require('./aes');
      var _errors = require('../other/errors');
      var _utils = require('../other/utils');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var AES_CTR = /** @class */function (_super) {
        __extends(AES_CTR, _super);
        function AES_CTR(key, nonce) {
          var _this = _super.call(this, key, undefined, false, 'CTR') || this;
          delete _this.padding;
          _this.AES_CTR_set_options(nonce);
          return _this;
        }
        AES_CTR.encrypt = function (data, key, nonce) {
          return new AES_CTR(key, nonce).encrypt(data);
        };
        AES_CTR.decrypt = function (data, key, nonce) {
          return new AES_CTR(key, nonce).encrypt(data);
        };
        AES_CTR.prototype.encrypt = function (data) {
          var r1 = this.AES_Encrypt_process(data);
          var r2 = this.AES_Encrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        AES_CTR.prototype.decrypt = function (data) {
          var r1 = this.AES_Encrypt_process(data);
          var r2 = this.AES_Encrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        AES_CTR.prototype.AES_CTR_set_options = function (nonce, counter, size) {
          if (size !== undefined) {
            if (size < 8 || size > 48) throw new _errors.IllegalArgumentError('illegal counter size');
            var mask = Math.pow(2, size) - 1;
            this.asm.set_mask(0, 0, mask / 0x100000000 | 0, mask | 0);
          } else {
            size = 48;
            this.asm.set_mask(0, 0, 0xffff, 0xffffffff);
          }
          if (nonce !== undefined) {
            var len = nonce.length;
            if (!len || len > 16) throw new _errors.IllegalArgumentError('illegal nonce size');
            var view = new DataView(new ArrayBuffer(16));
            new Uint8Array(view.buffer).set(nonce);
            this.asm.set_nonce(view.getUint32(0), view.getUint32(4), view.getUint32(8), view.getUint32(12));
          } else {
            throw new Error('nonce is required');
          }
          if (counter !== undefined) {
            if (counter < 0 || counter >= Math.pow(2, size)) throw new _errors.IllegalArgumentError('illegal counter value');
            this.asm.set_counter(0, 0, counter / 0x100000000 | 0, counter | 0);
          }
        };
        return AES_CTR;
      }(_aes.AES);
      exports.AES_CTR = AES_CTR;
    }, {
      "../other/errors": 15,
      "../other/utils": 16,
      "./aes": 4
    }],
    8: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.AES_ECB = undefined;
      var _aes = require('./aes');
      var _utils = require('../other/utils');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var AES_ECB = /** @class */function (_super) {
        __extends(AES_ECB, _super);
        function AES_ECB(key, padding) {
          if (padding === void 0) {
            padding = false;
          }
          return _super.call(this, key, undefined, padding, 'ECB') || this;
        }
        AES_ECB.encrypt = function (data, key, padding) {
          if (padding === void 0) {
            padding = false;
          }
          return new AES_ECB(key, padding).encrypt(data);
        };
        AES_ECB.decrypt = function (data, key, padding) {
          if (padding === void 0) {
            padding = false;
          }
          return new AES_ECB(key, padding).decrypt(data);
        };
        AES_ECB.prototype.encrypt = function (data) {
          var r1 = this.AES_Encrypt_process(data);
          var r2 = this.AES_Encrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        AES_ECB.prototype.decrypt = function (data) {
          var r1 = this.AES_Decrypt_process(data);
          var r2 = this.AES_Decrypt_finish();
          return (0, _utils.joinBytes)(r1, r2);
        };
        return AES_ECB;
      }(_aes.AES);
      exports.AES_ECB = AES_ECB;
    }, {
      "../other/utils": 16,
      "./aes": 4
    }],
    9: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.AES_GCM = undefined;
      var _errors = require('../other/errors');
      var _utils = require('../other/utils');
      var _aes = require('./aes');
      var _aes2 = require('./aes.asm');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var _AES_GCM_data_maxLength = 68719476704; // 2^36 - 2^5
      var AES_GCM = /** @class */function (_super) {
        __extends(AES_GCM, _super);
        function AES_GCM(key, nonce, adata, tagSize) {
          if (tagSize === void 0) {
            tagSize = 16;
          }
          var _this = _super.call(this, key, undefined, false, 'CTR') || this;
          _this.tagSize = tagSize;
          _this.gamma0 = 0;
          _this.counter = 1; // Init GCM
          _this.asm.gcm_init(); // Tag size
          if (_this.tagSize < 4 || _this.tagSize > 16) throw new _errors.IllegalArgumentError('illegal tagSize value'); // Nonce
          var noncelen = nonce.length || 0;
          var noncebuf = new Uint8Array(16);
          if (noncelen !== 12) {
            _this._gcm_mac_process(nonce);
            _this.heap[0] = 0;
            _this.heap[1] = 0;
            _this.heap[2] = 0;
            _this.heap[3] = 0;
            _this.heap[4] = 0;
            _this.heap[5] = 0;
            _this.heap[6] = 0;
            _this.heap[7] = 0;
            _this.heap[8] = 0;
            _this.heap[9] = 0;
            _this.heap[10] = 0;
            _this.heap[11] = noncelen >>> 29;
            _this.heap[12] = noncelen >>> 21 & 255;
            _this.heap[13] = noncelen >>> 13 & 255;
            _this.heap[14] = noncelen >>> 5 & 255;
            _this.heap[15] = noncelen << 3 & 255;
            _this.asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA, 16);
            _this.asm.get_iv(_aes2.AES_asm.HEAP_DATA);
            _this.asm.set_iv(0, 0, 0, 0);
            noncebuf.set(_this.heap.subarray(0, 16));
          } else {
            noncebuf.set(nonce);
            noncebuf[15] = 1;
          }
          var nonceview = new DataView(noncebuf.buffer);
          _this.gamma0 = nonceview.getUint32(12);
          _this.asm.set_nonce(nonceview.getUint32(0), nonceview.getUint32(4), nonceview.getUint32(8), 0);
          _this.asm.set_mask(0, 0, 0, 0xffffffff); // Associated data
          if (adata !== undefined) {
            if (adata.length > _AES_GCM_data_maxLength) throw new _errors.IllegalArgumentError('illegal adata length');
            if (adata.length) {
              _this.adata = adata;
              _this._gcm_mac_process(adata);
            } else {
              _this.adata = undefined;
            }
          } else {
            _this.adata = undefined;
          } // Counter
          if (_this.counter < 1 || _this.counter > 0xffffffff) throw new RangeError('counter must be a positive 32-bit integer');
          _this.asm.set_counter(0, 0, 0, _this.gamma0 + _this.counter | 0);
          return _this;
        }
        AES_GCM.encrypt = function (cleartext, key, nonce, adata, tagsize) {
          return new AES_GCM(key, nonce, adata, tagsize).encrypt(cleartext);
        };
        AES_GCM.decrypt = function (ciphertext, key, nonce, adata, tagsize) {
          return new AES_GCM(key, nonce, adata, tagsize).decrypt(ciphertext);
        };
        AES_GCM.prototype.encrypt = function (data) {
          return this.AES_GCM_encrypt(data);
        };
        AES_GCM.prototype.decrypt = function (data) {
          return this.AES_GCM_decrypt(data);
        };
        AES_GCM.prototype.AES_GCM_Encrypt_process = function (data) {
          var dpos = 0;
          var dlen = data.length || 0;
          var asm = this.asm;
          var heap = this.heap;
          var counter = this.counter;
          var pos = this.pos;
          var len = this.len;
          var rpos = 0;
          var rlen = len + dlen & -16;
          var wlen = 0;
          if ((counter - 1 << 4) + len + dlen > _AES_GCM_data_maxLength) throw new RangeError('counter overflow');
          var result = new Uint8Array(rlen);
          while (dlen > 0) {
            wlen = (0, _utils._heap_write)(heap, pos + len, data, dpos, dlen);
            len += wlen;
            dpos += wlen;
            dlen -= wlen;
            wlen = asm.cipher(_aes2.AES_asm.ENC.CTR, _aes2.AES_asm.HEAP_DATA + pos, len);
            wlen = asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA + pos, wlen);
            if (wlen) result.set(heap.subarray(pos, pos + wlen), rpos);
            counter += wlen >>> 4;
            rpos += wlen;
            if (wlen < len) {
              pos += wlen;
              len -= wlen;
            } else {
              pos = 0;
              len = 0;
            }
          }
          this.counter = counter;
          this.pos = pos;
          this.len = len;
          return result;
        };
        AES_GCM.prototype.AES_GCM_Encrypt_finish = function () {
          var asm = this.asm;
          var heap = this.heap;
          var counter = this.counter;
          var tagSize = this.tagSize;
          var adata = this.adata;
          var pos = this.pos;
          var len = this.len;
          var result = new Uint8Array(len + tagSize);
          asm.cipher(_aes2.AES_asm.ENC.CTR, _aes2.AES_asm.HEAP_DATA + pos, len + 15 & -16);
          if (len) result.set(heap.subarray(pos, pos + len));
          var i = len;
          for (; i & 15; i++) {
            heap[pos + i] = 0;
          }
          asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA + pos, i);
          var alen = adata !== undefined ? adata.length : 0;
          var clen = (counter - 1 << 4) + len;
          heap[0] = 0;
          heap[1] = 0;
          heap[2] = 0;
          heap[3] = alen >>> 29;
          heap[4] = alen >>> 21;
          heap[5] = alen >>> 13 & 255;
          heap[6] = alen >>> 5 & 255;
          heap[7] = alen << 3 & 255;
          heap[8] = heap[9] = heap[10] = 0;
          heap[11] = clen >>> 29;
          heap[12] = clen >>> 21 & 255;
          heap[13] = clen >>> 13 & 255;
          heap[14] = clen >>> 5 & 255;
          heap[15] = clen << 3 & 255;
          asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA, 16);
          asm.get_iv(_aes2.AES_asm.HEAP_DATA);
          asm.set_counter(0, 0, 0, this.gamma0);
          asm.cipher(_aes2.AES_asm.ENC.CTR, _aes2.AES_asm.HEAP_DATA, 16);
          result.set(heap.subarray(0, tagSize), len);
          this.counter = 1;
          this.pos = 0;
          this.len = 0;
          return result;
        };
        AES_GCM.prototype.AES_GCM_Decrypt_process = function (data) {
          var dpos = 0;
          var dlen = data.length || 0;
          var asm = this.asm;
          var heap = this.heap;
          var counter = this.counter;
          var tagSize = this.tagSize;
          var pos = this.pos;
          var len = this.len;
          var rpos = 0;
          var rlen = len + dlen > tagSize ? len + dlen - tagSize & -16 : 0;
          var tlen = len + dlen - rlen;
          var wlen = 0;
          if ((counter - 1 << 4) + len + dlen > _AES_GCM_data_maxLength) throw new RangeError('counter overflow');
          var result = new Uint8Array(rlen);
          while (dlen > tlen) {
            wlen = (0, _utils._heap_write)(heap, pos + len, data, dpos, dlen - tlen);
            len += wlen;
            dpos += wlen;
            dlen -= wlen;
            wlen = asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA + pos, wlen);
            wlen = asm.cipher(_aes2.AES_asm.DEC.CTR, _aes2.AES_asm.HEAP_DATA + pos, wlen);
            if (wlen) result.set(heap.subarray(pos, pos + wlen), rpos);
            counter += wlen >>> 4;
            rpos += wlen;
            pos = 0;
            len = 0;
          }
          if (dlen > 0) {
            len += (0, _utils._heap_write)(heap, 0, data, dpos, dlen);
          }
          this.counter = counter;
          this.pos = pos;
          this.len = len;
          return result;
        };
        AES_GCM.prototype.AES_GCM_Decrypt_finish = function () {
          var asm = this.asm;
          var heap = this.heap;
          var tagSize = this.tagSize;
          var adata = this.adata;
          var counter = this.counter;
          var pos = this.pos;
          var len = this.len;
          var rlen = len - tagSize;
          if (len < tagSize) throw new _errors.IllegalStateError('authentication tag not found');
          var result = new Uint8Array(rlen);
          var atag = new Uint8Array(heap.subarray(pos + rlen, pos + len));
          var i = rlen;
          for (; i & 15; i++) {
            heap[pos + i] = 0;
          }
          asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA + pos, i);
          asm.cipher(_aes2.AES_asm.DEC.CTR, _aes2.AES_asm.HEAP_DATA + pos, i);
          if (rlen) result.set(heap.subarray(pos, pos + rlen));
          var alen = adata !== undefined ? adata.length : 0;
          var clen = (counter - 1 << 4) + len - tagSize;
          heap[0] = 0;
          heap[1] = 0;
          heap[2] = 0;
          heap[3] = alen >>> 29;
          heap[4] = alen >>> 21;
          heap[5] = alen >>> 13 & 255;
          heap[6] = alen >>> 5 & 255;
          heap[7] = alen << 3 & 255;
          heap[8] = heap[9] = heap[10] = 0;
          heap[11] = clen >>> 29;
          heap[12] = clen >>> 21 & 255;
          heap[13] = clen >>> 13 & 255;
          heap[14] = clen >>> 5 & 255;
          heap[15] = clen << 3 & 255;
          asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA, 16);
          asm.get_iv(_aes2.AES_asm.HEAP_DATA);
          asm.set_counter(0, 0, 0, this.gamma0);
          asm.cipher(_aes2.AES_asm.ENC.CTR, _aes2.AES_asm.HEAP_DATA, 16);
          var acheck = 0;
          for (var i_1 = 0; i_1 < tagSize; ++i_1) {
            acheck |= atag[i_1] ^ heap[i_1];
          }
          if (acheck) throw new _errors.SecurityError('data integrity check failed');
          this.counter = 1;
          this.pos = 0;
          this.len = 0;
          return result;
        };
        AES_GCM.prototype.AES_GCM_decrypt = function (data) {
          var result1 = this.AES_GCM_Decrypt_process(data);
          var result2 = this.AES_GCM_Decrypt_finish();
          var result = new Uint8Array(result1.length + result2.length);
          if (result1.length) result.set(result1);
          if (result2.length) result.set(result2, result1.length);
          return result;
        };
        AES_GCM.prototype.AES_GCM_encrypt = function (data) {
          var result1 = this.AES_GCM_Encrypt_process(data);
          var result2 = this.AES_GCM_Encrypt_finish();
          var result = new Uint8Array(result1.length + result2.length);
          if (result1.length) result.set(result1);
          if (result2.length) result.set(result2, result1.length);
          return result;
        };
        AES_GCM.prototype._gcm_mac_process = function (data) {
          var heap = this.heap;
          var asm = this.asm;
          var dpos = 0;
          var dlen = data.length || 0;
          var wlen = 0;
          while (dlen > 0) {
            wlen = (0, _utils._heap_write)(heap, 0, data, dpos, dlen);
            dpos += wlen;
            dlen -= wlen;
            while (wlen & 15) {
              heap[wlen++] = 0;
            }
            asm.mac(_aes2.AES_asm.MAC.GCM, _aes2.AES_asm.HEAP_DATA, wlen);
          }
        };
        return AES_GCM;
      }(_aes.AES);
      exports.AES_GCM = AES_GCM;
    }, {
      "../other/errors": 15,
      "../other/utils": 16,
      "./aes": 4,
      "./aes.asm": 3
    }],
    10: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.Hash = undefined;
      var _utils = require('../other/utils');
      var _errors = require('../other/errors');
      var Hash = /** @class */function () {
        function Hash() {
          this.pos = 0;
          this.len = 0;
          this.acquire_asm();
        }
        Hash.prototype.acquire_asm = function () {
          if (this.heap === undefined && this.asm === undefined) {
            this.heap = this.constructor.heap_pool.pop() || (0, _utils._heap_init)();
            this.asm = this.constructor.asm_pool.pop() || this.constructor.asm_function({
              Uint8Array: Uint8Array
            }, null, this.heap.buffer);
            this.reset();
          }
        };
        Hash.prototype.release_asm = function () {
          this.constructor.heap_pool.push(this.heap);
          ;
          this.constructor.asm_pool.push(this.asm);
          this.heap = undefined;
          this.asm = undefined;
        };
        Hash.prototype.reset = function () {
          this.acquire_asm();
          this.result = null;
          this.pos = 0;
          this.len = 0;
          this.asm.reset();
          return this;
        };
        Hash.prototype.process = function (data) {
          if (this.result !== null) throw new _errors.IllegalStateError('state must be reset before processing new data');
          this.acquire_asm();
          var asm = this.asm;
          var heap = this.heap;
          var hpos = this.pos;
          var hlen = this.len;
          var dpos = 0;
          var dlen = data.length;
          var wlen = 0;
          while (dlen > 0) {
            wlen = (0, _utils._heap_write)(heap, hpos + hlen, data, dpos, dlen);
            hlen += wlen;
            dpos += wlen;
            dlen -= wlen;
            wlen = asm.process(hpos, hlen);
            hpos += wlen;
            hlen -= wlen;
            if (!hlen) hpos = 0;
          }
          this.pos = hpos;
          this.len = hlen;
          return this;
        };
        Hash.prototype.finish = function () {
          if (this.result !== null) throw new _errors.IllegalStateError('state must be reset before processing new data');
          this.acquire_asm();
          this.asm.finish(this.pos, this.len, 0);
          this.result = new Uint8Array(this.HASH_SIZE);
          this.result.set(this.heap.subarray(0, this.HASH_SIZE));
          this.pos = 0;
          this.len = 0;
          this.release_asm();
          return this;
        };
        return Hash;
      }();
      exports.Hash = Hash;
    }, {
      "../other/errors": 15,
      "../other/utils": 16
    }],
    11: [function (require, module, exports) {
      "use strict";

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.sha1_asm = sha1_asm;
      function sha1_asm(stdlib, foreign, buffer) {
        "use asm";

        // SHA256 state
        var H0 = 0,
          H1 = 0,
          H2 = 0,
          H3 = 0,
          H4 = 0,
          TOTAL0 = 0,
          TOTAL1 = 0; // HMAC state
        var I0 = 0,
          I1 = 0,
          I2 = 0,
          I3 = 0,
          I4 = 0,
          O0 = 0,
          O1 = 0,
          O2 = 0,
          O3 = 0,
          O4 = 0; // I/O buffer
        var HEAP = new stdlib.Uint8Array(buffer);
        function _core(w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12, w13, w14, w15) {
          w0 = w0 | 0;
          w1 = w1 | 0;
          w2 = w2 | 0;
          w3 = w3 | 0;
          w4 = w4 | 0;
          w5 = w5 | 0;
          w6 = w6 | 0;
          w7 = w7 | 0;
          w8 = w8 | 0;
          w9 = w9 | 0;
          w10 = w10 | 0;
          w11 = w11 | 0;
          w12 = w12 | 0;
          w13 = w13 | 0;
          w14 = w14 | 0;
          w15 = w15 | 0;
          var a = 0,
            b = 0,
            c = 0,
            d = 0,
            e = 0,
            n = 0,
            t = 0,
            w16 = 0,
            w17 = 0,
            w18 = 0,
            w19 = 0,
            w20 = 0,
            w21 = 0,
            w22 = 0,
            w23 = 0,
            w24 = 0,
            w25 = 0,
            w26 = 0,
            w27 = 0,
            w28 = 0,
            w29 = 0,
            w30 = 0,
            w31 = 0,
            w32 = 0,
            w33 = 0,
            w34 = 0,
            w35 = 0,
            w36 = 0,
            w37 = 0,
            w38 = 0,
            w39 = 0,
            w40 = 0,
            w41 = 0,
            w42 = 0,
            w43 = 0,
            w44 = 0,
            w45 = 0,
            w46 = 0,
            w47 = 0,
            w48 = 0,
            w49 = 0,
            w50 = 0,
            w51 = 0,
            w52 = 0,
            w53 = 0,
            w54 = 0,
            w55 = 0,
            w56 = 0,
            w57 = 0,
            w58 = 0,
            w59 = 0,
            w60 = 0,
            w61 = 0,
            w62 = 0,
            w63 = 0,
            w64 = 0,
            w65 = 0,
            w66 = 0,
            w67 = 0,
            w68 = 0,
            w69 = 0,
            w70 = 0,
            w71 = 0,
            w72 = 0,
            w73 = 0,
            w74 = 0,
            w75 = 0,
            w76 = 0,
            w77 = 0,
            w78 = 0,
            w79 = 0;
          a = H0;
          b = H1;
          c = H2;
          d = H3;
          e = H4; // 0
          t = w0 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 1
          t = w1 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 2
          t = w2 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 3
          t = w3 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 4
          t = w4 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 5
          t = w5 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 6
          t = w6 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 7
          t = w7 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 8
          t = w8 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 9
          t = w9 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 10
          t = w10 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 11
          t = w11 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 12
          t = w12 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 13
          t = w13 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 14
          t = w14 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 15
          t = w15 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 16
          n = w13 ^ w8 ^ w2 ^ w0;
          w16 = n << 1 | n >>> 31;
          t = w16 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 17
          n = w14 ^ w9 ^ w3 ^ w1;
          w17 = n << 1 | n >>> 31;
          t = w17 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 18
          n = w15 ^ w10 ^ w4 ^ w2;
          w18 = n << 1 | n >>> 31;
          t = w18 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 19
          n = w16 ^ w11 ^ w5 ^ w3;
          w19 = n << 1 | n >>> 31;
          t = w19 + (a << 5 | a >>> 27) + e + (b & c | ~b & d) + 0x5a827999 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 20
          n = w17 ^ w12 ^ w6 ^ w4;
          w20 = n << 1 | n >>> 31;
          t = w20 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 21
          n = w18 ^ w13 ^ w7 ^ w5;
          w21 = n << 1 | n >>> 31;
          t = w21 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 22
          n = w19 ^ w14 ^ w8 ^ w6;
          w22 = n << 1 | n >>> 31;
          t = w22 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 23
          n = w20 ^ w15 ^ w9 ^ w7;
          w23 = n << 1 | n >>> 31;
          t = w23 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 24
          n = w21 ^ w16 ^ w10 ^ w8;
          w24 = n << 1 | n >>> 31;
          t = w24 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 25
          n = w22 ^ w17 ^ w11 ^ w9;
          w25 = n << 1 | n >>> 31;
          t = w25 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 26
          n = w23 ^ w18 ^ w12 ^ w10;
          w26 = n << 1 | n >>> 31;
          t = w26 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 27
          n = w24 ^ w19 ^ w13 ^ w11;
          w27 = n << 1 | n >>> 31;
          t = w27 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 28
          n = w25 ^ w20 ^ w14 ^ w12;
          w28 = n << 1 | n >>> 31;
          t = w28 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 29
          n = w26 ^ w21 ^ w15 ^ w13;
          w29 = n << 1 | n >>> 31;
          t = w29 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 30
          n = w27 ^ w22 ^ w16 ^ w14;
          w30 = n << 1 | n >>> 31;
          t = w30 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 31
          n = w28 ^ w23 ^ w17 ^ w15;
          w31 = n << 1 | n >>> 31;
          t = w31 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 32
          n = w29 ^ w24 ^ w18 ^ w16;
          w32 = n << 1 | n >>> 31;
          t = w32 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 33
          n = w30 ^ w25 ^ w19 ^ w17;
          w33 = n << 1 | n >>> 31;
          t = w33 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 34
          n = w31 ^ w26 ^ w20 ^ w18;
          w34 = n << 1 | n >>> 31;
          t = w34 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 35
          n = w32 ^ w27 ^ w21 ^ w19;
          w35 = n << 1 | n >>> 31;
          t = w35 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 36
          n = w33 ^ w28 ^ w22 ^ w20;
          w36 = n << 1 | n >>> 31;
          t = w36 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 37
          n = w34 ^ w29 ^ w23 ^ w21;
          w37 = n << 1 | n >>> 31;
          t = w37 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 38
          n = w35 ^ w30 ^ w24 ^ w22;
          w38 = n << 1 | n >>> 31;
          t = w38 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 39
          n = w36 ^ w31 ^ w25 ^ w23;
          w39 = n << 1 | n >>> 31;
          t = w39 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) + 0x6ed9eba1 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 40
          n = w37 ^ w32 ^ w26 ^ w24;
          w40 = n << 1 | n >>> 31;
          t = w40 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 41
          n = w38 ^ w33 ^ w27 ^ w25;
          w41 = n << 1 | n >>> 31;
          t = w41 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 42
          n = w39 ^ w34 ^ w28 ^ w26;
          w42 = n << 1 | n >>> 31;
          t = w42 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 43
          n = w40 ^ w35 ^ w29 ^ w27;
          w43 = n << 1 | n >>> 31;
          t = w43 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 44
          n = w41 ^ w36 ^ w30 ^ w28;
          w44 = n << 1 | n >>> 31;
          t = w44 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 45
          n = w42 ^ w37 ^ w31 ^ w29;
          w45 = n << 1 | n >>> 31;
          t = w45 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 46
          n = w43 ^ w38 ^ w32 ^ w30;
          w46 = n << 1 | n >>> 31;
          t = w46 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 47
          n = w44 ^ w39 ^ w33 ^ w31;
          w47 = n << 1 | n >>> 31;
          t = w47 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 48
          n = w45 ^ w40 ^ w34 ^ w32;
          w48 = n << 1 | n >>> 31;
          t = w48 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 49
          n = w46 ^ w41 ^ w35 ^ w33;
          w49 = n << 1 | n >>> 31;
          t = w49 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 50
          n = w47 ^ w42 ^ w36 ^ w34;
          w50 = n << 1 | n >>> 31;
          t = w50 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 51
          n = w48 ^ w43 ^ w37 ^ w35;
          w51 = n << 1 | n >>> 31;
          t = w51 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 52
          n = w49 ^ w44 ^ w38 ^ w36;
          w52 = n << 1 | n >>> 31;
          t = w52 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 53
          n = w50 ^ w45 ^ w39 ^ w37;
          w53 = n << 1 | n >>> 31;
          t = w53 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 54
          n = w51 ^ w46 ^ w40 ^ w38;
          w54 = n << 1 | n >>> 31;
          t = w54 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 55
          n = w52 ^ w47 ^ w41 ^ w39;
          w55 = n << 1 | n >>> 31;
          t = w55 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 56
          n = w53 ^ w48 ^ w42 ^ w40;
          w56 = n << 1 | n >>> 31;
          t = w56 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 57
          n = w54 ^ w49 ^ w43 ^ w41;
          w57 = n << 1 | n >>> 31;
          t = w57 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 58
          n = w55 ^ w50 ^ w44 ^ w42;
          w58 = n << 1 | n >>> 31;
          t = w58 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 59
          n = w56 ^ w51 ^ w45 ^ w43;
          w59 = n << 1 | n >>> 31;
          t = w59 + (a << 5 | a >>> 27) + e + (b & c | b & d | c & d) - 0x70e44324 | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 60
          n = w57 ^ w52 ^ w46 ^ w44;
          w60 = n << 1 | n >>> 31;
          t = w60 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 61
          n = w58 ^ w53 ^ w47 ^ w45;
          w61 = n << 1 | n >>> 31;
          t = w61 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 62
          n = w59 ^ w54 ^ w48 ^ w46;
          w62 = n << 1 | n >>> 31;
          t = w62 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 63
          n = w60 ^ w55 ^ w49 ^ w47;
          w63 = n << 1 | n >>> 31;
          t = w63 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 64
          n = w61 ^ w56 ^ w50 ^ w48;
          w64 = n << 1 | n >>> 31;
          t = w64 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 65
          n = w62 ^ w57 ^ w51 ^ w49;
          w65 = n << 1 | n >>> 31;
          t = w65 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 66
          n = w63 ^ w58 ^ w52 ^ w50;
          w66 = n << 1 | n >>> 31;
          t = w66 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 67
          n = w64 ^ w59 ^ w53 ^ w51;
          w67 = n << 1 | n >>> 31;
          t = w67 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 68
          n = w65 ^ w60 ^ w54 ^ w52;
          w68 = n << 1 | n >>> 31;
          t = w68 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 69
          n = w66 ^ w61 ^ w55 ^ w53;
          w69 = n << 1 | n >>> 31;
          t = w69 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 70
          n = w67 ^ w62 ^ w56 ^ w54;
          w70 = n << 1 | n >>> 31;
          t = w70 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 71
          n = w68 ^ w63 ^ w57 ^ w55;
          w71 = n << 1 | n >>> 31;
          t = w71 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 72
          n = w69 ^ w64 ^ w58 ^ w56;
          w72 = n << 1 | n >>> 31;
          t = w72 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 73
          n = w70 ^ w65 ^ w59 ^ w57;
          w73 = n << 1 | n >>> 31;
          t = w73 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 74
          n = w71 ^ w66 ^ w60 ^ w58;
          w74 = n << 1 | n >>> 31;
          t = w74 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 75
          n = w72 ^ w67 ^ w61 ^ w59;
          w75 = n << 1 | n >>> 31;
          t = w75 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 76
          n = w73 ^ w68 ^ w62 ^ w60;
          w76 = n << 1 | n >>> 31;
          t = w76 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 77
          n = w74 ^ w69 ^ w63 ^ w61;
          w77 = n << 1 | n >>> 31;
          t = w77 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 78
          n = w75 ^ w70 ^ w64 ^ w62;
          w78 = n << 1 | n >>> 31;
          t = w78 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t; // 79
          n = w76 ^ w71 ^ w65 ^ w63;
          w79 = n << 1 | n >>> 31;
          t = w79 + (a << 5 | a >>> 27) + e + (b ^ c ^ d) - 0x359d3e2a | 0;
          e = d;
          d = c;
          c = b << 30 | b >>> 2;
          b = a;
          a = t;
          H0 = H0 + a | 0;
          H1 = H1 + b | 0;
          H2 = H2 + c | 0;
          H3 = H3 + d | 0;
          H4 = H4 + e | 0;
        }
        function _core_heap(offset) {
          offset = offset | 0;
          _core(HEAP[offset | 0] << 24 | HEAP[offset | 1] << 16 | HEAP[offset | 2] << 8 | HEAP[offset | 3], HEAP[offset | 4] << 24 | HEAP[offset | 5] << 16 | HEAP[offset | 6] << 8 | HEAP[offset | 7], HEAP[offset | 8] << 24 | HEAP[offset | 9] << 16 | HEAP[offset | 10] << 8 | HEAP[offset | 11], HEAP[offset | 12] << 24 | HEAP[offset | 13] << 16 | HEAP[offset | 14] << 8 | HEAP[offset | 15], HEAP[offset | 16] << 24 | HEAP[offset | 17] << 16 | HEAP[offset | 18] << 8 | HEAP[offset | 19], HEAP[offset | 20] << 24 | HEAP[offset | 21] << 16 | HEAP[offset | 22] << 8 | HEAP[offset | 23], HEAP[offset | 24] << 24 | HEAP[offset | 25] << 16 | HEAP[offset | 26] << 8 | HEAP[offset | 27], HEAP[offset | 28] << 24 | HEAP[offset | 29] << 16 | HEAP[offset | 30] << 8 | HEAP[offset | 31], HEAP[offset | 32] << 24 | HEAP[offset | 33] << 16 | HEAP[offset | 34] << 8 | HEAP[offset | 35], HEAP[offset | 36] << 24 | HEAP[offset | 37] << 16 | HEAP[offset | 38] << 8 | HEAP[offset | 39], HEAP[offset | 40] << 24 | HEAP[offset | 41] << 16 | HEAP[offset | 42] << 8 | HEAP[offset | 43], HEAP[offset | 44] << 24 | HEAP[offset | 45] << 16 | HEAP[offset | 46] << 8 | HEAP[offset | 47], HEAP[offset | 48] << 24 | HEAP[offset | 49] << 16 | HEAP[offset | 50] << 8 | HEAP[offset | 51], HEAP[offset | 52] << 24 | HEAP[offset | 53] << 16 | HEAP[offset | 54] << 8 | HEAP[offset | 55], HEAP[offset | 56] << 24 | HEAP[offset | 57] << 16 | HEAP[offset | 58] << 8 | HEAP[offset | 59], HEAP[offset | 60] << 24 | HEAP[offset | 61] << 16 | HEAP[offset | 62] << 8 | HEAP[offset | 63]);
        } // offset — multiple of 32
        function _state_to_heap(output) {
          output = output | 0;
          HEAP[output | 0] = H0 >>> 24;
          HEAP[output | 1] = H0 >>> 16 & 255;
          HEAP[output | 2] = H0 >>> 8 & 255;
          HEAP[output | 3] = H0 & 255;
          HEAP[output | 4] = H1 >>> 24;
          HEAP[output | 5] = H1 >>> 16 & 255;
          HEAP[output | 6] = H1 >>> 8 & 255;
          HEAP[output | 7] = H1 & 255;
          HEAP[output | 8] = H2 >>> 24;
          HEAP[output | 9] = H2 >>> 16 & 255;
          HEAP[output | 10] = H2 >>> 8 & 255;
          HEAP[output | 11] = H2 & 255;
          HEAP[output | 12] = H3 >>> 24;
          HEAP[output | 13] = H3 >>> 16 & 255;
          HEAP[output | 14] = H3 >>> 8 & 255;
          HEAP[output | 15] = H3 & 255;
          HEAP[output | 16] = H4 >>> 24;
          HEAP[output | 17] = H4 >>> 16 & 255;
          HEAP[output | 18] = H4 >>> 8 & 255;
          HEAP[output | 19] = H4 & 255;
        }
        function reset() {
          H0 = 0x67452301;
          H1 = 0xefcdab89;
          H2 = 0x98badcfe;
          H3 = 0x10325476;
          H4 = 0xc3d2e1f0;
          TOTAL0 = TOTAL1 = 0;
        }
        function init(h0, h1, h2, h3, h4, total0, total1) {
          h0 = h0 | 0;
          h1 = h1 | 0;
          h2 = h2 | 0;
          h3 = h3 | 0;
          h4 = h4 | 0;
          total0 = total0 | 0;
          total1 = total1 | 0;
          H0 = h0;
          H1 = h1;
          H2 = h2;
          H3 = h3;
          H4 = h4;
          TOTAL0 = total0;
          TOTAL1 = total1;
        } // offset — multiple of 64
        function process(offset, length) {
          offset = offset | 0;
          length = length | 0;
          var hashed = 0;
          if (offset & 63) return -1;
          while ((length | 0) >= 64) {
            _core_heap(offset);
            offset = offset + 64 | 0;
            length = length - 64 | 0;
            hashed = hashed + 64 | 0;
          }
          TOTAL0 = TOTAL0 + hashed | 0;
          if (TOTAL0 >>> 0 < hashed >>> 0) TOTAL1 = TOTAL1 + 1 | 0;
          return hashed | 0;
        } // offset — multiple of 64
        // output — multiple of 32
        function finish(offset, length, output) {
          offset = offset | 0;
          length = length | 0;
          output = output | 0;
          var hashed = 0,
            i = 0;
          if (offset & 63) return -1;
          if (~output) if (output & 31) return -1;
          if ((length | 0) >= 64) {
            hashed = process(offset, length) | 0;
            if ((hashed | 0) == -1) return -1;
            offset = offset + hashed | 0;
            length = length - hashed | 0;
          }
          hashed = hashed + length | 0;
          TOTAL0 = TOTAL0 + length | 0;
          if (TOTAL0 >>> 0 < length >>> 0) TOTAL1 = TOTAL1 + 1 | 0;
          HEAP[offset | length] = 0x80;
          if ((length | 0) >= 56) {
            for (i = length + 1 | 0; (i | 0) < 64; i = i + 1 | 0) {
              HEAP[offset | i] = 0x00;
            }
            _core_heap(offset);
            length = 0;
            HEAP[offset | 0] = 0;
          }
          for (i = length + 1 | 0; (i | 0) < 59; i = i + 1 | 0) {
            HEAP[offset | i] = 0;
          }
          HEAP[offset | 56] = TOTAL1 >>> 21 & 255;
          HEAP[offset | 57] = TOTAL1 >>> 13 & 255;
          HEAP[offset | 58] = TOTAL1 >>> 5 & 255;
          HEAP[offset | 59] = TOTAL1 << 3 & 255 | TOTAL0 >>> 29;
          HEAP[offset | 60] = TOTAL0 >>> 21 & 255;
          HEAP[offset | 61] = TOTAL0 >>> 13 & 255;
          HEAP[offset | 62] = TOTAL0 >>> 5 & 255;
          HEAP[offset | 63] = TOTAL0 << 3 & 255;
          _core_heap(offset);
          if (~output) _state_to_heap(output);
          return hashed | 0;
        }
        function hmac_reset() {
          H0 = I0;
          H1 = I1;
          H2 = I2;
          H3 = I3;
          H4 = I4;
          TOTAL0 = 64;
          TOTAL1 = 0;
        }
        function _hmac_opad() {
          H0 = O0;
          H1 = O1;
          H2 = O2;
          H3 = O3;
          H4 = O4;
          TOTAL0 = 64;
          TOTAL1 = 0;
        }
        function hmac_init(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15) {
          p0 = p0 | 0;
          p1 = p1 | 0;
          p2 = p2 | 0;
          p3 = p3 | 0;
          p4 = p4 | 0;
          p5 = p5 | 0;
          p6 = p6 | 0;
          p7 = p7 | 0;
          p8 = p8 | 0;
          p9 = p9 | 0;
          p10 = p10 | 0;
          p11 = p11 | 0;
          p12 = p12 | 0;
          p13 = p13 | 0;
          p14 = p14 | 0;
          p15 = p15 | 0; // opad
          reset();
          _core(p0 ^ 0x5c5c5c5c, p1 ^ 0x5c5c5c5c, p2 ^ 0x5c5c5c5c, p3 ^ 0x5c5c5c5c, p4 ^ 0x5c5c5c5c, p5 ^ 0x5c5c5c5c, p6 ^ 0x5c5c5c5c, p7 ^ 0x5c5c5c5c, p8 ^ 0x5c5c5c5c, p9 ^ 0x5c5c5c5c, p10 ^ 0x5c5c5c5c, p11 ^ 0x5c5c5c5c, p12 ^ 0x5c5c5c5c, p13 ^ 0x5c5c5c5c, p14 ^ 0x5c5c5c5c, p15 ^ 0x5c5c5c5c);
          O0 = H0;
          O1 = H1;
          O2 = H2;
          O3 = H3;
          O4 = H4; // ipad
          reset();
          _core(p0 ^ 0x36363636, p1 ^ 0x36363636, p2 ^ 0x36363636, p3 ^ 0x36363636, p4 ^ 0x36363636, p5 ^ 0x36363636, p6 ^ 0x36363636, p7 ^ 0x36363636, p8 ^ 0x36363636, p9 ^ 0x36363636, p10 ^ 0x36363636, p11 ^ 0x36363636, p12 ^ 0x36363636, p13 ^ 0x36363636, p14 ^ 0x36363636, p15 ^ 0x36363636);
          I0 = H0;
          I1 = H1;
          I2 = H2;
          I3 = H3;
          I4 = H4;
          TOTAL0 = 64;
          TOTAL1 = 0;
        } // offset — multiple of 64
        // output — multiple of 32
        function hmac_finish(offset, length, output) {
          offset = offset | 0;
          length = length | 0;
          output = output | 0;
          var t0 = 0,
            t1 = 0,
            t2 = 0,
            t3 = 0,
            t4 = 0,
            hashed = 0;
          if (offset & 63) return -1;
          if (~output) if (output & 31) return -1;
          hashed = finish(offset, length, -1) | 0;
          t0 = H0, t1 = H1, t2 = H2, t3 = H3, t4 = H4;
          _hmac_opad();
          _core(t0, t1, t2, t3, t4, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 672);
          if (~output) _state_to_heap(output);
          return hashed | 0;
        } // salt is assumed to be already processed
        // offset — multiple of 64
        // output — multiple of 32
        function pbkdf2_generate_block(offset, length, block, count, output) {
          offset = offset | 0;
          length = length | 0;
          block = block | 0;
          count = count | 0;
          output = output | 0;
          var h0 = 0,
            h1 = 0,
            h2 = 0,
            h3 = 0,
            h4 = 0,
            t0 = 0,
            t1 = 0,
            t2 = 0,
            t3 = 0,
            t4 = 0;
          if (offset & 63) return -1;
          if (~output) if (output & 31) return -1; // pad block number into heap
          // FIXME probable OOB write
          HEAP[offset + length | 0] = block >>> 24;
          HEAP[offset + length + 1 | 0] = block >>> 16 & 255;
          HEAP[offset + length + 2 | 0] = block >>> 8 & 255;
          HEAP[offset + length + 3 | 0] = block & 255; // finish first iteration
          hmac_finish(offset, length + 4 | 0, -1) | 0;
          h0 = t0 = H0, h1 = t1 = H1, h2 = t2 = H2, h3 = t3 = H3, h4 = t4 = H4;
          count = count - 1 | 0; // perform the rest iterations
          while ((count | 0) > 0) {
            hmac_reset();
            _core(t0, t1, t2, t3, t4, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 672);
            t0 = H0, t1 = H1, t2 = H2, t3 = H3, t4 = H4;
            _hmac_opad();
            _core(t0, t1, t2, t3, t4, 0x80000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 672);
            t0 = H0, t1 = H1, t2 = H2, t3 = H3, t4 = H4;
            h0 = h0 ^ H0;
            h1 = h1 ^ H1;
            h2 = h2 ^ H2;
            h3 = h3 ^ H3;
            h4 = h4 ^ H4;
            count = count - 1 | 0;
          }
          H0 = h0;
          H1 = h1;
          H2 = h2;
          H3 = h3;
          H4 = h4;
          if (~output) _state_to_heap(output);
          return 0;
        }
        return {
          // SHA1
          reset: reset,
          init: init,
          process: process,
          finish: finish,
          // HMAC-SHA1
          hmac_reset: hmac_reset,
          hmac_init: hmac_init,
          hmac_finish: hmac_finish,
          // PBKDF2-HMAC-SHA1
          pbkdf2_generate_block: pbkdf2_generate_block
        };
      }
    }, {}],
    12: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.Sha1 = exports._sha1_hash_size = exports._sha1_block_size = undefined;
      var _sha = require('./sha1.asm');
      var _hash = require('../hash');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var _sha1_block_size = exports._sha1_block_size = 64;
      var _sha1_hash_size = exports._sha1_hash_size = 20;
      var Sha1 = /** @class */function (_super) {
        __extends(Sha1, _super);
        function Sha1() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.NAME = 'sha1';
          _this.BLOCK_SIZE = _sha1_block_size;
          _this.HASH_SIZE = _sha1_hash_size;
          return _this;
        }
        Sha1.bytes = function (data) {
          return new Sha1().process(data).finish().result;
        };
        Sha1.NAME = 'sha1';
        Sha1.heap_pool = [];
        Sha1.asm_pool = [];
        Sha1.asm_function = _sha.sha1_asm;
        return Sha1;
      }(_hash.Hash);
      exports.Sha1 = Sha1;
    }, {
      "../hash": 10,
      "./sha1.asm": 11
    }],
    13: [function (require, module, exports) {
      "use strict";

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.sha256_asm = sha256_asm;
      function sha256_asm(stdlib, foreign, buffer) {
        "use asm";

        // SHA256 state
        var H0 = 0,
          H1 = 0,
          H2 = 0,
          H3 = 0,
          H4 = 0,
          H5 = 0,
          H6 = 0,
          H7 = 0,
          TOTAL0 = 0,
          TOTAL1 = 0; // HMAC state
        var I0 = 0,
          I1 = 0,
          I2 = 0,
          I3 = 0,
          I4 = 0,
          I5 = 0,
          I6 = 0,
          I7 = 0,
          O0 = 0,
          O1 = 0,
          O2 = 0,
          O3 = 0,
          O4 = 0,
          O5 = 0,
          O6 = 0,
          O7 = 0; // I/O buffer
        var HEAP = new stdlib.Uint8Array(buffer);
        function _core(w0, w1, w2, w3, w4, w5, w6, w7, w8, w9, w10, w11, w12, w13, w14, w15) {
          w0 = w0 | 0;
          w1 = w1 | 0;
          w2 = w2 | 0;
          w3 = w3 | 0;
          w4 = w4 | 0;
          w5 = w5 | 0;
          w6 = w6 | 0;
          w7 = w7 | 0;
          w8 = w8 | 0;
          w9 = w9 | 0;
          w10 = w10 | 0;
          w11 = w11 | 0;
          w12 = w12 | 0;
          w13 = w13 | 0;
          w14 = w14 | 0;
          w15 = w15 | 0;
          var a = 0,
            b = 0,
            c = 0,
            d = 0,
            e = 0,
            f = 0,
            g = 0,
            h = 0;
          a = H0;
          b = H1;
          c = H2;
          d = H3;
          e = H4;
          f = H5;
          g = H6;
          h = H7; // 0
          h = w0 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0x428a2f98 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 1
          g = w1 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0x71374491 | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 2
          f = w2 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0xb5c0fbcf | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 3
          e = w3 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0xe9b5dba5 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 4
          d = w4 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0x3956c25b | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 5
          c = w5 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0x59f111f1 | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 6
          b = w6 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0x923f82a4 | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 7
          a = w7 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0xab1c5ed5 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 8
          h = w8 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0xd807aa98 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 9
          g = w9 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0x12835b01 | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 10
          f = w10 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0x243185be | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 11
          e = w11 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0x550c7dc3 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 12
          d = w12 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0x72be5d74 | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 13
          c = w13 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0x80deb1fe | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 14
          b = w14 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0x9bdc06a7 | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 15
          a = w15 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0xc19bf174 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 16
          w0 = (w1 >>> 7 ^ w1 >>> 18 ^ w1 >>> 3 ^ w1 << 25 ^ w1 << 14) + (w14 >>> 17 ^ w14 >>> 19 ^ w14 >>> 10 ^ w14 << 15 ^ w14 << 13) + w0 + w9 | 0;
          h = w0 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0xe49b69c1 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 17
          w1 = (w2 >>> 7 ^ w2 >>> 18 ^ w2 >>> 3 ^ w2 << 25 ^ w2 << 14) + (w15 >>> 17 ^ w15 >>> 19 ^ w15 >>> 10 ^ w15 << 15 ^ w15 << 13) + w1 + w10 | 0;
          g = w1 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0xefbe4786 | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 18
          w2 = (w3 >>> 7 ^ w3 >>> 18 ^ w3 >>> 3 ^ w3 << 25 ^ w3 << 14) + (w0 >>> 17 ^ w0 >>> 19 ^ w0 >>> 10 ^ w0 << 15 ^ w0 << 13) + w2 + w11 | 0;
          f = w2 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0x0fc19dc6 | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 19
          w3 = (w4 >>> 7 ^ w4 >>> 18 ^ w4 >>> 3 ^ w4 << 25 ^ w4 << 14) + (w1 >>> 17 ^ w1 >>> 19 ^ w1 >>> 10 ^ w1 << 15 ^ w1 << 13) + w3 + w12 | 0;
          e = w3 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0x240ca1cc | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 20
          w4 = (w5 >>> 7 ^ w5 >>> 18 ^ w5 >>> 3 ^ w5 << 25 ^ w5 << 14) + (w2 >>> 17 ^ w2 >>> 19 ^ w2 >>> 10 ^ w2 << 15 ^ w2 << 13) + w4 + w13 | 0;
          d = w4 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0x2de92c6f | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 21
          w5 = (w6 >>> 7 ^ w6 >>> 18 ^ w6 >>> 3 ^ w6 << 25 ^ w6 << 14) + (w3 >>> 17 ^ w3 >>> 19 ^ w3 >>> 10 ^ w3 << 15 ^ w3 << 13) + w5 + w14 | 0;
          c = w5 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0x4a7484aa | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 22
          w6 = (w7 >>> 7 ^ w7 >>> 18 ^ w7 >>> 3 ^ w7 << 25 ^ w7 << 14) + (w4 >>> 17 ^ w4 >>> 19 ^ w4 >>> 10 ^ w4 << 15 ^ w4 << 13) + w6 + w15 | 0;
          b = w6 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0x5cb0a9dc | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 23
          w7 = (w8 >>> 7 ^ w8 >>> 18 ^ w8 >>> 3 ^ w8 << 25 ^ w8 << 14) + (w5 >>> 17 ^ w5 >>> 19 ^ w5 >>> 10 ^ w5 << 15 ^ w5 << 13) + w7 + w0 | 0;
          a = w7 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0x76f988da | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 24
          w8 = (w9 >>> 7 ^ w9 >>> 18 ^ w9 >>> 3 ^ w9 << 25 ^ w9 << 14) + (w6 >>> 17 ^ w6 >>> 19 ^ w6 >>> 10 ^ w6 << 15 ^ w6 << 13) + w8 + w1 | 0;
          h = w8 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0x983e5152 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 25
          w9 = (w10 >>> 7 ^ w10 >>> 18 ^ w10 >>> 3 ^ w10 << 25 ^ w10 << 14) + (w7 >>> 17 ^ w7 >>> 19 ^ w7 >>> 10 ^ w7 << 15 ^ w7 << 13) + w9 + w2 | 0;
          g = w9 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0xa831c66d | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 26
          w10 = (w11 >>> 7 ^ w11 >>> 18 ^ w11 >>> 3 ^ w11 << 25 ^ w11 << 14) + (w8 >>> 17 ^ w8 >>> 19 ^ w8 >>> 10 ^ w8 << 15 ^ w8 << 13) + w10 + w3 | 0;
          f = w10 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0xb00327c8 | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 27
          w11 = (w12 >>> 7 ^ w12 >>> 18 ^ w12 >>> 3 ^ w12 << 25 ^ w12 << 14) + (w9 >>> 17 ^ w9 >>> 19 ^ w9 >>> 10 ^ w9 << 15 ^ w9 << 13) + w11 + w4 | 0;
          e = w11 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0xbf597fc7 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 28
          w12 = (w13 >>> 7 ^ w13 >>> 18 ^ w13 >>> 3 ^ w13 << 25 ^ w13 << 14) + (w10 >>> 17 ^ w10 >>> 19 ^ w10 >>> 10 ^ w10 << 15 ^ w10 << 13) + w12 + w5 | 0;
          d = w12 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0xc6e00bf3 | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 29
          w13 = (w14 >>> 7 ^ w14 >>> 18 ^ w14 >>> 3 ^ w14 << 25 ^ w14 << 14) + (w11 >>> 17 ^ w11 >>> 19 ^ w11 >>> 10 ^ w11 << 15 ^ w11 << 13) + w13 + w6 | 0;
          c = w13 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0xd5a79147 | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 30
          w14 = (w15 >>> 7 ^ w15 >>> 18 ^ w15 >>> 3 ^ w15 << 25 ^ w15 << 14) + (w12 >>> 17 ^ w12 >>> 19 ^ w12 >>> 10 ^ w12 << 15 ^ w12 << 13) + w14 + w7 | 0;
          b = w14 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0x06ca6351 | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 31
          w15 = (w0 >>> 7 ^ w0 >>> 18 ^ w0 >>> 3 ^ w0 << 25 ^ w0 << 14) + (w13 >>> 17 ^ w13 >>> 19 ^ w13 >>> 10 ^ w13 << 15 ^ w13 << 13) + w15 + w8 | 0;
          a = w15 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0x14292967 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 32
          w0 = (w1 >>> 7 ^ w1 >>> 18 ^ w1 >>> 3 ^ w1 << 25 ^ w1 << 14) + (w14 >>> 17 ^ w14 >>> 19 ^ w14 >>> 10 ^ w14 << 15 ^ w14 << 13) + w0 + w9 | 0;
          h = w0 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0x27b70a85 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 33
          w1 = (w2 >>> 7 ^ w2 >>> 18 ^ w2 >>> 3 ^ w2 << 25 ^ w2 << 14) + (w15 >>> 17 ^ w15 >>> 19 ^ w15 >>> 10 ^ w15 << 15 ^ w15 << 13) + w1 + w10 | 0;
          g = w1 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0x2e1b2138 | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 34
          w2 = (w3 >>> 7 ^ w3 >>> 18 ^ w3 >>> 3 ^ w3 << 25 ^ w3 << 14) + (w0 >>> 17 ^ w0 >>> 19 ^ w0 >>> 10 ^ w0 << 15 ^ w0 << 13) + w2 + w11 | 0;
          f = w2 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0x4d2c6dfc | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 35
          w3 = (w4 >>> 7 ^ w4 >>> 18 ^ w4 >>> 3 ^ w4 << 25 ^ w4 << 14) + (w1 >>> 17 ^ w1 >>> 19 ^ w1 >>> 10 ^ w1 << 15 ^ w1 << 13) + w3 + w12 | 0;
          e = w3 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0x53380d13 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 36
          w4 = (w5 >>> 7 ^ w5 >>> 18 ^ w5 >>> 3 ^ w5 << 25 ^ w5 << 14) + (w2 >>> 17 ^ w2 >>> 19 ^ w2 >>> 10 ^ w2 << 15 ^ w2 << 13) + w4 + w13 | 0;
          d = w4 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0x650a7354 | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 37
          w5 = (w6 >>> 7 ^ w6 >>> 18 ^ w6 >>> 3 ^ w6 << 25 ^ w6 << 14) + (w3 >>> 17 ^ w3 >>> 19 ^ w3 >>> 10 ^ w3 << 15 ^ w3 << 13) + w5 + w14 | 0;
          c = w5 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0x766a0abb | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 38
          w6 = (w7 >>> 7 ^ w7 >>> 18 ^ w7 >>> 3 ^ w7 << 25 ^ w7 << 14) + (w4 >>> 17 ^ w4 >>> 19 ^ w4 >>> 10 ^ w4 << 15 ^ w4 << 13) + w6 + w15 | 0;
          b = w6 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0x81c2c92e | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 39
          w7 = (w8 >>> 7 ^ w8 >>> 18 ^ w8 >>> 3 ^ w8 << 25 ^ w8 << 14) + (w5 >>> 17 ^ w5 >>> 19 ^ w5 >>> 10 ^ w5 << 15 ^ w5 << 13) + w7 + w0 | 0;
          a = w7 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0x92722c85 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 40
          w8 = (w9 >>> 7 ^ w9 >>> 18 ^ w9 >>> 3 ^ w9 << 25 ^ w9 << 14) + (w6 >>> 17 ^ w6 >>> 19 ^ w6 >>> 10 ^ w6 << 15 ^ w6 << 13) + w8 + w1 | 0;
          h = w8 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0xa2bfe8a1 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 41
          w9 = (w10 >>> 7 ^ w10 >>> 18 ^ w10 >>> 3 ^ w10 << 25 ^ w10 << 14) + (w7 >>> 17 ^ w7 >>> 19 ^ w7 >>> 10 ^ w7 << 15 ^ w7 << 13) + w9 + w2 | 0;
          g = w9 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0xa81a664b | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 42
          w10 = (w11 >>> 7 ^ w11 >>> 18 ^ w11 >>> 3 ^ w11 << 25 ^ w11 << 14) + (w8 >>> 17 ^ w8 >>> 19 ^ w8 >>> 10 ^ w8 << 15 ^ w8 << 13) + w10 + w3 | 0;
          f = w10 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0xc24b8b70 | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 43
          w11 = (w12 >>> 7 ^ w12 >>> 18 ^ w12 >>> 3 ^ w12 << 25 ^ w12 << 14) + (w9 >>> 17 ^ w9 >>> 19 ^ w9 >>> 10 ^ w9 << 15 ^ w9 << 13) + w11 + w4 | 0;
          e = w11 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0xc76c51a3 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 44
          w12 = (w13 >>> 7 ^ w13 >>> 18 ^ w13 >>> 3 ^ w13 << 25 ^ w13 << 14) + (w10 >>> 17 ^ w10 >>> 19 ^ w10 >>> 10 ^ w10 << 15 ^ w10 << 13) + w12 + w5 | 0;
          d = w12 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0xd192e819 | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 45
          w13 = (w14 >>> 7 ^ w14 >>> 18 ^ w14 >>> 3 ^ w14 << 25 ^ w14 << 14) + (w11 >>> 17 ^ w11 >>> 19 ^ w11 >>> 10 ^ w11 << 15 ^ w11 << 13) + w13 + w6 | 0;
          c = w13 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0xd6990624 | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 46
          w14 = (w15 >>> 7 ^ w15 >>> 18 ^ w15 >>> 3 ^ w15 << 25 ^ w15 << 14) + (w12 >>> 17 ^ w12 >>> 19 ^ w12 >>> 10 ^ w12 << 15 ^ w12 << 13) + w14 + w7 | 0;
          b = w14 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0xf40e3585 | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 47
          w15 = (w0 >>> 7 ^ w0 >>> 18 ^ w0 >>> 3 ^ w0 << 25 ^ w0 << 14) + (w13 >>> 17 ^ w13 >>> 19 ^ w13 >>> 10 ^ w13 << 15 ^ w13 << 13) + w15 + w8 | 0;
          a = w15 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0x106aa070 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 48
          w0 = (w1 >>> 7 ^ w1 >>> 18 ^ w1 >>> 3 ^ w1 << 25 ^ w1 << 14) + (w14 >>> 17 ^ w14 >>> 19 ^ w14 >>> 10 ^ w14 << 15 ^ w14 << 13) + w0 + w9 | 0;
          h = w0 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0x19a4c116 | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 49
          w1 = (w2 >>> 7 ^ w2 >>> 18 ^ w2 >>> 3 ^ w2 << 25 ^ w2 << 14) + (w15 >>> 17 ^ w15 >>> 19 ^ w15 >>> 10 ^ w15 << 15 ^ w15 << 13) + w1 + w10 | 0;
          g = w1 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0x1e376c08 | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 50
          w2 = (w3 >>> 7 ^ w3 >>> 18 ^ w3 >>> 3 ^ w3 << 25 ^ w3 << 14) + (w0 >>> 17 ^ w0 >>> 19 ^ w0 >>> 10 ^ w0 << 15 ^ w0 << 13) + w2 + w11 | 0;
          f = w2 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0x2748774c | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 51
          w3 = (w4 >>> 7 ^ w4 >>> 18 ^ w4 >>> 3 ^ w4 << 25 ^ w4 << 14) + (w1 >>> 17 ^ w1 >>> 19 ^ w1 >>> 10 ^ w1 << 15 ^ w1 << 13) + w3 + w12 | 0;
          e = w3 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0x34b0bcb5 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 52
          w4 = (w5 >>> 7 ^ w5 >>> 18 ^ w5 >>> 3 ^ w5 << 25 ^ w5 << 14) + (w2 >>> 17 ^ w2 >>> 19 ^ w2 >>> 10 ^ w2 << 15 ^ w2 << 13) + w4 + w13 | 0;
          d = w4 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0x391c0cb3 | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 53
          w5 = (w6 >>> 7 ^ w6 >>> 18 ^ w6 >>> 3 ^ w6 << 25 ^ w6 << 14) + (w3 >>> 17 ^ w3 >>> 19 ^ w3 >>> 10 ^ w3 << 15 ^ w3 << 13) + w5 + w14 | 0;
          c = w5 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0x4ed8aa4a | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 54
          w6 = (w7 >>> 7 ^ w7 >>> 18 ^ w7 >>> 3 ^ w7 << 25 ^ w7 << 14) + (w4 >>> 17 ^ w4 >>> 19 ^ w4 >>> 10 ^ w4 << 15 ^ w4 << 13) + w6 + w15 | 0;
          b = w6 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0x5b9cca4f | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 55
          w7 = (w8 >>> 7 ^ w8 >>> 18 ^ w8 >>> 3 ^ w8 << 25 ^ w8 << 14) + (w5 >>> 17 ^ w5 >>> 19 ^ w5 >>> 10 ^ w5 << 15 ^ w5 << 13) + w7 + w0 | 0;
          a = w7 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0x682e6ff3 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0; // 56
          w8 = (w9 >>> 7 ^ w9 >>> 18 ^ w9 >>> 3 ^ w9 << 25 ^ w9 << 14) + (w6 >>> 17 ^ w6 >>> 19 ^ w6 >>> 10 ^ w6 << 15 ^ w6 << 13) + w8 + w1 | 0;
          h = w8 + h + (e >>> 6 ^ e >>> 11 ^ e >>> 25 ^ e << 26 ^ e << 21 ^ e << 7) + (g ^ e & (f ^ g)) + 0x748f82ee | 0;
          d = d + h | 0;
          h = h + (a & b ^ c & (a ^ b)) + (a >>> 2 ^ a >>> 13 ^ a >>> 22 ^ a << 30 ^ a << 19 ^ a << 10) | 0; // 57
          w9 = (w10 >>> 7 ^ w10 >>> 18 ^ w10 >>> 3 ^ w10 << 25 ^ w10 << 14) + (w7 >>> 17 ^ w7 >>> 19 ^ w7 >>> 10 ^ w7 << 15 ^ w7 << 13) + w9 + w2 | 0;
          g = w9 + g + (d >>> 6 ^ d >>> 11 ^ d >>> 25 ^ d << 26 ^ d << 21 ^ d << 7) + (f ^ d & (e ^ f)) + 0x78a5636f | 0;
          c = c + g | 0;
          g = g + (h & a ^ b & (h ^ a)) + (h >>> 2 ^ h >>> 13 ^ h >>> 22 ^ h << 30 ^ h << 19 ^ h << 10) | 0; // 58
          w10 = (w11 >>> 7 ^ w11 >>> 18 ^ w11 >>> 3 ^ w11 << 25 ^ w11 << 14) + (w8 >>> 17 ^ w8 >>> 19 ^ w8 >>> 10 ^ w8 << 15 ^ w8 << 13) + w10 + w3 | 0;
          f = w10 + f + (c >>> 6 ^ c >>> 11 ^ c >>> 25 ^ c << 26 ^ c << 21 ^ c << 7) + (e ^ c & (d ^ e)) + 0x84c87814 | 0;
          b = b + f | 0;
          f = f + (g & h ^ a & (g ^ h)) + (g >>> 2 ^ g >>> 13 ^ g >>> 22 ^ g << 30 ^ g << 19 ^ g << 10) | 0; // 59
          w11 = (w12 >>> 7 ^ w12 >>> 18 ^ w12 >>> 3 ^ w12 << 25 ^ w12 << 14) + (w9 >>> 17 ^ w9 >>> 19 ^ w9 >>> 10 ^ w9 << 15 ^ w9 << 13) + w11 + w4 | 0;
          e = w11 + e + (b >>> 6 ^ b >>> 11 ^ b >>> 25 ^ b << 26 ^ b << 21 ^ b << 7) + (d ^ b & (c ^ d)) + 0x8cc70208 | 0;
          a = a + e | 0;
          e = e + (f & g ^ h & (f ^ g)) + (f >>> 2 ^ f >>> 13 ^ f >>> 22 ^ f << 30 ^ f << 19 ^ f << 10) | 0; // 60
          w12 = (w13 >>> 7 ^ w13 >>> 18 ^ w13 >>> 3 ^ w13 << 25 ^ w13 << 14) + (w10 >>> 17 ^ w10 >>> 19 ^ w10 >>> 10 ^ w10 << 15 ^ w10 << 13) + w12 + w5 | 0;
          d = w12 + d + (a >>> 6 ^ a >>> 11 ^ a >>> 25 ^ a << 26 ^ a << 21 ^ a << 7) + (c ^ a & (b ^ c)) + 0x90befffa | 0;
          h = h + d | 0;
          d = d + (e & f ^ g & (e ^ f)) + (e >>> 2 ^ e >>> 13 ^ e >>> 22 ^ e << 30 ^ e << 19 ^ e << 10) | 0; // 61
          w13 = (w14 >>> 7 ^ w14 >>> 18 ^ w14 >>> 3 ^ w14 << 25 ^ w14 << 14) + (w11 >>> 17 ^ w11 >>> 19 ^ w11 >>> 10 ^ w11 << 15 ^ w11 << 13) + w13 + w6 | 0;
          c = w13 + c + (h >>> 6 ^ h >>> 11 ^ h >>> 25 ^ h << 26 ^ h << 21 ^ h << 7) + (b ^ h & (a ^ b)) + 0xa4506ceb | 0;
          g = g + c | 0;
          c = c + (d & e ^ f & (d ^ e)) + (d >>> 2 ^ d >>> 13 ^ d >>> 22 ^ d << 30 ^ d << 19 ^ d << 10) | 0; // 62
          w14 = (w15 >>> 7 ^ w15 >>> 18 ^ w15 >>> 3 ^ w15 << 25 ^ w15 << 14) + (w12 >>> 17 ^ w12 >>> 19 ^ w12 >>> 10 ^ w12 << 15 ^ w12 << 13) + w14 + w7 | 0;
          b = w14 + b + (g >>> 6 ^ g >>> 11 ^ g >>> 25 ^ g << 26 ^ g << 21 ^ g << 7) + (a ^ g & (h ^ a)) + 0xbef9a3f7 | 0;
          f = f + b | 0;
          b = b + (c & d ^ e & (c ^ d)) + (c >>> 2 ^ c >>> 13 ^ c >>> 22 ^ c << 30 ^ c << 19 ^ c << 10) | 0; // 63
          w15 = (w0 >>> 7 ^ w0 >>> 18 ^ w0 >>> 3 ^ w0 << 25 ^ w0 << 14) + (w13 >>> 17 ^ w13 >>> 19 ^ w13 >>> 10 ^ w13 << 15 ^ w13 << 13) + w15 + w8 | 0;
          a = w15 + a + (f >>> 6 ^ f >>> 11 ^ f >>> 25 ^ f << 26 ^ f << 21 ^ f << 7) + (h ^ f & (g ^ h)) + 0xc67178f2 | 0;
          e = e + a | 0;
          a = a + (b & c ^ d & (b ^ c)) + (b >>> 2 ^ b >>> 13 ^ b >>> 22 ^ b << 30 ^ b << 19 ^ b << 10) | 0;
          H0 = H0 + a | 0;
          H1 = H1 + b | 0;
          H2 = H2 + c | 0;
          H3 = H3 + d | 0;
          H4 = H4 + e | 0;
          H5 = H5 + f | 0;
          H6 = H6 + g | 0;
          H7 = H7 + h | 0;
        }
        function _core_heap(offset) {
          offset = offset | 0;
          _core(HEAP[offset | 0] << 24 | HEAP[offset | 1] << 16 | HEAP[offset | 2] << 8 | HEAP[offset | 3], HEAP[offset | 4] << 24 | HEAP[offset | 5] << 16 | HEAP[offset | 6] << 8 | HEAP[offset | 7], HEAP[offset | 8] << 24 | HEAP[offset | 9] << 16 | HEAP[offset | 10] << 8 | HEAP[offset | 11], HEAP[offset | 12] << 24 | HEAP[offset | 13] << 16 | HEAP[offset | 14] << 8 | HEAP[offset | 15], HEAP[offset | 16] << 24 | HEAP[offset | 17] << 16 | HEAP[offset | 18] << 8 | HEAP[offset | 19], HEAP[offset | 20] << 24 | HEAP[offset | 21] << 16 | HEAP[offset | 22] << 8 | HEAP[offset | 23], HEAP[offset | 24] << 24 | HEAP[offset | 25] << 16 | HEAP[offset | 26] << 8 | HEAP[offset | 27], HEAP[offset | 28] << 24 | HEAP[offset | 29] << 16 | HEAP[offset | 30] << 8 | HEAP[offset | 31], HEAP[offset | 32] << 24 | HEAP[offset | 33] << 16 | HEAP[offset | 34] << 8 | HEAP[offset | 35], HEAP[offset | 36] << 24 | HEAP[offset | 37] << 16 | HEAP[offset | 38] << 8 | HEAP[offset | 39], HEAP[offset | 40] << 24 | HEAP[offset | 41] << 16 | HEAP[offset | 42] << 8 | HEAP[offset | 43], HEAP[offset | 44] << 24 | HEAP[offset | 45] << 16 | HEAP[offset | 46] << 8 | HEAP[offset | 47], HEAP[offset | 48] << 24 | HEAP[offset | 49] << 16 | HEAP[offset | 50] << 8 | HEAP[offset | 51], HEAP[offset | 52] << 24 | HEAP[offset | 53] << 16 | HEAP[offset | 54] << 8 | HEAP[offset | 55], HEAP[offset | 56] << 24 | HEAP[offset | 57] << 16 | HEAP[offset | 58] << 8 | HEAP[offset | 59], HEAP[offset | 60] << 24 | HEAP[offset | 61] << 16 | HEAP[offset | 62] << 8 | HEAP[offset | 63]);
        } // offset — multiple of 32
        function _state_to_heap(output) {
          output = output | 0;
          HEAP[output | 0] = H0 >>> 24;
          HEAP[output | 1] = H0 >>> 16 & 255;
          HEAP[output | 2] = H0 >>> 8 & 255;
          HEAP[output | 3] = H0 & 255;
          HEAP[output | 4] = H1 >>> 24;
          HEAP[output | 5] = H1 >>> 16 & 255;
          HEAP[output | 6] = H1 >>> 8 & 255;
          HEAP[output | 7] = H1 & 255;
          HEAP[output | 8] = H2 >>> 24;
          HEAP[output | 9] = H2 >>> 16 & 255;
          HEAP[output | 10] = H2 >>> 8 & 255;
          HEAP[output | 11] = H2 & 255;
          HEAP[output | 12] = H3 >>> 24;
          HEAP[output | 13] = H3 >>> 16 & 255;
          HEAP[output | 14] = H3 >>> 8 & 255;
          HEAP[output | 15] = H3 & 255;
          HEAP[output | 16] = H4 >>> 24;
          HEAP[output | 17] = H4 >>> 16 & 255;
          HEAP[output | 18] = H4 >>> 8 & 255;
          HEAP[output | 19] = H4 & 255;
          HEAP[output | 20] = H5 >>> 24;
          HEAP[output | 21] = H5 >>> 16 & 255;
          HEAP[output | 22] = H5 >>> 8 & 255;
          HEAP[output | 23] = H5 & 255;
          HEAP[output | 24] = H6 >>> 24;
          HEAP[output | 25] = H6 >>> 16 & 255;
          HEAP[output | 26] = H6 >>> 8 & 255;
          HEAP[output | 27] = H6 & 255;
          HEAP[output | 28] = H7 >>> 24;
          HEAP[output | 29] = H7 >>> 16 & 255;
          HEAP[output | 30] = H7 >>> 8 & 255;
          HEAP[output | 31] = H7 & 255;
        }
        function reset() {
          H0 = 0x6a09e667;
          H1 = 0xbb67ae85;
          H2 = 0x3c6ef372;
          H3 = 0xa54ff53a;
          H4 = 0x510e527f;
          H5 = 0x9b05688c;
          H6 = 0x1f83d9ab;
          H7 = 0x5be0cd19;
          TOTAL0 = TOTAL1 = 0;
        }
        function init(h0, h1, h2, h3, h4, h5, h6, h7, total0, total1) {
          h0 = h0 | 0;
          h1 = h1 | 0;
          h2 = h2 | 0;
          h3 = h3 | 0;
          h4 = h4 | 0;
          h5 = h5 | 0;
          h6 = h6 | 0;
          h7 = h7 | 0;
          total0 = total0 | 0;
          total1 = total1 | 0;
          H0 = h0;
          H1 = h1;
          H2 = h2;
          H3 = h3;
          H4 = h4;
          H5 = h5;
          H6 = h6;
          H7 = h7;
          TOTAL0 = total0;
          TOTAL1 = total1;
        } // offset — multiple of 64
        function process(offset, length) {
          offset = offset | 0;
          length = length | 0;
          var hashed = 0;
          if (offset & 63) return -1;
          while ((length | 0) >= 64) {
            _core_heap(offset);
            offset = offset + 64 | 0;
            length = length - 64 | 0;
            hashed = hashed + 64 | 0;
          }
          TOTAL0 = TOTAL0 + hashed | 0;
          if (TOTAL0 >>> 0 < hashed >>> 0) TOTAL1 = TOTAL1 + 1 | 0;
          return hashed | 0;
        } // offset — multiple of 64
        // output — multiple of 32
        function finish(offset, length, output) {
          offset = offset | 0;
          length = length | 0;
          output = output | 0;
          var hashed = 0,
            i = 0;
          if (offset & 63) return -1;
          if (~output) if (output & 31) return -1;
          if ((length | 0) >= 64) {
            hashed = process(offset, length) | 0;
            if ((hashed | 0) == -1) return -1;
            offset = offset + hashed | 0;
            length = length - hashed | 0;
          }
          hashed = hashed + length | 0;
          TOTAL0 = TOTAL0 + length | 0;
          if (TOTAL0 >>> 0 < length >>> 0) TOTAL1 = TOTAL1 + 1 | 0;
          HEAP[offset | length] = 0x80;
          if ((length | 0) >= 56) {
            for (i = length + 1 | 0; (i | 0) < 64; i = i + 1 | 0) {
              HEAP[offset | i] = 0x00;
            }
            _core_heap(offset);
            length = 0;
            HEAP[offset | 0] = 0;
          }
          for (i = length + 1 | 0; (i | 0) < 59; i = i + 1 | 0) {
            HEAP[offset | i] = 0;
          }
          HEAP[offset | 56] = TOTAL1 >>> 21 & 255;
          HEAP[offset | 57] = TOTAL1 >>> 13 & 255;
          HEAP[offset | 58] = TOTAL1 >>> 5 & 255;
          HEAP[offset | 59] = TOTAL1 << 3 & 255 | TOTAL0 >>> 29;
          HEAP[offset | 60] = TOTAL0 >>> 21 & 255;
          HEAP[offset | 61] = TOTAL0 >>> 13 & 255;
          HEAP[offset | 62] = TOTAL0 >>> 5 & 255;
          HEAP[offset | 63] = TOTAL0 << 3 & 255;
          _core_heap(offset);
          if (~output) _state_to_heap(output);
          return hashed | 0;
        }
        function hmac_reset() {
          H0 = I0;
          H1 = I1;
          H2 = I2;
          H3 = I3;
          H4 = I4;
          H5 = I5;
          H6 = I6;
          H7 = I7;
          TOTAL0 = 64;
          TOTAL1 = 0;
        }
        function _hmac_opad() {
          H0 = O0;
          H1 = O1;
          H2 = O2;
          H3 = O3;
          H4 = O4;
          H5 = O5;
          H6 = O6;
          H7 = O7;
          TOTAL0 = 64;
          TOTAL1 = 0;
        }
        function hmac_init(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15) {
          p0 = p0 | 0;
          p1 = p1 | 0;
          p2 = p2 | 0;
          p3 = p3 | 0;
          p4 = p4 | 0;
          p5 = p5 | 0;
          p6 = p6 | 0;
          p7 = p7 | 0;
          p8 = p8 | 0;
          p9 = p9 | 0;
          p10 = p10 | 0;
          p11 = p11 | 0;
          p12 = p12 | 0;
          p13 = p13 | 0;
          p14 = p14 | 0;
          p15 = p15 | 0; // opad
          reset();
          _core(p0 ^ 0x5c5c5c5c, p1 ^ 0x5c5c5c5c, p2 ^ 0x5c5c5c5c, p3 ^ 0x5c5c5c5c, p4 ^ 0x5c5c5c5c, p5 ^ 0x5c5c5c5c, p6 ^ 0x5c5c5c5c, p7 ^ 0x5c5c5c5c, p8 ^ 0x5c5c5c5c, p9 ^ 0x5c5c5c5c, p10 ^ 0x5c5c5c5c, p11 ^ 0x5c5c5c5c, p12 ^ 0x5c5c5c5c, p13 ^ 0x5c5c5c5c, p14 ^ 0x5c5c5c5c, p15 ^ 0x5c5c5c5c);
          O0 = H0;
          O1 = H1;
          O2 = H2;
          O3 = H3;
          O4 = H4;
          O5 = H5;
          O6 = H6;
          O7 = H7; // ipad
          reset();
          _core(p0 ^ 0x36363636, p1 ^ 0x36363636, p2 ^ 0x36363636, p3 ^ 0x36363636, p4 ^ 0x36363636, p5 ^ 0x36363636, p6 ^ 0x36363636, p7 ^ 0x36363636, p8 ^ 0x36363636, p9 ^ 0x36363636, p10 ^ 0x36363636, p11 ^ 0x36363636, p12 ^ 0x36363636, p13 ^ 0x36363636, p14 ^ 0x36363636, p15 ^ 0x36363636);
          I0 = H0;
          I1 = H1;
          I2 = H2;
          I3 = H3;
          I4 = H4;
          I5 = H5;
          I6 = H6;
          I7 = H7;
          TOTAL0 = 64;
          TOTAL1 = 0;
        } // offset — multiple of 64
        // output — multiple of 32
        function hmac_finish(offset, length, output) {
          offset = offset | 0;
          length = length | 0;
          output = output | 0;
          var t0 = 0,
            t1 = 0,
            t2 = 0,
            t3 = 0,
            t4 = 0,
            t5 = 0,
            t6 = 0,
            t7 = 0,
            hashed = 0;
          if (offset & 63) return -1;
          if (~output) if (output & 31) return -1;
          hashed = finish(offset, length, -1) | 0;
          t0 = H0, t1 = H1, t2 = H2, t3 = H3, t4 = H4, t5 = H5, t6 = H6, t7 = H7;
          _hmac_opad();
          _core(t0, t1, t2, t3, t4, t5, t6, t7, 0x80000000, 0, 0, 0, 0, 0, 0, 768);
          if (~output) _state_to_heap(output);
          return hashed | 0;
        } // salt is assumed to be already processed
        // offset — multiple of 64
        // output — multiple of 32
        function pbkdf2_generate_block(offset, length, block, count, output) {
          offset = offset | 0;
          length = length | 0;
          block = block | 0;
          count = count | 0;
          output = output | 0;
          var h0 = 0,
            h1 = 0,
            h2 = 0,
            h3 = 0,
            h4 = 0,
            h5 = 0,
            h6 = 0,
            h7 = 0,
            t0 = 0,
            t1 = 0,
            t2 = 0,
            t3 = 0,
            t4 = 0,
            t5 = 0,
            t6 = 0,
            t7 = 0;
          if (offset & 63) return -1;
          if (~output) if (output & 31) return -1; // pad block number into heap
          // FIXME probable OOB write
          HEAP[offset + length | 0] = block >>> 24;
          HEAP[offset + length + 1 | 0] = block >>> 16 & 255;
          HEAP[offset + length + 2 | 0] = block >>> 8 & 255;
          HEAP[offset + length + 3 | 0] = block & 255; // finish first iteration
          hmac_finish(offset, length + 4 | 0, -1) | 0;
          h0 = t0 = H0, h1 = t1 = H1, h2 = t2 = H2, h3 = t3 = H3, h4 = t4 = H4, h5 = t5 = H5, h6 = t6 = H6, h7 = t7 = H7;
          count = count - 1 | 0; // perform the rest iterations
          while ((count | 0) > 0) {
            hmac_reset();
            _core(t0, t1, t2, t3, t4, t5, t6, t7, 0x80000000, 0, 0, 0, 0, 0, 0, 768);
            t0 = H0, t1 = H1, t2 = H2, t3 = H3, t4 = H4, t5 = H5, t6 = H6, t7 = H7;
            _hmac_opad();
            _core(t0, t1, t2, t3, t4, t5, t6, t7, 0x80000000, 0, 0, 0, 0, 0, 0, 768);
            t0 = H0, t1 = H1, t2 = H2, t3 = H3, t4 = H4, t5 = H5, t6 = H6, t7 = H7;
            h0 = h0 ^ H0;
            h1 = h1 ^ H1;
            h2 = h2 ^ H2;
            h3 = h3 ^ H3;
            h4 = h4 ^ H4;
            h5 = h5 ^ H5;
            h6 = h6 ^ H6;
            h7 = h7 ^ H7;
            count = count - 1 | 0;
          }
          H0 = h0;
          H1 = h1;
          H2 = h2;
          H3 = h3;
          H4 = h4;
          H5 = h5;
          H6 = h6;
          H7 = h7;
          if (~output) _state_to_heap(output);
          return 0;
        }
        return {
          // SHA256
          reset: reset,
          init: init,
          process: process,
          finish: finish,
          // HMAC-SHA256
          hmac_reset: hmac_reset,
          hmac_init: hmac_init,
          hmac_finish: hmac_finish,
          // PBKDF2-HMAC-SHA256
          pbkdf2_generate_block: pbkdf2_generate_block
        };
      }
    }, {}],
    14: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.Sha256 = exports._sha256_hash_size = exports._sha256_block_size = undefined;
      var _sha = require('./sha256.asm');
      var _hash = require('../hash');
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var _sha256_block_size = exports._sha256_block_size = 64;
      var _sha256_hash_size = exports._sha256_hash_size = 32;
      var Sha256 = /** @class */function (_super) {
        __extends(Sha256, _super);
        function Sha256() {
          var _this = _super !== null && _super.apply(this, arguments) || this;
          _this.NAME = 'sha256';
          _this.BLOCK_SIZE = _sha256_block_size;
          _this.HASH_SIZE = _sha256_hash_size;
          return _this;
        }
        Sha256.bytes = function (data) {
          return new Sha256().process(data).finish().result;
        };
        Sha256.NAME = 'sha256';
        Sha256.heap_pool = [];
        Sha256.asm_pool = [];
        Sha256.asm_function = _sha.sha256_asm;
        return Sha256;
      }(_hash.Hash);
      exports.Sha256 = Sha256;
    }, {
      "../hash": 10,
      "./sha256.asm": 13
    }],
    15: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      var __extends =  false || function () {
        var extendStatics = Object.setPrototypeOf || _instanceof({
          __proto__: []
        }, Array) && function (d, b) {
          d.__proto__ = b;
        } || function (d, b) {
          for (var p in b) {
            if (b.hasOwnProperty(p)) d[p] = b[p];
          }
        };
        return function (d, b) {
          extendStatics(d, b);
          function __() {
            this.constructor = d;
          }
          d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
      }();
      var IllegalStateError = /** @class */function (_super) {
        __extends(IllegalStateError, _super);
        function IllegalStateError() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          var _this = _super.apply(this, args) || this;
          Object.create(Error.prototype, {
            name: {
              value: 'IllegalStateError'
            }
          });
          return _this;
        }
        return IllegalStateError;
      }(Error);
      exports.IllegalStateError = IllegalStateError;
      var IllegalArgumentError = /** @class */function (_super) {
        __extends(IllegalArgumentError, _super);
        function IllegalArgumentError() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          var _this = _super.apply(this, args) || this;
          Object.create(Error.prototype, {
            name: {
              value: 'IllegalArgumentError'
            }
          });
          return _this;
        }
        return IllegalArgumentError;
      }(Error);
      exports.IllegalArgumentError = IllegalArgumentError;
      var SecurityError = /** @class */function (_super) {
        __extends(SecurityError, _super);
        function SecurityError() {
          var args = [];
          for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
          }
          var _this = _super.apply(this, args) || this;
          Object.create(Error.prototype, {
            name: {
              value: 'SecurityError'
            }
          });
          return _this;
        }
        return SecurityError;
      }(Error);
      exports.SecurityError = SecurityError;
    }, {}],
    16: [function (require, module, exports) {
      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.string_to_bytes = string_to_bytes;
      exports.hex_to_bytes = hex_to_bytes;
      exports.base64_to_bytes = base64_to_bytes;
      exports.bytes_to_string = bytes_to_string;
      exports.bytes_to_hex = bytes_to_hex;
      exports.bytes_to_base64 = bytes_to_base64;
      exports.pow2_ceil = pow2_ceil;
      exports.is_number = is_number;
      exports.is_string = is_string;
      exports.is_buffer = is_buffer;
      exports.is_bytes = is_bytes;
      exports.is_typed_array = is_typed_array;
      exports._heap_init = _heap_init;
      exports._heap_write = _heap_write;
      exports.joinBytes = joinBytes;
      var local_atob = typeof atob === 'undefined' ? function (str) {
        return require('buffer').Buffer.from(str, 'base64').toString('binary');
      } : atob;
      var local_btoa = typeof btoa === 'undefined' ? function (str) {
        return require('buffer').Buffer.from(str, 'binary').toString('base64');
      } : btoa;
      function string_to_bytes(str, utf8) {
        if (utf8 === void 0) {
          utf8 = false;
        }
        var len = str.length,
          bytes = new Uint8Array(utf8 ? 4 * len : len);
        for (var i = 0, j = 0; i < len; i++) {
          var c = str.charCodeAt(i);
          if (utf8 && 0xd800 <= c && c <= 0xdbff) {
            if (++i >= len) throw new Error('Malformed string, low surrogate expected at position ' + i);
            c = (c ^ 0xd800) << 10 | 0x10000 | str.charCodeAt(i) ^ 0xdc00;
          } else if (!utf8 && c >>> 8) {
            throw new Error('Wide characters are not allowed.');
          }
          if (!utf8 || c <= 0x7f) {
            bytes[j++] = c;
          } else if (c <= 0x7ff) {
            bytes[j++] = 0xc0 | c >> 6;
            bytes[j++] = 0x80 | c & 0x3f;
          } else if (c <= 0xffff) {
            bytes[j++] = 0xe0 | c >> 12;
            bytes[j++] = 0x80 | c >> 6 & 0x3f;
            bytes[j++] = 0x80 | c & 0x3f;
          } else {
            bytes[j++] = 0xf0 | c >> 18;
            bytes[j++] = 0x80 | c >> 12 & 0x3f;
            bytes[j++] = 0x80 | c >> 6 & 0x3f;
            bytes[j++] = 0x80 | c & 0x3f;
          }
        }
        return bytes.subarray(0, j);
      }
      function hex_to_bytes(str) {
        var len = str.length;
        if (len & 1) {
          str = '0' + str;
          len++;
        }
        var bytes = new Uint8Array(len >> 1);
        for (var i = 0; i < len; i += 2) {
          bytes[i >> 1] = parseInt(str.substr(i, 2), 16);
        }
        return bytes;
      }
      function base64_to_bytes(str) {
        return string_to_bytes(local_atob(str));
      }
      function bytes_to_string(bytes, utf8) {
        if (utf8 === void 0) {
          utf8 = false;
        }
        var len = bytes.length,
          chars = new Array(len);
        for (var i = 0, j = 0; i < len; i++) {
          var b = bytes[i];
          if (!utf8 || b < 128) {
            chars[j++] = b;
          } else if (b >= 192 && b < 224 && i + 1 < len) {
            chars[j++] = (b & 0x1f) << 6 | bytes[++i] & 0x3f;
          } else if (b >= 224 && b < 240 && i + 2 < len) {
            chars[j++] = (b & 0xf) << 12 | (bytes[++i] & 0x3f) << 6 | bytes[++i] & 0x3f;
          } else if (b >= 240 && b < 248 && i + 3 < len) {
            var c = (b & 7) << 18 | (bytes[++i] & 0x3f) << 12 | (bytes[++i] & 0x3f) << 6 | bytes[++i] & 0x3f;
            if (c <= 0xffff) {
              chars[j++] = c;
            } else {
              c ^= 0x10000;
              chars[j++] = 0xd800 | c >> 10;
              chars[j++] = 0xdc00 | c & 0x3ff;
            }
          } else {
            throw new Error('Malformed UTF8 character at byte offset ' + i);
          }
        }
        var str = '',
          bs = 16384;
        for (var i = 0; i < j; i += bs) {
          str += String.fromCharCode.apply(String, chars.slice(i, i + bs <= j ? i + bs : j));
        }
        return str;
      }
      function bytes_to_hex(arr) {
        var str = '';
        for (var i = 0; i < arr.length; i++) {
          var h = (arr[i] & 0xff).toString(16);
          if (h.length < 2) str += '0';
          str += h;
        }
        return str;
      }
      function bytes_to_base64(arr) {
        return local_btoa(bytes_to_string(arr));
      }
      function pow2_ceil(a) {
        a -= 1;
        a |= a >>> 1;
        a |= a >>> 2;
        a |= a >>> 4;
        a |= a >>> 8;
        a |= a >>> 16;
        a += 1;
        return a;
      }
      function is_number(a) {
        return typeof a === 'number';
      }
      function is_string(a) {
        return typeof a === 'string';
      }
      function is_buffer(a) {
        return _instanceof(a, ArrayBuffer);
      }
      function is_bytes(a) {
        return _instanceof(a, Uint8Array);
      }
      function is_typed_array(a) {
        return _instanceof(a, Int8Array) || _instanceof(a, Uint8Array) || _instanceof(a, Int16Array) || _instanceof(a, Uint16Array) || _instanceof(a, Int32Array) || _instanceof(a, Uint32Array) || _instanceof(a, Float32Array) || _instanceof(a, Float64Array);
      }
      function _heap_init(heap, heapSize) {
        var size = heap ? heap.byteLength : heapSize || 65536;
        if (size & 0xfff || size <= 0) throw new Error('heap size must be a positive integer and a multiple of 4096');
        heap = heap || new Uint8Array(new ArrayBuffer(size));
        return heap;
      }
      function _heap_write(heap, hpos, data, dpos, dlen) {
        var hlen = heap.length - hpos;
        var wlen = hlen < dlen ? hlen : dlen;
        heap.set(data.subarray(dpos, dpos + wlen), hpos);
        return wlen;
      }
      function joinBytes() {
        var arg = [];
        for (var _i = 0; _i < arguments.length; _i++) {
          arg[_i] = arguments[_i];
        }
        var totalLenght = arg.reduce(function (sum, curr) {
          return sum + curr.length;
        }, 0);
        var ret = new Uint8Array(totalLenght);
        var cursor = 0;
        for (var i = 0; i < arg.length; i++) {
          ret.set(arg[i], cursor);
          cursor += arg[i].length;
        }
        return ret;
      }
    }, {
      "buffer": "buffer"
    }],
    17: [function (require, module, exports) {
      (function (module, exports) {
        'use strict';

        // Utils
        function assert(val, msg) {
          if (!val) throw new Error(msg || 'Assertion failed');
        } // Could use `inherits` module, but don't want to move from single file
        // architecture yet.
        function inherits(ctor, superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function TempCtor() {};
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        } // BN
        function BN(number, base, endian) {
          if (BN.isBN(number)) {
            return number;
          }
          this.negative = 0;
          this.words = null;
          this.length = 0; // Reduction context
          this.red = null;
          if (number !== null) {
            if (base === 'le' || base === 'be') {
              endian = base;
              base = 10;
            }
            this._init(number || 0, base || 10, endian || 'be');
          }
        }
        if (_typeof(module) === 'object') {
          module.exports = BN;
        } else {
          exports.BN = BN;
        }
        BN.BN = BN;
        BN.wordSize = 26;
        var Buffer;
        try {
          Buffer = require('buffer').Buffer;
        } catch (e) {}
        BN.isBN = function isBN(num) {
          if (_instanceof(num, BN)) {
            return true;
          }
          return num !== null && _typeof(num) === 'object' && num.constructor.wordSize === BN.wordSize && Array.isArray(num.words);
        };
        BN.max = function max(left, right) {
          if (left.cmp(right) > 0) return left;
          return right;
        };
        BN.min = function min(left, right) {
          if (left.cmp(right) < 0) return left;
          return right;
        };
        BN.prototype._init = function init(number, base, endian) {
          if (typeof number === 'number') {
            return this._initNumber(number, base, endian);
          }
          if (_typeof(number) === 'object') {
            return this._initArray(number, base, endian);
          }
          if (base === 'hex') {
            base = 16;
          }
          assert(base === (base | 0) && base >= 2 && base <= 36);
          number = number.toString().replace(/\s+/g, '');
          var start = 0;
          if (number[0] === '-') {
            start++;
          }
          if (base === 16) {
            this._parseHex(number, start);
          } else {
            this._parseBase(number, base, start);
          }
          if (number[0] === '-') {
            this.negative = 1;
          }
          this.strip();
          if (endian !== 'le') return;
          this._initArray(this.toArray(), base, endian);
        };
        BN.prototype._initNumber = function _initNumber(number, base, endian) {
          if (number < 0) {
            this.negative = 1;
            number = -number;
          }
          if (number < 0x4000000) {
            this.words = [number & 0x3ffffff];
            this.length = 1;
          } else if (number < 0x10000000000000) {
            this.words = [number & 0x3ffffff, number / 0x4000000 & 0x3ffffff];
            this.length = 2;
          } else {
            assert(number < 0x20000000000000); // 2 ^ 53 (unsafe)
            this.words = [number & 0x3ffffff, number / 0x4000000 & 0x3ffffff, 1];
            this.length = 3;
          }
          if (endian !== 'le') return; // Reverse the bytes
          this._initArray(this.toArray(), base, endian);
        };
        BN.prototype._initArray = function _initArray(number, base, endian) {
          // Perhaps a Uint8Array
          assert(typeof number.length === 'number');
          if (number.length <= 0) {
            this.words = [0];
            this.length = 1;
            return this;
          }
          this.length = Math.ceil(number.length / 3);
          this.words = new Array(this.length);
          for (var i = 0; i < this.length; i++) {
            this.words[i] = 0;
          }
          var j, w;
          var off = 0;
          if (endian === 'be') {
            for (i = number.length - 1, j = 0; i >= 0; i -= 3) {
              w = number[i] | number[i - 1] << 8 | number[i - 2] << 16;
              this.words[j] |= w << off & 0x3ffffff;
              this.words[j + 1] = w >>> 26 - off & 0x3ffffff;
              off += 24;
              if (off >= 26) {
                off -= 26;
                j++;
              }
            }
          } else if (endian === 'le') {
            for (i = 0, j = 0; i < number.length; i += 3) {
              w = number[i] | number[i + 1] << 8 | number[i + 2] << 16;
              this.words[j] |= w << off & 0x3ffffff;
              this.words[j + 1] = w >>> 26 - off & 0x3ffffff;
              off += 24;
              if (off >= 26) {
                off -= 26;
                j++;
              }
            }
          }
          return this.strip();
        };
        function parseHex(str, start, end) {
          var r = 0;
          var len = Math.min(str.length, end);
          for (var i = start; i < len; i++) {
            var c = str.charCodeAt(i) - 48;
            r <<= 4; // 'a' - 'f'
            if (c >= 49 && c <= 54) {
              r |= c - 49 + 0xa; // 'A' - 'F'
            } else if (c >= 17 && c <= 22) {
              r |= c - 17 + 0xa; // '0' - '9'
            } else {
              r |= c & 0xf;
            }
          }
          return r;
        }
        BN.prototype._parseHex = function _parseHex(number, start) {
          // Create possibly bigger array to ensure that it fits the number
          this.length = Math.ceil((number.length - start) / 6);
          this.words = new Array(this.length);
          for (var i = 0; i < this.length; i++) {
            this.words[i] = 0;
          }
          var j, w; // Scan 24-bit chunks and add them to the number
          var off = 0;
          for (i = number.length - 6, j = 0; i >= start; i -= 6) {
            w = parseHex(number, i, i + 6);
            this.words[j] |= w << off & 0x3ffffff; // NOTE: `0x3fffff` is intentional here, 26bits max shift + 24bit hex limb
            this.words[j + 1] |= w >>> 26 - off & 0x3fffff;
            off += 24;
            if (off >= 26) {
              off -= 26;
              j++;
            }
          }
          if (i + 6 !== start) {
            w = parseHex(number, start, i + 6);
            this.words[j] |= w << off & 0x3ffffff;
            this.words[j + 1] |= w >>> 26 - off & 0x3fffff;
          }
          this.strip();
        };
        function parseBase(str, start, end, mul) {
          var r = 0;
          var len = Math.min(str.length, end);
          for (var i = start; i < len; i++) {
            var c = str.charCodeAt(i) - 48;
            r *= mul; // 'a'
            if (c >= 49) {
              r += c - 49 + 0xa; // 'A'
            } else if (c >= 17) {
              r += c - 17 + 0xa; // '0' - '9'
            } else {
              r += c;
            }
          }
          return r;
        }
        BN.prototype._parseBase = function _parseBase(number, base, start) {
          // Initialize as zero
          this.words = [0];
          this.length = 1; // Find length of limb in base
          for (var limbLen = 0, limbPow = 1; limbPow <= 0x3ffffff; limbPow *= base) {
            limbLen++;
          }
          limbLen--;
          limbPow = limbPow / base | 0;
          var total = number.length - start;
          var mod = total % limbLen;
          var end = Math.min(total, total - mod) + start;
          var word = 0;
          for (var i = start; i < end; i += limbLen) {
            word = parseBase(number, i, i + limbLen, base);
            this.imuln(limbPow);
            if (this.words[0] + word < 0x4000000) {
              this.words[0] += word;
            } else {
              this._iaddn(word);
            }
          }
          if (mod !== 0) {
            var pow = 1;
            word = parseBase(number, i, number.length, base);
            for (i = 0; i < mod; i++) {
              pow *= base;
            }
            this.imuln(pow);
            if (this.words[0] + word < 0x4000000) {
              this.words[0] += word;
            } else {
              this._iaddn(word);
            }
          }
        };
        BN.prototype.copy = function copy(dest) {
          dest.words = new Array(this.length);
          for (var i = 0; i < this.length; i++) {
            dest.words[i] = this.words[i];
          }
          dest.length = this.length;
          dest.negative = this.negative;
          dest.red = this.red;
        };
        BN.prototype.clone = function clone() {
          var r = new BN(null);
          this.copy(r);
          return r;
        };
        BN.prototype._expand = function _expand(size) {
          while (this.length < size) {
            this.words[this.length++] = 0;
          }
          return this;
        }; // Remove leading `0` from `this`
        BN.prototype.strip = function strip() {
          while (this.length > 1 && this.words[this.length - 1] === 0) {
            this.length--;
          }
          return this._normSign();
        };
        BN.prototype._normSign = function _normSign() {
          // -0 = 0
          if (this.length === 1 && this.words[0] === 0) {
            this.negative = 0;
          }
          return this;
        };
        BN.prototype.inspect = function inspect() {
          return (this.red ? '<BN-R: ' : '<BN: ') + this.toString(16) + '>';
        }; /*
           var zeros = [];
           var groupSizes = [];
           var groupBases = [];
           var s = '';
           var i = -1;
           while (++i < BN.wordSize) {
           zeros[i] = s;
           s += '0';
           }
           groupSizes[0] = 0;
           groupSizes[1] = 0;
           groupBases[0] = 0;
           groupBases[1] = 0;
           var base = 2 - 1;
           while (++base < 36 + 1) {
           var groupSize = 0;
           var groupBase = 1;
           while (groupBase < (1 << BN.wordSize) / base) {
           groupBase *= base;
           groupSize += 1;
           }
           groupSizes[base] = groupSize;
           groupBases[base] = groupBase;
           }
           */
        var zeros = ['', '0', '00', '000', '0000', '00000', '000000', '0000000', '00000000', '000000000', '0000000000', '00000000000', '000000000000', '0000000000000', '00000000000000', '000000000000000', '0000000000000000', '00000000000000000', '000000000000000000', '0000000000000000000', '00000000000000000000', '000000000000000000000', '0000000000000000000000', '00000000000000000000000', '000000000000000000000000', '0000000000000000000000000'];
        var groupSizes = [0, 0, 25, 16, 12, 11, 10, 9, 8, 8, 7, 7, 7, 7, 6, 6, 6, 6, 6, 6, 6, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5];
        var groupBases = [0, 0, 33554432, 43046721, 16777216, 48828125, 60466176, 40353607, 16777216, 43046721, 10000000, 19487171, 35831808, 62748517, 7529536, 11390625, 16777216, 24137569, 34012224, 47045881, 64000000, 4084101, 5153632, 6436343, 7962624, 9765625, 11881376, 14348907, 17210368, 20511149, 24300000, 28629151, 33554432, 39135393, 45435424, 52521875, 60466176];
        BN.prototype.toString = function toString(base, padding) {
          base = base || 10;
          padding = padding | 0 || 1;
          var out;
          if (base === 16 || base === 'hex') {
            out = '';
            var off = 0;
            var carry = 0;
            for (var i = 0; i < this.length; i++) {
              var w = this.words[i];
              var word = ((w << off | carry) & 0xffffff).toString(16);
              carry = w >>> 24 - off & 0xffffff;
              if (carry !== 0 || i !== this.length - 1) {
                out = zeros[6 - word.length] + word + out;
              } else {
                out = word + out;
              }
              off += 2;
              if (off >= 26) {
                off -= 26;
                i--;
              }
            }
            if (carry !== 0) {
              out = carry.toString(16) + out;
            }
            while (out.length % padding !== 0) {
              out = '0' + out;
            }
            if (this.negative !== 0) {
              out = '-' + out;
            }
            return out;
          }
          if (base === (base | 0) && base >= 2 && base <= 36) {
            // var groupSize = Math.floor(BN.wordSize * Math.LN2 / Math.log(base));
            var groupSize = groupSizes[base]; // var groupBase = Math.pow(base, groupSize);
            var groupBase = groupBases[base];
            out = '';
            var c = this.clone();
            c.negative = 0;
            while (!c.isZero()) {
              var r = c.modn(groupBase).toString(base);
              c = c.idivn(groupBase);
              if (!c.isZero()) {
                out = zeros[groupSize - r.length] + r + out;
              } else {
                out = r + out;
              }
            }
            if (this.isZero()) {
              out = '0' + out;
            }
            while (out.length % padding !== 0) {
              out = '0' + out;
            }
            if (this.negative !== 0) {
              out = '-' + out;
            }
            return out;
          }
          assert(false, 'Base should be between 2 and 36');
        };
        BN.prototype.toNumber = function toNumber() {
          var ret = this.words[0];
          if (this.length === 2) {
            ret += this.words[1] * 0x4000000;
          } else if (this.length === 3 && this.words[2] === 0x01) {
            // NOTE: at this stage it is known that the top bit is set
            ret += 0x10000000000000 + this.words[1] * 0x4000000;
          } else if (this.length > 2) {
            assert(false, 'Number can only safely store up to 53 bits');
          }
          return this.negative !== 0 ? -ret : ret;
        };
        BN.prototype.toJSON = function toJSON() {
          return this.toString(16);
        };
        BN.prototype.toBuffer = function toBuffer(endian, length) {
          assert(typeof Buffer !== 'undefined');
          return this.toArrayLike(Buffer, endian, length);
        };
        BN.prototype.toArray = function toArray(endian, length) {
          return this.toArrayLike(Array, endian, length);
        };
        BN.prototype.toArrayLike = function toArrayLike(ArrayType, endian, length) {
          var byteLength = this.byteLength();
          var reqLength = length || Math.max(1, byteLength);
          assert(byteLength <= reqLength, 'byte array longer than desired length');
          assert(reqLength > 0, 'Requested array length <= 0');
          this.strip();
          var littleEndian = endian === 'le';
          var res = new ArrayType(reqLength);
          var b, i;
          var q = this.clone();
          if (!littleEndian) {
            // Assume big-endian
            for (i = 0; i < reqLength - byteLength; i++) {
              res[i] = 0;
            }
            for (i = 0; !q.isZero(); i++) {
              b = q.andln(0xff);
              q.iushrn(8);
              res[reqLength - i - 1] = b;
            }
          } else {
            for (i = 0; !q.isZero(); i++) {
              b = q.andln(0xff);
              q.iushrn(8);
              res[i] = b;
            }
            for (; i < reqLength; i++) {
              res[i] = 0;
            }
          }
          return res;
        };
        if (Math.clz32) {
          BN.prototype._countBits = function _countBits(w) {
            return 32 - Math.clz32(w);
          };
        } else {
          BN.prototype._countBits = function _countBits(w) {
            var t = w;
            var r = 0;
            if (t >= 0x1000) {
              r += 13;
              t >>>= 13;
            }
            if (t >= 0x40) {
              r += 7;
              t >>>= 7;
            }
            if (t >= 0x8) {
              r += 4;
              t >>>= 4;
            }
            if (t >= 0x02) {
              r += 2;
              t >>>= 2;
            }
            return r + t;
          };
        }
        BN.prototype._zeroBits = function _zeroBits(w) {
          // Short-cut
          if (w === 0) return 26;
          var t = w;
          var r = 0;
          if ((t & 0x1fff) === 0) {
            r += 13;
            t >>>= 13;
          }
          if ((t & 0x7f) === 0) {
            r += 7;
            t >>>= 7;
          }
          if ((t & 0xf) === 0) {
            r += 4;
            t >>>= 4;
          }
          if ((t & 0x3) === 0) {
            r += 2;
            t >>>= 2;
          }
          if ((t & 0x1) === 0) {
            r++;
          }
          return r;
        }; // Return number of used bits in a BN
        BN.prototype.bitLength = function bitLength() {
          var w = this.words[this.length - 1];
          var hi = this._countBits(w);
          return (this.length - 1) * 26 + hi;
        };
        function toBitArray(num) {
          var w = new Array(num.bitLength());
          for (var bit = 0; bit < w.length; bit++) {
            var off = bit / 26 | 0;
            var wbit = bit % 26;
            w[bit] = (num.words[off] & 1 << wbit) >>> wbit;
          }
          return w;
        } // Number of trailing zero bits
        BN.prototype.zeroBits = function zeroBits() {
          if (this.isZero()) return 0;
          var r = 0;
          for (var i = 0; i < this.length; i++) {
            var b = this._zeroBits(this.words[i]);
            r += b;
            if (b !== 26) break;
          }
          return r;
        };
        BN.prototype.byteLength = function byteLength() {
          return Math.ceil(this.bitLength() / 8);
        };
        BN.prototype.toTwos = function toTwos(width) {
          if (this.negative !== 0) {
            return this.abs().inotn(width).iaddn(1);
          }
          return this.clone();
        };
        BN.prototype.fromTwos = function fromTwos(width) {
          if (this.testn(width - 1)) {
            return this.notn(width).iaddn(1).ineg();
          }
          return this.clone();
        };
        BN.prototype.isNeg = function isNeg() {
          return this.negative !== 0;
        }; // Return negative clone of `this`
        BN.prototype.neg = function neg() {
          return this.clone().ineg();
        };
        BN.prototype.ineg = function ineg() {
          if (!this.isZero()) {
            this.negative ^= 1;
          }
          return this;
        }; // Or `num` with `this` in-place
        BN.prototype.iuor = function iuor(num) {
          while (this.length < num.length) {
            this.words[this.length++] = 0;
          }
          for (var i = 0; i < num.length; i++) {
            this.words[i] = this.words[i] | num.words[i];
          }
          return this.strip();
        };
        BN.prototype.ior = function ior(num) {
          assert((this.negative | num.negative) === 0);
          return this.iuor(num);
        }; // Or `num` with `this`
        BN.prototype.or = function or(num) {
          if (this.length > num.length) return this.clone().ior(num);
          return num.clone().ior(this);
        };
        BN.prototype.uor = function uor(num) {
          if (this.length > num.length) return this.clone().iuor(num);
          return num.clone().iuor(this);
        }; // And `num` with `this` in-place
        BN.prototype.iuand = function iuand(num) {
          // b = min-length(num, this)
          var b;
          if (this.length > num.length) {
            b = num;
          } else {
            b = this;
          }
          for (var i = 0; i < b.length; i++) {
            this.words[i] = this.words[i] & num.words[i];
          }
          this.length = b.length;
          return this.strip();
        };
        BN.prototype.iand = function iand(num) {
          assert((this.negative | num.negative) === 0);
          return this.iuand(num);
        }; // And `num` with `this`
        BN.prototype.and = function and(num) {
          if (this.length > num.length) return this.clone().iand(num);
          return num.clone().iand(this);
        };
        BN.prototype.uand = function uand(num) {
          if (this.length > num.length) return this.clone().iuand(num);
          return num.clone().iuand(this);
        }; // Xor `num` with `this` in-place
        BN.prototype.iuxor = function iuxor(num) {
          // a.length > b.length
          var a;
          var b;
          if (this.length > num.length) {
            a = this;
            b = num;
          } else {
            a = num;
            b = this;
          }
          for (var i = 0; i < b.length; i++) {
            this.words[i] = a.words[i] ^ b.words[i];
          }
          if (this !== a) {
            for (; i < a.length; i++) {
              this.words[i] = a.words[i];
            }
          }
          this.length = a.length;
          return this.strip();
        };
        BN.prototype.ixor = function ixor(num) {
          assert((this.negative | num.negative) === 0);
          return this.iuxor(num);
        }; // Xor `num` with `this`
        BN.prototype.xor = function xor(num) {
          if (this.length > num.length) return this.clone().ixor(num);
          return num.clone().ixor(this);
        };
        BN.prototype.uxor = function uxor(num) {
          if (this.length > num.length) return this.clone().iuxor(num);
          return num.clone().iuxor(this);
        }; // Not ``this`` with ``width`` bitwidth
        BN.prototype.inotn = function inotn(width) {
          assert(typeof width === 'number' && width >= 0);
          var bytesNeeded = Math.ceil(width / 26) | 0;
          var bitsLeft = width % 26; // Extend the buffer with leading zeroes
          this._expand(bytesNeeded);
          if (bitsLeft > 0) {
            bytesNeeded--;
          } // Handle complete words
          for (var i = 0; i < bytesNeeded; i++) {
            this.words[i] = ~this.words[i] & 0x3ffffff;
          } // Handle the residue
          if (bitsLeft > 0) {
            this.words[i] = ~this.words[i] & 0x3ffffff >> 26 - bitsLeft;
          } // And remove leading zeroes
          return this.strip();
        };
        BN.prototype.notn = function notn(width) {
          return this.clone().inotn(width);
        }; // Set `bit` of `this`
        BN.prototype.setn = function setn(bit, val) {
          assert(typeof bit === 'number' && bit >= 0);
          var off = bit / 26 | 0;
          var wbit = bit % 26;
          this._expand(off + 1);
          if (val) {
            this.words[off] = this.words[off] | 1 << wbit;
          } else {
            this.words[off] = this.words[off] & ~(1 << wbit);
          }
          return this.strip();
        }; // Add `num` to `this` in-place
        BN.prototype.iadd = function iadd(num) {
          var r; // negative + positive
          if (this.negative !== 0 && num.negative === 0) {
            this.negative = 0;
            r = this.isub(num);
            this.negative ^= 1;
            return this._normSign(); // positive + negative
          } else if (this.negative === 0 && num.negative !== 0) {
            num.negative = 0;
            r = this.isub(num);
            num.negative = 1;
            return r._normSign();
          } // a.length > b.length
          var a, b;
          if (this.length > num.length) {
            a = this;
            b = num;
          } else {
            a = num;
            b = this;
          }
          var carry = 0;
          for (var i = 0; i < b.length; i++) {
            r = (a.words[i] | 0) + (b.words[i] | 0) + carry;
            this.words[i] = r & 0x3ffffff;
            carry = r >>> 26;
          }
          for (; carry !== 0 && i < a.length; i++) {
            r = (a.words[i] | 0) + carry;
            this.words[i] = r & 0x3ffffff;
            carry = r >>> 26;
          }
          this.length = a.length;
          if (carry !== 0) {
            this.words[this.length] = carry;
            this.length++; // Copy the rest of the words
          } else if (a !== this) {
            for (; i < a.length; i++) {
              this.words[i] = a.words[i];
            }
          }
          return this;
        }; // Add `num` to `this`
        BN.prototype.add = function add(num) {
          var res;
          if (num.negative !== 0 && this.negative === 0) {
            num.negative = 0;
            res = this.sub(num);
            num.negative ^= 1;
            return res;
          } else if (num.negative === 0 && this.negative !== 0) {
            this.negative = 0;
            res = num.sub(this);
            this.negative = 1;
            return res;
          }
          if (this.length > num.length) return this.clone().iadd(num);
          return num.clone().iadd(this);
        }; // Subtract `num` from `this` in-place
        BN.prototype.isub = function isub(num) {
          // this - (-num) = this + num
          if (num.negative !== 0) {
            num.negative = 0;
            var r = this.iadd(num);
            num.negative = 1;
            return r._normSign(); // -this - num = -(this + num)
          } else if (this.negative !== 0) {
            this.negative = 0;
            this.iadd(num);
            this.negative = 1;
            return this._normSign();
          } // At this point both numbers are positive
          var cmp = this.cmp(num); // Optimization - zeroify
          if (cmp === 0) {
            this.negative = 0;
            this.length = 1;
            this.words[0] = 0;
            return this;
          } // a > b
          var a, b;
          if (cmp > 0) {
            a = this;
            b = num;
          } else {
            a = num;
            b = this;
          }
          var carry = 0;
          for (var i = 0; i < b.length; i++) {
            r = (a.words[i] | 0) - (b.words[i] | 0) + carry;
            carry = r >> 26;
            this.words[i] = r & 0x3ffffff;
          }
          for (; carry !== 0 && i < a.length; i++) {
            r = (a.words[i] | 0) + carry;
            carry = r >> 26;
            this.words[i] = r & 0x3ffffff;
          } // Copy rest of the words
          if (carry === 0 && i < a.length && a !== this) {
            for (; i < a.length; i++) {
              this.words[i] = a.words[i];
            }
          }
          this.length = Math.max(this.length, i);
          if (a !== this) {
            this.negative = 1;
          }
          return this.strip();
        }; // Subtract `num` from `this`
        BN.prototype.sub = function sub(num) {
          return this.clone().isub(num);
        };
        function smallMulTo(self, num, out) {
          out.negative = num.negative ^ self.negative;
          var len = self.length + num.length | 0;
          out.length = len;
          len = len - 1 | 0; // Peel one iteration (compiler can't do it, because of code complexity)
          var a = self.words[0] | 0;
          var b = num.words[0] | 0;
          var r = a * b;
          var lo = r & 0x3ffffff;
          var carry = r / 0x4000000 | 0;
          out.words[0] = lo;
          for (var k = 1; k < len; k++) {
            // Sum all words with the same `i + j = k` and accumulate `ncarry`,
            // note that ncarry could be >= 0x3ffffff
            var ncarry = carry >>> 26;
            var rword = carry & 0x3ffffff;
            var maxJ = Math.min(k, num.length - 1);
            for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
              var i = k - j | 0;
              a = self.words[i] | 0;
              b = num.words[j] | 0;
              r = a * b + rword;
              ncarry += r / 0x4000000 | 0;
              rword = r & 0x3ffffff;
            }
            out.words[k] = rword | 0;
            carry = ncarry | 0;
          }
          if (carry !== 0) {
            out.words[k] = carry | 0;
          } else {
            out.length--;
          }
          return out.strip();
        } // TODO(indutny): it may be reasonable to omit it for users who don't need
        // to work with 256-bit numbers, otherwise it gives 20% improvement for 256-bit
        // multiplication (like elliptic secp256k1).
        var comb10MulTo = function comb10MulTo(self, num, out) {
          var a = self.words;
          var b = num.words;
          var o = out.words;
          var c = 0;
          var lo;
          var mid;
          var hi;
          var a0 = a[0] | 0;
          var al0 = a0 & 0x1fff;
          var ah0 = a0 >>> 13;
          var a1 = a[1] | 0;
          var al1 = a1 & 0x1fff;
          var ah1 = a1 >>> 13;
          var a2 = a[2] | 0;
          var al2 = a2 & 0x1fff;
          var ah2 = a2 >>> 13;
          var a3 = a[3] | 0;
          var al3 = a3 & 0x1fff;
          var ah3 = a3 >>> 13;
          var a4 = a[4] | 0;
          var al4 = a4 & 0x1fff;
          var ah4 = a4 >>> 13;
          var a5 = a[5] | 0;
          var al5 = a5 & 0x1fff;
          var ah5 = a5 >>> 13;
          var a6 = a[6] | 0;
          var al6 = a6 & 0x1fff;
          var ah6 = a6 >>> 13;
          var a7 = a[7] | 0;
          var al7 = a7 & 0x1fff;
          var ah7 = a7 >>> 13;
          var a8 = a[8] | 0;
          var al8 = a8 & 0x1fff;
          var ah8 = a8 >>> 13;
          var a9 = a[9] | 0;
          var al9 = a9 & 0x1fff;
          var ah9 = a9 >>> 13;
          var b0 = b[0] | 0;
          var bl0 = b0 & 0x1fff;
          var bh0 = b0 >>> 13;
          var b1 = b[1] | 0;
          var bl1 = b1 & 0x1fff;
          var bh1 = b1 >>> 13;
          var b2 = b[2] | 0;
          var bl2 = b2 & 0x1fff;
          var bh2 = b2 >>> 13;
          var b3 = b[3] | 0;
          var bl3 = b3 & 0x1fff;
          var bh3 = b3 >>> 13;
          var b4 = b[4] | 0;
          var bl4 = b4 & 0x1fff;
          var bh4 = b4 >>> 13;
          var b5 = b[5] | 0;
          var bl5 = b5 & 0x1fff;
          var bh5 = b5 >>> 13;
          var b6 = b[6] | 0;
          var bl6 = b6 & 0x1fff;
          var bh6 = b6 >>> 13;
          var b7 = b[7] | 0;
          var bl7 = b7 & 0x1fff;
          var bh7 = b7 >>> 13;
          var b8 = b[8] | 0;
          var bl8 = b8 & 0x1fff;
          var bh8 = b8 >>> 13;
          var b9 = b[9] | 0;
          var bl9 = b9 & 0x1fff;
          var bh9 = b9 >>> 13;
          out.negative = self.negative ^ num.negative;
          out.length = 19; /* k = 0 */
          lo = Math.imul(al0, bl0);
          mid = Math.imul(al0, bh0);
          mid = mid + Math.imul(ah0, bl0) | 0;
          hi = Math.imul(ah0, bh0);
          var w0 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w0 >>> 26) | 0;
          w0 &= 0x3ffffff; /* k = 1 */
          lo = Math.imul(al1, bl0);
          mid = Math.imul(al1, bh0);
          mid = mid + Math.imul(ah1, bl0) | 0;
          hi = Math.imul(ah1, bh0);
          lo = lo + Math.imul(al0, bl1) | 0;
          mid = mid + Math.imul(al0, bh1) | 0;
          mid = mid + Math.imul(ah0, bl1) | 0;
          hi = hi + Math.imul(ah0, bh1) | 0;
          var w1 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w1 >>> 26) | 0;
          w1 &= 0x3ffffff; /* k = 2 */
          lo = Math.imul(al2, bl0);
          mid = Math.imul(al2, bh0);
          mid = mid + Math.imul(ah2, bl0) | 0;
          hi = Math.imul(ah2, bh0);
          lo = lo + Math.imul(al1, bl1) | 0;
          mid = mid + Math.imul(al1, bh1) | 0;
          mid = mid + Math.imul(ah1, bl1) | 0;
          hi = hi + Math.imul(ah1, bh1) | 0;
          lo = lo + Math.imul(al0, bl2) | 0;
          mid = mid + Math.imul(al0, bh2) | 0;
          mid = mid + Math.imul(ah0, bl2) | 0;
          hi = hi + Math.imul(ah0, bh2) | 0;
          var w2 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w2 >>> 26) | 0;
          w2 &= 0x3ffffff; /* k = 3 */
          lo = Math.imul(al3, bl0);
          mid = Math.imul(al3, bh0);
          mid = mid + Math.imul(ah3, bl0) | 0;
          hi = Math.imul(ah3, bh0);
          lo = lo + Math.imul(al2, bl1) | 0;
          mid = mid + Math.imul(al2, bh1) | 0;
          mid = mid + Math.imul(ah2, bl1) | 0;
          hi = hi + Math.imul(ah2, bh1) | 0;
          lo = lo + Math.imul(al1, bl2) | 0;
          mid = mid + Math.imul(al1, bh2) | 0;
          mid = mid + Math.imul(ah1, bl2) | 0;
          hi = hi + Math.imul(ah1, bh2) | 0;
          lo = lo + Math.imul(al0, bl3) | 0;
          mid = mid + Math.imul(al0, bh3) | 0;
          mid = mid + Math.imul(ah0, bl3) | 0;
          hi = hi + Math.imul(ah0, bh3) | 0;
          var w3 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w3 >>> 26) | 0;
          w3 &= 0x3ffffff; /* k = 4 */
          lo = Math.imul(al4, bl0);
          mid = Math.imul(al4, bh0);
          mid = mid + Math.imul(ah4, bl0) | 0;
          hi = Math.imul(ah4, bh0);
          lo = lo + Math.imul(al3, bl1) | 0;
          mid = mid + Math.imul(al3, bh1) | 0;
          mid = mid + Math.imul(ah3, bl1) | 0;
          hi = hi + Math.imul(ah3, bh1) | 0;
          lo = lo + Math.imul(al2, bl2) | 0;
          mid = mid + Math.imul(al2, bh2) | 0;
          mid = mid + Math.imul(ah2, bl2) | 0;
          hi = hi + Math.imul(ah2, bh2) | 0;
          lo = lo + Math.imul(al1, bl3) | 0;
          mid = mid + Math.imul(al1, bh3) | 0;
          mid = mid + Math.imul(ah1, bl3) | 0;
          hi = hi + Math.imul(ah1, bh3) | 0;
          lo = lo + Math.imul(al0, bl4) | 0;
          mid = mid + Math.imul(al0, bh4) | 0;
          mid = mid + Math.imul(ah0, bl4) | 0;
          hi = hi + Math.imul(ah0, bh4) | 0;
          var w4 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w4 >>> 26) | 0;
          w4 &= 0x3ffffff; /* k = 5 */
          lo = Math.imul(al5, bl0);
          mid = Math.imul(al5, bh0);
          mid = mid + Math.imul(ah5, bl0) | 0;
          hi = Math.imul(ah5, bh0);
          lo = lo + Math.imul(al4, bl1) | 0;
          mid = mid + Math.imul(al4, bh1) | 0;
          mid = mid + Math.imul(ah4, bl1) | 0;
          hi = hi + Math.imul(ah4, bh1) | 0;
          lo = lo + Math.imul(al3, bl2) | 0;
          mid = mid + Math.imul(al3, bh2) | 0;
          mid = mid + Math.imul(ah3, bl2) | 0;
          hi = hi + Math.imul(ah3, bh2) | 0;
          lo = lo + Math.imul(al2, bl3) | 0;
          mid = mid + Math.imul(al2, bh3) | 0;
          mid = mid + Math.imul(ah2, bl3) | 0;
          hi = hi + Math.imul(ah2, bh3) | 0;
          lo = lo + Math.imul(al1, bl4) | 0;
          mid = mid + Math.imul(al1, bh4) | 0;
          mid = mid + Math.imul(ah1, bl4) | 0;
          hi = hi + Math.imul(ah1, bh4) | 0;
          lo = lo + Math.imul(al0, bl5) | 0;
          mid = mid + Math.imul(al0, bh5) | 0;
          mid = mid + Math.imul(ah0, bl5) | 0;
          hi = hi + Math.imul(ah0, bh5) | 0;
          var w5 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w5 >>> 26) | 0;
          w5 &= 0x3ffffff; /* k = 6 */
          lo = Math.imul(al6, bl0);
          mid = Math.imul(al6, bh0);
          mid = mid + Math.imul(ah6, bl0) | 0;
          hi = Math.imul(ah6, bh0);
          lo = lo + Math.imul(al5, bl1) | 0;
          mid = mid + Math.imul(al5, bh1) | 0;
          mid = mid + Math.imul(ah5, bl1) | 0;
          hi = hi + Math.imul(ah5, bh1) | 0;
          lo = lo + Math.imul(al4, bl2) | 0;
          mid = mid + Math.imul(al4, bh2) | 0;
          mid = mid + Math.imul(ah4, bl2) | 0;
          hi = hi + Math.imul(ah4, bh2) | 0;
          lo = lo + Math.imul(al3, bl3) | 0;
          mid = mid + Math.imul(al3, bh3) | 0;
          mid = mid + Math.imul(ah3, bl3) | 0;
          hi = hi + Math.imul(ah3, bh3) | 0;
          lo = lo + Math.imul(al2, bl4) | 0;
          mid = mid + Math.imul(al2, bh4) | 0;
          mid = mid + Math.imul(ah2, bl4) | 0;
          hi = hi + Math.imul(ah2, bh4) | 0;
          lo = lo + Math.imul(al1, bl5) | 0;
          mid = mid + Math.imul(al1, bh5) | 0;
          mid = mid + Math.imul(ah1, bl5) | 0;
          hi = hi + Math.imul(ah1, bh5) | 0;
          lo = lo + Math.imul(al0, bl6) | 0;
          mid = mid + Math.imul(al0, bh6) | 0;
          mid = mid + Math.imul(ah0, bl6) | 0;
          hi = hi + Math.imul(ah0, bh6) | 0;
          var w6 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w6 >>> 26) | 0;
          w6 &= 0x3ffffff; /* k = 7 */
          lo = Math.imul(al7, bl0);
          mid = Math.imul(al7, bh0);
          mid = mid + Math.imul(ah7, bl0) | 0;
          hi = Math.imul(ah7, bh0);
          lo = lo + Math.imul(al6, bl1) | 0;
          mid = mid + Math.imul(al6, bh1) | 0;
          mid = mid + Math.imul(ah6, bl1) | 0;
          hi = hi + Math.imul(ah6, bh1) | 0;
          lo = lo + Math.imul(al5, bl2) | 0;
          mid = mid + Math.imul(al5, bh2) | 0;
          mid = mid + Math.imul(ah5, bl2) | 0;
          hi = hi + Math.imul(ah5, bh2) | 0;
          lo = lo + Math.imul(al4, bl3) | 0;
          mid = mid + Math.imul(al4, bh3) | 0;
          mid = mid + Math.imul(ah4, bl3) | 0;
          hi = hi + Math.imul(ah4, bh3) | 0;
          lo = lo + Math.imul(al3, bl4) | 0;
          mid = mid + Math.imul(al3, bh4) | 0;
          mid = mid + Math.imul(ah3, bl4) | 0;
          hi = hi + Math.imul(ah3, bh4) | 0;
          lo = lo + Math.imul(al2, bl5) | 0;
          mid = mid + Math.imul(al2, bh5) | 0;
          mid = mid + Math.imul(ah2, bl5) | 0;
          hi = hi + Math.imul(ah2, bh5) | 0;
          lo = lo + Math.imul(al1, bl6) | 0;
          mid = mid + Math.imul(al1, bh6) | 0;
          mid = mid + Math.imul(ah1, bl6) | 0;
          hi = hi + Math.imul(ah1, bh6) | 0;
          lo = lo + Math.imul(al0, bl7) | 0;
          mid = mid + Math.imul(al0, bh7) | 0;
          mid = mid + Math.imul(ah0, bl7) | 0;
          hi = hi + Math.imul(ah0, bh7) | 0;
          var w7 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w7 >>> 26) | 0;
          w7 &= 0x3ffffff; /* k = 8 */
          lo = Math.imul(al8, bl0);
          mid = Math.imul(al8, bh0);
          mid = mid + Math.imul(ah8, bl0) | 0;
          hi = Math.imul(ah8, bh0);
          lo = lo + Math.imul(al7, bl1) | 0;
          mid = mid + Math.imul(al7, bh1) | 0;
          mid = mid + Math.imul(ah7, bl1) | 0;
          hi = hi + Math.imul(ah7, bh1) | 0;
          lo = lo + Math.imul(al6, bl2) | 0;
          mid = mid + Math.imul(al6, bh2) | 0;
          mid = mid + Math.imul(ah6, bl2) | 0;
          hi = hi + Math.imul(ah6, bh2) | 0;
          lo = lo + Math.imul(al5, bl3) | 0;
          mid = mid + Math.imul(al5, bh3) | 0;
          mid = mid + Math.imul(ah5, bl3) | 0;
          hi = hi + Math.imul(ah5, bh3) | 0;
          lo = lo + Math.imul(al4, bl4) | 0;
          mid = mid + Math.imul(al4, bh4) | 0;
          mid = mid + Math.imul(ah4, bl4) | 0;
          hi = hi + Math.imul(ah4, bh4) | 0;
          lo = lo + Math.imul(al3, bl5) | 0;
          mid = mid + Math.imul(al3, bh5) | 0;
          mid = mid + Math.imul(ah3, bl5) | 0;
          hi = hi + Math.imul(ah3, bh5) | 0;
          lo = lo + Math.imul(al2, bl6) | 0;
          mid = mid + Math.imul(al2, bh6) | 0;
          mid = mid + Math.imul(ah2, bl6) | 0;
          hi = hi + Math.imul(ah2, bh6) | 0;
          lo = lo + Math.imul(al1, bl7) | 0;
          mid = mid + Math.imul(al1, bh7) | 0;
          mid = mid + Math.imul(ah1, bl7) | 0;
          hi = hi + Math.imul(ah1, bh7) | 0;
          lo = lo + Math.imul(al0, bl8) | 0;
          mid = mid + Math.imul(al0, bh8) | 0;
          mid = mid + Math.imul(ah0, bl8) | 0;
          hi = hi + Math.imul(ah0, bh8) | 0;
          var w8 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w8 >>> 26) | 0;
          w8 &= 0x3ffffff; /* k = 9 */
          lo = Math.imul(al9, bl0);
          mid = Math.imul(al9, bh0);
          mid = mid + Math.imul(ah9, bl0) | 0;
          hi = Math.imul(ah9, bh0);
          lo = lo + Math.imul(al8, bl1) | 0;
          mid = mid + Math.imul(al8, bh1) | 0;
          mid = mid + Math.imul(ah8, bl1) | 0;
          hi = hi + Math.imul(ah8, bh1) | 0;
          lo = lo + Math.imul(al7, bl2) | 0;
          mid = mid + Math.imul(al7, bh2) | 0;
          mid = mid + Math.imul(ah7, bl2) | 0;
          hi = hi + Math.imul(ah7, bh2) | 0;
          lo = lo + Math.imul(al6, bl3) | 0;
          mid = mid + Math.imul(al6, bh3) | 0;
          mid = mid + Math.imul(ah6, bl3) | 0;
          hi = hi + Math.imul(ah6, bh3) | 0;
          lo = lo + Math.imul(al5, bl4) | 0;
          mid = mid + Math.imul(al5, bh4) | 0;
          mid = mid + Math.imul(ah5, bl4) | 0;
          hi = hi + Math.imul(ah5, bh4) | 0;
          lo = lo + Math.imul(al4, bl5) | 0;
          mid = mid + Math.imul(al4, bh5) | 0;
          mid = mid + Math.imul(ah4, bl5) | 0;
          hi = hi + Math.imul(ah4, bh5) | 0;
          lo = lo + Math.imul(al3, bl6) | 0;
          mid = mid + Math.imul(al3, bh6) | 0;
          mid = mid + Math.imul(ah3, bl6) | 0;
          hi = hi + Math.imul(ah3, bh6) | 0;
          lo = lo + Math.imul(al2, bl7) | 0;
          mid = mid + Math.imul(al2, bh7) | 0;
          mid = mid + Math.imul(ah2, bl7) | 0;
          hi = hi + Math.imul(ah2, bh7) | 0;
          lo = lo + Math.imul(al1, bl8) | 0;
          mid = mid + Math.imul(al1, bh8) | 0;
          mid = mid + Math.imul(ah1, bl8) | 0;
          hi = hi + Math.imul(ah1, bh8) | 0;
          lo = lo + Math.imul(al0, bl9) | 0;
          mid = mid + Math.imul(al0, bh9) | 0;
          mid = mid + Math.imul(ah0, bl9) | 0;
          hi = hi + Math.imul(ah0, bh9) | 0;
          var w9 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w9 >>> 26) | 0;
          w9 &= 0x3ffffff; /* k = 10 */
          lo = Math.imul(al9, bl1);
          mid = Math.imul(al9, bh1);
          mid = mid + Math.imul(ah9, bl1) | 0;
          hi = Math.imul(ah9, bh1);
          lo = lo + Math.imul(al8, bl2) | 0;
          mid = mid + Math.imul(al8, bh2) | 0;
          mid = mid + Math.imul(ah8, bl2) | 0;
          hi = hi + Math.imul(ah8, bh2) | 0;
          lo = lo + Math.imul(al7, bl3) | 0;
          mid = mid + Math.imul(al7, bh3) | 0;
          mid = mid + Math.imul(ah7, bl3) | 0;
          hi = hi + Math.imul(ah7, bh3) | 0;
          lo = lo + Math.imul(al6, bl4) | 0;
          mid = mid + Math.imul(al6, bh4) | 0;
          mid = mid + Math.imul(ah6, bl4) | 0;
          hi = hi + Math.imul(ah6, bh4) | 0;
          lo = lo + Math.imul(al5, bl5) | 0;
          mid = mid + Math.imul(al5, bh5) | 0;
          mid = mid + Math.imul(ah5, bl5) | 0;
          hi = hi + Math.imul(ah5, bh5) | 0;
          lo = lo + Math.imul(al4, bl6) | 0;
          mid = mid + Math.imul(al4, bh6) | 0;
          mid = mid + Math.imul(ah4, bl6) | 0;
          hi = hi + Math.imul(ah4, bh6) | 0;
          lo = lo + Math.imul(al3, bl7) | 0;
          mid = mid + Math.imul(al3, bh7) | 0;
          mid = mid + Math.imul(ah3, bl7) | 0;
          hi = hi + Math.imul(ah3, bh7) | 0;
          lo = lo + Math.imul(al2, bl8) | 0;
          mid = mid + Math.imul(al2, bh8) | 0;
          mid = mid + Math.imul(ah2, bl8) | 0;
          hi = hi + Math.imul(ah2, bh8) | 0;
          lo = lo + Math.imul(al1, bl9) | 0;
          mid = mid + Math.imul(al1, bh9) | 0;
          mid = mid + Math.imul(ah1, bl9) | 0;
          hi = hi + Math.imul(ah1, bh9) | 0;
          var w10 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w10 >>> 26) | 0;
          w10 &= 0x3ffffff; /* k = 11 */
          lo = Math.imul(al9, bl2);
          mid = Math.imul(al9, bh2);
          mid = mid + Math.imul(ah9, bl2) | 0;
          hi = Math.imul(ah9, bh2);
          lo = lo + Math.imul(al8, bl3) | 0;
          mid = mid + Math.imul(al8, bh3) | 0;
          mid = mid + Math.imul(ah8, bl3) | 0;
          hi = hi + Math.imul(ah8, bh3) | 0;
          lo = lo + Math.imul(al7, bl4) | 0;
          mid = mid + Math.imul(al7, bh4) | 0;
          mid = mid + Math.imul(ah7, bl4) | 0;
          hi = hi + Math.imul(ah7, bh4) | 0;
          lo = lo + Math.imul(al6, bl5) | 0;
          mid = mid + Math.imul(al6, bh5) | 0;
          mid = mid + Math.imul(ah6, bl5) | 0;
          hi = hi + Math.imul(ah6, bh5) | 0;
          lo = lo + Math.imul(al5, bl6) | 0;
          mid = mid + Math.imul(al5, bh6) | 0;
          mid = mid + Math.imul(ah5, bl6) | 0;
          hi = hi + Math.imul(ah5, bh6) | 0;
          lo = lo + Math.imul(al4, bl7) | 0;
          mid = mid + Math.imul(al4, bh7) | 0;
          mid = mid + Math.imul(ah4, bl7) | 0;
          hi = hi + Math.imul(ah4, bh7) | 0;
          lo = lo + Math.imul(al3, bl8) | 0;
          mid = mid + Math.imul(al3, bh8) | 0;
          mid = mid + Math.imul(ah3, bl8) | 0;
          hi = hi + Math.imul(ah3, bh8) | 0;
          lo = lo + Math.imul(al2, bl9) | 0;
          mid = mid + Math.imul(al2, bh9) | 0;
          mid = mid + Math.imul(ah2, bl9) | 0;
          hi = hi + Math.imul(ah2, bh9) | 0;
          var w11 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w11 >>> 26) | 0;
          w11 &= 0x3ffffff; /* k = 12 */
          lo = Math.imul(al9, bl3);
          mid = Math.imul(al9, bh3);
          mid = mid + Math.imul(ah9, bl3) | 0;
          hi = Math.imul(ah9, bh3);
          lo = lo + Math.imul(al8, bl4) | 0;
          mid = mid + Math.imul(al8, bh4) | 0;
          mid = mid + Math.imul(ah8, bl4) | 0;
          hi = hi + Math.imul(ah8, bh4) | 0;
          lo = lo + Math.imul(al7, bl5) | 0;
          mid = mid + Math.imul(al7, bh5) | 0;
          mid = mid + Math.imul(ah7, bl5) | 0;
          hi = hi + Math.imul(ah7, bh5) | 0;
          lo = lo + Math.imul(al6, bl6) | 0;
          mid = mid + Math.imul(al6, bh6) | 0;
          mid = mid + Math.imul(ah6, bl6) | 0;
          hi = hi + Math.imul(ah6, bh6) | 0;
          lo = lo + Math.imul(al5, bl7) | 0;
          mid = mid + Math.imul(al5, bh7) | 0;
          mid = mid + Math.imul(ah5, bl7) | 0;
          hi = hi + Math.imul(ah5, bh7) | 0;
          lo = lo + Math.imul(al4, bl8) | 0;
          mid = mid + Math.imul(al4, bh8) | 0;
          mid = mid + Math.imul(ah4, bl8) | 0;
          hi = hi + Math.imul(ah4, bh8) | 0;
          lo = lo + Math.imul(al3, bl9) | 0;
          mid = mid + Math.imul(al3, bh9) | 0;
          mid = mid + Math.imul(ah3, bl9) | 0;
          hi = hi + Math.imul(ah3, bh9) | 0;
          var w12 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w12 >>> 26) | 0;
          w12 &= 0x3ffffff; /* k = 13 */
          lo = Math.imul(al9, bl4);
          mid = Math.imul(al9, bh4);
          mid = mid + Math.imul(ah9, bl4) | 0;
          hi = Math.imul(ah9, bh4);
          lo = lo + Math.imul(al8, bl5) | 0;
          mid = mid + Math.imul(al8, bh5) | 0;
          mid = mid + Math.imul(ah8, bl5) | 0;
          hi = hi + Math.imul(ah8, bh5) | 0;
          lo = lo + Math.imul(al7, bl6) | 0;
          mid = mid + Math.imul(al7, bh6) | 0;
          mid = mid + Math.imul(ah7, bl6) | 0;
          hi = hi + Math.imul(ah7, bh6) | 0;
          lo = lo + Math.imul(al6, bl7) | 0;
          mid = mid + Math.imul(al6, bh7) | 0;
          mid = mid + Math.imul(ah6, bl7) | 0;
          hi = hi + Math.imul(ah6, bh7) | 0;
          lo = lo + Math.imul(al5, bl8) | 0;
          mid = mid + Math.imul(al5, bh8) | 0;
          mid = mid + Math.imul(ah5, bl8) | 0;
          hi = hi + Math.imul(ah5, bh8) | 0;
          lo = lo + Math.imul(al4, bl9) | 0;
          mid = mid + Math.imul(al4, bh9) | 0;
          mid = mid + Math.imul(ah4, bl9) | 0;
          hi = hi + Math.imul(ah4, bh9) | 0;
          var w13 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w13 >>> 26) | 0;
          w13 &= 0x3ffffff; /* k = 14 */
          lo = Math.imul(al9, bl5);
          mid = Math.imul(al9, bh5);
          mid = mid + Math.imul(ah9, bl5) | 0;
          hi = Math.imul(ah9, bh5);
          lo = lo + Math.imul(al8, bl6) | 0;
          mid = mid + Math.imul(al8, bh6) | 0;
          mid = mid + Math.imul(ah8, bl6) | 0;
          hi = hi + Math.imul(ah8, bh6) | 0;
          lo = lo + Math.imul(al7, bl7) | 0;
          mid = mid + Math.imul(al7, bh7) | 0;
          mid = mid + Math.imul(ah7, bl7) | 0;
          hi = hi + Math.imul(ah7, bh7) | 0;
          lo = lo + Math.imul(al6, bl8) | 0;
          mid = mid + Math.imul(al6, bh8) | 0;
          mid = mid + Math.imul(ah6, bl8) | 0;
          hi = hi + Math.imul(ah6, bh8) | 0;
          lo = lo + Math.imul(al5, bl9) | 0;
          mid = mid + Math.imul(al5, bh9) | 0;
          mid = mid + Math.imul(ah5, bl9) | 0;
          hi = hi + Math.imul(ah5, bh9) | 0;
          var w14 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w14 >>> 26) | 0;
          w14 &= 0x3ffffff; /* k = 15 */
          lo = Math.imul(al9, bl6);
          mid = Math.imul(al9, bh6);
          mid = mid + Math.imul(ah9, bl6) | 0;
          hi = Math.imul(ah9, bh6);
          lo = lo + Math.imul(al8, bl7) | 0;
          mid = mid + Math.imul(al8, bh7) | 0;
          mid = mid + Math.imul(ah8, bl7) | 0;
          hi = hi + Math.imul(ah8, bh7) | 0;
          lo = lo + Math.imul(al7, bl8) | 0;
          mid = mid + Math.imul(al7, bh8) | 0;
          mid = mid + Math.imul(ah7, bl8) | 0;
          hi = hi + Math.imul(ah7, bh8) | 0;
          lo = lo + Math.imul(al6, bl9) | 0;
          mid = mid + Math.imul(al6, bh9) | 0;
          mid = mid + Math.imul(ah6, bl9) | 0;
          hi = hi + Math.imul(ah6, bh9) | 0;
          var w15 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w15 >>> 26) | 0;
          w15 &= 0x3ffffff; /* k = 16 */
          lo = Math.imul(al9, bl7);
          mid = Math.imul(al9, bh7);
          mid = mid + Math.imul(ah9, bl7) | 0;
          hi = Math.imul(ah9, bh7);
          lo = lo + Math.imul(al8, bl8) | 0;
          mid = mid + Math.imul(al8, bh8) | 0;
          mid = mid + Math.imul(ah8, bl8) | 0;
          hi = hi + Math.imul(ah8, bh8) | 0;
          lo = lo + Math.imul(al7, bl9) | 0;
          mid = mid + Math.imul(al7, bh9) | 0;
          mid = mid + Math.imul(ah7, bl9) | 0;
          hi = hi + Math.imul(ah7, bh9) | 0;
          var w16 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w16 >>> 26) | 0;
          w16 &= 0x3ffffff; /* k = 17 */
          lo = Math.imul(al9, bl8);
          mid = Math.imul(al9, bh8);
          mid = mid + Math.imul(ah9, bl8) | 0;
          hi = Math.imul(ah9, bh8);
          lo = lo + Math.imul(al8, bl9) | 0;
          mid = mid + Math.imul(al8, bh9) | 0;
          mid = mid + Math.imul(ah8, bl9) | 0;
          hi = hi + Math.imul(ah8, bh9) | 0;
          var w17 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w17 >>> 26) | 0;
          w17 &= 0x3ffffff; /* k = 18 */
          lo = Math.imul(al9, bl9);
          mid = Math.imul(al9, bh9);
          mid = mid + Math.imul(ah9, bl9) | 0;
          hi = Math.imul(ah9, bh9);
          var w18 = (c + lo | 0) + ((mid & 0x1fff) << 13) | 0;
          c = (hi + (mid >>> 13) | 0) + (w18 >>> 26) | 0;
          w18 &= 0x3ffffff;
          o[0] = w0;
          o[1] = w1;
          o[2] = w2;
          o[3] = w3;
          o[4] = w4;
          o[5] = w5;
          o[6] = w6;
          o[7] = w7;
          o[8] = w8;
          o[9] = w9;
          o[10] = w10;
          o[11] = w11;
          o[12] = w12;
          o[13] = w13;
          o[14] = w14;
          o[15] = w15;
          o[16] = w16;
          o[17] = w17;
          o[18] = w18;
          if (c !== 0) {
            o[19] = c;
            out.length++;
          }
          return out;
        }; // Polyfill comb
        if (!Math.imul) {
          comb10MulTo = smallMulTo;
        }
        function bigMulTo(self, num, out) {
          out.negative = num.negative ^ self.negative;
          out.length = self.length + num.length;
          var carry = 0;
          var hncarry = 0;
          for (var k = 0; k < out.length - 1; k++) {
            // Sum all words with the same `i + j = k` and accumulate `ncarry`,
            // note that ncarry could be >= 0x3ffffff
            var ncarry = hncarry;
            hncarry = 0;
            var rword = carry & 0x3ffffff;
            var maxJ = Math.min(k, num.length - 1);
            for (var j = Math.max(0, k - self.length + 1); j <= maxJ; j++) {
              var i = k - j;
              var a = self.words[i] | 0;
              var b = num.words[j] | 0;
              var r = a * b;
              var lo = r & 0x3ffffff;
              ncarry = ncarry + (r / 0x4000000 | 0) | 0;
              lo = lo + rword | 0;
              rword = lo & 0x3ffffff;
              ncarry = ncarry + (lo >>> 26) | 0;
              hncarry += ncarry >>> 26;
              ncarry &= 0x3ffffff;
            }
            out.words[k] = rword;
            carry = ncarry;
            ncarry = hncarry;
          }
          if (carry !== 0) {
            out.words[k] = carry;
          } else {
            out.length--;
          }
          return out.strip();
        }
        function jumboMulTo(self, num, out) {
          var fftm = new FFTM();
          return fftm.mulp(self, num, out);
        }
        BN.prototype.mulTo = function mulTo(num, out) {
          var res;
          var len = this.length + num.length;
          if (this.length === 10 && num.length === 10) {
            res = comb10MulTo(this, num, out);
          } else if (len < 63) {
            res = smallMulTo(this, num, out);
          } else if (len < 1024) {
            res = bigMulTo(this, num, out);
          } else {
            res = jumboMulTo(this, num, out);
          }
          return res;
        }; // Cooley-Tukey algorithm for FFT
        // slightly revisited to rely on looping instead of recursion
        function FFTM(x, y) {
          this.x = x;
          this.y = y;
        }
        FFTM.prototype.makeRBT = function makeRBT(N) {
          var t = new Array(N);
          var l = BN.prototype._countBits(N) - 1;
          for (var i = 0; i < N; i++) {
            t[i] = this.revBin(i, l, N);
          }
          return t;
        }; // Returns binary-reversed representation of `x`
        FFTM.prototype.revBin = function revBin(x, l, N) {
          if (x === 0 || x === N - 1) return x;
          var rb = 0;
          for (var i = 0; i < l; i++) {
            rb |= (x & 1) << l - i - 1;
            x >>= 1;
          }
          return rb;
        }; // Performs "tweedling" phase, therefore 'emulating'
        // behaviour of the recursive algorithm
        FFTM.prototype.permute = function permute(rbt, rws, iws, rtws, itws, N) {
          for (var i = 0; i < N; i++) {
            rtws[i] = rws[rbt[i]];
            itws[i] = iws[rbt[i]];
          }
        };
        FFTM.prototype.transform = function transform(rws, iws, rtws, itws, N, rbt) {
          this.permute(rbt, rws, iws, rtws, itws, N);
          for (var s = 1; s < N; s <<= 1) {
            var l = s << 1;
            var rtwdf = Math.cos(2 * Math.PI / l);
            var itwdf = Math.sin(2 * Math.PI / l);
            for (var p = 0; p < N; p += l) {
              var rtwdf_ = rtwdf;
              var itwdf_ = itwdf;
              for (var j = 0; j < s; j++) {
                var re = rtws[p + j];
                var ie = itws[p + j];
                var ro = rtws[p + j + s];
                var io = itws[p + j + s];
                var rx = rtwdf_ * ro - itwdf_ * io;
                io = rtwdf_ * io + itwdf_ * ro;
                ro = rx;
                rtws[p + j] = re + ro;
                itws[p + j] = ie + io;
                rtws[p + j + s] = re - ro;
                itws[p + j + s] = ie - io; /* jshint maxdepth : false */
                if (j !== l) {
                  rx = rtwdf * rtwdf_ - itwdf * itwdf_;
                  itwdf_ = rtwdf * itwdf_ + itwdf * rtwdf_;
                  rtwdf_ = rx;
                }
              }
            }
          }
        };
        FFTM.prototype.guessLen13b = function guessLen13b(n, m) {
          var N = Math.max(m, n) | 1;
          var odd = N & 1;
          var i = 0;
          for (N = N / 2 | 0; N; N = N >>> 1) {
            i++;
          }
          return 1 << i + 1 + odd;
        };
        FFTM.prototype.conjugate = function conjugate(rws, iws, N) {
          if (N <= 1) return;
          for (var i = 0; i < N / 2; i++) {
            var t = rws[i];
            rws[i] = rws[N - i - 1];
            rws[N - i - 1] = t;
            t = iws[i];
            iws[i] = -iws[N - i - 1];
            iws[N - i - 1] = -t;
          }
        };
        FFTM.prototype.normalize13b = function normalize13b(ws, N) {
          var carry = 0;
          for (var i = 0; i < N / 2; i++) {
            var w = Math.round(ws[2 * i + 1] / N) * 0x2000 + Math.round(ws[2 * i] / N) + carry;
            ws[i] = w & 0x3ffffff;
            if (w < 0x4000000) {
              carry = 0;
            } else {
              carry = w / 0x4000000 | 0;
            }
          }
          return ws;
        };
        FFTM.prototype.convert13b = function convert13b(ws, len, rws, N) {
          var carry = 0;
          for (var i = 0; i < len; i++) {
            carry = carry + (ws[i] | 0);
            rws[2 * i] = carry & 0x1fff;
            carry = carry >>> 13;
            rws[2 * i + 1] = carry & 0x1fff;
            carry = carry >>> 13;
          } // Pad with zeroes
          for (i = 2 * len; i < N; ++i) {
            rws[i] = 0;
          }
          assert(carry === 0);
          assert((carry & ~0x1fff) === 0);
        };
        FFTM.prototype.stub = function stub(N) {
          var ph = new Array(N);
          for (var i = 0; i < N; i++) {
            ph[i] = 0;
          }
          return ph;
        };
        FFTM.prototype.mulp = function mulp(x, y, out) {
          var N = 2 * this.guessLen13b(x.length, y.length);
          var rbt = this.makeRBT(N);
          var _ = this.stub(N);
          var rws = new Array(N);
          var rwst = new Array(N);
          var iwst = new Array(N);
          var nrws = new Array(N);
          var nrwst = new Array(N);
          var niwst = new Array(N);
          var rmws = out.words;
          rmws.length = N;
          this.convert13b(x.words, x.length, rws, N);
          this.convert13b(y.words, y.length, nrws, N);
          this.transform(rws, _, rwst, iwst, N, rbt);
          this.transform(nrws, _, nrwst, niwst, N, rbt);
          for (var i = 0; i < N; i++) {
            var rx = rwst[i] * nrwst[i] - iwst[i] * niwst[i];
            iwst[i] = rwst[i] * niwst[i] + iwst[i] * nrwst[i];
            rwst[i] = rx;
          }
          this.conjugate(rwst, iwst, N);
          this.transform(rwst, iwst, rmws, _, N, rbt);
          this.conjugate(rmws, _, N);
          this.normalize13b(rmws, N);
          out.negative = x.negative ^ y.negative;
          out.length = x.length + y.length;
          return out.strip();
        }; // Multiply `this` by `num`
        BN.prototype.mul = function mul(num) {
          var out = new BN(null);
          out.words = new Array(this.length + num.length);
          return this.mulTo(num, out);
        }; // Multiply employing FFT
        BN.prototype.mulf = function mulf(num) {
          var out = new BN(null);
          out.words = new Array(this.length + num.length);
          return jumboMulTo(this, num, out);
        }; // In-place Multiplication
        BN.prototype.imul = function imul(num) {
          return this.clone().mulTo(num, this);
        };
        BN.prototype.imuln = function imuln(num) {
          assert(typeof num === 'number');
          assert(num < 0x4000000); // Carry
          var carry = 0;
          for (var i = 0; i < this.length; i++) {
            var w = (this.words[i] | 0) * num;
            var lo = (w & 0x3ffffff) + (carry & 0x3ffffff);
            carry >>= 26;
            carry += w / 0x4000000 | 0; // NOTE: lo is 27bit maximum
            carry += lo >>> 26;
            this.words[i] = lo & 0x3ffffff;
          }
          if (carry !== 0) {
            this.words[i] = carry;
            this.length++;
          }
          return this;
        };
        BN.prototype.muln = function muln(num) {
          return this.clone().imuln(num);
        }; // `this` * `this`
        BN.prototype.sqr = function sqr() {
          return this.mul(this);
        }; // `this` * `this` in-place
        BN.prototype.isqr = function isqr() {
          return this.imul(this.clone());
        }; // Math.pow(`this`, `num`)
        BN.prototype.pow = function pow(num) {
          var w = toBitArray(num);
          if (w.length === 0) return new BN(1); // Skip leading zeroes
          var res = this;
          for (var i = 0; i < w.length; i++, res = res.sqr()) {
            if (w[i] !== 0) break;
          }
          if (++i < w.length) {
            for (var q = res.sqr(); i < w.length; i++, q = q.sqr()) {
              if (w[i] === 0) continue;
              res = res.mul(q);
            }
          }
          return res;
        }; // Shift-left in-place
        BN.prototype.iushln = function iushln(bits) {
          assert(typeof bits === 'number' && bits >= 0);
          var r = bits % 26;
          var s = (bits - r) / 26;
          var carryMask = 0x3ffffff >>> 26 - r << 26 - r;
          var i;
          if (r !== 0) {
            var carry = 0;
            for (i = 0; i < this.length; i++) {
              var newCarry = this.words[i] & carryMask;
              var c = (this.words[i] | 0) - newCarry << r;
              this.words[i] = c | carry;
              carry = newCarry >>> 26 - r;
            }
            if (carry) {
              this.words[i] = carry;
              this.length++;
            }
          }
          if (s !== 0) {
            for (i = this.length - 1; i >= 0; i--) {
              this.words[i + s] = this.words[i];
            }
            for (i = 0; i < s; i++) {
              this.words[i] = 0;
            }
            this.length += s;
          }
          return this.strip();
        };
        BN.prototype.ishln = function ishln(bits) {
          // TODO(indutny): implement me
          assert(this.negative === 0);
          return this.iushln(bits);
        }; // Shift-right in-place
        // NOTE: `hint` is a lowest bit before trailing zeroes
        // NOTE: if `extended` is present - it will be filled with destroyed bits
        BN.prototype.iushrn = function iushrn(bits, hint, extended) {
          assert(typeof bits === 'number' && bits >= 0);
          var h;
          if (hint) {
            h = (hint - hint % 26) / 26;
          } else {
            h = 0;
          }
          var r = bits % 26;
          var s = Math.min((bits - r) / 26, this.length);
          var mask = 0x3ffffff ^ 0x3ffffff >>> r << r;
          var maskedWords = extended;
          h -= s;
          h = Math.max(0, h); // Extended mode, copy masked part
          if (maskedWords) {
            for (var i = 0; i < s; i++) {
              maskedWords.words[i] = this.words[i];
            }
            maskedWords.length = s;
          }
          if (s === 0) {// No-op, we should not move anything at all
          } else if (this.length > s) {
            this.length -= s;
            for (i = 0; i < this.length; i++) {
              this.words[i] = this.words[i + s];
            }
          } else {
            this.words[0] = 0;
            this.length = 1;
          }
          var carry = 0;
          for (i = this.length - 1; i >= 0 && (carry !== 0 || i >= h); i--) {
            var word = this.words[i] | 0;
            this.words[i] = carry << 26 - r | word >>> r;
            carry = word & mask;
          } // Push carried bits as a mask
          if (maskedWords && carry !== 0) {
            maskedWords.words[maskedWords.length++] = carry;
          }
          if (this.length === 0) {
            this.words[0] = 0;
            this.length = 1;
          }
          return this.strip();
        };
        BN.prototype.ishrn = function ishrn(bits, hint, extended) {
          // TODO(indutny): implement me
          assert(this.negative === 0);
          return this.iushrn(bits, hint, extended);
        }; // Shift-left
        BN.prototype.shln = function shln(bits) {
          return this.clone().ishln(bits);
        };
        BN.prototype.ushln = function ushln(bits) {
          return this.clone().iushln(bits);
        }; // Shift-right
        BN.prototype.shrn = function shrn(bits) {
          return this.clone().ishrn(bits);
        };
        BN.prototype.ushrn = function ushrn(bits) {
          return this.clone().iushrn(bits);
        }; // Test if n bit is set
        BN.prototype.testn = function testn(bit) {
          assert(typeof bit === 'number' && bit >= 0);
          var r = bit % 26;
          var s = (bit - r) / 26;
          var q = 1 << r; // Fast case: bit is much higher than all existing words
          if (this.length <= s) return false; // Check bit and return
          var w = this.words[s];
          return !!(w & q);
        }; // Return only lowers bits of number (in-place)
        BN.prototype.imaskn = function imaskn(bits) {
          assert(typeof bits === 'number' && bits >= 0);
          var r = bits % 26;
          var s = (bits - r) / 26;
          assert(this.negative === 0, 'imaskn works only with positive numbers');
          if (this.length <= s) {
            return this;
          }
          if (r !== 0) {
            s++;
          }
          this.length = Math.min(s, this.length);
          if (r !== 0) {
            var mask = 0x3ffffff ^ 0x3ffffff >>> r << r;
            this.words[this.length - 1] &= mask;
          }
          return this.strip();
        }; // Return only lowers bits of number
        BN.prototype.maskn = function maskn(bits) {
          return this.clone().imaskn(bits);
        }; // Add plain number `num` to `this`
        BN.prototype.iaddn = function iaddn(num) {
          assert(typeof num === 'number');
          assert(num < 0x4000000);
          if (num < 0) return this.isubn(-num); // Possible sign change
          if (this.negative !== 0) {
            if (this.length === 1 && (this.words[0] | 0) < num) {
              this.words[0] = num - (this.words[0] | 0);
              this.negative = 0;
              return this;
            }
            this.negative = 0;
            this.isubn(num);
            this.negative = 1;
            return this;
          } // Add without checks
          return this._iaddn(num);
        };
        BN.prototype._iaddn = function _iaddn(num) {
          this.words[0] += num; // Carry
          for (var i = 0; i < this.length && this.words[i] >= 0x4000000; i++) {
            this.words[i] -= 0x4000000;
            if (i === this.length - 1) {
              this.words[i + 1] = 1;
            } else {
              this.words[i + 1]++;
            }
          }
          this.length = Math.max(this.length, i + 1);
          return this;
        }; // Subtract plain number `num` from `this`
        BN.prototype.isubn = function isubn(num) {
          assert(typeof num === 'number');
          assert(num < 0x4000000);
          if (num < 0) return this.iaddn(-num);
          if (this.negative !== 0) {
            this.negative = 0;
            this.iaddn(num);
            this.negative = 1;
            return this;
          }
          this.words[0] -= num;
          if (this.length === 1 && this.words[0] < 0) {
            this.words[0] = -this.words[0];
            this.negative = 1;
          } else {
            // Carry
            for (var i = 0; i < this.length && this.words[i] < 0; i++) {
              this.words[i] += 0x4000000;
              this.words[i + 1] -= 1;
            }
          }
          return this.strip();
        };
        BN.prototype.addn = function addn(num) {
          return this.clone().iaddn(num);
        };
        BN.prototype.subn = function subn(num) {
          return this.clone().isubn(num);
        };
        BN.prototype.iabs = function iabs() {
          this.negative = 0;
          return this;
        };
        BN.prototype.abs = function abs() {
          return this.clone().iabs();
        };
        BN.prototype._ishlnsubmul = function _ishlnsubmul(num, mul, shift) {
          var len = num.length + shift;
          var i;
          this._expand(len);
          var w;
          var carry = 0;
          for (i = 0; i < num.length; i++) {
            w = (this.words[i + shift] | 0) + carry;
            var right = (num.words[i] | 0) * mul;
            w -= right & 0x3ffffff;
            carry = (w >> 26) - (right / 0x4000000 | 0);
            this.words[i + shift] = w & 0x3ffffff;
          }
          for (; i < this.length - shift; i++) {
            w = (this.words[i + shift] | 0) + carry;
            carry = w >> 26;
            this.words[i + shift] = w & 0x3ffffff;
          }
          if (carry === 0) return this.strip(); // Subtraction overflow
          assert(carry === -1);
          carry = 0;
          for (i = 0; i < this.length; i++) {
            w = -(this.words[i] | 0) + carry;
            carry = w >> 26;
            this.words[i] = w & 0x3ffffff;
          }
          this.negative = 1;
          return this.strip();
        };
        BN.prototype._wordDiv = function _wordDiv(num, mode) {
          var shift = this.length - num.length;
          var a = this.clone();
          var b = num; // Normalize
          var bhi = b.words[b.length - 1] | 0;
          var bhiBits = this._countBits(bhi);
          shift = 26 - bhiBits;
          if (shift !== 0) {
            b = b.ushln(shift);
            a.iushln(shift);
            bhi = b.words[b.length - 1] | 0;
          } // Initialize quotient
          var m = a.length - b.length;
          var q;
          if (mode !== 'mod') {
            q = new BN(null);
            q.length = m + 1;
            q.words = new Array(q.length);
            for (var i = 0; i < q.length; i++) {
              q.words[i] = 0;
            }
          }
          var diff = a.clone()._ishlnsubmul(b, 1, m);
          if (diff.negative === 0) {
            a = diff;
            if (q) {
              q.words[m] = 1;
            }
          }
          for (var j = m - 1; j >= 0; j--) {
            var qj = (a.words[b.length + j] | 0) * 0x4000000 + (a.words[b.length + j - 1] | 0); // NOTE: (qj / bhi) is (0x3ffffff * 0x4000000 + 0x3ffffff) / 0x2000000 max
            // (0x7ffffff)
            qj = Math.min(qj / bhi | 0, 0x3ffffff);
            a._ishlnsubmul(b, qj, j);
            while (a.negative !== 0) {
              qj--;
              a.negative = 0;
              a._ishlnsubmul(b, 1, j);
              if (!a.isZero()) {
                a.negative ^= 1;
              }
            }
            if (q) {
              q.words[j] = qj;
            }
          }
          if (q) {
            q.strip();
          }
          a.strip(); // Denormalize
          if (mode !== 'div' && shift !== 0) {
            a.iushrn(shift);
          }
          return {
            div: q || null,
            mod: a
          };
        }; // NOTE: 1) `mode` can be set to `mod` to request mod only,
        //       to `div` to request div only, or be absent to
        //       request both div & mod
        //       2) `positive` is true if unsigned mod is requested
        BN.prototype.divmod = function divmod(num, mode, positive) {
          assert(!num.isZero());
          if (this.isZero()) {
            return {
              div: new BN(0),
              mod: new BN(0)
            };
          }
          var div, mod, res;
          if (this.negative !== 0 && num.negative === 0) {
            res = this.neg().divmod(num, mode);
            if (mode !== 'mod') {
              div = res.div.neg();
            }
            if (mode !== 'div') {
              mod = res.mod.neg();
              if (positive && mod.negative !== 0) {
                mod.iadd(num);
              }
            }
            return {
              div: div,
              mod: mod
            };
          }
          if (this.negative === 0 && num.negative !== 0) {
            res = this.divmod(num.neg(), mode);
            if (mode !== 'mod') {
              div = res.div.neg();
            }
            return {
              div: div,
              mod: res.mod
            };
          }
          if ((this.negative & num.negative) !== 0) {
            res = this.neg().divmod(num.neg(), mode);
            if (mode !== 'div') {
              mod = res.mod.neg();
              if (positive && mod.negative !== 0) {
                mod.isub(num);
              }
            }
            return {
              div: res.div,
              mod: mod
            };
          } // Both numbers are positive at this point
          // Strip both numbers to approximate shift value
          if (num.length > this.length || this.cmp(num) < 0) {
            return {
              div: new BN(0),
              mod: this
            };
          } // Very short reduction
          if (num.length === 1) {
            if (mode === 'div') {
              return {
                div: this.divn(num.words[0]),
                mod: null
              };
            }
            if (mode === 'mod') {
              return {
                div: null,
                mod: new BN(this.modn(num.words[0]))
              };
            }
            return {
              div: this.divn(num.words[0]),
              mod: new BN(this.modn(num.words[0]))
            };
          }
          return this._wordDiv(num, mode);
        }; // Find `this` / `num`
        BN.prototype.div = function div(num) {
          return this.divmod(num, 'div', false).div;
        }; // Find `this` % `num`
        BN.prototype.mod = function mod(num) {
          return this.divmod(num, 'mod', false).mod;
        };
        BN.prototype.umod = function umod(num) {
          return this.divmod(num, 'mod', true).mod;
        }; // Find Round(`this` / `num`)
        BN.prototype.divRound = function divRound(num) {
          var dm = this.divmod(num); // Fast case - exact division
          if (dm.mod.isZero()) return dm.div;
          var mod = dm.div.negative !== 0 ? dm.mod.isub(num) : dm.mod;
          var half = num.ushrn(1);
          var r2 = num.andln(1);
          var cmp = mod.cmp(half); // Round down
          if (cmp < 0 || r2 === 1 && cmp === 0) return dm.div; // Round up
          return dm.div.negative !== 0 ? dm.div.isubn(1) : dm.div.iaddn(1);
        };
        BN.prototype.modn = function modn(num) {
          assert(num <= 0x3ffffff);
          var p = (1 << 26) % num;
          var acc = 0;
          for (var i = this.length - 1; i >= 0; i--) {
            acc = (p * acc + (this.words[i] | 0)) % num;
          }
          return acc;
        }; // In-place division by number
        BN.prototype.idivn = function idivn(num) {
          assert(num <= 0x3ffffff);
          var carry = 0;
          for (var i = this.length - 1; i >= 0; i--) {
            var w = (this.words[i] | 0) + carry * 0x4000000;
            this.words[i] = w / num | 0;
            carry = w % num;
          }
          return this.strip();
        };
        BN.prototype.divn = function divn(num) {
          return this.clone().idivn(num);
        };
        BN.prototype.egcd = function egcd(p) {
          assert(p.negative === 0);
          assert(!p.isZero());
          var x = this;
          var y = p.clone();
          if (x.negative !== 0) {
            x = x.umod(p);
          } else {
            x = x.clone();
          } // A * x + B * y = x
          var A = new BN(1);
          var B = new BN(0); // C * x + D * y = y
          var C = new BN(0);
          var D = new BN(1);
          var g = 0;
          while (x.isEven() && y.isEven()) {
            x.iushrn(1);
            y.iushrn(1);
            ++g;
          }
          var yp = y.clone();
          var xp = x.clone();
          while (!x.isZero()) {
            for (var i = 0, im = 1; (x.words[0] & im) === 0 && i < 26; ++i, im <<= 1) {
              ;
            }
            if (i > 0) {
              x.iushrn(i);
              while (i-- > 0) {
                if (A.isOdd() || B.isOdd()) {
                  A.iadd(yp);
                  B.isub(xp);
                }
                A.iushrn(1);
                B.iushrn(1);
              }
            }
            for (var j = 0, jm = 1; (y.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) {
              ;
            }
            if (j > 0) {
              y.iushrn(j);
              while (j-- > 0) {
                if (C.isOdd() || D.isOdd()) {
                  C.iadd(yp);
                  D.isub(xp);
                }
                C.iushrn(1);
                D.iushrn(1);
              }
            }
            if (x.cmp(y) >= 0) {
              x.isub(y);
              A.isub(C);
              B.isub(D);
            } else {
              y.isub(x);
              C.isub(A);
              D.isub(B);
            }
          }
          return {
            a: C,
            b: D,
            gcd: y.iushln(g)
          };
        }; // This is reduced incarnation of the binary EEA
        // above, designated to invert members of the
        // _prime_ fields F(p) at a maximal speed
        BN.prototype._invmp = function _invmp(p) {
          assert(p.negative === 0);
          assert(!p.isZero());
          var a = this;
          var b = p.clone();
          if (a.negative !== 0) {
            a = a.umod(p);
          } else {
            a = a.clone();
          }
          var x1 = new BN(1);
          var x2 = new BN(0);
          var delta = b.clone();
          while (a.cmpn(1) > 0 && b.cmpn(1) > 0) {
            for (var i = 0, im = 1; (a.words[0] & im) === 0 && i < 26; ++i, im <<= 1) {
              ;
            }
            if (i > 0) {
              a.iushrn(i);
              while (i-- > 0) {
                if (x1.isOdd()) {
                  x1.iadd(delta);
                }
                x1.iushrn(1);
              }
            }
            for (var j = 0, jm = 1; (b.words[0] & jm) === 0 && j < 26; ++j, jm <<= 1) {
              ;
            }
            if (j > 0) {
              b.iushrn(j);
              while (j-- > 0) {
                if (x2.isOdd()) {
                  x2.iadd(delta);
                }
                x2.iushrn(1);
              }
            }
            if (a.cmp(b) >= 0) {
              a.isub(b);
              x1.isub(x2);
            } else {
              b.isub(a);
              x2.isub(x1);
            }
          }
          var res;
          if (a.cmpn(1) === 0) {
            res = x1;
          } else {
            res = x2;
          }
          if (res.cmpn(0) < 0) {
            res.iadd(p);
          }
          return res;
        };
        BN.prototype.gcd = function gcd(num) {
          if (this.isZero()) return num.abs();
          if (num.isZero()) return this.abs();
          var a = this.clone();
          var b = num.clone();
          a.negative = 0;
          b.negative = 0; // Remove common factor of two
          for (var shift = 0; a.isEven() && b.isEven(); shift++) {
            a.iushrn(1);
            b.iushrn(1);
          }
          do {
            while (a.isEven()) {
              a.iushrn(1);
            }
            while (b.isEven()) {
              b.iushrn(1);
            }
            var r = a.cmp(b);
            if (r < 0) {
              // Swap `a` and `b` to make `a` always bigger than `b`
              var t = a;
              a = b;
              b = t;
            } else if (r === 0 || b.cmpn(1) === 0) {
              break;
            }
            a.isub(b);
          } while (true);
          return b.iushln(shift);
        }; // Invert number in the field F(num)
        BN.prototype.invm = function invm(num) {
          return this.egcd(num).a.umod(num);
        };
        BN.prototype.isEven = function isEven() {
          return (this.words[0] & 1) === 0;
        };
        BN.prototype.isOdd = function isOdd() {
          return (this.words[0] & 1) === 1;
        }; // And first word and num
        BN.prototype.andln = function andln(num) {
          return this.words[0] & num;
        }; // Increment at the bit position in-line
        BN.prototype.bincn = function bincn(bit) {
          assert(typeof bit === 'number');
          var r = bit % 26;
          var s = (bit - r) / 26;
          var q = 1 << r; // Fast case: bit is much higher than all existing words
          if (this.length <= s) {
            this._expand(s + 1);
            this.words[s] |= q;
            return this;
          } // Add bit and propagate, if needed
          var carry = q;
          for (var i = s; carry !== 0 && i < this.length; i++) {
            var w = this.words[i] | 0;
            w += carry;
            carry = w >>> 26;
            w &= 0x3ffffff;
            this.words[i] = w;
          }
          if (carry !== 0) {
            this.words[i] = carry;
            this.length++;
          }
          return this;
        };
        BN.prototype.isZero = function isZero() {
          return this.length === 1 && this.words[0] === 0;
        };
        BN.prototype.cmpn = function cmpn(num) {
          var negative = num < 0;
          if (this.negative !== 0 && !negative) return -1;
          if (this.negative === 0 && negative) return 1;
          this.strip();
          var res;
          if (this.length > 1) {
            res = 1;
          } else {
            if (negative) {
              num = -num;
            }
            assert(num <= 0x3ffffff, 'Number is too big');
            var w = this.words[0] | 0;
            res = w === num ? 0 : w < num ? -1 : 1;
          }
          if (this.negative !== 0) return -res | 0;
          return res;
        }; // Compare two numbers and return:
        // 1 - if `this` > `num`
        // 0 - if `this` == `num`
        // -1 - if `this` < `num`
        BN.prototype.cmp = function cmp(num) {
          if (this.negative !== 0 && num.negative === 0) return -1;
          if (this.negative === 0 && num.negative !== 0) return 1;
          var res = this.ucmp(num);
          if (this.negative !== 0) return -res | 0;
          return res;
        }; // Unsigned comparison
        BN.prototype.ucmp = function ucmp(num) {
          // At this point both numbers have the same sign
          if (this.length > num.length) return 1;
          if (this.length < num.length) return -1;
          var res = 0;
          for (var i = this.length - 1; i >= 0; i--) {
            var a = this.words[i] | 0;
            var b = num.words[i] | 0;
            if (a === b) continue;
            if (a < b) {
              res = -1;
            } else if (a > b) {
              res = 1;
            }
            break;
          }
          return res;
        };
        BN.prototype.gtn = function gtn(num) {
          return this.cmpn(num) === 1;
        };
        BN.prototype.gt = function gt(num) {
          return this.cmp(num) === 1;
        };
        BN.prototype.gten = function gten(num) {
          return this.cmpn(num) >= 0;
        };
        BN.prototype.gte = function gte(num) {
          return this.cmp(num) >= 0;
        };
        BN.prototype.ltn = function ltn(num) {
          return this.cmpn(num) === -1;
        };
        BN.prototype.lt = function lt(num) {
          return this.cmp(num) === -1;
        };
        BN.prototype.lten = function lten(num) {
          return this.cmpn(num) <= 0;
        };
        BN.prototype.lte = function lte(num) {
          return this.cmp(num) <= 0;
        };
        BN.prototype.eqn = function eqn(num) {
          return this.cmpn(num) === 0;
        };
        BN.prototype.eq = function eq(num) {
          return this.cmp(num) === 0;
        }; //
        // A reduce context, could be using montgomery or something better, depending
        // on the `m` itself.
        //
        BN.red = function red(num) {
          return new Red(num);
        };
        BN.prototype.toRed = function toRed(ctx) {
          assert(!this.red, 'Already a number in reduction context');
          assert(this.negative === 0, 'red works only with positives');
          return ctx.convertTo(this)._forceRed(ctx);
        };
        BN.prototype.fromRed = function fromRed() {
          assert(this.red, 'fromRed works only with numbers in reduction context');
          return this.red.convertFrom(this);
        };
        BN.prototype._forceRed = function _forceRed(ctx) {
          this.red = ctx;
          return this;
        };
        BN.prototype.forceRed = function forceRed(ctx) {
          assert(!this.red, 'Already a number in reduction context');
          return this._forceRed(ctx);
        };
        BN.prototype.redAdd = function redAdd(num) {
          assert(this.red, 'redAdd works only with red numbers');
          return this.red.add(this, num);
        };
        BN.prototype.redIAdd = function redIAdd(num) {
          assert(this.red, 'redIAdd works only with red numbers');
          return this.red.iadd(this, num);
        };
        BN.prototype.redSub = function redSub(num) {
          assert(this.red, 'redSub works only with red numbers');
          return this.red.sub(this, num);
        };
        BN.prototype.redISub = function redISub(num) {
          assert(this.red, 'redISub works only with red numbers');
          return this.red.isub(this, num);
        };
        BN.prototype.redShl = function redShl(num) {
          assert(this.red, 'redShl works only with red numbers');
          return this.red.shl(this, num);
        };
        BN.prototype.redMul = function redMul(num) {
          assert(this.red, 'redMul works only with red numbers');
          this.red._verify2(this, num);
          return this.red.mul(this, num);
        };
        BN.prototype.redIMul = function redIMul(num) {
          assert(this.red, 'redMul works only with red numbers');
          this.red._verify2(this, num);
          return this.red.imul(this, num);
        };
        BN.prototype.redSqr = function redSqr() {
          assert(this.red, 'redSqr works only with red numbers');
          this.red._verify1(this);
          return this.red.sqr(this);
        };
        BN.prototype.redISqr = function redISqr() {
          assert(this.red, 'redISqr works only with red numbers');
          this.red._verify1(this);
          return this.red.isqr(this);
        }; // Square root over p
        BN.prototype.redSqrt = function redSqrt() {
          assert(this.red, 'redSqrt works only with red numbers');
          this.red._verify1(this);
          return this.red.sqrt(this);
        };
        BN.prototype.redInvm = function redInvm() {
          assert(this.red, 'redInvm works only with red numbers');
          this.red._verify1(this);
          return this.red.invm(this);
        }; // Return negative clone of `this` % `red modulo`
        BN.prototype.redNeg = function redNeg() {
          assert(this.red, 'redNeg works only with red numbers');
          this.red._verify1(this);
          return this.red.neg(this);
        };
        BN.prototype.redPow = function redPow(num) {
          assert(this.red && !num.red, 'redPow(normalNum)');
          this.red._verify1(this);
          return this.red.pow(this, num);
        }; // Prime numbers with efficient reduction
        var primes = {
          k256: null,
          p224: null,
          p192: null,
          p25519: null
        }; // Pseudo-Mersenne prime
        function MPrime(name, p) {
          // P = 2 ^ N - K
          this.name = name;
          this.p = new BN(p, 16);
          this.n = this.p.bitLength();
          this.k = new BN(1).iushln(this.n).isub(this.p);
          this.tmp = this._tmp();
        }
        MPrime.prototype._tmp = function _tmp() {
          var tmp = new BN(null);
          tmp.words = new Array(Math.ceil(this.n / 13));
          return tmp;
        };
        MPrime.prototype.ireduce = function ireduce(num) {
          // Assumes that `num` is less than `P^2`
          // num = HI * (2 ^ N - K) + HI * K + LO = HI * K + LO (mod P)
          var r = num;
          var rlen;
          do {
            this.split(r, this.tmp);
            r = this.imulK(r);
            r = r.iadd(this.tmp);
            rlen = r.bitLength();
          } while (rlen > this.n);
          var cmp = rlen < this.n ? -1 : r.ucmp(this.p);
          if (cmp === 0) {
            r.words[0] = 0;
            r.length = 1;
          } else if (cmp > 0) {
            r.isub(this.p);
          } else {
            r.strip();
          }
          return r;
        };
        MPrime.prototype.split = function split(input, out) {
          input.iushrn(this.n, 0, out);
        };
        MPrime.prototype.imulK = function imulK(num) {
          return num.imul(this.k);
        };
        function K256() {
          MPrime.call(this, 'k256', 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f');
        }
        inherits(K256, MPrime);
        K256.prototype.split = function split(input, output) {
          // 256 = 9 * 26 + 22
          var mask = 0x3fffff;
          var outLen = Math.min(input.length, 9);
          for (var i = 0; i < outLen; i++) {
            output.words[i] = input.words[i];
          }
          output.length = outLen;
          if (input.length <= 9) {
            input.words[0] = 0;
            input.length = 1;
            return;
          } // Shift by 9 limbs
          var prev = input.words[9];
          output.words[output.length++] = prev & mask;
          for (i = 10; i < input.length; i++) {
            var next = input.words[i] | 0;
            input.words[i - 10] = (next & mask) << 4 | prev >>> 22;
            prev = next;
          }
          prev >>>= 22;
          input.words[i - 10] = prev;
          if (prev === 0 && input.length > 10) {
            input.length -= 10;
          } else {
            input.length -= 9;
          }
        };
        K256.prototype.imulK = function imulK(num) {
          // K = 0x1000003d1 = [ 0x40, 0x3d1 ]
          num.words[num.length] = 0;
          num.words[num.length + 1] = 0;
          num.length += 2; // bounded at: 0x40 * 0x3ffffff + 0x3d0 = 0x100000390
          var lo = 0;
          for (var i = 0; i < num.length; i++) {
            var w = num.words[i] | 0;
            lo += w * 0x3d1;
            num.words[i] = lo & 0x3ffffff;
            lo = w * 0x40 + (lo / 0x4000000 | 0);
          } // Fast length reduction
          if (num.words[num.length - 1] === 0) {
            num.length--;
            if (num.words[num.length - 1] === 0) {
              num.length--;
            }
          }
          return num;
        };
        function P224() {
          MPrime.call(this, 'p224', 'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001');
        }
        inherits(P224, MPrime);
        function P192() {
          MPrime.call(this, 'p192', 'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff');
        }
        inherits(P192, MPrime);
        function P25519() {
          // 2 ^ 255 - 19
          MPrime.call(this, '25519', '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed');
        }
        inherits(P25519, MPrime);
        P25519.prototype.imulK = function imulK(num) {
          // K = 0x13
          var carry = 0;
          for (var i = 0; i < num.length; i++) {
            var hi = (num.words[i] | 0) * 0x13 + carry;
            var lo = hi & 0x3ffffff;
            hi >>>= 26;
            num.words[i] = lo;
            carry = hi;
          }
          if (carry !== 0) {
            num.words[num.length++] = carry;
          }
          return num;
        }; // Exported mostly for testing purposes, use plain name instead
        BN._prime = function prime(name) {
          // Cached version of prime
          if (primes[name]) return primes[name];
          var prime;
          if (name === 'k256') {
            prime = new K256();
          } else if (name === 'p224') {
            prime = new P224();
          } else if (name === 'p192') {
            prime = new P192();
          } else if (name === 'p25519') {
            prime = new P25519();
          } else {
            throw new Error('Unknown prime ' + name);
          }
          primes[name] = prime;
          return prime;
        }; //
        // Base reduction engine
        //
        function Red(m) {
          if (typeof m === 'string') {
            var prime = BN._prime(m);
            this.m = prime.p;
            this.prime = prime;
          } else {
            assert(m.gtn(1), 'modulus must be greater than 1');
            this.m = m;
            this.prime = null;
          }
        }
        Red.prototype._verify1 = function _verify1(a) {
          assert(a.negative === 0, 'red works only with positives');
          assert(a.red, 'red works only with red numbers');
        };
        Red.prototype._verify2 = function _verify2(a, b) {
          assert((a.negative | b.negative) === 0, 'red works only with positives');
          assert(a.red && a.red === b.red, 'red works only with red numbers');
        };
        Red.prototype.imod = function imod(a) {
          if (this.prime) return this.prime.ireduce(a)._forceRed(this);
          return a.umod(this.m)._forceRed(this);
        };
        Red.prototype.neg = function neg(a) {
          if (a.isZero()) {
            return a.clone();
          }
          return this.m.sub(a)._forceRed(this);
        };
        Red.prototype.add = function add(a, b) {
          this._verify2(a, b);
          var res = a.add(b);
          if (res.cmp(this.m) >= 0) {
            res.isub(this.m);
          }
          return res._forceRed(this);
        };
        Red.prototype.iadd = function iadd(a, b) {
          this._verify2(a, b);
          var res = a.iadd(b);
          if (res.cmp(this.m) >= 0) {
            res.isub(this.m);
          }
          return res;
        };
        Red.prototype.sub = function sub(a, b) {
          this._verify2(a, b);
          var res = a.sub(b);
          if (res.cmpn(0) < 0) {
            res.iadd(this.m);
          }
          return res._forceRed(this);
        };
        Red.prototype.isub = function isub(a, b) {
          this._verify2(a, b);
          var res = a.isub(b);
          if (res.cmpn(0) < 0) {
            res.iadd(this.m);
          }
          return res;
        };
        Red.prototype.shl = function shl(a, num) {
          this._verify1(a);
          return this.imod(a.ushln(num));
        };
        Red.prototype.imul = function imul(a, b) {
          this._verify2(a, b);
          return this.imod(a.imul(b));
        };
        Red.prototype.mul = function mul(a, b) {
          this._verify2(a, b);
          return this.imod(a.mul(b));
        };
        Red.prototype.isqr = function isqr(a) {
          return this.imul(a, a.clone());
        };
        Red.prototype.sqr = function sqr(a) {
          return this.mul(a, a);
        };
        Red.prototype.sqrt = function sqrt(a) {
          if (a.isZero()) return a.clone();
          var mod3 = this.m.andln(3);
          assert(mod3 % 2 === 1); // Fast case
          if (mod3 === 3) {
            var pow = this.m.add(new BN(1)).iushrn(2);
            return this.pow(a, pow);
          } // Tonelli-Shanks algorithm (Totally unoptimized and slow)
          //
          // Find Q and S, that Q * 2 ^ S = (P - 1)
          var q = this.m.subn(1);
          var s = 0;
          while (!q.isZero() && q.andln(1) === 0) {
            s++;
            q.iushrn(1);
          }
          assert(!q.isZero());
          var one = new BN(1).toRed(this);
          var nOne = one.redNeg(); // Find quadratic non-residue
          // NOTE: Max is such because of generalized Riemann hypothesis.
          var lpow = this.m.subn(1).iushrn(1);
          var z = this.m.bitLength();
          z = new BN(2 * z * z).toRed(this);
          while (this.pow(z, lpow).cmp(nOne) !== 0) {
            z.redIAdd(nOne);
          }
          var c = this.pow(z, q);
          var r = this.pow(a, q.addn(1).iushrn(1));
          var t = this.pow(a, q);
          var m = s;
          while (t.cmp(one) !== 0) {
            var tmp = t;
            for (var i = 0; tmp.cmp(one) !== 0; i++) {
              tmp = tmp.redSqr();
            }
            assert(i < m);
            var b = this.pow(c, new BN(1).iushln(m - i - 1));
            r = r.redMul(b);
            c = b.redSqr();
            t = t.redMul(c);
            m = i;
          }
          return r;
        };
        Red.prototype.invm = function invm(a) {
          var inv = a._invmp(this.m);
          if (inv.negative !== 0) {
            inv.negative = 0;
            return this.imod(inv).redNeg();
          } else {
            return this.imod(inv);
          }
        };
        Red.prototype.pow = function pow(a, num) {
          if (num.isZero()) return new BN(1).toRed(this);
          if (num.cmpn(1) === 0) return a.clone();
          var windowSize = 4;
          var wnd = new Array(1 << windowSize);
          wnd[0] = new BN(1).toRed(this);
          wnd[1] = a;
          for (var i = 2; i < wnd.length; i++) {
            wnd[i] = this.mul(wnd[i - 1], a);
          }
          var res = wnd[0];
          var current = 0;
          var currentLen = 0;
          var start = num.bitLength() % 26;
          if (start === 0) {
            start = 26;
          }
          for (i = num.length - 1; i >= 0; i--) {
            var word = num.words[i];
            for (var j = start - 1; j >= 0; j--) {
              var bit = word >> j & 1;
              if (res !== wnd[0]) {
                res = this.sqr(res);
              }
              if (bit === 0 && current === 0) {
                currentLen = 0;
                continue;
              }
              current <<= 1;
              current |= bit;
              currentLen++;
              if (currentLen !== windowSize && (i !== 0 || j !== 0)) continue;
              res = this.mul(res, wnd[current]);
              currentLen = 0;
              current = 0;
            }
            start = 26;
          }
          return res;
        };
        Red.prototype.convertTo = function convertTo(num) {
          var r = num.umod(this.m);
          return r === num ? r.clone() : r;
        };
        Red.prototype.convertFrom = function convertFrom(num) {
          var res = num.clone();
          res.red = null;
          return res;
        }; //
        // Montgomery method engine
        //
        BN.mont = function mont(num) {
          return new Mont(num);
        };
        function Mont(m) {
          Red.call(this, m);
          this.shift = this.m.bitLength();
          if (this.shift % 26 !== 0) {
            this.shift += 26 - this.shift % 26;
          }
          this.r = new BN(1).iushln(this.shift);
          this.r2 = this.imod(this.r.sqr());
          this.rinv = this.r._invmp(this.m);
          this.minv = this.rinv.mul(this.r).isubn(1).div(this.m);
          this.minv = this.minv.umod(this.r);
          this.minv = this.r.sub(this.minv);
        }
        inherits(Mont, Red);
        Mont.prototype.convertTo = function convertTo(num) {
          return this.imod(num.ushln(this.shift));
        };
        Mont.prototype.convertFrom = function convertFrom(num) {
          var r = this.imod(num.mul(this.rinv));
          r.red = null;
          return r;
        };
        Mont.prototype.imul = function imul(a, b) {
          if (a.isZero() || b.isZero()) {
            a.words[0] = 0;
            a.length = 1;
            return a;
          }
          var t = a.imul(b);
          var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
          var u = t.isub(c).iushrn(this.shift);
          var res = u;
          if (u.cmp(this.m) >= 0) {
            res = u.isub(this.m);
          } else if (u.cmpn(0) < 0) {
            res = u.iadd(this.m);
          }
          return res._forceRed(this);
        };
        Mont.prototype.mul = function mul(a, b) {
          if (a.isZero() || b.isZero()) return new BN(0)._forceRed(this);
          var t = a.mul(b);
          var c = t.maskn(this.shift).mul(this.minv).imaskn(this.shift).mul(this.m);
          var u = t.isub(c).iushrn(this.shift);
          var res = u;
          if (u.cmp(this.m) >= 0) {
            res = u.isub(this.m);
          } else if (u.cmpn(0) < 0) {
            res = u.iadd(this.m);
          }
          return res._forceRed(this);
        };
        Mont.prototype.invm = function invm(a) {
          // (AR)^-1 * R^2 = (A^-1 * R^-1) * R^2 = A^-1 * R
          var res = this.imod(a._invmp(this.m).mul(this.r2));
          return res._forceRed(this);
        };
      })(typeof module === 'undefined' || module, this);
    }, {
      "buffer": "buffer"
    }],
    18: [function (require, module, exports) {
      var r;
      module.exports = function rand(len) {
        if (!r) r = new Rand(null);
        return r.generate(len);
      };
      function Rand(rand) {
        this.rand = rand;
      }
      module.exports.Rand = Rand;
      Rand.prototype.generate = function generate(len) {
        return this._rand(len);
      }; // Emulate crypto API using randy
      Rand.prototype._rand = function _rand(n) {
        if (this.rand.getBytes) return this.rand.getBytes(n);
        var res = new Uint8Array(n);
        for (var i = 0; i < res.length; i++) {
          res[i] = this.rand.getByte();
        }
        return res;
      };
      if ((typeof self === "undefined" ? "undefined" : _typeof(self)) === 'object') {
        if (self.crypto && self.crypto.getRandomValues) {
          // Modern browsers
          Rand.prototype._rand = function _rand(n) {
            var arr = new Uint8Array(n);
            self.crypto.getRandomValues(arr);
            return arr;
          };
        } else if (self.msCrypto && self.msCrypto.getRandomValues) {
          // IE
          Rand.prototype._rand = function _rand(n) {
            var arr = new Uint8Array(n);
            self.msCrypto.getRandomValues(arr);
            return arr;
          }; // Safari's WebWorkers do not have `crypto`
        } else if ((typeof window === "undefined" ? "undefined" : _typeof(window)) === 'object') {
          // Old junk
          Rand.prototype._rand = function () {
            throw new Error('Not implemented yet');
          };
        }
      } else {
        // Node.js or Web worker with no crypto support
        try {
          var crypto = require('crypto');
          if (typeof crypto.randomBytes !== 'function') throw new Error('Not supported');
          Rand.prototype._rand = function _rand(n) {
            return crypto.randomBytes(n);
          };
        } catch (e) {}
      }
    }, {
      "crypto": "crypto"
    }],
    19: [function (require, module, exports) {
      'use strict';

      var elliptic = exports;
      elliptic.utils = require('./elliptic/utils');
      elliptic.rand = require('brorand');
      elliptic.curve = require('./elliptic/curve');
      elliptic.curves = require('./elliptic/curves'); // Protocols
      elliptic.ec = require('./elliptic/ec');
      elliptic.eddsa = require('./elliptic/eddsa');
    }, {
      "./elliptic/curve": 22,
      "./elliptic/curves": 25,
      "./elliptic/ec": 26,
      "./elliptic/eddsa": 29,
      "./elliptic/utils": 33,
      "brorand": 18
    }],
    20: [function (require, module, exports) {
      'use strict';

      var BN = require('bn.js');
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var getNAF = utils.getNAF;
      var getJSF = utils.getJSF;
      var assert = utils.assert;
      function BaseCurve(type, conf) {
        this.type = type;
        this.p = new BN(conf.p, 16); // Use Montgomery, when there is no fast reduction for the prime
        this.red = conf.prime ? BN.red(conf.prime) : BN.mont(this.p); // Useful for many curves
        this.zero = new BN(0).toRed(this.red);
        this.one = new BN(1).toRed(this.red);
        this.two = new BN(2).toRed(this.red); // Curve configuration, optional
        this.n = conf.n && new BN(conf.n, 16);
        this.g = conf.g && this.pointFromJSON(conf.g, conf.gRed); // Temporary arrays
        this._wnafT1 = new Array(4);
        this._wnafT2 = new Array(4);
        this._wnafT3 = new Array(4);
        this._wnafT4 = new Array(4); // Generalized Greg Maxwell's trick
        var adjustCount = this.n && this.p.div(this.n);
        if (!adjustCount || adjustCount.cmpn(100) > 0) {
          this.redN = null;
        } else {
          this._maxwellTrick = true;
          this.redN = this.n.toRed(this.red);
        }
      }
      module.exports = BaseCurve;
      BaseCurve.prototype.point = function point() {
        throw new Error('Not implemented');
      };
      BaseCurve.prototype.validate = function validate() {
        throw new Error('Not implemented');
      };
      BaseCurve.prototype._fixedNafMul = function _fixedNafMul(p, k) {
        assert(p.precomputed);
        var doubles = p._getDoubles();
        var naf = getNAF(k, 1);
        var I = (1 << doubles.step + 1) - (doubles.step % 2 === 0 ? 2 : 1);
        I /= 3; // Translate into more windowed form
        var repr = [];
        for (var j = 0; j < naf.length; j += doubles.step) {
          var nafW = 0;
          for (var k = j + doubles.step - 1; k >= j; k--) {
            nafW = (nafW << 1) + naf[k];
          }
          repr.push(nafW);
        }
        var a = this.jpoint(null, null, null);
        var b = this.jpoint(null, null, null);
        for (var i = I; i > 0; i--) {
          for (var j = 0; j < repr.length; j++) {
            var nafW = repr[j];
            if (nafW === i) b = b.mixedAdd(doubles.points[j]);else if (nafW === -i) b = b.mixedAdd(doubles.points[j].neg());
          }
          a = a.add(b);
        }
        return a.toP();
      };
      BaseCurve.prototype._wnafMul = function _wnafMul(p, k) {
        var w = 4; // Precompute window
        var nafPoints = p._getNAFPoints(w);
        w = nafPoints.wnd;
        var wnd = nafPoints.points; // Get NAF form
        var naf = getNAF(k, w); // Add `this`*(N+1) for every w-NAF index
        var acc = this.jpoint(null, null, null);
        for (var i = naf.length - 1; i >= 0; i--) {
          // Count zeroes
          for (var k = 0; i >= 0 && naf[i] === 0; i--) {
            k++;
          }
          if (i >= 0) k++;
          acc = acc.dblp(k);
          if (i < 0) break;
          var z = naf[i];
          assert(z !== 0);
          if (p.type === 'affine') {
            // J +- P
            if (z > 0) acc = acc.mixedAdd(wnd[z - 1 >> 1]);else acc = acc.mixedAdd(wnd[-z - 1 >> 1].neg());
          } else {
            // J +- J
            if (z > 0) acc = acc.add(wnd[z - 1 >> 1]);else acc = acc.add(wnd[-z - 1 >> 1].neg());
          }
        }
        return p.type === 'affine' ? acc.toP() : acc;
      };
      BaseCurve.prototype._wnafMulAdd = function _wnafMulAdd(defW, points, coeffs, len, jacobianResult) {
        var wndWidth = this._wnafT1;
        var wnd = this._wnafT2;
        var naf = this._wnafT3; // Fill all arrays
        var max = 0;
        for (var i = 0; i < len; i++) {
          var p = points[i];
          var nafPoints = p._getNAFPoints(defW);
          wndWidth[i] = nafPoints.wnd;
          wnd[i] = nafPoints.points;
        } // Comb small window NAFs
        for (var i = len - 1; i >= 1; i -= 2) {
          var a = i - 1;
          var b = i;
          if (wndWidth[a] !== 1 || wndWidth[b] !== 1) {
            naf[a] = getNAF(coeffs[a], wndWidth[a]);
            naf[b] = getNAF(coeffs[b], wndWidth[b]);
            max = Math.max(naf[a].length, max);
            max = Math.max(naf[b].length, max);
            continue;
          }
          var comb = [points[a], /* 1 */null, /* 3 */null, /* 5 */points[b] /* 7 */]; // Try to avoid Projective points, if possible
          if (points[a].y.cmp(points[b].y) === 0) {
            comb[1] = points[a].add(points[b]);
            comb[2] = points[a].toJ().mixedAdd(points[b].neg());
          } else if (points[a].y.cmp(points[b].y.redNeg()) === 0) {
            comb[1] = points[a].toJ().mixedAdd(points[b]);
            comb[2] = points[a].add(points[b].neg());
          } else {
            comb[1] = points[a].toJ().mixedAdd(points[b]);
            comb[2] = points[a].toJ().mixedAdd(points[b].neg());
          }
          var index = [-3, /* -1 -1 */-1, /* -1 0 */-5, /* -1 1 */-7, /* 0 -1 */0, /* 0 0 */7, /* 0 1 */5, /* 1 -1 */1, /* 1 0 */3 /* 1 1 */];
          var jsf = getJSF(coeffs[a], coeffs[b]);
          max = Math.max(jsf[0].length, max);
          naf[a] = new Array(max);
          naf[b] = new Array(max);
          for (var j = 0; j < max; j++) {
            var ja = jsf[0][j] | 0;
            var jb = jsf[1][j] | 0;
            naf[a][j] = index[(ja + 1) * 3 + (jb + 1)];
            naf[b][j] = 0;
            wnd[a] = comb;
          }
        }
        var acc = this.jpoint(null, null, null);
        var tmp = this._wnafT4;
        for (var i = max; i >= 0; i--) {
          var k = 0;
          while (i >= 0) {
            var zero = true;
            for (var j = 0; j < len; j++) {
              tmp[j] = naf[j][i] | 0;
              if (tmp[j] !== 0) zero = false;
            }
            if (!zero) break;
            k++;
            i--;
          }
          if (i >= 0) k++;
          acc = acc.dblp(k);
          if (i < 0) break;
          for (var j = 0; j < len; j++) {
            var z = tmp[j];
            var p;
            if (z === 0) continue;else if (z > 0) p = wnd[j][z - 1 >> 1];else if (z < 0) p = wnd[j][-z - 1 >> 1].neg();
            if (p.type === 'affine') acc = acc.mixedAdd(p);else acc = acc.add(p);
          }
        } // Zeroify references
        for (var i = 0; i < len; i++) {
          wnd[i] = null;
        }
        if (jacobianResult) return acc;else return acc.toP();
      };
      function BasePoint(curve, type) {
        this.curve = curve;
        this.type = type;
        this.precomputed = null;
      }
      BaseCurve.BasePoint = BasePoint;
      BasePoint.prototype.eq = function eq() /*other*/{
        throw new Error('Not implemented');
      };
      BasePoint.prototype.validate = function validate() {
        return this.curve.validate(this);
      };
      BaseCurve.prototype.decodePoint = function decodePoint(bytes, enc) {
        bytes = utils.toArray(bytes, enc);
        var len = this.p.byteLength(); // uncompressed, hybrid-odd, hybrid-even
        if ((bytes[0] === 0x04 || bytes[0] === 0x06 || bytes[0] === 0x07) && bytes.length - 1 === 2 * len) {
          if (bytes[0] === 0x06) assert(bytes[bytes.length - 1] % 2 === 0);else if (bytes[0] === 0x07) assert(bytes[bytes.length - 1] % 2 === 1);
          var res = this.point(bytes.slice(1, 1 + len), bytes.slice(1 + len, 1 + 2 * len));
          return res;
        } else if ((bytes[0] === 0x02 || bytes[0] === 0x03) && bytes.length - 1 === len) {
          return this.pointFromX(bytes.slice(1, 1 + len), bytes[0] === 0x03);
        }
        throw new Error('Unknown point format');
      };
      BasePoint.prototype.encodeCompressed = function encodeCompressed(enc) {
        return this.encode(enc, true);
      };
      BasePoint.prototype._encode = function _encode(compact) {
        var len = this.curve.p.byteLength();
        var x = this.getX().toArray('be', len);
        if (compact) return [this.getY().isEven() ? 0x02 : 0x03].concat(x);
        return [0x04].concat(x, this.getY().toArray('be', len));
      };
      BasePoint.prototype.encode = function encode(enc, compact) {
        return utils.encode(this._encode(compact), enc);
      };
      BasePoint.prototype.precompute = function precompute(power) {
        if (this.precomputed) return this;
        var precomputed = {
          doubles: null,
          naf: null,
          beta: null
        };
        precomputed.naf = this._getNAFPoints(8);
        precomputed.doubles = this._getDoubles(4, power);
        precomputed.beta = this._getBeta();
        this.precomputed = precomputed;
        return this;
      };
      BasePoint.prototype._hasDoubles = function _hasDoubles(k) {
        if (!this.precomputed) return false;
        var doubles = this.precomputed.doubles;
        if (!doubles) return false;
        return doubles.points.length >= Math.ceil((k.bitLength() + 1) / doubles.step);
      };
      BasePoint.prototype._getDoubles = function _getDoubles(step, power) {
        if (this.precomputed && this.precomputed.doubles) return this.precomputed.doubles;
        var doubles = [this];
        var acc = this;
        for (var i = 0; i < power; i += step) {
          for (var j = 0; j < step; j++) {
            acc = acc.dbl();
          }
          doubles.push(acc);
        }
        return {
          step: step,
          points: doubles
        };
      };
      BasePoint.prototype._getNAFPoints = function _getNAFPoints(wnd) {
        if (this.precomputed && this.precomputed.naf) return this.precomputed.naf;
        var res = [this];
        var max = (1 << wnd) - 1;
        var dbl = max === 1 ? null : this.dbl();
        for (var i = 1; i < max; i++) {
          res[i] = res[i - 1].add(dbl);
        }
        return {
          wnd: wnd,
          points: res
        };
      };
      BasePoint.prototype._getBeta = function _getBeta() {
        return null;
      };
      BasePoint.prototype.dblp = function dblp(k) {
        var r = this;
        for (var i = 0; i < k; i++) {
          r = r.dbl();
        }
        return r;
      };
    }, {
      "../../elliptic": 19,
      "bn.js": 17
    }],
    21: [function (require, module, exports) {
      'use strict';

      var curve = require('../curve');
      var elliptic = require('../../elliptic');
      var BN = require('bn.js');
      var inherits = require('inherits');
      var Base = curve.base;
      var assert = elliptic.utils.assert;
      function EdwardsCurve(conf) {
        // NOTE: Important as we are creating point in Base.call()
        this.twisted = (conf.a | 0) !== 1;
        this.mOneA = this.twisted && (conf.a | 0) === -1;
        this.extended = this.mOneA;
        Base.call(this, 'edwards', conf);
        this.a = new BN(conf.a, 16).umod(this.red.m);
        this.a = this.a.toRed(this.red);
        this.c = new BN(conf.c, 16).toRed(this.red);
        this.c2 = this.c.redSqr();
        this.d = new BN(conf.d, 16).toRed(this.red);
        this.dd = this.d.redAdd(this.d);
        assert(!this.twisted || this.c.fromRed().cmpn(1) === 0);
        this.oneC = (conf.c | 0) === 1;
      }
      inherits(EdwardsCurve, Base);
      module.exports = EdwardsCurve;
      EdwardsCurve.prototype._mulA = function _mulA(num) {
        if (this.mOneA) return num.redNeg();else return this.a.redMul(num);
      };
      EdwardsCurve.prototype._mulC = function _mulC(num) {
        if (this.oneC) return num;else return this.c.redMul(num);
      }; // Just for compatibility with Short curve
      EdwardsCurve.prototype.jpoint = function jpoint(x, y, z, t) {
        return this.point(x, y, z, t);
      };
      EdwardsCurve.prototype.pointFromX = function pointFromX(x, odd) {
        x = new BN(x, 16);
        if (!x.red) x = x.toRed(this.red);
        var x2 = x.redSqr();
        var rhs = this.c2.redSub(this.a.redMul(x2));
        var lhs = this.one.redSub(this.c2.redMul(this.d).redMul(x2));
        var y2 = rhs.redMul(lhs.redInvm());
        var y = y2.redSqrt();
        if (y.redSqr().redSub(y2).cmp(this.zero) !== 0) throw new Error('invalid point');
        var isOdd = y.fromRed().isOdd();
        if (odd && !isOdd || !odd && isOdd) y = y.redNeg();
        return this.point(x, y);
      };
      EdwardsCurve.prototype.pointFromY = function pointFromY(y, odd) {
        y = new BN(y, 16);
        if (!y.red) y = y.toRed(this.red); // x^2 = (y^2 - c^2) / (c^2 d y^2 - a)
        var y2 = y.redSqr();
        var lhs = y2.redSub(this.c2);
        var rhs = y2.redMul(this.d).redMul(this.c2).redSub(this.a);
        var x2 = lhs.redMul(rhs.redInvm());
        if (x2.cmp(this.zero) === 0) {
          if (odd) throw new Error('invalid point');else return this.point(this.zero, y);
        }
        var x = x2.redSqrt();
        if (x.redSqr().redSub(x2).cmp(this.zero) !== 0) throw new Error('invalid point');
        if (x.fromRed().isOdd() !== odd) x = x.redNeg();
        return this.point(x, y);
      };
      EdwardsCurve.prototype.validate = function validate(point) {
        if (point.isInfinity()) return true; // Curve: A * X^2 + Y^2 = C^2 * (1 + D * X^2 * Y^2)
        point.normalize();
        var x2 = point.x.redSqr();
        var y2 = point.y.redSqr();
        var lhs = x2.redMul(this.a).redAdd(y2);
        var rhs = this.c2.redMul(this.one.redAdd(this.d.redMul(x2).redMul(y2)));
        return lhs.cmp(rhs) === 0;
      };
      function Point(curve, x, y, z, t) {
        Base.BasePoint.call(this, curve, 'projective');
        if (x === null && y === null && z === null) {
          this.x = this.curve.zero;
          this.y = this.curve.one;
          this.z = this.curve.one;
          this.t = this.curve.zero;
          this.zOne = true;
        } else {
          this.x = new BN(x, 16);
          this.y = new BN(y, 16);
          this.z = z ? new BN(z, 16) : this.curve.one;
          this.t = t && new BN(t, 16);
          if (!this.x.red) this.x = this.x.toRed(this.curve.red);
          if (!this.y.red) this.y = this.y.toRed(this.curve.red);
          if (!this.z.red) this.z = this.z.toRed(this.curve.red);
          if (this.t && !this.t.red) this.t = this.t.toRed(this.curve.red);
          this.zOne = this.z === this.curve.one; // Use extended coordinates
          if (this.curve.extended && !this.t) {
            this.t = this.x.redMul(this.y);
            if (!this.zOne) this.t = this.t.redMul(this.z.redInvm());
          }
        }
      }
      inherits(Point, Base.BasePoint);
      EdwardsCurve.prototype.pointFromJSON = function pointFromJSON(obj) {
        return Point.fromJSON(this, obj);
      };
      EdwardsCurve.prototype.point = function point(x, y, z, t) {
        return new Point(this, x, y, z, t);
      };
      Point.fromJSON = function fromJSON(curve, obj) {
        return new Point(curve, obj[0], obj[1], obj[2]);
      };
      Point.prototype.inspect = function inspect() {
        if (this.isInfinity()) return '<EC Point Infinity>';
        return '<EC Point x: ' + this.x.fromRed().toString(16, 2) + ' y: ' + this.y.fromRed().toString(16, 2) + ' z: ' + this.z.fromRed().toString(16, 2) + '>';
      };
      Point.prototype.isInfinity = function isInfinity() {
        // XXX This code assumes that zero is always zero in red
        return this.x.cmpn(0) === 0 && (this.y.cmp(this.z) === 0 || this.zOne && this.y.cmp(this.curve.c) === 0);
      };
      Point.prototype._extDbl = function _extDbl() {
        // hyperelliptic.org/EFD/g1p/auto-twisted-extended-1.html
        //     #doubling-dbl-2008-hwcd
        // 4M + 4S
        // A = X1^2
        var a = this.x.redSqr(); // B = Y1^2
        var b = this.y.redSqr(); // C = 2 * Z1^2
        var c = this.z.redSqr();
        c = c.redIAdd(c); // D = a * A
        var d = this.curve._mulA(a); // E = (X1 + Y1)^2 - A - B
        var e = this.x.redAdd(this.y).redSqr().redISub(a).redISub(b); // G = D + B
        var g = d.redAdd(b); // F = G - C
        var f = g.redSub(c); // H = D - B
        var h = d.redSub(b); // X3 = E * F
        var nx = e.redMul(f); // Y3 = G * H
        var ny = g.redMul(h); // T3 = E * H
        var nt = e.redMul(h); // Z3 = F * G
        var nz = f.redMul(g);
        return this.curve.point(nx, ny, nz, nt);
      };
      Point.prototype._projDbl = function _projDbl() {
        // hyperelliptic.org/EFD/g1p/auto-twisted-projective.html
        //     #doubling-dbl-2008-bbjlp
        //     #doubling-dbl-2007-bl
        // and others
        // Generally 3M + 4S or 2M + 4S
        // B = (X1 + Y1)^2
        var b = this.x.redAdd(this.y).redSqr(); // C = X1^2
        var c = this.x.redSqr(); // D = Y1^2
        var d = this.y.redSqr();
        var nx;
        var ny;
        var nz;
        if (this.curve.twisted) {
          // E = a * C
          var e = this.curve._mulA(c); // F = E + D
          var f = e.redAdd(d);
          if (this.zOne) {
            // X3 = (B - C - D) * (F - 2)
            nx = b.redSub(c).redSub(d).redMul(f.redSub(this.curve.two)); // Y3 = F * (E - D)
            ny = f.redMul(e.redSub(d)); // Z3 = F^2 - 2 * F
            nz = f.redSqr().redSub(f).redSub(f);
          } else {
            // H = Z1^2
            var h = this.z.redSqr(); // J = F - 2 * H
            var j = f.redSub(h).redISub(h); // X3 = (B-C-D)*J
            nx = b.redSub(c).redISub(d).redMul(j); // Y3 = F * (E - D)
            ny = f.redMul(e.redSub(d)); // Z3 = F * J
            nz = f.redMul(j);
          }
        } else {
          // E = C + D
          var e = c.redAdd(d); // H = (c * Z1)^2
          var h = this.curve._mulC(this.z).redSqr(); // J = E - 2 * H
          var j = e.redSub(h).redSub(h); // X3 = c * (B - E) * J
          nx = this.curve._mulC(b.redISub(e)).redMul(j); // Y3 = c * E * (C - D)
          ny = this.curve._mulC(e).redMul(c.redISub(d)); // Z3 = E * J
          nz = e.redMul(j);
        }
        return this.curve.point(nx, ny, nz);
      };
      Point.prototype.dbl = function dbl() {
        if (this.isInfinity()) return this; // Double in extended coordinates
        if (this.curve.extended) return this._extDbl();else return this._projDbl();
      };
      Point.prototype._extAdd = function _extAdd(p) {
        // hyperelliptic.org/EFD/g1p/auto-twisted-extended-1.html
        //     #addition-add-2008-hwcd-3
        // 8M
        // A = (Y1 - X1) * (Y2 - X2)
        var a = this.y.redSub(this.x).redMul(p.y.redSub(p.x)); // B = (Y1 + X1) * (Y2 + X2)
        var b = this.y.redAdd(this.x).redMul(p.y.redAdd(p.x)); // C = T1 * k * T2
        var c = this.t.redMul(this.curve.dd).redMul(p.t); // D = Z1 * 2 * Z2
        var d = this.z.redMul(p.z.redAdd(p.z)); // E = B - A
        var e = b.redSub(a); // F = D - C
        var f = d.redSub(c); // G = D + C
        var g = d.redAdd(c); // H = B + A
        var h = b.redAdd(a); // X3 = E * F
        var nx = e.redMul(f); // Y3 = G * H
        var ny = g.redMul(h); // T3 = E * H
        var nt = e.redMul(h); // Z3 = F * G
        var nz = f.redMul(g);
        return this.curve.point(nx, ny, nz, nt);
      };
      Point.prototype._projAdd = function _projAdd(p) {
        // hyperelliptic.org/EFD/g1p/auto-twisted-projective.html
        //     #addition-add-2008-bbjlp
        //     #addition-add-2007-bl
        // 10M + 1S
        // A = Z1 * Z2
        var a = this.z.redMul(p.z); // B = A^2
        var b = a.redSqr(); // C = X1 * X2
        var c = this.x.redMul(p.x); // D = Y1 * Y2
        var d = this.y.redMul(p.y); // E = d * C * D
        var e = this.curve.d.redMul(c).redMul(d); // F = B - E
        var f = b.redSub(e); // G = B + E
        var g = b.redAdd(e); // X3 = A * F * ((X1 + Y1) * (X2 + Y2) - C - D)
        var tmp = this.x.redAdd(this.y).redMul(p.x.redAdd(p.y)).redISub(c).redISub(d);
        var nx = a.redMul(f).redMul(tmp);
        var ny;
        var nz;
        if (this.curve.twisted) {
          // Y3 = A * G * (D - a * C)
          ny = a.redMul(g).redMul(d.redSub(this.curve._mulA(c))); // Z3 = F * G
          nz = f.redMul(g);
        } else {
          // Y3 = A * G * (D - C)
          ny = a.redMul(g).redMul(d.redSub(c)); // Z3 = c * F * G
          nz = this.curve._mulC(f).redMul(g);
        }
        return this.curve.point(nx, ny, nz);
      };
      Point.prototype.add = function add(p) {
        if (this.isInfinity()) return p;
        if (p.isInfinity()) return this;
        if (this.curve.extended) return this._extAdd(p);else return this._projAdd(p);
      };
      Point.prototype.mul = function mul(k) {
        if (this._hasDoubles(k)) return this.curve._fixedNafMul(this, k);else return this.curve._wnafMul(this, k);
      };
      Point.prototype.mulAdd = function mulAdd(k1, p, k2) {
        return this.curve._wnafMulAdd(1, [this, p], [k1, k2], 2, false);
      };
      Point.prototype.jmulAdd = function jmulAdd(k1, p, k2) {
        return this.curve._wnafMulAdd(1, [this, p], [k1, k2], 2, true);
      };
      Point.prototype.normalize = function normalize() {
        if (this.zOne) return this; // Normalize coordinates
        var zi = this.z.redInvm();
        this.x = this.x.redMul(zi);
        this.y = this.y.redMul(zi);
        if (this.t) this.t = this.t.redMul(zi);
        this.z = this.curve.one;
        this.zOne = true;
        return this;
      };
      Point.prototype.neg = function neg() {
        return this.curve.point(this.x.redNeg(), this.y, this.z, this.t && this.t.redNeg());
      };
      Point.prototype.getX = function getX() {
        this.normalize();
        return this.x.fromRed();
      };
      Point.prototype.getY = function getY() {
        this.normalize();
        return this.y.fromRed();
      };
      Point.prototype.eq = function eq(other) {
        return this === other || this.getX().cmp(other.getX()) === 0 && this.getY().cmp(other.getY()) === 0;
      };
      Point.prototype.eqXToP = function eqXToP(x) {
        var rx = x.toRed(this.curve.red).redMul(this.z);
        if (this.x.cmp(rx) === 0) return true;
        var xc = x.clone();
        var t = this.curve.redN.redMul(this.z);
        for (;;) {
          xc.iadd(this.curve.n);
          if (xc.cmp(this.curve.p) >= 0) return false;
          rx.redIAdd(t);
          if (this.x.cmp(rx) === 0) return true;
        }
      }; // Compatibility with BaseCurve
      Point.prototype.toP = Point.prototype.normalize;
      Point.prototype.mixedAdd = Point.prototype.add;
    }, {
      "../../elliptic": 19,
      "../curve": 22,
      "bn.js": 17,
      "inherits": 48
    }],
    22: [function (require, module, exports) {
      'use strict';

      var curve = exports;
      curve.base = require('./base');
      curve["short"] = require('./short');
      curve.mont = require('./mont');
      curve.edwards = require('./edwards');
    }, {
      "./base": 20,
      "./edwards": 21,
      "./mont": 23,
      "./short": 24
    }],
    23: [function (require, module, exports) {
      'use strict';

      var curve = require('../curve');
      var BN = require('bn.js');
      var inherits = require('inherits');
      var Base = curve.base;
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      function MontCurve(conf) {
        Base.call(this, 'mont', conf);
        this.a = new BN(conf.a, 16).toRed(this.red);
        this.b = new BN(conf.b, 16).toRed(this.red);
        this.i4 = new BN(4).toRed(this.red).redInvm();
        this.two = new BN(2).toRed(this.red); // Note: this implementation is according to the original paper
        // by P. Montgomery, NOT the one by D. J. Bernstein.
        this.a24 = this.i4.redMul(this.a.redAdd(this.two));
      }
      inherits(MontCurve, Base);
      module.exports = MontCurve;
      MontCurve.prototype.validate = function validate(point) {
        var x = point.normalize().x;
        var x2 = x.redSqr();
        var rhs = x2.redMul(x).redAdd(x2.redMul(this.a)).redAdd(x);
        var y = rhs.redSqrt();
        return y.redSqr().cmp(rhs) === 0;
      };
      function Point(curve, x, z) {
        Base.BasePoint.call(this, curve, 'projective');
        if (x === null && z === null) {
          this.x = this.curve.one;
          this.z = this.curve.zero;
        } else {
          this.x = new BN(x, 16);
          this.z = new BN(z, 16);
          if (!this.x.red) this.x = this.x.toRed(this.curve.red);
          if (!this.z.red) this.z = this.z.toRed(this.curve.red);
        }
      }
      inherits(Point, Base.BasePoint);
      MontCurve.prototype.decodePoint = function decodePoint(bytes, enc) {
        var bytes = utils.toArray(bytes, enc); // TODO Curve448
        // Montgomery curve points must be represented in the compressed format
        // https://tools.ietf.org/html/draft-ietf-openpgp-rfc4880bis-02#appendix-B
        if (bytes.length === 33 && bytes[0] === 0x40) bytes = bytes.slice(1, 33).reverse(); // point must be little-endian
        if (bytes.length !== 32) throw new Error('Unknown point compression format');
        return this.point(bytes, 1);
      };
      MontCurve.prototype.point = function point(x, z) {
        return new Point(this, x, z);
      };
      MontCurve.prototype.pointFromJSON = function pointFromJSON(obj) {
        return Point.fromJSON(this, obj);
      };
      Point.prototype.precompute = function precompute() {// No-op
      };
      Point.prototype._encode = function _encode(compact) {
        var len = this.curve.p.byteLength(); // Note: the output should always be little-endian
        // https://tools.ietf.org/html/draft-ietf-openpgp-rfc4880bis-02#appendix-B
        if (compact) {
          return [0x40].concat(this.getX().toArray('le', len));
        } else {
          return this.getX().toArray('be', len);
        }
      };
      Point.fromJSON = function fromJSON(curve, obj) {
        return new Point(curve, obj[0], obj[1] || curve.one);
      };
      Point.prototype.inspect = function inspect() {
        if (this.isInfinity()) return '<EC Point Infinity>';
        return '<EC Point x: ' + this.x.fromRed().toString(16, 2) + ' z: ' + this.z.fromRed().toString(16, 2) + '>';
      };
      Point.prototype.isInfinity = function isInfinity() {
        // XXX This code assumes that zero is always zero in red
        return this.z.cmpn(0) === 0;
      };
      Point.prototype.dbl = function dbl() {
        // http://hyperelliptic.org/EFD/g1p/auto-montgom-xz.html#doubling-dbl-1987-m-3
        // 2M + 2S + 4A
        // A = X1 + Z1
        var a = this.x.redAdd(this.z); // AA = A^2
        var aa = a.redSqr(); // B = X1 - Z1
        var b = this.x.redSub(this.z); // BB = B^2
        var bb = b.redSqr(); // C = AA - BB
        var c = aa.redSub(bb); // X3 = AA * BB
        var nx = aa.redMul(bb); // Z3 = C * (BB + A24 * C)
        var nz = c.redMul(bb.redAdd(this.curve.a24.redMul(c)));
        return this.curve.point(nx, nz);
      };
      Point.prototype.add = function add() {
        throw new Error('Not supported on Montgomery curve');
      };
      Point.prototype.diffAdd = function diffAdd(p, diff) {
        // http://hyperelliptic.org/EFD/g1p/auto-montgom-xz.html#diffadd-dadd-1987-m-3
        // 4M + 2S + 6A
        // A = X2 + Z2
        var a = this.x.redAdd(this.z); // B = X2 - Z2
        var b = this.x.redSub(this.z); // C = X3 + Z3
        var c = p.x.redAdd(p.z); // D = X3 - Z3
        var d = p.x.redSub(p.z); // DA = D * A
        var da = d.redMul(a); // CB = C * B
        var cb = c.redMul(b); // X5 = Z1 * (DA + CB)^2
        var nx = diff.z.redMul(da.redAdd(cb).redSqr()); // Z5 = X1 * (DA - CB)^2
        var nz = diff.x.redMul(da.redISub(cb).redSqr());
        return this.curve.point(nx, nz);
      };
      Point.prototype.mul = function mul(k) {
        k = new BN(k, 16);
        var t = k.clone();
        var a = this; // (N / 2) * Q + Q
        var b = this.curve.point(null, null); // (N / 2) * Q
        var c = this; // Q
        for (var bits = []; t.cmpn(0) !== 0; t.iushrn(1)) {
          bits.push(t.andln(1));
        }
        for (var i = bits.length - 1; i >= 0; i--) {
          if (bits[i] === 0) {
            // N * Q + Q = ((N / 2) * Q + Q)) + (N / 2) * Q
            a = a.diffAdd(b, c); // N * Q = 2 * ((N / 2) * Q + Q))
            b = b.dbl();
          } else {
            // N * Q = ((N / 2) * Q + Q) + ((N / 2) * Q)
            b = a.diffAdd(b, c); // N * Q + Q = 2 * ((N / 2) * Q + Q)
            a = a.dbl();
          }
        }
        return b;
      };
      Point.prototype.mulAdd = function mulAdd() {
        throw new Error('Not supported on Montgomery curve');
      };
      Point.prototype.jumlAdd = function jumlAdd() {
        throw new Error('Not supported on Montgomery curve');
      };
      Point.prototype.eq = function eq(other) {
        return this.getX().cmp(other.getX()) === 0;
      };
      Point.prototype.normalize = function normalize() {
        this.x = this.x.redMul(this.z.redInvm());
        this.z = this.curve.one;
        return this;
      };
      Point.prototype.getX = function getX() {
        // Normalize coordinates
        this.normalize();
        return this.x.fromRed();
      };
    }, {
      "../../elliptic": 19,
      "../curve": 22,
      "bn.js": 17,
      "inherits": 48
    }],
    24: [function (require, module, exports) {
      'use strict';

      var curve = require('../curve');
      var elliptic = require('../../elliptic');
      var BN = require('bn.js');
      var inherits = require('inherits');
      var Base = curve.base;
      var assert = elliptic.utils.assert;
      function ShortCurve(conf) {
        Base.call(this, 'short', conf);
        this.a = new BN(conf.a, 16).toRed(this.red);
        this.b = new BN(conf.b, 16).toRed(this.red);
        this.tinv = this.two.redInvm();
        this.zeroA = this.a.fromRed().cmpn(0) === 0;
        this.threeA = this.a.fromRed().sub(this.p).cmpn(-3) === 0; // If the curve is endomorphic, precalculate beta and lambda
        this.endo = this._getEndomorphism(conf);
        this._endoWnafT1 = new Array(4);
        this._endoWnafT2 = new Array(4);
      }
      inherits(ShortCurve, Base);
      module.exports = ShortCurve;
      ShortCurve.prototype._getEndomorphism = function _getEndomorphism(conf) {
        // No efficient endomorphism
        if (!this.zeroA || !this.g || !this.n || this.p.modn(3) !== 1) return; // Compute beta and lambda, that lambda * P = (beta * Px; Py)
        var beta;
        var lambda;
        if (conf.beta) {
          beta = new BN(conf.beta, 16).toRed(this.red);
        } else {
          var betas = this._getEndoRoots(this.p); // Choose the smallest beta
          beta = betas[0].cmp(betas[1]) < 0 ? betas[0] : betas[1];
          beta = beta.toRed(this.red);
        }
        if (conf.lambda) {
          lambda = new BN(conf.lambda, 16);
        } else {
          // Choose the lambda that is matching selected beta
          var lambdas = this._getEndoRoots(this.n);
          if (this.g.mul(lambdas[0]).x.cmp(this.g.x.redMul(beta)) === 0) {
            lambda = lambdas[0];
          } else {
            lambda = lambdas[1];
            assert(this.g.mul(lambda).x.cmp(this.g.x.redMul(beta)) === 0);
          }
        } // Get basis vectors, used for balanced length-two representation
        var basis;
        if (conf.basis) {
          basis = conf.basis.map(function (vec) {
            return {
              a: new BN(vec.a, 16),
              b: new BN(vec.b, 16)
            };
          });
        } else {
          basis = this._getEndoBasis(lambda);
        }
        return {
          beta: beta,
          lambda: lambda,
          basis: basis
        };
      };
      ShortCurve.prototype._getEndoRoots = function _getEndoRoots(num) {
        // Find roots of for x^2 + x + 1 in F
        // Root = (-1 +- Sqrt(-3)) / 2
        //
        var red = num === this.p ? this.red : BN.mont(num);
        var tinv = new BN(2).toRed(red).redInvm();
        var ntinv = tinv.redNeg();
        var s = new BN(3).toRed(red).redNeg().redSqrt().redMul(tinv);
        var l1 = ntinv.redAdd(s).fromRed();
        var l2 = ntinv.redSub(s).fromRed();
        return [l1, l2];
      };
      ShortCurve.prototype._getEndoBasis = function _getEndoBasis(lambda) {
        // aprxSqrt >= sqrt(this.n)
        var aprxSqrt = this.n.ushrn(Math.floor(this.n.bitLength() / 2)); // 3.74
        // Run EGCD, until r(L + 1) < aprxSqrt
        var u = lambda;
        var v = this.n.clone();
        var x1 = new BN(1);
        var y1 = new BN(0);
        var x2 = new BN(0);
        var y2 = new BN(1); // NOTE: all vectors are roots of: a + b * lambda = 0 (mod n)
        var a0;
        var b0; // First vector
        var a1;
        var b1; // Second vector
        var a2;
        var b2;
        var prevR;
        var i = 0;
        var r;
        var x;
        while (u.cmpn(0) !== 0) {
          var q = v.div(u);
          r = v.sub(q.mul(u));
          x = x2.sub(q.mul(x1));
          var y = y2.sub(q.mul(y1));
          if (!a1 && r.cmp(aprxSqrt) < 0) {
            a0 = prevR.neg();
            b0 = x1;
            a1 = r.neg();
            b1 = x;
          } else if (a1 && ++i === 2) {
            break;
          }
          prevR = r;
          v = u;
          u = r;
          x2 = x1;
          x1 = x;
          y2 = y1;
          y1 = y;
        }
        a2 = r.neg();
        b2 = x;
        var len1 = a1.sqr().add(b1.sqr());
        var len2 = a2.sqr().add(b2.sqr());
        if (len2.cmp(len1) >= 0) {
          a2 = a0;
          b2 = b0;
        } // Normalize signs
        if (a1.negative) {
          a1 = a1.neg();
          b1 = b1.neg();
        }
        if (a2.negative) {
          a2 = a2.neg();
          b2 = b2.neg();
        }
        return [{
          a: a1,
          b: b1
        }, {
          a: a2,
          b: b2
        }];
      };
      ShortCurve.prototype._endoSplit = function _endoSplit(k) {
        var basis = this.endo.basis;
        var v1 = basis[0];
        var v2 = basis[1];
        var c1 = v2.b.mul(k).divRound(this.n);
        var c2 = v1.b.neg().mul(k).divRound(this.n);
        var p1 = c1.mul(v1.a);
        var p2 = c2.mul(v2.a);
        var q1 = c1.mul(v1.b);
        var q2 = c2.mul(v2.b); // Calculate answer
        var k1 = k.sub(p1).sub(p2);
        var k2 = q1.add(q2).neg();
        return {
          k1: k1,
          k2: k2
        };
      };
      ShortCurve.prototype.pointFromX = function pointFromX(x, odd) {
        x = new BN(x, 16);
        if (!x.red) x = x.toRed(this.red);
        var y2 = x.redSqr().redMul(x).redIAdd(x.redMul(this.a)).redIAdd(this.b);
        var y = y2.redSqrt();
        if (y.redSqr().redSub(y2).cmp(this.zero) !== 0) throw new Error('invalid point'); // XXX Is there any way to tell if the number is odd without converting it
        // to non-red form?
        var isOdd = y.fromRed().isOdd();
        if (odd && !isOdd || !odd && isOdd) y = y.redNeg();
        return this.point(x, y);
      };
      ShortCurve.prototype.validate = function validate(point) {
        if (point.inf) return true;
        var x = point.x;
        var y = point.y;
        var ax = this.a.redMul(x);
        var rhs = x.redSqr().redMul(x).redIAdd(ax).redIAdd(this.b);
        return y.redSqr().redISub(rhs).cmpn(0) === 0;
      };
      ShortCurve.prototype._endoWnafMulAdd = function _endoWnafMulAdd(points, coeffs, jacobianResult) {
        var npoints = this._endoWnafT1;
        var ncoeffs = this._endoWnafT2;
        for (var i = 0; i < points.length; i++) {
          var split = this._endoSplit(coeffs[i]);
          var p = points[i];
          var beta = p._getBeta();
          if (split.k1.negative) {
            split.k1.ineg();
            p = p.neg(true);
          }
          if (split.k2.negative) {
            split.k2.ineg();
            beta = beta.neg(true);
          }
          npoints[i * 2] = p;
          npoints[i * 2 + 1] = beta;
          ncoeffs[i * 2] = split.k1;
          ncoeffs[i * 2 + 1] = split.k2;
        }
        var res = this._wnafMulAdd(1, npoints, ncoeffs, i * 2, jacobianResult); // Clean-up references to points and coefficients
        for (var j = 0; j < i * 2; j++) {
          npoints[j] = null;
          ncoeffs[j] = null;
        }
        return res;
      };
      function Point(curve, x, y, isRed) {
        Base.BasePoint.call(this, curve, 'affine');
        if (x === null && y === null) {
          this.x = null;
          this.y = null;
          this.inf = true;
        } else {
          this.x = new BN(x, 16);
          this.y = new BN(y, 16); // Force redgomery representation when loading from JSON
          if (isRed) {
            this.x.forceRed(this.curve.red);
            this.y.forceRed(this.curve.red);
          }
          if (!this.x.red) this.x = this.x.toRed(this.curve.red);
          if (!this.y.red) this.y = this.y.toRed(this.curve.red);
          this.inf = false;
        }
      }
      inherits(Point, Base.BasePoint);
      ShortCurve.prototype.point = function point(x, y, isRed) {
        return new Point(this, x, y, isRed);
      };
      ShortCurve.prototype.pointFromJSON = function pointFromJSON(obj, red) {
        return Point.fromJSON(this, obj, red);
      };
      Point.prototype._getBeta = function _getBeta() {
        if (!this.curve.endo) return;
        var pre = this.precomputed;
        if (pre && pre.beta) return pre.beta;
        var beta = this.curve.point(this.x.redMul(this.curve.endo.beta), this.y);
        if (pre) {
          var curve = this.curve;
          var endoMul = function endoMul(p) {
            return curve.point(p.x.redMul(curve.endo.beta), p.y);
          };
          pre.beta = beta;
          beta.precomputed = {
            beta: null,
            naf: pre.naf && {
              wnd: pre.naf.wnd,
              points: pre.naf.points.map(endoMul)
            },
            doubles: pre.doubles && {
              step: pre.doubles.step,
              points: pre.doubles.points.map(endoMul)
            }
          };
        }
        return beta;
      };
      Point.prototype.toJSON = function toJSON() {
        if (!this.precomputed) return [this.x, this.y];
        return [this.x, this.y, this.precomputed && {
          doubles: this.precomputed.doubles && {
            step: this.precomputed.doubles.step,
            points: this.precomputed.doubles.points.slice(1)
          },
          naf: this.precomputed.naf && {
            wnd: this.precomputed.naf.wnd,
            points: this.precomputed.naf.points.slice(1)
          }
        }];
      };
      Point.fromJSON = function fromJSON(curve, obj, red) {
        if (typeof obj === 'string') obj = JSON.parse(obj);
        var res = curve.point(obj[0], obj[1], red);
        if (!obj[2]) return res;
        function obj2point(obj) {
          return curve.point(obj[0], obj[1], red);
        }
        var pre = obj[2];
        res.precomputed = {
          beta: null,
          doubles: pre.doubles && {
            step: pre.doubles.step,
            points: [res].concat(pre.doubles.points.map(obj2point))
          },
          naf: pre.naf && {
            wnd: pre.naf.wnd,
            points: [res].concat(pre.naf.points.map(obj2point))
          }
        };
        return res;
      };
      Point.prototype.inspect = function inspect() {
        if (this.isInfinity()) return '<EC Point Infinity>';
        return '<EC Point x: ' + this.x.fromRed().toString(16, 2) + ' y: ' + this.y.fromRed().toString(16, 2) + '>';
      };
      Point.prototype.isInfinity = function isInfinity() {
        return this.inf;
      };
      Point.prototype.add = function add(p) {
        // O + P = P
        if (this.inf) return p; // P + O = P
        if (p.inf) return this; // P + P = 2P
        if (this.eq(p)) return this.dbl(); // P + (-P) = O
        if (this.neg().eq(p)) return this.curve.point(null, null); // P + Q = O
        if (this.x.cmp(p.x) === 0) return this.curve.point(null, null);
        var c = this.y.redSub(p.y);
        if (c.cmpn(0) !== 0) c = c.redMul(this.x.redSub(p.x).redInvm());
        var nx = c.redSqr().redISub(this.x).redISub(p.x);
        var ny = c.redMul(this.x.redSub(nx)).redISub(this.y);
        return this.curve.point(nx, ny);
      };
      Point.prototype.dbl = function dbl() {
        if (this.inf) return this; // 2P = O
        var ys1 = this.y.redAdd(this.y);
        if (ys1.cmpn(0) === 0) return this.curve.point(null, null);
        var a = this.curve.a;
        var x2 = this.x.redSqr();
        var dyinv = ys1.redInvm();
        var c = x2.redAdd(x2).redIAdd(x2).redIAdd(a).redMul(dyinv);
        var nx = c.redSqr().redISub(this.x.redAdd(this.x));
        var ny = c.redMul(this.x.redSub(nx)).redISub(this.y);
        return this.curve.point(nx, ny);
      };
      Point.prototype.getX = function getX() {
        return this.x.fromRed();
      };
      Point.prototype.getY = function getY() {
        return this.y.fromRed();
      };
      Point.prototype.mul = function mul(k) {
        k = new BN(k, 16);
        if (this._hasDoubles(k)) return this.curve._fixedNafMul(this, k);else if (this.curve.endo) return this.curve._endoWnafMulAdd([this], [k]);else return this.curve._wnafMul(this, k);
      };
      Point.prototype.mulAdd = function mulAdd(k1, p2, k2) {
        var points = [this, p2];
        var coeffs = [k1, k2];
        if (this.curve.endo) return this.curve._endoWnafMulAdd(points, coeffs);else return this.curve._wnafMulAdd(1, points, coeffs, 2);
      };
      Point.prototype.jmulAdd = function jmulAdd(k1, p2, k2) {
        var points = [this, p2];
        var coeffs = [k1, k2];
        if (this.curve.endo) return this.curve._endoWnafMulAdd(points, coeffs, true);else return this.curve._wnafMulAdd(1, points, coeffs, 2, true);
      };
      Point.prototype.eq = function eq(p) {
        return this === p || this.inf === p.inf && (this.inf || this.x.cmp(p.x) === 0 && this.y.cmp(p.y) === 0);
      };
      Point.prototype.neg = function neg(_precompute) {
        if (this.inf) return this;
        var res = this.curve.point(this.x, this.y.redNeg());
        if (_precompute && this.precomputed) {
          var pre = this.precomputed;
          var negate = function negate(p) {
            return p.neg();
          };
          res.precomputed = {
            naf: pre.naf && {
              wnd: pre.naf.wnd,
              points: pre.naf.points.map(negate)
            },
            doubles: pre.doubles && {
              step: pre.doubles.step,
              points: pre.doubles.points.map(negate)
            }
          };
        }
        return res;
      };
      Point.prototype.toJ = function toJ() {
        if (this.inf) return this.curve.jpoint(null, null, null);
        var res = this.curve.jpoint(this.x, this.y, this.curve.one);
        return res;
      };
      function JPoint(curve, x, y, z) {
        Base.BasePoint.call(this, curve, 'jacobian');
        if (x === null && y === null && z === null) {
          this.x = this.curve.one;
          this.y = this.curve.one;
          this.z = new BN(0);
        } else {
          this.x = new BN(x, 16);
          this.y = new BN(y, 16);
          this.z = new BN(z, 16);
        }
        if (!this.x.red) this.x = this.x.toRed(this.curve.red);
        if (!this.y.red) this.y = this.y.toRed(this.curve.red);
        if (!this.z.red) this.z = this.z.toRed(this.curve.red);
        this.zOne = this.z === this.curve.one;
      }
      inherits(JPoint, Base.BasePoint);
      ShortCurve.prototype.jpoint = function jpoint(x, y, z) {
        return new JPoint(this, x, y, z);
      };
      JPoint.prototype.toP = function toP() {
        if (this.isInfinity()) return this.curve.point(null, null);
        var zinv = this.z.redInvm();
        var zinv2 = zinv.redSqr();
        var ax = this.x.redMul(zinv2);
        var ay = this.y.redMul(zinv2).redMul(zinv);
        return this.curve.point(ax, ay);
      };
      JPoint.prototype.neg = function neg() {
        return this.curve.jpoint(this.x, this.y.redNeg(), this.z);
      };
      JPoint.prototype.add = function add(p) {
        // O + P = P
        if (this.isInfinity()) return p; // P + O = P
        if (p.isInfinity()) return this; // 12M + 4S + 7A
        var pz2 = p.z.redSqr();
        var z2 = this.z.redSqr();
        var u1 = this.x.redMul(pz2);
        var u2 = p.x.redMul(z2);
        var s1 = this.y.redMul(pz2.redMul(p.z));
        var s2 = p.y.redMul(z2.redMul(this.z));
        var h = u1.redSub(u2);
        var r = s1.redSub(s2);
        if (h.cmpn(0) === 0) {
          if (r.cmpn(0) !== 0) return this.curve.jpoint(null, null, null);else return this.dbl();
        }
        var h2 = h.redSqr();
        var h3 = h2.redMul(h);
        var v = u1.redMul(h2);
        var nx = r.redSqr().redIAdd(h3).redISub(v).redISub(v);
        var ny = r.redMul(v.redISub(nx)).redISub(s1.redMul(h3));
        var nz = this.z.redMul(p.z).redMul(h);
        return this.curve.jpoint(nx, ny, nz);
      };
      JPoint.prototype.mixedAdd = function mixedAdd(p) {
        // O + P = P
        if (this.isInfinity()) return p.toJ(); // P + O = P
        if (p.isInfinity()) return this; // 8M + 3S + 7A
        var z2 = this.z.redSqr();
        var u1 = this.x;
        var u2 = p.x.redMul(z2);
        var s1 = this.y;
        var s2 = p.y.redMul(z2).redMul(this.z);
        var h = u1.redSub(u2);
        var r = s1.redSub(s2);
        if (h.cmpn(0) === 0) {
          if (r.cmpn(0) !== 0) return this.curve.jpoint(null, null, null);else return this.dbl();
        }
        var h2 = h.redSqr();
        var h3 = h2.redMul(h);
        var v = u1.redMul(h2);
        var nx = r.redSqr().redIAdd(h3).redISub(v).redISub(v);
        var ny = r.redMul(v.redISub(nx)).redISub(s1.redMul(h3));
        var nz = this.z.redMul(h);
        return this.curve.jpoint(nx, ny, nz);
      };
      JPoint.prototype.dblp = function dblp(pow) {
        if (pow === 0) return this;
        if (this.isInfinity()) return this;
        if (!pow) return this.dbl();
        if (this.curve.zeroA || this.curve.threeA) {
          var r = this;
          for (var i = 0; i < pow; i++) {
            r = r.dbl();
          }
          return r;
        } // 1M + 2S + 1A + N * (4S + 5M + 8A)
        // N = 1 => 6M + 6S + 9A
        var a = this.curve.a;
        var tinv = this.curve.tinv;
        var jx = this.x;
        var jy = this.y;
        var jz = this.z;
        var jz4 = jz.redSqr().redSqr(); // Reuse results
        var jyd = jy.redAdd(jy);
        for (var i = 0; i < pow; i++) {
          var jx2 = jx.redSqr();
          var jyd2 = jyd.redSqr();
          var jyd4 = jyd2.redSqr();
          var c = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a.redMul(jz4));
          var t1 = jx.redMul(jyd2);
          var nx = c.redSqr().redISub(t1.redAdd(t1));
          var t2 = t1.redISub(nx);
          var dny = c.redMul(t2);
          dny = dny.redIAdd(dny).redISub(jyd4);
          var nz = jyd.redMul(jz);
          if (i + 1 < pow) jz4 = jz4.redMul(jyd4);
          jx = nx;
          jz = nz;
          jyd = dny;
        }
        return this.curve.jpoint(jx, jyd.redMul(tinv), jz);
      };
      JPoint.prototype.dbl = function dbl() {
        if (this.isInfinity()) return this;
        if (this.curve.zeroA) return this._zeroDbl();else if (this.curve.threeA) return this._threeDbl();else return this._dbl();
      };
      JPoint.prototype._zeroDbl = function _zeroDbl() {
        var nx;
        var ny;
        var nz; // Z = 1
        if (this.zOne) {
          // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-0.html
          //     #doubling-mdbl-2007-bl
          // 1M + 5S + 14A
          // XX = X1^2
          var xx = this.x.redSqr(); // YY = Y1^2
          var yy = this.y.redSqr(); // YYYY = YY^2
          var yyyy = yy.redSqr(); // S = 2 * ((X1 + YY)^2 - XX - YYYY)
          var s = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
          s = s.redIAdd(s); // M = 3 * XX + a; a = 0
          var m = xx.redAdd(xx).redIAdd(xx); // T = M ^ 2 - 2*S
          var t = m.redSqr().redISub(s).redISub(s); // 8 * YYYY
          var yyyy8 = yyyy.redIAdd(yyyy);
          yyyy8 = yyyy8.redIAdd(yyyy8);
          yyyy8 = yyyy8.redIAdd(yyyy8); // X3 = T
          nx = t; // Y3 = M * (S - T) - 8 * YYYY
          ny = m.redMul(s.redISub(t)).redISub(yyyy8); // Z3 = 2*Y1
          nz = this.y.redAdd(this.y);
        } else {
          // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-0.html
          //     #doubling-dbl-2009-l
          // 2M + 5S + 13A
          // A = X1^2
          var a = this.x.redSqr(); // B = Y1^2
          var b = this.y.redSqr(); // C = B^2
          var c = b.redSqr(); // D = 2 * ((X1 + B)^2 - A - C)
          var d = this.x.redAdd(b).redSqr().redISub(a).redISub(c);
          d = d.redIAdd(d); // E = 3 * A
          var e = a.redAdd(a).redIAdd(a); // F = E^2
          var f = e.redSqr(); // 8 * C
          var c8 = c.redIAdd(c);
          c8 = c8.redIAdd(c8);
          c8 = c8.redIAdd(c8); // X3 = F - 2 * D
          nx = f.redISub(d).redISub(d); // Y3 = E * (D - X3) - 8 * C
          ny = e.redMul(d.redISub(nx)).redISub(c8); // Z3 = 2 * Y1 * Z1
          nz = this.y.redMul(this.z);
          nz = nz.redIAdd(nz);
        }
        return this.curve.jpoint(nx, ny, nz);
      };
      JPoint.prototype._threeDbl = function _threeDbl() {
        var nx;
        var ny;
        var nz; // Z = 1
        if (this.zOne) {
          // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-3.html
          //     #doubling-mdbl-2007-bl
          // 1M + 5S + 15A
          // XX = X1^2
          var xx = this.x.redSqr(); // YY = Y1^2
          var yy = this.y.redSqr(); // YYYY = YY^2
          var yyyy = yy.redSqr(); // S = 2 * ((X1 + YY)^2 - XX - YYYY)
          var s = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
          s = s.redIAdd(s); // M = 3 * XX + a
          var m = xx.redAdd(xx).redIAdd(xx).redIAdd(this.curve.a); // T = M^2 - 2 * S
          var t = m.redSqr().redISub(s).redISub(s); // X3 = T
          nx = t; // Y3 = M * (S - T) - 8 * YYYY
          var yyyy8 = yyyy.redIAdd(yyyy);
          yyyy8 = yyyy8.redIAdd(yyyy8);
          yyyy8 = yyyy8.redIAdd(yyyy8);
          ny = m.redMul(s.redISub(t)).redISub(yyyy8); // Z3 = 2 * Y1
          nz = this.y.redAdd(this.y);
        } else {
          // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-3.html#doubling-dbl-2001-b
          // 3M + 5S
          // delta = Z1^2
          var delta = this.z.redSqr(); // gamma = Y1^2
          var gamma = this.y.redSqr(); // beta = X1 * gamma
          var beta = this.x.redMul(gamma); // alpha = 3 * (X1 - delta) * (X1 + delta)
          var alpha = this.x.redSub(delta).redMul(this.x.redAdd(delta));
          alpha = alpha.redAdd(alpha).redIAdd(alpha); // X3 = alpha^2 - 8 * beta
          var beta4 = beta.redIAdd(beta);
          beta4 = beta4.redIAdd(beta4);
          var beta8 = beta4.redAdd(beta4);
          nx = alpha.redSqr().redISub(beta8); // Z3 = (Y1 + Z1)^2 - gamma - delta
          nz = this.y.redAdd(this.z).redSqr().redISub(gamma).redISub(delta); // Y3 = alpha * (4 * beta - X3) - 8 * gamma^2
          var ggamma8 = gamma.redSqr();
          ggamma8 = ggamma8.redIAdd(ggamma8);
          ggamma8 = ggamma8.redIAdd(ggamma8);
          ggamma8 = ggamma8.redIAdd(ggamma8);
          ny = alpha.redMul(beta4.redISub(nx)).redISub(ggamma8);
        }
        return this.curve.jpoint(nx, ny, nz);
      };
      JPoint.prototype._dbl = function _dbl() {
        var a = this.curve.a; // 4M + 6S + 10A
        var jx = this.x;
        var jy = this.y;
        var jz = this.z;
        var jz4 = jz.redSqr().redSqr();
        var jx2 = jx.redSqr();
        var jy2 = jy.redSqr();
        var c = jx2.redAdd(jx2).redIAdd(jx2).redIAdd(a.redMul(jz4));
        var jxd4 = jx.redAdd(jx);
        jxd4 = jxd4.redIAdd(jxd4);
        var t1 = jxd4.redMul(jy2);
        var nx = c.redSqr().redISub(t1.redAdd(t1));
        var t2 = t1.redISub(nx);
        var jyd8 = jy2.redSqr();
        jyd8 = jyd8.redIAdd(jyd8);
        jyd8 = jyd8.redIAdd(jyd8);
        jyd8 = jyd8.redIAdd(jyd8);
        var ny = c.redMul(t2).redISub(jyd8);
        var nz = jy.redAdd(jy).redMul(jz);
        return this.curve.jpoint(nx, ny, nz);
      };
      JPoint.prototype.trpl = function trpl() {
        if (!this.curve.zeroA) return this.dbl().add(this); // hyperelliptic.org/EFD/g1p/auto-shortw-jacobian-0.html#tripling-tpl-2007-bl
        // 5M + 10S + ...
        // XX = X1^2
        var xx = this.x.redSqr(); // YY = Y1^2
        var yy = this.y.redSqr(); // ZZ = Z1^2
        var zz = this.z.redSqr(); // YYYY = YY^2
        var yyyy = yy.redSqr(); // M = 3 * XX + a * ZZ2; a = 0
        var m = xx.redAdd(xx).redIAdd(xx); // MM = M^2
        var mm = m.redSqr(); // E = 6 * ((X1 + YY)^2 - XX - YYYY) - MM
        var e = this.x.redAdd(yy).redSqr().redISub(xx).redISub(yyyy);
        e = e.redIAdd(e);
        e = e.redAdd(e).redIAdd(e);
        e = e.redISub(mm); // EE = E^2
        var ee = e.redSqr(); // T = 16*YYYY
        var t = yyyy.redIAdd(yyyy);
        t = t.redIAdd(t);
        t = t.redIAdd(t);
        t = t.redIAdd(t); // U = (M + E)^2 - MM - EE - T
        var u = m.redIAdd(e).redSqr().redISub(mm).redISub(ee).redISub(t); // X3 = 4 * (X1 * EE - 4 * YY * U)
        var yyu4 = yy.redMul(u);
        yyu4 = yyu4.redIAdd(yyu4);
        yyu4 = yyu4.redIAdd(yyu4);
        var nx = this.x.redMul(ee).redISub(yyu4);
        nx = nx.redIAdd(nx);
        nx = nx.redIAdd(nx); // Y3 = 8 * Y1 * (U * (T - U) - E * EE)
        var ny = this.y.redMul(u.redMul(t.redISub(u)).redISub(e.redMul(ee)));
        ny = ny.redIAdd(ny);
        ny = ny.redIAdd(ny);
        ny = ny.redIAdd(ny); // Z3 = (Z1 + E)^2 - ZZ - EE
        var nz = this.z.redAdd(e).redSqr().redISub(zz).redISub(ee);
        return this.curve.jpoint(nx, ny, nz);
      };
      JPoint.prototype.mul = function mul(k, kbase) {
        k = new BN(k, kbase);
        return this.curve._wnafMul(this, k);
      };
      JPoint.prototype.eq = function eq(p) {
        if (p.type === 'affine') return this.eq(p.toJ());
        if (this === p) return true; // x1 * z2^2 == x2 * z1^2
        var z2 = this.z.redSqr();
        var pz2 = p.z.redSqr();
        if (this.x.redMul(pz2).redISub(p.x.redMul(z2)).cmpn(0) !== 0) return false; // y1 * z2^3 == y2 * z1^3
        var z3 = z2.redMul(this.z);
        var pz3 = pz2.redMul(p.z);
        return this.y.redMul(pz3).redISub(p.y.redMul(z3)).cmpn(0) === 0;
      };
      JPoint.prototype.eqXToP = function eqXToP(x) {
        var zs = this.z.redSqr();
        var rx = x.toRed(this.curve.red).redMul(zs);
        if (this.x.cmp(rx) === 0) return true;
        var xc = x.clone();
        var t = this.curve.redN.redMul(zs);
        for (;;) {
          xc.iadd(this.curve.n);
          if (xc.cmp(this.curve.p) >= 0) return false;
          rx.redIAdd(t);
          if (this.x.cmp(rx) === 0) return true;
        }
      };
      JPoint.prototype.inspect = function inspect() {
        if (this.isInfinity()) return '<EC JPoint Infinity>';
        return '<EC JPoint x: ' + this.x.toString(16, 2) + ' y: ' + this.y.toString(16, 2) + ' z: ' + this.z.toString(16, 2) + '>';
      };
      JPoint.prototype.isInfinity = function isInfinity() {
        // XXX This code assumes that zero is always zero in red
        return this.z.cmpn(0) === 0;
      };
    }, {
      "../../elliptic": 19,
      "../curve": 22,
      "bn.js": 17,
      "inherits": 48
    }],
    25: [function (require, module, exports) {
      'use strict';

      var curves = exports;
      var hash = require('hash.js');
      var elliptic = require('../elliptic');
      var assert = elliptic.utils.assert;
      function PresetCurve(options) {
        if (options.type === 'short') this.curve = new elliptic.curve["short"](options);else if (options.type === 'edwards') this.curve = new elliptic.curve.edwards(options);else if (options.type === 'mont') this.curve = new elliptic.curve.mont(options);else throw new Error('Unknown curve type.');
        this.g = this.curve.g;
        this.n = this.curve.n;
        this.hash = options.hash;
        assert(this.g.validate(), 'Invalid curve');
        assert(this.g.mul(this.n).isInfinity(), 'Invalid curve, n*G != O');
      }
      curves.PresetCurve = PresetCurve;
      function defineCurve(name, options) {
        Object.defineProperty(curves, name, {
          configurable: true,
          enumerable: true,
          get: function get() {
            var curve = new PresetCurve(options);
            Object.defineProperty(curves, name, {
              configurable: true,
              enumerable: true,
              value: curve
            });
            return curve;
          }
        });
      }
      defineCurve('p192', {
        type: 'short',
        prime: 'p192',
        p: 'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff',
        a: 'ffffffff ffffffff ffffffff fffffffe ffffffff fffffffc',
        b: '64210519 e59c80e7 0fa7e9ab 72243049 feb8deec c146b9b1',
        n: 'ffffffff ffffffff ffffffff 99def836 146bc9b1 b4d22831',
        hash: hash.sha256,
        gRed: false,
        g: ['188da80e b03090f6 7cbf20eb 43a18800 f4ff0afd 82ff1012', '07192b95 ffc8da78 631011ed 6b24cdd5 73f977a1 1e794811']
      });
      defineCurve('p224', {
        type: 'short',
        prime: 'p224',
        p: 'ffffffff ffffffff ffffffff ffffffff 00000000 00000000 00000001',
        a: 'ffffffff ffffffff ffffffff fffffffe ffffffff ffffffff fffffffe',
        b: 'b4050a85 0c04b3ab f5413256 5044b0b7 d7bfd8ba 270b3943 2355ffb4',
        n: 'ffffffff ffffffff ffffffff ffff16a2 e0b8f03e 13dd2945 5c5c2a3d',
        hash: hash.sha256,
        gRed: false,
        g: ['b70e0cbd 6bb4bf7f 321390b9 4a03c1d3 56c21122 343280d6 115c1d21', 'bd376388 b5f723fb 4c22dfe6 cd4375a0 5a074764 44d58199 85007e34']
      });
      defineCurve('p256', {
        type: 'short',
        prime: null,
        p: 'ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff ffffffff',
        a: 'ffffffff 00000001 00000000 00000000 00000000 ffffffff ffffffff fffffffc',
        b: '5ac635d8 aa3a93e7 b3ebbd55 769886bc 651d06b0 cc53b0f6 3bce3c3e 27d2604b',
        n: 'ffffffff 00000000 ffffffff ffffffff bce6faad a7179e84 f3b9cac2 fc632551',
        hash: hash.sha256,
        gRed: false,
        g: ['6b17d1f2 e12c4247 f8bce6e5 63a440f2 77037d81 2deb33a0 f4a13945 d898c296', '4fe342e2 fe1a7f9b 8ee7eb4a 7c0f9e16 2bce3357 6b315ece cbb64068 37bf51f5']
      });
      defineCurve('p384', {
        type: 'short',
        prime: null,
        p: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'fffffffe ffffffff 00000000 00000000 ffffffff',
        a: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'fffffffe ffffffff 00000000 00000000 fffffffc',
        b: 'b3312fa7 e23ee7e4 988e056b e3f82d19 181d9c6e fe814112 0314088f ' + '5013875a c656398d 8a2ed19d 2a85c8ed d3ec2aef',
        n: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff c7634d81 ' + 'f4372ddf 581a0db2 48b0a77a ecec196a ccc52973',
        hash: hash.sha384,
        gRed: false,
        g: ['aa87ca22 be8b0537 8eb1c71e f320ad74 6e1d3b62 8ba79b98 59f741e0 82542a38 ' + '5502f25d bf55296c 3a545e38 72760ab7', '3617de4a 96262c6f 5d9e98bf 9292dc29 f8f41dbd 289a147c e9da3113 b5f0b8c0 ' + '0a60b1ce 1d7e819d 7a431d7c 90ea0e5f']
      });
      defineCurve('p521', {
        type: 'short',
        prime: null,
        p: '000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'ffffffff ffffffff ffffffff ffffffff ffffffff',
        a: '000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'ffffffff ffffffff ffffffff ffffffff fffffffc',
        b: '00000051 953eb961 8e1c9a1f 929a21a0 b68540ee a2da725b ' + '99b315f3 b8b48991 8ef109e1 56193951 ec7e937b 1652c0bd ' + '3bb1bf07 3573df88 3d2c34f1 ef451fd4 6b503f00',
        n: '000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ' + 'ffffffff ffffffff fffffffa 51868783 bf2f966b 7fcc0148 ' + 'f709a5d0 3bb5c9b8 899c47ae bb6fb71e 91386409',
        hash: hash.sha512,
        gRed: false,
        g: ['000000c6 858e06b7 0404e9cd 9e3ecb66 2395b442 9c648139 ' + '053fb521 f828af60 6b4d3dba a14b5e77 efe75928 fe1dc127 ' + 'a2ffa8de 3348b3c1 856a429b f97e7e31 c2e5bd66', '00000118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd9 98f54449 ' + '579b4468 17afbd17 273e662c 97ee7299 5ef42640 c550b901 ' + '3fad0761 353c7086 a272c240 88be9476 9fd16650']
      }); // https://tools.ietf.org/html/rfc7748#section-4.1
      defineCurve('curve25519', {
        type: 'mont',
        prime: 'p25519',
        p: '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed',
        a: '76d06',
        b: '1',
        n: '1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed',
        cofactor: '8',
        hash: hash.sha256,
        gRed: false,
        g: ['9']
      });
      defineCurve('ed25519', {
        type: 'edwards',
        prime: 'p25519',
        p: '7fffffffffffffff ffffffffffffffff ffffffffffffffff ffffffffffffffed',
        a: '-1',
        c: '1',
        // -121665 * (121666^(-1)) (mod P)
        d: '52036cee2b6ffe73 8cc740797779e898 00700a4d4141d8ab 75eb4dca135978a3',
        n: '1000000000000000 0000000000000000 14def9dea2f79cd6 5812631a5cf5d3ed',
        cofactor: '8',
        hash: hash.sha256,
        gRed: false,
        g: ['216936d3cd6e53fec0a4e231fdd6dc5c692cc7609525a7b2c9562d608f25d51a',
        // 4/5
        '6666666666666666666666666666666666666666666666666666666666666658']
      }); // https://tools.ietf.org/html/rfc5639#section-3.4
      defineCurve('brainpoolP256r1', {
        type: 'short',
        prime: null,
        p: 'A9FB57DB A1EEA9BC 3E660A90 9D838D72 6E3BF623 D5262028 2013481D 1F6E5377',
        a: '7D5A0975 FC2C3057 EEF67530 417AFFE7 FB8055C1 26DC5C6C E94A4B44 F330B5D9',
        b: '26DC5C6C E94A4B44 F330B5D9 BBD77CBF 95841629 5CF7E1CE 6BCCDC18 FF8C07B6',
        n: 'A9FB57DB A1EEA9BC 3E660A90 9D838D71 8C397AA3 B561A6F7 901E0E82 974856A7',
        hash: hash.sha256,
        // or 384, or 512
        gRed: false,
        g: ['8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262', '547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997']
      }); // https://tools.ietf.org/html/rfc5639#section-3.6
      defineCurve('brainpoolP384r1', {
        type: 'short',
        prime: null,
        p: '8CB91E82 A3386D28 0F5D6F7E 50E641DF 152F7109 ED5456B4 12B1DA19 7FB71123' + 'ACD3A729 901D1A71 87470013 3107EC53',
        a: '7BC382C6 3D8C150C 3C72080A CE05AFA0 C2BEA28E 4FB22787 139165EF BA91F90F' + '8AA5814A 503AD4EB 04A8C7DD 22CE2826',
        b: '04A8C7DD 22CE2826 8B39B554 16F0447C 2FB77DE1 07DCD2A6 2E880EA5 3EEB62D5' + '7CB43902 95DBC994 3AB78696 FA504C11',
        n: '8CB91E82 A3386D28 0F5D6F7E 50E641DF 152F7109 ED5456B3 1F166E6C AC0425A7' + 'CF3AB6AF 6B7FC310 3B883202 E9046565',
        hash: hash.sha384,
        // or 512
        gRed: false,
        g: ['1D1C64F068CF45FFA2A63A81B7C13F6B8847A3E77EF14FE3DB7FCAFE0CBD10' + 'E8E826E03436D646AAEF87B2E247D4AF1E', '8ABE1D7520F9C2A45CB1EB8E95CFD55262B70B29FEEC5864E19C054FF99129' + '280E4646217791811142820341263C5315']
      }); // https://tools.ietf.org/html/rfc5639#section-3.7
      defineCurve('brainpoolP512r1', {
        type: 'short',
        prime: null,
        p: 'AADD9DB8 DBE9C48B 3FD4E6AE 33C9FC07 CB308DB3 B3C9D20E D6639CCA 70330871' + '7D4D9B00 9BC66842 AECDA12A E6A380E6 2881FF2F 2D82C685 28AA6056 583A48F3',
        a: '7830A331 8B603B89 E2327145 AC234CC5 94CBDD8D 3DF91610 A83441CA EA9863BC' + '2DED5D5A A8253AA1 0A2EF1C9 8B9AC8B5 7F1117A7 2BF2C7B9 E7C1AC4D 77FC94CA',
        b: '3DF91610 A83441CA EA9863BC 2DED5D5A A8253AA1 0A2EF1C9 8B9AC8B5 7F1117A7' + '2BF2C7B9 E7C1AC4D 77FC94CA DC083E67 984050B7 5EBAE5DD 2809BD63 8016F723',
        n: 'AADD9DB8 DBE9C48B 3FD4E6AE 33C9FC07 CB308DB3 B3C9D20E D6639CCA 70330870' + '553E5C41 4CA92619 41866119 7FAC1047 1DB1D381 085DDADD B5879682 9CA90069',
        hash: hash.sha512,
        gRed: false,
        g: ['81AEE4BDD82ED9645A21322E9C4C6A9385ED9F70B5D916C1B43B62EEF4D009' + '8EFF3B1F78E2D0D48D50D1687B93B97D5F7C6D5047406A5E688B352209BCB9F822', '7DDE385D566332ECC0EABFA9CF7822FDF209F70024A57B1AA000C55B881F81' + '11B2DCDE494A5F485E5BCA4BD88A2763AED1CA2B2FA8F0540678CD1E0F3AD80892']
      }); // https://en.bitcoin.it/wiki/Secp256k1
      var pre;
      try {
        pre = require('./precomputed/secp256k1');
      } catch (e) {
        pre = undefined;
      }
      defineCurve('secp256k1', {
        type: 'short',
        prime: 'k256',
        p: 'ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe fffffc2f',
        a: '0',
        b: '7',
        n: 'ffffffff ffffffff ffffffff fffffffe baaedce6 af48a03b bfd25e8c d0364141',
        h: '1',
        hash: hash.sha256,
        // Precomputed endomorphism
        beta: '7ae96a2b657c07106e64479eac3434e99cf0497512f58995c1396c28719501ee',
        lambda: '5363ad4cc05c30e0a5261c028812645a122e22ea20816678df02967c1b23bd72',
        basis: [{
          a: '3086d221a7d46bcde86c90e49284eb15',
          b: '-e4437ed6010e88286f547fa90abfe4c3'
        }, {
          a: '114ca50f7a8e2f3f657c1108d9d44cfd8',
          b: '3086d221a7d46bcde86c90e49284eb15'
        }],
        gRed: false,
        g: ['79be667ef9dcbbac55a06295ce870b07029bfcdb2dce28d959f2815b16f81798', '483ada7726a3c4655da4fbfc0e1108a8fd17b448a68554199c47d08ffb10d4b8', pre]
      });
    }, {
      "../elliptic": 19,
      "./precomputed/secp256k1": 32,
      "hash.js": 35
    }],
    26: [function (require, module, exports) {
      'use strict';

      var BN = require('bn.js');
      var HmacDRBG = require('hmac-drbg');
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var assert = utils.assert;
      var KeyPair = require('./key');
      var Signature = require('./signature');
      function EC(options) {
        if (!_instanceof(this, EC)) return new EC(options); // Shortcut `elliptic.ec(curve-name)`
        if (typeof options === 'string') {
          assert(elliptic.curves.hasOwnProperty(options), 'Unknown curve ' + options);
          options = elliptic.curves[options];
        } // Shortcut for `elliptic.ec(elliptic.curves.curveName)`
        if (_instanceof(options, elliptic.curves.PresetCurve)) options = {
          curve: options
        };
        this.curve = options.curve.curve;
        this.n = this.curve.n;
        this.nh = this.n.ushrn(1);
        this.g = this.curve.g; // Point on curve
        this.g = options.curve.g;
        this.g.precompute(options.curve.n.bitLength() + 1); // Hash function for DRBG
        this.hash = options.hash || options.curve.hash;
      }
      module.exports = EC;
      EC.prototype.keyPair = function keyPair(options) {
        return new KeyPair(this, options);
      };
      EC.prototype.keyFromPrivate = function keyFromPrivate(priv, enc) {
        return KeyPair.fromPrivate(this, priv, enc);
      };
      EC.prototype.keyFromPublic = function keyFromPublic(pub, enc) {
        return KeyPair.fromPublic(this, pub, enc);
      };
      EC.prototype.genKeyPair = function genKeyPair(options) {
        if (!options) options = {}; // Instantiate Hmac_DRBG
        var drbg = new HmacDRBG({
          hash: this.hash,
          pers: options.pers,
          persEnc: options.persEnc || 'utf8',
          entropy: options.entropy || elliptic.rand(this.hash.hmacStrength),
          entropyEnc: options.entropy && options.entropyEnc || 'utf8',
          nonce: this.n.toArray()
        }); // Key generation for curve25519 is simpler
        if (this.curve.type === 'mont') {
          var priv = new BN(drbg.generate(32));
          return this.keyFromPrivate(priv);
        }
        var bytes = this.n.byteLength();
        var ns2 = this.n.sub(new BN(2));
        do {
          var priv = new BN(drbg.generate(bytes));
          if (priv.cmp(ns2) > 0) continue;
          priv.iaddn(1);
          return this.keyFromPrivate(priv);
        } while (true);
      };
      EC.prototype._truncateToN = function truncateToN(msg, truncOnly) {
        var delta = msg.byteLength() * 8 - this.n.bitLength();
        if (delta > 0) msg = msg.ushrn(delta);
        if (!truncOnly && msg.cmp(this.n) >= 0) return msg.sub(this.n);else return msg;
      };
      EC.prototype.sign = function sign(msg, key, enc, options) {
        if (_typeof(enc) === 'object') {
          options = enc;
          enc = null;
        }
        if (!options) options = {};
        key = this.keyFromPrivate(key, enc);
        msg = this._truncateToN(new BN(msg, 16)); // Zero-extend key to provide enough entropy
        var bytes = this.n.byteLength();
        var bkey = key.getPrivate().toArray('be', bytes); // Zero-extend nonce to have the same byte size as N
        var nonce = msg.toArray('be', bytes); // Instantiate Hmac_DRBG
        var drbg = new HmacDRBG({
          hash: this.hash,
          entropy: bkey,
          nonce: nonce,
          pers: options.pers,
          persEnc: options.persEnc || 'utf8'
        }); // Number of bytes to generate
        var ns1 = this.n.sub(new BN(1));
        for (var iter = 0; true; iter++) {
          var k = options.k ? options.k(iter) : new BN(drbg.generate(this.n.byteLength()));
          k = this._truncateToN(k, true);
          if (k.cmpn(1) <= 0 || k.cmp(ns1) >= 0) continue;
          var kp = this.g.mul(k);
          if (kp.isInfinity()) continue;
          var kpX = kp.getX();
          var r = kpX.umod(this.n);
          if (r.cmpn(0) === 0) continue;
          var s = k.invm(this.n).mul(r.mul(key.getPrivate()).iadd(msg));
          s = s.umod(this.n);
          if (s.cmpn(0) === 0) continue;
          var recoveryParam = (kp.getY().isOdd() ? 1 : 0) | (kpX.cmp(r) !== 0 ? 2 : 0); // Use complement of `s`, if it is > `n / 2`
          if (options.canonical && s.cmp(this.nh) > 0) {
            s = this.n.sub(s);
            recoveryParam ^= 1;
          }
          return new Signature({
            r: r,
            s: s,
            recoveryParam: recoveryParam
          });
        }
      };
      EC.prototype.verify = function verify(msg, signature, key, enc) {
        msg = this._truncateToN(new BN(msg, 16));
        key = this.keyFromPublic(key, enc);
        signature = new Signature(signature, 'hex'); // Perform primitive values validation
        var r = signature.r;
        var s = signature.s;
        if (r.cmpn(1) < 0 || r.cmp(this.n) >= 0) return false;
        if (s.cmpn(1) < 0 || s.cmp(this.n) >= 0) return false; // Validate signature
        var sinv = s.invm(this.n);
        var u1 = sinv.mul(msg).umod(this.n);
        var u2 = sinv.mul(r).umod(this.n);
        if (!this.curve._maxwellTrick) {
          var p = this.g.mulAdd(u1, key.getPublic(), u2);
          if (p.isInfinity()) return false;
          return p.getX().umod(this.n).cmp(r) === 0;
        } // NOTE: Greg Maxwell's trick, inspired by:
        // https://git.io/vad3K
        var p = this.g.jmulAdd(u1, key.getPublic(), u2);
        if (p.isInfinity()) return false; // Compare `p.x` of Jacobian point with `r`,
        // this will do `p.x == r * p.z^2` instead of multiplying `p.x` by the
        // inverse of `p.z^2`
        return p.eqXToP(r);
      };
      EC.prototype.recoverPubKey = function (msg, signature, j, enc) {
        assert((3 & j) === j, 'The recovery param is more than two bits');
        signature = new Signature(signature, enc);
        var n = this.n;
        var e = new BN(msg);
        var r = signature.r;
        var s = signature.s; // A set LSB signifies that the y-coordinate is odd
        var isYOdd = j & 1;
        var isSecondKey = j >> 1;
        if (r.cmp(this.curve.p.umod(this.curve.n)) >= 0 && isSecondKey) throw new Error('Unable to find sencond key candinate'); // 1.1. Let x = r + jn.
        if (isSecondKey) r = this.curve.pointFromX(r.add(this.curve.n), isYOdd);else r = this.curve.pointFromX(r, isYOdd);
        var rInv = signature.r.invm(n);
        var s1 = n.sub(e).mul(rInv).umod(n);
        var s2 = s.mul(rInv).umod(n); // 1.6.1 Compute Q = r^-1 (sR -  eG)
        //               Q = r^-1 (sR + -eG)
        return this.g.mulAdd(s1, r, s2);
      };
      EC.prototype.getKeyRecoveryParam = function (e, signature, Q, enc) {
        signature = new Signature(signature, enc);
        if (signature.recoveryParam !== null) return signature.recoveryParam;
        for (var i = 0; i < 4; i++) {
          var Qprime;
          try {
            Qprime = this.recoverPubKey(e, signature, i);
          } catch (e) {
            continue;
          }
          if (Qprime.eq(Q)) return i;
        }
        throw new Error('Unable to find valid recovery factor');
      };
    }, {
      "../../elliptic": 19,
      "./key": 27,
      "./signature": 28,
      "bn.js": 17,
      "hmac-drbg": 47
    }],
    27: [function (require, module, exports) {
      'use strict';

      var BN = require('bn.js');
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var assert = utils.assert;
      function KeyPair(ec, options) {
        this.ec = ec;
        this.priv = null;
        this.pub = null; // KeyPair(ec, { priv: ..., pub: ... })
        if (options.priv) this._importPrivate(options.priv, options.privEnc);
        if (options.pub) this._importPublic(options.pub, options.pubEnc);
      }
      module.exports = KeyPair;
      KeyPair.fromPublic = function fromPublic(ec, pub, enc) {
        if (_instanceof(pub, KeyPair)) return pub;
        return new KeyPair(ec, {
          pub: pub,
          pubEnc: enc
        });
      };
      KeyPair.fromPrivate = function fromPrivate(ec, priv, enc) {
        if (_instanceof(priv, KeyPair)) return priv;
        return new KeyPair(ec, {
          priv: priv,
          privEnc: enc
        });
      }; // TODO: should not validate for X25519
      KeyPair.prototype.validate = function validate() {
        var pub = this.getPublic();
        if (pub.isInfinity()) return {
          result: false,
          reason: 'Invalid public key'
        };
        if (!pub.validate()) return {
          result: false,
          reason: 'Public key is not a point'
        };
        if (!pub.mul(this.ec.curve.n).isInfinity()) return {
          result: false,
          reason: 'Public key * N != O'
        };
        return {
          result: true,
          reason: null
        };
      };
      KeyPair.prototype.getPublic = function getPublic(enc, compact) {
        if (!this.pub) this.pub = this.ec.g.mul(this.priv);
        if (!enc) return this.pub;
        return this.pub.encode(enc, compact);
      };
      KeyPair.prototype.getPrivate = function getPrivate(enc) {
        if (enc === 'hex') return this.priv.toString(16, 2);else return this.priv;
      };
      KeyPair.prototype._importPrivate = function _importPrivate(key, enc) {
        this.priv = new BN(key, enc || 16); // For Curve25519/Curve448 we have a specific procedure.
        // TODO Curve448
        if (this.ec.curve.type === 'mont') {
          var one = this.ec.curve.one;
          var mask = one.ushln(255 - 3).sub(one).ushln(3);
          this.priv = this.priv.or(one.ushln(255 - 1));
          this.priv = this.priv.and(mask);
        } else
          // Ensure that the priv won't be bigger than n, otherwise we may fail
          // in fixed multiplication method
          this.priv = this.priv.umod(this.ec.curve.n);
      };
      KeyPair.prototype._importPublic = function _importPublic(key, enc) {
        if (key.x || key.y) {
          // Montgomery points only have an `x` coordinate.
          // Weierstrass/Edwards points on the other hand have both `x` and
          // `y` coordinates.
          if (this.ec.curve.type === 'mont') {
            assert(key.x, 'Need x coordinate');
          } else if (this.ec.curve.type === 'short' || this.ec.curve.type === 'edwards') {
            assert(key.x && key.y, 'Need both x and y coordinate');
          }
          this.pub = this.ec.curve.point(key.x, key.y);
          return;
        }
        this.pub = this.ec.curve.decodePoint(key, enc);
      }; // ECDH
      KeyPair.prototype.derive = function derive(pub) {
        return pub.mul(this.priv).getX();
      }; // ECDSA
      KeyPair.prototype.sign = function sign(msg, enc, options) {
        return this.ec.sign(msg, this, enc, options);
      };
      KeyPair.prototype.verify = function verify(msg, signature) {
        return this.ec.verify(msg, signature, this);
      };
      KeyPair.prototype.inspect = function inspect() {
        return '<Key priv: ' + (this.priv && this.priv.toString(16, 2)) + ' pub: ' + (this.pub && this.pub.inspect()) + ' >';
      };
    }, {
      "../../elliptic": 19,
      "bn.js": 17
    }],
    28: [function (require, module, exports) {
      'use strict';

      var BN = require('bn.js');
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var assert = utils.assert;
      function Signature(options, enc) {
        if (_instanceof(options, Signature)) return options;
        if (this._importDER(options, enc)) return;
        assert(options.r && options.s, 'Signature without r or s');
        this.r = new BN(options.r, 16);
        this.s = new BN(options.s, 16);
        if (options.recoveryParam === undefined) this.recoveryParam = null;else this.recoveryParam = options.recoveryParam;
      }
      module.exports = Signature;
      function Position() {
        this.place = 0;
      }
      function getLength(buf, p) {
        var initial = buf[p.place++];
        if (!(initial & 0x80)) {
          return initial;
        }
        var octetLen = initial & 0xf;
        var val = 0;
        for (var i = 0, off = p.place; i < octetLen; i++, off++) {
          val <<= 8;
          val |= buf[off];
        }
        p.place = off;
        return val;
      }
      function rmPadding(buf) {
        var i = 0;
        var len = buf.length - 1;
        while (!buf[i] && !(buf[i + 1] & 0x80) && i < len) {
          i++;
        }
        if (i === 0) {
          return buf;
        }
        return buf.slice(i);
      }
      Signature.prototype._importDER = function _importDER(data, enc) {
        data = utils.toArray(data, enc);
        var p = new Position();
        if (data[p.place++] !== 0x30) {
          return false;
        }
        var len = getLength(data, p);
        if (len + p.place !== data.length) {
          return false;
        }
        if (data[p.place++] !== 0x02) {
          return false;
        }
        var rlen = getLength(data, p);
        var r = data.slice(p.place, rlen + p.place);
        p.place += rlen;
        if (data[p.place++] !== 0x02) {
          return false;
        }
        var slen = getLength(data, p);
        if (data.length !== slen + p.place) {
          return false;
        }
        var s = data.slice(p.place, slen + p.place);
        if (r[0] === 0 && r[1] & 0x80) {
          r = r.slice(1);
        }
        if (s[0] === 0 && s[1] & 0x80) {
          s = s.slice(1);
        }
        this.r = new BN(r);
        this.s = new BN(s);
        this.recoveryParam = null;
        return true;
      };
      function constructLength(arr, len) {
        if (len < 0x80) {
          arr.push(len);
          return;
        }
        var octets = 1 + (Math.log(len) / Math.LN2 >>> 3);
        arr.push(octets | 0x80);
        while (--octets) {
          arr.push(len >>> (octets << 3) & 0xff);
        }
        arr.push(len);
      }
      Signature.prototype.toDER = function toDER(enc) {
        var r = this.r.toArray();
        var s = this.s.toArray(); // Pad values
        if (r[0] & 0x80) r = [0].concat(r); // Pad values
        if (s[0] & 0x80) s = [0].concat(s);
        r = rmPadding(r);
        s = rmPadding(s);
        while (!s[0] && !(s[1] & 0x80)) {
          s = s.slice(1);
        }
        var arr = [0x02];
        constructLength(arr, r.length);
        arr = arr.concat(r);
        arr.push(0x02);
        constructLength(arr, s.length);
        var backHalf = arr.concat(s);
        var res = [0x30];
        constructLength(res, backHalf.length);
        res = res.concat(backHalf);
        return utils.encode(res, enc);
      };
    }, {
      "../../elliptic": 19,
      "bn.js": 17
    }],
    29: [function (require, module, exports) {
      'use strict';

      var hash = require('hash.js');
      var HmacDRBG = require('hmac-drbg');
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var assert = utils.assert;
      var parseBytes = utils.parseBytes;
      var KeyPair = require('./key');
      var Signature = require('./signature');
      function EDDSA(curve) {
        assert(curve === 'ed25519', 'only tested with ed25519 so far');
        if (!_instanceof(this, EDDSA)) return new EDDSA(curve);
        var curve = elliptic.curves[curve].curve;
        this.curve = curve;
        this.g = curve.g;
        this.g.precompute(curve.n.bitLength() + 1);
        this.pointClass = curve.point().constructor;
        this.encodingLength = Math.ceil(curve.n.bitLength() / 8);
        this.hash = hash.sha512;
      }
      module.exports = EDDSA; /**
                              * @param {Array|String} message - message bytes
                              * @param {Array|String|KeyPair} secret - secret bytes or a keypair
                              * @returns {Signature} - signature
                              */
      EDDSA.prototype.sign = function sign(message, secret) {
        message = parseBytes(message);
        var key = this.keyFromSecret(secret);
        var r = this.hashInt(key.messagePrefix(), message);
        var R = this.g.mul(r);
        var Rencoded = this.encodePoint(R);
        var s_ = this.hashInt(Rencoded, key.pubBytes(), message).mul(key.priv());
        var S = r.add(s_).umod(this.curve.n);
        return this.makeSignature({
          R: R,
          S: S,
          Rencoded: Rencoded
        });
      }; /**
         * @param {Array} message - message bytes
         * @param {Array|String|Signature} sig - sig bytes
         * @param {Array|String|Point|KeyPair} pub - public key
         * @returns {Boolean} - true if public key matches sig of message
         */
      EDDSA.prototype.verify = function verify(message, sig, pub) {
        message = parseBytes(message);
        sig = this.makeSignature(sig);
        var key = this.keyFromPublic(pub);
        var h = this.hashInt(sig.Rencoded(), key.pubBytes(), message);
        var SG = this.g.mul(sig.S());
        var RplusAh = sig.R().add(key.pub().mul(h));
        return RplusAh.eq(SG);
      };
      EDDSA.prototype.hashInt = function hashInt() {
        var hash = this.hash();
        for (var i = 0; i < arguments.length; i++) {
          hash.update(arguments[i]);
        }
        return utils.intFromLE(hash.digest()).umod(this.curve.n);
      };
      EDDSA.prototype.keyPair = function keyPair(options) {
        return new KeyPair(this, options);
      };
      EDDSA.prototype.keyFromPublic = function keyFromPublic(pub) {
        return KeyPair.fromPublic(this, pub);
      };
      EDDSA.prototype.keyFromSecret = function keyFromSecret(secret) {
        return KeyPair.fromSecret(this, secret);
      };
      EDDSA.prototype.genKeyPair = function genKeyPair(options) {
        if (!options) options = {}; // Instantiate Hmac_DRBG
        var drbg = new HmacDRBG({
          hash: this.hash,
          pers: options.pers,
          persEnc: options.persEnc || 'utf8',
          entropy: options.entropy || elliptic.rand(this.hash.hmacStrength),
          entropyEnc: options.entropy && options.entropyEnc || 'utf8',
          nonce: this.curve.n.toArray()
        });
        return this.keyFromSecret(drbg.generate(32));
      };
      EDDSA.prototype.makeSignature = function makeSignature(sig) {
        if (_instanceof(sig, Signature)) return sig;
        return new Signature(this, sig);
      }; /**
         * * https://tools.ietf.org/html/draft-josefsson-eddsa-ed25519-03#section-5.2
         *
         * EDDSA defines methods for encoding and decoding points and integers. These are
         * helper convenience methods, that pass along to utility functions implied
         * parameters.
         *
         */
      EDDSA.prototype.encodePoint = function encodePoint(point) {
        var enc = point.getY().toArray('le', this.encodingLength);
        enc[this.encodingLength - 1] |= point.getX().isOdd() ? 0x80 : 0;
        return enc;
      };
      EDDSA.prototype.decodePoint = function decodePoint(bytes) {
        bytes = utils.parseBytes(bytes);
        var lastIx = bytes.length - 1;
        var normed = bytes.slice(0, lastIx).concat(bytes[lastIx] & ~0x80);
        var xIsOdd = (bytes[lastIx] & 0x80) !== 0;
        var y = utils.intFromLE(normed);
        return this.curve.pointFromY(y, xIsOdd);
      };
      EDDSA.prototype.encodeInt = function encodeInt(num) {
        return num.toArray('le', this.encodingLength);
      };
      EDDSA.prototype.decodeInt = function decodeInt(bytes) {
        return utils.intFromLE(bytes);
      };
      EDDSA.prototype.isPoint = function isPoint(val) {
        return _instanceof(val, this.pointClass);
      };
    }, {
      "../../elliptic": 19,
      "./key": 30,
      "./signature": 31,
      "hash.js": 35,
      "hmac-drbg": 47
    }],
    30: [function (require, module, exports) {
      'use strict';

      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var assert = utils.assert;
      var parseBytes = utils.parseBytes;
      var cachedProperty = utils.cachedProperty; /**
                                                 * @param {EDDSA} eddsa - instance
                                                 * @param {Object} params - public/private key parameters
                                                 *
                                                 * @param {Array<Byte>} [params.secret] - secret seed bytes
                                                 * @param {Point} [params.pub] - public key point (aka `A` in eddsa terms)
                                                 * @param {Array<Byte>} [params.pub] - public key point encoded as bytes
                                                 *
                                                 */
      function KeyPair(eddsa, params) {
        this.eddsa = eddsa;
        if (params.hasOwnProperty('secret')) this._secret = parseBytes(params.secret);
        if (eddsa.isPoint(params.pub)) this._pub = params.pub;else {
          this._pubBytes = parseBytes(params.pub);
          if (this._pubBytes && this._pubBytes.length === 33 && this._pubBytes[0] === 0x40) this._pubBytes = this._pubBytes.slice(1, 33);
          if (this._pubBytes && this._pubBytes.length !== 32) throw new Error('Unknown point compression format');
        }
      }
      KeyPair.fromPublic = function fromPublic(eddsa, pub) {
        if (_instanceof(pub, KeyPair)) return pub;
        return new KeyPair(eddsa, {
          pub: pub
        });
      };
      KeyPair.fromSecret = function fromSecret(eddsa, secret) {
        if (_instanceof(secret, KeyPair)) return secret;
        return new KeyPair(eddsa, {
          secret: secret
        });
      };
      KeyPair.prototype.secret = function secret() {
        return this._secret;
      };
      cachedProperty(KeyPair, 'pubBytes', function pubBytes() {
        return this.eddsa.encodePoint(this.pub());
      });
      cachedProperty(KeyPair, 'pub', function pub() {
        if (this._pubBytes) return this.eddsa.decodePoint(this._pubBytes);
        return this.eddsa.g.mul(this.priv());
      });
      cachedProperty(KeyPair, 'privBytes', function privBytes() {
        var eddsa = this.eddsa;
        var hash = this.hash();
        var lastIx = eddsa.encodingLength - 1; // https://tools.ietf.org/html/rfc8032#section-5.1.5
        var a = hash.slice(0, eddsa.encodingLength);
        a[0] &= 248;
        a[lastIx] &= 127;
        a[lastIx] |= 64;
        return a;
      });
      cachedProperty(KeyPair, 'priv', function priv() {
        return this.eddsa.decodeInt(this.privBytes());
      });
      cachedProperty(KeyPair, 'hash', function hash() {
        return this.eddsa.hash().update(this.secret()).digest();
      });
      cachedProperty(KeyPair, 'messagePrefix', function messagePrefix() {
        return this.hash().slice(this.eddsa.encodingLength);
      });
      KeyPair.prototype.sign = function sign(message) {
        assert(this._secret, 'KeyPair can only verify');
        return this.eddsa.sign(message, this);
      };
      KeyPair.prototype.verify = function verify(message, sig) {
        return this.eddsa.verify(message, sig, this);
      };
      KeyPair.prototype.getSecret = function getSecret(enc) {
        assert(this._secret, 'KeyPair is public only');
        return utils.encode(this.secret(), enc);
      };
      KeyPair.prototype.getPublic = function getPublic(enc, compact) {
        return utils.encode((compact ? [0x40] : []).concat(this.pubBytes()), enc);
      };
      module.exports = KeyPair;
    }, {
      "../../elliptic": 19
    }],
    31: [function (require, module, exports) {
      'use strict';

      var BN = require('bn.js');
      var elliptic = require('../../elliptic');
      var utils = elliptic.utils;
      var assert = utils.assert;
      var cachedProperty = utils.cachedProperty;
      var parseBytes = utils.parseBytes; /**
                                         * @param {EDDSA} eddsa - eddsa instance
                                         * @param {Array<Bytes>|Object} sig -
                                         * @param {Array<Bytes>|Point} [sig.R] - R point as Point or bytes
                                         * @param {Array<Bytes>|bn} [sig.S] - S scalar as bn or bytes
                                         * @param {Array<Bytes>} [sig.Rencoded] - R point encoded
                                         * @param {Array<Bytes>} [sig.Sencoded] - S scalar encoded
                                         */
      function Signature(eddsa, sig) {
        this.eddsa = eddsa;
        if (_typeof(sig) !== 'object') sig = parseBytes(sig);
        if (Array.isArray(sig)) {
          sig = {
            R: sig.slice(0, eddsa.encodingLength),
            S: sig.slice(eddsa.encodingLength)
          };
        }
        assert(sig.R && sig.S, 'Signature without R or S');
        if (eddsa.isPoint(sig.R)) this._R = sig.R;
        if (_instanceof(sig.S, BN)) this._S = sig.S;
        this._Rencoded = Array.isArray(sig.R) ? sig.R : sig.Rencoded;
        this._Sencoded = Array.isArray(sig.S) ? sig.S : sig.Sencoded;
      }
      cachedProperty(Signature, 'S', function S() {
        return this.eddsa.decodeInt(this.Sencoded());
      });
      cachedProperty(Signature, 'R', function R() {
        return this.eddsa.decodePoint(this.Rencoded());
      });
      cachedProperty(Signature, 'Rencoded', function Rencoded() {
        return this.eddsa.encodePoint(this.R());
      });
      cachedProperty(Signature, 'Sencoded', function Sencoded() {
        return this.eddsa.encodeInt(this.S());
      });
      Signature.prototype.toBytes = function toBytes() {
        return this.Rencoded().concat(this.Sencoded());
      };
      Signature.prototype.toHex = function toHex() {
        return utils.encode(this.toBytes(), 'hex').toUpperCase();
      };
      module.exports = Signature;
    }, {
      "../../elliptic": 19,
      "bn.js": 17
    }],
    32: [function (require, module, exports) {
      module.exports = {
        doubles: {
          step: 4,
          points: [['e60fce93b59e9ec53011aabc21c23e97b2a31369b87a5ae9c44ee89e2a6dec0a', 'f7e3507399e595929db99f34f57937101296891e44d23f0be1f32cce69616821'], ['8282263212c609d9ea2a6e3e172de238d8c39cabd5ac1ca10646e23fd5f51508', '11f8a8098557dfe45e8256e830b60ace62d613ac2f7b17bed31b6eaff6e26caf'], ['175e159f728b865a72f99cc6c6fc846de0b93833fd2222ed73fce5b551e5b739', 'd3506e0d9e3c79eba4ef97a51ff71f5eacb5955add24345c6efa6ffee9fed695'], ['363d90d447b00c9c99ceac05b6262ee053441c7e55552ffe526bad8f83ff4640', '4e273adfc732221953b445397f3363145b9a89008199ecb62003c7f3bee9de9'], ['8b4b5f165df3c2be8c6244b5b745638843e4a781a15bcd1b69f79a55dffdf80c', '4aad0a6f68d308b4b3fbd7813ab0da04f9e336546162ee56b3eff0c65fd4fd36'], ['723cbaa6e5db996d6bf771c00bd548c7b700dbffa6c0e77bcb6115925232fcda', '96e867b5595cc498a921137488824d6e2660a0653779494801dc069d9eb39f5f'], ['eebfa4d493bebf98ba5feec812c2d3b50947961237a919839a533eca0e7dd7fa', '5d9a8ca3970ef0f269ee7edaf178089d9ae4cdc3a711f712ddfd4fdae1de8999'], ['100f44da696e71672791d0a09b7bde459f1215a29b3c03bfefd7835b39a48db0', 'cdd9e13192a00b772ec8f3300c090666b7ff4a18ff5195ac0fbd5cd62bc65a09'], ['e1031be262c7ed1b1dc9227a4a04c017a77f8d4464f3b3852c8acde6e534fd2d', '9d7061928940405e6bb6a4176597535af292dd419e1ced79a44f18f29456a00d'], ['feea6cae46d55b530ac2839f143bd7ec5cf8b266a41d6af52d5e688d9094696d', 'e57c6b6c97dce1bab06e4e12bf3ecd5c981c8957cc41442d3155debf18090088'], ['da67a91d91049cdcb367be4be6ffca3cfeed657d808583de33fa978bc1ec6cb1', '9bacaa35481642bc41f463f7ec9780e5dec7adc508f740a17e9ea8e27a68be1d'], ['53904faa0b334cdda6e000935ef22151ec08d0f7bb11069f57545ccc1a37b7c0', '5bc087d0bc80106d88c9eccac20d3c1c13999981e14434699dcb096b022771c8'], ['8e7bcd0bd35983a7719cca7764ca906779b53a043a9b8bcaeff959f43ad86047', '10b7770b2a3da4b3940310420ca9514579e88e2e47fd68b3ea10047e8460372a'], ['385eed34c1cdff21e6d0818689b81bde71a7f4f18397e6690a841e1599c43862', '283bebc3e8ea23f56701de19e9ebf4576b304eec2086dc8cc0458fe5542e5453'], ['6f9d9b803ecf191637c73a4413dfa180fddf84a5947fbc9c606ed86c3fac3a7', '7c80c68e603059ba69b8e2a30e45c4d47ea4dd2f5c281002d86890603a842160'], ['3322d401243c4e2582a2147c104d6ecbf774d163db0f5e5313b7e0e742d0e6bd', '56e70797e9664ef5bfb019bc4ddaf9b72805f63ea2873af624f3a2e96c28b2a0'], ['85672c7d2de0b7da2bd1770d89665868741b3f9af7643397721d74d28134ab83', '7c481b9b5b43b2eb6374049bfa62c2e5e77f17fcc5298f44c8e3094f790313a6'], ['948bf809b1988a46b06c9f1919413b10f9226c60f668832ffd959af60c82a0a', '53a562856dcb6646dc6b74c5d1c3418c6d4dff08c97cd2bed4cb7f88d8c8e589'], ['6260ce7f461801c34f067ce0f02873a8f1b0e44dfc69752accecd819f38fd8e8', 'bc2da82b6fa5b571a7f09049776a1ef7ecd292238051c198c1a84e95b2b4ae17'], ['e5037de0afc1d8d43d8348414bbf4103043ec8f575bfdc432953cc8d2037fa2d', '4571534baa94d3b5f9f98d09fb990bddbd5f5b03ec481f10e0e5dc841d755bda'], ['e06372b0f4a207adf5ea905e8f1771b4e7e8dbd1c6a6c5b725866a0ae4fce725', '7a908974bce18cfe12a27bb2ad5a488cd7484a7787104870b27034f94eee31dd'], ['213c7a715cd5d45358d0bbf9dc0ce02204b10bdde2a3f58540ad6908d0559754', '4b6dad0b5ae462507013ad06245ba190bb4850f5f36a7eeddff2c27534b458f2'], ['4e7c272a7af4b34e8dbb9352a5419a87e2838c70adc62cddf0cc3a3b08fbd53c', '17749c766c9d0b18e16fd09f6def681b530b9614bff7dd33e0b3941817dcaae6'], ['fea74e3dbe778b1b10f238ad61686aa5c76e3db2be43057632427e2840fb27b6', '6e0568db9b0b13297cf674deccb6af93126b596b973f7b77701d3db7f23cb96f'], ['76e64113f677cf0e10a2570d599968d31544e179b760432952c02a4417bdde39', 'c90ddf8dee4e95cf577066d70681f0d35e2a33d2b56d2032b4b1752d1901ac01'], ['c738c56b03b2abe1e8281baa743f8f9a8f7cc643df26cbee3ab150242bcbb891', '893fb578951ad2537f718f2eacbfbbbb82314eef7880cfe917e735d9699a84c3'], ['d895626548b65b81e264c7637c972877d1d72e5f3a925014372e9f6588f6c14b', 'febfaa38f2bc7eae728ec60818c340eb03428d632bb067e179363ed75d7d991f'], ['b8da94032a957518eb0f6433571e8761ceffc73693e84edd49150a564f676e03', '2804dfa44805a1e4d7c99cc9762808b092cc584d95ff3b511488e4e74efdf6e7'], ['e80fea14441fb33a7d8adab9475d7fab2019effb5156a792f1a11778e3c0df5d', 'eed1de7f638e00771e89768ca3ca94472d155e80af322ea9fcb4291b6ac9ec78'], ['a301697bdfcd704313ba48e51d567543f2a182031efd6915ddc07bbcc4e16070', '7370f91cfb67e4f5081809fa25d40f9b1735dbf7c0a11a130c0d1a041e177ea1'], ['90ad85b389d6b936463f9d0512678de208cc330b11307fffab7ac63e3fb04ed4', 'e507a3620a38261affdcbd9427222b839aefabe1582894d991d4d48cb6ef150'], ['8f68b9d2f63b5f339239c1ad981f162ee88c5678723ea3351b7b444c9ec4c0da', '662a9f2dba063986de1d90c2b6be215dbbea2cfe95510bfdf23cbf79501fff82'], ['e4f3fb0176af85d65ff99ff9198c36091f48e86503681e3e6686fd5053231e11', '1e63633ad0ef4f1c1661a6d0ea02b7286cc7e74ec951d1c9822c38576feb73bc'], ['8c00fa9b18ebf331eb961537a45a4266c7034f2f0d4e1d0716fb6eae20eae29e', 'efa47267fea521a1a9dc343a3736c974c2fadafa81e36c54e7d2a4c66702414b'], ['e7a26ce69dd4829f3e10cec0a9e98ed3143d084f308b92c0997fddfc60cb3e41', '2a758e300fa7984b471b006a1aafbb18d0a6b2c0420e83e20e8a9421cf2cfd51'], ['b6459e0ee3662ec8d23540c223bcbdc571cbcb967d79424f3cf29eb3de6b80ef', '67c876d06f3e06de1dadf16e5661db3c4b3ae6d48e35b2ff30bf0b61a71ba45'], ['d68a80c8280bb840793234aa118f06231d6f1fc67e73c5a5deda0f5b496943e8', 'db8ba9fff4b586d00c4b1f9177b0e28b5b0e7b8f7845295a294c84266b133120'], ['324aed7df65c804252dc0270907a30b09612aeb973449cea4095980fc28d3d5d', '648a365774b61f2ff130c0c35aec1f4f19213b0c7e332843967224af96ab7c84'], ['4df9c14919cde61f6d51dfdbe5fee5dceec4143ba8d1ca888e8bd373fd054c96', '35ec51092d8728050974c23a1d85d4b5d506cdc288490192ebac06cad10d5d'], ['9c3919a84a474870faed8a9c1cc66021523489054d7f0308cbfc99c8ac1f98cd', 'ddb84f0f4a4ddd57584f044bf260e641905326f76c64c8e6be7e5e03d4fc599d'], ['6057170b1dd12fdf8de05f281d8e06bb91e1493a8b91d4cc5a21382120a959e5', '9a1af0b26a6a4807add9a2daf71df262465152bc3ee24c65e899be932385a2a8'], ['a576df8e23a08411421439a4518da31880cef0fba7d4df12b1a6973eecb94266', '40a6bf20e76640b2c92b97afe58cd82c432e10a7f514d9f3ee8be11ae1b28ec8'], ['7778a78c28dec3e30a05fe9629de8c38bb30d1f5cf9a3a208f763889be58ad71', '34626d9ab5a5b22ff7098e12f2ff580087b38411ff24ac563b513fc1fd9f43ac'], ['928955ee637a84463729fd30e7afd2ed5f96274e5ad7e5cb09eda9c06d903ac', 'c25621003d3f42a827b78a13093a95eeac3d26efa8a8d83fc5180e935bcd091f'], ['85d0fef3ec6db109399064f3a0e3b2855645b4a907ad354527aae75163d82751', '1f03648413a38c0be29d496e582cf5663e8751e96877331582c237a24eb1f962'], ['ff2b0dce97eece97c1c9b6041798b85dfdfb6d8882da20308f5404824526087e', '493d13fef524ba188af4c4dc54d07936c7b7ed6fb90e2ceb2c951e01f0c29907'], ['827fbbe4b1e880ea9ed2b2e6301b212b57f1ee148cd6dd28780e5e2cf856e241', 'c60f9c923c727b0b71bef2c67d1d12687ff7a63186903166d605b68baec293ec'], ['eaa649f21f51bdbae7be4ae34ce6e5217a58fdce7f47f9aa7f3b58fa2120e2b3', 'be3279ed5bbbb03ac69a80f89879aa5a01a6b965f13f7e59d47a5305ba5ad93d'], ['e4a42d43c5cf169d9391df6decf42ee541b6d8f0c9a137401e23632dda34d24f', '4d9f92e716d1c73526fc99ccfb8ad34ce886eedfa8d8e4f13a7f7131deba9414'], ['1ec80fef360cbdd954160fadab352b6b92b53576a88fea4947173b9d4300bf19', 'aeefe93756b5340d2f3a4958a7abbf5e0146e77f6295a07b671cdc1cc107cefd'], ['146a778c04670c2f91b00af4680dfa8bce3490717d58ba889ddb5928366642be', 'b318e0ec3354028add669827f9d4b2870aaa971d2f7e5ed1d0b297483d83efd0'], ['fa50c0f61d22e5f07e3acebb1aa07b128d0012209a28b9776d76a8793180eef9', '6b84c6922397eba9b72cd2872281a68a5e683293a57a213b38cd8d7d3f4f2811'], ['da1d61d0ca721a11b1a5bf6b7d88e8421a288ab5d5bba5220e53d32b5f067ec2', '8157f55a7c99306c79c0766161c91e2966a73899d279b48a655fba0f1ad836f1'], ['a8e282ff0c9706907215ff98e8fd416615311de0446f1e062a73b0610d064e13', '7f97355b8db81c09abfb7f3c5b2515888b679a3e50dd6bd6cef7c73111f4cc0c'], ['174a53b9c9a285872d39e56e6913cab15d59b1fa512508c022f382de8319497c', 'ccc9dc37abfc9c1657b4155f2c47f9e6646b3a1d8cb9854383da13ac079afa73'], ['959396981943785c3d3e57edf5018cdbe039e730e4918b3d884fdff09475b7ba', '2e7e552888c331dd8ba0386a4b9cd6849c653f64c8709385e9b8abf87524f2fd'], ['d2a63a50ae401e56d645a1153b109a8fcca0a43d561fba2dbb51340c9d82b151', 'e82d86fb6443fcb7565aee58b2948220a70f750af484ca52d4142174dcf89405'], ['64587e2335471eb890ee7896d7cfdc866bacbdbd3839317b3436f9b45617e073', 'd99fcdd5bf6902e2ae96dd6447c299a185b90a39133aeab358299e5e9faf6589'], ['8481bde0e4e4d885b3a546d3e549de042f0aa6cea250e7fd358d6c86dd45e458', '38ee7b8cba5404dd84a25bf39cecb2ca900a79c42b262e556d64b1b59779057e'], ['13464a57a78102aa62b6979ae817f4637ffcfed3c4b1ce30bcd6303f6caf666b', '69be159004614580ef7e433453ccb0ca48f300a81d0942e13f495a907f6ecc27'], ['bc4a9df5b713fe2e9aef430bcc1dc97a0cd9ccede2f28588cada3a0d2d83f366', 'd3a81ca6e785c06383937adf4b798caa6e8a9fbfa547b16d758d666581f33c1'], ['8c28a97bf8298bc0d23d8c749452a32e694b65e30a9472a3954ab30fe5324caa', '40a30463a3305193378fedf31f7cc0eb7ae784f0451cb9459e71dc73cbef9482'], ['8ea9666139527a8c1dd94ce4f071fd23c8b350c5a4bb33748c4ba111faccae0', '620efabbc8ee2782e24e7c0cfb95c5d735b783be9cf0f8e955af34a30e62b945'], ['dd3625faef5ba06074669716bbd3788d89bdde815959968092f76cc4eb9a9787', '7a188fa3520e30d461da2501045731ca941461982883395937f68d00c644a573'], ['f710d79d9eb962297e4f6232b40e8f7feb2bc63814614d692c12de752408221e', 'ea98e67232d3b3295d3b535532115ccac8612c721851617526ae47a9c77bfc82']]
        },
        naf: {
          wnd: 7,
          points: [['f9308a019258c31049344f85f89d5229b531c845836f99b08601f113bce036f9', '388f7b0f632de8140fe337e62a37f3566500a99934c2231b6cb9fd7584b8e672'], ['2f8bde4d1a07209355b4a7250a5c5128e88b84bddc619ab7cba8d569b240efe4', 'd8ac222636e5e3d6d4dba9dda6c9c426f788271bab0d6840dca87d3aa6ac62d6'], ['5cbdf0646e5db4eaa398f365f2ea7a0e3d419b7e0330e39ce92bddedcac4f9bc', '6aebca40ba255960a3178d6d861a54dba813d0b813fde7b5a5082628087264da'], ['acd484e2f0c7f65309ad178a9f559abde09796974c57e714c35f110dfc27ccbe', 'cc338921b0a7d9fd64380971763b61e9add888a4375f8e0f05cc262ac64f9c37'], ['774ae7f858a9411e5ef4246b70c65aac5649980be5c17891bbec17895da008cb', 'd984a032eb6b5e190243dd56d7b7b365372db1e2dff9d6a8301d74c9c953c61b'], ['f28773c2d975288bc7d1d205c3748651b075fbc6610e58cddeeddf8f19405aa8', 'ab0902e8d880a89758212eb65cdaf473a1a06da521fa91f29b5cb52db03ed81'], ['d7924d4f7d43ea965a465ae3095ff41131e5946f3c85f79e44adbcf8e27e080e', '581e2872a86c72a683842ec228cc6defea40af2bd896d3a5c504dc9ff6a26b58'], ['defdea4cdb677750a420fee807eacf21eb9898ae79b9768766e4faa04a2d4a34', '4211ab0694635168e997b0ead2a93daeced1f4a04a95c0f6cfb199f69e56eb77'], ['2b4ea0a797a443d293ef5cff444f4979f06acfebd7e86d277475656138385b6c', '85e89bc037945d93b343083b5a1c86131a01f60c50269763b570c854e5c09b7a'], ['352bbf4a4cdd12564f93fa332ce333301d9ad40271f8107181340aef25be59d5', '321eb4075348f534d59c18259dda3e1f4a1b3b2e71b1039c67bd3d8bcf81998c'], ['2fa2104d6b38d11b0230010559879124e42ab8dfeff5ff29dc9cdadd4ecacc3f', '2de1068295dd865b64569335bd5dd80181d70ecfc882648423ba76b532b7d67'], ['9248279b09b4d68dab21a9b066edda83263c3d84e09572e269ca0cd7f5453714', '73016f7bf234aade5d1aa71bdea2b1ff3fc0de2a887912ffe54a32ce97cb3402'], ['daed4f2be3a8bf278e70132fb0beb7522f570e144bf615c07e996d443dee8729', 'a69dce4a7d6c98e8d4a1aca87ef8d7003f83c230f3afa726ab40e52290be1c55'], ['c44d12c7065d812e8acf28d7cbb19f9011ecd9e9fdf281b0e6a3b5e87d22e7db', '2119a460ce326cdc76c45926c982fdac0e106e861edf61c5a039063f0e0e6482'], ['6a245bf6dc698504c89a20cfded60853152b695336c28063b61c65cbd269e6b4', 'e022cf42c2bd4a708b3f5126f16a24ad8b33ba48d0423b6efd5e6348100d8a82'], ['1697ffa6fd9de627c077e3d2fe541084ce13300b0bec1146f95ae57f0d0bd6a5', 'b9c398f186806f5d27561506e4557433a2cf15009e498ae7adee9d63d01b2396'], ['605bdb019981718b986d0f07e834cb0d9deb8360ffb7f61df982345ef27a7479', '2972d2de4f8d20681a78d93ec96fe23c26bfae84fb14db43b01e1e9056b8c49'], ['62d14dab4150bf497402fdc45a215e10dcb01c354959b10cfe31c7e9d87ff33d', '80fc06bd8cc5b01098088a1950eed0db01aa132967ab472235f5642483b25eaf'], ['80c60ad0040f27dade5b4b06c408e56b2c50e9f56b9b8b425e555c2f86308b6f', '1c38303f1cc5c30f26e66bad7fe72f70a65eed4cbe7024eb1aa01f56430bd57a'], ['7a9375ad6167ad54aa74c6348cc54d344cc5dc9487d847049d5eabb0fa03c8fb', 'd0e3fa9eca8726909559e0d79269046bdc59ea10c70ce2b02d499ec224dc7f7'], ['d528ecd9b696b54c907a9ed045447a79bb408ec39b68df504bb51f459bc3ffc9', 'eecf41253136e5f99966f21881fd656ebc4345405c520dbc063465b521409933'], ['49370a4b5f43412ea25f514e8ecdad05266115e4a7ecb1387231808f8b45963', '758f3f41afd6ed428b3081b0512fd62a54c3f3afbb5b6764b653052a12949c9a'], ['77f230936ee88cbbd73df930d64702ef881d811e0e1498e2f1c13eb1fc345d74', '958ef42a7886b6400a08266e9ba1b37896c95330d97077cbbe8eb3c7671c60d6'], ['f2dac991cc4ce4b9ea44887e5c7c0bce58c80074ab9d4dbaeb28531b7739f530', 'e0dedc9b3b2f8dad4da1f32dec2531df9eb5fbeb0598e4fd1a117dba703a3c37'], ['463b3d9f662621fb1b4be8fbbe2520125a216cdfc9dae3debcba4850c690d45b', '5ed430d78c296c3543114306dd8622d7c622e27c970a1de31cb377b01af7307e'], ['f16f804244e46e2a09232d4aff3b59976b98fac14328a2d1a32496b49998f247', 'cedabd9b82203f7e13d206fcdf4e33d92a6c53c26e5cce26d6579962c4e31df6'], ['caf754272dc84563b0352b7a14311af55d245315ace27c65369e15f7151d41d1', 'cb474660ef35f5f2a41b643fa5e460575f4fa9b7962232a5c32f908318a04476'], ['2600ca4b282cb986f85d0f1709979d8b44a09c07cb86d7c124497bc86f082120', '4119b88753c15bd6a693b03fcddbb45d5ac6be74ab5f0ef44b0be9475a7e4b40'], ['7635ca72d7e8432c338ec53cd12220bc01c48685e24f7dc8c602a7746998e435', '91b649609489d613d1d5e590f78e6d74ecfc061d57048bad9e76f302c5b9c61'], ['754e3239f325570cdbbf4a87deee8a66b7f2b33479d468fbc1a50743bf56cc18', '673fb86e5bda30fb3cd0ed304ea49a023ee33d0197a695d0c5d98093c536683'], ['e3e6bd1071a1e96aff57859c82d570f0330800661d1c952f9fe2694691d9b9e8', '59c9e0bba394e76f40c0aa58379a3cb6a5a2283993e90c4167002af4920e37f5'], ['186b483d056a033826ae73d88f732985c4ccb1f32ba35f4b4cc47fdcf04aa6eb', '3b952d32c67cf77e2e17446e204180ab21fb8090895138b4a4a797f86e80888b'], ['df9d70a6b9876ce544c98561f4be4f725442e6d2b737d9c91a8321724ce0963f', '55eb2dafd84d6ccd5f862b785dc39d4ab157222720ef9da217b8c45cf2ba2417'], ['5edd5cc23c51e87a497ca815d5dce0f8ab52554f849ed8995de64c5f34ce7143', 'efae9c8dbc14130661e8cec030c89ad0c13c66c0d17a2905cdc706ab7399a868'], ['290798c2b6476830da12fe02287e9e777aa3fba1c355b17a722d362f84614fba', 'e38da76dcd440621988d00bcf79af25d5b29c094db2a23146d003afd41943e7a'], ['af3c423a95d9f5b3054754efa150ac39cd29552fe360257362dfdecef4053b45', 'f98a3fd831eb2b749a93b0e6f35cfb40c8cd5aa667a15581bc2feded498fd9c6'], ['766dbb24d134e745cccaa28c99bf274906bb66b26dcf98df8d2fed50d884249a', '744b1152eacbe5e38dcc887980da38b897584a65fa06cedd2c924f97cbac5996'], ['59dbf46f8c94759ba21277c33784f41645f7b44f6c596a58ce92e666191abe3e', 'c534ad44175fbc300f4ea6ce648309a042ce739a7919798cd85e216c4a307f6e'], ['f13ada95103c4537305e691e74e9a4a8dd647e711a95e73cb62dc6018cfd87b8', 'e13817b44ee14de663bf4bc808341f326949e21a6a75c2570778419bdaf5733d'], ['7754b4fa0e8aced06d4167a2c59cca4cda1869c06ebadfb6488550015a88522c', '30e93e864e669d82224b967c3020b8fa8d1e4e350b6cbcc537a48b57841163a2'], ['948dcadf5990e048aa3874d46abef9d701858f95de8041d2a6828c99e2262519', 'e491a42537f6e597d5d28a3224b1bc25df9154efbd2ef1d2cbba2cae5347d57e'], ['7962414450c76c1689c7b48f8202ec37fb224cf5ac0bfa1570328a8a3d7c77ab', '100b610ec4ffb4760d5c1fc133ef6f6b12507a051f04ac5760afa5b29db83437'], ['3514087834964b54b15b160644d915485a16977225b8847bb0dd085137ec47ca', 'ef0afbb2056205448e1652c48e8127fc6039e77c15c2378b7e7d15a0de293311'], ['d3cc30ad6b483e4bc79ce2c9dd8bc54993e947eb8df787b442943d3f7b527eaf', '8b378a22d827278d89c5e9be8f9508ae3c2ad46290358630afb34db04eede0a4'], ['1624d84780732860ce1c78fcbfefe08b2b29823db913f6493975ba0ff4847610', '68651cf9b6da903e0914448c6cd9d4ca896878f5282be4c8cc06e2a404078575'], ['733ce80da955a8a26902c95633e62a985192474b5af207da6df7b4fd5fc61cd4', 'f5435a2bd2badf7d485a4d8b8db9fcce3e1ef8e0201e4578c54673bc1dc5ea1d'], ['15d9441254945064cf1a1c33bbd3b49f8966c5092171e699ef258dfab81c045c', 'd56eb30b69463e7234f5137b73b84177434800bacebfc685fc37bbe9efe4070d'], ['a1d0fcf2ec9de675b612136e5ce70d271c21417c9d2b8aaaac138599d0717940', 'edd77f50bcb5a3cab2e90737309667f2641462a54070f3d519212d39c197a629'], ['e22fbe15c0af8ccc5780c0735f84dbe9a790badee8245c06c7ca37331cb36980', 'a855babad5cd60c88b430a69f53a1a7a38289154964799be43d06d77d31da06'], ['311091dd9860e8e20ee13473c1155f5f69635e394704eaa74009452246cfa9b3', '66db656f87d1f04fffd1f04788c06830871ec5a64feee685bd80f0b1286d8374'], ['34c1fd04d301be89b31c0442d3e6ac24883928b45a9340781867d4232ec2dbdf', '9414685e97b1b5954bd46f730174136d57f1ceeb487443dc5321857ba73abee'], ['f219ea5d6b54701c1c14de5b557eb42a8d13f3abbcd08affcc2a5e6b049b8d63', '4cb95957e83d40b0f73af4544cccf6b1f4b08d3c07b27fb8d8c2962a400766d1'], ['d7b8740f74a8fbaab1f683db8f45de26543a5490bca627087236912469a0b448', 'fa77968128d9c92ee1010f337ad4717eff15db5ed3c049b3411e0315eaa4593b'], ['32d31c222f8f6f0ef86f7c98d3a3335ead5bcd32abdd94289fe4d3091aa824bf', '5f3032f5892156e39ccd3d7915b9e1da2e6dac9e6f26e961118d14b8462e1661'], ['7461f371914ab32671045a155d9831ea8793d77cd59592c4340f86cbc18347b5', '8ec0ba238b96bec0cbdddcae0aa442542eee1ff50c986ea6b39847b3cc092ff6'], ['ee079adb1df1860074356a25aa38206a6d716b2c3e67453d287698bad7b2b2d6', '8dc2412aafe3be5c4c5f37e0ecc5f9f6a446989af04c4e25ebaac479ec1c8c1e'], ['16ec93e447ec83f0467b18302ee620f7e65de331874c9dc72bfd8616ba9da6b5', '5e4631150e62fb40d0e8c2a7ca5804a39d58186a50e497139626778e25b0674d'], ['eaa5f980c245f6f038978290afa70b6bd8855897f98b6aa485b96065d537bd99', 'f65f5d3e292c2e0819a528391c994624d784869d7e6ea67fb18041024edc07dc'], ['78c9407544ac132692ee1910a02439958ae04877151342ea96c4b6b35a49f51', 'f3e0319169eb9b85d5404795539a5e68fa1fbd583c064d2462b675f194a3ddb4'], ['494f4be219a1a77016dcd838431aea0001cdc8ae7a6fc688726578d9702857a5', '42242a969283a5f339ba7f075e36ba2af925ce30d767ed6e55f4b031880d562c'], ['a598a8030da6d86c6bc7f2f5144ea549d28211ea58faa70ebf4c1e665c1fe9b5', '204b5d6f84822c307e4b4a7140737aec23fc63b65b35f86a10026dbd2d864e6b'], ['c41916365abb2b5d09192f5f2dbeafec208f020f12570a184dbadc3e58595997', '4f14351d0087efa49d245b328984989d5caf9450f34bfc0ed16e96b58fa9913'], ['841d6063a586fa475a724604da03bc5b92a2e0d2e0a36acfe4c73a5514742881', '73867f59c0659e81904f9a1c7543698e62562d6744c169ce7a36de01a8d6154'], ['5e95bb399a6971d376026947f89bde2f282b33810928be4ded112ac4d70e20d5', '39f23f366809085beebfc71181313775a99c9aed7d8ba38b161384c746012865'], ['36e4641a53948fd476c39f8a99fd974e5ec07564b5315d8bf99471bca0ef2f66', 'd2424b1b1abe4eb8164227b085c9aa9456ea13493fd563e06fd51cf5694c78fc'], ['336581ea7bfbbb290c191a2f507a41cf5643842170e914faeab27c2c579f726', 'ead12168595fe1be99252129b6e56b3391f7ab1410cd1e0ef3dcdcabd2fda224'], ['8ab89816dadfd6b6a1f2634fcf00ec8403781025ed6890c4849742706bd43ede', '6fdcef09f2f6d0a044e654aef624136f503d459c3e89845858a47a9129cdd24e'], ['1e33f1a746c9c5778133344d9299fcaa20b0938e8acff2544bb40284b8c5fb94', '60660257dd11b3aa9c8ed618d24edff2306d320f1d03010e33a7d2057f3b3b6'], ['85b7c1dcb3cec1b7ee7f30ded79dd20a0ed1f4cc18cbcfcfa410361fd8f08f31', '3d98a9cdd026dd43f39048f25a8847f4fcafad1895d7a633c6fed3c35e999511'], ['29df9fbd8d9e46509275f4b125d6d45d7fbe9a3b878a7af872a2800661ac5f51', 'b4c4fe99c775a606e2d8862179139ffda61dc861c019e55cd2876eb2a27d84b'], ['a0b1cae06b0a847a3fea6e671aaf8adfdfe58ca2f768105c8082b2e449fce252', 'ae434102edde0958ec4b19d917a6a28e6b72da1834aff0e650f049503a296cf2'], ['4e8ceafb9b3e9a136dc7ff67e840295b499dfb3b2133e4ba113f2e4c0e121e5', 'cf2174118c8b6d7a4b48f6d534ce5c79422c086a63460502b827ce62a326683c'], ['d24a44e047e19b6f5afb81c7ca2f69080a5076689a010919f42725c2b789a33b', '6fb8d5591b466f8fc63db50f1c0f1c69013f996887b8244d2cdec417afea8fa3'], ['ea01606a7a6c9cdd249fdfcfacb99584001edd28abbab77b5104e98e8e3b35d4', '322af4908c7312b0cfbfe369f7a7b3cdb7d4494bc2823700cfd652188a3ea98d'], ['af8addbf2b661c8a6c6328655eb96651252007d8c5ea31be4ad196de8ce2131f', '6749e67c029b85f52a034eafd096836b2520818680e26ac8f3dfbcdb71749700'], ['e3ae1974566ca06cc516d47e0fb165a674a3dabcfca15e722f0e3450f45889', '2aeabe7e4531510116217f07bf4d07300de97e4874f81f533420a72eeb0bd6a4'], ['591ee355313d99721cf6993ffed1e3e301993ff3ed258802075ea8ced397e246', 'b0ea558a113c30bea60fc4775460c7901ff0b053d25ca2bdeee98f1a4be5d196'], ['11396d55fda54c49f19aa97318d8da61fa8584e47b084945077cf03255b52984', '998c74a8cd45ac01289d5833a7beb4744ff536b01b257be4c5767bea93ea57a4'], ['3c5d2a1ba39c5a1790000738c9e0c40b8dcdfd5468754b6405540157e017aa7a', 'b2284279995a34e2f9d4de7396fc18b80f9b8b9fdd270f6661f79ca4c81bd257'], ['cc8704b8a60a0defa3a99a7299f2e9c3fbc395afb04ac078425ef8a1793cc030', 'bdd46039feed17881d1e0862db347f8cf395b74fc4bcdc4e940b74e3ac1f1b13'], ['c533e4f7ea8555aacd9777ac5cad29b97dd4defccc53ee7ea204119b2889b197', '6f0a256bc5efdf429a2fb6242f1a43a2d9b925bb4a4b3a26bb8e0f45eb596096'], ['c14f8f2ccb27d6f109f6d08d03cc96a69ba8c34eec07bbcf566d48e33da6593', 'c359d6923bb398f7fd4473e16fe1c28475b740dd098075e6c0e8649113dc3a38'], ['a6cbc3046bc6a450bac24789fa17115a4c9739ed75f8f21ce441f72e0b90e6ef', '21ae7f4680e889bb130619e2c0f95a360ceb573c70603139862afd617fa9b9f'], ['347d6d9a02c48927ebfb86c1359b1caf130a3c0267d11ce6344b39f99d43cc38', '60ea7f61a353524d1c987f6ecec92f086d565ab687870cb12689ff1e31c74448'], ['da6545d2181db8d983f7dcb375ef5866d47c67b1bf31c8cf855ef7437b72656a', '49b96715ab6878a79e78f07ce5680c5d6673051b4935bd897fea824b77dc208a'], ['c40747cc9d012cb1a13b8148309c6de7ec25d6945d657146b9d5994b8feb1111', '5ca560753be2a12fc6de6caf2cb489565db936156b9514e1bb5e83037e0fa2d4'], ['4e42c8ec82c99798ccf3a610be870e78338c7f713348bd34c8203ef4037f3502', '7571d74ee5e0fb92a7a8b33a07783341a5492144cc54bcc40a94473693606437'], ['3775ab7089bc6af823aba2e1af70b236d251cadb0c86743287522a1b3b0dedea', 'be52d107bcfa09d8bcb9736a828cfa7fac8db17bf7a76a2c42ad961409018cf7'], ['cee31cbf7e34ec379d94fb814d3d775ad954595d1314ba8846959e3e82f74e26', '8fd64a14c06b589c26b947ae2bcf6bfa0149ef0be14ed4d80f448a01c43b1c6d'], ['b4f9eaea09b6917619f6ea6a4eb5464efddb58fd45b1ebefcdc1a01d08b47986', '39e5c9925b5a54b07433a4f18c61726f8bb131c012ca542eb24a8ac07200682a'], ['d4263dfc3d2df923a0179a48966d30ce84e2515afc3dccc1b77907792ebcc60e', '62dfaf07a0f78feb30e30d6295853ce189e127760ad6cf7fae164e122a208d54'], ['48457524820fa65a4f8d35eb6930857c0032acc0a4a2de422233eeda897612c4', '25a748ab367979d98733c38a1fa1c2e7dc6cc07db2d60a9ae7a76aaa49bd0f77'], ['dfeeef1881101f2cb11644f3a2afdfc2045e19919152923f367a1767c11cceda', 'ecfb7056cf1de042f9420bab396793c0c390bde74b4bbdff16a83ae09a9a7517'], ['6d7ef6b17543f8373c573f44e1f389835d89bcbc6062ced36c82df83b8fae859', 'cd450ec335438986dfefa10c57fea9bcc521a0959b2d80bbf74b190dca712d10'], ['e75605d59102a5a2684500d3b991f2e3f3c88b93225547035af25af66e04541f', 'f5c54754a8f71ee540b9b48728473e314f729ac5308b06938360990e2bfad125'], ['eb98660f4c4dfaa06a2be453d5020bc99a0c2e60abe388457dd43fefb1ed620c', '6cb9a8876d9cb8520609af3add26cd20a0a7cd8a9411131ce85f44100099223e'], ['13e87b027d8514d35939f2e6892b19922154596941888336dc3563e3b8dba942', 'fef5a3c68059a6dec5d624114bf1e91aac2b9da568d6abeb2570d55646b8adf1'], ['ee163026e9fd6fe017c38f06a5be6fc125424b371ce2708e7bf4491691e5764a', '1acb250f255dd61c43d94ccc670d0f58f49ae3fa15b96623e5430da0ad6c62b2'], ['b268f5ef9ad51e4d78de3a750c2dc89b1e626d43505867999932e5db33af3d80', '5f310d4b3c99b9ebb19f77d41c1dee018cf0d34fd4191614003e945a1216e423'], ['ff07f3118a9df035e9fad85eb6c7bfe42b02f01ca99ceea3bf7ffdba93c4750d', '438136d603e858a3a5c440c38eccbaddc1d2942114e2eddd4740d098ced1f0d8'], ['8d8b9855c7c052a34146fd20ffb658bea4b9f69e0d825ebec16e8c3ce2b526a1', 'cdb559eedc2d79f926baf44fb84ea4d44bcf50fee51d7ceb30e2e7f463036758'], ['52db0b5384dfbf05bfa9d472d7ae26dfe4b851ceca91b1eba54263180da32b63', 'c3b997d050ee5d423ebaf66a6db9f57b3180c902875679de924b69d84a7b375'], ['e62f9490d3d51da6395efd24e80919cc7d0f29c3f3fa48c6fff543becbd43352', '6d89ad7ba4876b0b22c2ca280c682862f342c8591f1daf5170e07bfd9ccafa7d'], ['7f30ea2476b399b4957509c88f77d0191afa2ff5cb7b14fd6d8e7d65aaab1193', 'ca5ef7d4b231c94c3b15389a5f6311e9daff7bb67b103e9880ef4bff637acaec'], ['5098ff1e1d9f14fb46a210fada6c903fef0fb7b4a1dd1d9ac60a0361800b7a00', '9731141d81fc8f8084d37c6e7542006b3ee1b40d60dfe5362a5b132fd17ddc0'], ['32b78c7de9ee512a72895be6b9cbefa6e2f3c4ccce445c96b9f2c81e2778ad58', 'ee1849f513df71e32efc3896ee28260c73bb80547ae2275ba497237794c8753c'], ['e2cb74fddc8e9fbcd076eef2a7c72b0ce37d50f08269dfc074b581550547a4f7', 'd3aa2ed71c9dd2247a62df062736eb0baddea9e36122d2be8641abcb005cc4a4'], ['8438447566d4d7bedadc299496ab357426009a35f235cb141be0d99cd10ae3a8', 'c4e1020916980a4da5d01ac5e6ad330734ef0d7906631c4f2390426b2edd791f'], ['4162d488b89402039b584c6fc6c308870587d9c46f660b878ab65c82c711d67e', '67163e903236289f776f22c25fb8a3afc1732f2b84b4e95dbda47ae5a0852649'], ['3fad3fa84caf0f34f0f89bfd2dcf54fc175d767aec3e50684f3ba4a4bf5f683d', 'cd1bc7cb6cc407bb2f0ca647c718a730cf71872e7d0d2a53fa20efcdfe61826'], ['674f2600a3007a00568c1a7ce05d0816c1fb84bf1370798f1c69532faeb1a86b', '299d21f9413f33b3edf43b257004580b70db57da0b182259e09eecc69e0d38a5'], ['d32f4da54ade74abb81b815ad1fb3b263d82d6c692714bcff87d29bd5ee9f08f', 'f9429e738b8e53b968e99016c059707782e14f4535359d582fc416910b3eea87'], ['30e4e670435385556e593657135845d36fbb6931f72b08cb1ed954f1e3ce3ff6', '462f9bce619898638499350113bbc9b10a878d35da70740dc695a559eb88db7b'], ['be2062003c51cc3004682904330e4dee7f3dcd10b01e580bf1971b04d4cad297', '62188bc49d61e5428573d48a74e1c655b1c61090905682a0d5558ed72dccb9bc'], ['93144423ace3451ed29e0fb9ac2af211cb6e84a601df5993c419859fff5df04a', '7c10dfb164c3425f5c71a3f9d7992038f1065224f72bb9d1d902a6d13037b47c'], ['b015f8044f5fcbdcf21ca26d6c34fb8197829205c7b7d2a7cb66418c157b112c', 'ab8c1e086d04e813744a655b2df8d5f83b3cdc6faa3088c1d3aea1454e3a1d5f'], ['d5e9e1da649d97d89e4868117a465a3a4f8a18de57a140d36b3f2af341a21b52', '4cb04437f391ed73111a13cc1d4dd0db1693465c2240480d8955e8592f27447a'], ['d3ae41047dd7ca065dbf8ed77b992439983005cd72e16d6f996a5316d36966bb', 'bd1aeb21ad22ebb22a10f0303417c6d964f8cdd7df0aca614b10dc14d125ac46'], ['463e2763d885f958fc66cdd22800f0a487197d0a82e377b49f80af87c897b065', 'bfefacdb0e5d0fd7df3a311a94de062b26b80c61fbc97508b79992671ef7ca7f'], ['7985fdfd127c0567c6f53ec1bb63ec3158e597c40bfe747c83cddfc910641917', '603c12daf3d9862ef2b25fe1de289aed24ed291e0ec6708703a5bd567f32ed03'], ['74a1ad6b5f76e39db2dd249410eac7f99e74c59cb83d2d0ed5ff1543da7703e9', 'cc6157ef18c9c63cd6193d83631bbea0093e0968942e8c33d5737fd790e0db08'], ['30682a50703375f602d416664ba19b7fc9bab42c72747463a71d0896b22f6da3', '553e04f6b018b4fa6c8f39e7f311d3176290d0e0f19ca73f17714d9977a22ff8'], ['9e2158f0d7c0d5f26c3791efefa79597654e7a2b2464f52b1ee6c1347769ef57', '712fcdd1b9053f09003a3481fa7762e9ffd7c8ef35a38509e2fbf2629008373'], ['176e26989a43c9cfeba4029c202538c28172e566e3c4fce7322857f3be327d66', 'ed8cc9d04b29eb877d270b4878dc43c19aefd31f4eee09ee7b47834c1fa4b1c3'], ['75d46efea3771e6e68abb89a13ad747ecf1892393dfc4f1b7004788c50374da8', '9852390a99507679fd0b86fd2b39a868d7efc22151346e1a3ca4726586a6bed8'], ['809a20c67d64900ffb698c4c825f6d5f2310fb0451c869345b7319f645605721', '9e994980d9917e22b76b061927fa04143d096ccc54963e6a5ebfa5f3f8e286c1'], ['1b38903a43f7f114ed4500b4eac7083fdefece1cf29c63528d563446f972c180', '4036edc931a60ae889353f77fd53de4a2708b26b6f5da72ad3394119daf408f9']]
        }
      };
    }, {}],
    33: [function (require, module, exports) {
      'use strict';

      var utils = exports;
      var BN = require('bn.js');
      var minAssert = require('minimalistic-assert');
      var minUtils = require('minimalistic-crypto-utils');
      utils.assert = minAssert;
      utils.toArray = minUtils.toArray;
      utils.zero2 = minUtils.zero2;
      utils.toHex = minUtils.toHex;
      utils.encode = minUtils.encode; // Represent num in a w-NAF form
      function getNAF(num, w) {
        var naf = [];
        var ws = 1 << w + 1;
        var k = num.clone();
        while (k.cmpn(1) >= 0) {
          var z;
          if (k.isOdd()) {
            var mod = k.andln(ws - 1);
            if (mod > (ws >> 1) - 1) z = (ws >> 1) - mod;else z = mod;
            k.isubn(z);
          } else {
            z = 0;
          }
          naf.push(z); // Optimization, shift by word if possible
          var shift = k.cmpn(0) !== 0 && k.andln(ws - 1) === 0 ? w + 1 : 1;
          for (var i = 1; i < shift; i++) {
            naf.push(0);
          }
          k.iushrn(shift);
        }
        return naf;
      }
      utils.getNAF = getNAF; // Represent k1, k2 in a Joint Sparse Form
      function getJSF(k1, k2) {
        var jsf = [[], []];
        k1 = k1.clone();
        k2 = k2.clone();
        var d1 = 0;
        var d2 = 0;
        while (k1.cmpn(-d1) > 0 || k2.cmpn(-d2) > 0) {
          // First phase
          var m14 = k1.andln(3) + d1 & 3;
          var m24 = k2.andln(3) + d2 & 3;
          if (m14 === 3) m14 = -1;
          if (m24 === 3) m24 = -1;
          var u1;
          if ((m14 & 1) === 0) {
            u1 = 0;
          } else {
            var m8 = k1.andln(7) + d1 & 7;
            if ((m8 === 3 || m8 === 5) && m24 === 2) u1 = -m14;else u1 = m14;
          }
          jsf[0].push(u1);
          var u2;
          if ((m24 & 1) === 0) {
            u2 = 0;
          } else {
            var m8 = k2.andln(7) + d2 & 7;
            if ((m8 === 3 || m8 === 5) && m14 === 2) u2 = -m24;else u2 = m24;
          }
          jsf[1].push(u2); // Second phase
          if (2 * d1 === u1 + 1) d1 = 1 - d1;
          if (2 * d2 === u2 + 1) d2 = 1 - d2;
          k1.iushrn(1);
          k2.iushrn(1);
        }
        return jsf;
      }
      utils.getJSF = getJSF;
      function cachedProperty(obj, name, computer) {
        var key = '_' + name;
        obj.prototype[name] = function cachedProperty() {
          return this[key] !== undefined ? this[key] : this[key] = computer.call(this);
        };
      }
      utils.cachedProperty = cachedProperty;
      function parseBytes(bytes) {
        return typeof bytes === 'string' ? utils.toArray(bytes, 'hex') : bytes;
      }
      utils.parseBytes = parseBytes;
      function intFromLE(bytes) {
        return new BN(bytes, 'hex', 'le');
      }
      utils.intFromLE = intFromLE;
    }, {
      "bn.js": 17,
      "minimalistic-assert": 49,
      "minimalistic-crypto-utils": 50
    }],
    34: [function (require, module, exports) {
      // email-addresses.js - RFC 5322 email address parser
      // v 3.0.1
      //
      // http://tools.ietf.org/html/rfc5322
      //
      // This library does not validate email addresses.
      // emailAddresses attempts to parse addresses using the (fairly liberal)
      // grammar specified in RFC 5322.
      //
      // email-addresses returns {
      //     ast: <an abstract syntax tree based on rfc5322>,
      //     addresses: [{
      //            node: <node in ast for this address>,
      //            name: <display-name>,
      //            address: <addr-spec>,
      //            local: <local-part>,
      //            domain: <domain>
      //         }, ...]
      // }
      //
      // emailAddresses.parseOneAddress and emailAddresses.parseAddressList
      // work as you might expect. Try it out.
      //
      // Many thanks to Dominic Sayers and his documentation on the is_email function,
      // http://code.google.com/p/isemail/ , which helped greatly in writing this parser.
      (function (global) {
        "use strict";

        function parse5322(opts) {
          // tokenizing functions
          function inStr() {
            return pos < len;
          }
          function curTok() {
            return parseString[pos];
          }
          function getPos() {
            return pos;
          }
          function setPos(i) {
            pos = i;
          }
          function nextTok() {
            pos += 1;
          }
          function initialize() {
            pos = 0;
            len = parseString.length;
          } // parser helper functions
          function o(name, value) {
            return {
              name: name,
              tokens: value || "",
              semantic: value || "",
              children: []
            };
          }
          function wrap(name, ast) {
            var n;
            if (ast === null) {
              return null;
            }
            n = o(name);
            n.tokens = ast.tokens;
            n.semantic = ast.semantic;
            n.children.push(ast);
            return n;
          }
          function add(parent, child) {
            if (child !== null) {
              parent.tokens += child.tokens;
              parent.semantic += child.semantic;
            }
            parent.children.push(child);
            return parent;
          }
          function compareToken(fxnCompare) {
            var tok;
            if (!inStr()) {
              return null;
            }
            tok = curTok();
            if (fxnCompare(tok)) {
              nextTok();
              return o('token', tok);
            }
            return null;
          }
          function literal(lit) {
            return function literalFunc() {
              return wrap('literal', compareToken(function (tok) {
                return tok === lit;
              }));
            };
          }
          function and() {
            var args = arguments;
            return function andFunc() {
              var i, s, result, start;
              start = getPos();
              s = o('and');
              for (i = 0; i < args.length; i += 1) {
                result = args[i]();
                if (result === null) {
                  setPos(start);
                  return null;
                }
                add(s, result);
              }
              return s;
            };
          }
          function or() {
            var args = arguments;
            return function orFunc() {
              var i, result, start;
              start = getPos();
              for (i = 0; i < args.length; i += 1) {
                result = args[i]();
                if (result !== null) {
                  return result;
                }
                setPos(start);
              }
              return null;
            };
          }
          function opt(prod) {
            return function optFunc() {
              var result, start;
              start = getPos();
              result = prod();
              if (result !== null) {
                return result;
              } else {
                setPos(start);
                return o('opt');
              }
            };
          }
          function invis(prod) {
            return function invisFunc() {
              var result = prod();
              if (result !== null) {
                result.semantic = "";
              }
              return result;
            };
          }
          function colwsp(prod) {
            return function collapseSemanticWhitespace() {
              var result = prod();
              if (result !== null && result.semantic.length > 0) {
                result.semantic = " ";
              }
              return result;
            };
          }
          function star(prod, minimum) {
            return function starFunc() {
              var s, result, count, start, min;
              start = getPos();
              s = o('star');
              count = 0;
              min = minimum === undefined ? 0 : minimum;
              while ((result = prod()) !== null) {
                count = count + 1;
                add(s, result);
              }
              if (count >= min) {
                return s;
              } else {
                setPos(start);
                return null;
              }
            };
          } // One expects names to get normalized like this:
          // "  First  Last " -> "First Last"
          // "First Last" -> "First Last"
          // "First   Last" -> "First Last"
          function collapseWhitespace(s) {
            return s.replace(/([ \t]|\r\n)+/g, ' ').replace(/^\s*/, '').replace(/\s*$/, '');
          } // UTF-8 pseudo-production (RFC 6532)
          // RFC 6532 extends RFC 5322 productions to include UTF-8
          // using the following productions:
          // UTF8-non-ascii  =   UTF8-2 / UTF8-3 / UTF8-4
          // UTF8-2          =   <Defined in Section 4 of RFC3629>
          // UTF8-3          =   <Defined in Section 4 of RFC3629>
          // UTF8-4          =   <Defined in Section 4 of RFC3629>
          //
          // For reference, the extended RFC 5322 productions are:
          // VCHAR   =/  UTF8-non-ascii
          // ctext   =/  UTF8-non-ascii
          // atext   =/  UTF8-non-ascii
          // qtext   =/  UTF8-non-ascii
          // dtext   =/  UTF8-non-ascii
          function isUTF8NonAscii(tok) {
            // In JavaScript, we just deal directly with Unicode code points,
            // so we aren't checking individual bytes for UTF-8 encoding.
            // Just check that the character is non-ascii.
            return tok.charCodeAt(0) >= 128;
          } // common productions (RFC 5234)
          // http://tools.ietf.org/html/rfc5234
          // B.1. Core Rules
          // CR             =  %x0D
          //                         ; carriage return
          function cr() {
            return wrap('cr', literal('\r')());
          } // CRLF           =  CR LF
          //                         ; Internet standard newline
          function crlf() {
            return wrap('crlf', and(cr, lf)());
          } // DQUOTE         =  %x22
          //                         ; " (Double Quote)
          function dquote() {
            return wrap('dquote', literal('"')());
          } // HTAB           =  %x09
          //                         ; horizontal tab
          function htab() {
            return wrap('htab', literal('\t')());
          } // LF             =  %x0A
          //                         ; linefeed
          function lf() {
            return wrap('lf', literal('\n')());
          } // SP             =  %x20
          function sp() {
            return wrap('sp', literal(' ')());
          } // VCHAR          =  %x21-7E
          //                         ; visible (printing) characters
          function vchar() {
            return wrap('vchar', compareToken(function vcharFunc(tok) {
              var code = tok.charCodeAt(0);
              var accept = 0x21 <= code && code <= 0x7E;
              if (opts.rfc6532) {
                accept = accept || isUTF8NonAscii(tok);
              }
              return accept;
            }));
          } // WSP            =  SP / HTAB
          //                         ; white space
          function wsp() {
            return wrap('wsp', or(sp, htab)());
          } // email productions (RFC 5322)
          // http://tools.ietf.org/html/rfc5322
          // 3.2.1. Quoted characters
          // quoted-pair     =   ("\" (VCHAR / WSP)) / obs-qp
          function quotedPair() {
            var qp = wrap('quoted-pair', or(and(literal('\\'), or(vchar, wsp)), obsQP)());
            if (qp === null) {
              return null;
            } // a quoted pair will be two characters, and the "\" character
            // should be semantically "invisible" (RFC 5322 3.2.1)
            qp.semantic = qp.semantic[1];
            return qp;
          } // 3.2.2. Folding White Space and Comments
          // FWS             =   ([*WSP CRLF] 1*WSP) /  obs-FWS
          function fws() {
            return wrap('fws', or(obsFws, and(opt(and(star(wsp), invis(crlf))), star(wsp, 1)))());
          } // ctext           =   %d33-39 /          ; Printable US-ASCII
          //                     %d42-91 /          ;  characters not including
          //                     %d93-126 /         ;  "(", ")", or "\"
          //                     obs-ctext
          function ctext() {
            return wrap('ctext', or(function ctextFunc1() {
              return compareToken(function ctextFunc2(tok) {
                var code = tok.charCodeAt(0);
                var accept = 33 <= code && code <= 39 || 42 <= code && code <= 91 || 93 <= code && code <= 126;
                if (opts.rfc6532) {
                  accept = accept || isUTF8NonAscii(tok);
                }
                return accept;
              });
            }, obsCtext)());
          } // ccontent        =   ctext / quoted-pair / comment
          function ccontent() {
            return wrap('ccontent', or(ctext, quotedPair, comment)());
          } // comment         =   "(" *([FWS] ccontent) [FWS] ")"
          function comment() {
            return wrap('comment', and(literal('('), star(and(opt(fws), ccontent)), opt(fws), literal(')'))());
          } // CFWS            =   (1*([FWS] comment) [FWS]) / FWS
          function cfws() {
            return wrap('cfws', or(and(star(and(opt(fws), comment), 1), opt(fws)), fws)());
          } // 3.2.3. Atom
          //atext           =   ALPHA / DIGIT /    ; Printable US-ASCII
          //                       "!" / "#" /        ;  characters not including
          //                       "$" / "%" /        ;  specials.  Used for atoms.
          //                       "&" / "'" /
          //                       "*" / "+" /
          //                       "-" / "/" /
          //                       "=" / "?" /
          //                       "^" / "_" /
          //                       "`" / "{" /
          //                       "|" / "}" /
          //                       "~"
          function atext() {
            return wrap('atext', compareToken(function atextFunc(tok) {
              var accept = 'a' <= tok && tok <= 'z' || 'A' <= tok && tok <= 'Z' || '0' <= tok && tok <= '9' || ['!', '#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'].indexOf(tok) >= 0;
              if (opts.rfc6532) {
                accept = accept || isUTF8NonAscii(tok);
              }
              return accept;
            }));
          } // atom            =   [CFWS] 1*atext [CFWS]
          function atom() {
            return wrap('atom', and(colwsp(opt(cfws)), star(atext, 1), colwsp(opt(cfws)))());
          } // dot-atom-text   =   1*atext *("." 1*atext)
          function dotAtomText() {
            var s, maybeText;
            s = wrap('dot-atom-text', star(atext, 1)());
            if (s === null) {
              return s;
            }
            maybeText = star(and(literal('.'), star(atext, 1)))();
            if (maybeText !== null) {
              add(s, maybeText);
            }
            return s;
          } // dot-atom        =   [CFWS] dot-atom-text [CFWS]
          function dotAtom() {
            return wrap('dot-atom', and(invis(opt(cfws)), dotAtomText, invis(opt(cfws)))());
          } // 3.2.4. Quoted Strings
          //  qtext           =   %d33 /             ; Printable US-ASCII
          //                      %d35-91 /          ;  characters not including
          //                      %d93-126 /         ;  "\" or the quote character
          //                      obs-qtext
          function qtext() {
            return wrap('qtext', or(function qtextFunc1() {
              return compareToken(function qtextFunc2(tok) {
                var code = tok.charCodeAt(0);
                var accept = 33 === code || 35 <= code && code <= 91 || 93 <= code && code <= 126;
                if (opts.rfc6532) {
                  accept = accept || isUTF8NonAscii(tok);
                }
                return accept;
              });
            }, obsQtext)());
          } // qcontent        =   qtext / quoted-pair
          function qcontent() {
            return wrap('qcontent', or(qtext, quotedPair)());
          } //  quoted-string   =   [CFWS]
          //                      DQUOTE *([FWS] qcontent) [FWS] DQUOTE
          //                      [CFWS]
          function quotedString() {
            return wrap('quoted-string', and(invis(opt(cfws)), invis(dquote), star(and(opt(colwsp(fws)), qcontent)), opt(invis(fws)), invis(dquote), invis(opt(cfws)))());
          } // 3.2.5 Miscellaneous Tokens
          // word            =   atom / quoted-string
          function word() {
            return wrap('word', or(atom, quotedString)());
          } // phrase          =   1*word / obs-phrase
          function phrase() {
            return wrap('phrase', or(obsPhrase, star(word, 1))());
          } // 3.4. Address Specification
          //   address         =   mailbox / group
          function address() {
            return wrap('address', or(mailbox, group)());
          } //   mailbox         =   name-addr / addr-spec
          function mailbox() {
            return wrap('mailbox', or(nameAddr, addrSpec)());
          } //   name-addr       =   [display-name] angle-addr
          function nameAddr() {
            return wrap('name-addr', and(opt(displayName), angleAddr)());
          } //   angle-addr      =   [CFWS] "<" addr-spec ">" [CFWS] /
          //                       obs-angle-addr
          function angleAddr() {
            return wrap('angle-addr', or(and(invis(opt(cfws)), literal('<'), addrSpec, literal('>'), invis(opt(cfws))), obsAngleAddr)());
          } //   group           =   display-name ":" [group-list] ";" [CFWS]
          function group() {
            return wrap('group', and(displayName, literal(':'), opt(groupList), literal(';'), invis(opt(cfws)))());
          } //   display-name    =   phrase
          function displayName() {
            return wrap('display-name', function phraseFixedSemantic() {
              var result = phrase();
              if (result !== null) {
                result.semantic = collapseWhitespace(result.semantic);
              }
              return result;
            }());
          } //   mailbox-list    =   (mailbox *("," mailbox)) / obs-mbox-list
          function mailboxList() {
            return wrap('mailbox-list', or(and(mailbox, star(and(literal(','), mailbox))), obsMboxList)());
          } //   address-list    =   (address *("," address)) / obs-addr-list
          function addressList() {
            return wrap('address-list', or(and(address, star(and(literal(','), address))), obsAddrList)());
          } //   group-list      =   mailbox-list / CFWS / obs-group-list
          function groupList() {
            return wrap('group-list', or(mailboxList, invis(cfws), obsGroupList)());
          } // 3.4.1 Addr-Spec Specification
          // local-part      =   dot-atom / quoted-string / obs-local-part
          function localPart() {
            // note: quoted-string, dotAtom are proper subsets of obs-local-part
            // so we really just have to look for obsLocalPart, if we don't care about the exact parse tree
            return wrap('local-part', or(obsLocalPart, dotAtom, quotedString)());
          } //  dtext           =   %d33-90 /          ; Printable US-ASCII
          //                      %d94-126 /         ;  characters not including
          //                      obs-dtext          ;  "[", "]", or "\"
          function dtext() {
            return wrap('dtext', or(function dtextFunc1() {
              return compareToken(function dtextFunc2(tok) {
                var code = tok.charCodeAt(0);
                var accept = 33 <= code && code <= 90 || 94 <= code && code <= 126;
                if (opts.rfc6532) {
                  accept = accept || isUTF8NonAscii(tok);
                }
                return accept;
              });
            }, obsDtext)());
          } // domain-literal  =   [CFWS] "[" *([FWS] dtext) [FWS] "]" [CFWS]
          function domainLiteral() {
            return wrap('domain-literal', and(invis(opt(cfws)), literal('['), star(and(opt(fws), dtext)), opt(fws), literal(']'), invis(opt(cfws)))());
          } // domain          =   dot-atom / domain-literal / obs-domain
          function domain() {
            return wrap('domain', function domainCheckTLD() {
              var result = or(obsDomain, dotAtom, domainLiteral)();
              if (opts.rejectTLD) {
                if (result.semantic.indexOf('.') < 0) {
                  return null;
                }
              } // strip all whitespace from domains
              if (result) {
                result.semantic = result.semantic.replace(/\s+/g, '');
              }
              return result;
            }());
          } // addr-spec       =   local-part "@" domain
          function addrSpec() {
            return wrap('addr-spec', and(localPart, literal('@'), domain)());
          } // 3.6.2 Originator Fields
          // Below we only parse the field body, not the name of the field
          // like "From:", "Sender:", or "Reply-To:". Other libraries that
          // parse email headers can parse those and defer to these productions
          // for the "RFC 5322" part.
          // RFC 6854 2.1. Replacement of RFC 5322, Section 3.6.2. Originator Fields
          // from = "From:" (mailbox-list / address-list) CRLF
          function fromSpec() {
            return wrap('from', or(mailboxList, addressList)());
          } // RFC 6854 2.1. Replacement of RFC 5322, Section 3.6.2. Originator Fields
          // sender = "Sender:" (mailbox / address) CRLF
          function senderSpec() {
            return wrap('sender', or(mailbox, address)());
          } // RFC 6854 2.1. Replacement of RFC 5322, Section 3.6.2. Originator Fields
          // reply-to = "Reply-To:" address-list CRLF
          function replyToSpec() {
            return wrap('reply-to', addressList());
          } // 4.1. Miscellaneous Obsolete Tokens
          //  obs-NO-WS-CTL   =   %d1-8 /            ; US-ASCII control
          //                      %d11 /             ;  characters that do not
          //                      %d12 /             ;  include the carriage
          //                      %d14-31 /          ;  return, line feed, and
          //                      %d127              ;  white space characters
          function obsNoWsCtl() {
            return opts.strict ? null : wrap('obs-NO-WS-CTL', compareToken(function (tok) {
              var code = tok.charCodeAt(0);
              return 1 <= code && code <= 8 || 11 === code || 12 === code || 14 <= code && code <= 31 || 127 === code;
            }));
          } // obs-ctext       =   obs-NO-WS-CTL
          function obsCtext() {
            return opts.strict ? null : wrap('obs-ctext', obsNoWsCtl());
          } // obs-qtext       =   obs-NO-WS-CTL
          function obsQtext() {
            return opts.strict ? null : wrap('obs-qtext', obsNoWsCtl());
          } // obs-qp          =   "\" (%d0 / obs-NO-WS-CTL / LF / CR)
          function obsQP() {
            return opts.strict ? null : wrap('obs-qp', and(literal('\\'), or(literal('\0'), obsNoWsCtl, lf, cr))());
          } // obs-phrase      =   word *(word / "." / CFWS)
          function obsPhrase() {
            return opts.strict ? null : wrap('obs-phrase', and(word, star(or(word, literal('.'), colwsp(cfws))))());
          } // 4.2. Obsolete Folding White Space
          // NOTE: read the errata http://www.rfc-editor.org/errata_search.php?rfc=5322&eid=1908
          // obs-FWS         =   1*([CRLF] WSP)
          function obsFws() {
            return opts.strict ? null : wrap('obs-FWS', star(and(invis(opt(crlf)), wsp), 1)());
          } // 4.4. Obsolete Addressing
          // obs-angle-addr  =   [CFWS] "<" obs-route addr-spec ">" [CFWS]
          function obsAngleAddr() {
            return opts.strict ? null : wrap('obs-angle-addr', and(invis(opt(cfws)), literal('<'), obsRoute, addrSpec, literal('>'), invis(opt(cfws)))());
          } // obs-route       =   obs-domain-list ":"
          function obsRoute() {
            return opts.strict ? null : wrap('obs-route', and(obsDomainList, literal(':'))());
          } //   obs-domain-list =   *(CFWS / ",") "@" domain
          //                       *("," [CFWS] ["@" domain])
          function obsDomainList() {
            return opts.strict ? null : wrap('obs-domain-list', and(star(or(invis(cfws), literal(','))), literal('@'), domain, star(and(literal(','), invis(opt(cfws)), opt(and(literal('@'), domain)))))());
          } // obs-mbox-list   =   *([CFWS] ",") mailbox *("," [mailbox / CFWS])
          function obsMboxList() {
            return opts.strict ? null : wrap('obs-mbox-list', and(star(and(invis(opt(cfws)), literal(','))), mailbox, star(and(literal(','), opt(and(mailbox, invis(cfws))))))());
          } // obs-addr-list   =   *([CFWS] ",") address *("," [address / CFWS])
          function obsAddrList() {
            return opts.strict ? null : wrap('obs-addr-list', and(star(and(invis(opt(cfws)), literal(','))), address, star(and(literal(','), opt(and(address, invis(cfws))))))());
          } // obs-group-list  =   1*([CFWS] ",") [CFWS]
          function obsGroupList() {
            return opts.strict ? null : wrap('obs-group-list', and(star(and(invis(opt(cfws)), literal(',')), 1), invis(opt(cfws)))());
          } // obs-local-part = word *("." word)
          function obsLocalPart() {
            return opts.strict ? null : wrap('obs-local-part', and(word, star(and(literal('.'), word)))());
          } // obs-domain       = atom *("." atom)
          function obsDomain() {
            return opts.strict ? null : wrap('obs-domain', and(atom, star(and(literal('.'), atom)))());
          } // obs-dtext       =   obs-NO-WS-CTL / quoted-pair
          function obsDtext() {
            return opts.strict ? null : wrap('obs-dtext', or(obsNoWsCtl, quotedPair)());
          } /////////////////////////////////////////////////////
          // ast analysis
          function findNode(name, root) {
            var i, stack, node;
            if (root === null || root === undefined) {
              return null;
            }
            stack = [root];
            while (stack.length > 0) {
              node = stack.pop();
              if (node.name === name) {
                return node;
              }
              for (i = node.children.length - 1; i >= 0; i -= 1) {
                stack.push(node.children[i]);
              }
            }
            return null;
          }
          function findAllNodes(name, root) {
            var i, stack, node, result;
            if (root === null || root === undefined) {
              return null;
            }
            stack = [root];
            result = [];
            while (stack.length > 0) {
              node = stack.pop();
              if (node.name === name) {
                result.push(node);
              }
              for (i = node.children.length - 1; i >= 0; i -= 1) {
                stack.push(node.children[i]);
              }
            }
            return result;
          }
          function findAllNodesNoChildren(names, root) {
            var i, stack, node, result, namesLookup;
            if (root === null || root === undefined) {
              return null;
            }
            stack = [root];
            result = [];
            namesLookup = {};
            for (i = 0; i < names.length; i += 1) {
              namesLookup[names[i]] = true;
            }
            while (stack.length > 0) {
              node = stack.pop();
              if (node.name in namesLookup) {
                result.push(node); // don't look at children (hence findAllNodesNoChildren)
              } else {
                for (i = node.children.length - 1; i >= 0; i -= 1) {
                  stack.push(node.children[i]);
                }
              }
            }
            return result;
          }
          function giveResult(ast) {
            var addresses, groupsAndMailboxes, i, groupOrMailbox, result;
            if (ast === null) {
              return null;
            }
            addresses = []; // An address is a 'group' (i.e. a list of mailboxes) or a 'mailbox'.
            groupsAndMailboxes = findAllNodesNoChildren(['group', 'mailbox'], ast);
            for (i = 0; i < groupsAndMailboxes.length; i += 1) {
              groupOrMailbox = groupsAndMailboxes[i];
              if (groupOrMailbox.name === 'group') {
                addresses.push(giveResultGroup(groupOrMailbox));
              } else if (groupOrMailbox.name === 'mailbox') {
                addresses.push(giveResultMailbox(groupOrMailbox));
              }
            }
            result = {
              ast: ast,
              addresses: addresses
            };
            if (opts.simple) {
              result = simplifyResult(result);
            }
            if (opts.oneResult) {
              return oneResult(result);
            }
            if (opts.simple) {
              return result && result.addresses;
            } else {
              return result;
            }
          }
          function giveResultGroup(group) {
            var i;
            var groupName = findNode('display-name', group);
            var groupResultMailboxes = [];
            var mailboxes = findAllNodesNoChildren(['mailbox'], group);
            for (i = 0; i < mailboxes.length; i += 1) {
              groupResultMailboxes.push(giveResultMailbox(mailboxes[i]));
            }
            return {
              node: group,
              parts: {
                name: groupName
              },
              type: group.name,
              // 'group'
              name: grabSemantic(groupName),
              addresses: groupResultMailboxes
            };
          }
          function giveResultMailbox(mailbox) {
            var name = findNode('display-name', mailbox);
            var aspec = findNode('addr-spec', mailbox);
            var comments = findAllNodes('cfws', mailbox);
            var local = findNode('local-part', aspec);
            var domain = findNode('domain', aspec);
            return {
              node: mailbox,
              parts: {
                name: name,
                address: aspec,
                local: local,
                domain: domain,
                comments: comments
              },
              type: mailbox.name,
              // 'mailbox'
              name: grabSemantic(name),
              address: grabSemantic(aspec),
              local: grabSemantic(local),
              domain: grabSemantic(domain),
              groupName: grabSemantic(mailbox.groupName)
            };
          }
          function grabSemantic(n) {
            return n !== null && n !== undefined ? n.semantic : null;
          }
          function simplifyResult(result) {
            var i;
            if (result && result.addresses) {
              for (i = 0; i < result.addresses.length; i += 1) {
                delete result.addresses[i].node;
              }
            }
            return result;
          }
          function oneResult(result) {
            if (!result) {
              return null;
            }
            if (!opts.partial && result.addresses.length > 1) {
              return null;
            }
            return result.addresses && result.addresses[0];
          } /////////////////////////////////////////////////////
          var parseString, pos, len, parsed, startProduction;
          opts = handleOpts(opts, {});
          if (opts === null) {
            return null;
          }
          parseString = opts.input;
          startProduction = {
            'address': address,
            'address-list': addressList,
            'angle-addr': angleAddr,
            'from': fromSpec,
            'group': group,
            'mailbox': mailbox,
            'mailbox-list': mailboxList,
            'reply-to': replyToSpec,
            'sender': senderSpec
          }[opts.startAt] || addressList;
          if (!opts.strict) {
            initialize();
            opts.strict = true;
            parsed = startProduction(parseString);
            if (opts.partial || !inStr()) {
              return giveResult(parsed);
            }
            opts.strict = false;
          }
          initialize();
          parsed = startProduction(parseString);
          if (!opts.partial && inStr()) {
            return null;
          }
          return giveResult(parsed);
        }
        function parseOneAddressSimple(opts) {
          return parse5322(handleOpts(opts, {
            oneResult: true,
            rfc6532: true,
            simple: true,
            startAt: 'address-list'
          }));
        }
        function parseAddressListSimple(opts) {
          return parse5322(handleOpts(opts, {
            rfc6532: true,
            simple: true,
            startAt: 'address-list'
          }));
        }
        function parseFromSimple(opts) {
          return parse5322(handleOpts(opts, {
            rfc6532: true,
            simple: true,
            startAt: 'from'
          }));
        }
        function parseSenderSimple(opts) {
          return parse5322(handleOpts(opts, {
            oneResult: true,
            rfc6532: true,
            simple: true,
            startAt: 'sender'
          }));
        }
        function parseReplyToSimple(opts) {
          return parse5322(handleOpts(opts, {
            rfc6532: true,
            simple: true,
            startAt: 'reply-to'
          }));
        }
        function handleOpts(opts, defs) {
          function isString(str) {
            return Object.prototype.toString.call(str) === '[object String]';
          }
          function isObject(o) {
            return o === Object(o);
          }
          function isNullUndef(o) {
            return o === null || o === undefined;
          }
          var defaults, o;
          if (isString(opts)) {
            opts = {
              input: opts
            };
          } else if (!isObject(opts)) {
            return null;
          }
          if (!isString(opts.input)) {
            return null;
          }
          if (!defs) {
            return null;
          }
          defaults = {
            oneResult: false,
            partial: false,
            rejectTLD: false,
            rfc6532: false,
            simple: false,
            startAt: 'address-list',
            strict: false
          };
          for (o in defaults) {
            if (isNullUndef(opts[o])) {
              opts[o] = !isNullUndef(defs[o]) ? defs[o] : defaults[o];
            }
          }
          return opts;
        }
        parse5322.parseOneAddress = parseOneAddressSimple;
        parse5322.parseAddressList = parseAddressListSimple;
        parse5322.parseFrom = parseFromSimple;
        parse5322.parseSender = parseSenderSimple;
        parse5322.parseReplyTo = parseReplyToSimple;
        if (typeof module !== 'undefined' && typeof module.exports !== 'undefined') {
          module.exports = parse5322;
        } else {
          global.emailAddresses = parse5322;
        }
      })(this);
    }, {}],
    35: [function (require, module, exports) {
      var hash = exports;
      hash.utils = require('./hash/utils');
      hash.common = require('./hash/common');
      hash.sha = require('./hash/sha');
      hash.ripemd = require('./hash/ripemd');
      hash.hmac = require('./hash/hmac'); // Proxy hash functions to the main object
      hash.sha1 = hash.sha.sha1;
      hash.sha256 = hash.sha.sha256;
      hash.sha224 = hash.sha.sha224;
      hash.sha384 = hash.sha.sha384;
      hash.sha512 = hash.sha.sha512;
      hash.ripemd160 = hash.ripemd.ripemd160;
    }, {
      "./hash/common": 36,
      "./hash/hmac": 37,
      "./hash/ripemd": 38,
      "./hash/sha": 39,
      "./hash/utils": 46
    }],
    36: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');
      var assert = require('minimalistic-assert');
      function BlockHash() {
        this.pending = null;
        this.pendingTotal = 0;
        this.blockSize = this.constructor.blockSize;
        this.outSize = this.constructor.outSize;
        this.hmacStrength = this.constructor.hmacStrength;
        this.padLength = this.constructor.padLength / 8;
        this.endian = 'big';
        this._delta8 = this.blockSize / 8;
        this._delta32 = this.blockSize / 32;
      }
      exports.BlockHash = BlockHash;
      BlockHash.prototype.update = function update(msg, enc) {
        // Convert message to array, pad it, and join into 32bit blocks
        msg = utils.toArray(msg, enc);
        if (!this.pending) this.pending = msg;else this.pending = this.pending.concat(msg);
        this.pendingTotal += msg.length; // Enough data, try updating
        if (this.pending.length >= this._delta8) {
          msg = this.pending; // Process pending data in blocks
          var r = msg.length % this._delta8;
          this.pending = msg.slice(msg.length - r, msg.length);
          if (this.pending.length === 0) this.pending = null;
          msg = utils.join32(msg, 0, msg.length - r, this.endian);
          for (var i = 0; i < msg.length; i += this._delta32) {
            this._update(msg, i, i + this._delta32);
          }
        }
        return this;
      };
      BlockHash.prototype.digest = function digest(enc) {
        this.update(this._pad());
        assert(this.pending === null);
        return this._digest(enc);
      };
      BlockHash.prototype._pad = function pad() {
        var len = this.pendingTotal;
        var bytes = this._delta8;
        var k = bytes - (len + this.padLength) % bytes;
        var res = new Array(k + this.padLength);
        res[0] = 0x80;
        for (var i = 1; i < k; i++) {
          res[i] = 0;
        } // Append length
        len <<= 3;
        if (this.endian === 'big') {
          for (var t = 8; t < this.padLength; t++) {
            res[i++] = 0;
          }
          res[i++] = 0;
          res[i++] = 0;
          res[i++] = 0;
          res[i++] = 0;
          res[i++] = len >>> 24 & 0xff;
          res[i++] = len >>> 16 & 0xff;
          res[i++] = len >>> 8 & 0xff;
          res[i++] = len & 0xff;
        } else {
          res[i++] = len & 0xff;
          res[i++] = len >>> 8 & 0xff;
          res[i++] = len >>> 16 & 0xff;
          res[i++] = len >>> 24 & 0xff;
          res[i++] = 0;
          res[i++] = 0;
          res[i++] = 0;
          res[i++] = 0;
          for (t = 8; t < this.padLength; t++) {
            res[i++] = 0;
          }
        }
        return res;
      };
    }, {
      "./utils": 46,
      "minimalistic-assert": 49
    }],
    37: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');
      var assert = require('minimalistic-assert');
      function Hmac(hash, key, enc) {
        if (!_instanceof(this, Hmac)) return new Hmac(hash, key, enc);
        this.Hash = hash;
        this.blockSize = hash.blockSize / 8;
        this.outSize = hash.outSize / 8;
        this.inner = null;
        this.outer = null;
        this._init(utils.toArray(key, enc));
      }
      module.exports = Hmac;
      Hmac.prototype._init = function init(key) {
        // Shorten key, if needed
        if (key.length > this.blockSize) key = new this.Hash().update(key).digest();
        assert(key.length <= this.blockSize); // Add padding to key
        for (var i = key.length; i < this.blockSize; i++) {
          key.push(0);
        }
        for (i = 0; i < key.length; i++) {
          key[i] ^= 0x36;
        }
        this.inner = new this.Hash().update(key); // 0x36 ^ 0x5c = 0x6a
        for (i = 0; i < key.length; i++) {
          key[i] ^= 0x6a;
        }
        this.outer = new this.Hash().update(key);
      };
      Hmac.prototype.update = function update(msg, enc) {
        this.inner.update(msg, enc);
        return this;
      };
      Hmac.prototype.digest = function digest(enc) {
        this.outer.update(this.inner.digest());
        return this.outer.digest(enc);
      };
    }, {
      "./utils": 46,
      "minimalistic-assert": 49
    }],
    38: [function (require, module, exports) {
      'use strict';

      var utils = require('./utils');
      var common = require('./common');
      var rotl32 = utils.rotl32;
      var sum32 = utils.sum32;
      var sum32_3 = utils.sum32_3;
      var sum32_4 = utils.sum32_4;
      var BlockHash = common.BlockHash;
      function RIPEMD160() {
        if (!_instanceof(this, RIPEMD160)) return new RIPEMD160();
        BlockHash.call(this);
        this.h = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];
        this.endian = 'little';
      }
      utils.inherits(RIPEMD160, BlockHash);
      exports.ripemd160 = RIPEMD160;
      RIPEMD160.blockSize = 512;
      RIPEMD160.outSize = 160;
      RIPEMD160.hmacStrength = 192;
      RIPEMD160.padLength = 64;
      RIPEMD160.prototype._update = function update(msg, start) {
        var A = this.h[0];
        var B = this.h[1];
        var C = this.h[2];
        var D = this.h[3];
        var E = this.h[4];
        var Ah = A;
        var Bh = B;
        var Ch = C;
        var Dh = D;
        var Eh = E;
        for (var j = 0; j < 80; j++) {
          var T = sum32(rotl32(sum32_4(A, f(j, B, C, D), msg[r[j] + start], K(j)), s[j]), E);
          A = E;
          E = D;
          D = rotl32(C, 10);
          C = B;
          B = T;
          T = sum32(rotl32(sum32_4(Ah, f(79 - j, Bh, Ch, Dh), msg[rh[j] + start], Kh(j)), sh[j]), Eh);
          Ah = Eh;
          Eh = Dh;
          Dh = rotl32(Ch, 10);
          Ch = Bh;
          Bh = T;
        }
        T = sum32_3(this.h[1], C, Dh);
        this.h[1] = sum32_3(this.h[2], D, Eh);
        this.h[2] = sum32_3(this.h[3], E, Ah);
        this.h[3] = sum32_3(this.h[4], A, Bh);
        this.h[4] = sum32_3(this.h[0], B, Ch);
        this.h[0] = T;
      };
      RIPEMD160.prototype._digest = function digest(enc) {
        if (enc === 'hex') return utils.toHex32(this.h, 'little');else return utils.split32(this.h, 'little');
      };
      function f(j, x, y, z) {
        if (j <= 15) return x ^ y ^ z;else if (j <= 31) return x & y | ~x & z;else if (j <= 47) return (x | ~y) ^ z;else if (j <= 63) return x & z | y & ~z;else return x ^ (y | ~z);
      }
      function K(j) {
        if (j <= 15) return 0x00000000;else if (j <= 31) return 0x5a827999;else if (j <= 47) return 0x6ed9eba1;else if (j <= 63) return 0x8f1bbcdc;else return 0xa953fd4e;
      }
      function Kh(j) {
        if (j <= 15) return 0x50a28be6;else if (j <= 31) return 0x5c4dd124;else if (j <= 47) return 0x6d703ef3;else if (j <= 63) return 0x7a6d76e9;else return 0x00000000;
      }
      var r = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 7, 4, 13, 1, 10, 6, 15, 3, 12, 0, 9, 5, 2, 14, 11, 8, 3, 10, 14, 4, 9, 15, 8, 1, 2, 7, 0, 6, 13, 11, 5, 12, 1, 9, 11, 10, 0, 8, 12, 4, 13, 3, 7, 15, 14, 5, 6, 2, 4, 0, 5, 9, 7, 12, 2, 10, 14, 1, 3, 8, 11, 6, 15, 13];
      var rh = [5, 14, 7, 0, 9, 2, 11, 4, 13, 6, 15, 8, 1, 10, 3, 12, 6, 11, 3, 7, 0, 13, 5, 10, 14, 15, 8, 12, 4, 9, 1, 2, 15, 5, 1, 3, 7, 14, 6, 9, 11, 8, 12, 2, 10, 0, 4, 13, 8, 6, 4, 1, 3, 11, 15, 0, 5, 12, 2, 13, 9, 7, 10, 14, 12, 15, 10, 4, 1, 5, 8, 7, 6, 2, 13, 14, 0, 3, 9, 11];
      var s = [11, 14, 15, 12, 5, 8, 7, 9, 11, 13, 14, 15, 6, 7, 9, 8, 7, 6, 8, 13, 11, 9, 7, 15, 7, 12, 15, 9, 11, 7, 13, 12, 11, 13, 6, 7, 14, 9, 13, 15, 14, 8, 13, 6, 5, 12, 7, 5, 11, 12, 14, 15, 14, 15, 9, 8, 9, 14, 5, 6, 8, 6, 5, 12, 9, 15, 5, 11, 6, 8, 13, 12, 5, 12, 13, 14, 11, 8, 5, 6];
      var sh = [8, 9, 9, 11, 13, 15, 15, 5, 7, 7, 8, 11, 14, 14, 12, 6, 9, 13, 15, 7, 12, 8, 9, 11, 7, 7, 12, 7, 6, 15, 13, 11, 9, 7, 15, 11, 8, 6, 6, 14, 12, 13, 5, 14, 13, 13, 7, 5, 15, 5, 8, 11, 14, 14, 6, 14, 6, 9, 12, 9, 12, 5, 15, 8, 8, 5, 12, 9, 12, 5, 14, 6, 8, 13, 6, 5, 15, 13, 11, 11];
    }, {
      "./common": 36,
      "./utils": 46
    }],
    39: [function (require, module, exports) {
      'use strict';

      exports.sha1 = require('./sha/1');
      exports.sha224 = require('./sha/224');
      exports.sha256 = require('./sha/256');
      exports.sha384 = require('./sha/384');
      exports.sha512 = require('./sha/512');
    }, {
      "./sha/1": 40,
      "./sha/224": 41,
      "./sha/256": 42,
      "./sha/384": 43,
      "./sha/512": 44
    }],
    40: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');
      var common = require('../common');
      var shaCommon = require('./common');
      var rotl32 = utils.rotl32;
      var sum32 = utils.sum32;
      var sum32_5 = utils.sum32_5;
      var ft_1 = shaCommon.ft_1;
      var BlockHash = common.BlockHash;
      var sha1_K = [0x5A827999, 0x6ED9EBA1, 0x8F1BBCDC, 0xCA62C1D6];
      function SHA1() {
        if (!_instanceof(this, SHA1)) return new SHA1();
        BlockHash.call(this);
        this.h = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];
        this.W = new Array(80);
      }
      utils.inherits(SHA1, BlockHash);
      module.exports = SHA1;
      SHA1.blockSize = 512;
      SHA1.outSize = 160;
      SHA1.hmacStrength = 80;
      SHA1.padLength = 64;
      SHA1.prototype._update = function _update(msg, start) {
        var W = this.W;
        for (var i = 0; i < 16; i++) {
          W[i] = msg[start + i];
        }
        for (; i < W.length; i++) {
          W[i] = rotl32(W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16], 1);
        }
        var a = this.h[0];
        var b = this.h[1];
        var c = this.h[2];
        var d = this.h[3];
        var e = this.h[4];
        for (i = 0; i < W.length; i++) {
          var s = ~~(i / 20);
          var t = sum32_5(rotl32(a, 5), ft_1(s, b, c, d), e, W[i], sha1_K[s]);
          e = d;
          d = c;
          c = rotl32(b, 30);
          b = a;
          a = t;
        }
        this.h[0] = sum32(this.h[0], a);
        this.h[1] = sum32(this.h[1], b);
        this.h[2] = sum32(this.h[2], c);
        this.h[3] = sum32(this.h[3], d);
        this.h[4] = sum32(this.h[4], e);
      };
      SHA1.prototype._digest = function digest(enc) {
        if (enc === 'hex') return utils.toHex32(this.h, 'big');else return utils.split32(this.h, 'big');
      };
    }, {
      "../common": 36,
      "../utils": 46,
      "./common": 45
    }],
    41: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');
      var SHA256 = require('./256');
      function SHA224() {
        if (!_instanceof(this, SHA224)) return new SHA224();
        SHA256.call(this);
        this.h = [0xc1059ed8, 0x367cd507, 0x3070dd17, 0xf70e5939, 0xffc00b31, 0x68581511, 0x64f98fa7, 0xbefa4fa4];
      }
      utils.inherits(SHA224, SHA256);
      module.exports = SHA224;
      SHA224.blockSize = 512;
      SHA224.outSize = 224;
      SHA224.hmacStrength = 192;
      SHA224.padLength = 64;
      SHA224.prototype._digest = function digest(enc) {
        // Just truncate output
        if (enc === 'hex') return utils.toHex32(this.h.slice(0, 7), 'big');else return utils.split32(this.h.slice(0, 7), 'big');
      };
    }, {
      "../utils": 46,
      "./256": 42
    }],
    42: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');
      var common = require('../common');
      var shaCommon = require('./common');
      var assert = require('minimalistic-assert');
      var sum32 = utils.sum32;
      var sum32_4 = utils.sum32_4;
      var sum32_5 = utils.sum32_5;
      var ch32 = shaCommon.ch32;
      var maj32 = shaCommon.maj32;
      var s0_256 = shaCommon.s0_256;
      var s1_256 = shaCommon.s1_256;
      var g0_256 = shaCommon.g0_256;
      var g1_256 = shaCommon.g1_256;
      var BlockHash = common.BlockHash;
      var sha256_K = [0x428a2f98, 0x71374491, 0xb5c0fbcf, 0xe9b5dba5, 0x3956c25b, 0x59f111f1, 0x923f82a4, 0xab1c5ed5, 0xd807aa98, 0x12835b01, 0x243185be, 0x550c7dc3, 0x72be5d74, 0x80deb1fe, 0x9bdc06a7, 0xc19bf174, 0xe49b69c1, 0xefbe4786, 0x0fc19dc6, 0x240ca1cc, 0x2de92c6f, 0x4a7484aa, 0x5cb0a9dc, 0x76f988da, 0x983e5152, 0xa831c66d, 0xb00327c8, 0xbf597fc7, 0xc6e00bf3, 0xd5a79147, 0x06ca6351, 0x14292967, 0x27b70a85, 0x2e1b2138, 0x4d2c6dfc, 0x53380d13, 0x650a7354, 0x766a0abb, 0x81c2c92e, 0x92722c85, 0xa2bfe8a1, 0xa81a664b, 0xc24b8b70, 0xc76c51a3, 0xd192e819, 0xd6990624, 0xf40e3585, 0x106aa070, 0x19a4c116, 0x1e376c08, 0x2748774c, 0x34b0bcb5, 0x391c0cb3, 0x4ed8aa4a, 0x5b9cca4f, 0x682e6ff3, 0x748f82ee, 0x78a5636f, 0x84c87814, 0x8cc70208, 0x90befffa, 0xa4506ceb, 0xbef9a3f7, 0xc67178f2];
      function SHA256() {
        if (!_instanceof(this, SHA256)) return new SHA256();
        BlockHash.call(this);
        this.h = [0x6a09e667, 0xbb67ae85, 0x3c6ef372, 0xa54ff53a, 0x510e527f, 0x9b05688c, 0x1f83d9ab, 0x5be0cd19];
        this.k = sha256_K;
        this.W = new Array(64);
      }
      utils.inherits(SHA256, BlockHash);
      module.exports = SHA256;
      SHA256.blockSize = 512;
      SHA256.outSize = 256;
      SHA256.hmacStrength = 192;
      SHA256.padLength = 64;
      SHA256.prototype._update = function _update(msg, start) {
        var W = this.W;
        for (var i = 0; i < 16; i++) {
          W[i] = msg[start + i];
        }
        for (; i < W.length; i++) {
          W[i] = sum32_4(g1_256(W[i - 2]), W[i - 7], g0_256(W[i - 15]), W[i - 16]);
        }
        var a = this.h[0];
        var b = this.h[1];
        var c = this.h[2];
        var d = this.h[3];
        var e = this.h[4];
        var f = this.h[5];
        var g = this.h[6];
        var h = this.h[7];
        assert(this.k.length === W.length);
        for (i = 0; i < W.length; i++) {
          var T1 = sum32_5(h, s1_256(e), ch32(e, f, g), this.k[i], W[i]);
          var T2 = sum32(s0_256(a), maj32(a, b, c));
          h = g;
          g = f;
          f = e;
          e = sum32(d, T1);
          d = c;
          c = b;
          b = a;
          a = sum32(T1, T2);
        }
        this.h[0] = sum32(this.h[0], a);
        this.h[1] = sum32(this.h[1], b);
        this.h[2] = sum32(this.h[2], c);
        this.h[3] = sum32(this.h[3], d);
        this.h[4] = sum32(this.h[4], e);
        this.h[5] = sum32(this.h[5], f);
        this.h[6] = sum32(this.h[6], g);
        this.h[7] = sum32(this.h[7], h);
      };
      SHA256.prototype._digest = function digest(enc) {
        if (enc === 'hex') return utils.toHex32(this.h, 'big');else return utils.split32(this.h, 'big');
      };
    }, {
      "../common": 36,
      "../utils": 46,
      "./common": 45,
      "minimalistic-assert": 49
    }],
    43: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');
      var SHA512 = require('./512');
      function SHA384() {
        if (!_instanceof(this, SHA384)) return new SHA384();
        SHA512.call(this);
        this.h = [0xcbbb9d5d, 0xc1059ed8, 0x629a292a, 0x367cd507, 0x9159015a, 0x3070dd17, 0x152fecd8, 0xf70e5939, 0x67332667, 0xffc00b31, 0x8eb44a87, 0x68581511, 0xdb0c2e0d, 0x64f98fa7, 0x47b5481d, 0xbefa4fa4];
      }
      utils.inherits(SHA384, SHA512);
      module.exports = SHA384;
      SHA384.blockSize = 1024;
      SHA384.outSize = 384;
      SHA384.hmacStrength = 192;
      SHA384.padLength = 128;
      SHA384.prototype._digest = function digest(enc) {
        if (enc === 'hex') return utils.toHex32(this.h.slice(0, 12), 'big');else return utils.split32(this.h.slice(0, 12), 'big');
      };
    }, {
      "../utils": 46,
      "./512": 44
    }],
    44: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');
      var common = require('../common');
      var assert = require('minimalistic-assert');
      var rotr64_hi = utils.rotr64_hi;
      var rotr64_lo = utils.rotr64_lo;
      var shr64_hi = utils.shr64_hi;
      var shr64_lo = utils.shr64_lo;
      var sum64 = utils.sum64;
      var sum64_hi = utils.sum64_hi;
      var sum64_lo = utils.sum64_lo;
      var sum64_4_hi = utils.sum64_4_hi;
      var sum64_4_lo = utils.sum64_4_lo;
      var sum64_5_hi = utils.sum64_5_hi;
      var sum64_5_lo = utils.sum64_5_lo;
      var BlockHash = common.BlockHash;
      var sha512_K = [0x428a2f98, 0xd728ae22, 0x71374491, 0x23ef65cd, 0xb5c0fbcf, 0xec4d3b2f, 0xe9b5dba5, 0x8189dbbc, 0x3956c25b, 0xf348b538, 0x59f111f1, 0xb605d019, 0x923f82a4, 0xaf194f9b, 0xab1c5ed5, 0xda6d8118, 0xd807aa98, 0xa3030242, 0x12835b01, 0x45706fbe, 0x243185be, 0x4ee4b28c, 0x550c7dc3, 0xd5ffb4e2, 0x72be5d74, 0xf27b896f, 0x80deb1fe, 0x3b1696b1, 0x9bdc06a7, 0x25c71235, 0xc19bf174, 0xcf692694, 0xe49b69c1, 0x9ef14ad2, 0xefbe4786, 0x384f25e3, 0x0fc19dc6, 0x8b8cd5b5, 0x240ca1cc, 0x77ac9c65, 0x2de92c6f, 0x592b0275, 0x4a7484aa, 0x6ea6e483, 0x5cb0a9dc, 0xbd41fbd4, 0x76f988da, 0x831153b5, 0x983e5152, 0xee66dfab, 0xa831c66d, 0x2db43210, 0xb00327c8, 0x98fb213f, 0xbf597fc7, 0xbeef0ee4, 0xc6e00bf3, 0x3da88fc2, 0xd5a79147, 0x930aa725, 0x06ca6351, 0xe003826f, 0x14292967, 0x0a0e6e70, 0x27b70a85, 0x46d22ffc, 0x2e1b2138, 0x5c26c926, 0x4d2c6dfc, 0x5ac42aed, 0x53380d13, 0x9d95b3df, 0x650a7354, 0x8baf63de, 0x766a0abb, 0x3c77b2a8, 0x81c2c92e, 0x47edaee6, 0x92722c85, 0x1482353b, 0xa2bfe8a1, 0x4cf10364, 0xa81a664b, 0xbc423001, 0xc24b8b70, 0xd0f89791, 0xc76c51a3, 0x0654be30, 0xd192e819, 0xd6ef5218, 0xd6990624, 0x5565a910, 0xf40e3585, 0x5771202a, 0x106aa070, 0x32bbd1b8, 0x19a4c116, 0xb8d2d0c8, 0x1e376c08, 0x5141ab53, 0x2748774c, 0xdf8eeb99, 0x34b0bcb5, 0xe19b48a8, 0x391c0cb3, 0xc5c95a63, 0x4ed8aa4a, 0xe3418acb, 0x5b9cca4f, 0x7763e373, 0x682e6ff3, 0xd6b2b8a3, 0x748f82ee, 0x5defb2fc, 0x78a5636f, 0x43172f60, 0x84c87814, 0xa1f0ab72, 0x8cc70208, 0x1a6439ec, 0x90befffa, 0x23631e28, 0xa4506ceb, 0xde82bde9, 0xbef9a3f7, 0xb2c67915, 0xc67178f2, 0xe372532b, 0xca273ece, 0xea26619c, 0xd186b8c7, 0x21c0c207, 0xeada7dd6, 0xcde0eb1e, 0xf57d4f7f, 0xee6ed178, 0x06f067aa, 0x72176fba, 0x0a637dc5, 0xa2c898a6, 0x113f9804, 0xbef90dae, 0x1b710b35, 0x131c471b, 0x28db77f5, 0x23047d84, 0x32caab7b, 0x40c72493, 0x3c9ebe0a, 0x15c9bebc, 0x431d67c4, 0x9c100d4c, 0x4cc5d4be, 0xcb3e42b6, 0x597f299c, 0xfc657e2a, 0x5fcb6fab, 0x3ad6faec, 0x6c44198c, 0x4a475817];
      function SHA512() {
        if (!_instanceof(this, SHA512)) return new SHA512();
        BlockHash.call(this);
        this.h = [0x6a09e667, 0xf3bcc908, 0xbb67ae85, 0x84caa73b, 0x3c6ef372, 0xfe94f82b, 0xa54ff53a, 0x5f1d36f1, 0x510e527f, 0xade682d1, 0x9b05688c, 0x2b3e6c1f, 0x1f83d9ab, 0xfb41bd6b, 0x5be0cd19, 0x137e2179];
        this.k = sha512_K;
        this.W = new Array(160);
      }
      utils.inherits(SHA512, BlockHash);
      module.exports = SHA512;
      SHA512.blockSize = 1024;
      SHA512.outSize = 512;
      SHA512.hmacStrength = 192;
      SHA512.padLength = 128;
      SHA512.prototype._prepareBlock = function _prepareBlock(msg, start) {
        var W = this.W; // 32 x 32bit words
        for (var i = 0; i < 32; i++) {
          W[i] = msg[start + i];
        }
        for (; i < W.length; i += 2) {
          var c0_hi = g1_512_hi(W[i - 4], W[i - 3]); // i - 2
          var c0_lo = g1_512_lo(W[i - 4], W[i - 3]);
          var c1_hi = W[i - 14]; // i - 7
          var c1_lo = W[i - 13];
          var c2_hi = g0_512_hi(W[i - 30], W[i - 29]); // i - 15
          var c2_lo = g0_512_lo(W[i - 30], W[i - 29]);
          var c3_hi = W[i - 32]; // i - 16
          var c3_lo = W[i - 31];
          W[i] = sum64_4_hi(c0_hi, c0_lo, c1_hi, c1_lo, c2_hi, c2_lo, c3_hi, c3_lo);
          W[i + 1] = sum64_4_lo(c0_hi, c0_lo, c1_hi, c1_lo, c2_hi, c2_lo, c3_hi, c3_lo);
        }
      };
      SHA512.prototype._update = function _update(msg, start) {
        this._prepareBlock(msg, start);
        var W = this.W;
        var ah = this.h[0];
        var al = this.h[1];
        var bh = this.h[2];
        var bl = this.h[3];
        var ch = this.h[4];
        var cl = this.h[5];
        var dh = this.h[6];
        var dl = this.h[7];
        var eh = this.h[8];
        var el = this.h[9];
        var fh = this.h[10];
        var fl = this.h[11];
        var gh = this.h[12];
        var gl = this.h[13];
        var hh = this.h[14];
        var hl = this.h[15];
        assert(this.k.length === W.length);
        for (var i = 0; i < W.length; i += 2) {
          var c0_hi = hh;
          var c0_lo = hl;
          var c1_hi = s1_512_hi(eh, el);
          var c1_lo = s1_512_lo(eh, el);
          var c2_hi = ch64_hi(eh, el, fh, fl, gh, gl);
          var c2_lo = ch64_lo(eh, el, fh, fl, gh, gl);
          var c3_hi = this.k[i];
          var c3_lo = this.k[i + 1];
          var c4_hi = W[i];
          var c4_lo = W[i + 1];
          var T1_hi = sum64_5_hi(c0_hi, c0_lo, c1_hi, c1_lo, c2_hi, c2_lo, c3_hi, c3_lo, c4_hi, c4_lo);
          var T1_lo = sum64_5_lo(c0_hi, c0_lo, c1_hi, c1_lo, c2_hi, c2_lo, c3_hi, c3_lo, c4_hi, c4_lo);
          c0_hi = s0_512_hi(ah, al);
          c0_lo = s0_512_lo(ah, al);
          c1_hi = maj64_hi(ah, al, bh, bl, ch, cl);
          c1_lo = maj64_lo(ah, al, bh, bl, ch, cl);
          var T2_hi = sum64_hi(c0_hi, c0_lo, c1_hi, c1_lo);
          var T2_lo = sum64_lo(c0_hi, c0_lo, c1_hi, c1_lo);
          hh = gh;
          hl = gl;
          gh = fh;
          gl = fl;
          fh = eh;
          fl = el;
          eh = sum64_hi(dh, dl, T1_hi, T1_lo);
          el = sum64_lo(dl, dl, T1_hi, T1_lo);
          dh = ch;
          dl = cl;
          ch = bh;
          cl = bl;
          bh = ah;
          bl = al;
          ah = sum64_hi(T1_hi, T1_lo, T2_hi, T2_lo);
          al = sum64_lo(T1_hi, T1_lo, T2_hi, T2_lo);
        }
        sum64(this.h, 0, ah, al);
        sum64(this.h, 2, bh, bl);
        sum64(this.h, 4, ch, cl);
        sum64(this.h, 6, dh, dl);
        sum64(this.h, 8, eh, el);
        sum64(this.h, 10, fh, fl);
        sum64(this.h, 12, gh, gl);
        sum64(this.h, 14, hh, hl);
      };
      SHA512.prototype._digest = function digest(enc) {
        if (enc === 'hex') return utils.toHex32(this.h, 'big');else return utils.split32(this.h, 'big');
      };
      function ch64_hi(xh, xl, yh, yl, zh) {
        var r = xh & yh ^ ~xh & zh;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function ch64_lo(xh, xl, yh, yl, zh, zl) {
        var r = xl & yl ^ ~xl & zl;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function maj64_hi(xh, xl, yh, yl, zh) {
        var r = xh & yh ^ xh & zh ^ yh & zh;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function maj64_lo(xh, xl, yh, yl, zh, zl) {
        var r = xl & yl ^ xl & zl ^ yl & zl;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function s0_512_hi(xh, xl) {
        var c0_hi = rotr64_hi(xh, xl, 28);
        var c1_hi = rotr64_hi(xl, xh, 2); // 34
        var c2_hi = rotr64_hi(xl, xh, 7); // 39
        var r = c0_hi ^ c1_hi ^ c2_hi;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function s0_512_lo(xh, xl) {
        var c0_lo = rotr64_lo(xh, xl, 28);
        var c1_lo = rotr64_lo(xl, xh, 2); // 34
        var c2_lo = rotr64_lo(xl, xh, 7); // 39
        var r = c0_lo ^ c1_lo ^ c2_lo;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function s1_512_hi(xh, xl) {
        var c0_hi = rotr64_hi(xh, xl, 14);
        var c1_hi = rotr64_hi(xh, xl, 18);
        var c2_hi = rotr64_hi(xl, xh, 9); // 41
        var r = c0_hi ^ c1_hi ^ c2_hi;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function s1_512_lo(xh, xl) {
        var c0_lo = rotr64_lo(xh, xl, 14);
        var c1_lo = rotr64_lo(xh, xl, 18);
        var c2_lo = rotr64_lo(xl, xh, 9); // 41
        var r = c0_lo ^ c1_lo ^ c2_lo;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function g0_512_hi(xh, xl) {
        var c0_hi = rotr64_hi(xh, xl, 1);
        var c1_hi = rotr64_hi(xh, xl, 8);
        var c2_hi = shr64_hi(xh, xl, 7);
        var r = c0_hi ^ c1_hi ^ c2_hi;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function g0_512_lo(xh, xl) {
        var c0_lo = rotr64_lo(xh, xl, 1);
        var c1_lo = rotr64_lo(xh, xl, 8);
        var c2_lo = shr64_lo(xh, xl, 7);
        var r = c0_lo ^ c1_lo ^ c2_lo;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function g1_512_hi(xh, xl) {
        var c0_hi = rotr64_hi(xh, xl, 19);
        var c1_hi = rotr64_hi(xl, xh, 29); // 61
        var c2_hi = shr64_hi(xh, xl, 6);
        var r = c0_hi ^ c1_hi ^ c2_hi;
        if (r < 0) r += 0x100000000;
        return r;
      }
      function g1_512_lo(xh, xl) {
        var c0_lo = rotr64_lo(xh, xl, 19);
        var c1_lo = rotr64_lo(xl, xh, 29); // 61
        var c2_lo = shr64_lo(xh, xl, 6);
        var r = c0_lo ^ c1_lo ^ c2_lo;
        if (r < 0) r += 0x100000000;
        return r;
      }
    }, {
      "../common": 36,
      "../utils": 46,
      "minimalistic-assert": 49
    }],
    45: [function (require, module, exports) {
      'use strict';

      var utils = require('../utils');
      var rotr32 = utils.rotr32;
      function ft_1(s, x, y, z) {
        if (s === 0) return ch32(x, y, z);
        if (s === 1 || s === 3) return p32(x, y, z);
        if (s === 2) return maj32(x, y, z);
      }
      exports.ft_1 = ft_1;
      function ch32(x, y, z) {
        return x & y ^ ~x & z;
      }
      exports.ch32 = ch32;
      function maj32(x, y, z) {
        return x & y ^ x & z ^ y & z;
      }
      exports.maj32 = maj32;
      function p32(x, y, z) {
        return x ^ y ^ z;
      }
      exports.p32 = p32;
      function s0_256(x) {
        return rotr32(x, 2) ^ rotr32(x, 13) ^ rotr32(x, 22);
      }
      exports.s0_256 = s0_256;
      function s1_256(x) {
        return rotr32(x, 6) ^ rotr32(x, 11) ^ rotr32(x, 25);
      }
      exports.s1_256 = s1_256;
      function g0_256(x) {
        return rotr32(x, 7) ^ rotr32(x, 18) ^ x >>> 3;
      }
      exports.g0_256 = g0_256;
      function g1_256(x) {
        return rotr32(x, 17) ^ rotr32(x, 19) ^ x >>> 10;
      }
      exports.g1_256 = g1_256;
    }, {
      "../utils": 46
    }],
    46: [function (require, module, exports) {
      'use strict';

      var assert = require('minimalistic-assert');
      var inherits = require('inherits');
      exports.inherits = inherits;
      function toArray(msg, enc) {
        if (Array.isArray(msg)) return msg.slice();
        if (!msg) return [];
        var res = [];
        if (typeof msg === 'string') {
          if (!enc) {
            for (var i = 0; i < msg.length; i++) {
              var c = msg.charCodeAt(i);
              var hi = c >> 8;
              var lo = c & 0xff;
              if (hi) res.push(hi, lo);else res.push(lo);
            }
          } else if (enc === 'hex') {
            msg = msg.replace(/[^a-z0-9]+/ig, '');
            if (msg.length % 2 !== 0) msg = '0' + msg;
            for (i = 0; i < msg.length; i += 2) {
              res.push(parseInt(msg[i] + msg[i + 1], 16));
            }
          }
        } else {
          for (i = 0; i < msg.length; i++) {
            res[i] = msg[i] | 0;
          }
        }
        return res;
      }
      exports.toArray = toArray;
      function toHex(msg) {
        var res = '';
        for (var i = 0; i < msg.length; i++) {
          res += zero2(msg[i].toString(16));
        }
        return res;
      }
      exports.toHex = toHex;
      function htonl(w) {
        var res = w >>> 24 | w >>> 8 & 0xff00 | w << 8 & 0xff0000 | (w & 0xff) << 24;
        return res >>> 0;
      }
      exports.htonl = htonl;
      function toHex32(msg, endian) {
        var res = '';
        for (var i = 0; i < msg.length; i++) {
          var w = msg[i];
          if (endian === 'little') w = htonl(w);
          res += zero8(w.toString(16));
        }
        return res;
      }
      exports.toHex32 = toHex32;
      function zero2(word) {
        if (word.length === 1) return '0' + word;else return word;
      }
      exports.zero2 = zero2;
      function zero8(word) {
        if (word.length === 7) return '0' + word;else if (word.length === 6) return '00' + word;else if (word.length === 5) return '000' + word;else if (word.length === 4) return '0000' + word;else if (word.length === 3) return '00000' + word;else if (word.length === 2) return '000000' + word;else if (word.length === 1) return '0000000' + word;else return word;
      }
      exports.zero8 = zero8;
      function join32(msg, start, end, endian) {
        var len = end - start;
        assert(len % 4 === 0);
        var res = new Array(len / 4);
        for (var i = 0, k = start; i < res.length; i++, k += 4) {
          var w;
          if (endian === 'big') w = msg[k] << 24 | msg[k + 1] << 16 | msg[k + 2] << 8 | msg[k + 3];else w = msg[k + 3] << 24 | msg[k + 2] << 16 | msg[k + 1] << 8 | msg[k];
          res[i] = w >>> 0;
        }
        return res;
      }
      exports.join32 = join32;
      function split32(msg, endian) {
        var res = new Array(msg.length * 4);
        for (var i = 0, k = 0; i < msg.length; i++, k += 4) {
          var m = msg[i];
          if (endian === 'big') {
            res[k] = m >>> 24;
            res[k + 1] = m >>> 16 & 0xff;
            res[k + 2] = m >>> 8 & 0xff;
            res[k + 3] = m & 0xff;
          } else {
            res[k + 3] = m >>> 24;
            res[k + 2] = m >>> 16 & 0xff;
            res[k + 1] = m >>> 8 & 0xff;
            res[k] = m & 0xff;
          }
        }
        return res;
      }
      exports.split32 = split32;
      function rotr32(w, b) {
        return w >>> b | w << 32 - b;
      }
      exports.rotr32 = rotr32;
      function rotl32(w, b) {
        return w << b | w >>> 32 - b;
      }
      exports.rotl32 = rotl32;
      function sum32(a, b) {
        return a + b >>> 0;
      }
      exports.sum32 = sum32;
      function sum32_3(a, b, c) {
        return a + b + c >>> 0;
      }
      exports.sum32_3 = sum32_3;
      function sum32_4(a, b, c, d) {
        return a + b + c + d >>> 0;
      }
      exports.sum32_4 = sum32_4;
      function sum32_5(a, b, c, d, e) {
        return a + b + c + d + e >>> 0;
      }
      exports.sum32_5 = sum32_5;
      function sum64(buf, pos, ah, al) {
        var bh = buf[pos];
        var bl = buf[pos + 1];
        var lo = al + bl >>> 0;
        var hi = (lo < al ? 1 : 0) + ah + bh;
        buf[pos] = hi >>> 0;
        buf[pos + 1] = lo;
      }
      exports.sum64 = sum64;
      function sum64_hi(ah, al, bh, bl) {
        var lo = al + bl >>> 0;
        var hi = (lo < al ? 1 : 0) + ah + bh;
        return hi >>> 0;
      }
      exports.sum64_hi = sum64_hi;
      function sum64_lo(ah, al, bh, bl) {
        var lo = al + bl;
        return lo >>> 0;
      }
      exports.sum64_lo = sum64_lo;
      function sum64_4_hi(ah, al, bh, bl, ch, cl, dh, dl) {
        var carry = 0;
        var lo = al;
        lo = lo + bl >>> 0;
        carry += lo < al ? 1 : 0;
        lo = lo + cl >>> 0;
        carry += lo < cl ? 1 : 0;
        lo = lo + dl >>> 0;
        carry += lo < dl ? 1 : 0;
        var hi = ah + bh + ch + dh + carry;
        return hi >>> 0;
      }
      exports.sum64_4_hi = sum64_4_hi;
      function sum64_4_lo(ah, al, bh, bl, ch, cl, dh, dl) {
        var lo = al + bl + cl + dl;
        return lo >>> 0;
      }
      exports.sum64_4_lo = sum64_4_lo;
      function sum64_5_hi(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
        var carry = 0;
        var lo = al;
        lo = lo + bl >>> 0;
        carry += lo < al ? 1 : 0;
        lo = lo + cl >>> 0;
        carry += lo < cl ? 1 : 0;
        lo = lo + dl >>> 0;
        carry += lo < dl ? 1 : 0;
        lo = lo + el >>> 0;
        carry += lo < el ? 1 : 0;
        var hi = ah + bh + ch + dh + eh + carry;
        return hi >>> 0;
      }
      exports.sum64_5_hi = sum64_5_hi;
      function sum64_5_lo(ah, al, bh, bl, ch, cl, dh, dl, eh, el) {
        var lo = al + bl + cl + dl + el;
        return lo >>> 0;
      }
      exports.sum64_5_lo = sum64_5_lo;
      function rotr64_hi(ah, al, num) {
        var r = al << 32 - num | ah >>> num;
        return r >>> 0;
      }
      exports.rotr64_hi = rotr64_hi;
      function rotr64_lo(ah, al, num) {
        var r = ah << 32 - num | al >>> num;
        return r >>> 0;
      }
      exports.rotr64_lo = rotr64_lo;
      function shr64_hi(ah, al, num) {
        return ah >>> num;
      }
      exports.shr64_hi = shr64_hi;
      function shr64_lo(ah, al, num) {
        var r = ah << 32 - num | al >>> num;
        return r >>> 0;
      }
      exports.shr64_lo = shr64_lo;
    }, {
      "inherits": 48,
      "minimalistic-assert": 49
    }],
    47: [function (require, module, exports) {
      'use strict';

      var hash = require('hash.js');
      var utils = require('minimalistic-crypto-utils');
      var assert = require('minimalistic-assert');
      function HmacDRBG(options) {
        if (!_instanceof(this, HmacDRBG)) return new HmacDRBG(options);
        this.hash = options.hash;
        this.predResist = !!options.predResist;
        this.outLen = this.hash.outSize;
        this.minEntropy = options.minEntropy || this.hash.hmacStrength;
        this._reseed = null;
        this.reseedInterval = null;
        this.K = null;
        this.V = null;
        var entropy = utils.toArray(options.entropy, options.entropyEnc || 'hex');
        var nonce = utils.toArray(options.nonce, options.nonceEnc || 'hex');
        var pers = utils.toArray(options.pers, options.persEnc || 'hex');
        assert(entropy.length >= this.minEntropy / 8, 'Not enough entropy. Minimum is: ' + this.minEntropy + ' bits');
        this._init(entropy, nonce, pers);
      }
      module.exports = HmacDRBG;
      HmacDRBG.prototype._init = function init(entropy, nonce, pers) {
        var seed = entropy.concat(nonce).concat(pers);
        this.K = new Array(this.outLen / 8);
        this.V = new Array(this.outLen / 8);
        for (var i = 0; i < this.V.length; i++) {
          this.K[i] = 0x00;
          this.V[i] = 0x01;
        }
        this._update(seed);
        this._reseed = 1;
        this.reseedInterval = 0x1000000000000; // 2^48
      };
      HmacDRBG.prototype._hmac = function hmac() {
        return new hash.hmac(this.hash, this.K);
      };
      HmacDRBG.prototype._update = function update(seed) {
        var kmac = this._hmac().update(this.V).update([0x00]);
        if (seed) kmac = kmac.update(seed);
        this.K = kmac.digest();
        this.V = this._hmac().update(this.V).digest();
        if (!seed) return;
        this.K = this._hmac().update(this.V).update([0x01]).update(seed).digest();
        this.V = this._hmac().update(this.V).digest();
      };
      HmacDRBG.prototype.reseed = function reseed(entropy, entropyEnc, add, addEnc) {
        // Optional entropy enc
        if (typeof entropyEnc !== 'string') {
          addEnc = add;
          add = entropyEnc;
          entropyEnc = null;
        }
        entropy = utils.toArray(entropy, entropyEnc);
        add = utils.toArray(add, addEnc);
        assert(entropy.length >= this.minEntropy / 8, 'Not enough entropy. Minimum is: ' + this.minEntropy + ' bits');
        this._update(entropy.concat(add || []));
        this._reseed = 1;
      };
      HmacDRBG.prototype.generate = function generate(len, enc, add, addEnc) {
        if (this._reseed > this.reseedInterval) throw new Error('Reseed is required'); // Optional encoding
        if (typeof enc !== 'string') {
          addEnc = add;
          add = enc;
          enc = null;
        } // Optional additional data
        if (add) {
          add = utils.toArray(add, addEnc || 'hex');
          this._update(add);
        }
        var temp = [];
        while (temp.length < len) {
          this.V = this._hmac().update(this.V).digest();
          temp = temp.concat(this.V);
        }
        var res = temp.slice(0, len);
        this._update(add);
        this._reseed++;
        return utils.encode(res, enc);
      };
    }, {
      "hash.js": 35,
      "minimalistic-assert": 49,
      "minimalistic-crypto-utils": 50
    }],
    48: [function (require, module, exports) {
      if (typeof Object.create === 'function') {
        // implementation from standard node.js 'util' module
        module.exports = function inherits(ctor, superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        };
      } else {
        // old school shim for old browsers
        module.exports = function inherits(ctor, superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function TempCtor() {};
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        };
      }
    }, {}],
    49: [function (require, module, exports) {
      module.exports = assert;
      function assert(val, msg) {
        if (!val) throw new Error(msg || 'Assertion failed');
      }
      assert.equal = function assertEqual(l, r, msg) {
        if (l != r) throw new Error(msg || 'Assertion failed: ' + l + ' != ' + r);
      };
    }, {}],
    50: [function (require, module, exports) {
      'use strict';

      var utils = exports;
      function toArray(msg, enc) {
        if (Array.isArray(msg)) return msg.slice();
        if (!msg) return [];
        var res = [];
        if (typeof msg !== 'string') {
          for (var i = 0; i < msg.length; i++) {
            res[i] = msg[i] | 0;
          }
          return res;
        }
        if (enc === 'hex') {
          msg = msg.replace(/[^a-z0-9]+/ig, '');
          if (msg.length % 2 !== 0) msg = '0' + msg;
          for (var i = 0; i < msg.length; i += 2) {
            res.push(parseInt(msg[i] + msg[i + 1], 16));
          }
        } else {
          for (var i = 0; i < msg.length; i++) {
            var c = msg.charCodeAt(i);
            var hi = c >> 8;
            var lo = c & 0xff;
            if (hi) res.push(hi, lo);else res.push(lo);
          }
        }
        return res;
      }
      utils.toArray = toArray;
      function zero2(word) {
        if (word.length === 1) return '0' + word;else return word;
      }
      utils.zero2 = zero2;
      function toHex(msg) {
        var res = '';
        for (var i = 0; i < msg.length; i++) {
          res += zero2(msg[i].toString(16));
        }
        return res;
      }
      utils.toHex = toHex;
      utils.encode = function encode(arr, enc) {
        if (enc === 'hex') return toHex(arr);else return arr;
      };
    }, {}],
    51: [function (require, module, exports) {
      // Top level file is just a mixin of submodules & constants
      'use strict';

      var assign = require('./lib/utils/common').assign;
      var deflate = require('./lib/deflate');
      var inflate = require('./lib/inflate');
      var constants = require('./lib/zlib/constants');
      var pako = {};
      assign(pako, deflate, inflate, constants);
      module.exports = pako;
    }, {
      "./lib/deflate": 52,
      "./lib/inflate": 53,
      "./lib/utils/common": 54,
      "./lib/zlib/constants": 57
    }],
    52: [function (require, module, exports) {
      'use strict';

      var zlib_deflate = require('./zlib/deflate');
      var utils = require('./utils/common');
      var strings = require('./utils/strings');
      var msg = require('./zlib/messages');
      var ZStream = require('./zlib/zstream');
      var toString = Object.prototype.toString; /* Public constants ==========================================================*/ /* ===========================================================================*/
      var Z_NO_FLUSH = 0;
      var Z_FINISH = 4;
      var Z_OK = 0;
      var Z_STREAM_END = 1;
      var Z_SYNC_FLUSH = 2;
      var Z_DEFAULT_COMPRESSION = -1;
      var Z_DEFAULT_STRATEGY = 0;
      var Z_DEFLATED = 8; /* ===========================================================================*/ /**
                                                                                                           * class Deflate
                                                                                                           *
                                                                                                           * Generic JS-style wrapper for zlib calls. If you don't need
                                                                                                           * streaming behaviour - use more simple functions: [[deflate]],
                                                                                                           * [[deflateRaw]] and [[gzip]].
                                                                                                           **/ /* internal
                                                                                                               * Deflate.chunks -> Array
                                                                                                               *
                                                                                                               * Chunks of output data, if [[Deflate#onData]] not overridden.
                                                                                                               **/ /**
                                                                                                                   * Deflate.result -> Uint8Array|Array
                                                                                                                   *
                                                                                                                   * Compressed result, generated by default [[Deflate#onData]]
                                                                                                                   * and [[Deflate#onEnd]] handlers. Filled after you push last chunk
                                                                                                                   * (call [[Deflate#push]] with `Z_FINISH` / `true` param)  or if you
                                                                                                                   * push a chunk with explicit flush (call [[Deflate#push]] with
                                                                                                                   * `Z_SYNC_FLUSH` param).
                                                                                                                   **/ /**
                                                                                                                       * Deflate.err -> Number
                                                                                                                       *
                                                                                                                       * Error code after deflate finished. 0 (Z_OK) on success.
                                                                                                                       * You will not need it in real life, because deflate errors
                                                                                                                       * are possible only on wrong options or bad `onData` / `onEnd`
                                                                                                                       * custom handlers.
                                                                                                                       **/ /**
                                                                                                                           * Deflate.msg -> String
                                                                                                                           *
                                                                                                                           * Error message, if [[Deflate.err]] != 0
                                                                                                                           **/ /**
                                                                                                                               * new Deflate(options)
                                                                                                                               * - options (Object): zlib deflate options.
                                                                                                                               *
                                                                                                                               * Creates new deflator instance with specified params. Throws exception
                                                                                                                               * on bad params. Supported options:
                                                                                                                               *
                                                                                                                               * - `level`
                                                                                                                               * - `windowBits`
                                                                                                                               * - `memLevel`
                                                                                                                               * - `strategy`
                                                                                                                               * - `dictionary`
                                                                                                                               *
                                                                                                                               * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
                                                                                                                               * for more information on these.
                                                                                                                               *
                                                                                                                               * Additional options, for internal needs:
                                                                                                                               *
                                                                                                                               * - `chunkSize` - size of generated data chunks (16K by default)
                                                                                                                               * - `raw` (Boolean) - do raw deflate
                                                                                                                               * - `gzip` (Boolean) - create gzip wrapper
                                                                                                                               * - `to` (String) - if equal to 'string', then result will be "binary string"
                                                                                                                               *    (each char code [0..255])
                                                                                                                               * - `header` (Object) - custom header for gzip
                                                                                                                               *   - `text` (Boolean) - true if compressed data believed to be text
                                                                                                                               *   - `time` (Number) - modification time, unix timestamp
                                                                                                                               *   - `os` (Number) - operation system code
                                                                                                                               *   - `extra` (Array) - array of bytes with extra data (max 65536)
                                                                                                                               *   - `name` (String) - file name (binary string)
                                                                                                                               *   - `comment` (String) - comment (binary string)
                                                                                                                               *   - `hcrc` (Boolean) - true if header crc should be added
                                                                                                                               *
                                                                                                                               * ##### Example:
                                                                                                                               *
                                                                                                                               * ```javascript
                                                                                                                               * var pako = require('pako')
                                                                                                                               *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])
                                                                                                                               *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);
                                                                                                                               *
                                                                                                                               * var deflate = new pako.Deflate({ level: 3});
                                                                                                                               *
                                                                                                                               * deflate.push(chunk1, false);
                                                                                                                               * deflate.push(chunk2, true);  // true -> last chunk
                                                                                                                               *
                                                                                                                               * if (deflate.err) { throw new Error(deflate.err); }
                                                                                                                               *
                                                                                                                               * console.log(deflate.result);
                                                                                                                               * ```
                                                                                                                               **/
      function Deflate(options) {
        if (!_instanceof(this, Deflate)) return new Deflate(options);
        this.options = utils.assign({
          level: Z_DEFAULT_COMPRESSION,
          method: Z_DEFLATED,
          chunkSize: 16384,
          windowBits: 15,
          memLevel: 8,
          strategy: Z_DEFAULT_STRATEGY,
          to: ''
        }, options || {});
        var opt = this.options;
        if (opt.raw && opt.windowBits > 0) {
          opt.windowBits = -opt.windowBits;
        } else if (opt.gzip && opt.windowBits > 0 && opt.windowBits < 16) {
          opt.windowBits += 16;
        }
        this.err = 0; // error code, if happens (0 = Z_OK)
        this.msg = ''; // error message
        this.ended = false; // used to avoid multiple onEnd() calls
        this.chunks = []; // chunks of compressed data
        this.strm = new ZStream();
        this.strm.avail_out = 0;
        var status = zlib_deflate.deflateInit2(this.strm, opt.level, opt.method, opt.windowBits, opt.memLevel, opt.strategy);
        if (status !== Z_OK) {
          throw new Error(msg[status]);
        }
        if (opt.header) {
          zlib_deflate.deflateSetHeader(this.strm, opt.header);
        }
        if (opt.dictionary) {
          var dict; // Convert data if needed
          if (typeof opt.dictionary === 'string') {
            // If we need to compress text, change encoding to utf8.
            dict = strings.string2buf(opt.dictionary);
          } else if (toString.call(opt.dictionary) === '[object ArrayBuffer]') {
            dict = new Uint8Array(opt.dictionary);
          } else {
            dict = opt.dictionary;
          }
          status = zlib_deflate.deflateSetDictionary(this.strm, dict);
          if (status !== Z_OK) {
            throw new Error(msg[status]);
          }
          this._dict_set = true;
        }
      } /**
        * Deflate#push(data[, mode]) -> Boolean
        * - data (Uint8Array|Array|ArrayBuffer|String): input data. Strings will be
        *   converted to utf8 byte sequence.
        * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
        *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.
        *
        * Sends input data to deflate pipe, generating [[Deflate#onData]] calls with
        * new compressed chunks. Returns `true` on success. The last data block must have
        * mode Z_FINISH (or `true`). That will flush internal pending buffers and call
        * [[Deflate#onEnd]]. For interim explicit flushes (without ending the stream) you
        * can use mode Z_SYNC_FLUSH, keeping the compression context.
        *
        * On fail call [[Deflate#onEnd]] with error code and return false.
        *
        * We strongly recommend to use `Uint8Array` on input for best speed (output
        * array format is detected automatically). Also, don't skip last param and always
        * use the same type in your code (boolean or number). That will improve JS speed.
        *
        * For regular `Array`-s make sure all elements are [0..255].
        *
        * ##### Example
        *
        * ```javascript
        * push(chunk, false); // push one of data chunks
        * ...
        * push(chunk, true);  // push last chunk
        * ```
        **/
      Deflate.prototype.push = function (data, mode) {
        var strm = this.strm;
        var chunkSize = this.options.chunkSize;
        var status, _mode;
        if (this.ended) {
          return false;
        }
        _mode = mode === ~~mode ? mode : mode === true ? Z_FINISH : Z_NO_FLUSH; // Convert data if needed
        if (typeof data === 'string') {
          // If we need to compress text, change encoding to utf8.
          strm.input = strings.string2buf(data);
        } else if (toString.call(data) === '[object ArrayBuffer]') {
          strm.input = new Uint8Array(data);
        } else {
          strm.input = data;
        }
        strm.next_in = 0;
        strm.avail_in = strm.input.length;
        do {
          if (strm.avail_out === 0) {
            strm.output = new utils.Buf8(chunkSize);
            strm.next_out = 0;
            strm.avail_out = chunkSize;
          }
          status = zlib_deflate.deflate(strm, _mode); /* no bad return value */
          if (status !== Z_STREAM_END && status !== Z_OK) {
            this.onEnd(status);
            this.ended = true;
            return false;
          }
          if (strm.avail_out === 0 || strm.avail_in === 0 && (_mode === Z_FINISH || _mode === Z_SYNC_FLUSH)) {
            if (this.options.to === 'string') {
              this.onData(strings.buf2binstring(utils.shrinkBuf(strm.output, strm.next_out)));
            } else {
              this.onData(utils.shrinkBuf(strm.output, strm.next_out));
            }
          }
        } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== Z_STREAM_END); // Finalize on the last chunk.
        if (_mode === Z_FINISH) {
          status = zlib_deflate.deflateEnd(this.strm);
          this.onEnd(status);
          this.ended = true;
          return status === Z_OK;
        } // callback interim results if Z_SYNC_FLUSH.
        if (_mode === Z_SYNC_FLUSH) {
          this.onEnd(Z_OK);
          strm.avail_out = 0;
          return true;
        }
        return true;
      }; /**
         * Deflate#onData(chunk) -> Void
         * - chunk (Uint8Array|Array|String): output data. Type of array depends
         *   on js engine support. When string output requested, each chunk
         *   will be string.
         *
         * By default, stores data blocks in `chunks[]` property and glue
         * those in `onEnd`. Override this handler, if you need another behaviour.
         **/
      Deflate.prototype.onData = function (chunk) {
        this.chunks.push(chunk);
      }; /**
         * Deflate#onEnd(status) -> Void
         * - status (Number): deflate status. 0 (Z_OK) on success,
         *   other if not.
         *
         * Called once after you tell deflate that the input stream is
         * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)
         * or if an error happened. By default - join collected chunks,
         * free memory and fill `results` / `err` properties.
         **/
      Deflate.prototype.onEnd = function (status) {
        // On success - join
        if (status === Z_OK) {
          if (this.options.to === 'string') {
            this.result = this.chunks.join('');
          } else {
            this.result = utils.flattenChunks(this.chunks);
          }
        }
        this.chunks = [];
        this.err = status;
        this.msg = this.strm.msg;
      }; /**
         * deflate(data[, options]) -> Uint8Array|Array|String
         * - data (Uint8Array|Array|String): input data to compress.
         * - options (Object): zlib deflate options.
         *
         * Compress `data` with deflate algorithm and `options`.
         *
         * Supported options are:
         *
         * - level
         * - windowBits
         * - memLevel
         * - strategy
         * - dictionary
         *
         * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
         * for more information on these.
         *
         * Sugar (options):
         *
         * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
         *   negative windowBits implicitly.
         * - `to` (String) - if equal to 'string', then result will be "binary string"
         *    (each char code [0..255])
         *
         * ##### Example:
         *
         * ```javascript
         * var pako = require('pako')
         *   , data = Uint8Array([1,2,3,4,5,6,7,8,9]);
         *
         * console.log(pako.deflate(data));
         * ```
         **/
      function deflate(input, options) {
        var deflator = new Deflate(options);
        deflator.push(input, true); // That will never happens, if you don't cheat with options :)
        if (deflator.err) {
          throw deflator.msg || msg[deflator.err];
        }
        return deflator.result;
      } /**
        * deflateRaw(data[, options]) -> Uint8Array|Array|String
        * - data (Uint8Array|Array|String): input data to compress.
        * - options (Object): zlib deflate options.
        *
        * The same as [[deflate]], but creates raw data, without wrapper
        * (header and adler32 crc).
        **/
      function deflateRaw(input, options) {
        options = options || {};
        options.raw = true;
        return deflate(input, options);
      } /**
        * gzip(data[, options]) -> Uint8Array|Array|String
        * - data (Uint8Array|Array|String): input data to compress.
        * - options (Object): zlib deflate options.
        *
        * The same as [[deflate]], but create gzip wrapper instead of
        * deflate one.
        **/
      function gzip(input, options) {
        options = options || {};
        options.gzip = true;
        return deflate(input, options);
      }
      exports.Deflate = Deflate;
      exports.deflate = deflate;
      exports.deflateRaw = deflateRaw;
      exports.gzip = gzip;
    }, {
      "./utils/common": 54,
      "./utils/strings": 55,
      "./zlib/deflate": 59,
      "./zlib/messages": 64,
      "./zlib/zstream": 66
    }],
    53: [function (require, module, exports) {
      'use strict';

      var zlib_inflate = require('./zlib/inflate');
      var utils = require('./utils/common');
      var strings = require('./utils/strings');
      var c = require('./zlib/constants');
      var msg = require('./zlib/messages');
      var ZStream = require('./zlib/zstream');
      var GZheader = require('./zlib/gzheader');
      var toString = Object.prototype.toString; /**
                                                * class Inflate
                                                *
                                                * Generic JS-style wrapper for zlib calls. If you don't need
                                                * streaming behaviour - use more simple functions: [[inflate]]
                                                * and [[inflateRaw]].
                                                **/ /* internal
                                                    * inflate.chunks -> Array
                                                    *
                                                    * Chunks of output data, if [[Inflate#onData]] not overridden.
                                                    **/ /**
                                                        * Inflate.result -> Uint8Array|Array|String
                                                        *
                                                        * Uncompressed result, generated by default [[Inflate#onData]]
                                                        * and [[Inflate#onEnd]] handlers. Filled after you push last chunk
                                                        * (call [[Inflate#push]] with `Z_FINISH` / `true` param) or if you
                                                        * push a chunk with explicit flush (call [[Inflate#push]] with
                                                        * `Z_SYNC_FLUSH` param).
                                                        **/ /**
                                                            * Inflate.err -> Number
                                                            *
                                                            * Error code after inflate finished. 0 (Z_OK) on success.
                                                            * Should be checked if broken data possible.
                                                            **/ /**
                                                                * Inflate.msg -> String
                                                                *
                                                                * Error message, if [[Inflate.err]] != 0
                                                                **/ /**
                                                                    * new Inflate(options)
                                                                    * - options (Object): zlib inflate options.
                                                                    *
                                                                    * Creates new inflator instance with specified params. Throws exception
                                                                    * on bad params. Supported options:
                                                                    *
                                                                    * - `windowBits`
                                                                    * - `dictionary`
                                                                    *
                                                                    * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
                                                                    * for more information on these.
                                                                    *
                                                                    * Additional options, for internal needs:
                                                                    *
                                                                    * - `chunkSize` - size of generated data chunks (16K by default)
                                                                    * - `raw` (Boolean) - do raw inflate
                                                                    * - `to` (String) - if equal to 'string', then result will be converted
                                                                    *   from utf8 to utf16 (javascript) string. When string output requested,
                                                                    *   chunk length can differ from `chunkSize`, depending on content.
                                                                    *
                                                                    * By default, when no options set, autodetect deflate/gzip data format via
                                                                    * wrapper header.
                                                                    *
                                                                    * ##### Example:
                                                                    *
                                                                    * ```javascript
                                                                    * var pako = require('pako')
                                                                    *   , chunk1 = Uint8Array([1,2,3,4,5,6,7,8,9])
                                                                    *   , chunk2 = Uint8Array([10,11,12,13,14,15,16,17,18,19]);
                                                                    *
                                                                    * var inflate = new pako.Inflate({ level: 3});
                                                                    *
                                                                    * inflate.push(chunk1, false);
                                                                    * inflate.push(chunk2, true);  // true -> last chunk
                                                                    *
                                                                    * if (inflate.err) { throw new Error(inflate.err); }
                                                                    *
                                                                    * console.log(inflate.result);
                                                                    * ```
                                                                    **/
      function Inflate(options) {
        if (!_instanceof(this, Inflate)) return new Inflate(options);
        this.options = utils.assign({
          chunkSize: 16384,
          windowBits: 0,
          to: ''
        }, options || {});
        var opt = this.options; // Force window size for `raw` data, if not set directly,
        // because we have no header for autodetect.
        if (opt.raw && opt.windowBits >= 0 && opt.windowBits < 16) {
          opt.windowBits = -opt.windowBits;
          if (opt.windowBits === 0) {
            opt.windowBits = -15;
          }
        } // If `windowBits` not defined (and mode not raw) - set autodetect flag for gzip/deflate
        if (opt.windowBits >= 0 && opt.windowBits < 16 && !(options && options.windowBits)) {
          opt.windowBits += 32;
        } // Gzip header has no info about windows size, we can do autodetect only
        // for deflate. So, if window size not set, force it to max when gzip possible
        if (opt.windowBits > 15 && opt.windowBits < 48) {
          // bit 3 (16) -> gzipped data
          // bit 4 (32) -> autodetect gzip/deflate
          if ((opt.windowBits & 15) === 0) {
            opt.windowBits |= 15;
          }
        }
        this.err = 0; // error code, if happens (0 = Z_OK)
        this.msg = ''; // error message
        this.ended = false; // used to avoid multiple onEnd() calls
        this.chunks = []; // chunks of compressed data
        this.strm = new ZStream();
        this.strm.avail_out = 0;
        var status = zlib_inflate.inflateInit2(this.strm, opt.windowBits);
        if (status !== c.Z_OK) {
          throw new Error(msg[status]);
        }
        this.header = new GZheader();
        zlib_inflate.inflateGetHeader(this.strm, this.header);
      } /**
        * Inflate#push(data[, mode]) -> Boolean
        * - data (Uint8Array|Array|ArrayBuffer|String): input data
        * - mode (Number|Boolean): 0..6 for corresponding Z_NO_FLUSH..Z_TREE modes.
        *   See constants. Skipped or `false` means Z_NO_FLUSH, `true` means Z_FINISH.
        *
        * Sends input data to inflate pipe, generating [[Inflate#onData]] calls with
        * new output chunks. Returns `true` on success. The last data block must have
        * mode Z_FINISH (or `true`). That will flush internal pending buffers and call
        * [[Inflate#onEnd]]. For interim explicit flushes (without ending the stream) you
        * can use mode Z_SYNC_FLUSH, keeping the decompression context.
        *
        * On fail call [[Inflate#onEnd]] with error code and return false.
        *
        * We strongly recommend to use `Uint8Array` on input for best speed (output
        * format is detected automatically). Also, don't skip last param and always
        * use the same type in your code (boolean or number). That will improve JS speed.
        *
        * For regular `Array`-s make sure all elements are [0..255].
        *
        * ##### Example
        *
        * ```javascript
        * push(chunk, false); // push one of data chunks
        * ...
        * push(chunk, true);  // push last chunk
        * ```
        **/
      Inflate.prototype.push = function (data, mode) {
        var strm = this.strm;
        var chunkSize = this.options.chunkSize;
        var dictionary = this.options.dictionary;
        var status, _mode;
        var next_out_utf8, tail, utf8str;
        var dict; // Flag to properly process Z_BUF_ERROR on testing inflate call
        // when we check that all output data was flushed.
        var allowBufError = false;
        if (this.ended) {
          return false;
        }
        _mode = mode === ~~mode ? mode : mode === true ? c.Z_FINISH : c.Z_NO_FLUSH; // Convert data if needed
        if (typeof data === 'string') {
          // Only binary strings can be decompressed on practice
          strm.input = strings.binstring2buf(data);
        } else if (toString.call(data) === '[object ArrayBuffer]') {
          strm.input = new Uint8Array(data);
        } else {
          strm.input = data;
        }
        strm.next_in = 0;
        strm.avail_in = strm.input.length;
        do {
          if (strm.avail_out === 0) {
            strm.output = new utils.Buf8(chunkSize);
            strm.next_out = 0;
            strm.avail_out = chunkSize;
          }
          status = zlib_inflate.inflate(strm, c.Z_NO_FLUSH); /* no bad return value */
          if (status === c.Z_NEED_DICT && dictionary) {
            // Convert data if needed
            if (typeof dictionary === 'string') {
              dict = strings.string2buf(dictionary);
            } else if (toString.call(dictionary) === '[object ArrayBuffer]') {
              dict = new Uint8Array(dictionary);
            } else {
              dict = dictionary;
            }
            status = zlib_inflate.inflateSetDictionary(this.strm, dict);
          }
          if (status === c.Z_BUF_ERROR && allowBufError === true) {
            status = c.Z_OK;
            allowBufError = false;
          }
          if (status !== c.Z_STREAM_END && status !== c.Z_OK) {
            this.onEnd(status);
            this.ended = true;
            return false;
          }
          if (strm.next_out) {
            if (strm.avail_out === 0 || status === c.Z_STREAM_END || strm.avail_in === 0 && (_mode === c.Z_FINISH || _mode === c.Z_SYNC_FLUSH)) {
              if (this.options.to === 'string') {
                next_out_utf8 = strings.utf8border(strm.output, strm.next_out);
                tail = strm.next_out - next_out_utf8;
                utf8str = strings.buf2string(strm.output, next_out_utf8); // move tail
                strm.next_out = tail;
                strm.avail_out = chunkSize - tail;
                if (tail) {
                  utils.arraySet(strm.output, strm.output, next_out_utf8, tail, 0);
                }
                this.onData(utf8str);
              } else {
                this.onData(utils.shrinkBuf(strm.output, strm.next_out));
              }
            }
          } // When no more input data, we should check that internal inflate buffers
          // are flushed. The only way to do it when avail_out = 0 - run one more
          // inflate pass. But if output data not exists, inflate return Z_BUF_ERROR.
          // Here we set flag to process this error properly.
          //
          // NOTE. Deflate does not return error in this case and does not needs such
          // logic.
          if (strm.avail_in === 0 && strm.avail_out === 0) {
            allowBufError = true;
          }
        } while ((strm.avail_in > 0 || strm.avail_out === 0) && status !== c.Z_STREAM_END);
        if (status === c.Z_STREAM_END) {
          _mode = c.Z_FINISH;
        } // Finalize on the last chunk.
        if (_mode === c.Z_FINISH) {
          status = zlib_inflate.inflateEnd(this.strm);
          this.onEnd(status);
          this.ended = true;
          return status === c.Z_OK;
        } // callback interim results if Z_SYNC_FLUSH.
        if (_mode === c.Z_SYNC_FLUSH) {
          this.onEnd(c.Z_OK);
          strm.avail_out = 0;
          return true;
        }
        return true;
      }; /**
         * Inflate#onData(chunk) -> Void
         * - chunk (Uint8Array|Array|String): output data. Type of array depends
         *   on js engine support. When string output requested, each chunk
         *   will be string.
         *
         * By default, stores data blocks in `chunks[]` property and glue
         * those in `onEnd`. Override this handler, if you need another behaviour.
         **/
      Inflate.prototype.onData = function (chunk) {
        this.chunks.push(chunk);
      }; /**
         * Inflate#onEnd(status) -> Void
         * - status (Number): inflate status. 0 (Z_OK) on success,
         *   other if not.
         *
         * Called either after you tell inflate that the input stream is
         * complete (Z_FINISH) or should be flushed (Z_SYNC_FLUSH)
         * or if an error happened. By default - join collected chunks,
         * free memory and fill `results` / `err` properties.
         **/
      Inflate.prototype.onEnd = function (status) {
        // On success - join
        if (status === c.Z_OK) {
          if (this.options.to === 'string') {
            // Glue & convert here, until we teach pako to send
            // utf8 aligned strings to onData
            this.result = this.chunks.join('');
          } else {
            this.result = utils.flattenChunks(this.chunks);
          }
        }
        this.chunks = [];
        this.err = status;
        this.msg = this.strm.msg;
      }; /**
         * inflate(data[, options]) -> Uint8Array|Array|String
         * - data (Uint8Array|Array|String): input data to decompress.
         * - options (Object): zlib inflate options.
         *
         * Decompress `data` with inflate/ungzip and `options`. Autodetect
         * format via wrapper header by default. That's why we don't provide
         * separate `ungzip` method.
         *
         * Supported options are:
         *
         * - windowBits
         *
         * [http://zlib.net/manual.html#Advanced](http://zlib.net/manual.html#Advanced)
         * for more information.
         *
         * Sugar (options):
         *
         * - `raw` (Boolean) - say that we work with raw stream, if you don't wish to specify
         *   negative windowBits implicitly.
         * - `to` (String) - if equal to 'string', then result will be converted
         *   from utf8 to utf16 (javascript) string. When string output requested,
         *   chunk length can differ from `chunkSize`, depending on content.
         *
         *
         * ##### Example:
         *
         * ```javascript
         * var pako = require('pako')
         *   , input = pako.deflate([1,2,3,4,5,6,7,8,9])
         *   , output;
         *
         * try {
         *   output = pako.inflate(input);
         * } catch (err)
         *   console.log(err);
         * }
         * ```
         **/
      function inflate(input, options) {
        var inflator = new Inflate(options);
        inflator.push(input, true); // That will never happens, if you don't cheat with options :)
        if (inflator.err) {
          throw inflator.msg || msg[inflator.err];
        }
        return inflator.result;
      } /**
        * inflateRaw(data[, options]) -> Uint8Array|Array|String
        * - data (Uint8Array|Array|String): input data to decompress.
        * - options (Object): zlib inflate options.
        *
        * The same as [[inflate]], but creates raw data, without wrapper
        * (header and adler32 crc).
        **/
      function inflateRaw(input, options) {
        options = options || {};
        options.raw = true;
        return inflate(input, options);
      } /**
        * ungzip(data[, options]) -> Uint8Array|Array|String
        * - data (Uint8Array|Array|String): input data to decompress.
        * - options (Object): zlib inflate options.
        *
        * Just shortcut to [[inflate]], because it autodetects format
        * by header.content. Done for convenience.
        **/
      exports.Inflate = Inflate;
      exports.inflate = inflate;
      exports.inflateRaw = inflateRaw;
      exports.ungzip = inflate;
    }, {
      "./utils/common": 54,
      "./utils/strings": 55,
      "./zlib/constants": 57,
      "./zlib/gzheader": 60,
      "./zlib/inflate": 62,
      "./zlib/messages": 64,
      "./zlib/zstream": 66
    }],
    54: [function (require, module, exports) {
      'use strict';

      var TYPED_OK = typeof Uint8Array !== 'undefined' && typeof Uint16Array !== 'undefined' && typeof Int32Array !== 'undefined';
      function _has(obj, key) {
        return Object.prototype.hasOwnProperty.call(obj, key);
      }
      exports.assign = function (obj /*from1, from2, from3, ...*/) {
        var sources = Array.prototype.slice.call(arguments, 1);
        while (sources.length) {
          var source = sources.shift();
          if (!source) {
            continue;
          }
          if (_typeof(source) !== 'object') {
            throw new TypeError(source + 'must be non-object');
          }
          for (var p in source) {
            if (_has(source, p)) {
              obj[p] = source[p];
            }
          }
        }
        return obj;
      }; // reduce buffer size, avoiding mem copy
      exports.shrinkBuf = function (buf, size) {
        if (buf.length === size) {
          return buf;
        }
        if (buf.subarray) {
          return buf.subarray(0, size);
        }
        buf.length = size;
        return buf;
      };
      var fnTyped = {
        arraySet: function arraySet(dest, src, src_offs, len, dest_offs) {
          if (src.subarray && dest.subarray) {
            dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
            return;
          } // Fallback to ordinary array
          for (var i = 0; i < len; i++) {
            dest[dest_offs + i] = src[src_offs + i];
          }
        },
        // Join array of chunks to single array.
        flattenChunks: function flattenChunks(chunks) {
          var i, l, len, pos, chunk, result; // calculate data length
          len = 0;
          for (i = 0, l = chunks.length; i < l; i++) {
            len += chunks[i].length;
          } // join chunks
          result = new Uint8Array(len);
          pos = 0;
          for (i = 0, l = chunks.length; i < l; i++) {
            chunk = chunks[i];
            result.set(chunk, pos);
            pos += chunk.length;
          }
          return result;
        }
      };
      var fnUntyped = {
        arraySet: function arraySet(dest, src, src_offs, len, dest_offs) {
          for (var i = 0; i < len; i++) {
            dest[dest_offs + i] = src[src_offs + i];
          }
        },
        // Join array of chunks to single array.
        flattenChunks: function flattenChunks(chunks) {
          return [].concat.apply([], chunks);
        }
      }; // Enable/Disable typed arrays use, for testing
      //
      exports.setTyped = function (on) {
        if (on) {
          exports.Buf8 = Uint8Array;
          exports.Buf16 = Uint16Array;
          exports.Buf32 = Int32Array;
          exports.assign(exports, fnTyped);
        } else {
          exports.Buf8 = Array;
          exports.Buf16 = Array;
          exports.Buf32 = Array;
          exports.assign(exports, fnUntyped);
        }
      };
      exports.setTyped(TYPED_OK);
    }, {}],
    55: [function (require, module, exports) {
      // String encode/decode helpers
      'use strict';

      var utils = require('./common'); // Quick check if we can use fast array to bin string conversion
      //
      // - apply(Array) can fail on Android 2.2
      // - apply(Uint8Array) can fail on iOS 5.1 Safari
      //
      var STR_APPLY_OK = true;
      var STR_APPLY_UIA_OK = true;
      try {
        String.fromCharCode.apply(null, [0]);
      } catch (__) {
        STR_APPLY_OK = false;
      }
      try {
        String.fromCharCode.apply(null, new Uint8Array(1));
      } catch (__) {
        STR_APPLY_UIA_OK = false;
      } // Table with utf8 lengths (calculated by first byte of sequence)
      // Note, that 5 & 6-byte values and some 4-byte values can not be represented in JS,
      // because max possible codepoint is 0x10ffff
      var _utf8len = new utils.Buf8(256);
      for (var q = 0; q < 256; q++) {
        _utf8len[q] = q >= 252 ? 6 : q >= 248 ? 5 : q >= 240 ? 4 : q >= 224 ? 3 : q >= 192 ? 2 : 1;
      }
      _utf8len[254] = _utf8len[254] = 1; // Invalid sequence start
      // convert string to array (typed, when possible)
      exports.string2buf = function (str) {
        var buf,
          c,
          c2,
          m_pos,
          i,
          str_len = str.length,
          buf_len = 0; // count binary size
        for (m_pos = 0; m_pos < str_len; m_pos++) {
          c = str.charCodeAt(m_pos);
          if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
            c2 = str.charCodeAt(m_pos + 1);
            if ((c2 & 0xfc00) === 0xdc00) {
              c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
              m_pos++;
            }
          }
          buf_len += c < 0x80 ? 1 : c < 0x800 ? 2 : c < 0x10000 ? 3 : 4;
        } // allocate buffer
        buf = new utils.Buf8(buf_len); // convert
        for (i = 0, m_pos = 0; i < buf_len; m_pos++) {
          c = str.charCodeAt(m_pos);
          if ((c & 0xfc00) === 0xd800 && m_pos + 1 < str_len) {
            c2 = str.charCodeAt(m_pos + 1);
            if ((c2 & 0xfc00) === 0xdc00) {
              c = 0x10000 + (c - 0xd800 << 10) + (c2 - 0xdc00);
              m_pos++;
            }
          }
          if (c < 0x80) {
            /* one byte */buf[i++] = c;
          } else if (c < 0x800) {
            /* two bytes */buf[i++] = 0xC0 | c >>> 6;
            buf[i++] = 0x80 | c & 0x3f;
          } else if (c < 0x10000) {
            /* three bytes */buf[i++] = 0xE0 | c >>> 12;
            buf[i++] = 0x80 | c >>> 6 & 0x3f;
            buf[i++] = 0x80 | c & 0x3f;
          } else {
            /* four bytes */buf[i++] = 0xf0 | c >>> 18;
            buf[i++] = 0x80 | c >>> 12 & 0x3f;
            buf[i++] = 0x80 | c >>> 6 & 0x3f;
            buf[i++] = 0x80 | c & 0x3f;
          }
        }
        return buf;
      }; // Helper (used in 2 places)
      function buf2binstring(buf, len) {
        // use fallback for big arrays to avoid stack overflow
        if (len < 65537) {
          if (buf.subarray && STR_APPLY_UIA_OK || !buf.subarray && STR_APPLY_OK) {
            return String.fromCharCode.apply(null, utils.shrinkBuf(buf, len));
          }
        }
        var result = '';
        for (var i = 0; i < len; i++) {
          result += String.fromCharCode(buf[i]);
        }
        return result;
      } // Convert byte array to binary string
      exports.buf2binstring = function (buf) {
        return buf2binstring(buf, buf.length);
      }; // Convert binary string (typed, when possible)
      exports.binstring2buf = function (str) {
        var buf = new utils.Buf8(str.length);
        for (var i = 0, len = buf.length; i < len; i++) {
          buf[i] = str.charCodeAt(i);
        }
        return buf;
      }; // convert array to string
      exports.buf2string = function (buf, max) {
        var i, out, c, c_len;
        var len = max || buf.length; // Reserve max possible length (2 words per char)
        // NB: by unknown reasons, Array is significantly faster for
        //     String.fromCharCode.apply than Uint16Array.
        var utf16buf = new Array(len * 2);
        for (out = 0, i = 0; i < len;) {
          c = buf[i++]; // quick process ascii
          if (c < 0x80) {
            utf16buf[out++] = c;
            continue;
          }
          c_len = _utf8len[c]; // skip 5 & 6 byte codes
          if (c_len > 4) {
            utf16buf[out++] = 0xfffd;
            i += c_len - 1;
            continue;
          } // apply mask on first byte
          c &= c_len === 2 ? 0x1f : c_len === 3 ? 0x0f : 0x07; // join the rest
          while (c_len > 1 && i < len) {
            c = c << 6 | buf[i++] & 0x3f;
            c_len--;
          } // terminated by end of string?
          if (c_len > 1) {
            utf16buf[out++] = 0xfffd;
            continue;
          }
          if (c < 0x10000) {
            utf16buf[out++] = c;
          } else {
            c -= 0x10000;
            utf16buf[out++] = 0xd800 | c >> 10 & 0x3ff;
            utf16buf[out++] = 0xdc00 | c & 0x3ff;
          }
        }
        return buf2binstring(utf16buf, out);
      }; // Calculate max possible position in utf8 buffer,
      // that will not break sequence. If that's not possible
      // - (very small limits) return max size as is.
      //
      // buf[] - utf8 bytes array
      // max   - length limit (mandatory);
      exports.utf8border = function (buf, max) {
        var pos;
        max = max || buf.length;
        if (max > buf.length) {
          max = buf.length;
        } // go back from last position, until start of sequence found
        pos = max - 1;
        while (pos >= 0 && (buf[pos] & 0xC0) === 0x80) {
          pos--;
        } // Very small and broken sequence,
        // return max, because we should return something anyway.
        if (pos < 0) {
          return max;
        } // If we came to start of buffer - that means buffer is too small,
        // return max too.
        if (pos === 0) {
          return max;
        }
        return pos + _utf8len[buf[pos]] > max ? pos : max;
      };
    }, {
      "./common": 54
    }],
    56: [function (require, module, exports) {
      'use strict';

      // Note: adler32 takes 12% for level 0 and 2% for level 6.
      // It isn't worth it to make additional optimizations as in original.
      // Small size is preferable.
      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      function adler32(adler, buf, len, pos) {
        var s1 = adler & 0xffff | 0,
          s2 = adler >>> 16 & 0xffff | 0,
          n = 0;
        while (len !== 0) {
          // Set limit ~ twice less than 5552, to keep
          // s2 in 31-bits, because we force signed ints.
          // in other case %= will fail.
          n = len > 2000 ? 2000 : len;
          len -= n;
          do {
            s1 = s1 + buf[pos++] | 0;
            s2 = s2 + s1 | 0;
          } while (--n);
          s1 %= 65521;
          s2 %= 65521;
        }
        return s1 | s2 << 16 | 0;
      }
      module.exports = adler32;
    }, {}],
    57: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      module.exports = {
        /* Allowed flush values; see deflate() and inflate() below for details */Z_NO_FLUSH: 0,
        Z_PARTIAL_FLUSH: 1,
        Z_SYNC_FLUSH: 2,
        Z_FULL_FLUSH: 3,
        Z_FINISH: 4,
        Z_BLOCK: 5,
        Z_TREES: 6,
        /* Return codes for the compression/decompression functions. Negative values
        * are errors, positive values are used for special but normal events.
        */
        Z_OK: 0,
        Z_STREAM_END: 1,
        Z_NEED_DICT: 2,
        Z_ERRNO: -1,
        Z_STREAM_ERROR: -2,
        Z_DATA_ERROR: -3,
        //Z_MEM_ERROR:     -4,
        Z_BUF_ERROR: -5,
        //Z_VERSION_ERROR: -6,
        /* compression levels */
        Z_NO_COMPRESSION: 0,
        Z_BEST_SPEED: 1,
        Z_BEST_COMPRESSION: 9,
        Z_DEFAULT_COMPRESSION: -1,
        Z_FILTERED: 1,
        Z_HUFFMAN_ONLY: 2,
        Z_RLE: 3,
        Z_FIXED: 4,
        Z_DEFAULT_STRATEGY: 0,
        /* Possible values of the data_type field (though see inflate()) */Z_BINARY: 0,
        Z_TEXT: 1,
        //Z_ASCII:                1, // = Z_TEXT (deprecated)
        Z_UNKNOWN: 2,
        /* The deflate compression method */Z_DEFLATED: 8 //Z_NULL:                 null // Use -1 or null inline, depending on var type
      };
    }, {}],
    58: [function (require, module, exports) {
      'use strict';

      // Note: we can't get significant speed boost here.
      // So write code to minimize size - no pregenerated tables
      // and array tools dependencies.
      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      // Use ordinary array, since untyped makes no boost here
      function makeTable() {
        var c,
          table = [];
        for (var n = 0; n < 256; n++) {
          c = n;
          for (var k = 0; k < 8; k++) {
            c = c & 1 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
          }
          table[n] = c;
        }
        return table;
      } // Create table on load. Just 255 signed longs. Not a problem.
      var crcTable = makeTable();
      function crc32(crc, buf, len, pos) {
        var t = crcTable,
          end = pos + len;
        crc ^= -1;
        for (var i = pos; i < end; i++) {
          crc = crc >>> 8 ^ t[(crc ^ buf[i]) & 0xFF];
        }
        return crc ^ -1; // >>> 0;
      }
      module.exports = crc32;
    }, {}],
    59: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      var utils = require('../utils/common');
      var trees = require('./trees');
      var adler32 = require('./adler32');
      var crc32 = require('./crc32');
      var msg = require('./messages'); /* Public constants ==========================================================*/ /* ===========================================================================*/ /* Allowed flush values; see deflate() and inflate() below for details */
      var Z_NO_FLUSH = 0;
      var Z_PARTIAL_FLUSH = 1; //var Z_SYNC_FLUSH    = 2;
      var Z_FULL_FLUSH = 3;
      var Z_FINISH = 4;
      var Z_BLOCK = 5; //var Z_TREES         = 6;
      /* Return codes for the compression/decompression functions. Negative values
       * are errors, positive values are used for special but normal events.
       */
      var Z_OK = 0;
      var Z_STREAM_END = 1; //var Z_NEED_DICT     = 2;
      //var Z_ERRNO         = -1;
      var Z_STREAM_ERROR = -2;
      var Z_DATA_ERROR = -3; //var Z_MEM_ERROR     = -4;
      var Z_BUF_ERROR = -5; //var Z_VERSION_ERROR = -6;
      /* compression levels */ //var Z_NO_COMPRESSION      = 0;
      //var Z_BEST_SPEED          = 1;
      //var Z_BEST_COMPRESSION    = 9;
      var Z_DEFAULT_COMPRESSION = -1;
      var Z_FILTERED = 1;
      var Z_HUFFMAN_ONLY = 2;
      var Z_RLE = 3;
      var Z_FIXED = 4;
      var Z_DEFAULT_STRATEGY = 0; /* Possible values of the data_type field (though see inflate()) */ //var Z_BINARY              = 0;
      //var Z_TEXT                = 1;
      //var Z_ASCII               = 1; // = Z_TEXT
      var Z_UNKNOWN = 2; /* The deflate compression method */
      var Z_DEFLATED = 8; /*============================================================================*/
      var MAX_MEM_LEVEL = 9; /* Maximum value for memLevel in deflateInit2 */
      var MAX_WBITS = 15; /* 32K LZ77 window */
      var DEF_MEM_LEVEL = 8;
      var LENGTH_CODES = 29; /* number of length codes, not counting the special END_BLOCK code */
      var LITERALS = 256; /* number of literal bytes 0..255 */
      var L_CODES = LITERALS + 1 + LENGTH_CODES; /* number of Literal or Length codes, including the END_BLOCK code */
      var D_CODES = 30; /* number of distance codes */
      var BL_CODES = 19; /* number of codes used to transfer the bit lengths */
      var HEAP_SIZE = 2 * L_CODES + 1; /* maximum heap size */
      var MAX_BITS = 15; /* All codes must not exceed MAX_BITS bits */
      var MIN_MATCH = 3;
      var MAX_MATCH = 258;
      var MIN_LOOKAHEAD = MAX_MATCH + MIN_MATCH + 1;
      var PRESET_DICT = 0x20;
      var INIT_STATE = 42;
      var EXTRA_STATE = 69;
      var NAME_STATE = 73;
      var COMMENT_STATE = 91;
      var HCRC_STATE = 103;
      var BUSY_STATE = 113;
      var FINISH_STATE = 666;
      var BS_NEED_MORE = 1; /* block not completed, need more input or more output */
      var BS_BLOCK_DONE = 2; /* block flush performed */
      var BS_FINISH_STARTED = 3; /* finish started, need only more output at next deflate */
      var BS_FINISH_DONE = 4; /* finish done, accept no more input or output */
      var OS_CODE = 0x03; // Unix :) . Don't detect, use this default.
      function err(strm, errorCode) {
        strm.msg = msg[errorCode];
        return errorCode;
      }
      function rank(f) {
        return (f << 1) - (f > 4 ? 9 : 0);
      }
      function zero(buf) {
        var len = buf.length;
        while (--len >= 0) {
          buf[len] = 0;
        }
      } /* =========================================================================
        * Flush as much pending output as possible. All deflate() output goes
        * through this function so some applications may wish to modify it
        * to avoid allocating a large strm->output buffer and copying into it.
        * (See also read_buf()).
        */
      function flush_pending(strm) {
        var s = strm.state; //_tr_flush_bits(s);
        var len = s.pending;
        if (len > strm.avail_out) {
          len = strm.avail_out;
        }
        if (len === 0) {
          return;
        }
        utils.arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);
        strm.next_out += len;
        s.pending_out += len;
        strm.total_out += len;
        strm.avail_out -= len;
        s.pending -= len;
        if (s.pending === 0) {
          s.pending_out = 0;
        }
      }
      function flush_block_only(s, last) {
        trees._tr_flush_block(s, s.block_start >= 0 ? s.block_start : -1, s.strstart - s.block_start, last);
        s.block_start = s.strstart;
        flush_pending(s.strm);
      }
      function put_byte(s, b) {
        s.pending_buf[s.pending++] = b;
      } /* =========================================================================
        * Put a short in the pending buffer. The 16-bit value is put in MSB order.
        * IN assertion: the stream state is correct and there is enough room in
        * pending_buf.
        */
      function putShortMSB(s, b) {
        //  put_byte(s, (Byte)(b >> 8));
        //  put_byte(s, (Byte)(b & 0xff));
        s.pending_buf[s.pending++] = b >>> 8 & 0xff;
        s.pending_buf[s.pending++] = b & 0xff;
      } /* ===========================================================================
        * Read a new buffer from the current input stream, update the adler32
        * and total number of bytes read.  All deflate() input goes through
        * this function so some applications may wish to modify it to avoid
        * allocating a large strm->input buffer and copying from it.
        * (See also flush_pending()).
        */
      function read_buf(strm, buf, start, size) {
        var len = strm.avail_in;
        if (len > size) {
          len = size;
        }
        if (len === 0) {
          return 0;
        }
        strm.avail_in -= len; // zmemcpy(buf, strm->next_in, len);
        utils.arraySet(buf, strm.input, strm.next_in, len, start);
        if (strm.state.wrap === 1) {
          strm.adler = adler32(strm.adler, buf, len, start);
        } else if (strm.state.wrap === 2) {
          strm.adler = crc32(strm.adler, buf, len, start);
        }
        strm.next_in += len;
        strm.total_in += len;
        return len;
      } /* ===========================================================================
        * Set match_start to the longest match starting at the given string and
        * return its length. Matches shorter or equal to prev_length are discarded,
        * in which case the result is equal to prev_length and match_start is
        * garbage.
        * IN assertions: cur_match is the head of the hash chain for the current
        *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
        * OUT assertion: the match length is not greater than s->lookahead.
        */
      function longest_match(s, cur_match) {
        var chain_length = s.max_chain_length; /* max hash chain length */
        var scan = s.strstart; /* current string */
        var match; /* matched string */
        var len; /* length of current match */
        var best_len = s.prev_length; /* best match length so far */
        var nice_match = s.nice_match; /* stop if match long enough */
        var limit = s.strstart > s.w_size - MIN_LOOKAHEAD ? s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0 /*NIL*/;
        var _win = s.window; // shortcut
        var wmask = s.w_mask;
        var prev = s.prev; /* Stop when cur_match becomes <= limit. To simplify the code,
                           * we prevent matches with the string of window index 0.
                           */
        var strend = s.strstart + MAX_MATCH;
        var scan_end1 = _win[scan + best_len - 1];
        var scan_end = _win[scan + best_len]; /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
                                              * It is easy to get rid of this optimization if necessary.
                                              */ // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");
        /* Do not waste too much time if we already have a good match: */
        if (s.prev_length >= s.good_match) {
          chain_length >>= 2;
        } /* Do not look for matches beyond the end of the input. This is necessary
          * to make deflate deterministic.
          */
        if (nice_match > s.lookahead) {
          nice_match = s.lookahead;
        } // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");
        do {
          // Assert(cur_match < s->strstart, "no future");
          match = cur_match; /* Skip to next match if the match length cannot increase
                             * or if the match length is less than 2.  Note that the checks below
                             * for insufficient lookahead only occur occasionally for performance
                             * reasons.  Therefore uninitialized memory will be accessed, and
                             * conditional jumps will be made that depend on those values.
                             * However the length of the match is limited to the lookahead, so
                             * the output of deflate is not affected by the uninitialized values.
                             */
          if (_win[match + best_len] !== scan_end || _win[match + best_len - 1] !== scan_end1 || _win[match] !== _win[scan] || _win[++match] !== _win[scan + 1]) {
            continue;
          } /* The check at best_len-1 can be removed because it will be made
            * again later. (This heuristic is not always a win.)
            * It is not necessary to compare scan[2] and match[2] since they
            * are always equal when the other bytes match, given that
            * the hash keys are equal and that HASH_BITS >= 8.
            */
          scan += 2;
          match++; // Assert(*scan == *match, "match[2]?");
          /* We check for insufficient lookahead only every 8th comparison;
               * the 256th check will be made at strstart+258.
               */
          do {/*jshint noempty:false*/} while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && _win[++scan] === _win[++match] && scan < strend); // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");
          len = MAX_MATCH - (strend - scan);
          scan = strend - MAX_MATCH;
          if (len > best_len) {
            s.match_start = cur_match;
            best_len = len;
            if (len >= nice_match) {
              break;
            }
            scan_end1 = _win[scan + best_len - 1];
            scan_end = _win[scan + best_len];
          }
        } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);
        if (best_len <= s.lookahead) {
          return best_len;
        }
        return s.lookahead;
      } /* ===========================================================================
        * Fill the window when the lookahead becomes insufficient.
        * Updates strstart and lookahead.
        *
        * IN assertion: lookahead < MIN_LOOKAHEAD
        * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
        *    At least one byte has been read, or avail_in == 0; reads are
        *    performed for at least two bytes (required for the zip translate_eol
        *    option -- not supported here).
        */
      function fill_window(s) {
        var _w_size = s.w_size;
        var p, n, m, more, str; //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");
        do {
          more = s.window_size - s.lookahead - s.strstart; // JS ints have 32 bit, block below not needed
          /* Deal with !@#$% 64K limit: */ //if (sizeof(int) <= 2) {
          //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
          //        more = wsize;
          //
          //  } else if (more == (unsigned)(-1)) {
          //        /* Very unlikely, but possible on 16 bit machine if
          //         * strstart == 0 && lookahead == 1 (input done a byte at time)
          //         */
          //        more--;
          //    }
          //}
          /* If the window is almost full and there is insufficient lookahead,
               * move the upper half to the lower one to make room in the upper half.
               */
          if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {
            utils.arraySet(s.window, s.window, _w_size, _w_size, 0);
            s.match_start -= _w_size;
            s.strstart -= _w_size; /* we now have strstart >= MAX_DIST */
            s.block_start -= _w_size; /* Slide the hash table (could be avoided with 32 bit values
                                      at the expense of memory usage). We slide even when level == 0
                                      to keep the hash table consistent if we switch back to level > 0
                                      later. (Using level 0 permanently is not an optimal usage of
                                      zlib, so we don't care about this pathological case.)
                                      */
            n = s.hash_size;
            p = n;
            do {
              m = s.head[--p];
              s.head[p] = m >= _w_size ? m - _w_size : 0;
            } while (--n);
            n = _w_size;
            p = n;
            do {
              m = s.prev[--p];
              s.prev[p] = m >= _w_size ? m - _w_size : 0; /* If n is not on any hash chain, prev[n] is garbage but
                                                          * its value will never be used.
                                                          */
            } while (--n);
            more += _w_size;
          }
          if (s.strm.avail_in === 0) {
            break;
          } /* If there was no sliding:
            *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
            *    more == window_size - lookahead - strstart
            * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
            * => more >= window_size - 2*WSIZE + 2
            * In the BIG_MEM or MMAP case (not yet supported),
            *   window_size == input_size + MIN_LOOKAHEAD  &&
            *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
            * Otherwise, window_size == 2*WSIZE so more >= 2.
            * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
            */ //Assert(more >= 2, "more < 2");
          n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
          s.lookahead += n; /* Initialize the hash value now that we have some input: */
          if (s.lookahead + s.insert >= MIN_MATCH) {
            str = s.strstart - s.insert;
            s.ins_h = s.window[str]; /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */
            s.ins_h = (s.ins_h << s.hash_shift ^ s.window[str + 1]) & s.hash_mask; //#if MIN_MATCH != 3
            //        Call update_hash() MIN_MATCH-3 more times
            //#endif
            while (s.insert) {
              /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */s.ins_h = (s.ins_h << s.hash_shift ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;
              s.prev[str & s.w_mask] = s.head[s.ins_h];
              s.head[s.ins_h] = str;
              str++;
              s.insert--;
              if (s.lookahead + s.insert < MIN_MATCH) {
                break;
              }
            }
          } /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
            * but this is not important since only literal bytes will be emitted.
            */
        } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0); /* If the WIN_INIT bytes after the end of the current data have never been
                                                                        * written, then zero those bytes in order to avoid memory check reports of
                                                                        * the use of uninitialized (or uninitialised as Julian writes) bytes by
                                                                        * the longest match routines.  Update the high water mark for the next
                                                                        * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
                                                                        * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
                                                                        */ //  if (s.high_water < s.window_size) {
        //    var curr = s.strstart + s.lookahead;
        //    var init = 0;
        //
        //    if (s.high_water < curr) {
        //      /* Previous high water mark below current data -- zero WIN_INIT
        //       * bytes or up to end of window, whichever is less.
        //       */
        //      init = s.window_size - curr;
        //      if (init > WIN_INIT)
        //        init = WIN_INIT;
        //      zmemzero(s->window + curr, (unsigned)init);
        //      s->high_water = curr + init;
        //    }
        //    else if (s->high_water < (ulg)curr + WIN_INIT) {
        //      /* High water mark at or above current data, but below current data
        //       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
        //       * to end of window, whichever is less.
        //       */
        //      init = (ulg)curr + WIN_INIT - s->high_water;
        //      if (init > s->window_size - s->high_water)
        //        init = s->window_size - s->high_water;
        //      zmemzero(s->window + s->high_water, (unsigned)init);
        //      s->high_water += init;
        //    }
        //  }
        //
        //  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
        //    "not enough room for search");
      } /* ===========================================================================
        * Copy without compression as much as possible from the input stream, return
        * the current block state.
        * This function does not insert new strings in the dictionary since
        * uncompressible data is probably not useful. This function is used
        * only for the level=0 compression option.
        * NOTE: this function should be optimized to avoid extra copying from
        * window to pending_buf.
        */
      function deflate_stored(s, flush) {
        /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
        * to pending_buf_size, and each stored block has a 5 byte header:
        */
        var max_block_size = 0xffff;
        if (max_block_size > s.pending_buf_size - 5) {
          max_block_size = s.pending_buf_size - 5;
        } /* Copy as much as possible from input to output: */
        for (;;) {
          /* Fill the window as much as possible: */if (s.lookahead <= 1) {
            //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
            //  s->block_start >= (long)s->w_size, "slide too late");
            //      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
            //        s.block_start >= s.w_size)) {
            //        throw  new Error("slide too late");
            //      }
            fill_window(s);
            if (s.lookahead === 0 && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }
            if (s.lookahead === 0) {
              break;
            } /* flush the current block */
          } //Assert(s->block_start >= 0L, "block gone");
          //    if (s.block_start < 0) throw new Error("block gone");
          s.strstart += s.lookahead;
          s.lookahead = 0; /* Emit a stored block if pending_buf will be full: */
          var max_start = s.block_start + max_block_size;
          if (s.strstart === 0 || s.strstart >= max_start) {
            /* strstart == 0 is possible when wraparound on 16-bit machine */s.lookahead = s.strstart - max_start;
            s.strstart = max_start; /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            } /***/
          } /* Flush if we may have to slide, otherwise block_start may become
            * negative and the data will be gone:
            */
          if (s.strstart - s.block_start >= s.w_size - MIN_LOOKAHEAD) {
            /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            } /***/
          }
        }
        s.insert = 0;
        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/flush_block_only(s, true);
          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          } /***/
          return BS_FINISH_DONE;
        }
        if (s.strstart > s.block_start) {
          /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          } /***/
        }
        return BS_NEED_MORE;
      } /* ===========================================================================
        * Compress as much as possible from the input stream, return the current
        * block state.
        * This function does not perform lazy evaluation of matches and inserts
        * new strings in the dictionary only for unmatched strings or for short
        * matches. It is used only for the fast compression options.
        */
      function deflate_fast(s, flush) {
        var hash_head; /* head of the hash chain */
        var bflush; /* set if current block must be flushed */
        for (;;) {
          /* Make sure that we always have enough lookahead, except
          * at the end of the input file. We need MAX_MATCH bytes
          * for the next match, plus MIN_MATCH bytes to insert the
          * string following the next match.
          */
          if (s.lookahead < MIN_LOOKAHEAD) {
            fill_window(s);
            if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }
            if (s.lookahead === 0) {
              break; /* flush the current block */
            }
          } /* Insert the string window[strstart .. strstart+2] in the
            * dictionary, and set hash_head to the head of the hash chain:
            */
          hash_head = 0 /*NIL*/;
          if (s.lookahead >= MIN_MATCH) {
            /*** INSERT_STRING(s, s.strstart, hash_head); ***/s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
            hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = s.strstart; /***/
          } /* Find the longest match, discarding those <= prev_length.
            * At this point we have always match_length < MIN_MATCH
            */
          if (hash_head !== 0 /*NIL*/ && s.strstart - hash_head <= s.w_size - MIN_LOOKAHEAD) {
            /* To simplify the code, we prevent matches with the string
            * of window index 0 (in particular we have to avoid a match
            * of the string with itself at the start of the input file).
            */
            s.match_length = longest_match(s, hash_head); /* longest_match() sets match_start */
          }
          if (s.match_length >= MIN_MATCH) {
            // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only
            /*** _tr_tally_dist(s, s.strstart - s.match_start,
                                 s.match_length - MIN_MATCH, bflush); ***/
            bflush = trees._tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH);
            s.lookahead -= s.match_length; /* Insert new strings in the hash table only if the match length
                                           * is not too large. This saves time but degrades compression.
                                           */
            if (s.match_length <= s.max_lazy_match /*max_insert_length*/ && s.lookahead >= MIN_MATCH) {
              s.match_length--; /* string at strstart already in table */
              do {
                s.strstart++; /*** INSERT_STRING(s, s.strstart, hash_head); ***/
                s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
                hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
                s.head[s.ins_h] = s.strstart; /***/ /* strstart never exceeds WSIZE-MAX_MATCH, so there are
                                                    * always MIN_MATCH bytes ahead.
                                                    */
              } while (--s.match_length !== 0);
              s.strstart++;
            } else {
              s.strstart += s.match_length;
              s.match_length = 0;
              s.ins_h = s.window[s.strstart]; /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */
              s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + 1]) & s.hash_mask; //#if MIN_MATCH != 3
              //                Call UPDATE_HASH() MIN_MATCH-3 more times
              //#endif
              /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
                       * matter since it will be recomputed at next deflate call.
                       */
            }
          } else {
            /* No match, output a literal byte */ //Tracevv((stderr,"%c", s.window[s.strstart]));
            /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
            s.lookahead--;
            s.strstart++;
          }
          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            } /***/
          }
        }
        s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;
        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/flush_block_only(s, true);
          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          } /***/
          return BS_FINISH_DONE;
        }
        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          } /***/
        }
        return BS_BLOCK_DONE;
      } /* ===========================================================================
        * Same as above, but achieves better compression. We use a lazy
        * evaluation for matches: a match is finally adopted only if there is
        * no better match at the next window position.
        */
      function deflate_slow(s, flush) {
        var hash_head; /* head of hash chain */
        var bflush; /* set if current block must be flushed */
        var max_insert; /* Process the input block. */
        for (;;) {
          /* Make sure that we always have enough lookahead, except
          * at the end of the input file. We need MAX_MATCH bytes
          * for the next match, plus MIN_MATCH bytes to insert the
          * string following the next match.
          */
          if (s.lookahead < MIN_LOOKAHEAD) {
            fill_window(s);
            if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }
            if (s.lookahead === 0) {
              break;
            } /* flush the current block */
          } /* Insert the string window[strstart .. strstart+2] in the
            * dictionary, and set hash_head to the head of the hash chain:
            */
          hash_head = 0 /*NIL*/;
          if (s.lookahead >= MIN_MATCH) {
            /*** INSERT_STRING(s, s.strstart, hash_head); ***/s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
            hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = s.strstart; /***/
          } /* Find the longest match, discarding those <= prev_length.
            */
          s.prev_length = s.match_length;
          s.prev_match = s.match_start;
          s.match_length = MIN_MATCH - 1;
          if (hash_head !== 0 /*NIL*/ && s.prev_length < s.max_lazy_match && s.strstart - hash_head <= s.w_size - MIN_LOOKAHEAD /*MAX_DIST(s)*/) {
            /* To simplify the code, we prevent matches with the string
            * of window index 0 (in particular we have to avoid a match
            * of the string with itself at the start of the input file).
            */
            s.match_length = longest_match(s, hash_head); /* longest_match() sets match_start */
            if (s.match_length <= 5 && (s.strategy === Z_FILTERED || s.match_length === MIN_MATCH && s.strstart - s.match_start > 4096 /*TOO_FAR*/)) {
              /* If prev_match is also MIN_MATCH, match_start is garbage
              * but we will ignore the current match anyway.
              */
              s.match_length = MIN_MATCH - 1;
            }
          } /* If there was a match at the previous step and the current
            * match is not better, output the previous match:
            */
          if (s.prev_length >= MIN_MATCH && s.match_length <= s.prev_length) {
            max_insert = s.strstart + s.lookahead - MIN_MATCH; /* Do not insert strings in hash table beyond this. */ //check_match(s, s.strstart-1, s.prev_match, s.prev_length);
            /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
                                 s.prev_length - MIN_MATCH, bflush);***/
            bflush = trees._tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH); /* Insert in hash table all strings up to the end of the match.
                                                                                                   * strstart-1 and strstart are already inserted. If there is not
                                                                                                   * enough lookahead, the last two strings are not inserted in
                                                                                                   * the hash table.
                                                                                                   */
            s.lookahead -= s.prev_length - 1;
            s.prev_length -= 2;
            do {
              if (++s.strstart <= max_insert) {
                /*** INSERT_STRING(s, s.strstart, hash_head); ***/s.ins_h = (s.ins_h << s.hash_shift ^ s.window[s.strstart + MIN_MATCH - 1]) & s.hash_mask;
                hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
                s.head[s.ins_h] = s.strstart; /***/
              }
            } while (--s.prev_length !== 0);
            s.match_available = 0;
            s.match_length = MIN_MATCH - 1;
            s.strstart++;
            if (bflush) {
              /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
              if (s.strm.avail_out === 0) {
                return BS_NEED_MORE;
              } /***/
            }
          } else if (s.match_available) {
            /* If there was no match at the previous position, output a
            * single literal. If there was a match but the current match
            * is longer, truncate the previous match to a single literal.
            */ //Tracevv((stderr,"%c", s->window[s->strstart-1]));
            /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
            bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);
            if (bflush) {
              /*** FLUSH_BLOCK_ONLY(s, 0) ***/flush_block_only(s, false); /***/
            }
            s.strstart++;
            s.lookahead--;
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
          } else {
            /* There is no previous match to compare with, wait for
            * the next step to decide.
            */
            s.match_available = 1;
            s.strstart++;
            s.lookahead--;
          }
        } //Assert (flush != Z_NO_FLUSH, "no flush?");
        if (s.match_available) {
          //Tracevv((stderr,"%c", s->window[s->strstart-1]));
          /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
          bflush = trees._tr_tally(s, 0, s.window[s.strstart - 1]);
          s.match_available = 0;
        }
        s.insert = s.strstart < MIN_MATCH - 1 ? s.strstart : MIN_MATCH - 1;
        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/flush_block_only(s, true);
          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          } /***/
          return BS_FINISH_DONE;
        }
        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          } /***/
        }
        return BS_BLOCK_DONE;
      } /* ===========================================================================
        * For Z_RLE, simply look for runs of bytes, generate matches only of distance
        * one.  Do not maintain a hash table.  (It will be regenerated if this run of
        * deflate switches away from Z_RLE.)
        */
      function deflate_rle(s, flush) {
        var bflush; /* set if current block must be flushed */
        var prev; /* byte at distance one to match */
        var scan, strend; /* scan goes up to strend for length of run */
        var _win = s.window;
        for (;;) {
          /* Make sure that we always have enough lookahead, except
          * at the end of the input file. We need MAX_MATCH bytes
          * for the longest run, plus one for the unrolled loop.
          */
          if (s.lookahead <= MAX_MATCH) {
            fill_window(s);
            if (s.lookahead <= MAX_MATCH && flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }
            if (s.lookahead === 0) {
              break;
            } /* flush the current block */
          } /* See how many times the previous byte repeats */
          s.match_length = 0;
          if (s.lookahead >= MIN_MATCH && s.strstart > 0) {
            scan = s.strstart - 1;
            prev = _win[scan];
            if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
              strend = s.strstart + MAX_MATCH;
              do {/*jshint noempty:false*/} while (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan] && scan < strend);
              s.match_length = MAX_MATCH - (strend - scan);
              if (s.match_length > s.lookahead) {
                s.match_length = s.lookahead;
              }
            } //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");
          } /* Emit match if have run of MIN_MATCH or longer, else emit literal */
          if (s.match_length >= MIN_MATCH) {
            //check_match(s, s.strstart, s.strstart - 1, s.match_length);
            /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
            bflush = trees._tr_tally(s, 1, s.match_length - MIN_MATCH);
            s.lookahead -= s.match_length;
            s.strstart += s.match_length;
            s.match_length = 0;
          } else {
            /* No match, output a literal byte */ //Tracevv((stderr,"%c", s->window[s->strstart]));
            /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
            s.lookahead--;
            s.strstart++;
          }
          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            } /***/
          }
        }
        s.insert = 0;
        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/flush_block_only(s, true);
          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          } /***/
          return BS_FINISH_DONE;
        }
        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          } /***/
        }
        return BS_BLOCK_DONE;
      } /* ===========================================================================
        * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
        * (It will be regenerated if this run of deflate switches away from Huffman.)
        */
      function deflate_huff(s, flush) {
        var bflush; /* set if current block must be flushed */
        for (;;) {
          /* Make sure that we have a literal to write. */if (s.lookahead === 0) {
            fill_window(s);
            if (s.lookahead === 0) {
              if (flush === Z_NO_FLUSH) {
                return BS_NEED_MORE;
              }
              break; /* flush the current block */
            }
          } /* Output a literal byte */
          s.match_length = 0; //Tracevv((stderr,"%c", s->window[s->strstart]));
          /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
          bflush = trees._tr_tally(s, 0, s.window[s.strstart]);
          s.lookahead--;
          s.strstart++;
          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            } /***/
          }
        }
        s.insert = 0;
        if (flush === Z_FINISH) {
          /*** FLUSH_BLOCK(s, 1); ***/flush_block_only(s, true);
          if (s.strm.avail_out === 0) {
            return BS_FINISH_STARTED;
          } /***/
          return BS_FINISH_DONE;
        }
        if (s.last_lit) {
          /*** FLUSH_BLOCK(s, 0); ***/flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          } /***/
        }
        return BS_BLOCK_DONE;
      } /* Values for max_lazy_match, good_match and max_chain_length, depending on
        * the desired pack level (0..9). The values given below have been tuned to
        * exclude worst case performance for pathological files. Better values may be
        * found for specific files.
        */
      function Config(good_length, max_lazy, nice_length, max_chain, func) {
        this.good_length = good_length;
        this.max_lazy = max_lazy;
        this.nice_length = nice_length;
        this.max_chain = max_chain;
        this.func = func;
      }
      var configuration_table;
      configuration_table = [/*      good lazy nice chain */new Config(0, 0, 0, 0, deflate_stored), /* 0 store only */new Config(4, 4, 8, 4, deflate_fast), /* 1 max speed, no lazy matches */new Config(4, 5, 16, 8, deflate_fast), /* 2 */new Config(4, 6, 32, 32, deflate_fast), /* 3 */new Config(4, 4, 16, 16, deflate_slow), /* 4 lazy matches */new Config(8, 16, 32, 32, deflate_slow), /* 5 */new Config(8, 16, 128, 128, deflate_slow), /* 6 */new Config(8, 32, 128, 256, deflate_slow), /* 7 */new Config(32, 128, 258, 1024, deflate_slow), /* 8 */new Config(32, 258, 258, 4096, deflate_slow) /* 9 max compression */]; /* ===========================================================================
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       * Initialize the "longest match" routines for a new zlib stream
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       */
      function lm_init(s) {
        s.window_size = 2 * s.w_size; /*** CLEAR_HASH(s); ***/
        zero(s.head); // Fill with NIL (= 0);
        /* Set the default configuration parameters:
           */
        s.max_lazy_match = configuration_table[s.level].max_lazy;
        s.good_match = configuration_table[s.level].good_length;
        s.nice_match = configuration_table[s.level].nice_length;
        s.max_chain_length = configuration_table[s.level].max_chain;
        s.strstart = 0;
        s.block_start = 0;
        s.lookahead = 0;
        s.insert = 0;
        s.match_length = s.prev_length = MIN_MATCH - 1;
        s.match_available = 0;
        s.ins_h = 0;
      }
      function DeflateState() {
        this.strm = null; /* pointer back to this zlib stream */
        this.status = 0; /* as the name implies */
        this.pending_buf = null; /* output still pending */
        this.pending_buf_size = 0; /* size of pending_buf */
        this.pending_out = 0; /* next pending byte to output to the stream */
        this.pending = 0; /* nb of bytes in the pending buffer */
        this.wrap = 0; /* bit 0 true for zlib, bit 1 true for gzip */
        this.gzhead = null; /* gzip header information to write */
        this.gzindex = 0; /* where in extra, name, or comment */
        this.method = Z_DEFLATED; /* can only be DEFLATED */
        this.last_flush = -1; /* value of flush param for previous deflate call */
        this.w_size = 0; /* LZ77 window size (32K by default) */
        this.w_bits = 0; /* log2(w_size)  (8..16) */
        this.w_mask = 0; /* w_size - 1 */
        this.window = null; /* Sliding window. Input bytes are read into the second half of the window,
                            * and move to the first half later to keep a dictionary of at least wSize
                            * bytes. With this organization, matches are limited to a distance of
                            * wSize-MAX_MATCH bytes, but this ensures that IO is always
                            * performed with a length multiple of the block size.
                            */
        this.window_size = 0; /* Actual size of window: 2*wSize, except when the user input buffer
                              * is directly used as sliding window.
                              */
        this.prev = null; /* Link to older string with same hash index. To limit the size of this
                          * array to 64K, this link is maintained only for the last 32K strings.
                          * An index in this array is thus a window index modulo 32K.
                          */
        this.head = null; /* Heads of the hash chains or NIL. */
        this.ins_h = 0; /* hash index of string to be inserted */
        this.hash_size = 0; /* number of elements in hash table */
        this.hash_bits = 0; /* log2(hash_size) */
        this.hash_mask = 0; /* hash_size-1 */
        this.hash_shift = 0; /* Number of bits by which ins_h must be shifted at each input
                             * step. It must be such that after MIN_MATCH steps, the oldest
                             * byte no longer takes part in the hash key, that is:
                             *   hash_shift * MIN_MATCH >= hash_bits
                             */
        this.block_start = 0; /* Window position at the beginning of the current output block. Gets
                              * negative when the window is moved backwards.
                              */
        this.match_length = 0; /* length of best match */
        this.prev_match = 0; /* previous match */
        this.match_available = 0; /* set if previous match exists */
        this.strstart = 0; /* start of string to insert */
        this.match_start = 0; /* start of matching string */
        this.lookahead = 0; /* number of valid bytes ahead in window */
        this.prev_length = 0; /* Length of the best match at previous step. Matches not greater than this
                              * are discarded. This is used in the lazy match evaluation.
                              */
        this.max_chain_length = 0; /* To speed up deflation, hash chains are never searched beyond this
                                   * length.  A higher limit improves compression ratio but degrades the
                                   * speed.
                                   */
        this.max_lazy_match = 0; /* Attempt to find a better match only when the current match is strictly
                                 * smaller than this value. This mechanism is used only for compression
                                 * levels >= 4.
                                 */ // That's alias to max_lazy_match, don't use directly
        //this.max_insert_length = 0;
        /* Insert new strings in the hash table only if the match length is not
           * greater than this length. This saves time but degrades compression.
           * max_insert_length is used only for compression levels <= 3.
           */
        this.level = 0; /* compression level (1..9) */
        this.strategy = 0; /* favor or force Huffman coding*/
        this.good_match = 0; /* Use a faster search when the previous match is longer than this */
        this.nice_match = 0; /* Stop searching when current match exceeds this */ /* used by trees.c: */ /* Didn't use ct_data typedef below to suppress compiler warning */ // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
        // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
        // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */
        // Use flat array of DOUBLE size, with interleaved fata,
        // because JS does not support effective
        this.dyn_ltree = new utils.Buf16(HEAP_SIZE * 2);
        this.dyn_dtree = new utils.Buf16((2 * D_CODES + 1) * 2);
        this.bl_tree = new utils.Buf16((2 * BL_CODES + 1) * 2);
        zero(this.dyn_ltree);
        zero(this.dyn_dtree);
        zero(this.bl_tree);
        this.l_desc = null; /* desc. for literal tree */
        this.d_desc = null; /* desc. for distance tree */
        this.bl_desc = null; /* desc. for bit length tree */ //ush bl_count[MAX_BITS+1];
        this.bl_count = new utils.Buf16(MAX_BITS + 1); /* number of codes at each bit length for an optimal tree */ //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */
        this.heap = new utils.Buf16(2 * L_CODES + 1); /* heap used to build the Huffman trees */
        zero(this.heap);
        this.heap_len = 0; /* number of elements in the heap */
        this.heap_max = 0; /* element of largest frequency */ /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
                                                              * The same heap array is used to build all trees.
                                                              */
        this.depth = new utils.Buf16(2 * L_CODES + 1); //uch depth[2*L_CODES+1];
        zero(this.depth); /* Depth of each subtree used as tie breaker for trees of equal frequency
                          */
        this.l_buf = 0; /* buffer index for literals or lengths */
        this.lit_bufsize = 0; /* Size of match buffer for literals/lengths.  There are 4 reasons for
                              * limiting lit_bufsize to 64K:
                              *   - frequencies can be kept in 16 bit counters
                              *   - if compression is not successful for the first block, all input
                              *     data is still in the window so we can still emit a stored block even
                              *     when input comes from standard input.  (This can also be done for
                              *     all blocks if lit_bufsize is not greater than 32K.)
                              *   - if compression is not successful for a file smaller than 64K, we can
                              *     even emit a stored file instead of a stored block (saving 5 bytes).
                              *     This is applicable only for zip (not gzip or zlib).
                              *   - creating new Huffman trees less frequently may not provide fast
                              *     adaptation to changes in the input data statistics. (Take for
                              *     example a binary file with poorly compressible code followed by
                              *     a highly compressible string table.) Smaller buffer sizes give
                              *     fast adaptation but have of course the overhead of transmitting
                              *     trees more frequently.
                              *   - I can't count above 4
                              */
        this.last_lit = 0; /* running index in l_buf */
        this.d_buf = 0; /* Buffer index for distances. To simplify the code, d_buf and l_buf have
                        * the same number of elements. To use different lengths, an extra flag
                        * array would be necessary.
                        */
        this.opt_len = 0; /* bit length of current block with optimal trees */
        this.static_len = 0; /* bit length of current block with static trees */
        this.matches = 0; /* number of string matches in current block */
        this.insert = 0; /* bytes at end of window left to insert */
        this.bi_buf = 0; /* Output buffer. bits are inserted starting at the bottom (least
                         * significant bits).
                         */
        this.bi_valid = 0; /* Number of valid bits in bi_buf.  All bits above the last valid bit
                           * are always zero.
                           */ // Used for window memory init. We safely ignore it for JS. That makes
        // sense only for pointers and memory check tools.
        //this.high_water = 0;
        /* High water mark offset in window for initialized bytes -- bytes above
           * this are set to zero in order to avoid memory check warnings when
           * longest match routines access bytes past the input.  This is then
           * updated to the new high water mark.
           */
      }
      function deflateResetKeep(strm) {
        var s;
        if (!strm || !strm.state) {
          return err(strm, Z_STREAM_ERROR);
        }
        strm.total_in = strm.total_out = 0;
        strm.data_type = Z_UNKNOWN;
        s = strm.state;
        s.pending = 0;
        s.pending_out = 0;
        if (s.wrap < 0) {
          s.wrap = -s.wrap; /* was made negative by deflate(..., Z_FINISH); */
        }
        s.status = s.wrap ? INIT_STATE : BUSY_STATE;
        strm.adler = s.wrap === 2 ? 0 // crc32(0, Z_NULL, 0)
        : 1; // adler32(0, Z_NULL, 0)
        s.last_flush = Z_NO_FLUSH;
        trees._tr_init(s);
        return Z_OK;
      }
      function deflateReset(strm) {
        var ret = deflateResetKeep(strm);
        if (ret === Z_OK) {
          lm_init(strm.state);
        }
        return ret;
      }
      function deflateSetHeader(strm, head) {
        if (!strm || !strm.state) {
          return Z_STREAM_ERROR;
        }
        if (strm.state.wrap !== 2) {
          return Z_STREAM_ERROR;
        }
        strm.state.gzhead = head;
        return Z_OK;
      }
      function deflateInit2(strm, level, method, windowBits, memLevel, strategy) {
        if (!strm) {
          // === Z_NULL
          return Z_STREAM_ERROR;
        }
        var wrap = 1;
        if (level === Z_DEFAULT_COMPRESSION) {
          level = 6;
        }
        if (windowBits < 0) {
          /* suppress zlib wrapper */wrap = 0;
          windowBits = -windowBits;
        } else if (windowBits > 15) {
          wrap = 2; /* write gzip wrapper instead */
          windowBits -= 16;
        }
        if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED || windowBits < 8 || windowBits > 15 || level < 0 || level > 9 || strategy < 0 || strategy > Z_FIXED) {
          return err(strm, Z_STREAM_ERROR);
        }
        if (windowBits === 8) {
          windowBits = 9;
        } /* until 256-byte window bug fixed */
        var s = new DeflateState();
        strm.state = s;
        s.strm = strm;
        s.wrap = wrap;
        s.gzhead = null;
        s.w_bits = windowBits;
        s.w_size = 1 << s.w_bits;
        s.w_mask = s.w_size - 1;
        s.hash_bits = memLevel + 7;
        s.hash_size = 1 << s.hash_bits;
        s.hash_mask = s.hash_size - 1;
        s.hash_shift = ~~((s.hash_bits + MIN_MATCH - 1) / MIN_MATCH);
        s.window = new utils.Buf8(s.w_size * 2);
        s.head = new utils.Buf16(s.hash_size);
        s.prev = new utils.Buf16(s.w_size); // Don't need mem init magic for JS.
        //s.high_water = 0;  /* nothing written to s->window yet */
        s.lit_bufsize = 1 << memLevel + 6; /* 16K elements by default */
        s.pending_buf_size = s.lit_bufsize * 4; //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
        //s->pending_buf = (uchf *) overlay;
        s.pending_buf = new utils.Buf8(s.pending_buf_size); // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
        //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);
        s.d_buf = 1 * s.lit_bufsize; //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;
        s.l_buf = (1 + 2) * s.lit_bufsize;
        s.level = level;
        s.strategy = strategy;
        s.method = method;
        return deflateReset(strm);
      }
      function deflateInit(strm, level) {
        return deflateInit2(strm, level, Z_DEFLATED, MAX_WBITS, DEF_MEM_LEVEL, Z_DEFAULT_STRATEGY);
      }
      function deflate(strm, flush) {
        var old_flush, s;
        var beg, val; // for gzip header write only
        if (!strm || !strm.state || flush > Z_BLOCK || flush < 0) {
          return strm ? err(strm, Z_STREAM_ERROR) : Z_STREAM_ERROR;
        }
        s = strm.state;
        if (!strm.output || !strm.input && strm.avail_in !== 0 || s.status === FINISH_STATE && flush !== Z_FINISH) {
          return err(strm, strm.avail_out === 0 ? Z_BUF_ERROR : Z_STREAM_ERROR);
        }
        s.strm = strm; /* just in case */
        old_flush = s.last_flush;
        s.last_flush = flush; /* Write the header */
        if (s.status === INIT_STATE) {
          if (s.wrap === 2) {
            // GZIP header
            strm.adler = 0; //crc32(0L, Z_NULL, 0);
            put_byte(s, 31);
            put_byte(s, 139);
            put_byte(s, 8);
            if (!s.gzhead) {
              // s->gzhead == Z_NULL
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, 0);
              put_byte(s, s.level === 9 ? 2 : s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ? 4 : 0);
              put_byte(s, OS_CODE);
              s.status = BUSY_STATE;
            } else {
              put_byte(s, (s.gzhead.text ? 1 : 0) + (s.gzhead.hcrc ? 2 : 0) + (!s.gzhead.extra ? 0 : 4) + (!s.gzhead.name ? 0 : 8) + (!s.gzhead.comment ? 0 : 16));
              put_byte(s, s.gzhead.time & 0xff);
              put_byte(s, s.gzhead.time >> 8 & 0xff);
              put_byte(s, s.gzhead.time >> 16 & 0xff);
              put_byte(s, s.gzhead.time >> 24 & 0xff);
              put_byte(s, s.level === 9 ? 2 : s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ? 4 : 0);
              put_byte(s, s.gzhead.os & 0xff);
              if (s.gzhead.extra && s.gzhead.extra.length) {
                put_byte(s, s.gzhead.extra.length & 0xff);
                put_byte(s, s.gzhead.extra.length >> 8 & 0xff);
              }
              if (s.gzhead.hcrc) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending, 0);
              }
              s.gzindex = 0;
              s.status = EXTRA_STATE;
            }
          } else
            // DEFLATE header
            {
              var header = Z_DEFLATED + (s.w_bits - 8 << 4) << 8;
              var level_flags = -1;
              if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
                level_flags = 0;
              } else if (s.level < 6) {
                level_flags = 1;
              } else if (s.level === 6) {
                level_flags = 2;
              } else {
                level_flags = 3;
              }
              header |= level_flags << 6;
              if (s.strstart !== 0) {
                header |= PRESET_DICT;
              }
              header += 31 - header % 31;
              s.status = BUSY_STATE;
              putShortMSB(s, header); /* Save the adler32 of the preset dictionary: */
              if (s.strstart !== 0) {
                putShortMSB(s, strm.adler >>> 16);
                putShortMSB(s, strm.adler & 0xffff);
              }
              strm.adler = 1; // adler32(0L, Z_NULL, 0);
            }
        } //#ifdef GZIP
        if (s.status === EXTRA_STATE) {
          if (s.gzhead.extra /* != Z_NULL*/) {
            beg = s.pending; /* start of bytes to update crc */
            while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
              if (s.pending === s.pending_buf_size) {
                if (s.gzhead.hcrc && s.pending > beg) {
                  strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
                }
                flush_pending(strm);
                beg = s.pending;
                if (s.pending === s.pending_buf_size) {
                  break;
                }
              }
              put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
              s.gzindex++;
            }
            if (s.gzhead.hcrc && s.pending > beg) {
              strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
            }
            if (s.gzindex === s.gzhead.extra.length) {
              s.gzindex = 0;
              s.status = NAME_STATE;
            }
          } else {
            s.status = NAME_STATE;
          }
        }
        if (s.status === NAME_STATE) {
          if (s.gzhead.name /* != Z_NULL*/) {
            beg = s.pending; /* start of bytes to update crc */ //int val;
            do {
              if (s.pending === s.pending_buf_size) {
                if (s.gzhead.hcrc && s.pending > beg) {
                  strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
                }
                flush_pending(strm);
                beg = s.pending;
                if (s.pending === s.pending_buf_size) {
                  val = 1;
                  break;
                }
              } // JS specific: little magic to add zero terminator to end of string
              if (s.gzindex < s.gzhead.name.length) {
                val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
              } else {
                val = 0;
              }
              put_byte(s, val);
            } while (val !== 0);
            if (s.gzhead.hcrc && s.pending > beg) {
              strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
            }
            if (val === 0) {
              s.gzindex = 0;
              s.status = COMMENT_STATE;
            }
          } else {
            s.status = COMMENT_STATE;
          }
        }
        if (s.status === COMMENT_STATE) {
          if (s.gzhead.comment /* != Z_NULL*/) {
            beg = s.pending; /* start of bytes to update crc */ //int val;
            do {
              if (s.pending === s.pending_buf_size) {
                if (s.gzhead.hcrc && s.pending > beg) {
                  strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
                }
                flush_pending(strm);
                beg = s.pending;
                if (s.pending === s.pending_buf_size) {
                  val = 1;
                  break;
                }
              } // JS specific: little magic to add zero terminator to end of string
              if (s.gzindex < s.gzhead.comment.length) {
                val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
              } else {
                val = 0;
              }
              put_byte(s, val);
            } while (val !== 0);
            if (s.gzhead.hcrc && s.pending > beg) {
              strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
            }
            if (val === 0) {
              s.status = HCRC_STATE;
            }
          } else {
            s.status = HCRC_STATE;
          }
        }
        if (s.status === HCRC_STATE) {
          if (s.gzhead.hcrc) {
            if (s.pending + 2 > s.pending_buf_size) {
              flush_pending(strm);
            }
            if (s.pending + 2 <= s.pending_buf_size) {
              put_byte(s, strm.adler & 0xff);
              put_byte(s, strm.adler >> 8 & 0xff);
              strm.adler = 0; //crc32(0L, Z_NULL, 0);
              s.status = BUSY_STATE;
            }
          } else {
            s.status = BUSY_STATE;
          }
        } //#endif
        /* Flush as much pending output as possible */
        if (s.pending !== 0) {
          flush_pending(strm);
          if (strm.avail_out === 0) {
            /* Since avail_out is 0, deflate will be called again with
            * more output space, but possibly with both pending and
            * avail_in equal to zero. There won't be anything to do,
            * but this is not an error situation so make sure we
            * return OK instead of BUF_ERROR at next call of deflate:
            */
            s.last_flush = -1;
            return Z_OK;
          } /* Make sure there is something to do and avoid duplicate consecutive
            * flushes. For repeated and useless calls with Z_FINISH, we keep
            * returning Z_STREAM_END instead of Z_BUF_ERROR.
            */
        } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) && flush !== Z_FINISH) {
          return err(strm, Z_BUF_ERROR);
        } /* User must not provide more input after the first FINISH: */
        if (s.status === FINISH_STATE && strm.avail_in !== 0) {
          return err(strm, Z_BUF_ERROR);
        } /* Start a new block or continue the current one.
          */
        if (strm.avail_in !== 0 || s.lookahead !== 0 || flush !== Z_NO_FLUSH && s.status !== FINISH_STATE) {
          var bstate = s.strategy === Z_HUFFMAN_ONLY ? deflate_huff(s, flush) : s.strategy === Z_RLE ? deflate_rle(s, flush) : configuration_table[s.level].func(s, flush);
          if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
            s.status = FINISH_STATE;
          }
          if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
            if (strm.avail_out === 0) {
              s.last_flush = -1; /* avoid BUF_ERROR next call, see above */
            }
            return Z_OK; /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
                         * of deflate should use the same flush parameter to make sure
                         * that the flush is complete. So we don't have to output an
                         * empty block here, this will be done at next call. This also
                         * ensures that for a very small output buffer, we emit at most
                         * one empty block.
                         */
          }
          if (bstate === BS_BLOCK_DONE) {
            if (flush === Z_PARTIAL_FLUSH) {
              trees._tr_align(s);
            } else if (flush !== Z_BLOCK) {
              /* FULL_FLUSH or SYNC_FLUSH */trees._tr_stored_block(s, 0, 0, false); /* For a full flush, this empty block will be recognized
                                                                                    * as a special marker by inflate_sync().
                                                                                    */
              if (flush === Z_FULL_FLUSH) {
                /*** CLEAR_HASH(s); ***/ /* forget history */zero(s.head); // Fill with NIL (= 0);
                if (s.lookahead === 0) {
                  s.strstart = 0;
                  s.block_start = 0;
                  s.insert = 0;
                }
              }
            }
            flush_pending(strm);
            if (strm.avail_out === 0) {
              s.last_flush = -1; /* avoid BUF_ERROR at next call, see above */
              return Z_OK;
            }
          }
        } //Assert(strm->avail_out > 0, "bug2");
        //if (strm.avail_out <= 0) { throw new Error("bug2");}
        if (flush !== Z_FINISH) {
          return Z_OK;
        }
        if (s.wrap <= 0) {
          return Z_STREAM_END;
        } /* Write the trailer */
        if (s.wrap === 2) {
          put_byte(s, strm.adler & 0xff);
          put_byte(s, strm.adler >> 8 & 0xff);
          put_byte(s, strm.adler >> 16 & 0xff);
          put_byte(s, strm.adler >> 24 & 0xff);
          put_byte(s, strm.total_in & 0xff);
          put_byte(s, strm.total_in >> 8 & 0xff);
          put_byte(s, strm.total_in >> 16 & 0xff);
          put_byte(s, strm.total_in >> 24 & 0xff);
        } else {
          putShortMSB(s, strm.adler >>> 16);
          putShortMSB(s, strm.adler & 0xffff);
        }
        flush_pending(strm); /* If avail_out is zero, the application will call deflate again
                             * to flush the rest.
                             */
        if (s.wrap > 0) {
          s.wrap = -s.wrap;
        } /* write the trailer only once! */
        return s.pending !== 0 ? Z_OK : Z_STREAM_END;
      }
      function deflateEnd(strm) {
        var status;
        if (!strm /*== Z_NULL*/ || !strm.state /*== Z_NULL*/) {
          return Z_STREAM_ERROR;
        }
        status = strm.state.status;
        if (status !== INIT_STATE && status !== EXTRA_STATE && status !== NAME_STATE && status !== COMMENT_STATE && status !== HCRC_STATE && status !== BUSY_STATE && status !== FINISH_STATE) {
          return err(strm, Z_STREAM_ERROR);
        }
        strm.state = null;
        return status === BUSY_STATE ? err(strm, Z_DATA_ERROR) : Z_OK;
      } /* =========================================================================
        * Initializes the compression dictionary from the given byte
        * sequence without producing any compressed output.
        */
      function deflateSetDictionary(strm, dictionary) {
        var dictLength = dictionary.length;
        var s;
        var str, n;
        var wrap;
        var avail;
        var next;
        var input;
        var tmpDict;
        if (!strm /*== Z_NULL*/ || !strm.state /*== Z_NULL*/) {
          return Z_STREAM_ERROR;
        }
        s = strm.state;
        wrap = s.wrap;
        if (wrap === 2 || wrap === 1 && s.status !== INIT_STATE || s.lookahead) {
          return Z_STREAM_ERROR;
        } /* when using zlib wrappers, compute Adler-32 for provided dictionary */
        if (wrap === 1) {
          /* adler32(strm->adler, dictionary, dictLength); */strm.adler = adler32(strm.adler, dictionary, dictLength, 0);
        }
        s.wrap = 0; /* avoid computing Adler-32 in read_buf */ /* if dictionary would fill window, just replace the history */
        if (dictLength >= s.w_size) {
          if (wrap === 0) {
            /* already empty otherwise */ /*** CLEAR_HASH(s); ***/zero(s.head); // Fill with NIL (= 0);
            s.strstart = 0;
            s.block_start = 0;
            s.insert = 0;
          } /* use the tail */ // dictionary = dictionary.slice(dictLength - s.w_size);
          tmpDict = new utils.Buf8(s.w_size);
          utils.arraySet(tmpDict, dictionary, dictLength - s.w_size, s.w_size, 0);
          dictionary = tmpDict;
          dictLength = s.w_size;
        } /* insert dictionary into window and hash */
        avail = strm.avail_in;
        next = strm.next_in;
        input = strm.input;
        strm.avail_in = dictLength;
        strm.next_in = 0;
        strm.input = dictionary;
        fill_window(s);
        while (s.lookahead >= MIN_MATCH) {
          str = s.strstart;
          n = s.lookahead - (MIN_MATCH - 1);
          do {
            /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */s.ins_h = (s.ins_h << s.hash_shift ^ s.window[str + MIN_MATCH - 1]) & s.hash_mask;
            s.prev[str & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = str;
            str++;
          } while (--n);
          s.strstart = str;
          s.lookahead = MIN_MATCH - 1;
          fill_window(s);
        }
        s.strstart += s.lookahead;
        s.block_start = s.strstart;
        s.insert = s.lookahead;
        s.lookahead = 0;
        s.match_length = s.prev_length = MIN_MATCH - 1;
        s.match_available = 0;
        strm.next_in = next;
        strm.input = input;
        strm.avail_in = avail;
        s.wrap = wrap;
        return Z_OK;
      }
      exports.deflateInit = deflateInit;
      exports.deflateInit2 = deflateInit2;
      exports.deflateReset = deflateReset;
      exports.deflateResetKeep = deflateResetKeep;
      exports.deflateSetHeader = deflateSetHeader;
      exports.deflate = deflate;
      exports.deflateEnd = deflateEnd;
      exports.deflateSetDictionary = deflateSetDictionary;
      exports.deflateInfo = 'pako deflate (from Nodeca project)'; /* Not implemented
                                                                  exports.deflateBound = deflateBound;
                                                                  exports.deflateCopy = deflateCopy;
                                                                  exports.deflateParams = deflateParams;
                                                                  exports.deflatePending = deflatePending;
                                                                  exports.deflatePrime = deflatePrime;
                                                                  exports.deflateTune = deflateTune;
                                                                  */
    }, {
      "../utils/common": 54,
      "./adler32": 56,
      "./crc32": 58,
      "./messages": 64,
      "./trees": 65
    }],
    60: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      function GZheader() {
        /* true if compressed data believed to be text */this.text = 0; /* modification time */
        this.time = 0; /* extra flags (not used when writing a gzip file) */
        this.xflags = 0; /* operating system */
        this.os = 0; /* pointer to extra field or Z_NULL if none */
        this.extra = null; /* extra field length (valid if extra != Z_NULL) */
        this.extra_len = 0; // Actually, we don't need it in JS,
        // but leave for few code modifications
        //
        // Setup limits is not necessary because in js we should not preallocate memory
        // for inflate use constant limit in 65536 bytes
        //
        /* space at extra (only when reading header) */ // this.extra_max  = 0;
        /* pointer to zero-terminated file name or Z_NULL */
        this.name = ''; /* space at name (only when reading header) */ // this.name_max   = 0;
        /* pointer to zero-terminated comment or Z_NULL */
        this.comment = ''; /* space at comment (only when reading header) */ // this.comm_max   = 0;
        /* true if there was or will be a header crc */
        this.hcrc = 0; /* true when done reading gzip header (not used when writing a gzip file) */
        this.done = false;
      }
      module.exports = GZheader;
    }, {}],
    61: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      // See state defs from inflate.js
      var BAD = 30; /* got a data error -- remain here until reset */
      var TYPE = 12; /* i: waiting for type bits, including last-flag bit */ /*
                                                                             Decode literal, length, and distance codes and write out the resulting
                                                                             literal and match bytes until either not enough input or output is
                                                                             available, an end-of-block is encountered, or a data error is encountered.
                                                                             When large enough input and output buffers are supplied to inflate(), for
                                                                             example, a 16K input buffer and a 64K output buffer, more than 95% of the
                                                                             inflate execution time is spent in this routine.
                                                                             Entry assumptions:
                                                                             state.mode === LEN
                                                                             strm.avail_in >= 6
                                                                             strm.avail_out >= 258
                                                                             start >= strm.avail_out
                                                                             state.bits < 8
                                                                             On return, state.mode is one of:
                                                                             LEN -- ran out of enough output space or enough available input
                                                                             TYPE -- reached end of block code, inflate() to interpret next block
                                                                             BAD -- error in block data
                                                                             Notes:
                                                                             - The maximum input bits used by a length/distance pair is 15 bits for the
                                                                             length code, 5 bits for the length extra, 15 bits for the distance code,
                                                                             and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
                                                                             Therefore if strm.avail_in >= 6, then there is enough input to avoid
                                                                             checking for available input while decoding.
                                                                             - The maximum bytes that a single length/distance pair can output is 258
                                                                             bytes, which is the maximum length that can be coded.  inflate_fast()
                                                                             requires strm.avail_out >= 258 for each loop to avoid checking for
                                                                             output space.
                                                                             */
      module.exports = function inflate_fast(strm, start) {
        var state;
        var _in; /* local strm.input */
        var last; /* have enough input while in < last */
        var _out; /* local strm.output */
        var beg; /* inflate()'s initial strm.output */
        var end; /* while out < end, enough space available */ //#ifdef INFLATE_STRICT
        var dmax; /* maximum distance from zlib header */ //#endif
        var wsize; /* window size or zero if not using window */
        var whave; /* valid bytes in the window */
        var wnext; /* window write index */ // Use `s_window` instead `window`, avoid conflict with instrumentation tools
        var s_window; /* allocated sliding window, if wsize != 0 */
        var hold; /* local strm.hold */
        var bits; /* local strm.bits */
        var lcode; /* local strm.lencode */
        var dcode; /* local strm.distcode */
        var lmask; /* mask for first level of length codes */
        var dmask; /* mask for first level of distance codes */
        var here; /* retrieved table entry */
        var op; /* code bits, operation, extra bits, or */ /*  window position, window bytes to copy */
        var len; /* match length, unused bytes */
        var dist; /* match distance */
        var from; /* where to copy match from */
        var from_source;
        var input, output; // JS specific, because we have no pointers
        /* copy state to local variables */
        state = strm.state; //here = state.here;
        _in = strm.next_in;
        input = strm.input;
        last = _in + (strm.avail_in - 5);
        _out = strm.next_out;
        output = strm.output;
        beg = _out - (start - strm.avail_out);
        end = _out + (strm.avail_out - 257); //#ifdef INFLATE_STRICT
        dmax = state.dmax; //#endif
        wsize = state.wsize;
        whave = state.whave;
        wnext = state.wnext;
        s_window = state.window;
        hold = state.hold;
        bits = state.bits;
        lcode = state.lencode;
        dcode = state.distcode;
        lmask = (1 << state.lenbits) - 1;
        dmask = (1 << state.distbits) - 1; /* decode literals and length/distances until end-of-block or not enough
                                           input data or output space */
        top: do {
          if (bits < 15) {
            hold += input[_in++] << bits;
            bits += 8;
            hold += input[_in++] << bits;
            bits += 8;
          }
          here = lcode[hold & lmask];
          dolen: for (;;) {
            // Goto emulation
            op = here >>> 24 /*here.bits*/;
            hold >>>= op;
            bits -= op;
            op = here >>> 16 & 0xff /*here.op*/;
            if (op === 0) {
              /* literal */ //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
              //        "inflate:         literal '%c'\n" :
              //        "inflate:         literal 0x%02x\n", here.val));
              output[_out++] = here & 0xffff /*here.val*/;
            } else if (op & 16) {
              /* length base */len = here & 0xffff /*here.val*/;
              op &= 15; /* number of extra bits */
              if (op) {
                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;
                }
                len += hold & (1 << op) - 1;
                hold >>>= op;
                bits -= op;
              } //Tracevv((stderr, "inflate:         length %u\n", len));
              if (bits < 15) {
                hold += input[_in++] << bits;
                bits += 8;
                hold += input[_in++] << bits;
                bits += 8;
              }
              here = dcode[hold & dmask];
              dodist: for (;;) {
                // goto emulation
                op = here >>> 24 /*here.bits*/;
                hold >>>= op;
                bits -= op;
                op = here >>> 16 & 0xff /*here.op*/;
                if (op & 16) {
                  /* distance base */dist = here & 0xffff /*here.val*/;
                  op &= 15; /* number of extra bits */
                  if (bits < op) {
                    hold += input[_in++] << bits;
                    bits += 8;
                    if (bits < op) {
                      hold += input[_in++] << bits;
                      bits += 8;
                    }
                  }
                  dist += hold & (1 << op) - 1; //#ifdef INFLATE_STRICT
                  if (dist > dmax) {
                    strm.msg = 'invalid distance too far back';
                    state.mode = BAD;
                    break top;
                  } //#endif
                  hold >>>= op;
                  bits -= op; //Tracevv((stderr, "inflate:         distance %u\n", dist));
                  op = _out - beg; /* max distance in output */
                  if (dist > op) {
                    /* see if copy from window */op = dist - op; /* distance back in window */
                    if (op > whave) {
                      if (state.sane) {
                        strm.msg = 'invalid distance too far back';
                        state.mode = BAD;
                        break top;
                      } // (!) This block is disabled in zlib defaults,
                      // don't enable it for binary compatibility
                      //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                      //                if (len <= op - whave) {
                      //                  do {
                      //                    output[_out++] = 0;
                      //                  } while (--len);
                      //                  continue top;
                      //                }
                      //                len -= op - whave;
                      //                do {
                      //                  output[_out++] = 0;
                      //                } while (--op > whave);
                      //                if (op === 0) {
                      //                  from = _out - dist;
                      //                  do {
                      //                    output[_out++] = output[from++];
                      //                  } while (--len);
                      //                  continue top;
                      //                }
                      //#endif
                    }
                    from = 0; // window index
                    from_source = s_window;
                    if (wnext === 0) {
                      /* very common case */from += wsize - op;
                      if (op < len) {
                        /* some from window */len -= op;
                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);
                        from = _out - dist; /* rest from output */
                        from_source = output;
                      }
                    } else if (wnext < op) {
                      /* wrap around window */from += wsize + wnext - op;
                      op -= wnext;
                      if (op < len) {
                        /* some from end of window */len -= op;
                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);
                        from = 0;
                        if (wnext < len) {
                          /* some from start of window */op = wnext;
                          len -= op;
                          do {
                            output[_out++] = s_window[from++];
                          } while (--op);
                          from = _out - dist; /* rest from output */
                          from_source = output;
                        }
                      }
                    } else {
                      /* contiguous in window */from += wnext - op;
                      if (op < len) {
                        /* some from window */len -= op;
                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);
                        from = _out - dist; /* rest from output */
                        from_source = output;
                      }
                    }
                    while (len > 2) {
                      output[_out++] = from_source[from++];
                      output[_out++] = from_source[from++];
                      output[_out++] = from_source[from++];
                      len -= 3;
                    }
                    if (len) {
                      output[_out++] = from_source[from++];
                      if (len > 1) {
                        output[_out++] = from_source[from++];
                      }
                    }
                  } else {
                    from = _out - dist; /* copy direct from output */
                    do {
                      /* minimum length is three */output[_out++] = output[from++];
                      output[_out++] = output[from++];
                      output[_out++] = output[from++];
                      len -= 3;
                    } while (len > 2);
                    if (len) {
                      output[_out++] = output[from++];
                      if (len > 1) {
                        output[_out++] = output[from++];
                      }
                    }
                  }
                } else if ((op & 64) === 0) {
                  /* 2nd level distance code */here = dcode[(here & 0xffff) + (/*here.val*/hold & (1 << op) - 1)];
                  continue dodist;
                } else {
                  strm.msg = 'invalid distance code';
                  state.mode = BAD;
                  break top;
                }
                break; // need to emulate goto via "continue"
              }
            } else if ((op & 64) === 0) {
              /* 2nd level length code */here = lcode[(here & 0xffff) + (/*here.val*/hold & (1 << op) - 1)];
              continue dolen;
            } else if (op & 32) {
              /* end-of-block */ //Tracevv((stderr, "inflate:         end of block\n"));
              state.mode = TYPE;
              break top;
            } else {
              strm.msg = 'invalid literal/length code';
              state.mode = BAD;
              break top;
            }
            break; // need to emulate goto via "continue"
          }
        } while (_in < last && _out < end); /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
        len = bits >> 3;
        _in -= len;
        bits -= len << 3;
        hold &= (1 << bits) - 1; /* update state and return */
        strm.next_in = _in;
        strm.next_out = _out;
        strm.avail_in = _in < last ? 5 + (last - _in) : 5 - (_in - last);
        strm.avail_out = _out < end ? 257 + (end - _out) : 257 - (_out - end);
        state.hold = hold;
        state.bits = bits;
        return;
      };
    }, {}],
    62: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      var utils = require('../utils/common');
      var adler32 = require('./adler32');
      var crc32 = require('./crc32');
      var inflate_fast = require('./inffast');
      var inflate_table = require('./inftrees');
      var CODES = 0;
      var LENS = 1;
      var DISTS = 2; /* Public constants ==========================================================*/ /* ===========================================================================*/ /* Allowed flush values; see deflate() and inflate() below for details */ //var Z_NO_FLUSH      = 0;
      //var Z_PARTIAL_FLUSH = 1;
      //var Z_SYNC_FLUSH    = 2;
      //var Z_FULL_FLUSH    = 3;
      var Z_FINISH = 4;
      var Z_BLOCK = 5;
      var Z_TREES = 6; /* Return codes for the compression/decompression functions. Negative values
                       * are errors, positive values are used for special but normal events.
                       */
      var Z_OK = 0;
      var Z_STREAM_END = 1;
      var Z_NEED_DICT = 2; //var Z_ERRNO         = -1;
      var Z_STREAM_ERROR = -2;
      var Z_DATA_ERROR = -3;
      var Z_MEM_ERROR = -4;
      var Z_BUF_ERROR = -5; //var Z_VERSION_ERROR = -6;
      /* The deflate compression method */
      var Z_DEFLATED = 8; /* STATES ====================================================================*/ /* ===========================================================================*/
      var HEAD = 1; /* i: waiting for magic header */
      var FLAGS = 2; /* i: waiting for method and flags (gzip) */
      var TIME = 3; /* i: waiting for modification time (gzip) */
      var OS = 4; /* i: waiting for extra flags and operating system (gzip) */
      var EXLEN = 5; /* i: waiting for extra length (gzip) */
      var EXTRA = 6; /* i: waiting for extra bytes (gzip) */
      var NAME = 7; /* i: waiting for end of file name (gzip) */
      var COMMENT = 8; /* i: waiting for end of comment (gzip) */
      var HCRC = 9; /* i: waiting for header crc (gzip) */
      var DICTID = 10; /* i: waiting for dictionary check value */
      var DICT = 11; /* waiting for inflateSetDictionary() call */
      var TYPE = 12; /* i: waiting for type bits, including last-flag bit */
      var TYPEDO = 13; /* i: same, but skip check to exit inflate on new block */
      var STORED = 14; /* i: waiting for stored size (length and complement) */
      var COPY_ = 15; /* i/o: same as COPY below, but only first time in */
      var COPY = 16; /* i/o: waiting for input or output to copy stored block */
      var TABLE = 17; /* i: waiting for dynamic block table lengths */
      var LENLENS = 18; /* i: waiting for code length code lengths */
      var CODELENS = 19; /* i: waiting for length/lit and distance code lengths */
      var LEN_ = 20; /* i: same as LEN below, but only first time in */
      var LEN = 21; /* i: waiting for length/lit/eob code */
      var LENEXT = 22; /* i: waiting for length extra bits */
      var DIST = 23; /* i: waiting for distance code */
      var DISTEXT = 24; /* i: waiting for distance extra bits */
      var MATCH = 25; /* o: waiting for output space to copy string */
      var LIT = 26; /* o: waiting for output space to write literal */
      var CHECK = 27; /* i: waiting for 32-bit check value */
      var LENGTH = 28; /* i: waiting for 32-bit length (gzip) */
      var DONE = 29; /* finished check, done -- remain here until reset */
      var BAD = 30; /* got a data error -- remain here until reset */
      var MEM = 31; /* got an inflate() memory error -- remain here until reset */
      var SYNC = 32; /* looking for synchronization bytes to restart inflate() */ /* ===========================================================================*/
      var ENOUGH_LENS = 852;
      var ENOUGH_DISTS = 592; //var ENOUGH =  (ENOUGH_LENS+ENOUGH_DISTS);
      var MAX_WBITS = 15; /* 32K LZ77 window */
      var DEF_WBITS = MAX_WBITS;
      function zswap32(q) {
        return (q >>> 24 & 0xff) + (q >>> 8 & 0xff00) + ((q & 0xff00) << 8) + ((q & 0xff) << 24);
      }
      function InflateState() {
        this.mode = 0; /* current inflate mode */
        this.last = false; /* true if processing last block */
        this.wrap = 0; /* bit 0 true for zlib, bit 1 true for gzip */
        this.havedict = false; /* true if dictionary provided */
        this.flags = 0; /* gzip header method and flags (0 if zlib) */
        this.dmax = 0; /* zlib header max distance (INFLATE_STRICT) */
        this.check = 0; /* protected copy of check value */
        this.total = 0; /* protected copy of output count */ // TODO: may be {}
        this.head = null; /* where to save gzip header information */ /* sliding window */
        this.wbits = 0; /* log base 2 of requested window size */
        this.wsize = 0; /* window size or zero if not using window */
        this.whave = 0; /* valid bytes in the window */
        this.wnext = 0; /* window write index */
        this.window = null; /* allocated sliding window, if needed */ /* bit accumulator */
        this.hold = 0; /* input bit accumulator */
        this.bits = 0; /* number of bits in "in" */ /* for string and stored block copying */
        this.length = 0; /* literal or length of data to copy */
        this.offset = 0; /* distance back to copy string from */ /* for table and code decoding */
        this.extra = 0; /* extra bits needed */ /* fixed and dynamic code tables */
        this.lencode = null; /* starting table for length/literal codes */
        this.distcode = null; /* starting table for distance codes */
        this.lenbits = 0; /* index bits for lencode */
        this.distbits = 0; /* index bits for distcode */ /* dynamic table building */
        this.ncode = 0; /* number of code length code lengths */
        this.nlen = 0; /* number of length code lengths */
        this.ndist = 0; /* number of distance code lengths */
        this.have = 0; /* number of code lengths in lens[] */
        this.next = null; /* next available space in codes[] */
        this.lens = new utils.Buf16(320); /* temporary storage for code lengths */
        this.work = new utils.Buf16(288); /* work area for code table building */ /*
                                                                                  because we don't have pointers in js, we use lencode and distcode directly
                                                                                  as buffers so we don't need codes
                                                                                  */ //this.codes = new utils.Buf32(ENOUGH);       /* space for code tables */
        this.lendyn = null; /* dynamic table for length/literal codes (JS specific) */
        this.distdyn = null; /* dynamic table for distance codes (JS specific) */
        this.sane = 0; /* if false, allow invalid distance too far */
        this.back = 0; /* bits back of last unprocessed length/lit */
        this.was = 0; /* initial length of match */
      }
      function inflateResetKeep(strm) {
        var state;
        if (!strm || !strm.state) {
          return Z_STREAM_ERROR;
        }
        state = strm.state;
        strm.total_in = strm.total_out = state.total = 0;
        strm.msg = ''; /*Z_NULL*/
        if (state.wrap) {
          /* to support ill-conceived Java test suite */strm.adler = state.wrap & 1;
        }
        state.mode = HEAD;
        state.last = 0;
        state.havedict = 0;
        state.dmax = 32768;
        state.head = null /*Z_NULL*/;
        state.hold = 0;
        state.bits = 0; //state.lencode = state.distcode = state.next = state.codes;
        state.lencode = state.lendyn = new utils.Buf32(ENOUGH_LENS);
        state.distcode = state.distdyn = new utils.Buf32(ENOUGH_DISTS);
        state.sane = 1;
        state.back = -1; //Tracev((stderr, "inflate: reset\n"));
        return Z_OK;
      }
      function inflateReset(strm) {
        var state;
        if (!strm || !strm.state) {
          return Z_STREAM_ERROR;
        }
        state = strm.state;
        state.wsize = 0;
        state.whave = 0;
        state.wnext = 0;
        return inflateResetKeep(strm);
      }
      function inflateReset2(strm, windowBits) {
        var wrap;
        var state; /* get the state */
        if (!strm || !strm.state) {
          return Z_STREAM_ERROR;
        }
        state = strm.state; /* extract wrap request from windowBits parameter */
        if (windowBits < 0) {
          wrap = 0;
          windowBits = -windowBits;
        } else {
          wrap = (windowBits >> 4) + 1;
          if (windowBits < 48) {
            windowBits &= 15;
          }
        } /* set number of window bits, free window if different */
        if (windowBits && (windowBits < 8 || windowBits > 15)) {
          return Z_STREAM_ERROR;
        }
        if (state.window !== null && state.wbits !== windowBits) {
          state.window = null;
        } /* update state and reset the rest of it */
        state.wrap = wrap;
        state.wbits = windowBits;
        return inflateReset(strm);
      }
      function inflateInit2(strm, windowBits) {
        var ret;
        var state;
        if (!strm) {
          return Z_STREAM_ERROR;
        } //strm.msg = Z_NULL;                 /* in case we return an error */
        state = new InflateState(); //if (state === Z_NULL) return Z_MEM_ERROR;
        //Tracev((stderr, "inflate: allocated\n"));
        strm.state = state;
        state.window = null /*Z_NULL*/;
        ret = inflateReset2(strm, windowBits);
        if (ret !== Z_OK) {
          strm.state = null /*Z_NULL*/;
        }
        return ret;
      }
      function inflateInit(strm) {
        return inflateInit2(strm, DEF_WBITS);
      } /*
        Return state with length and distance decoding tables and index sizes set to
        fixed code decoding.  Normally this returns fixed tables from inffixed.h.
        If BUILDFIXED is defined, then instead this routine builds the tables the
        first time it's called, and returns those tables the first time and
        thereafter.  This reduces the size of the code by about 2K bytes, in
        exchange for a little execution time.  However, BUILDFIXED should not be
        used for threaded applications, since the rewriting of the tables and virgin
        may not be thread-safe.
        */
      var virgin = true;
      var lenfix, distfix; // We have no pointers in JS, so keep tables separate
      function fixedtables(state) {
        /* build fixed huffman tables if first call (may not be thread safe) */if (virgin) {
          var sym;
          lenfix = new utils.Buf32(512);
          distfix = new utils.Buf32(32); /* literal/length table */
          sym = 0;
          while (sym < 144) {
            state.lens[sym++] = 8;
          }
          while (sym < 256) {
            state.lens[sym++] = 9;
          }
          while (sym < 280) {
            state.lens[sym++] = 7;
          }
          while (sym < 288) {
            state.lens[sym++] = 8;
          }
          inflate_table(LENS, state.lens, 0, 288, lenfix, 0, state.work, {
            bits: 9
          }); /* distance table */
          sym = 0;
          while (sym < 32) {
            state.lens[sym++] = 5;
          }
          inflate_table(DISTS, state.lens, 0, 32, distfix, 0, state.work, {
            bits: 5
          }); /* do this just once */
          virgin = false;
        }
        state.lencode = lenfix;
        state.lenbits = 9;
        state.distcode = distfix;
        state.distbits = 5;
      } /*
        Update the window with the last wsize (normally 32K) bytes written before
        returning.  If window does not exist yet, create it.  This is only called
        when a window is already in use, or when output has been written during this
        inflate call, but the end of the deflate stream has not been reached yet.
        It is also called to create a window for dictionary data when a dictionary
        is loaded.
        Providing output buffers larger than 32K to inflate() should provide a speed
        advantage, since only the last 32K of output is copied to the sliding window
        upon return from inflate(), and since all distances after the first 32K of
        output will fall in the output data, making match copies simpler and faster.
        The advantage may be dependent on the size of the processor's data caches.
        */
      function updatewindow(strm, src, end, copy) {
        var dist;
        var state = strm.state; /* if it hasn't been done already, allocate space for the window */
        if (state.window === null) {
          state.wsize = 1 << state.wbits;
          state.wnext = 0;
          state.whave = 0;
          state.window = new utils.Buf8(state.wsize);
        } /* copy state->wsize or less output bytes into the circular window */
        if (copy >= state.wsize) {
          utils.arraySet(state.window, src, end - state.wsize, state.wsize, 0);
          state.wnext = 0;
          state.whave = state.wsize;
        } else {
          dist = state.wsize - state.wnext;
          if (dist > copy) {
            dist = copy;
          } //zmemcpy(state->window + state->wnext, end - copy, dist);
          utils.arraySet(state.window, src, end - copy, dist, state.wnext);
          copy -= dist;
          if (copy) {
            //zmemcpy(state->window, end - copy, copy);
            utils.arraySet(state.window, src, end - copy, copy, 0);
            state.wnext = copy;
            state.whave = state.wsize;
          } else {
            state.wnext += dist;
            if (state.wnext === state.wsize) {
              state.wnext = 0;
            }
            if (state.whave < state.wsize) {
              state.whave += dist;
            }
          }
        }
        return 0;
      }
      function inflate(strm, flush) {
        var state;
        var input, output; // input/output buffers
        var next; /* next input INDEX */
        var put; /* next output INDEX */
        var have, left; /* available input and output */
        var hold; /* bit buffer */
        var bits; /* bits in bit buffer */
        var _in, _out; /* save starting available input and output */
        var copy; /* number of stored or match bytes to copy */
        var from; /* where to copy match bytes from */
        var from_source;
        var here = 0; /* current decoding table entry */
        var here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
        //var last;                   /* parent table entry */
        var last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
        var len; /* length to copy for repeats, bits to drop */
        var ret; /* return code */
        var hbuf = new utils.Buf8(4); /* buffer for gzip header crc calculation */
        var opts;
        var n; // temporary var for NEED_BITS
        var order = /* permutation of code lengths */[16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
        if (!strm || !strm.state || !strm.output || !strm.input && strm.avail_in !== 0) {
          return Z_STREAM_ERROR;
        }
        state = strm.state;
        if (state.mode === TYPE) {
          state.mode = TYPEDO;
        } /* skip check */ //--- LOAD() ---
        put = strm.next_out;
        output = strm.output;
        left = strm.avail_out;
        next = strm.next_in;
        input = strm.input;
        have = strm.avail_in;
        hold = state.hold;
        bits = state.bits; //---
        _in = have;
        _out = left;
        ret = Z_OK;
        inf_leave:
        // goto emulation
        for (;;) {
          switch (state.mode) {
            case HEAD:
              if (state.wrap === 0) {
                state.mode = TYPEDO;
                break;
              } //=== NEEDBITS(16);
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              if (state.wrap & 2 && hold === 0x8b1f) {
                /* gzip header */state.check = 0 /*crc32(0L, Z_NULL, 0)*/; //=== CRC2(state.check, hold);
                hbuf[0] = hold & 0xff;
                hbuf[1] = hold >>> 8 & 0xff;
                state.check = crc32(state.check, hbuf, 2, 0); //===//
                //=== INITBITS();
                hold = 0;
                bits = 0; //===//
                state.mode = FLAGS;
                break;
              }
              state.flags = 0; /* expect zlib header */
              if (state.head) {
                state.head.done = false;
              }
              if (!(state.wrap & 1) || /* check if zlib header allowed */(((hold & 0xff) << /*BITS(8)*/8) + (hold >> 8)) % 31) {
                strm.msg = 'incorrect header check';
                state.mode = BAD;
                break;
              }
              if ((hold & 0x0f) !== /*BITS(4)*/Z_DEFLATED) {
                strm.msg = 'unknown compression method';
                state.mode = BAD;
                break;
              } //--- DROPBITS(4) ---//
              hold >>>= 4;
              bits -= 4; //---//
              len = (hold & 0x0f) + /*BITS(4)*/8;
              if (state.wbits === 0) {
                state.wbits = len;
              } else if (len > state.wbits) {
                strm.msg = 'invalid window size';
                state.mode = BAD;
                break;
              }
              state.dmax = 1 << len; //Tracev((stderr, "inflate:   zlib header ok\n"));
              strm.adler = state.check = 1 /*adler32(0L, Z_NULL, 0)*/;
              state.mode = hold & 0x200 ? DICTID : TYPE; //=== INITBITS();
              hold = 0;
              bits = 0; //===//
              break;
            case FLAGS:
              //=== NEEDBITS(16); */
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              state.flags = hold;
              if ((state.flags & 0xff) !== Z_DEFLATED) {
                strm.msg = 'unknown compression method';
                state.mode = BAD;
                break;
              }
              if (state.flags & 0xe000) {
                strm.msg = 'unknown header flags set';
                state.mode = BAD;
                break;
              }
              if (state.head) {
                state.head.text = hold >> 8 & 1;
              }
              if (state.flags & 0x0200) {
                //=== CRC2(state.check, hold);
                hbuf[0] = hold & 0xff;
                hbuf[1] = hold >>> 8 & 0xff;
                state.check = crc32(state.check, hbuf, 2, 0); //===//
              } //=== INITBITS();
              hold = 0;
              bits = 0; //===//
              state.mode = TIME;
            /* falls through */
            case TIME:
              //=== NEEDBITS(32); */
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              if (state.head) {
                state.head.time = hold;
              }
              if (state.flags & 0x0200) {
                //=== CRC4(state.check, hold)
                hbuf[0] = hold & 0xff;
                hbuf[1] = hold >>> 8 & 0xff;
                hbuf[2] = hold >>> 16 & 0xff;
                hbuf[3] = hold >>> 24 & 0xff;
                state.check = crc32(state.check, hbuf, 4, 0); //===
              } //=== INITBITS();
              hold = 0;
              bits = 0; //===//
              state.mode = OS;
            /* falls through */
            case OS:
              //=== NEEDBITS(16); */
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              if (state.head) {
                state.head.xflags = hold & 0xff;
                state.head.os = hold >> 8;
              }
              if (state.flags & 0x0200) {
                //=== CRC2(state.check, hold);
                hbuf[0] = hold & 0xff;
                hbuf[1] = hold >>> 8 & 0xff;
                state.check = crc32(state.check, hbuf, 2, 0); //===//
              } //=== INITBITS();
              hold = 0;
              bits = 0; //===//
              state.mode = EXLEN;
            /* falls through */
            case EXLEN:
              if (state.flags & 0x0400) {
                //=== NEEDBITS(16); */
                while (bits < 16) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                } //===//
                state.length = hold;
                if (state.head) {
                  state.head.extra_len = hold;
                }
                if (state.flags & 0x0200) {
                  //=== CRC2(state.check, hold);
                  hbuf[0] = hold & 0xff;
                  hbuf[1] = hold >>> 8 & 0xff;
                  state.check = crc32(state.check, hbuf, 2, 0); //===//
                } //=== INITBITS();
                hold = 0;
                bits = 0; //===//
              } else if (state.head) {
                state.head.extra = null /*Z_NULL*/;
              }
              state.mode = EXTRA;
            /* falls through */
            case EXTRA:
              if (state.flags & 0x0400) {
                copy = state.length;
                if (copy > have) {
                  copy = have;
                }
                if (copy) {
                  if (state.head) {
                    len = state.head.extra_len - state.length;
                    if (!state.head.extra) {
                      // Use untyped array for more convenient processing later
                      state.head.extra = new Array(state.head.extra_len);
                    }
                    utils.arraySet(state.head.extra, input, next,
                    // extra field is limited to 65536 bytes
                    // - no need for additional size check
                    copy, /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/len); //zmemcpy(state.head.extra + len, next,
                    //        len + copy > state.head.extra_max ?
                    //        state.head.extra_max - len : copy);
                  }
                  if (state.flags & 0x0200) {
                    state.check = crc32(state.check, input, copy, next);
                  }
                  have -= copy;
                  next += copy;
                  state.length -= copy;
                }
                if (state.length) {
                  break inf_leave;
                }
              }
              state.length = 0;
              state.mode = NAME;
            /* falls through */
            case NAME:
              if (state.flags & 0x0800) {
                if (have === 0) {
                  break inf_leave;
                }
                copy = 0;
                do {
                  // TODO: 2 or 1 bytes?
                  len = input[next + copy++]; /* use constant limit because in js we should not preallocate memory */
                  if (state.head && len && state.length < 65536 /*state.head.name_max*/) {
                    state.head.name += String.fromCharCode(len);
                  }
                } while (len && copy < have);
                if (state.flags & 0x0200) {
                  state.check = crc32(state.check, input, copy, next);
                }
                have -= copy;
                next += copy;
                if (len) {
                  break inf_leave;
                }
              } else if (state.head) {
                state.head.name = null;
              }
              state.length = 0;
              state.mode = COMMENT;
            /* falls through */
            case COMMENT:
              if (state.flags & 0x1000) {
                if (have === 0) {
                  break inf_leave;
                }
                copy = 0;
                do {
                  len = input[next + copy++]; /* use constant limit because in js we should not preallocate memory */
                  if (state.head && len && state.length < 65536 /*state.head.comm_max*/) {
                    state.head.comment += String.fromCharCode(len);
                  }
                } while (len && copy < have);
                if (state.flags & 0x0200) {
                  state.check = crc32(state.check, input, copy, next);
                }
                have -= copy;
                next += copy;
                if (len) {
                  break inf_leave;
                }
              } else if (state.head) {
                state.head.comment = null;
              }
              state.mode = HCRC;
            /* falls through */
            case HCRC:
              if (state.flags & 0x0200) {
                //=== NEEDBITS(16); */
                while (bits < 16) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                } //===//
                if (hold !== (state.check & 0xffff)) {
                  strm.msg = 'header crc mismatch';
                  state.mode = BAD;
                  break;
                } //=== INITBITS();
                hold = 0;
                bits = 0; //===//
              }
              if (state.head) {
                state.head.hcrc = state.flags >> 9 & 1;
                state.head.done = true;
              }
              strm.adler = state.check = 0;
              state.mode = TYPE;
              break;
            case DICTID:
              //=== NEEDBITS(32); */
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              strm.adler = state.check = zswap32(hold); //=== INITBITS();
              hold = 0;
              bits = 0; //===//
              state.mode = DICT;
            /* falls through */
            case DICT:
              if (state.havedict === 0) {
                //--- RESTORE() ---
                strm.next_out = put;
                strm.avail_out = left;
                strm.next_in = next;
                strm.avail_in = have;
                state.hold = hold;
                state.bits = bits; //---
                return Z_NEED_DICT;
              }
              strm.adler = state.check = 1 /*adler32(0L, Z_NULL, 0)*/;
              state.mode = TYPE;
            /* falls through */
            case TYPE:
              if (flush === Z_BLOCK || flush === Z_TREES) {
                break inf_leave;
              }
            /* falls through */
            case TYPEDO:
              if (state.last) {
                //--- BYTEBITS() ---//
                hold >>>= bits & 7;
                bits -= bits & 7; //---//
                state.mode = CHECK;
                break;
              } //=== NEEDBITS(3); */
              while (bits < 3) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              state.last = hold & 0x01 /*BITS(1)*/; //--- DROPBITS(1) ---//
              hold >>>= 1;
              bits -= 1; //---//
              switch (hold & 0x03) {
                /*BITS(2)*/case 0:
                  /* stored block */ //Tracev((stderr, "inflate:     stored block%s\n",
                  //        state.last ? " (last)" : ""));
                  state.mode = STORED;
                  break;
                case 1:
                  /* fixed block */fixedtables(state); //Tracev((stderr, "inflate:     fixed codes block%s\n",
                  //        state.last ? " (last)" : ""));
                  state.mode = LEN_; /* decode codes */
                  if (flush === Z_TREES) {
                    //--- DROPBITS(2) ---//
                    hold >>>= 2;
                    bits -= 2; //---//
                    break inf_leave;
                  }
                  break;
                case 2:
                  /* dynamic block */ //Tracev((stderr, "inflate:     dynamic codes block%s\n",
                  //        state.last ? " (last)" : ""));
                  state.mode = TABLE;
                  break;
                case 3:
                  strm.msg = 'invalid block type';
                  state.mode = BAD;
              } //--- DROPBITS(2) ---//
              hold >>>= 2;
              bits -= 2; //---//
              break;
            case STORED:
              //--- BYTEBITS() ---// /* go to byte boundary */
              hold >>>= bits & 7;
              bits -= bits & 7; //---//
              //=== NEEDBITS(32); */
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              if ((hold & 0xffff) !== (hold >>> 16 ^ 0xffff)) {
                strm.msg = 'invalid stored block lengths';
                state.mode = BAD;
                break;
              }
              state.length = hold & 0xffff; //Tracev((stderr, "inflate:       stored length %u\n",
              //        state.length));
              //=== INITBITS();
              hold = 0;
              bits = 0; //===//
              state.mode = COPY_;
              if (flush === Z_TREES) {
                break inf_leave;
              }
            /* falls through */
            case COPY_:
              state.mode = COPY;
            /* falls through */
            case COPY:
              copy = state.length;
              if (copy) {
                if (copy > have) {
                  copy = have;
                }
                if (copy > left) {
                  copy = left;
                }
                if (copy === 0) {
                  break inf_leave;
                } //--- zmemcpy(put, next, copy); ---
                utils.arraySet(output, input, next, copy, put); //---//
                have -= copy;
                next += copy;
                left -= copy;
                put += copy;
                state.length -= copy;
                break;
              } //Tracev((stderr, "inflate:       stored end\n"));
              state.mode = TYPE;
              break;
            case TABLE:
              //=== NEEDBITS(14); */
              while (bits < 14) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              } //===//
              state.nlen = (hold & 0x1f) + /*BITS(5)*/257; //--- DROPBITS(5) ---//
              hold >>>= 5;
              bits -= 5; //---//
              state.ndist = (hold & 0x1f) + /*BITS(5)*/1; //--- DROPBITS(5) ---//
              hold >>>= 5;
              bits -= 5; //---//
              state.ncode = (hold & 0x0f) + /*BITS(4)*/4; //--- DROPBITS(4) ---//
              hold >>>= 4;
              bits -= 4; //---//
              //#ifndef PKZIP_BUG_WORKAROUND
              if (state.nlen > 286 || state.ndist > 30) {
                strm.msg = 'too many length or distance symbols';
                state.mode = BAD;
                break;
              } //#endif
              //Tracev((stderr, "inflate:       table sizes ok\n"));
              state.have = 0;
              state.mode = LENLENS;
            /* falls through */
            case LENLENS:
              while (state.have < state.ncode) {
                //=== NEEDBITS(3);
                while (bits < 3) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                } //===//
                state.lens[order[state.have++]] = hold & 0x07; //BITS(3);
                //--- DROPBITS(3) ---//
                hold >>>= 3;
                bits -= 3; //---//
              }
              while (state.have < 19) {
                state.lens[order[state.have++]] = 0;
              } // We have separate tables & no pointers. 2 commented lines below not needed.
              //state.next = state.codes;
              //state.lencode = state.next;
              // Switch to use dynamic table
              state.lencode = state.lendyn;
              state.lenbits = 7;
              opts = {
                bits: state.lenbits
              };
              ret = inflate_table(CODES, state.lens, 0, 19, state.lencode, 0, state.work, opts);
              state.lenbits = opts.bits;
              if (ret) {
                strm.msg = 'invalid code lengths set';
                state.mode = BAD;
                break;
              } //Tracev((stderr, "inflate:       code lengths ok\n"));
              state.have = 0;
              state.mode = CODELENS;
            /* falls through */
            case CODELENS:
              while (state.have < state.nlen + state.ndist) {
                for (;;) {
                  here = state.lencode[hold & (1 << state.lenbits) - 1]; /*BITS(state.lenbits)*/
                  here_bits = here >>> 24;
                  here_op = here >>> 16 & 0xff;
                  here_val = here & 0xffff;
                  if (here_bits <= bits) {
                    break;
                  } //--- PULLBYTE() ---//
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8; //---//
                }
                if (here_val < 16) {
                  //--- DROPBITS(here.bits) ---//
                  hold >>>= here_bits;
                  bits -= here_bits; //---//
                  state.lens[state.have++] = here_val;
                } else {
                  if (here_val === 16) {
                    //=== NEEDBITS(here.bits + 2);
                    n = here_bits + 2;
                    while (bits < n) {
                      if (have === 0) {
                        break inf_leave;
                      }
                      have--;
                      hold += input[next++] << bits;
                      bits += 8;
                    } //===//
                    //--- DROPBITS(here.bits) ---//
                    hold >>>= here_bits;
                    bits -= here_bits; //---//
                    if (state.have === 0) {
                      strm.msg = 'invalid bit length repeat';
                      state.mode = BAD;
                      break;
                    }
                    len = state.lens[state.have - 1];
                    copy = 3 + (hold & 0x03); //BITS(2);
                    //--- DROPBITS(2) ---//
                    hold >>>= 2;
                    bits -= 2; //---//
                  } else if (here_val === 17) {
                    //=== NEEDBITS(here.bits + 3);
                    n = here_bits + 3;
                    while (bits < n) {
                      if (have === 0) {
                        break inf_leave;
                      }
                      have--;
                      hold += input[next++] << bits;
                      bits += 8;
                    } //===//
                    //--- DROPBITS(here.bits) ---//
                    hold >>>= here_bits;
                    bits -= here_bits; //---//
                    len = 0;
                    copy = 3 + (hold & 0x07); //BITS(3);
                    //--- DROPBITS(3) ---//
                    hold >>>= 3;
                    bits -= 3; //---//
                  } else {
                    //=== NEEDBITS(here.bits + 7);
                    n = here_bits + 7;
                    while (bits < n) {
                      if (have === 0) {
                        break inf_leave;
                      }
                      have--;
                      hold += input[next++] << bits;
                      bits += 8;
                    } //===//
                    //--- DROPBITS(here.bits) ---//
                    hold >>>= here_bits;
                    bits -= here_bits; //---//
                    len = 0;
                    copy = 11 + (hold & 0x7f); //BITS(7);
                    //--- DROPBITS(7) ---//
                    hold >>>= 7;
                    bits -= 7; //---//
                  }
                  if (state.have + copy > state.nlen + state.ndist) {
                    strm.msg = 'invalid bit length repeat';
                    state.mode = BAD;
                    break;
                  }
                  while (copy--) {
                    state.lens[state.have++] = len;
                  }
                }
              } /* handle error breaks in while */
              if (state.mode === BAD) {
                break;
              } /* check for end-of-block code (better have one) */
              if (state.lens[256] === 0) {
                strm.msg = 'invalid code -- missing end-of-block';
                state.mode = BAD;
                break;
              } /* build code tables -- note: do not change the lenbits or distbits
                values here (9 and 6) without reading the comments in inftrees.h
                concerning the ENOUGH constants, which depend on those values */
              state.lenbits = 9;
              opts = {
                bits: state.lenbits
              };
              ret = inflate_table(LENS, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts); // We have separate tables & no pointers. 2 commented lines below not needed.
              // state.next_index = opts.table_index;
              state.lenbits = opts.bits; // state.lencode = state.next;
              if (ret) {
                strm.msg = 'invalid literal/lengths set';
                state.mode = BAD;
                break;
              }
              state.distbits = 6; //state.distcode.copy(state.codes);
              // Switch to use dynamic table
              state.distcode = state.distdyn;
              opts = {
                bits: state.distbits
              };
              ret = inflate_table(DISTS, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts); // We have separate tables & no pointers. 2 commented lines below not needed.
              // state.next_index = opts.table_index;
              state.distbits = opts.bits; // state.distcode = state.next;
              if (ret) {
                strm.msg = 'invalid distances set';
                state.mode = BAD;
                break;
              } //Tracev((stderr, 'inflate:       codes ok\n'));
              state.mode = LEN_;
              if (flush === Z_TREES) {
                break inf_leave;
              }
            /* falls through */
            case LEN_:
              state.mode = LEN;
            /* falls through */
            case LEN:
              if (have >= 6 && left >= 258) {
                //--- RESTORE() ---
                strm.next_out = put;
                strm.avail_out = left;
                strm.next_in = next;
                strm.avail_in = have;
                state.hold = hold;
                state.bits = bits; //---
                inflate_fast(strm, _out); //--- LOAD() ---
                put = strm.next_out;
                output = strm.output;
                left = strm.avail_out;
                next = strm.next_in;
                input = strm.input;
                have = strm.avail_in;
                hold = state.hold;
                bits = state.bits; //---
                if (state.mode === TYPE) {
                  state.back = -1;
                }
                break;
              }
              state.back = 0;
              for (;;) {
                here = state.lencode[hold & (1 << state.lenbits) - 1]; /*BITS(state.lenbits)*/
                here_bits = here >>> 24;
                here_op = here >>> 16 & 0xff;
                here_val = here & 0xffff;
                if (here_bits <= bits) {
                  break;
                } //--- PULLBYTE() ---//
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8; //---//
              }
              if (here_op && (here_op & 0xf0) === 0) {
                last_bits = here_bits;
                last_op = here_op;
                last_val = here_val;
                for (;;) {
                  here = state.lencode[last_val + ((hold & (1 << last_bits + last_op) - 1) >> /*BITS(last.bits + last.op)*/last_bits)];
                  here_bits = here >>> 24;
                  here_op = here >>> 16 & 0xff;
                  here_val = here & 0xffff;
                  if (last_bits + here_bits <= bits) {
                    break;
                  } //--- PULLBYTE() ---//
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8; //---//
                } //--- DROPBITS(last.bits) ---//
                hold >>>= last_bits;
                bits -= last_bits; //---//
                state.back += last_bits;
              } //--- DROPBITS(here.bits) ---//
              hold >>>= here_bits;
              bits -= here_bits; //---//
              state.back += here_bits;
              state.length = here_val;
              if (here_op === 0) {
                //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
                //        "inflate:         literal '%c'\n" :
                //        "inflate:         literal 0x%02x\n", here.val));
                state.mode = LIT;
                break;
              }
              if (here_op & 32) {
                //Tracevv((stderr, "inflate:         end of block\n"));
                state.back = -1;
                state.mode = TYPE;
                break;
              }
              if (here_op & 64) {
                strm.msg = 'invalid literal/length code';
                state.mode = BAD;
                break;
              }
              state.extra = here_op & 15;
              state.mode = LENEXT;
            /* falls through */
            case LENEXT:
              if (state.extra) {
                //=== NEEDBITS(state.extra);
                n = state.extra;
                while (bits < n) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                } //===//
                state.length += hold & (1 << state.extra) - 1 /*BITS(state.extra)*/; //--- DROPBITS(state.extra) ---//
                hold >>>= state.extra;
                bits -= state.extra; //---//
                state.back += state.extra;
              } //Tracevv((stderr, "inflate:         length %u\n", state.length));
              state.was = state.length;
              state.mode = DIST;
            /* falls through */
            case DIST:
              for (;;) {
                here = state.distcode[hold & (1 << state.distbits) - 1]; /*BITS(state.distbits)*/
                here_bits = here >>> 24;
                here_op = here >>> 16 & 0xff;
                here_val = here & 0xffff;
                if (here_bits <= bits) {
                  break;
                } //--- PULLBYTE() ---//
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8; //---//
              }
              if ((here_op & 0xf0) === 0) {
                last_bits = here_bits;
                last_op = here_op;
                last_val = here_val;
                for (;;) {
                  here = state.distcode[last_val + ((hold & (1 << last_bits + last_op) - 1) >> /*BITS(last.bits + last.op)*/last_bits)];
                  here_bits = here >>> 24;
                  here_op = here >>> 16 & 0xff;
                  here_val = here & 0xffff;
                  if (last_bits + here_bits <= bits) {
                    break;
                  } //--- PULLBYTE() ---//
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8; //---//
                } //--- DROPBITS(last.bits) ---//
                hold >>>= last_bits;
                bits -= last_bits; //---//
                state.back += last_bits;
              } //--- DROPBITS(here.bits) ---//
              hold >>>= here_bits;
              bits -= here_bits; //---//
              state.back += here_bits;
              if (here_op & 64) {
                strm.msg = 'invalid distance code';
                state.mode = BAD;
                break;
              }
              state.offset = here_val;
              state.extra = here_op & 15;
              state.mode = DISTEXT;
            /* falls through */
            case DISTEXT:
              if (state.extra) {
                //=== NEEDBITS(state.extra);
                n = state.extra;
                while (bits < n) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                } //===//
                state.offset += hold & (1 << state.extra) - 1 /*BITS(state.extra)*/; //--- DROPBITS(state.extra) ---//
                hold >>>= state.extra;
                bits -= state.extra; //---//
                state.back += state.extra;
              } //#ifdef INFLATE_STRICT
              if (state.offset > state.dmax) {
                strm.msg = 'invalid distance too far back';
                state.mode = BAD;
                break;
              } //#endif
              //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
              state.mode = MATCH;
            /* falls through */
            case MATCH:
              if (left === 0) {
                break inf_leave;
              }
              copy = _out - left;
              if (state.offset > copy) {
                /* copy from window */copy = state.offset - copy;
                if (copy > state.whave) {
                  if (state.sane) {
                    strm.msg = 'invalid distance too far back';
                    state.mode = BAD;
                    break;
                  } // (!) This block is disabled in zlib defaults,
                  // don't enable it for binary compatibility
                  //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                  //          Trace((stderr, "inflate.c too far\n"));
                  //          copy -= state.whave;
                  //          if (copy > state.length) { copy = state.length; }
                  //          if (copy > left) { copy = left; }
                  //          left -= copy;
                  //          state.length -= copy;
                  //          do {
                  //            output[put++] = 0;
                  //          } while (--copy);
                  //          if (state.length === 0) { state.mode = LEN; }
                  //          break;
                  //#endif
                }
                if (copy > state.wnext) {
                  copy -= state.wnext;
                  from = state.wsize - copy;
                } else {
                  from = state.wnext - copy;
                }
                if (copy > state.length) {
                  copy = state.length;
                }
                from_source = state.window;
              } else {
                /* copy from output */from_source = output;
                from = put - state.offset;
                copy = state.length;
              }
              if (copy > left) {
                copy = left;
              }
              left -= copy;
              state.length -= copy;
              do {
                output[put++] = from_source[from++];
              } while (--copy);
              if (state.length === 0) {
                state.mode = LEN;
              }
              break;
            case LIT:
              if (left === 0) {
                break inf_leave;
              }
              output[put++] = state.length;
              left--;
              state.mode = LEN;
              break;
            case CHECK:
              if (state.wrap) {
                //=== NEEDBITS(32);
                while (bits < 32) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--; // Use '|' instead of '+' to make sure that result is signed
                  hold |= input[next++] << bits;
                  bits += 8;
                } //===//
                _out -= left;
                strm.total_out += _out;
                state.total += _out;
                if (_out) {
                  strm.adler = state.check = /*UPDATE(state.check, put - _out, _out);*/state.flags ? crc32(state.check, output, _out, put - _out) : adler32(state.check, output, _out, put - _out);
                }
                _out = left; // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
                if ((state.flags ? hold : zswap32(hold)) !== state.check) {
                  strm.msg = 'incorrect data check';
                  state.mode = BAD;
                  break;
                } //=== INITBITS();
                hold = 0;
                bits = 0; //===//
                //Tracev((stderr, "inflate:   check matches trailer\n"));
              }
              state.mode = LENGTH;
            /* falls through */
            case LENGTH:
              if (state.wrap && state.flags) {
                //=== NEEDBITS(32);
                while (bits < 32) {
                  if (have === 0) {
                    break inf_leave;
                  }
                  have--;
                  hold += input[next++] << bits;
                  bits += 8;
                } //===//
                if (hold !== (state.total & 0xffffffff)) {
                  strm.msg = 'incorrect length check';
                  state.mode = BAD;
                  break;
                } //=== INITBITS();
                hold = 0;
                bits = 0; //===//
                //Tracev((stderr, "inflate:   length matches trailer\n"));
              }
              state.mode = DONE;
            /* falls through */
            case DONE:
              ret = Z_STREAM_END;
              break inf_leave;
            case BAD:
              ret = Z_DATA_ERROR;
              break inf_leave;
            case MEM:
              return Z_MEM_ERROR;
            case SYNC: /* falls through */
            default:
              return Z_STREAM_ERROR;
          }
        } // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"
        /*
             Return from inflate(), updating the total counts and the check value.
             If there was no progress during the inflate() call, return a buffer
             error.  Call updatewindow() to create and/or update the window state.
             Note: a memory error from inflate() is non-recoverable.
           */ //--- RESTORE() ---
        strm.next_out = put;
        strm.avail_out = left;
        strm.next_in = next;
        strm.avail_in = have;
        state.hold = hold;
        state.bits = bits; //---
        if (state.wsize || _out !== strm.avail_out && state.mode < BAD && (state.mode < CHECK || flush !== Z_FINISH)) {
          if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) {
            state.mode = MEM;
            return Z_MEM_ERROR;
          }
        }
        _in -= strm.avail_in;
        _out -= strm.avail_out;
        strm.total_in += _in;
        strm.total_out += _out;
        state.total += _out;
        if (state.wrap && _out) {
          strm.adler = state.check = /*UPDATE(state.check, strm.next_out - _out, _out);*/state.flags ? crc32(state.check, output, _out, strm.next_out - _out) : adler32(state.check, output, _out, strm.next_out - _out);
        }
        strm.data_type = state.bits + (state.last ? 64 : 0) + (state.mode === TYPE ? 128 : 0) + (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
        if ((_in === 0 && _out === 0 || flush === Z_FINISH) && ret === Z_OK) {
          ret = Z_BUF_ERROR;
        }
        return ret;
      }
      function inflateEnd(strm) {
        if (!strm || !strm.state /*|| strm->zfree == (free_func)0*/) {
          return Z_STREAM_ERROR;
        }
        var state = strm.state;
        if (state.window) {
          state.window = null;
        }
        strm.state = null;
        return Z_OK;
      }
      function inflateGetHeader(strm, head) {
        var state; /* check state */
        if (!strm || !strm.state) {
          return Z_STREAM_ERROR;
        }
        state = strm.state;
        if ((state.wrap & 2) === 0) {
          return Z_STREAM_ERROR;
        } /* save header structure */
        state.head = head;
        head.done = false;
        return Z_OK;
      }
      function inflateSetDictionary(strm, dictionary) {
        var dictLength = dictionary.length;
        var state;
        var dictid;
        var ret; /* check state */
        if (!strm /* == Z_NULL */ || !strm.state /* == Z_NULL */) {
          return Z_STREAM_ERROR;
        }
        state = strm.state;
        if (state.wrap !== 0 && state.mode !== DICT) {
          return Z_STREAM_ERROR;
        } /* check for correct dictionary identifier */
        if (state.mode === DICT) {
          dictid = 1; /* adler32(0, null, 0)*/ /* dictid = adler32(dictid, dictionary, dictLength); */
          dictid = adler32(dictid, dictionary, dictLength, 0);
          if (dictid !== state.check) {
            return Z_DATA_ERROR;
          }
        } /* copy dictionary to window using updatewindow(), which will amend the
          existing dictionary if appropriate */
        ret = updatewindow(strm, dictionary, dictLength, dictLength);
        if (ret) {
          state.mode = MEM;
          return Z_MEM_ERROR;
        }
        state.havedict = 1; // Tracev((stderr, "inflate:   dictionary set\n"));
        return Z_OK;
      }
      exports.inflateReset = inflateReset;
      exports.inflateReset2 = inflateReset2;
      exports.inflateResetKeep = inflateResetKeep;
      exports.inflateInit = inflateInit;
      exports.inflateInit2 = inflateInit2;
      exports.inflate = inflate;
      exports.inflateEnd = inflateEnd;
      exports.inflateGetHeader = inflateGetHeader;
      exports.inflateSetDictionary = inflateSetDictionary;
      exports.inflateInfo = 'pako inflate (from Nodeca project)'; /* Not implemented
                                                                  exports.inflateCopy = inflateCopy;
                                                                  exports.inflateGetDictionary = inflateGetDictionary;
                                                                  exports.inflateMark = inflateMark;
                                                                  exports.inflatePrime = inflatePrime;
                                                                  exports.inflateSync = inflateSync;
                                                                  exports.inflateSyncPoint = inflateSyncPoint;
                                                                  exports.inflateUndermine = inflateUndermine;
                                                                  */
    }, {
      "../utils/common": 54,
      "./adler32": 56,
      "./crc32": 58,
      "./inffast": 61,
      "./inftrees": 63
    }],
    63: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      var utils = require('../utils/common');
      var MAXBITS = 15;
      var ENOUGH_LENS = 852;
      var ENOUGH_DISTS = 592; //var ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);
      var CODES = 0;
      var LENS = 1;
      var DISTS = 2;
      var lbase = [/* Length codes 257..285 base */3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0];
      var lext = [/* Length codes 257..285 extra */16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78];
      var dbase = [/* Distance codes 0..29 base */1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577, 0, 0];
      var dext = [/* Distance codes 0..29 extra */16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 64, 64];
      module.exports = function inflate_table(type, lens, lens_index, codes, table, table_index, work, opts) {
        var bits = opts.bits; //here = opts.here; /* table entry for duplication */
        var len = 0; /* a code's length in bits */
        var sym = 0; /* index of code symbols */
        var min = 0,
          max = 0; /* minimum and maximum code lengths */
        var root = 0; /* number of index bits for root table */
        var curr = 0; /* number of index bits for current table */
        var drop = 0; /* code bits to drop for sub-table */
        var left = 0; /* number of prefix codes available */
        var used = 0; /* code entries in table used */
        var huff = 0; /* Huffman code */
        var incr; /* for incrementing code, index */
        var fill; /* index for replicating entries */
        var low; /* low bits for current root entry */
        var mask; /* mask for low root bits */
        var next; /* next available space in table */
        var base = null; /* base value table to use */
        var base_index = 0; //  var shoextra;    /* extra bits table to use */
        var end; /* use base and extra for symbol > end */
        var count = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
        var offs = new utils.Buf16(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
        var extra = null;
        var extra_index = 0;
        var here_bits, here_op, here_val; /*
                                          Process a set of code lengths to create a canonical Huffman code.  The
                                          code lengths are lens[0..codes-1].  Each length corresponds to the
                                          symbols 0..codes-1.  The Huffman code is generated by first sorting the
                                          symbols by length from short to long, and retaining the symbol order
                                          for codes with equal lengths.  Then the code starts with all zero bits
                                          for the first code of the shortest length, and the codes are integer
                                          increments for the same length, and zeros are appended as the length
                                          increases.  For the deflate format, these bits are stored backwards
                                          from their more natural integer increment ordering, and so when the
                                          decoding tables are built in the large loop below, the integer codes
                                          are incremented backwards.
                                          This routine assumes, but does not check, that all of the entries in
                                          lens[] are in the range 0..MAXBITS.  The caller must assure this.
                                          1..MAXBITS is interpreted as that code length.  zero means that that
                                          symbol does not occur in this code.
                                          The codes are sorted by computing a count of codes for each length,
                                          creating from that a table of starting indices for each length in the
                                          sorted table, and then entering the symbols in order in the sorted
                                          table.  The sorted table is work[], with that space being provided by
                                          the caller.
                                          The length counts are used for other purposes as well, i.e. finding
                                          the minimum and maximum length codes, determining if there are any
                                          codes at all, checking for a valid set of lengths, and looking ahead
                                          at length counts to determine sub-table sizes when building the
                                          decoding tables.
                                          */ /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
        for (len = 0; len <= MAXBITS; len++) {
          count[len] = 0;
        }
        for (sym = 0; sym < codes; sym++) {
          count[lens[lens_index + sym]]++;
        } /* bound code lengths, force root to be within code lengths */
        root = bits;
        for (max = MAXBITS; max >= 1; max--) {
          if (count[max] !== 0) {
            break;
          }
        }
        if (root > max) {
          root = max;
        }
        if (max === 0) {
          /* no symbols to code at all */ //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
          //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
          //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
          table[table_index++] = 1 << 24 | 64 << 16 | 0; //table.op[opts.table_index] = 64;
          //table.bits[opts.table_index] = 1;
          //table.val[opts.table_index++] = 0;
          table[table_index++] = 1 << 24 | 64 << 16 | 0;
          opts.bits = 1;
          return 0; /* no symbols, but wait for decoding to report error */
        }
        for (min = 1; min < max; min++) {
          if (count[min] !== 0) {
            break;
          }
        }
        if (root < min) {
          root = min;
        } /* check for an over-subscribed or incomplete set of lengths */
        left = 1;
        for (len = 1; len <= MAXBITS; len++) {
          left <<= 1;
          left -= count[len];
          if (left < 0) {
            return -1;
          } /* over-subscribed */
        }
        if (left > 0 && (type === CODES || max !== 1)) {
          return -1; /* incomplete set */
        } /* generate offsets into symbol table for each length for sorting */
        offs[1] = 0;
        for (len = 1; len < MAXBITS; len++) {
          offs[len + 1] = offs[len] + count[len];
        } /* sort symbols by length, by symbol order within each length */
        for (sym = 0; sym < codes; sym++) {
          if (lens[lens_index + sym] !== 0) {
            work[offs[lens[lens_index + sym]]++] = sym;
          }
        } /*
          Create and fill in decoding tables.  In this loop, the table being
          filled is at next and has curr index bits.  The code being used is huff
          with length len.  That code is converted to an index by dropping drop
          bits off of the bottom.  For codes where len is less than drop + curr,
          those top drop + curr - len bits are incremented through all values to
          fill the table with replicated entries.
          root is the number of index bits for the root table.  When len exceeds
          root, sub-tables are created pointed to by the root entry with an index
          of the low root bits of huff.  This is saved in low to check for when a
          new sub-table should be started.  drop is zero when the root table is
          being filled, and drop is root when sub-tables are being filled.
          When a new sub-table is needed, it is necessary to look ahead in the
          code lengths to determine what size sub-table is needed.  The length
          counts are used for this, and so count[] is decremented as codes are
          entered in the tables.
          used keeps track of how many table entries have been allocated from the
          provided *table space.  It is checked for LENS and DIST tables against
          the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
          the initial root table size constants.  See the comments in inftrees.h
          for more information.
          sym increments through all symbols, and the loop terminates when
          all codes of length max, i.e. all codes, have been processed.  This
          routine permits incomplete codes, so another loop after this one fills
          in the rest of the decoding tables with invalid code markers.
          */ /* set up for code type */ // poor man optimization - use if-else instead of switch,
        // to avoid deopts in old v8
        if (type === CODES) {
          base = extra = work; /* dummy value--not used */
          end = 19;
        } else if (type === LENS) {
          base = lbase;
          base_index -= 257;
          extra = lext;
          extra_index -= 257;
          end = 256;
        } else {
          /* DISTS */base = dbase;
          extra = dext;
          end = -1;
        } /* initialize opts for loop */
        huff = 0; /* starting code */
        sym = 0; /* starting code symbol */
        len = min; /* starting code length */
        next = table_index; /* current table to fill in */
        curr = root; /* current table index bits */
        drop = 0; /* current bits to drop from code for index */
        low = -1; /* trigger new sub-table when len > root */
        used = 1 << root; /* use root table entries */
        mask = used - 1; /* mask for comparing low */ /* check available table space */
        if (type === LENS && used > ENOUGH_LENS || type === DISTS && used > ENOUGH_DISTS) {
          return 1;
        } /* process all codes and make table entries */
        for (;;) {
          /* create table entry */here_bits = len - drop;
          if (work[sym] < end) {
            here_op = 0;
            here_val = work[sym];
          } else if (work[sym] > end) {
            here_op = extra[extra_index + work[sym]];
            here_val = base[base_index + work[sym]];
          } else {
            here_op = 32 + 64; /* end of block */
            here_val = 0;
          } /* replicate for those indices with low len bits equal to huff */
          incr = 1 << len - drop;
          fill = 1 << curr;
          min = fill; /* save offset to next table */
          do {
            fill -= incr;
            table[next + (huff >> drop) + fill] = here_bits << 24 | here_op << 16 | here_val | 0;
          } while (fill !== 0); /* backwards increment the len-bit code huff */
          incr = 1 << len - 1;
          while (huff & incr) {
            incr >>= 1;
          }
          if (incr !== 0) {
            huff &= incr - 1;
            huff += incr;
          } else {
            huff = 0;
          } /* go to next symbol, update count, len */
          sym++;
          if (--count[len] === 0) {
            if (len === max) {
              break;
            }
            len = lens[lens_index + work[sym]];
          } /* create new sub-table if needed */
          if (len > root && (huff & mask) !== low) {
            /* if first time, transition to sub-tables */if (drop === 0) {
              drop = root;
            } /* increment past last table */
            next += min; /* here min is 1 << curr */ /* determine length of next table */
            curr = len - drop;
            left = 1 << curr;
            while (curr + drop < max) {
              left -= count[curr + drop];
              if (left <= 0) {
                break;
              }
              curr++;
              left <<= 1;
            } /* check for enough space */
            used += 1 << curr;
            if (type === LENS && used > ENOUGH_LENS || type === DISTS && used > ENOUGH_DISTS) {
              return 1;
            } /* point entry in root table to sub-table */
            low = huff & mask; /*table.op[low] = curr;
                               table.bits[low] = root;
                               table.val[low] = next - opts.table_index;*/
            table[low] = root << 24 | curr << 16 | next - table_index | 0;
          }
        } /* fill in remaining table entry if code is incomplete (guaranteed to have
          at most one remaining entry, since if the code is incomplete, the
          maximum code length that was allowed to get this far is one bit) */
        if (huff !== 0) {
          //table.op[next + huff] = 64;            /* invalid code marker */
          //table.bits[next + huff] = len - drop;
          //table.val[next + huff] = 0;
          table[next + huff] = len - drop << 24 | 64 << 16 | 0;
        } /* set return parameters */ //opts.table_index += used;
        opts.bits = root;
        return 0;
      };
    }, {
      "../utils/common": 54
    }],
    64: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      module.exports = {
        2: 'need dictionary',
        /* Z_NEED_DICT       2  */1: 'stream end',
        /* Z_STREAM_END      1  */0: '',
        /* Z_OK              0  */'-1': 'file error',
        /* Z_ERRNO         (-1) */'-2': 'stream error',
        /* Z_STREAM_ERROR  (-2) */'-3': 'data error',
        /* Z_DATA_ERROR    (-3) */'-4': 'insufficient memory',
        /* Z_MEM_ERROR     (-4) */'-5': 'buffer error',
        /* Z_BUF_ERROR     (-5) */'-6': 'incompatible version' /* Z_VERSION_ERROR (-6) */
      };
    }, {}],
    65: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      var utils = require('../utils/common'); /* Public constants ==========================================================*/ /* ===========================================================================*/ //var Z_FILTERED          = 1;
      //var Z_HUFFMAN_ONLY      = 2;
      //var Z_RLE               = 3;
      var Z_FIXED = 4; //var Z_DEFAULT_STRATEGY  = 0;
      /* Possible values of the data_type field (though see inflate()) */
      var Z_BINARY = 0;
      var Z_TEXT = 1; //var Z_ASCII             = 1; // = Z_TEXT
      var Z_UNKNOWN = 2; /*============================================================================*/
      function zero(buf) {
        var len = buf.length;
        while (--len >= 0) {
          buf[len] = 0;
        }
      } // From zutil.h
      var STORED_BLOCK = 0;
      var STATIC_TREES = 1;
      var DYN_TREES = 2; /* The three kinds of block type */
      var MIN_MATCH = 3;
      var MAX_MATCH = 258; /* The minimum and maximum match lengths */ // From deflate.h
      /* ===========================================================================
       * Internal compression state.
       */
      var LENGTH_CODES = 29; /* number of length codes, not counting the special END_BLOCK code */
      var LITERALS = 256; /* number of literal bytes 0..255 */
      var L_CODES = LITERALS + 1 + LENGTH_CODES; /* number of Literal or Length codes, including the END_BLOCK code */
      var D_CODES = 30; /* number of distance codes */
      var BL_CODES = 19; /* number of codes used to transfer the bit lengths */
      var HEAP_SIZE = 2 * L_CODES + 1; /* maximum heap size */
      var MAX_BITS = 15; /* All codes must not exceed MAX_BITS bits */
      var Buf_size = 16; /* size of bit buffer in bi_buf */ /* ===========================================================================
                                                            * Constants
                                                            */
      var MAX_BL_BITS = 7; /* Bit length codes must not exceed MAX_BL_BITS bits */
      var END_BLOCK = 256; /* end of block literal code */
      var REP_3_6 = 16; /* repeat previous bit length 3-6 times (2 bits of repeat count) */
      var REPZ_3_10 = 17; /* repeat a zero length 3-10 times  (3 bits of repeat count) */
      var REPZ_11_138 = 18; /* repeat a zero length 11-138 times  (7 bits of repeat count) */ /* eslint-disable comma-spacing,array-bracket-spacing */
      var extra_lbits = /* extra bits for each length code */[0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0];
      var extra_dbits = /* extra bits for each distance code */[0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13];
      var extra_blbits = /* extra bits for each bit length code */[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7];
      var bl_order = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]; /* eslint-enable comma-spacing,array-bracket-spacing */ /* The lengths of the bit length codes are sent in order of decreasing
                                                                                                                                                 * probability, to avoid transmitting the lengths for unused bit length codes.
                                                                                                                                                 */ /* ===========================================================================
                                                                                                                                                    * Local data. These are initialized only once.
                                                                                                                                                    */ // We pre-fill arrays with 0 to avoid uninitialized gaps
      var DIST_CODE_LEN = 512; /* see definition of array dist_code below */ // !!!! Use flat array instead of structure, Freq = i*2, Len = i*2+1
      var static_ltree = new Array((L_CODES + 2) * 2);
      zero(static_ltree); /* The static literal tree. Since the bit lengths are imposed, there is no
                          * need for the L_CODES extra codes used during heap construction. However
                          * The codes 286 and 287 are needed to build a canonical tree (see _tr_init
                          * below).
                          */
      var static_dtree = new Array(D_CODES * 2);
      zero(static_dtree); /* The static distance tree. (Actually a trivial tree since all codes use
                          * 5 bits.)
                          */
      var _dist_code = new Array(DIST_CODE_LEN);
      zero(_dist_code); /* Distance codes. The first 256 values correspond to the distances
                        * 3 .. 258, the last 256 values correspond to the top 8 bits of
                        * the 15 bit distances.
                        */
      var _length_code = new Array(MAX_MATCH - MIN_MATCH + 1);
      zero(_length_code); /* length code for each normalized match length (0 == MIN_MATCH) */
      var base_length = new Array(LENGTH_CODES);
      zero(base_length); /* First normalized length for each code (0 = MIN_MATCH) */
      var base_dist = new Array(D_CODES);
      zero(base_dist); /* First normalized distance for each code (0 = distance of 1) */
      function StaticTreeDesc(static_tree, extra_bits, extra_base, elems, max_length) {
        this.static_tree = static_tree; /* static tree or NULL */
        this.extra_bits = extra_bits; /* extra bits for each code or NULL */
        this.extra_base = extra_base; /* base index for extra_bits */
        this.elems = elems; /* max number of elements in the tree */
        this.max_length = max_length; /* max bit length for the codes */ // show if `static_tree` has data or dummy - needed for monomorphic objects
        this.has_stree = static_tree && static_tree.length;
      }
      var static_l_desc;
      var static_d_desc;
      var static_bl_desc;
      function TreeDesc(dyn_tree, stat_desc) {
        this.dyn_tree = dyn_tree; /* the dynamic tree */
        this.max_code = 0; /* largest code with non zero frequency */
        this.stat_desc = stat_desc; /* the corresponding static tree */
      }
      function d_code(dist) {
        return dist < 256 ? _dist_code[dist] : _dist_code[256 + (dist >>> 7)];
      } /* ===========================================================================
        * Output a short LSB first on the stream.
        * IN assertion: there is enough room in pendingBuf.
        */
      function put_short(s, w) {
        //    put_byte(s, (uch)((w) & 0xff));
        //    put_byte(s, (uch)((ush)(w) >> 8));
        s.pending_buf[s.pending++] = w & 0xff;
        s.pending_buf[s.pending++] = w >>> 8 & 0xff;
      } /* ===========================================================================
        * Send a value on a given number of bits.
        * IN assertion: length <= 16 and value fits in length bits.
        */
      function send_bits(s, value, length) {
        if (s.bi_valid > Buf_size - length) {
          s.bi_buf |= value << s.bi_valid & 0xffff;
          put_short(s, s.bi_buf);
          s.bi_buf = value >> Buf_size - s.bi_valid;
          s.bi_valid += length - Buf_size;
        } else {
          s.bi_buf |= value << s.bi_valid & 0xffff;
          s.bi_valid += length;
        }
      }
      function send_code(s, c, tree) {
        send_bits(s, tree[c * 2] /*.Code*/, tree[c * 2 + 1] /*.Len*/);
      } /* ===========================================================================
        * Reverse the first len bits of a code, using straightforward code (a faster
        * method would use a table)
        * IN assertion: 1 <= len <= 15
        */
      function bi_reverse(code, len) {
        var res = 0;
        do {
          res |= code & 1;
          code >>>= 1;
          res <<= 1;
        } while (--len > 0);
        return res >>> 1;
      } /* ===========================================================================
        * Flush the bit buffer, keeping at most 7 bits in it.
        */
      function bi_flush(s) {
        if (s.bi_valid === 16) {
          put_short(s, s.bi_buf);
          s.bi_buf = 0;
          s.bi_valid = 0;
        } else if (s.bi_valid >= 8) {
          s.pending_buf[s.pending++] = s.bi_buf & 0xff;
          s.bi_buf >>= 8;
          s.bi_valid -= 8;
        }
      } /* ===========================================================================
        * Compute the optimal bit lengths for a tree and update the total bit length
        * for the current block.
        * IN assertion: the fields freq and dad are set, heap[heap_max] and
        *    above are the tree nodes sorted by increasing frequency.
        * OUT assertions: the field len is set to the optimal bit length, the
        *     array bl_count contains the frequencies for each bit length.
        *     The length opt_len is updated; static_len is also updated if stree is
        *     not null.
        */
      function gen_bitlen(s, desc)
      //    deflate_state *s;
      //    tree_desc *desc;    /* the tree descriptor */
      {
        var tree = desc.dyn_tree;
        var max_code = desc.max_code;
        var stree = desc.stat_desc.static_tree;
        var has_stree = desc.stat_desc.has_stree;
        var extra = desc.stat_desc.extra_bits;
        var base = desc.stat_desc.extra_base;
        var max_length = desc.stat_desc.max_length;
        var h; /* heap index */
        var n, m; /* iterate over the tree elements */
        var bits; /* bit length */
        var xbits; /* extra bits */
        var f; /* frequency */
        var overflow = 0; /* number of elements with bit length too large */
        for (bits = 0; bits <= MAX_BITS; bits++) {
          s.bl_count[bits] = 0;
        } /* In a first pass, compute the optimal bit lengths (which may
          * overflow in the case of the bit length tree).
          */
        tree[s.heap[s.heap_max] * 2 + 1] /*.Len*/ = 0; /* root of the heap */
        for (h = s.heap_max + 1; h < HEAP_SIZE; h++) {
          n = s.heap[h];
          bits = tree[tree[n * 2 + 1] /*.Dad*/ * 2 + 1] /*.Len*/ + 1;
          if (bits > max_length) {
            bits = max_length;
            overflow++;
          }
          tree[n * 2 + 1] /*.Len*/ = bits; /* We overwrite tree[n].Dad which is no longer needed */
          if (n > max_code) {
            continue;
          } /* not a leaf node */
          s.bl_count[bits]++;
          xbits = 0;
          if (n >= base) {
            xbits = extra[n - base];
          }
          f = tree[n * 2] /*.Freq*/;
          s.opt_len += f * (bits + xbits);
          if (has_stree) {
            s.static_len += f * (stree[n * 2 + 1] /*.Len*/ + xbits);
          }
        }
        if (overflow === 0) {
          return;
        } // Trace((stderr,"\nbit length overflow\n"));
        /* This happens for example on obj2 and pic of the Calgary corpus */ /* Find the first bit length which could increase: */
        do {
          bits = max_length - 1;
          while (s.bl_count[bits] === 0) {
            bits--;
          }
          s.bl_count[bits]--; /* move one leaf down the tree */
          s.bl_count[bits + 1] += 2; /* move one overflow item as its brother */
          s.bl_count[max_length]--; /* The brother of the overflow item also moves one step up,
                                    * but this does not affect bl_count[max_length]
                                    */
          overflow -= 2;
        } while (overflow > 0); /* Now recompute all bit lengths, scanning in increasing frequency.
                                * h is still equal to HEAP_SIZE. (It is simpler to reconstruct all
                                * lengths instead of fixing only the wrong ones. This idea is taken
                                * from 'ar' written by Haruhiko Okumura.)
                                */
        for (bits = max_length; bits !== 0; bits--) {
          n = s.bl_count[bits];
          while (n !== 0) {
            m = s.heap[--h];
            if (m > max_code) {
              continue;
            }
            if (tree[m * 2 + 1] /*.Len*/ !== bits) {
              // Trace((stderr,"code %d bits %d->%d\n", m, tree[m].Len, bits));
              s.opt_len += (bits - tree[m * 2 + 1] /*.Len*/) * tree[m * 2] /*.Freq*/;
              tree[m * 2 + 1] /*.Len*/ = bits;
            }
            n--;
          }
        }
      } /* ===========================================================================
        * Generate the codes for a given tree and bit counts (which need not be
        * optimal).
        * IN assertion: the array bl_count contains the bit length statistics for
        * the given tree and the field len is set for all tree elements.
        * OUT assertion: the field code is set for all tree elements of non
        *     zero code length.
        */
      function gen_codes(tree, max_code, bl_count)
      //    ct_data *tree;             /* the tree to decorate */
      //    int max_code;              /* largest code with non zero frequency */
      //    ushf *bl_count;            /* number of codes at each bit length */
      {
        var next_code = new Array(MAX_BITS + 1); /* next code value for each bit length */
        var code = 0; /* running code value */
        var bits; /* bit index */
        var n; /* code index */ /* The distribution counts are first used to generate the code values
                                * without bit reversal.
                                */
        for (bits = 1; bits <= MAX_BITS; bits++) {
          next_code[bits] = code = code + bl_count[bits - 1] << 1;
        } /* Check that the bit counts in bl_count are consistent. The last code
          * must be all ones.
          */ //Assert (code + bl_count[MAX_BITS]-1 == (1<<MAX_BITS)-1,
        //        "inconsistent bit counts");
        //Tracev((stderr,"\ngen_codes: max_code %d ", max_code));
        for (n = 0; n <= max_code; n++) {
          var len = tree[n * 2 + 1] /*.Len*/;
          if (len === 0) {
            continue;
          } /* Now reverse the bits */
          tree[n * 2] /*.Code*/ = bi_reverse(next_code[len]++, len); //Tracecv(tree != static_ltree, (stderr,"\nn %3d %c l %2d c %4x (%x) ",
          //     n, (isgraph(n) ? n : ' '), len, tree[n].Code, next_code[len]-1));
        }
      } /* ===========================================================================
        * Initialize the various 'constant' tables.
        */
      function tr_static_init() {
        var n; /* iterates over tree elements */
        var bits; /* bit counter */
        var length; /* length value */
        var code; /* code value */
        var dist; /* distance index */
        var bl_count = new Array(MAX_BITS + 1); /* number of codes at each bit length for an optimal tree */ // do check in _tr_init()
        //if (static_init_done) return;
        /* For some embedded targets, global variables are not initialized: */ /*#ifdef NO_INIT_GLOBAL_POINTERS
                                                                               static_l_desc.static_tree = static_ltree;
                                                                               static_l_desc.extra_bits = extra_lbits;
                                                                               static_d_desc.static_tree = static_dtree;
                                                                               static_d_desc.extra_bits = extra_dbits;
                                                                               static_bl_desc.extra_bits = extra_blbits;
                                                                               #endif*/ /* Initialize the mapping length (0..255) -> length code (0..28) */
        length = 0;
        for (code = 0; code < LENGTH_CODES - 1; code++) {
          base_length[code] = length;
          for (n = 0; n < 1 << extra_lbits[code]; n++) {
            _length_code[length++] = code;
          }
        } //Assert (length == 256, "tr_static_init: length != 256");
        /* Note that the length 255 (match length 258) can be represented
           * in two different ways: code 284 + 5 bits or code 285, so we
           * overwrite length_code[255] to use the best encoding:
           */
        _length_code[length - 1] = code; /* Initialize the mapping dist (0..32K) -> dist code (0..29) */
        dist = 0;
        for (code = 0; code < 16; code++) {
          base_dist[code] = dist;
          for (n = 0; n < 1 << extra_dbits[code]; n++) {
            _dist_code[dist++] = code;
          }
        } //Assert (dist == 256, "tr_static_init: dist != 256");
        dist >>= 7; /* from now on, all distances are divided by 128 */
        for (; code < D_CODES; code++) {
          base_dist[code] = dist << 7;
          for (n = 0; n < 1 << extra_dbits[code] - 7; n++) {
            _dist_code[256 + dist++] = code;
          }
        } //Assert (dist == 256, "tr_static_init: 256+dist != 512");
        /* Construct the codes of the static literal tree */
        for (bits = 0; bits <= MAX_BITS; bits++) {
          bl_count[bits] = 0;
        }
        n = 0;
        while (n <= 143) {
          static_ltree[n * 2 + 1] /*.Len*/ = 8;
          n++;
          bl_count[8]++;
        }
        while (n <= 255) {
          static_ltree[n * 2 + 1] /*.Len*/ = 9;
          n++;
          bl_count[9]++;
        }
        while (n <= 279) {
          static_ltree[n * 2 + 1] /*.Len*/ = 7;
          n++;
          bl_count[7]++;
        }
        while (n <= 287) {
          static_ltree[n * 2 + 1] /*.Len*/ = 8;
          n++;
          bl_count[8]++;
        } /* Codes 286 and 287 do not exist, but we must include them in the
          * tree construction to get a canonical Huffman tree (longest code
          * all ones)
          */
        gen_codes(static_ltree, L_CODES + 1, bl_count); /* The static distance tree is trivial: */
        for (n = 0; n < D_CODES; n++) {
          static_dtree[n * 2 + 1] /*.Len*/ = 5;
          static_dtree[n * 2] /*.Code*/ = bi_reverse(n, 5);
        } // Now data ready and we can init static trees
        static_l_desc = new StaticTreeDesc(static_ltree, extra_lbits, LITERALS + 1, L_CODES, MAX_BITS);
        static_d_desc = new StaticTreeDesc(static_dtree, extra_dbits, 0, D_CODES, MAX_BITS);
        static_bl_desc = new StaticTreeDesc(new Array(0), extra_blbits, 0, BL_CODES, MAX_BL_BITS); //static_init_done = true;
      } /* ===========================================================================
        * Initialize a new block.
        */
      function init_block(s) {
        var n; /* iterates over tree elements */ /* Initialize the trees. */
        for (n = 0; n < L_CODES; n++) {
          s.dyn_ltree[n * 2] /*.Freq*/ = 0;
        }
        for (n = 0; n < D_CODES; n++) {
          s.dyn_dtree[n * 2] /*.Freq*/ = 0;
        }
        for (n = 0; n < BL_CODES; n++) {
          s.bl_tree[n * 2] /*.Freq*/ = 0;
        }
        s.dyn_ltree[END_BLOCK * 2] /*.Freq*/ = 1;
        s.opt_len = s.static_len = 0;
        s.last_lit = s.matches = 0;
      } /* ===========================================================================
        * Flush the bit buffer and align the output on a byte boundary
        */
      function bi_windup(s) {
        if (s.bi_valid > 8) {
          put_short(s, s.bi_buf);
        } else if (s.bi_valid > 0) {
          //put_byte(s, (Byte)s->bi_buf);
          s.pending_buf[s.pending++] = s.bi_buf;
        }
        s.bi_buf = 0;
        s.bi_valid = 0;
      } /* ===========================================================================
        * Copy a stored block, storing first the length and its
        * one's complement if requested.
        */
      function copy_block(s, buf, len, header)
      //DeflateState *s;
      //charf    *buf;    /* the input data */
      //unsigned len;     /* its length */
      //int      header;  /* true if block header must be written */
      {
        bi_windup(s); /* align on byte boundary */
        if (header) {
          put_short(s, len);
          put_short(s, ~len);
        } //  while (len--) {
        //    put_byte(s, *buf++);
        //  }
        utils.arraySet(s.pending_buf, s.window, buf, len, s.pending);
        s.pending += len;
      } /* ===========================================================================
        * Compares to subtrees, using the tree depth as tie breaker when
        * the subtrees have equal frequency. This minimizes the worst case length.
        */
      function smaller(tree, n, m, depth) {
        var _n2 = n * 2;
        var _m2 = m * 2;
        return tree[_n2] /*.Freq*/ < tree[_m2] /*.Freq*/ || tree[_n2] /*.Freq*/ === tree[_m2] /*.Freq*/ && depth[n] <= depth[m];
      } /* ===========================================================================
        * Restore the heap property by moving down the tree starting at node k,
        * exchanging a node with the smallest of its two sons if necessary, stopping
        * when the heap property is re-established (each father smaller than its
        * two sons).
        */
      function pqdownheap(s, tree, k)
      //    deflate_state *s;
      //    ct_data *tree;  /* the tree to restore */
      //    int k;               /* node to move down */
      {
        var v = s.heap[k];
        var j = k << 1; /* left son of k */
        while (j <= s.heap_len) {
          /* Set j to the smallest of the two sons: */if (j < s.heap_len && smaller(tree, s.heap[j + 1], s.heap[j], s.depth)) {
            j++;
          } /* Exit if v is smaller than both sons */
          if (smaller(tree, v, s.heap[j], s.depth)) {
            break;
          } /* Exchange v with the smallest son */
          s.heap[k] = s.heap[j];
          k = j; /* And continue down the tree, setting j to the left son of k */
          j <<= 1;
        }
        s.heap[k] = v;
      } // inlined manually
      // var SMALLEST = 1;
      /* ===========================================================================
       * Send the block data compressed using the given Huffman trees
       */
      function compress_block(s, ltree, dtree)
      //    deflate_state *s;
      //    const ct_data *ltree; /* literal tree */
      //    const ct_data *dtree; /* distance tree */
      {
        var dist; /* distance of matched string */
        var lc; /* match length or unmatched char (if dist == 0) */
        var lx = 0; /* running index in l_buf */
        var code; /* the code to send */
        var extra; /* number of extra bits to send */
        if (s.last_lit !== 0) {
          do {
            dist = s.pending_buf[s.d_buf + lx * 2] << 8 | s.pending_buf[s.d_buf + lx * 2 + 1];
            lc = s.pending_buf[s.l_buf + lx];
            lx++;
            if (dist === 0) {
              send_code(s, lc, ltree); /* send a literal byte */ //Tracecv(isgraph(lc), (stderr," '%c' ", lc));
            } else {
              /* Here, lc is the match length - MIN_MATCH */code = _length_code[lc];
              send_code(s, code + LITERALS + 1, ltree); /* send the length code */
              extra = extra_lbits[code];
              if (extra !== 0) {
                lc -= base_length[code];
                send_bits(s, lc, extra); /* send the extra length bits */
              }
              dist--; /* dist is now the match distance - 1 */
              code = d_code(dist); //Assert (code < D_CODES, "bad d_code");
              send_code(s, code, dtree); /* send the distance code */
              extra = extra_dbits[code];
              if (extra !== 0) {
                dist -= base_dist[code];
                send_bits(s, dist, extra); /* send the extra distance bits */
              }
            } /* literal or match pair ? */ /* Check that the overlay between pending_buf and d_buf+l_buf is ok: */ //Assert((uInt)(s->pending) < s->lit_bufsize + 2*lx,
            //       "pendingBuf overflow");
          } while (lx < s.last_lit);
        }
        send_code(s, END_BLOCK, ltree);
      } /* ===========================================================================
        * Construct one Huffman tree and assigns the code bit strings and lengths.
        * Update the total bit length for the current block.
        * IN assertion: the field freq is set for all tree elements.
        * OUT assertions: the fields len and code are set to the optimal bit length
        *     and corresponding code. The length opt_len is updated; static_len is
        *     also updated if stree is not null. The field max_code is set.
        */
      function build_tree(s, desc)
      //    deflate_state *s;
      //    tree_desc *desc; /* the tree descriptor */
      {
        var tree = desc.dyn_tree;
        var stree = desc.stat_desc.static_tree;
        var has_stree = desc.stat_desc.has_stree;
        var elems = desc.stat_desc.elems;
        var n, m; /* iterate over heap elements */
        var max_code = -1; /* largest code with non zero frequency */
        var node; /* new node being created */ /* Construct the initial heap, with least frequent element in
                                               * heap[SMALLEST]. The sons of heap[n] are heap[2*n] and heap[2*n+1].
                                               * heap[0] is not used.
                                               */
        s.heap_len = 0;
        s.heap_max = HEAP_SIZE;
        for (n = 0; n < elems; n++) {
          if (tree[n * 2] /*.Freq*/ !== 0) {
            s.heap[++s.heap_len] = max_code = n;
            s.depth[n] = 0;
          } else {
            tree[n * 2 + 1] /*.Len*/ = 0;
          }
        } /* The pkzip format requires that at least one distance code exists,
          * and that at least one bit should be sent even if there is only one
          * possible code. So to avoid special checks later on we force at least
          * two codes of non zero frequency.
          */
        while (s.heap_len < 2) {
          node = s.heap[++s.heap_len] = max_code < 2 ? ++max_code : 0;
          tree[node * 2] /*.Freq*/ = 1;
          s.depth[node] = 0;
          s.opt_len--;
          if (has_stree) {
            s.static_len -= stree[node * 2 + 1] /*.Len*/;
          } /* node is 0 or 1 so it does not have extra bits */
        }
        desc.max_code = max_code; /* The elements heap[heap_len/2+1 .. heap_len] are leaves of the tree,
                                  * establish sub-heaps of increasing lengths:
                                  */
        for (n = s.heap_len >> 1 /*int /2*/; n >= 1; n--) {
          pqdownheap(s, tree, n);
        } /* Construct the Huffman tree by repeatedly combining the least two
          * frequent nodes.
          */
        node = elems; /* next internal node of the tree */
        do {
          //pqremove(s, tree, n);  /* n = node of least frequency */
          /*** pqremove ***/
          n = s.heap[1 /*SMALLEST*/];
          s.heap[1 /*SMALLEST*/] = s.heap[s.heap_len--];
          pqdownheap(s, tree, 1 /*SMALLEST*/); /***/
          m = s.heap[1 /*SMALLEST*/]; /* m = node of next least frequency */
          s.heap[--s.heap_max] = n; /* keep the nodes sorted by frequency */
          s.heap[--s.heap_max] = m; /* Create a new node father of n and m */
          tree[node * 2] /*.Freq*/ = tree[n * 2] /*.Freq*/ + tree[m * 2] /*.Freq*/;
          s.depth[node] = (s.depth[n] >= s.depth[m] ? s.depth[n] : s.depth[m]) + 1;
          tree[n * 2 + 1] /*.Dad*/ = tree[m * 2 + 1] /*.Dad*/ = node; /* and insert the new node in the heap */
          s.heap[1 /*SMALLEST*/] = node++;
          pqdownheap(s, tree, 1 /*SMALLEST*/);
        } while (s.heap_len >= 2);
        s.heap[--s.heap_max] = s.heap[1 /*SMALLEST*/]; /* At this point, the fields freq and dad are set. We can now
                                                       * generate the bit lengths.
                                                       */
        gen_bitlen(s, desc); /* The field len is now set, we can generate the bit codes */
        gen_codes(tree, max_code, s.bl_count);
      } /* ===========================================================================
        * Scan a literal or distance tree to determine the frequencies of the codes
        * in the bit length tree.
        */
      function scan_tree(s, tree, max_code)
      //    deflate_state *s;
      //    ct_data *tree;   /* the tree to be scanned */
      //    int max_code;    /* and its largest code of non zero frequency */
      {
        var n; /* iterates over all tree elements */
        var prevlen = -1; /* last emitted length */
        var curlen; /* length of current code */
        var nextlen = tree[0 * 2 + 1] /*.Len*/; /* length of next code */
        var count = 0; /* repeat count of the current code */
        var max_count = 7; /* max repeat count */
        var min_count = 4; /* min repeat count */
        if (nextlen === 0) {
          max_count = 138;
          min_count = 3;
        }
        tree[(max_code + 1) * 2 + 1] /*.Len*/ = 0xffff; /* guard */
        for (n = 0; n <= max_code; n++) {
          curlen = nextlen;
          nextlen = tree[(n + 1) * 2 + 1] /*.Len*/;
          if (++count < max_count && curlen === nextlen) {
            continue;
          } else if (count < min_count) {
            s.bl_tree[curlen * 2] /*.Freq*/ += count;
          } else if (curlen !== 0) {
            if (curlen !== prevlen) {
              s.bl_tree[curlen * 2] /*.Freq*/++;
            }
            s.bl_tree[REP_3_6 * 2] /*.Freq*/++;
          } else if (count <= 10) {
            s.bl_tree[REPZ_3_10 * 2] /*.Freq*/++;
          } else {
            s.bl_tree[REPZ_11_138 * 2] /*.Freq*/++;
          }
          count = 0;
          prevlen = curlen;
          if (nextlen === 0) {
            max_count = 138;
            min_count = 3;
          } else if (curlen === nextlen) {
            max_count = 6;
            min_count = 3;
          } else {
            max_count = 7;
            min_count = 4;
          }
        }
      } /* ===========================================================================
        * Send a literal or distance tree in compressed form, using the codes in
        * bl_tree.
        */
      function send_tree(s, tree, max_code)
      //    deflate_state *s;
      //    ct_data *tree; /* the tree to be scanned */
      //    int max_code;       /* and its largest code of non zero frequency */
      {
        var n; /* iterates over all tree elements */
        var prevlen = -1; /* last emitted length */
        var curlen; /* length of current code */
        var nextlen = tree[0 * 2 + 1] /*.Len*/; /* length of next code */
        var count = 0; /* repeat count of the current code */
        var max_count = 7; /* max repeat count */
        var min_count = 4; /* min repeat count */ /* tree[max_code+1].Len = -1; */ /* guard already set */
        if (nextlen === 0) {
          max_count = 138;
          min_count = 3;
        }
        for (n = 0; n <= max_code; n++) {
          curlen = nextlen;
          nextlen = tree[(n + 1) * 2 + 1] /*.Len*/;
          if (++count < max_count && curlen === nextlen) {
            continue;
          } else if (count < min_count) {
            do {
              send_code(s, curlen, s.bl_tree);
            } while (--count !== 0);
          } else if (curlen !== 0) {
            if (curlen !== prevlen) {
              send_code(s, curlen, s.bl_tree);
              count--;
            } //Assert(count >= 3 && count <= 6, " 3_6?");
            send_code(s, REP_3_6, s.bl_tree);
            send_bits(s, count - 3, 2);
          } else if (count <= 10) {
            send_code(s, REPZ_3_10, s.bl_tree);
            send_bits(s, count - 3, 3);
          } else {
            send_code(s, REPZ_11_138, s.bl_tree);
            send_bits(s, count - 11, 7);
          }
          count = 0;
          prevlen = curlen;
          if (nextlen === 0) {
            max_count = 138;
            min_count = 3;
          } else if (curlen === nextlen) {
            max_count = 6;
            min_count = 3;
          } else {
            max_count = 7;
            min_count = 4;
          }
        }
      } /* ===========================================================================
        * Construct the Huffman tree for the bit lengths and return the index in
        * bl_order of the last bit length code to send.
        */
      function build_bl_tree(s) {
        var max_blindex; /* index of last bit length code of non zero freq */ /* Determine the bit length frequencies for literal and distance trees */
        scan_tree(s, s.dyn_ltree, s.l_desc.max_code);
        scan_tree(s, s.dyn_dtree, s.d_desc.max_code); /* Build the bit length tree: */
        build_tree(s, s.bl_desc); /* opt_len now includes the length of the tree representations, except
                                  * the lengths of the bit lengths codes and the 5+5+4 bits for the counts.
                                  */ /* Determine the number of bit length codes to send. The pkzip format
                                     * requires that at least 4 bit length codes be sent. (appnote.txt says
                                     * 3 but the actual value used is 4.)
                                     */
        for (max_blindex = BL_CODES - 1; max_blindex >= 3; max_blindex--) {
          if (s.bl_tree[bl_order[max_blindex] * 2 + 1] /*.Len*/ !== 0) {
            break;
          }
        } /* Update opt_len to include the bit length tree and counts */
        s.opt_len += 3 * (max_blindex + 1) + 5 + 5 + 4; //Tracev((stderr, "\ndyn trees: dyn %ld, stat %ld",
        //        s->opt_len, s->static_len));
        return max_blindex;
      } /* ===========================================================================
        * Send the header for a block using dynamic Huffman trees: the counts, the
        * lengths of the bit length codes, the literal tree and the distance tree.
        * IN assertion: lcodes >= 257, dcodes >= 1, blcodes >= 4.
        */
      function send_all_trees(s, lcodes, dcodes, blcodes)
      //    deflate_state *s;
      //    int lcodes, dcodes, blcodes; /* number of codes for each tree */
      {
        var rank; /* index in bl_order */ //Assert (lcodes >= 257 && dcodes >= 1 && blcodes >= 4, "not enough codes");
        //Assert (lcodes <= L_CODES && dcodes <= D_CODES && blcodes <= BL_CODES,
        //        "too many codes");
        //Tracev((stderr, "\nbl counts: "));
        send_bits(s, lcodes - 257, 5); /* not +255 as stated in appnote.txt */
        send_bits(s, dcodes - 1, 5);
        send_bits(s, blcodes - 4, 4); /* not -3 as stated in appnote.txt */
        for (rank = 0; rank < blcodes; rank++) {
          //Tracev((stderr, "\nbl code %2d ", bl_order[rank]));
          send_bits(s, s.bl_tree[bl_order[rank] * 2 + 1] /*.Len*/, 3);
        } //Tracev((stderr, "\nbl tree: sent %ld", s->bits_sent));
        send_tree(s, s.dyn_ltree, lcodes - 1); /* literal tree */ //Tracev((stderr, "\nlit tree: sent %ld", s->bits_sent));
        send_tree(s, s.dyn_dtree, dcodes - 1); /* distance tree */ //Tracev((stderr, "\ndist tree: sent %ld", s->bits_sent));
      } /* ===========================================================================
        * Check if the data type is TEXT or BINARY, using the following algorithm:
        * - TEXT if the two conditions below are satisfied:
        *    a) There are no non-portable control characters belonging to the
        *       "black list" (0..6, 14..25, 28..31).
        *    b) There is at least one printable character belonging to the
        *       "white list" (9 {TAB}, 10 {LF}, 13 {CR}, 32..255).
        * - BINARY otherwise.
        * - The following partially-portable control characters form a
        *   "gray list" that is ignored in this detection algorithm:
        *   (7 {BEL}, 8 {BS}, 11 {VT}, 12 {FF}, 26 {SUB}, 27 {ESC}).
        * IN assertion: the fields Freq of dyn_ltree are set.
        */
      function detect_data_type(s) {
        /* black_mask is the bit mask of black-listed bytes
        * set bits 0..6, 14..25, and 28..31
        * 0xf3ffc07f = binary 11110011111111111100000001111111
        */
        var black_mask = 0xf3ffc07f;
        var n; /* Check for non-textual ("black-listed") bytes. */
        for (n = 0; n <= 31; n++, black_mask >>>= 1) {
          if (black_mask & 1 && s.dyn_ltree[n * 2] /*.Freq*/ !== 0) {
            return Z_BINARY;
          }
        } /* Check for textual ("white-listed") bytes. */
        if (s.dyn_ltree[9 * 2] /*.Freq*/ !== 0 || s.dyn_ltree[10 * 2] /*.Freq*/ !== 0 || s.dyn_ltree[13 * 2] /*.Freq*/ !== 0) {
          return Z_TEXT;
        }
        for (n = 32; n < LITERALS; n++) {
          if (s.dyn_ltree[n * 2] /*.Freq*/ !== 0) {
            return Z_TEXT;
          }
        } /* There are no "black-listed" or "white-listed" bytes:
          * this stream either is empty or has tolerated ("gray-listed") bytes only.
          */
        return Z_BINARY;
      }
      var static_init_done = false; /* ===========================================================================
                                    * Initialize the tree data structures for a new zlib stream.
                                    */
      function _tr_init(s) {
        if (!static_init_done) {
          tr_static_init();
          static_init_done = true;
        }
        s.l_desc = new TreeDesc(s.dyn_ltree, static_l_desc);
        s.d_desc = new TreeDesc(s.dyn_dtree, static_d_desc);
        s.bl_desc = new TreeDesc(s.bl_tree, static_bl_desc);
        s.bi_buf = 0;
        s.bi_valid = 0; /* Initialize the first block of the first file: */
        init_block(s);
      } /* ===========================================================================
        * Send a stored block
        */
      function _tr_stored_block(s, buf, stored_len, last)
      //DeflateState *s;
      //charf *buf;       /* input block */
      //ulg stored_len;   /* length of input block */
      //int last;         /* one if this is the last block for a file */
      {
        send_bits(s, (STORED_BLOCK << 1) + (last ? 1 : 0), 3); /* send block type */
        copy_block(s, buf, stored_len, true); /* with header */
      } /* ===========================================================================
        * Send one empty static block to give enough lookahead for inflate.
        * This takes 10 bits, of which 7 may remain in the bit buffer.
        */
      function _tr_align(s) {
        send_bits(s, STATIC_TREES << 1, 3);
        send_code(s, END_BLOCK, static_ltree);
        bi_flush(s);
      } /* ===========================================================================
        * Determine the best encoding for the current block: dynamic trees, static
        * trees or store, and output the encoded block to the zip file.
        */
      function _tr_flush_block(s, buf, stored_len, last)
      //DeflateState *s;
      //charf *buf;       /* input block, or NULL if too old */
      //ulg stored_len;   /* length of input block */
      //int last;         /* one if this is the last block for a file */
      {
        var opt_lenb, static_lenb; /* opt_len and static_len in bytes */
        var max_blindex = 0; /* index of last bit length code of non zero freq */ /* Build the Huffman trees unless a stored block is forced */
        if (s.level > 0) {
          /* Check if the file is binary or text */if (s.strm.data_type === Z_UNKNOWN) {
            s.strm.data_type = detect_data_type(s);
          } /* Construct the literal and distance trees */
          build_tree(s, s.l_desc); // Tracev((stderr, "\nlit data: dyn %ld, stat %ld", s->opt_len,
          //        s->static_len));
          build_tree(s, s.d_desc); // Tracev((stderr, "\ndist data: dyn %ld, stat %ld", s->opt_len,
          //        s->static_len));
          /* At this point, opt_len and static_len are the total bit lengths of
               * the compressed block data, excluding the tree representations.
               */ /* Build the bit length tree for the above two trees, and get the index
                  * in bl_order of the last bit length code to send.
                  */
          max_blindex = build_bl_tree(s); /* Determine the best encoding. Compute the block lengths in bytes. */
          opt_lenb = s.opt_len + 3 + 7 >>> 3;
          static_lenb = s.static_len + 3 + 7 >>> 3; // Tracev((stderr, "\nopt %lu(%lu) stat %lu(%lu) stored %lu lit %u ",
          //        opt_lenb, s->opt_len, static_lenb, s->static_len, stored_len,
          //        s->last_lit));
          if (static_lenb <= opt_lenb) {
            opt_lenb = static_lenb;
          }
        } else {
          // Assert(buf != (char*)0, "lost buf");
          opt_lenb = static_lenb = stored_len + 5; /* force a stored block */
        }
        if (stored_len + 4 <= opt_lenb && buf !== -1) {
          /* 4: two words for the lengths */ /* The test buf != NULL is only necessary if LIT_BUFSIZE > WSIZE.
                                             * Otherwise we can't have processed more than WSIZE input bytes since
                                             * the last block flush, because compression would have been
                                             * successful. If LIT_BUFSIZE <= WSIZE, it is never too late to
                                             * transform a block into a stored block.
                                             */_tr_stored_block(s, buf, stored_len, last);
        } else if (s.strategy === Z_FIXED || static_lenb === opt_lenb) {
          send_bits(s, (STATIC_TREES << 1) + (last ? 1 : 0), 3);
          compress_block(s, static_ltree, static_dtree);
        } else {
          send_bits(s, (DYN_TREES << 1) + (last ? 1 : 0), 3);
          send_all_trees(s, s.l_desc.max_code + 1, s.d_desc.max_code + 1, max_blindex + 1);
          compress_block(s, s.dyn_ltree, s.dyn_dtree);
        } // Assert (s->compressed_len == s->bits_sent, "bad compressed size");
        /* The above check is made mod 2^32, for files larger than 512 MB
           * and uLong implemented on 32 bits.
           */
        init_block(s);
        if (last) {
          bi_windup(s);
        } // Tracev((stderr,"\ncomprlen %lu(%lu) ", s->compressed_len>>3,
        //       s->compressed_len-7*last));
      } /* ===========================================================================
        * Save the match info and tally the frequency counts. Return true if
        * the current block must be flushed.
        */
      function _tr_tally(s, dist, lc)
      //    deflate_state *s;
      //    unsigned dist;  /* distance of matched string */
      //    unsigned lc;    /* match length-MIN_MATCH or unmatched char (if dist==0) */
      {
        //var out_length, in_length, dcode;
        s.pending_buf[s.d_buf + s.last_lit * 2] = dist >>> 8 & 0xff;
        s.pending_buf[s.d_buf + s.last_lit * 2 + 1] = dist & 0xff;
        s.pending_buf[s.l_buf + s.last_lit] = lc & 0xff;
        s.last_lit++;
        if (dist === 0) {
          /* lc is the unmatched char */s.dyn_ltree[lc * 2] /*.Freq*/++;
        } else {
          s.matches++; /* Here, lc is the match length - MIN_MATCH */
          dist--; /* dist = match distance - 1 */ //Assert((ush)dist < (ush)MAX_DIST(s) &&
          //       (ush)lc <= (ush)(MAX_MATCH-MIN_MATCH) &&
          //       (ush)d_code(dist) < (ush)D_CODES,  "_tr_tally: bad match");
          s.dyn_ltree[(_length_code[lc] + LITERALS + 1) * 2] /*.Freq*/++;
          s.dyn_dtree[d_code(dist) * 2] /*.Freq*/++;
        } // (!) This block is disabled in zlib defaults,
        // don't enable it for binary compatibility
        //#ifdef TRUNCATE_BLOCK
        //  /* Try to guess if it is profitable to stop the current block here */
        //  if ((s.last_lit & 0x1fff) === 0 && s.level > 2) {
        //    /* Compute an upper bound for the compressed length */
        //    out_length = s.last_lit*8;
        //    in_length = s.strstart - s.block_start;
        //
        //    for (dcode = 0; dcode < D_CODES; dcode++) {
        //      out_length += s.dyn_dtree[dcode*2]/*.Freq*/ * (5 + extra_dbits[dcode]);
        //    }
        //    out_length >>>= 3;
        //    //Tracev((stderr,"\nlast_lit %u, in %ld, out ~%ld(%ld%%) ",
        //    //       s->last_lit, in_length, out_length,
        //    //       100L - out_length*100L/in_length));
        //    if (s.matches < (s.last_lit>>1)/*int /2*/ && out_length < (in_length>>1)/*int /2*/) {
        //      return true;
        //    }
        //  }
        //#endif
        return s.last_lit === s.lit_bufsize - 1; /* We avoid equality with lit_bufsize because of wraparound at 64K
                                                 * on 16 bit machines and because stored blocks are restricted to
                                                 * 64K-1 bytes.
                                                 */
      }
      exports._tr_init = _tr_init;
      exports._tr_stored_block = _tr_stored_block;
      exports._tr_flush_block = _tr_flush_block;
      exports._tr_tally = _tr_tally;
      exports._tr_align = _tr_align;
    }, {
      "../utils/common": 54
    }],
    66: [function (require, module, exports) {
      'use strict';

      // (C) 1995-2013 Jean-loup Gailly and Mark Adler
      // (C) 2014-2017 Vitaly Puzrin and Andrey Tupitsin
      //
      // This software is provided 'as-is', without any express or implied
      // warranty. In no event will the authors be held liable for any damages
      // arising from the use of this software.
      //
      // Permission is granted to anyone to use this software for any purpose,
      // including commercial applications, and to alter it and redistribute it
      // freely, subject to the following restrictions:
      //
      // 1. The origin of this software must not be misrepresented; you must not
      //   claim that you wrote the original software. If you use this software
      //   in a product, an acknowledgment in the product documentation would be
      //   appreciated but is not required.
      // 2. Altered source versions must be plainly marked as such, and must not be
      //   misrepresented as being the original software.
      // 3. This notice may not be removed or altered from any source distribution.
      function ZStream() {
        /* next input byte */this.input = null; // JS specific, because we have no pointers
        this.next_in = 0; /* number of bytes available at input */
        this.avail_in = 0; /* total number of input bytes read so far */
        this.total_in = 0; /* next output byte should be put there */
        this.output = null; // JS specific, because we have no pointers
        this.next_out = 0; /* remaining free space at output */
        this.avail_out = 0; /* total number of bytes output so far */
        this.total_out = 0; /* last error message, NULL if no error */
        this.msg = '' /*Z_NULL*/; /* not visible by applications */
        this.state = null; /* best guess about the data type: binary or text */
        this.data_type = 2 /*Z_UNKNOWN*/; /* adler32 value of the uncompressed data */
        this.adler = 0;
      }
      module.exports = ZStream;
    }, {}],
    67: [function (require, module, exports) {
      // shim for using process in browser
      var process = module.exports = {}; // cached from whatever global is present so that test runners that stub it
      // don't break things.  But we need to wrap it in a try catch in case it is
      // wrapped in strict mode code which doesn't define any globals.  It's inside a
      // function because try/catches deoptimize in certain engines.
      var cachedSetTimeout;
      var cachedClearTimeout;
      function defaultSetTimout() {
        throw new Error('setTimeout has not been defined');
      }
      function defaultClearTimeout() {
        throw new Error('clearTimeout has not been defined');
      }
      (function () {
        try {
          if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
          } else {
            cachedSetTimeout = defaultSetTimout;
          }
        } catch (e) {
          cachedSetTimeout = defaultSetTimout;
        }
        try {
          if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
          } else {
            cachedClearTimeout = defaultClearTimeout;
          }
        } catch (e) {
          cachedClearTimeout = defaultClearTimeout;
        }
      })();
      function runTimeout(fun) {
        if (cachedSetTimeout === setTimeout) {
          //normal enviroments in sane situations
          return setTimeout(fun, 0);
        } // if setTimeout wasn't available but was latter defined
        if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
          cachedSetTimeout = setTimeout;
          return setTimeout(fun, 0);
        }
        try {
          // when when somebody has screwed with setTimeout but no I.E. maddness
          return cachedSetTimeout(fun, 0);
        } catch (e) {
          try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
          } catch (e) {
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
          }
        }
      }
      function runClearTimeout(marker) {
        if (cachedClearTimeout === clearTimeout) {
          //normal enviroments in sane situations
          return clearTimeout(marker);
        } // if clearTimeout wasn't available but was latter defined
        if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
          cachedClearTimeout = clearTimeout;
          return clearTimeout(marker);
        }
        try {
          // when when somebody has screwed with setTimeout but no I.E. maddness
          return cachedClearTimeout(marker);
        } catch (e) {
          try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
          } catch (e) {
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
          }
        }
      }
      var queue = [];
      var draining = false;
      var currentQueue;
      var queueIndex = -1;
      function cleanUpNextTick() {
        if (!draining || !currentQueue) {
          return;
        }
        draining = false;
        if (currentQueue.length) {
          queue = currentQueue.concat(queue);
        } else {
          queueIndex = -1;
        }
        if (queue.length) {
          drainQueue();
        }
      }
      function drainQueue() {
        if (draining) {
          return;
        }
        var timeout = runTimeout(cleanUpNextTick);
        draining = true;
        var len = queue.length;
        while (len) {
          currentQueue = queue;
          queue = [];
          while (++queueIndex < len) {
            if (currentQueue) {
              currentQueue[queueIndex].run();
            }
          }
          queueIndex = -1;
          len = queue.length;
        }
        currentQueue = null;
        draining = false;
        runClearTimeout(timeout);
      }
      process.nextTick = function (fun) {
        var args = new Array(arguments.length - 1);
        if (arguments.length > 1) {
          for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
          }
        }
        queue.push(new Item(fun, args));
        if (queue.length === 1 && !draining) {
          runTimeout(drainQueue);
        }
      }; // v8 likes predictible objects
      function Item(fun, array) {
        this.fun = fun;
        this.array = array;
      }
      Item.prototype.run = function () {
        this.fun.apply(null, this.array);
      };
      process.title = 'browser';
      process.browser = true;
      process.env = {};
      process.argv = [];
      process.version = ''; // empty string to avoid regexp issues
      process.versions = {};
      function noop() {}
      process.on = noop;
      process.addListener = noop;
      process.once = noop;
      process.off = noop;
      process.removeListener = noop;
      process.removeAllListeners = noop;
      process.emit = noop;
      process.prependListener = noop;
      process.prependOnceListener = noop;
      process.listeners = function (name) {
        return [];
      };
      process.binding = function (name) {
        throw new Error('process.binding is not supported');
      };
      process.cwd = function () {
        return '/';
      };
      process.chdir = function (dir) {
        throw new Error('process.chdir is not supported');
      };
      process.umask = function () {
        return 0;
      };
    }, {}],
    68: [function (require, module, exports) {
      'use strict';

      /*
      node-bzip - a pure-javascript Node.JS module for decoding bzip2 data
      Copyright (C) 2012 Eli Skeggs
      This library is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License as published by the Free Software Foundation; either
      version 2.1 of the License, or (at your option) any later version.
      This library is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
      You should have received a copy of the GNU Lesser General Public
      License along with this library; if not, see
      http://www.gnu.org/licenses/lgpl-2.1.html
      Adapted from bzip2.js, copyright 2011 antimatter15 (antimatter15@gmail.com).
      Based on micro-bunzip by Rob Landley (rob@landley.net).
      Based on bzip2 decompression code by Julian R Seward (jseward@acm.org),
      which also acknowledges contributions by Mike Burrows, David Wheeler,
      Peter Fenwick, Alistair Moffat, Radford Neal, Ian H. Witten,
      Robert Sedgewick, and Jon L. Bentley.
      */
      var BITMASK = [0x00, 0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF]; // offset in bytes
      var BitReader = function BitReader(stream) {
        this.stream = stream;
        this.bitOffset = 0;
        this.curByte = 0;
        this.hasByte = false;
      };
      BitReader.prototype._ensureByte = function () {
        if (!this.hasByte) {
          this.curByte = this.stream.readByte();
          this.hasByte = true;
        }
      }; // reads bits from the buffer
      BitReader.prototype.read = function (bits) {
        var result = 0;
        while (bits > 0) {
          this._ensureByte();
          var remaining = 8 - this.bitOffset; // if we're in a byte
          if (bits >= remaining) {
            result <<= remaining;
            result |= BITMASK[remaining] & this.curByte;
            this.hasByte = false;
            this.bitOffset = 0;
            bits -= remaining;
          } else {
            result <<= bits;
            var shift = remaining - bits;
            result |= (this.curByte & BITMASK[bits] << shift) >> shift;
            this.bitOffset += bits;
            bits = 0;
          }
        }
        return result;
      }; // seek to an arbitrary point in the buffer (expressed in bits)
      BitReader.prototype.seek = function (pos) {
        var n_bit = pos % 8;
        var n_byte = (pos - n_bit) / 8;
        this.bitOffset = n_bit;
        this.stream.seek(n_byte);
        this.hasByte = false;
      }; // reads 6 bytes worth of data using the read method
      BitReader.prototype.pi = function () {
        var buf = new Uint8Array(6),
          i;
        for (i = 0; i < buf.length; i++) {
          buf[i] = this.read(8);
        }
        return bufToHex(buf);
      };
      function bufToHex(buf) {
        return Array.prototype.map.call(buf, function (x) {
          return ('00' + x.toString(16)).slice(-2);
        }).join('');
      }
      module.exports = BitReader;
    }, {}],
    69: [function (require, module, exports) {
      "use strict";

      /* CRC32, used in Bzip2 implementation.
      * This is a port of CRC32.java from the jbzip2 implementation at
      *   https://code.google.com/p/jbzip2
      * which is:
      *   Copyright (c) 2011 Matthew Francis
      *
      *   Permission is hereby granted, free of charge, to any person
      *   obtaining a copy of this software and associated documentation
      *   files (the "Software"), to deal in the Software without
      *   restriction, including without limitation the rights to use,
      *   copy, modify, merge, publish, distribute, sublicense, and/or sell
      *   copies of the Software, and to permit persons to whom the
      *   Software is furnished to do so, subject to the following
      *   conditions:
      *
      *   The above copyright notice and this permission notice shall be
      *   included in all copies or substantial portions of the Software.
      *
      *   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
      *   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
      *   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
      *   NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
      *   HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
      *   WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
      *   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
      *   OTHER DEALINGS IN THE SOFTWARE.
      * This JavaScript implementation is:
      *   Copyright (c) 2013 C. Scott Ananian
      * with the same licensing terms as Matthew Francis' original implementation.
      */
      module.exports = function () {
        /**
        * A static CRC lookup table
        */
        var crc32Lookup = new Uint32Array([0x00000000, 0x04c11db7, 0x09823b6e, 0x0d4326d9, 0x130476dc, 0x17c56b6b, 0x1a864db2, 0x1e475005, 0x2608edb8, 0x22c9f00f, 0x2f8ad6d6, 0x2b4bcb61, 0x350c9b64, 0x31cd86d3, 0x3c8ea00a, 0x384fbdbd, 0x4c11db70, 0x48d0c6c7, 0x4593e01e, 0x4152fda9, 0x5f15adac, 0x5bd4b01b, 0x569796c2, 0x52568b75, 0x6a1936c8, 0x6ed82b7f, 0x639b0da6, 0x675a1011, 0x791d4014, 0x7ddc5da3, 0x709f7b7a, 0x745e66cd, 0x9823b6e0, 0x9ce2ab57, 0x91a18d8e, 0x95609039, 0x8b27c03c, 0x8fe6dd8b, 0x82a5fb52, 0x8664e6e5, 0xbe2b5b58, 0xbaea46ef, 0xb7a96036, 0xb3687d81, 0xad2f2d84, 0xa9ee3033, 0xa4ad16ea, 0xa06c0b5d, 0xd4326d90, 0xd0f37027, 0xddb056fe, 0xd9714b49, 0xc7361b4c, 0xc3f706fb, 0xceb42022, 0xca753d95, 0xf23a8028, 0xf6fb9d9f, 0xfbb8bb46, 0xff79a6f1, 0xe13ef6f4, 0xe5ffeb43, 0xe8bccd9a, 0xec7dd02d, 0x34867077, 0x30476dc0, 0x3d044b19, 0x39c556ae, 0x278206ab, 0x23431b1c, 0x2e003dc5, 0x2ac12072, 0x128e9dcf, 0x164f8078, 0x1b0ca6a1, 0x1fcdbb16, 0x018aeb13, 0x054bf6a4, 0x0808d07d, 0x0cc9cdca, 0x7897ab07, 0x7c56b6b0, 0x71159069, 0x75d48dde, 0x6b93dddb, 0x6f52c06c, 0x6211e6b5, 0x66d0fb02, 0x5e9f46bf, 0x5a5e5b08, 0x571d7dd1, 0x53dc6066, 0x4d9b3063, 0x495a2dd4, 0x44190b0d, 0x40d816ba, 0xaca5c697, 0xa864db20, 0xa527fdf9, 0xa1e6e04e, 0xbfa1b04b, 0xbb60adfc, 0xb6238b25, 0xb2e29692, 0x8aad2b2f, 0x8e6c3698, 0x832f1041, 0x87ee0df6, 0x99a95df3, 0x9d684044, 0x902b669d, 0x94ea7b2a, 0xe0b41de7, 0xe4750050, 0xe9362689, 0xedf73b3e, 0xf3b06b3b, 0xf771768c, 0xfa325055, 0xfef34de2, 0xc6bcf05f, 0xc27dede8, 0xcf3ecb31, 0xcbffd686, 0xd5b88683, 0xd1799b34, 0xdc3abded, 0xd8fba05a, 0x690ce0ee, 0x6dcdfd59, 0x608edb80, 0x644fc637, 0x7a089632, 0x7ec98b85, 0x738aad5c, 0x774bb0eb, 0x4f040d56, 0x4bc510e1, 0x46863638, 0x42472b8f, 0x5c007b8a, 0x58c1663d, 0x558240e4, 0x51435d53, 0x251d3b9e, 0x21dc2629, 0x2c9f00f0, 0x285e1d47, 0x36194d42, 0x32d850f5, 0x3f9b762c, 0x3b5a6b9b, 0x0315d626, 0x07d4cb91, 0x0a97ed48, 0x0e56f0ff, 0x1011a0fa, 0x14d0bd4d, 0x19939b94, 0x1d528623, 0xf12f560e, 0xf5ee4bb9, 0xf8ad6d60, 0xfc6c70d7, 0xe22b20d2, 0xe6ea3d65, 0xeba91bbc, 0xef68060b, 0xd727bbb6, 0xd3e6a601, 0xdea580d8, 0xda649d6f, 0xc423cd6a, 0xc0e2d0dd, 0xcda1f604, 0xc960ebb3, 0xbd3e8d7e, 0xb9ff90c9, 0xb4bcb610, 0xb07daba7, 0xae3afba2, 0xaafbe615, 0xa7b8c0cc, 0xa379dd7b, 0x9b3660c6, 0x9ff77d71, 0x92b45ba8, 0x9675461f, 0x8832161a, 0x8cf30bad, 0x81b02d74, 0x857130c3, 0x5d8a9099, 0x594b8d2e, 0x5408abf7, 0x50c9b640, 0x4e8ee645, 0x4a4ffbf2, 0x470cdd2b, 0x43cdc09c, 0x7b827d21, 0x7f436096, 0x7200464f, 0x76c15bf8, 0x68860bfd, 0x6c47164a, 0x61043093, 0x65c52d24, 0x119b4be9, 0x155a565e, 0x18197087, 0x1cd86d30, 0x029f3d35, 0x065e2082, 0x0b1d065b, 0x0fdc1bec, 0x3793a651, 0x3352bbe6, 0x3e119d3f, 0x3ad08088, 0x2497d08d, 0x2056cd3a, 0x2d15ebe3, 0x29d4f654, 0xc5a92679, 0xc1683bce, 0xcc2b1d17, 0xc8ea00a0, 0xd6ad50a5, 0xd26c4d12, 0xdf2f6bcb, 0xdbee767c, 0xe3a1cbc1, 0xe760d676, 0xea23f0af, 0xeee2ed18, 0xf0a5bd1d, 0xf464a0aa, 0xf9278673, 0xfde69bc4, 0x89b8fd09, 0x8d79e0be, 0x803ac667, 0x84fbdbd0, 0x9abc8bd5, 0x9e7d9662, 0x933eb0bb, 0x97ffad0c, 0xafb010b1, 0xab710d06, 0xa6322bdf, 0xa2f33668, 0xbcb4666d, 0xb8757bda, 0xb5365d03, 0xb1f740b4]);
        var CRC32 = function CRC32() {
          /**
          * The current CRC
          */
          var crc = 0xffffffff; /**
                                * @return The current CRC
                                */
          this.getCRC = function () {
            return ~crc >>> 0; // return an unsigned value
          }; /**
                * Update the CRC with a single byte
                * @param value The value to update the CRC with
                */
          this.updateCRC = function (value) {
            crc = crc << 8 ^ crc32Lookup[(crc >>> 24 ^ value) & 0xff];
          }; /**
             * Update the CRC with a sequence of identical bytes
             * @param value The value to update the CRC with
             * @param count The number of bytes
             */
          this.updateCRCRun = function (value, count) {
            while (count-- > 0) {
              crc = crc << 8 ^ crc32Lookup[(crc >>> 24 ^ value) & 0xff];
            }
          };
        };
        return CRC32;
      }();
    }, {}],
    70: [function (require, module, exports) {
      'use strict';

      /*
      seek-bzip - a pure-javascript module for seeking within bzip2 data
      Copyright (C) 2013 C. Scott Ananian
      Copyright (C) 2012 Eli Skeggs
      Copyright (C) 2011 Kevin Kwok
      This library is free software; you can redistribute it and/or
      modify it under the terms of the GNU Lesser General Public
      License as published by the Free Software Foundation; either
      version 2.1 of the License, or (at your option) any later version.
      This library is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
      Lesser General Public License for more details.
      You should have received a copy of the GNU Lesser General Public
      License along with this library; if not, see
      http://www.gnu.org/licenses/lgpl-2.1.html
      Adapted from node-bzip, copyright 2012 Eli Skeggs.
      Adapted from bzip2.js, copyright 2011 Kevin Kwok (antimatter15@gmail.com).
      Based on micro-bunzip by Rob Landley (rob@landley.net).
      Based on bzip2 decompression code by Julian R Seward (jseward@acm.org),
      which also acknowledges contributions by Mike Burrows, David Wheeler,
      Peter Fenwick, Alistair Moffat, Radford Neal, Ian H. Witten,
      Robert Sedgewick, and Jon L. Bentley.
      */
      var BitReader = require('./bitreader');
      var Stream = require('./stream');
      var CRC32 = require('./crc32');
      var MAX_HUFCODE_BITS = 20;
      var MAX_SYMBOLS = 258;
      var SYMBOL_RUNA = 0;
      var SYMBOL_RUNB = 1;
      var MIN_GROUPS = 2;
      var MAX_GROUPS = 6;
      var GROUP_SIZE = 50;
      var WHOLEPI = "314159265359";
      var SQRTPI = "177245385090";
      var mtf = function mtf(array, index) {
        var src = array[index],
          i;
        for (i = index; i > 0; i--) {
          array[i] = array[i - 1];
        }
        array[0] = src;
        return src;
      };
      var Err = {
        OK: 0,
        LAST_BLOCK: -1,
        NOT_BZIP_DATA: -2,
        UNEXPECTED_INPUT_EOF: -3,
        UNEXPECTED_OUTPUT_EOF: -4,
        DATA_ERROR: -5,
        OUT_OF_MEMORY: -6,
        OBSOLETE_INPUT: -7,
        END_OF_BLOCK: -8
      };
      var ErrorMessages = {};
      ErrorMessages[Err.LAST_BLOCK] = "Bad file checksum";
      ErrorMessages[Err.NOT_BZIP_DATA] = "Not bzip data";
      ErrorMessages[Err.UNEXPECTED_INPUT_EOF] = "Unexpected input EOF";
      ErrorMessages[Err.UNEXPECTED_OUTPUT_EOF] = "Unexpected output EOF";
      ErrorMessages[Err.DATA_ERROR] = "Data error";
      ErrorMessages[Err.OUT_OF_MEMORY] = "Out of memory";
      ErrorMessages[Err.OBSOLETE_INPUT] = "Obsolete (pre 0.9.5) bzip format not supported.";
      var _throw = function _throw(status, optDetail) {
        var msg = ErrorMessages[status] || 'unknown error';
        if (optDetail) {
          msg += ': ' + optDetail;
        }
        var e = new TypeError(msg);
        e.errorCode = status;
        throw e;
      };
      var Bunzip = function Bunzip(inputStream, outputStream) {
        this.writePos = this.writeCurrent = this.writeCount = 0;
        this._start_bunzip(inputStream, outputStream);
      };
      Bunzip.prototype._init_block = function () {
        var moreBlocks = this._get_next_block();
        if (!moreBlocks) {
          this.writeCount = -1;
          return false; /* no more blocks */
        }
        this.blockCRC = new CRC32();
        return true;
      }; /* XXX micro-bunzip uses (inputStream, inputBuffer, len) as arguments */
      Bunzip.prototype._start_bunzip = function (inputStream, outputStream) {
        /* Ensure that file starts with "BZh['1'-'9']." */var buf = new Uint8Array(4);
        if (inputStream.read(buf, 0, 4) !== 4 || String.fromCharCode(buf[0], buf[1], buf[2]) !== 'BZh') _throw(Err.NOT_BZIP_DATA, 'bad magic');
        var level = buf[3] - 0x30;
        if (level < 1 || level > 9) _throw(Err.NOT_BZIP_DATA, 'level out of range');
        this.reader = new BitReader(inputStream); /* Fourth byte (ascii '1'-'9'), indicates block size in units of 100k of
                                                  uncompressed data.  Allocate intermediate buffer for block. */
        this.dbufSize = 100000 * level;
        this.nextoutput = 0;
        this.outputStream = outputStream;
        this.streamCRC = 0;
      };
      Bunzip.prototype._get_next_block = function () {
        var i, j, k;
        var reader = this.reader; // this is get_next_block() function from micro-bunzip:
        /* Read in header signature and CRC, then validate signature.
             (last block signature means CRC is for whole file, return now) */
        var h = reader.pi();
        if (h === SQRTPI) {
          // last block
          return false; /* no more blocks */
        }
        if (h !== WHOLEPI) _throw(Err.NOT_BZIP_DATA);
        this.targetBlockCRC = reader.read(32) >>> 0; // (convert to unsigned)
        this.streamCRC = (this.targetBlockCRC ^ (this.streamCRC << 1 | this.streamCRC >>> 31)) >>> 0; /* We can add support for blockRandomised if anybody complains.  There was
                                                                                                      some code for this in busybox 1.0.0-pre3, but nobody ever noticed that
                                                                                                      it didn't actually work. */
        if (reader.read(1)) _throw(Err.OBSOLETE_INPUT);
        var origPointer = reader.read(24);
        if (origPointer > this.dbufSize) _throw(Err.DATA_ERROR, 'initial position out of bounds'); /* mapping table: if some byte values are never used (encoding things
                                                                                                   like ascii text), the compression code removes the gaps to have fewer
                                                                                                   symbols to deal with, and writes a sparse bitfield indicating which
                                                                                                   values were present.  We make a translation table to convert the symbols
                                                                                                   back to the corresponding bytes. */
        var t = reader.read(16);
        var symToByte = new Uint8Array(256),
          symTotal = 0;
        for (i = 0; i < 16; i++) {
          if (t & 1 << 0xF - i) {
            var o = i * 16;
            k = reader.read(16);
            for (j = 0; j < 16; j++) {
              if (k & 1 << 0xF - j) symToByte[symTotal++] = o + j;
            }
          }
        } /* How many different huffman coding groups does this block use? */
        var groupCount = reader.read(3);
        if (groupCount < MIN_GROUPS || groupCount > MAX_GROUPS) _throw(Err.DATA_ERROR); /* nSelectors: Every GROUP_SIZE many symbols we select a new huffman coding
                                                                                        group.  Read in the group selector list, which is stored as MTF encoded
                                                                                        bit runs.  (MTF=Move To Front, as each value is used it's moved to the
                                                                                        start of the list.) */
        var nSelectors = reader.read(15);
        if (nSelectors === 0) _throw(Err.DATA_ERROR);
        var mtfSymbol = new Uint8Array(256);
        for (i = 0; i < groupCount; i++) {
          mtfSymbol[i] = i;
        }
        var selectors = new Uint8Array(nSelectors); // was 32768...
        for (i = 0; i < nSelectors; i++) {
          /* Get next value */for (j = 0; reader.read(1); j++) {
            if (j >= groupCount) _throw(Err.DATA_ERROR);
          } /* Decode MTF to get the next selector */
          selectors[i] = mtf(mtfSymbol, j);
        } /* Read the huffman coding tables for each group, which code for symTotal
          literal symbols, plus two run symbols (RUNA, RUNB) */
        var symCount = symTotal + 2;
        var groups = [],
          hufGroup;
        for (j = 0; j < groupCount; j++) {
          var length = new Uint8Array(symCount),
            temp = new Uint16Array(MAX_HUFCODE_BITS + 1); /* Read huffman code lengths for each symbol.  They're stored in
                                                          a way similar to mtf; record a starting value for the first symbol,
                                                          and an offset from the previous value for everys symbol after that. */
          t = reader.read(5); // lengths
          for (i = 0; i < symCount; i++) {
            for (;;) {
              if (t < 1 || t > MAX_HUFCODE_BITS) _throw(Err.DATA_ERROR); /* If first bit is 0, stop.  Else second bit indicates whether
                                                                         to increment or decrement the value. */
              if (!reader.read(1)) break;
              if (!reader.read(1)) t++;else t--;
            }
            length[i] = t;
          } /* Find largest and smallest lengths in this group */
          var minLen, maxLen;
          minLen = maxLen = length[0];
          for (i = 1; i < symCount; i++) {
            if (length[i] > maxLen) maxLen = length[i];else if (length[i] < minLen) minLen = length[i];
          } /* Calculate permute[], base[], and limit[] tables from length[].
            *
            * permute[] is the lookup table for converting huffman coded symbols
            * into decoded symbols.  base[] is the amount to subtract from the
            * value of a huffman symbol of a given length when using permute[].
            *
            * limit[] indicates the largest numerical value a symbol with a given
            * number of bits can have.  This is how the huffman codes can vary in
            * length: each code with a value>limit[length] needs another bit.
            */
          hufGroup = {};
          groups.push(hufGroup);
          hufGroup.permute = new Uint16Array(MAX_SYMBOLS);
          hufGroup.limit = new Uint32Array(MAX_HUFCODE_BITS + 2);
          hufGroup.base = new Uint32Array(MAX_HUFCODE_BITS + 1);
          hufGroup.minLen = minLen;
          hufGroup.maxLen = maxLen; /* Calculate permute[].  Concurently, initialize temp[] and limit[]. */
          var pp = 0;
          for (i = minLen; i <= maxLen; i++) {
            temp[i] = hufGroup.limit[i] = 0;
            for (t = 0; t < symCount; t++) {
              if (length[t] === i) hufGroup.permute[pp++] = t;
            }
          } /* Count symbols coded for at each bit length */
          for (i = 0; i < symCount; i++) {
            temp[length[i]]++;
          } /* Calculate limit[] (the largest symbol-coding value at each bit
            * length, which is (previous limit<<1)+symbols at this level), and
            * base[] (number of symbols to ignore at each bit length, which is
            * limit minus the cumulative count of symbols coded for already). */
          pp = t = 0;
          for (i = minLen; i < maxLen; i++) {
            pp += temp[i]; /* We read the largest possible symbol size and then unget bits
                           after determining how many we need, and those extra bits could
                           be set to anything.  (They're noise from future symbols.)  At
                           each level we're really only interested in the first few bits,
                           so here we set all the trailing to-be-ignored bits to 1 so they
                           don't affect the value>limit[length] comparison. */
            hufGroup.limit[i] = pp - 1;
            pp <<= 1;
            t += temp[i];
            hufGroup.base[i + 1] = pp - t;
          }
          hufGroup.limit[maxLen + 1] = Number.MAX_VALUE; /* Sentinal value for reading next sym. */
          hufGroup.limit[maxLen] = pp + temp[maxLen] - 1;
          hufGroup.base[minLen] = 0;
        } /* We've finished reading and digesting the block header.  Now read this
          block's huffman coded symbols from the file and undo the huffman coding
          and run length encoding, saving the result into dbuf[dbufCount++]=uc */ /* Initialize symbol occurrence counters and symbol Move To Front table */
        var byteCount = new Uint32Array(256);
        for (i = 0; i < 256; i++) {
          mtfSymbol[i] = i;
        } /* Loop through compressed symbols. */
        var runPos = 0,
          dbufCount = 0,
          selector = 0,
          uc;
        var dbuf = this.dbuf = new Uint32Array(this.dbufSize);
        symCount = 0;
        for (;;) {
          /* Determine which huffman coding group to use. */if (!symCount--) {
            symCount = GROUP_SIZE - 1;
            if (selector >= nSelectors) {
              _throw(Err.DATA_ERROR);
            }
            hufGroup = groups[selectors[selector++]];
          } /* Read next huffman-coded symbol. */
          i = hufGroup.minLen;
          j = reader.read(i);
          for (;; i++) {
            if (i > hufGroup.maxLen) {
              _throw(Err.DATA_ERROR);
            }
            if (j <= hufGroup.limit[i]) break;
            j = j << 1 | reader.read(1);
          } /* Huffman decode value to get nextSym (with bounds checking) */
          j -= hufGroup.base[i];
          if (j < 0 || j >= MAX_SYMBOLS) {
            _throw(Err.DATA_ERROR);
          }
          var nextSym = hufGroup.permute[j]; /* We have now decoded the symbol, which indicates either a new literal
                                             byte, or a repeated run of the most recent literal byte.  First,
                                             check if nextSym indicates a repeated run, and if so loop collecting
                                             how many times to repeat the last literal. */
          if (nextSym === SYMBOL_RUNA || nextSym === SYMBOL_RUNB) {
            /* If this is the start of a new run, zero out counter */if (!runPos) {
              runPos = 1;
              t = 0;
            } /* Neat trick that saves 1 symbol: instead of or-ing 0 or 1 at
              each bit position, add 1 or 2 instead.  For example,
              1011 is 1<<0 + 1<<1 + 2<<2.  1010 is 2<<0 + 2<<1 + 1<<2.
              You can make any bit pattern that way using 1 less symbol than
              the basic or 0/1 method (except all bits 0, which would use no
              symbols, but a run of length 0 doesn't mean anything in this
              context).  Thus space is saved. */
            if (nextSym === SYMBOL_RUNA) t += runPos;else t += 2 * runPos;
            runPos <<= 1;
            continue;
          } /* When we hit the first non-run symbol after a run, we now know
            how many times to repeat the last literal, so append that many
            copies to our buffer of decoded symbols (dbuf) now.  (The last
            literal used is the one at the head of the mtfSymbol array.) */
          if (runPos) {
            runPos = 0;
            if (dbufCount + t > this.dbufSize) {
              _throw(Err.DATA_ERROR);
            }
            uc = symToByte[mtfSymbol[0]];
            byteCount[uc] += t;
            while (t--) {
              dbuf[dbufCount++] = uc;
            }
          } /* Is this the terminating symbol? */
          if (nextSym > symTotal) break; /* At this point, nextSym indicates a new literal character.  Subtract
                                         one to get the position in the MTF array at which this literal is
                                         currently to be found.  (Note that the result can't be -1 or 0,
                                         because 0 and 1 are RUNA and RUNB.  But another instance of the
                                         first symbol in the mtf array, position 0, would have been handled
                                         as part of a run above.  Therefore 1 unused mtf position minus
                                         2 non-literal nextSym values equals -1.) */
          if (dbufCount >= this.dbufSize) {
            _throw(Err.DATA_ERROR);
          }
          i = nextSym - 1;
          uc = mtf(mtfSymbol, i);
          uc = symToByte[uc]; /* We have our literal byte.  Save it into dbuf. */
          byteCount[uc]++;
          dbuf[dbufCount++] = uc;
        } /* At this point, we've read all the huffman-coded symbols (and repeated
          runs) for this block from the input stream, and decoded them into the
          intermediate buffer.  There are dbufCount many decoded bytes in dbuf[].
          Now undo the Burrows-Wheeler transform on dbuf.
          See http://dogma.net/markn/articles/bwt/bwt.htm
          */
        if (origPointer < 0 || origPointer >= dbufCount) {
          _throw(Err.DATA_ERROR);
        } /* Turn byteCount into cumulative occurrence counts of 0 to n-1. */
        j = 0;
        for (i = 0; i < 256; i++) {
          k = j + byteCount[i];
          byteCount[i] = j;
          j = k;
        } /* Figure out what order dbuf would be in if we sorted it. */
        for (i = 0; i < dbufCount; i++) {
          uc = dbuf[i] & 0xff;
          dbuf[byteCount[uc]] |= i << 8;
          byteCount[uc]++;
        } /* Decode first byte by hand to initialize "previous" byte.  Note that it
          doesn't get output, and if the first three characters are identical
          it doesn't qualify as a run (hence writeRunCountdown=5). */
        var pos = 0,
          current = 0,
          run = 0;
        if (dbufCount) {
          pos = dbuf[origPointer];
          current = pos & 0xff;
          pos >>= 8;
          run = -1;
        }
        this.writePos = pos;
        this.writeCurrent = current;
        this.writeCount = dbufCount;
        this.writeRun = run;
        return true; /* more blocks to come */
      }; /* Undo burrows-wheeler transform on intermediate buffer to produce output.
         If start_bunzip was initialized with out_fd=-1, then up to len bytes of
         data are written to outbuf.  Return value is number of bytes written or
         error (all errors are negative numbers).  If out_fd!=-1, outbuf and len
         are ignored, data is written to out_fd and return is RETVAL_OK or error.
         */
      Bunzip.prototype._read_bunzip = function (outputBuffer, len) {
        var copies, previous, outbyte; /* james@jamestaylor.org: writeCount goes to -1 when the buffer is fully
                                       decoded, which results in this returning RETVAL_LAST_BLOCK, also
                                       equal to -1... Confusing, I'm returning 0 here to indicate no
                                       bytes written into the buffer */
        if (this.writeCount < 0) {
          return 0;
        }
        var gotcount = 0;
        var dbuf = this.dbuf,
          pos = this.writePos,
          current = this.writeCurrent;
        var dbufCount = this.writeCount,
          outputsize = this.outputsize;
        var run = this.writeRun;
        while (dbufCount) {
          dbufCount--;
          previous = current;
          pos = dbuf[pos];
          current = pos & 0xff;
          pos >>= 8;
          if (run++ === 3) {
            copies = current;
            outbyte = previous;
            current = -1;
          } else {
            copies = 1;
            outbyte = current;
          }
          this.blockCRC.updateCRCRun(outbyte, copies);
          while (copies--) {
            this.outputStream.writeByte(outbyte);
            this.nextoutput++;
          }
          if (current != previous) run = 0;
        }
        this.writeCount = dbufCount; // check CRC
        if (this.blockCRC.getCRC() !== this.targetBlockCRC) {
          _throw(Err.DATA_ERROR, "Bad block CRC " + "(got " + this.blockCRC.getCRC().toString(16) + " expected " + this.targetBlockCRC.toString(16) + ")");
        }
        return this.nextoutput;
      };
      var coerceInputStream = function coerceInputStream(input) {
        if ('readByte' in input) {
          return input;
        }
        var inputStream = new Stream();
        inputStream.pos = 0;
        inputStream.readByte = function () {
          return input[this.pos++];
        };
        inputStream.seek = function (pos) {
          this.pos = pos;
        };
        inputStream.eof = function () {
          return this.pos >= input.length;
        };
        return inputStream;
      };
      var coerceOutputStream = function coerceOutputStream(output) {
        var outputStream = new Stream();
        var resizeOk = true;
        if (output) {
          if (typeof output === 'number') {
            outputStream.buffer = new Uint8Array(output);
            resizeOk = false;
          } else if ('writeByte' in output) {
            return output;
          } else {
            outputStream.buffer = output;
            resizeOk = false;
          }
        } else {
          outputStream.buffer = new Uint8Array(16384);
        }
        outputStream.pos = 0;
        outputStream.writeByte = function (_byte) {
          if (resizeOk && this.pos >= this.buffer.length) {
            var newBuffer = new Uint8Array(this.buffer.length * 2);
            newBuffer.set(this.buffer);
            this.buffer = newBuffer;
          }
          this.buffer[this.pos++] = _byte;
        };
        outputStream.getBuffer = function () {
          // trim buffer
          if (this.pos !== this.buffer.length) {
            if (!resizeOk) throw new TypeError('outputsize does not match decoded input');
            var newBuffer = new Uint8Array(this.pos);
            newBuffer.set(this.buffer.subarray(0, this.pos));
            this.buffer = newBuffer;
          }
          return this.buffer;
        };
        outputStream._coerced = true;
        return outputStream;
      }; /* Static helper functions */
      Bunzip.Err = Err; // 'input' can be a stream or a buffer
      // 'output' can be a stream or a buffer or a number (buffer size)
      Bunzip.decode = function (input, output, multistream) {
        // make a stream from a buffer, if necessary
        var inputStream = coerceInputStream(input);
        var outputStream = coerceOutputStream(output);
        var bz = new Bunzip(inputStream, outputStream);
        while (true) {
          if ('eof' in inputStream && inputStream.eof()) break;
          if (bz._init_block()) {
            bz._read_bunzip();
          } else {
            var targetStreamCRC = bz.reader.read(32) >>> 0; // (convert to unsigned)
            if (targetStreamCRC !== bz.streamCRC) {
              _throw(Err.DATA_ERROR, "Bad stream CRC " + "(got " + bz.streamCRC.toString(16) + " expected " + targetStreamCRC.toString(16) + ")");
            }
            if (multistream && 'eof' in inputStream && !inputStream.eof()) {
              // note that start_bunzip will also resync the bit reader to next byte
              bz._start_bunzip(inputStream, outputStream);
            } else break;
          }
        }
        if ('getBuffer' in outputStream) return outputStream.getBuffer();
      };
      Bunzip.decodeBlock = function (input, pos, output) {
        // make a stream from a buffer, if necessary
        var inputStream = coerceInputStream(input);
        var outputStream = coerceOutputStream(output);
        var bz = new Bunzip(inputStream, outputStream);
        bz.reader.seek(pos); /* Fill the decode buffer for the block */
        var moreBlocks = bz._get_next_block();
        if (moreBlocks) {
          /* Init the CRC for writing */bz.blockCRC = new CRC32(); /* Zero this so the current byte from before the seek is not written */
          bz.writeCopies = 0; /* Decompress the block and write to stdout */
          bz._read_bunzip(); // XXX keep writing?
        }
        if ('getBuffer' in outputStream) return outputStream.getBuffer();
      }; /* Reads bzip2 file from stream or buffer `input`, and invoke
         * `callback(position, size)` once for each bzip2 block,
         * where position gives the starting position (in *bits*)
         * and size gives uncompressed size of the block (in *bytes*). */
      Bunzip.table = function (input, callback, multistream) {
        // make a stream from a buffer, if necessary
        var inputStream = new Stream();
        inputStream.delegate = coerceInputStream(input);
        inputStream.pos = 0;
        inputStream.readByte = function () {
          this.pos++;
          return this.delegate.readByte();
        };
        if (inputStream.delegate.eof) {
          inputStream.eof = inputStream.delegate.eof.bind(inputStream.delegate);
        }
        var outputStream = new Stream();
        outputStream.pos = 0;
        outputStream.writeByte = function () {
          this.pos++;
        };
        var bz = new Bunzip(inputStream, outputStream);
        var blockSize = bz.dbufSize;
        while (true) {
          if ('eof' in inputStream && inputStream.eof()) break;
          var position = inputStream.pos * 8 + bz.reader.bitOffset;
          if (bz.reader.hasByte) {
            position -= 8;
          }
          if (bz._init_block()) {
            var start = outputStream.pos;
            bz._read_bunzip();
            callback(position, outputStream.pos - start);
          } else {
            var crc = bz.reader.read(32); // (but we ignore the crc)
            if (multistream && 'eof' in inputStream && !inputStream.eof()) {
              // note that start_bunzip will also resync the bit reader to next byte
              bz._start_bunzip(inputStream, outputStream);
              console.assert(bz.dbufSize === blockSize, "shouldn't change block size within multistream file");
            } else break;
          }
        }
      };
      Bunzip.Stream = Stream;
      module.exports = Bunzip;
    }, {
      "./bitreader": 68,
      "./crc32": 69,
      "./stream": 71
    }],
    71: [function (require, module, exports) {
      "use strict";

      /* very simple input/output stream interface */
      var Stream = function Stream() {}; // input streams //////////////
      /** Returns the next byte, or -1 for EOF. */
      Stream.prototype.readByte = function () {
        throw new Error("abstract method readByte() not implemented");
      }; /** Attempts to fill the buffer; returns number of bytes read, or
         *  -1 for EOF. */
      Stream.prototype.read = function (buffer, bufOffset, length) {
        var bytesRead = 0;
        while (bytesRead < length) {
          var c = this.readByte();
          if (c < 0) {
            // EOF
            return bytesRead === 0 ? -1 : bytesRead;
          }
          buffer[bufOffset++] = c;
          bytesRead++;
        }
        return bytesRead;
      };
      Stream.prototype.seek = function (new_pos) {
        throw new Error("abstract method seek() not implemented");
      }; // output streams ///////////
      Stream.prototype.writeByte = function (_byte) {
        throw new Error("abstract method readByte() not implemented");
      };
      Stream.prototype.write = function (buffer, bufOffset, length) {
        var i;
        for (i = 0; i < length; i++) {
          this.writeByte(buffer[bufOffset++]);
        }
        return length;
      };
      Stream.prototype.flush = function () {};
      module.exports = Stream;
    }, {}],
    72: [function (require, module, exports) {
      'use strict';

      // This is free and unencumbered software released into the public domain.
      // See LICENSE.md for more information.
      //
      // Utilities
      //
      /**
       * @param {number} a The number to test.
       * @param {number} min The minimum value in the range, inclusive.
       * @param {number} max The maximum value in the range, inclusive.
       * @return {boolean} True if a >= min and a <= max.
       */
      function inRange(a, min, max) {
        return min <= a && a <= max;
      } /**
        * @param {*} o
        * @return {Object}
        */
      function ToDictionary(o) {
        if (o === undefined) return {};
        if (o === Object(o)) return o;
        throw TypeError('Could not convert argument to dictionary');
      } /**
        * @param {string} string Input string of UTF-16 code units.
        * @return {!Array.<number>} Code points.
        */
      function stringToCodePoints(string) {
        // https://heycam.github.io/webidl/#dfn-obtain-unicode
        // 1. Let S be the DOMString value.
        var s = String(string); // 2. Let n be the length of S.
        var n = s.length; // 3. Initialize i to 0.
        var i = 0; // 4. Initialize U to be an empty sequence of Unicode characters.
        var u = []; // 5. While i < n:
        while (i < n) {
          // 1. Let c be the code unit in S at index i.
          var c = s.charCodeAt(i); // 2. Depending on the value of c:
          // c < 0xD800 or c > 0xDFFF
          if (c < 0xD800 || c > 0xDFFF) {
            // Append to U the Unicode character with code point c.
            u.push(c);
          } // 0xDC00 ≤ c ≤ 0xDFFF
          else if (0xDC00 <= c && c <= 0xDFFF) {
            // Append to U a U+FFFD REPLACEMENT CHARACTER.
            u.push(0xFFFD);
          } // 0xD800 ≤ c ≤ 0xDBFF
          else if (0xD800 <= c && c <= 0xDBFF) {
            // 1. If i = n−1, then append to U a U+FFFD REPLACEMENT
            // CHARACTER.
            if (i === n - 1) {
              u.push(0xFFFD);
            } // 2. Otherwise, i < n−1:
            else {
              // 1. Let d be the code unit in S at index i+1.
              var d = string.charCodeAt(i + 1); // 2. If 0xDC00 ≤ d ≤ 0xDFFF, then:
              if (0xDC00 <= d && d <= 0xDFFF) {
                // 1. Let a be c & 0x3FF.
                var a = c & 0x3FF; // 2. Let b be d & 0x3FF.
                var b = d & 0x3FF; // 3. Append to U the Unicode character with code point
                // 2^16+2^10*a+b.
                u.push(0x10000 + (a << 10) + b); // 4. Set i to i+1.
                i += 1;
              } // 3. Otherwise, d < 0xDC00 or d > 0xDFFF. Append to U a
              // U+FFFD REPLACEMENT CHARACTER.
              else {
                u.push(0xFFFD);
              }
            }
          } // 3. Set i to i+1.
          i += 1;
        } // 6. Return U.
        return u;
      } /**
        * @param {!Array.<number>} code_points Array of code points.
        * @return {string} string String of UTF-16 code units.
        */
      function codePointsToString(code_points) {
        var s = '';
        for (var i = 0; i < code_points.length; ++i) {
          var cp = code_points[i];
          if (cp <= 0xFFFF) {
            s += String.fromCharCode(cp);
          } else {
            cp -= 0x10000;
            s += String.fromCharCode((cp >> 10) + 0xD800, (cp & 0x3FF) + 0xDC00);
          }
        }
        return s;
      } //
      // Implementation of Encoding specification
      // https://encoding.spec.whatwg.org/
      //
      //
      // 3. Terminology
      //
      /**
       * End-of-stream is a special token that signifies no more tokens
       * are in the stream.
       * @const
       */
      var end_of_stream = -1; /**
                              * A stream represents an ordered sequence of tokens.
                              *
                              * @constructor
                              * @param {!(Array.<number>|Uint8Array)} tokens Array of tokens that provide the
                              * stream.
                              */
      function Stream(tokens) {
        /** @type {!Array.<number>} */this.tokens = [].slice.call(tokens);
      }
      Stream.prototype = {
        /**
        * @return {boolean} True if end-of-stream has been hit.
        */
        endOfStream: function endOfStream() {
          return !this.tokens.length;
        },
        /**
        * When a token is read from a stream, the first token in the
        * stream must be returned and subsequently removed, and
        * end-of-stream must be returned otherwise.
        *
        * @return {number} Get the next token from the stream, or
        * end_of_stream.
        */
        read: function read() {
          if (!this.tokens.length) return end_of_stream;
          return this.tokens.shift();
        },
        /**
        * When one or more tokens are prepended to a stream, those tokens
        * must be inserted, in given order, before the first token in the
        * stream.
        *
        * @param {(number|!Array.<number>)} token The token(s) to prepend to the stream.
        */
        prepend: function prepend(token) {
          if (Array.isArray(token)) {
            var tokens = /**@type {!Array.<number>}*/token;
            while (tokens.length) {
              this.tokens.unshift(tokens.pop());
            }
          } else {
            this.tokens.unshift(token);
          }
        },
        /**
        * When one or more tokens are pushed to a stream, those tokens
        * must be inserted, in given order, after the last token in the
        * stream.
        *
        * @param {(number|!Array.<number>)} token The tokens(s) to prepend to the stream.
        */
        push: function push(token) {
          if (Array.isArray(token)) {
            var tokens = /**@type {!Array.<number>}*/token;
            while (tokens.length) {
              this.tokens.push(tokens.shift());
            }
          } else {
            this.tokens.push(token);
          }
        }
      }; //
      // 4. Encodings
      //
      // 4.1 Encoders and decoders
      /** @const */
      var finished = -1; /**
                         * @param {boolean} fatal If true, decoding errors raise an exception.
                         * @param {number=} opt_code_point Override the standard fallback code point.
                         * @return {number} The code point to insert on a decoding error.
                         */
      function decoderError(fatal, opt_code_point) {
        if (fatal) throw TypeError('Decoder error');
        return opt_code_point || 0xFFFD;
      } //
      // 7. API
      //
      /** @const */
      var DEFAULT_ENCODING = 'utf-8'; // 7.1 Interface TextDecoder
      /**
       * @constructor
       * @param {string=} encoding The label of the encoding;
       *     defaults to 'utf-8'.
       * @param {Object=} options
       */
      function TextDecoder(encoding, options) {
        if (!_instanceof(this, TextDecoder)) {
          return new TextDecoder(encoding, options);
        }
        encoding = encoding !== undefined ? String(encoding).toLowerCase() : DEFAULT_ENCODING;
        if (encoding !== DEFAULT_ENCODING) {
          throw new Error('Encoding not supported. Only utf-8 is supported');
        }
        options = ToDictionary(options); /** @private @type {boolean} */
        this._streaming = false; /** @private @type {boolean} */
        this._BOMseen = false; /** @private @type {?Decoder} */
        this._decoder = null; /** @private @type {boolean} */
        this._fatal = Boolean(options['fatal']); /** @private @type {boolean} */
        this._ignoreBOM = Boolean(options['ignoreBOM']);
        Object.defineProperty(this, 'encoding', {
          value: 'utf-8'
        });
        Object.defineProperty(this, 'fatal', {
          value: this._fatal
        });
        Object.defineProperty(this, 'ignoreBOM', {
          value: this._ignoreBOM
        });
      }
      TextDecoder.prototype = {
        /**
        * @param {ArrayBufferView=} input The buffer of bytes to decode.
        * @param {Object=} options
        * @return {string} The decoded string.
        */
        decode: function decode(input, options) {
          var bytes;
          if (_typeof(input) === 'object' && _instanceof(input, ArrayBuffer)) {
            bytes = new Uint8Array(input);
          } else if (_typeof(input) === 'object' && 'buffer' in input && _instanceof(input.buffer, ArrayBuffer)) {
            bytes = new Uint8Array(input.buffer, input.byteOffset, input.byteLength);
          } else {
            bytes = new Uint8Array(0);
          }
          options = ToDictionary(options);
          if (!this._streaming) {
            this._decoder = new UTF8Decoder({
              fatal: this._fatal
            });
            this._BOMseen = false;
          }
          this._streaming = Boolean(options['stream']);
          var input_stream = new Stream(bytes);
          var code_points = []; /** @type {?(number|!Array.<number>)} */
          var result;
          while (!input_stream.endOfStream()) {
            result = this._decoder.handler(input_stream, input_stream.read());
            if (result === finished) break;
            if (result === null) continue;
            if (Array.isArray(result)) code_points.push.apply(code_points, /**@type {!Array.<number>}*/result);else code_points.push(result);
          }
          if (!this._streaming) {
            do {
              result = this._decoder.handler(input_stream, input_stream.read());
              if (result === finished) break;
              if (result === null) continue;
              if (Array.isArray(result)) code_points.push.apply(code_points, /**@type {!Array.<number>}*/result);else code_points.push(result);
            } while (!input_stream.endOfStream());
            this._decoder = null;
          }
          if (code_points.length) {
            // If encoding is one of utf-8, utf-16be, and utf-16le, and
            // ignore BOM flag and BOM seen flag are unset, run these
            // subsubsteps:
            if (['utf-8'].indexOf(this.encoding) !== -1 && !this._ignoreBOM && !this._BOMseen) {
              // If token is U+FEFF, set BOM seen flag.
              if (code_points[0] === 0xFEFF) {
                this._BOMseen = true;
                code_points.shift();
              } else {
                // Otherwise, if token is not end-of-stream, set BOM seen
                // flag and append token to output.
                this._BOMseen = true;
              }
            }
          }
          return codePointsToString(code_points);
        }
      }; // 7.2 Interface TextEncoder
      /**
       * @constructor
       * @param {string=} encoding The label of the encoding;
       *     defaults to 'utf-8'.
       * @param {Object=} options
       */
      function TextEncoder(encoding, options) {
        if (!_instanceof(this, TextEncoder)) return new TextEncoder(encoding, options);
        encoding = encoding !== undefined ? String(encoding).toLowerCase() : DEFAULT_ENCODING;
        if (encoding !== DEFAULT_ENCODING) {
          throw new Error('Encoding not supported. Only utf-8 is supported');
        }
        options = ToDictionary(options); /** @private @type {boolean} */
        this._streaming = false; /** @private @type {?Encoder} */
        this._encoder = null; /** @private @type {{fatal: boolean}} */
        this._options = {
          fatal: Boolean(options['fatal'])
        };
        Object.defineProperty(this, 'encoding', {
          value: 'utf-8'
        });
      }
      TextEncoder.prototype = {
        /**
        * @param {string=} opt_string The string to encode.
        * @param {Object=} options
        * @return {Uint8Array} Encoded bytes, as a Uint8Array.
        */
        encode: function encode(opt_string, options) {
          opt_string = opt_string ? String(opt_string) : '';
          options = ToDictionary(options); // NOTE: This option is nonstandard. None of the encodings
          // permitted for encoding (i.e. UTF-8, UTF-16) are stateful,
          // so streaming is not necessary.
          if (!this._streaming) this._encoder = new UTF8Encoder(this._options);
          this._streaming = Boolean(options['stream']);
          var bytes = [];
          var input_stream = new Stream(stringToCodePoints(opt_string)); /** @type {?(number|!Array.<number>)} */
          var result;
          while (!input_stream.endOfStream()) {
            result = this._encoder.handler(input_stream, input_stream.read());
            if (result === finished) break;
            if (Array.isArray(result)) bytes.push.apply(bytes, /**@type {!Array.<number>}*/result);else bytes.push(result);
          }
          if (!this._streaming) {
            while (true) {
              result = this._encoder.handler(input_stream, input_stream.read());
              if (result === finished) break;
              if (Array.isArray(result)) bytes.push.apply(bytes, /**@type {!Array.<number>}*/result);else bytes.push(result);
            }
            this._encoder = null;
          }
          return new Uint8Array(bytes);
        }
      }; //
      // 8. The encoding
      //
      // 8.1 utf-8
      /**
       * @constructor
       * @implements {Decoder}
       * @param {{fatal: boolean}} options
       */
      function UTF8Decoder(options) {
        var fatal = options.fatal; // utf-8's decoder's has an associated utf-8 code point, utf-8
        // bytes seen, and utf-8 bytes needed (all initially 0), a utf-8
        // lower boundary (initially 0x80), and a utf-8 upper boundary
        // (initially 0xBF).
        var /** @type {number} */utf8_code_point = 0,
          /** @type {number} */utf8_bytes_seen = 0,
          /** @type {number} */utf8_bytes_needed = 0,
          /** @type {number} */utf8_lower_boundary = 0x80,
          /** @type {number} */utf8_upper_boundary = 0xBF; /**
                                                           * @param {Stream} stream The stream of bytes being decoded.
                                                           * @param {number} bite The next byte read from the stream.
                                                           * @return {?(number|!Array.<number>)} The next code point(s)
                                                           *     decoded, or null if not enough data exists in the input
                                                           *     stream to decode a complete code point.
                                                           */
        this.handler = function (stream, bite) {
          // 1. If byte is end-of-stream and utf-8 bytes needed is not 0,
          // set utf-8 bytes needed to 0 and return error.
          if (bite === end_of_stream && utf8_bytes_needed !== 0) {
            utf8_bytes_needed = 0;
            return decoderError(fatal);
          } // 2. If byte is end-of-stream, return finished.
          if (bite === end_of_stream) return finished; // 3. If utf-8 bytes needed is 0, based on byte:
          if (utf8_bytes_needed === 0) {
            // 0x00 to 0x7F
            if (inRange(bite, 0x00, 0x7F)) {
              // Return a code point whose value is byte.
              return bite;
            } // 0xC2 to 0xDF
            if (inRange(bite, 0xC2, 0xDF)) {
              // Set utf-8 bytes needed to 1 and utf-8 code point to byte
              // − 0xC0.
              utf8_bytes_needed = 1;
              utf8_code_point = bite - 0xC0;
            } // 0xE0 to 0xEF
            else if (inRange(bite, 0xE0, 0xEF)) {
              // 1. If byte is 0xE0, set utf-8 lower boundary to 0xA0.
              if (bite === 0xE0) utf8_lower_boundary = 0xA0; // 2. If byte is 0xED, set utf-8 upper boundary to 0x9F.
              if (bite === 0xED) utf8_upper_boundary = 0x9F; // 3. Set utf-8 bytes needed to 2 and utf-8 code point to
              // byte − 0xE0.
              utf8_bytes_needed = 2;
              utf8_code_point = bite - 0xE0;
            } // 0xF0 to 0xF4
            else if (inRange(bite, 0xF0, 0xF4)) {
              // 1. If byte is 0xF0, set utf-8 lower boundary to 0x90.
              if (bite === 0xF0) utf8_lower_boundary = 0x90; // 2. If byte is 0xF4, set utf-8 upper boundary to 0x8F.
              if (bite === 0xF4) utf8_upper_boundary = 0x8F; // 3. Set utf-8 bytes needed to 3 and utf-8 code point to
              // byte − 0xF0.
              utf8_bytes_needed = 3;
              utf8_code_point = bite - 0xF0;
            } // Otherwise
            else {
              // Return error.
              return decoderError(fatal);
            } // Then (byte is in the range 0xC2 to 0xF4) set utf-8 code
            // point to utf-8 code point << (6 × utf-8 bytes needed) and
            // return continue.
            utf8_code_point = utf8_code_point << 6 * utf8_bytes_needed;
            return null;
          } // 4. If byte is not in the range utf-8 lower boundary to utf-8
          // upper boundary, run these substeps:
          if (!inRange(bite, utf8_lower_boundary, utf8_upper_boundary)) {
            // 1. Set utf-8 code point, utf-8 bytes needed, and utf-8
            // bytes seen to 0, set utf-8 lower boundary to 0x80, and set
            // utf-8 upper boundary to 0xBF.
            utf8_code_point = utf8_bytes_needed = utf8_bytes_seen = 0;
            utf8_lower_boundary = 0x80;
            utf8_upper_boundary = 0xBF; // 2. Prepend byte to stream.
            stream.prepend(bite); // 3. Return error.
            return decoderError(fatal);
          } // 5. Set utf-8 lower boundary to 0x80 and utf-8 upper boundary
          // to 0xBF.
          utf8_lower_boundary = 0x80;
          utf8_upper_boundary = 0xBF; // 6. Increase utf-8 bytes seen by one and set utf-8 code point
          // to utf-8 code point + (byte − 0x80) << (6 × (utf-8 bytes
          // needed − utf-8 bytes seen)).
          utf8_bytes_seen += 1;
          utf8_code_point += bite - 0x80 << 6 * (utf8_bytes_needed - utf8_bytes_seen); // 7. If utf-8 bytes seen is not equal to utf-8 bytes needed,
          // continue.
          if (utf8_bytes_seen !== utf8_bytes_needed) return null; // 8. Let code point be utf-8 code point.
          var code_point = utf8_code_point; // 9. Set utf-8 code point, utf-8 bytes needed, and utf-8 bytes
          // seen to 0.
          utf8_code_point = utf8_bytes_needed = utf8_bytes_seen = 0; // 10. Return a code point whose value is code point.
          return code_point;
        };
      } /**
        * @constructor
        * @implements {Encoder}
        * @param {{fatal: boolean}} options
        */
      function UTF8Encoder(options) {
        var fatal = options.fatal; /**
                                   * @param {Stream} stream Input stream.
                                   * @param {number} code_point Next code point read from the stream.
                                   * @return {(number|!Array.<number>)} Byte(s) to emit.
                                   */
        this.handler = function (stream, code_point) {
          // 1. If code point is end-of-stream, return finished.
          if (code_point === end_of_stream) return finished; // 2. If code point is in the range U+0000 to U+007F, return a
          // byte whose value is code point.
          if (inRange(code_point, 0x0000, 0x007f)) return code_point; // 3. Set count and offset based on the range code point is in:
          var count, offset; // U+0080 to U+07FF:    1 and 0xC0
          if (inRange(code_point, 0x0080, 0x07FF)) {
            count = 1;
            offset = 0xC0;
          } // U+0800 to U+FFFF:    2 and 0xE0
          else if (inRange(code_point, 0x0800, 0xFFFF)) {
            count = 2;
            offset = 0xE0;
          } // U+10000 to U+10FFFF: 3 and 0xF0
          else if (inRange(code_point, 0x10000, 0x10FFFF)) {
            count = 3;
            offset = 0xF0;
          } // 4.Let bytes be a byte sequence whose first byte is (code
          // point >> (6 × count)) + offset.
          var bytes = [(code_point >> 6 * count) + offset]; // 5. Run these substeps while count is greater than 0:
          while (count > 0) {
            // 1. Set temp to code point >> (6 × (count − 1)).
            var temp = code_point >> 6 * (count - 1); // 2. Append to bytes 0x80 | (temp & 0x3F).
            bytes.push(0x80 | temp & 0x3F); // 3. Decrease count by one.
            count -= 1;
          } // 6. Return bytes bytes, in order.
          return bytes;
        };
      }
      exports.TextEncoder = TextEncoder;
      exports.TextDecoder = TextDecoder;
    }, {}],
    73: [function (require, module, exports) {
      /*jshint bitwise: false*/(function (nacl) {
        'use strict';

        // Ported in 2014 by Dmitry Chestnykh and Devi Mandiri.
        // Public domain.
        //
        // Implementation derived from TweetNaCl version 20140427.
        // See for details: http://tweetnacl.cr.yp.to/
        var gf = function gf(init) {
          var i,
            r = new Float64Array(16);
          if (init) for (i = 0; i < init.length; i++) {
            r[i] = init[i];
          }
          return r;
        }; //  Pluggable, initialized in high-level API below.
        var randombytes = function randombytes() /* x, n */{
          throw new Error('no PRNG');
        };
        var _9 = new Uint8Array(32);
        _9[0] = 9;
        var gf0 = gf(),
          gf1 = gf([1]),
          _121665 = gf([0xdb41, 1]),
          D = gf([0x78a3, 0x1359, 0x4dca, 0x75eb, 0xd8ab, 0x4141, 0x0a4d, 0x0070, 0xe898, 0x7779, 0x4079, 0x8cc7, 0xfe73, 0x2b6f, 0x6cee, 0x5203]),
          D2 = gf([0xf159, 0x26b2, 0x9b94, 0xebd6, 0xb156, 0x8283, 0x149a, 0x00e0, 0xd130, 0xeef3, 0x80f2, 0x198e, 0xfce7, 0x56df, 0xd9dc, 0x2406]),
          X = gf([0xd51a, 0x8f25, 0x2d60, 0xc956, 0xa7b2, 0x9525, 0xc760, 0x692c, 0xdc5c, 0xfdd6, 0xe231, 0xc0a4, 0x53fe, 0xcd6e, 0x36d3, 0x2169]),
          Y = gf([0x6658, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666, 0x6666]),
          I = gf([0xa0b0, 0x4a0e, 0x1b27, 0xc4ee, 0xe478, 0xad2f, 0x1806, 0x2f43, 0xd7a7, 0x3dfb, 0x0099, 0x2b4d, 0xdf0b, 0x4fc1, 0x2480, 0x2b83]);
        function vn(x, xi, y, yi, n) {
          var i,
            d = 0;
          for (i = 0; i < n; i++) {
            d |= x[xi + i] ^ y[yi + i];
          }
          return (1 & d - 1 >>> 8) - 1;
        }
        function crypto_verify_32(x, xi, y, yi) {
          return vn(x, xi, y, yi, 32);
        }
        function set25519(r, a) {
          var i;
          for (i = 0; i < 16; i++) {
            r[i] = a[i] | 0;
          }
        }
        function car25519(o) {
          var i,
            v,
            c = 1;
          for (i = 0; i < 16; i++) {
            v = o[i] + c + 65535;
            c = Math.floor(v / 65536);
            o[i] = v - c * 65536;
          }
          o[0] += c - 1 + 37 * (c - 1);
        }
        function sel25519(p, q, b) {
          var t,
            c = ~(b - 1);
          for (var i = 0; i < 16; i++) {
            t = c & (p[i] ^ q[i]);
            p[i] ^= t;
            q[i] ^= t;
          }
        }
        function pack25519(o, n) {
          var i, j, b;
          var m = gf(),
            t = gf();
          for (i = 0; i < 16; i++) {
            t[i] = n[i];
          }
          car25519(t);
          car25519(t);
          car25519(t);
          for (j = 0; j < 2; j++) {
            m[0] = t[0] - 0xffed;
            for (i = 1; i < 15; i++) {
              m[i] = t[i] - 0xffff - (m[i - 1] >> 16 & 1);
              m[i - 1] &= 0xffff;
            }
            m[15] = t[15] - 0x7fff - (m[14] >> 16 & 1);
            b = m[15] >> 16 & 1;
            m[14] &= 0xffff;
            sel25519(t, m, 1 - b);
          }
          for (i = 0; i < 16; i++) {
            o[2 * i] = t[i] & 0xff;
            o[2 * i + 1] = t[i] >> 8;
          }
        }
        function neq25519(a, b) {
          var c = new Uint8Array(32),
            d = new Uint8Array(32);
          pack25519(c, a);
          pack25519(d, b);
          return crypto_verify_32(c, 0, d, 0);
        }
        function par25519(a) {
          var d = new Uint8Array(32);
          pack25519(d, a);
          return d[0] & 1;
        }
        function unpack25519(o, n) {
          var i;
          for (i = 0; i < 16; i++) {
            o[i] = n[2 * i] + (n[2 * i + 1] << 8);
          }
          o[15] &= 0x7fff;
        }
        function A(o, a, b) {
          for (var i = 0; i < 16; i++) {
            o[i] = a[i] + b[i];
          }
        }
        function Z(o, a, b) {
          for (var i = 0; i < 16; i++) {
            o[i] = a[i] - b[i];
          }
        }
        function M(o, a, b) {
          var v,
            c,
            t0 = 0,
            t1 = 0,
            t2 = 0,
            t3 = 0,
            t4 = 0,
            t5 = 0,
            t6 = 0,
            t7 = 0,
            t8 = 0,
            t9 = 0,
            t10 = 0,
            t11 = 0,
            t12 = 0,
            t13 = 0,
            t14 = 0,
            t15 = 0,
            t16 = 0,
            t17 = 0,
            t18 = 0,
            t19 = 0,
            t20 = 0,
            t21 = 0,
            t22 = 0,
            t23 = 0,
            t24 = 0,
            t25 = 0,
            t26 = 0,
            t27 = 0,
            t28 = 0,
            t29 = 0,
            t30 = 0,
            b0 = b[0],
            b1 = b[1],
            b2 = b[2],
            b3 = b[3],
            b4 = b[4],
            b5 = b[5],
            b6 = b[6],
            b7 = b[7],
            b8 = b[8],
            b9 = b[9],
            b10 = b[10],
            b11 = b[11],
            b12 = b[12],
            b13 = b[13],
            b14 = b[14],
            b15 = b[15];
          v = a[0];
          t0 += v * b0;
          t1 += v * b1;
          t2 += v * b2;
          t3 += v * b3;
          t4 += v * b4;
          t5 += v * b5;
          t6 += v * b6;
          t7 += v * b7;
          t8 += v * b8;
          t9 += v * b9;
          t10 += v * b10;
          t11 += v * b11;
          t12 += v * b12;
          t13 += v * b13;
          t14 += v * b14;
          t15 += v * b15;
          v = a[1];
          t1 += v * b0;
          t2 += v * b1;
          t3 += v * b2;
          t4 += v * b3;
          t5 += v * b4;
          t6 += v * b5;
          t7 += v * b6;
          t8 += v * b7;
          t9 += v * b8;
          t10 += v * b9;
          t11 += v * b10;
          t12 += v * b11;
          t13 += v * b12;
          t14 += v * b13;
          t15 += v * b14;
          t16 += v * b15;
          v = a[2];
          t2 += v * b0;
          t3 += v * b1;
          t4 += v * b2;
          t5 += v * b3;
          t6 += v * b4;
          t7 += v * b5;
          t8 += v * b6;
          t9 += v * b7;
          t10 += v * b8;
          t11 += v * b9;
          t12 += v * b10;
          t13 += v * b11;
          t14 += v * b12;
          t15 += v * b13;
          t16 += v * b14;
          t17 += v * b15;
          v = a[3];
          t3 += v * b0;
          t4 += v * b1;
          t5 += v * b2;
          t6 += v * b3;
          t7 += v * b4;
          t8 += v * b5;
          t9 += v * b6;
          t10 += v * b7;
          t11 += v * b8;
          t12 += v * b9;
          t13 += v * b10;
          t14 += v * b11;
          t15 += v * b12;
          t16 += v * b13;
          t17 += v * b14;
          t18 += v * b15;
          v = a[4];
          t4 += v * b0;
          t5 += v * b1;
          t6 += v * b2;
          t7 += v * b3;
          t8 += v * b4;
          t9 += v * b5;
          t10 += v * b6;
          t11 += v * b7;
          t12 += v * b8;
          t13 += v * b9;
          t14 += v * b10;
          t15 += v * b11;
          t16 += v * b12;
          t17 += v * b13;
          t18 += v * b14;
          t19 += v * b15;
          v = a[5];
          t5 += v * b0;
          t6 += v * b1;
          t7 += v * b2;
          t8 += v * b3;
          t9 += v * b4;
          t10 += v * b5;
          t11 += v * b6;
          t12 += v * b7;
          t13 += v * b8;
          t14 += v * b9;
          t15 += v * b10;
          t16 += v * b11;
          t17 += v * b12;
          t18 += v * b13;
          t19 += v * b14;
          t20 += v * b15;
          v = a[6];
          t6 += v * b0;
          t7 += v * b1;
          t8 += v * b2;
          t9 += v * b3;
          t10 += v * b4;
          t11 += v * b5;
          t12 += v * b6;
          t13 += v * b7;
          t14 += v * b8;
          t15 += v * b9;
          t16 += v * b10;
          t17 += v * b11;
          t18 += v * b12;
          t19 += v * b13;
          t20 += v * b14;
          t21 += v * b15;
          v = a[7];
          t7 += v * b0;
          t8 += v * b1;
          t9 += v * b2;
          t10 += v * b3;
          t11 += v * b4;
          t12 += v * b5;
          t13 += v * b6;
          t14 += v * b7;
          t15 += v * b8;
          t16 += v * b9;
          t17 += v * b10;
          t18 += v * b11;
          t19 += v * b12;
          t20 += v * b13;
          t21 += v * b14;
          t22 += v * b15;
          v = a[8];
          t8 += v * b0;
          t9 += v * b1;
          t10 += v * b2;
          t11 += v * b3;
          t12 += v * b4;
          t13 += v * b5;
          t14 += v * b6;
          t15 += v * b7;
          t16 += v * b8;
          t17 += v * b9;
          t18 += v * b10;
          t19 += v * b11;
          t20 += v * b12;
          t21 += v * b13;
          t22 += v * b14;
          t23 += v * b15;
          v = a[9];
          t9 += v * b0;
          t10 += v * b1;
          t11 += v * b2;
          t12 += v * b3;
          t13 += v * b4;
          t14 += v * b5;
          t15 += v * b6;
          t16 += v * b7;
          t17 += v * b8;
          t18 += v * b9;
          t19 += v * b10;
          t20 += v * b11;
          t21 += v * b12;
          t22 += v * b13;
          t23 += v * b14;
          t24 += v * b15;
          v = a[10];
          t10 += v * b0;
          t11 += v * b1;
          t12 += v * b2;
          t13 += v * b3;
          t14 += v * b4;
          t15 += v * b5;