<?php
/**
 * OpenStreetMap Default driver file to get tile layer.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 *
 * @see       https://wiki.openstreetmap.org/wiki/OpenStreetMap_Carto
 */

declare(strict_types=1);

namespace App\Map\TileLayer;

/**
 * Connector for service OpenStreetMapDefault to get tile layer.
 */
class OpenStreetMapDefault extends Base
{
	/**
	 * @inheritdoc
	 */
	protected string $label = 'LBL_TILE_LAYER_OSM_DEFAULT';

	/**
	 * @inheritdoc
	 */
	protected string $url = 'https://wiki.openstreetmap.org';

	/**
	 * @inheritdoc
	 */
	protected string $urlTemplate = 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png';

	/**
	 * @inheritdoc
	 */
	protected array $formFields = [];
}
