<?php

namespace App\TextParser;

use App\Exceptions\AppException;
use App\Fields\Currency;
use FInvoice_Record_Model;
use Vtiger_Record_Model;

/**
 * Amount to return.
 *
 * @package TextParser
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 */
class AmountToPay extends Base
{
	/** @var string */
	public $name = 'LBL_AMOUNT_TO_PAY';

	/** @var mixed Parser type */
	public $type = 'pdf';

	/** @var array Allowed modules */
	public $allowedModules = ['FCorectingInvoice'];

	/** @var array Related modules fields */
	protected $relatedModulesFields = ['FCorectingInvoice' => 'finvoiceid'];

	/**
	 * Process.
	 *
	 * @return string
	 * @throws AppException
	 */
	public function process()
	{
		$relatedRecordModel = $this->getRelatedRecordModel();
		$inventoryData = $this->getInventoryData();
		$inventory = \Vtiger_Inventory_Model::getInstance($this->textParser->recordModel->getModuleName());

		return $inventory->getCorrectionGrossSummary($relatedRecordModel, $this->textParser->recordModel)
			. ' ' . $this->getCurrencySymbolByIdOrGetDefault($inventoryData['currency']);
	}

	public function getCurrencySymbolByIdOrGetDefault(int $currencyId): string
	{
		$currency = Currency::getById($currencyId)['currency_symbol'] ?? '';

		if (!$currency) {
			$currency = Currency::getDefault()['currency_symbol'] ?? '';
		}

		return $currency;
	}

	/**
	 * @throws AppException
	 */
	private function getInventoryData(): array
	{
		$inventoryData = $this->textParser->recordModel->getInventoryData();
		return reset($inventoryData);
	}

	private function getRelatedRecordModel(): Vtiger_Record_Model
	{
		return Vtiger_Record_Model::getInstanceById(
			$this->textParser->recordModel->get(
				$this->relatedModulesFields[$this->textParser->recordModel->getModuleName()]
			)
		);
	}
}
