{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	<!-- tpl-Settings-Map-Config -->
	<div>
		<div class="o-breadcrumb widget_header row mb-2">
			<div class="col-md-12">
                {include file=App\Layout::getTemplatePath('BreadCrumbs.tpl', $MODULE_NAME)}
			</div>
		</div>
		<div>
			<ul id="tabs" class="nav nav-tabs my-2 mr-0" data-tabs="tabs">
                {assign var="ACTIVE_TAB" value='TileLayer'}
				<li class="nav-item">
					<a class="nav-link {if $ACTIVE_TAB eq 'TileLayer'}active{/if}" href="#TileLayer" data-toggle="tab">
						<span class="fas fa-layer-group mr-2"></span>{App\Language::translate('LBL_TILE_LAYER', $QUALIFIED_MODULE)}
					</a>
				</li>
				<li class="nav-item">
					<a class="nav-link {if $ACTIVE_TAB eq 'Coordinates'}active{/if}" href="#Coordinates" data-toggle="tab">
						<span class="fas fa-globe mr-2"></span>{App\Language::translate('LBL_COORDINATES', 'OpenStreetMap')}
					</a>
				</li>
				<li class="nav-item">
					<a class="nav-link {if $ACTIVE_TAB eq 'Routing'}active{/if}" href="#Routing" data-toggle="tab">
						<span class="fas fa-route mr-2"></span>{App\Language::translate('LBL_ROUTING', $QUALIFIED_MODULE)}
					</a>
				</li>
			</ul>
		</div>

		<div id="my-tab-content" class="tab-content">
			<div class="tab-pane {if $ACTIVE_TAB eq 'TileLayer'}active{/if}" id="TileLayer">
				<div class="alert alert-info">
					<span class="mdi mdi-information-outline u-fs-2em mr-2 float-left"></span>
                    {App\Language::translate('LBL_TILE_LAYER_INFO', $QUALIFIED_MODULE)}<br>
				</div>
				<form class="js-validation-form">
					<div class="js-config-table table-responsive" data-js="container">
						<table class="table ">
							<thead>
							<tr>
								<th class="text-center col-6" scope="col">{App\Language::translate('LBL_PROVIDER_NAME', $QUALIFIED_MODULE)}</th>
								<th class="text-center col-3" scope="col">{App\Language::translate('LBL_PROVIDER_ACTIVE', $QUALIFIED_MODULE)}</th>
								<th class="text-center col-3" scope="col">{App\Language::translate('LBL_PROVIDER_ACTIONS', $QUALIFIED_MODULE)}</th>
							</tr>
							</thead>
							<tbody>
                            {foreach from=$TILE_LAYER_ROWS item=ROW}
                                {assign var="DRIVER" value=App\Map\Layer::getInstance($ROW['driver'])}
								<tr>
									<th scope="row">
                                        {App\Language::translate($DRIVER->getLabel(), $QUALIFIED_MODULE)}
									</th>
									<td class="text-center">
										<input name="tileLayerServers"
											   value="{$ROW['driver']}"
											   type="radio" {if $ROW['active']}checked{/if}
										>
									</td>

									<td class="text-center">
										{if $DRIVER->getFormFields()|count > 0}
											<button class="btn btn-outline-primary btn-sm js-show-config-modal js-popover-tooltip mr-1"
													type="button"
													data-tab="TileLayer"
													data-driver="{$ROW['driver']}"
													data-content="{App\Language::translate('LBL_PROVIDER_CONFIG', $QUALIFIED_MODULE)}"
											>
												<span class="fas fa-cog"></span>
											</button>
                                        {/if}
                                        {if $DRIVER->getUrl()}
											<a href="{$DRIVER->getUrl()}"
											   class="btn btn-outline-primary btn-sm js-popover-tooltip"
											   role="button"
											   target="_blank"
											   data-content="{App\Language::translate('LBL_PROVIDER_WEBPAGE', $QUALIFIED_MODULE)}"
											>
												<span class="fas fa-globe"></span>
											</a>
                                        {/if}
									</td>
								</tr>
                            {/foreach}
							</tbody>
						</table>
					</div>
				</form>
			</div>

			<div class="tab-pane {if $ACTIVE_TAB eq 'Coordinates'}active{/if}" id="Coordinates">
				<div class="alert alert-info">
					<span class="mdi mdi-information-outline u-fs-2em mr-2 float-left"></span>
                    {App\Language::translate('LBL_COORDINATES_INFO', $QUALIFIED_MODULE)}<br>
				</div>
				<form class="js-validation-form">
					<div class="js-config-table table-responsive" data-js="container">
						<table class="table ">
							<thead>
							<tr>
								<th class="text-center col-6" scope="col">{App\Language::translate('LBL_PROVIDER_NAME', $QUALIFIED_MODULE)}</th>
								<th class="text-center col-3" scope="col">{App\Language::translate('LBL_PROVIDER_ACTIVE', $QUALIFIED_MODULE)}</th>
								<th class="text-center col-3" scope="col">{App\Language::translate('LBL_PROVIDER_ACTIONS', $QUALIFIED_MODULE)}</th>
							</tr>
							</thead>
							<tbody>
                            {foreach from=$COORDINATES_ROWS item=ROW}
                                {assign var="DRIVER" value=App\Map\Coordinates::getInstance($ROW['driver'])}
								<tr>
									<th scope="row">
                                        {App\Language::translate($DRIVER->getLabel(), $QUALIFIED_MODULE)}
									</th>

									<td class="text-center">
										<input name="coordinatesServer" value="{$ROW['driver']}" type="radio" {if $ROW['active']}checked{/if}>
									</td>
									<td class="text-center">
                                        {if $DRIVER->getFormFields()|count > 0}
											<button class="btn btn-outline-primary btn-sm js-show-config-modal js-popover-tooltip mr-1"
													type="button"
													data-tab="Coordinates"
													data-driver="{$ROW['driver']}"
													data-content="{App\Language::translate('LBL_PROVIDER_CONFIG', $QUALIFIED_MODULE)}"
											>
												<span class="fas fa-cog"></span>
											</button>
										{/if}
                                        {if $DRIVER->getDocUrl()}
											<a href="{$DRIVER->getDocUrl()}"
											   class="btn btn-outline-primary btn-sm js-popover-tooltip"
											   role="button"
											   target="_blank"
											   data-content="{App\Language::translate('LBL_PROVIDER_WEBPAGE', $QUALIFIED_MODULE)}"
											>
												<span class="fas fa-globe"></span>
											</a>
                                        {/if}
									</td>
								</tr>
                            {/foreach}
							</tbody>
						</table>
					</div>
				</form>
			</div>

			<div class="tab-pane {if $ACTIVE_TAB eq 'Routing'}active{/if}" id="Routing">
				<div class="alert alert-info">
					<span class="mdi mdi-information-outline u-fs-2em mr-2 float-left"></span>
                    {App\Language::translate('LBL_ROUTING_INFO', $QUALIFIED_MODULE)}<br>
				</div>
				<form class="js-validation-form">
					<div class="js-config-table table-responsive" data-js="container">
						<table class="table ">
							<thead>
							<tr>
								<th class="text-center col-6" scope="col">{App\Language::translate('LBL_PROVIDER_NAME', $QUALIFIED_MODULE)}</th>
								<th class="text-center col-3" scope="col">{App\Language::translate('LBL_PROVIDER_ACTIVE', $QUALIFIED_MODULE)}</th>
								<th class="text-center col-3" scope="col">{App\Language::translate('LBL_PROVIDER_ACTIONS', $QUALIFIED_MODULE)}</th>
							</tr>
							</thead>
							<tbody>
                            {foreach from=$ROUTING_ROWS item=ROW}
                                {assign var="DRIVER" value=App\Map\Routing::getInstance($ROW['driver'])}
								<tr>
									<th scope="row">
                                        {App\Language::translate($DRIVER->getLabel(), $QUALIFIED_MODULE)}
									</th>

									<td class="text-center">
										<input name="coordinatesServer" value="{$ROW['driver']}" type="radio" {if $ROW['active']}checked{/if}>
									</td>
									<td class="text-center">
                                        {if $DRIVER->getFormFields()|count > 0}
											<button class="btn btn-outline-primary btn-sm js-show-config-modal js-popover-tooltip mr-1"
													type="button"
													data-tab="Routing"
													data-driver="{$ROW['driver']}"
													data-content="{App\Language::translate('LBL_PROVIDER_CONFIG', $QUALIFIED_MODULE)}"
											>
												<span class="fas fa-cog"></span>
											</button>
                                        {/if}
										{if $DRIVER->getDocUrl()}
											<a href="{$DRIVER->getDocUrl()}"
											   class="btn btn-outline-primary btn-sm js-popover-tooltip"
											   role="button"
											   target="_blank"
											   data-content="{App\Language::translate('LBL_PROVIDER_WEBPAGE', $QUALIFIED_MODULE)}"
											>
												<span class="fas fa-globe"></span>
											</a>
                                        {/if}
									</td>
								</tr>
                            {/foreach}
							</tbody>
						</table>
					</div>
				</form>
			</div>
		</div>
	</div>
	<!-- /tpl-Settings-Map-Config -->
{/strip}
