/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

Vtiger_Detail_Js(
	'ReportTemplate_Detail_Js',
	{
		generateReport(id) {
			AppConnector.request({
				module: 'ReportTemplate',
				action: 'GenerateReport',
				record: id
			})
				.done((data) => {
					let success = data.result.success;
					let linkFile = data.result.file;
					if(success && linkFile){
						const link = document.createElement('a');
						link.href = linkFile;
						link.click();
					}
					app.showNotify({
						type: success ? 'success' : 'info',
						text: data.result.message,
						textTrusted: false
					});
				})
				.fail(function (_error) {
					app.showError({
						title: app.vtranslate('JS_ERROR')
					});
				});
		}
	},
	{},
	{}
);
