'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";jQuery.Class("Settings_LeadMapping_Js",{/**
		 * Function to register event to edit leads mapping
		 */triggerEdit:function triggerEdit(editUrl){var aDeferred=jQuery.Deferred(),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});return AppConnector.request(editUrl).done(function(data){var detailContentsHolder=jQuery(".contentsDiv");detailContentsHolder.html(data),progressIndicatorElement.progressIndicator({mode:"hide"});var leadMappingInstance=new Settings_LeadMapping_Js;leadMappingInstance.registerEventsForEditView();}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});}),aDeferred.promise()},/**
		 * Function to register event for delete lead mapping
		 */triggerDelete:function triggerDelete(event,url){var element=jQuery(event.currentTarget),mappingContainer=element.closest(".listViewEntries"),mappingId=mappingContainer.data("cfmid");AppConnector.request(url+"&mappingId="+mappingId).done(function(data){var message=data.result[0],params={text:message};data.success?mappingContainer.remove():params.type="error",Settings_Vtiger_Index_Js.showMessage(params);});}},{/**
		 * Function to register events for edit view of leads mapping
		 */registerEventsForEditView:function registerEventsForEditView(){var form=jQuery("#leadsMapping"),select2Elements=form.find(".select2");App.Fields.Picklist.showSelect2ElementView(select2Elements),this.registerEventForAddingNewMapping(),this.registerOnChangeEventForSourceModule(),this.registerEventToDeleteMapping(),this.registerEventForFormSubmit(),this.registerOnChangeEventOfTargetModule(),jQuery("select.accountsFields.select2,select.contactFields.select2").trigger("change",!1);},/**
		 * Function to register event for adding new convert to lead mapping
		 */registerEventForAddingNewMapping:function registerEventForAddingNewMapping(){jQuery("#addMapping").on("click",function(){var convertLeadMappingTable=jQuery("#convertLeadMapping"),lastSequenceNumber=convertLeadMappingTable.find("tr:not(.newMapping):last[sequence-number]").attr("sequence-number"),newSequenceNumber=parseInt(lastSequenceNumber)+1,newMapping=jQuery(".newMapping").clone(!0,!0);newMapping.attr("sequence-number",newSequenceNumber),newMapping.find("select.leadsFields.newSelect").attr("name","mapping["+newSequenceNumber+"][lead]"),newMapping.find("select.accountsFields.newSelect").attr("name","mapping["+newSequenceNumber+"][account]"),newMapping.find("select.contactFields.newSelect").attr("name","mapping["+newSequenceNumber+"][contact]"),newMapping.removeClass("d-none newMapping"),newMapping.appendTo(convertLeadMappingTable),newMapping.find(".newSelect").removeClass("newSelect").addClass("select2");var select2Elements=newMapping.find(".select2");App.Fields.Picklist.showSelect2ElementView(select2Elements),jQuery("select.accountsFields.select2,select.contactFields.select2",newMapping).trigger("change",!1);});},/**
		 * Function to register on change event for select2 element
		 */registerOnChangeEventForSourceModule:function registerOnChangeEventForSourceModule(){var form=jQuery("#leadsMapping");form.on("change",".leadsFields",function(e){var element=jQuery(e.currentTarget),container=jQuery(element.closest("tr")),selectedValue=element.val(),selectedOption=element.find("option[value=\""+selectedValue+"\"]"),selectedDataType=selectedOption.data("type"),accountFieldsSelectElement=container.find("select.accountsFields.select2"),contactFieldsSelectElement=container.find("select.contactFields.select2"),accountFieldsBasedOnType=form.find(".newMapping").find(".accountsFields").children().filter("[data-type=\""+selectedDataType+"\"]").clone(!0,!0),contactFieldsBasedOnType=form.find(".newMapping").find(".contactFields").children().filter("option[data-type=\""+selectedDataType+"\"]").clone(!0,!0);selectedDataType=app.vtranslate("JS_"+selectedDataType),container.find(".selectedFieldDataType").html(selectedDataType);var noneValue=app.vtranslate("JS_NONE");accountFieldsSelectElement.html(accountFieldsBasedOnType),contactFieldsSelectElement.html(contactFieldsBasedOnType),"None"!=selectedDataType&&(accountFieldsSelectElement.prepend("<option data-type=\""+noneValue+"\" label=\""+noneValue+"\" value=\"0\" selected>"+noneValue+"</option>"),contactFieldsSelectElement.prepend("<option data-type=\""+noneValue+"\" label=\""+noneValue+"\" value=\"0\" selected>"+noneValue+"</option>")),accountFieldsSelectElement.trigger("change"),contactFieldsSelectElement.trigger("change");});},/**
		 * Function to register event to delete mapping
		 */registerEventToDeleteMapping:function registerEventToDeleteMapping(){var form=jQuery("#leadsMapping");form.on("click",".deleteMapping",function(e){var element=jQuery(e.currentTarget),mappingContainer=element.closest("tr"),mappingContainerSequenceNumber=mappingContainer.attr("sequence-number");mappingContainer.prepend("<input type=\"hidden\" name=\""+("mapping["+mappingContainerSequenceNumber+"][deletable]")+"\" />"),mappingContainer.data("deletable",!0).hide("slow");var params={text:app.vtranslate("JS_MAPPING_DELETED_SUCCESSFULLY")};Settings_Vtiger_Index_Js.showMessage(params);});},/**
		 * Function to handle edit view convert lead form submit
		 */registerEventForFormSubmit:function registerEventForFormSubmit(){jQuery("#leadsMapping").on("submit",function(e){e.preventDefault();var mappingDetails=jQuery(this).serializeFormData(),params={module:app.getModuleName(),parent:app.getParentModuleName(),action:"MappingSave",mapping:mappingDetails},progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request(params).done(function(data){if(data.success){var detailViewParams={module:app.getModuleName(),parent:app.getParentModuleName(),view:"MappingDetail"};AppConnector.request(detailViewParams).done(function(data){var detailContentsHolder=jQuery(".contentsDiv");detailContentsHolder.html(data),progressIndicatorElement.progressIndicator({mode:"hide"});});}var notifyParams;notifyParams=data.result.status?{title:app.vtranslate("JS_MAPPING_SAVED_SUCCESSFULLY"),type:"info"}:{title:app.vtranslate("JS_INVALID_MAPPING"),text:data.result,type:"error"},app.showNotify(notifyParams);}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});});},/**
		 * Function to register on chnage event of target module
		 */registerOnChangeEventOfTargetModule:function registerOnChangeEventOfTargetModule(){var form=jQuery("#leadsMapping");form.on("change","select.accountsFields.select2,select.contactFields.select2",function(e,executeChange){"undefined"==typeof executeChange&&(executeChange=!0);var existingIdElement,selectElement=jQuery(e.currentTarget),selectedValue=selectElement.children().filter("option:selected").text(),selectedOptionId=selectElement.children().filter("option:selected").val(),mappingContainer=selectElement.closest("tr"),duplicateOption=!1;if("0"==selectedOptionId&&(selectedOptionId="false"),!executeChange||"false"==selectedOptionId)return void selectElement.attr("selectedId",selectedOptionId);//check for source module field
var sourceModuleSelect=mappingContainer.find("select.leadsFields.select2"),sourceModuleSelectedField=sourceModuleSelect.val(),sourceModuleSelectedFieldLabel=sourceModuleSelect.find("option[value=\""+sourceModuleSelectedField+"\"]").text();if("0"==sourceModuleSelectedField){duplicateOption=!0;var errorParams={text:app.vtranslate("JS_CANT_MAP")+" "+selectedValue+" "+app.vtranslate("JS_WITH")+" "+sourceModuleSelectedFieldLabel,type:"error"};Settings_Vtiger_Index_Js.showMessage(errorParams);}if(existingIdElement=selectElement.hasClass("accountsFields")?jQuery("select.accountsFields.select2[selectedid=\""+selectedOptionId+"\"]"):jQuery("select.contactFields.select2[selectedid=\""+selectedOptionId+"\"]"),0<existingIdElement.length&&(duplicateOption=!0),duplicateOption){var selectedFieldId=selectElement.attr("selectedid");"false"==selectedFieldId?selectElement.attr("selectedId","false"):"false"!=selectedFieldId&&selectElement.attr("selectedId",selectedFieldId);var warningMessage=selectedValue+" "+app.vtranslate("JS_IS_ALREADY_BEEN_MAPPED");Settings_Vtiger_Index_Js.showMessage({text:warningMessage,type:"error"}),selectElement.val(0).trigger("change");}else selectElement.attr("selectedId",selectedOptionId);});}});
//# sourceMappingURL=LeadMapping.min.js.map
