'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";Vtiger_List_Js("Settings_Vtiger_List_Js",{triggerDelete:function triggerDelete(event,url){event.stopPropagation();var instance=Vtiger_List_Js.getInstance();instance.DeleteRecord(url);},/**
		 * Make delete request
		 *
		 * @param   {object}  params
		 * @param   {jQuery.Deferred}  aDeferred
		 * @param   {Vtiger_List_Js}  instance
		 */makeDeleteRequest:function makeDeleteRequest(params,aDeferred,instance){AppConnector.request(params).done(function(data){var response=data.result;response&&response.success?($("#recordsCount").val(""),$("#totalPageCount").text(""),instance.getListViewRecords().done(function(){instance.updatePagination();})):app.showNotify({text:response.message?response.message:app.vtranslate("JS_ERROR"),type:"error"}),aDeferred.resolve(data);});},/**
		 * Delete by id
		 *
		 * @param   {number}  id
		 * @param   {bool}  showConfirmation
		 *
		 * @return  {jQuery.Deferred}
		 */deleteById:function deleteById(id){var _this=this,showConfirmation=!(1<arguments.length&&void 0!==arguments[1])||arguments[1],aDeferred=jQuery.Deferred(),instance=Vtiger_List_Js.getInstance(),params=$.extend(instance.getDeleteParams(),{record:id});return showConfirmation?app.showConfirmModal({title:app.vtranslate("JS_DELETE_RECORD_CONFIRMATION"),confirmedCallback:function confirmedCallback(){_this.makeDeleteRequest(params,aDeferred,instance);}}):this.makeDeleteRequest(params,aDeferred,instance),aDeferred.promise()}},{getDeleteParams:function getDeleteParams(){return {module:app.getModuleName(),parent:app.getParentModuleName(),action:"DeleteAjax"}},/*
		 * Function to register the list view container
		 */getListViewContainer:function getListViewContainer(){return !1==this.listViewContainer&&(this.listViewContainer=$("div.contentsDiv")),this.listViewContainer},/*
		 * Function to register the list view delete record click event
		 */DeleteRecord:function DeleteRecord(url){var thisInstance=this;AppConnector.request(url).done(function(data){data&&app.showModalWindow(data,function(container){thisInstance.postDeleteAction(container);});});},/**
		 * Function to load list view after deletion of record from list view
		 */postDeleteAction:function postDeleteAction(container){var thisInstance=this,deleteConfirmForm=jQuery(container).find("#DeleteModal");deleteConfirmForm.on("submit",function(e){e.preventDefault();var deleteActionUrl=deleteConfirmForm.serializeFormData();AppConnector.request(deleteActionUrl).done(function(){app.hideModalWindow();var params={text:app.vtranslate("JS_RECORD_DELETED_SUCCESSFULLY")};Settings_Vtiger_Index_Js.showMessage(params),jQuery("#recordsCount").val(""),jQuery("#totalPageCount").text(""),thisInstance.getListViewRecords().done(function(){thisInstance.updatePagination();});}).fail(function(){app.hideModalWindow();});});},/**
		 * Function to get Page Jump Params
		 */getPageJumpParams:function getPageJumpParams(){var module=app.getModuleName(),cvId=this.getCurrentCvId(),pageCountParams={module:module,parent:"Settings",action:"ListAjax",mode:"getPageCount",viewname:cvId},sourceModule=jQuery("#moduleFilter").val();return "undefined"!=typeof sourceModule&&(pageCountParams.sourceModule=sourceModule),pageCountParams},/**
		 * Register button to create record
		 */registerButtons:function registerButtons(){var _this2=this;this.getListViewContainer().on("click",".js-add-record-modal, .js-edit-record-modal",function(e){app.showModalWindow({url:e.currentTarget.dataset.url,sendByAjaxCb:function sendByAjaxCb(){_this2.getListViewRecords();}});});},/**
		 * Function to register events
		 */registerEvents:function registerEvents(){this.registerRowClickEvent(),this.registerCheckBoxClickEvent(),this.registerHeadersClickEvent(),this.registerPageNavigationEvents(),this.registerEventForTotalRecordsCount(),this.registerButtons();}});
//# sourceMappingURL=List.min.js.map
