'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Settings_WebserviceApps_Index_Js",{},{/**
		 * Get container
		 *
		 * @returns {HTMLElement|jQuery}
		 */getContainer:function getContainer(){return this.container},/**
		 * Register actions for record
		 */registerTableEvents:function registerTableEvents(){var thisInstance=this,container=this.container=$(".configContainer");container.find(".edit").on("click",function(e){var currentTarget=$(e.currentTarget),trRow=currentTarget.closest("tr");thisInstance.showFormToEditKey(trRow.data("id"));}),container.find(".remove").on("click",function(e){var currentTrElement=jQuery(e.currentTarget).closest("tr");app.showConfirmModal({title:app.vtranslate("JS_DELETE_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var progress=jQuery.progressIndicator();AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),action:"Delete",id:currentTrElement.data("id")}).done(function(){progress.progressIndicator({mode:"hide"}),thisInstance.loadTable();});}});});},/**
		 * Refresh tables with records
		 */loadTable:function loadTable(){var thisInstance=this,params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"Index"},progress=jQuery.progressIndicator();AppConnector.request(params).done(function(data){progress.progressIndicator({mode:"hide"}),$(".configContainer").html(data),thisInstance.registerTableEvents();});},/**
		 * Show forms to edit or create record
		 * @param {int} id
		 */showFormToEditKey:function showFormToEditKey(id,type){var _this=this,thisInstance=this,params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"CreateApp",type:type};""!=id&&(params.record=id);var progress=jQuery.progressIndicator();AppConnector.request(params).done(function(data){progress.progressIndicator({mode:"hide"}),app.showModalWindow(data,function(container){var prevButton=container.find(".previewPassword"),password=container.find("[name=\"pass\"]");prevButton.on("mousedown",function(){password.attr("type","text");}),prevButton.on("mouseup",function(){password.attr("type","password");}),prevButton.on("mouseout",function(){password.attr("type","password");});var clipboard=App.Fields.Text.registerCopyClipboard(container,".copyPassword");container.one("hidden.bs.modal",function(){clipboard.destroy();});var form=container.find("form");form.validationEngine(app.validationEngineOptions),container.find("[name=\"saveButton\"]").on("click",function(){if(form.validationEngine("validate")){var formData=form.serializeFormData();formData.module=app.getModuleName(),formData.parent=app.getParentModuleName(),formData.action="SaveAjax",formData.status=container.find("[name=\"status\"]").is(":checked"),""!=id&&(formData.id=id),AppConnector.request(formData).done(function(data){!0===data.result?(thisInstance.loadTable(),app.hideModalWindow()):"undefined"!=typeof data.result.error&&app.showNotify({text:data.result.error,type:"error"});});}}),container.find("[name=\"type\"]").on("change",function(e){app.hideModalWindow(),_this.showFormToEditKey("",$(e.currentTarget).val());});});});},/**
		 * Register button to create record
		 */registerAddButton:function registerAddButton(){var thisInstance=this;$(".createKey").on("click",function(){thisInstance.showFormToEditKey();});},/**
		 * Main function
		 */registerEvents:function registerEvents(){this.registerAddButton(),this.registerTableEvents(),App.Fields.Text.registerCopyClipboard(this.getContainer());}});
//# sourceMappingURL=WebserviceApps.min.js.map
