'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _callSuper(t,o,e){return o=_getPrototypeOf(o),_possibleConstructorReturn(t,_isNativeReflectConstruct()?Reflect.construct(o,e||[],_getPrototypeOf(t).constructor):o.apply(t,e))}function _possibleConstructorReturn(self,call){if(call&&("object"===_typeof(call)||"function"==typeof call))return call;if(void 0!==call)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized(self)}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}function _isNativeReflectConstruct(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));}catch(t){}return (_isNativeReflectConstruct=function(){return !!t})()}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),Object.defineProperty(subClass,"prototype",{writable:!1}),superClass&&_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}/**
 * @classdesc Bria Softphone Pbx integrations class.
 * @class
 */Integrations_Pbx_Base.driver="BriaSoftphone",window.Integrations_Pbx_BriaSoftphone=/*#__PURE__*/function(_Integrations_Pbx_Bas){/** @inheritdoc */function Integrations_Pbx_BriaSoftphone(container){var _this;_classCallCheck(this,Integrations_Pbx_BriaSoftphone),_this=_callSuper(this,Integrations_Pbx_BriaSoftphone,[container]),_this.btnText=_this.accountName=_this.lastEvent=_this.status=_this.connected=!1;try{_this.initWebsocket();}catch(e){console.warn("WebSocket exception: "+e),_this.connected=!1;}return _this.container.find(".js-phone-status-btn").on("click",function(){_this.connected&&_this.bringToFront();}),_this}/** @inheritdoc */return _inherits(Integrations_Pbx_BriaSoftphone,_Integrations_Pbx_Bas),_createClass(Integrations_Pbx_BriaSoftphone,[{key:"performCall",value:function performCall(data){this.connected?this.apiCall("call","<dial type=\"audio\"><number>".concat(data.phone,"</number><displayName></displayName><suppressMainWindow>false</suppressMainWindow></dial>")):app.showError({title:app.vtranslate("JS_UNEXPECTED_ERROR")});}/**
	 * Connection initialization via websocket
	 */},{key:"initWebsocket",value:function initWebsocket(){var _this2=this;this.connected=!1,this.websocket=new WebSocket("wss://cpclientapi.softphone.com:9002/counterpath/socketapi/v1/"),this.websocket.onopen=function(e){_this2.connected=!0,_this2.setStatus("Connected",e),_this2.getStatus("account","<accountType>sip</accountType>");},this.websocket.onclose=function(e){_this2.connected?_this2.setStatus("Disconnected",e):_this2.setStatus("Close",e),_this2.connected=!1,setTimeout(function(){_this2.initWebsocket();},5e3);},this.websocket.onerror=function(e){_this2.connected=!1,_this2.setStatus("Error",e),_this2.websocket.close();},this.websocket.onmessage=function(e){_this2.received(e.data);};}/**
	 * Update button
	 */},{key:"updateBtn",value:function updateBtn(){var btn=this.container.find(".js-phone-status-btn"),btnIcon=btn.find(".js-icon"),btnText=btn.find(".js-text");btn.removeClass("d-none"),btn.attr("class",function(i,c){return c.replace(/(^|\s)btn-\S+/g,"")});var title=this.status;switch(this.status){case"Ringing":btn.addClass("btn-primary"),btnIcon.removeClass().addClass("fa-solid fa-phone-volume js-icon");break;case"Service Unavailable":btn.addClass("btn-outline-primary"),btnIcon.removeClass().addClass("fa-solid fa-phone-slash js-icon");break;case"Disconnected":case"Close":btn.addClass("btn-outline-primary"),btnIcon.removeClass().addClass("fa-solid fa-phone-slash js-icon");break;case"Connected":default:btn.addClass("btn-primary"),btnIcon.removeClass().addClass("fa-solid fa-phone-flip js-icon");}this.lastEvent&&(this.lastEvent.code||this.lastEvent.name)&&(title+=" ("+(this.lastEvent.code||this.lastEvent.name)+")"),btn.attr("title",title),this.btnText?btnText.text(this.btnText).addClass("ml-2"):btnText.removeClass("ml-2");}/**
	 * Message event
	 * @param {object} data
	 */},{key:"received",value:function received(data){var message=this.parseMessage(data);if(message.errorCode)this.setStatus(message.errorText);else switch(message.messageType){case"RESPONSE":this.response(message.xml);break;case"EVENT":this.event(message.xml);}this.updateBtn();}/**
	 * Response message type
	 * @param {jQuery} xml
	 */},{key:"response",value:function response(xml){if(xml){var type=xml.children(":first").attr("type"),fn="request"+type.charAt(0).toUpperCase()+type.slice(1);this.log("|\u25C4| "+fn+" ["+(fn in this)+"]",xml.get(0)),fn in this&&this[fn](xml.find(type));}}/**
	 * Event message type
	 * @param {jQuery} xml
	 */},{key:"event",value:function event(xml){if(xml){var type=xml.children(":first").attr("type"),fn="event"+type.charAt(0).toUpperCase()+type.slice(1);this.log("|\u25C4| "+fn+" ["+(fn in this)+"]",xml.get(0)),fn in this&&this[fn]();}}/**
	 * Account details request
	 * @param {jQuery} xml
	 * @description `|◄| requestAccount [true]`
	 */},{key:"requestAccount",value:function requestAccount(xml){this.btnText=this.accountName=xml.find("accountName").text();var value=app.cacheGet("PBX|lastCallHistoryUpdate|"+this.accountName,null);(null==value||300<Math.floor((Date.now()-value)/1e3))&&(app.cacheClear("PBX|lastCallHistoryUpdate|"+this.accountName),this.getStatus("callHistory","<count>20</count><entryType>all</entryType>"));}/**
	 * Call history details request
	 * @param {jQuery} xml
	 * @description `|◄| requestCallHistory [true]`
	 */},{key:"requestCallHistory",value:function requestCallHistory(xml){var _this3=this,calls=[];xml.each(function(_,callsXml){var call={};$(callsXml).children().each(function(_,callXml){call[callXml.tagName]=callXml.textContent;}),calls.push(call);}),AppConnector.request({module:"AppComponents",action:"Pbx",mode:"saveCalls",accountName:this.accountName,calls:calls}).done(function(response){!0===response.result.loadMore&&_this3.getStatus("callHistory","<count>100</count><entryType>all</entryType>");}),app.cacheSet("PBX|lastCallHistoryUpdate|"+this.accountName,Date.now());}/**
	 * Call request
	 * @param {jQuery} xml
	 * @description `|◄| requestCall [true]`
	 */},{key:"requestCall",value:function requestCall(xml){xml.length?(this.setStatus("Ringing"),this.btnText=xml.find("displayName").text()):(this.setStatus("Connected"),this.btnText=this.accountName);}/**
	 * Call history event
	 * @description `|◄| eventCallHistory [true]`
	 */},{key:"eventCallHistory",value:function eventCallHistory(){this.getStatus("callHistory","<count>5</count><entryType>all</entryType>");}/**
	 * Call event
	 * @description `|◄| eventCall [true]`
	 */},{key:"eventCall",value:function eventCall(){this.setStatus("Ringing"),this.getStatus("call");}/**
	 * Get status from phone application
	 * @param {string} type
	 * @param {string} custom
	 * @description `|►| status`
	 */},{key:"getStatus",value:function getStatus(type,custom){custom||(custom=""),this.apiCall("status","<status><type>".concat(type,"</type>").concat(custom,"</status>"));}/**
	 * Show phone app
	 * @description `|►| bringToFront`
	 */},{key:"bringToFront",value:function bringToFront(){this.apiCall("bringToFront","<bringToFront><window>main</window></bringToFront>");}/**
	 * Set status event
	 * @param {string} status
	 * @param {Event} e
	 */},{key:"setStatus",value:function setStatus(status,e){this.status=status,this.lastEvent=e,this.updateBtn(),this.log("\u260E %c"+status);}/**
	 * Send a request to the phone application
	 * @param {string} method
	 * @param {string} body
	 */},{key:"apiCall",value:function apiCall(method,body){this.log("|\u25BA| "+method,body),body="<?xml version=\"1.0\" encoding=\"utf-8\" ?>\r\n"+body;var msg="GET /"+method+"\r\nUser-Agent: YetiForce CRM";msg+="\r\nContent-Type: application/xml\r\nContent-Length: ",msg+=body.length+"\r\n\r\n"+body,this.websocket.send(msg);}/**
	 * Parse response from websocket
	 * @param {string} msg
	 * @returns {object}
	 */},{key:"parseMessage",value:function parseMessage(msg){var response={},content="",lines=msg.replace(/\r\n/g,"\n").split("\n"),line=lines[0];"POST"==line.substr(0,4)?(response.messageType="EVENT",line=line.substr(5).trim(),response.eventType=line.substr(0,13)):"HTTP/1.1"==line.substr(0,8)&&(line=line.substr(8).trim(),"200 OK"==line.substr(0,6)?response.messageType="RESPONSE":("4"==line[0]||"5"==line[0])&&(response.messageType="ERROR",response.errorCode=line.substr(0,3),response.errorText=line.substr(4)));for(var i=1;i<lines.length&&"<"!=lines[i][0];i++)continue;for(;i<lines.length;i++)content+=lines[i],i<lines.length-1&&(content+="\n");if(0<content.length){var parser=new DOMParser;response.xml=$(parser.parseFromString(content,"text/xml"));}return response}}])}(Integrations_Pbx_Base);
//# sourceMappingURL=BriaSoftphone.min.js.map
