{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	<!-- tpl-Base-Detail-InventorySummary -->
	<div class="row">
		{assign var="FIELD_DISCOUNT" value=$INVENTORY_MODEL->getField('discount')}
		{if $FIELD_DISCOUNT && $FIELD_DISCOUNT->isSummaryEnabled(\Vtiger_Basic_InventoryField::SUMMARY_BLOCK) && isset($FIELDS[1]['discount']) && isset($FIELDS[0]['discountmode'])}
			{assign var="DISCOUNT" value=$FIELD_DISCOUNT->getSummaryValuesFromData($INVENTORY_ROWS)}
			<div class="col-md-4">
				<table class="table  inventorySummaryContainer">
					<thead>
						<tr>
							<th>
								<img src="{\App\Layout::getImagePath('Discount24.png')}"
									alt="{\App\Language::translate('LBL_DISCOUNT', $MODULE_NAME)}" />&nbsp;&nbsp;
								<strong>{\App\Language::translate('LBL_DISCOUNTS_SUMMARY',$MODULE_NAME)}</strong>
							</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td class="textAlignRight">
								{CurrencyField::convertToUserFormatSymbol($DISCOUNT, true, $CURRENCY_SYMBOLAND['currency_symbol'])}
							</td>
						</tr>
					</tbody>
				</table>
			</div>
		{/if}
		{assign var="TAX_FIELD" value=$INVENTORY_MODEL->getField('tax')}
		{if $TAX_FIELD && $TAX_FIELD->isSummaryEnabled(\Vtiger_Basic_InventoryField::SUMMARY_BLOCK) && isset($FIELDS[1]['tax']) && isset($FIELDS[0]['taxmode']) && $INVENTORY_MODEL->isField('net')}
			{assign var="TAXES" value=$TAX_FIELD->getTaxSummary($RECORD)}
			<div class="col-md-4">
				<table class="table  inventorySummaryContainer">
					<thead>
						<tr>
							<th colspan="2">
								<img src="{\App\Layout::getImagePath('Tax24.png')}"
									alt="{\App\Language::translate('LBL_TAX', $MODULE_NAME)}" />&nbsp;&nbsp;
								<strong>{\App\Language::translate('LBL_TAX_SUMMARY',$MODULE_NAME)}</strong>
							</th>
						</tr>
					</thead>
					<tbody>
						{foreach item=TAX key=KEY from=$TAXES['groups']}
							<tr>
								<td class="textAlignRight" width='70px'>
									{$KEY}
								</td>
								<td class="textAlignRight">
									{CurrencyField::convertToUserFormatSymbol($TAX, true, $CURRENCY_SYMBOLAND['currency_symbol'])}
								</td>
							</tr>
						{/foreach}
						<tr>
							<td class="textAlignRight" width='70px'>
								{\App\Language::translate('LBL_AMOUNT',$MODULE_NAME)}
							</td>
							<td class="textAlignRight">
								{CurrencyField::convertToUserFormatSymbol($TAXES['total'], true, $CURRENCY_SYMBOLAND['currency_symbol'])}
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			{if isset($FIELDS[0]['currency']) && $BASE_CURRENCY['id'] != $CURRENCY}
				{assign var="CURRENCY_FIELD" value=$INVENTORY_MODEL->getField('currency')}
				{assign var="CURRENCIES" value=$CURRENCY_FIELD->getCurrencyConversationSummary($RECORD)}
				<div class="col-md-4">
					<table class="table  inventorySummaryContainer">
						<thead>
							<tr>
								<th colspan="2">
									<strong>{\App\Language::translate('LBL_CURRENCIES_SUMMARY',$MODULE_NAME)}</strong>
								</th>
							</tr>
						</thead>
						<tbody>
							{foreach item=CURRENCY_VALUE key=KEY from=$CURRENCIES['groups']}
								<tr>
									<td class="textAlignRight" width='70px'>
										{$KEY}
									</td>
									<td class="textAlignRight">
										{CurrencyField::convertToUserFormatSymbol($CURRENCY_VALUE, true, $BASE_CURRENCY['currency_symbol'])}
									</td>
								</tr>
							{/foreach}
							<tr>
								<td class="textAlignRight" width='70px'>
									{\App\Language::translate('LBL_AMOUNT',$MODULE_NAME)}
								</td>
								<td class="textAlignRight">
									{CurrencyField::convertToUserFormatSymbol($CURRENCIES['total'], true, $BASE_CURRENCY['currency_symbol'])}
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			{/if}
		{/if}
	</div>
	<!-- /tpl-Base-Detail-InventorySummary -->
{/strip}
