<?php
/**
 * Report field view.
 *
 * @package   Views
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */
class ReportTemplate_Fields_View extends \App\Controller\View\Page
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		if (!Users_Privileges_Model::getCurrentUserPrivilegesModel()->hasModulePermission($request->getModule())) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
	}

	public function process(App\Request $request)
	{
		$sourceModule = $request->getByType('sourceModule', App\Purifier::ALNUM);
		$relatedItems = $request->getArray('relations', App\Purifier::ALNUM);
		$viewer = $this->getViewer($request);
		$reportFields = new ReportTemplate_ReportFields_Model($sourceModule, $relatedItems ?? []);
		$viewer->assign('REPORT_FIELDS', []);
		$viewer->assign('FIELDS', $reportFields->getFields());
		echo $viewer->view('ReportFields.tpl', $request->getModule(), true);
	}
}
