<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 * *********************************************************************************** */

use App\Condition;
use App\Controller\ExposeMethod;
use App\Exceptions\NoPermitted;
use App\Request;

class Vtiger_MassActionAjax_View extends Vtiger_IndexAjax_View
{
	use ExposeMethod;

	public function __construct()
	{
		parent::__construct();
		$this->exposeMethod('showAddCommentForm');
	}

	/**
	 * Function returns the Add Comment form.
	 *
	 * @param Request $request
	 *
	 * @throws NoPermitted
	 */
	public function showAddCommentForm(Request $request)
	{
		$sourceModule = $request->getModule();
		$moduleName = 'ModComments';
		$moduleModel = Vtiger_Module_Model::getInstance($sourceModule);
		$userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
		if (!$userPrivilegesModel->hasModulePermission($sourceModule) || !($moduleModel->isCommentEnabled() && $userPrivilegesModel->hasModuleActionPermission($moduleName, 'CreateView') && $moduleModel->isPermitted('MassAddComment'))) {
			throw new NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
		$viewer = $this->getViewer($request);
		$viewer->assign('SOURCE_MODULE', $sourceModule);
		$viewer->assign('MODULE', $moduleName);
		$viewer->assign('CVID', $request->getByType('viewname', 2));
		$viewer->assign('SELECTED_IDS', $request->getArray('selected_ids', 2));
		$viewer->assign('EXCLUDED_IDS', $request->getArray('excluded_ids', 2));
		$viewer->assign('USER_MODEL', Users_Record_Model::getCurrentUserModel());
		$viewer->assign('OPERATOR', $request->getByType('operator'));
		$viewer->assign('ALPHABET_VALUE', Condition::validSearchValue($request->getByType('search_value', 'Text'), $moduleName, $request->getByType('search_key', 'Alnum'), $request->getByType('operator')));
		$viewer->assign('ENTITY_STATE', $request->getByType('entityState'));
		$viewer->assign('SEARCH_KEY', $request->getByType('search_key', 'Alnum'));
		$viewer->assign('SEARCH_PARAMS', Condition::validSearchParams($sourceModule, $request->getArray('search_params'), false));
		$advancedConditions = $request->has('advancedConditions') ? $request->getArray('advancedConditions') : [];
		if ($advancedConditions) {
			Condition::validAdvancedConditions($advancedConditions);
		}
		$viewer->assign('ADVANCED_CONDITIONS', $advancedConditions);
		$viewer->view('AddCommentForm.tpl', $moduleName);
	}
}
