'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";/**
 *  Class representing a modal calendar.
 * @extends Calendar_Calendar_Js
 */function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor))throw new TypeError("Cannot call a class as a function")}function _defineProperties(target,props){for(var descriptor,i=0;i<props.length;i++)descriptor=props[i],descriptor.enumerable=descriptor.enumerable||!1,descriptor.configurable=!0,"value"in descriptor&&(descriptor.writable=!0),Object.defineProperty(target,_toPropertyKey(descriptor.key),descriptor);}function _createClass(Constructor,protoProps,staticProps){return protoProps&&_defineProperties(Constructor.prototype,protoProps),staticProps&&_defineProperties(Constructor,staticProps),Object.defineProperty(Constructor,"prototype",{writable:!1}),Constructor}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}function _callSuper(t,o,e){return o=_getPrototypeOf(o),_possibleConstructorReturn(t,_isNativeReflectConstruct()?Reflect.construct(o,e||[],_getPrototypeOf(t).constructor):o.apply(t,e))}function _possibleConstructorReturn(self,call){if(call&&("object"===_typeof(call)||"function"==typeof call))return call;if(void 0!==call)throw new TypeError("Derived constructors may only return object or undefined");return _assertThisInitialized(self)}function _assertThisInitialized(self){if(void 0===self)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return self}function _isNativeReflectConstruct(){try{var t=!Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],function(){}));}catch(t){}return (_isNativeReflectConstruct=function(){return !!t})()}function _get(){return _get="undefined"!=typeof Reflect&&Reflect.get?Reflect.get.bind():function(target,property,receiver){var base=_superPropBase(target,property);if(base){var desc=Object.getOwnPropertyDescriptor(base,property);return desc.get?desc.get.call(3>arguments.length?target:receiver):desc.value}},_get.apply(this,arguments)}function _superPropBase(object,property){for(;!Object.prototype.hasOwnProperty.call(object,property)&&(object=_getPrototypeOf(object),null!==object););return object}function _getPrototypeOf(o){return _getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf.bind():function(o){return o.__proto__||Object.getPrototypeOf(o)},_getPrototypeOf(o)}function _inherits(subClass,superClass){if("function"!=typeof superClass&&null!==superClass)throw new TypeError("Super expression must either be null or a function");subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,writable:!0,configurable:!0}}),Object.defineProperty(subClass,"prototype",{writable:!1}),superClass&&_setPrototypeOf(subClass,superClass);}function _setPrototypeOf(o,p){return _setPrototypeOf=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(o,p){return o.__proto__=p,o},_setPrototypeOf(o,p)}window.Calendar_CalendarQuickCreate_Js=/*#__PURE__*/function(_Calendar_Calendar_Js){function Calendar_CalendarQuickCreate_Js(container,readonly){var _this;return _classCallCheck(this,Calendar_CalendarQuickCreate_Js),_this=_callSuper(this,Calendar_CalendarQuickCreate_Js,[container,readonly]),_this.isSwitchAllDays=!1,_this.sidebarName="add",_this.eventCreate=!1,_this.module="Calendar",_this.renderCalendar(),_this.registerEvents(),_this}/**
	 * Function sets calendar module's options
	 * @returns {{eventClick: function, headerToolbar: object, selectable: boolean}}
	 */return _inherits(Calendar_CalendarQuickCreate_Js,_Calendar_Calendar_Js),_createClass(Calendar_CalendarQuickCreate_Js,[{key:"setCalendarModuleOptions",value:function setCalendarModuleOptions(){var options=_get(_getPrototypeOf(Calendar_CalendarQuickCreate_Js.prototype),"setCalendarModuleOptions",this).call(this);return options.selectable=!0,options.headerToolbar={left:"dayGridMonth,".concat(app.getMainParams("weekView"),",").concat(app.getMainParams("dayView"),",today"),center:"prevYear,prev,title,next,nextYear",right:""},options.eventClick=function(info){info.jsEvent.preventDefault();},options}/**
	 * Get selected users
	 * @returns {{ selectedIds: array, excludedIds: array }}
	 */},{key:"getSelectedUsersCalendar",value:function getSelectedUsersCalendar(){return {selectedIds:[this.container.find(".assigned_user_id").val()],excludedIds:[]}}/**
	 * Function registers calendar events
	 */},{key:"registerEvents",value:function registerEvents(){var calendarView=this.getCalendarView();this.switchContainer=$("<div class=\"js-calendar-switch-container\"></div>").insertAfter(calendarView.find(".fc-center")),this.registerSwitchEvents(),this.registerUsersChange(),this.registerAutofillTime(),this.registerPopoverButtonsClickEvent();}/**
	 * Function registers calendar switch event
	 */},{key:"registerSwitchEvents",value:function registerSwitchEvents(){var _this2=this;!1!==app.getMainParams("hiddenDays",!0)&&(this.switchContainer.html(this.createSwitch()),this.switchContainer.find("input").on("change",function(e){var currentTarget=$(e.currentTarget),hiddenDays=[];"undefined"==typeof currentTarget.data("on-text")?_this2.isSwitchAllDays=!0:(hiddenDays=app.getMainParams("hiddenDays",!0),_this2.isSwitchAllDays=!1),_this2.fullCalendar.setOption("hiddenDays",hiddenDays),_this2.registerSwitchEvents();}));}/**
	 * Generate filter buttons
	 * @returns {string}
	 */},{key:"createSwitch",value:function createSwitch(){var on=app.vtranslate("JS_WORK_DAYS"),off=app.vtranslate("JS_ALL"),state=this.isSwitchAllDays;return "<div class=\"btn-group btn-group-toggle js-switch c-calendar-switch\" data-toggle=\"buttons\">\n\t\t\t\t\t<label class=\"btn btn-outline-primary c-calendar-switch__button js-switch--label-on ".concat(state?"":"active","\">\n\t\t\t\t\t\t<input type=\"radio\" name=\"options\" data-on-text=\"").concat(on,"\" autocomplete=\"off\" ").concat(state?"":"checked",">").concat(on,"\n\t\t\t\t\t</label>\n\t\t\t\t\t<label class=\"btn btn-outline-primary c-calendar-switch__button ").concat(state?"active":"","\">\n\t\t\t\t\t\t<input type=\"radio\" name=\"options\" data-off-text=\"").concat(off,"\" autocomplete=\"off\" ").concat(state?"checked":"",">").concat(off,"\n\t\t\t\t\t</label>\n\t\t\t\t</div>")}/**
	 * Function registers select's user change event
	 */},{key:"registerUsersChange",value:function registerUsersChange(){var _this3=this;this.container.find(".assigned_user_id").on("change",function(){_this3.reloadCalendarData();});}/**
	 * Function invokes by FullCalendar, sets selected days in form
	 * @param {Object} info
	 * @returns
	 */},{key:"selectDays",value:function selectDays(info){var _this4=this;return "status"===this.sidebarName?(this.sidebarName="add",void this.getCalendarCreateView().done(function(){_this4.selectDays(info);})):void this.selectCallbackCreateModal(this.container,info)}/** @inheritdoc */},{key:"registerEditForm",value:function registerEditForm(sideBar){var _this5=this,editViewInstance=Vtiger_Edit_Js.getInstanceByModuleName(sideBar.find("[name=\"module\"]").val()),rightFormCreate=sideBar.find("form.js-form");editViewInstance.registerBasicEvents(rightFormCreate),rightFormCreate.validationEngine(app.validationEngineOptions),App.Fields.Picklist.showSelect2ElementView(sideBar.find("select")),sideBar.find(".js-summary-close-edit").on("click",function(){_this5.getCalendarCreateView();}),App.Components.QuickCreate.registerPostLoadEvents(rightFormCreate,[]),App.Fields.Text.Editor.register(sideBar.find(".js-editor"),{height:"5em",toolbar:"Min"});}/** @inheritdoc */},{key:"updateSidebar",value:function updateSidebar(sidebar,data){var modalTitleContainer=$(".js-modal-title__container"),modalTitles=modalTitleContainer.find("[class*=\"js-modal-title\"]");if(data=$(data),modalTitles.addClass("d-none"),data.hasClass("js-edit-form")){var title=data.find(".js-sidebar-title").data("title");modalTitles.filter(".js-modal-title--".concat(title)).removeClass("d-none"),this.sidebarName=title;}else data.hasClass("js-activity-state")&&(modalTitles.filter(".js-modal-title--status").removeClass("d-none"),this.sidebarName="status");sidebar.find(".js-qc-form").html(data);}}])}(Calendar_Calendar_Js),jQuery.Class("Calendar_QuickCreate_Js",{},{registerEvents:function registerEvents(container){new Calendar_CalendarQuickCreate_Js(container.closest(".js-modal-container"),!0),container.find(".js-activity-buttons button").on("click",function(e){var form=container.find("form"),currentTarget=$(e.currentTarget);1===currentTarget.data("type")?(form.append("<input type=hidden name=\"activitystatus\" value=\""+currentTarget.data("state")+"\">"),form.submit()):(container.find(".js-activity-buttons").remove(),form.find("[name=\"record\"]").val(""),form.append("<input type=hidden name=\"postponed\" value=\"true\">"),form.append("<input type=hidden name=\"followup\" value=\""+currentTarget.data("id")+"\">"));});}});
//# sourceMappingURL=CalendarQuickCreate.min.js.map
