'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";Vtiger_Edit_Js("Calendar_Edit_Js",{currencyInstance:!1,checkEmail:function checkEmail(field){return !Calendar_Edit_Js.currencyInstance.emailExists(field.val())||app.vtranslate("JS_DUPLICATE_RECORD")+": "+field.val()}},{init:function init(){Calendar_Edit_Js.currencyInstance=this;},registerReminderFieldCheckBox:function registerReminderFieldCheckBox(){var element=this.getForm().find(".js-reminder-field-checkbox");element.on("change",function(){var rowElement=element.closest(".js-reminder-field-element").find(".js-reminder-field-row");element.is(":checked")?rowElement.removeClass("d-none"):rowElement.addClass("d-none");}),element.change();},/**
		 * Function which will register change event on recurrence field checkbox
		 */registerRecurrenceFieldCheckBox:function registerRecurrenceFieldCheckBox(){var form=this.getForm(),element=form.find("input[name=\"reapeat\"]");element.on("change",function(e){var repeatUI=form.find(".js-repeat-ui"),container=form.find("[name=\"followup\"]").closest(".fieldValue");$(e.currentTarget).is(":checked")?(repeatUI.closest(".fieldRow").removeClass("d-none"),container.find("[name=\"followup_display\"]").attr("disabled","disabled"),container.find("button").attr("disabled","disabled")):(container.find("[name=\"followup_display\"]").removeAttr("disabled"),container.find("button").removeAttr("disabled"),repeatUI.closest(".fieldRow").addClass("d-none"));}),element.change();},/**
		 * Function which will register the change event for recurring type
		 */registerRecurringTypeChangeEvent:function registerRecurringTypeChangeEvent(){var container=this.getForm(),thisInstance=this;container.find(".recurringType").on("change",function(e){thisInstance.changeRecurringTypesUIStyles(jQuery(e.currentTarget).val());}),container.find(".js-repeat-ui [name=\"calendarEndType\"]").on("change",function(e){var currentTarget=$(e.currentTarget),value=currentTarget.val();"never"===value?(container.find(".countEvents").attr("disabled","disabled"),container.find(".calendarUntil").attr("disabled","disabled")):"count"===value?(container.find(".countEvents").removeAttr("disabled"),container.find(".calendarUntil").attr("disabled","disabled")):"until"===value&&(container.find(".countEvents").attr("disabled","disabled"),container.find(".calendarUntil").removeAttr("disabled"));});},/**
		 * Function which will change the UI styles based on recurring type
		 * @params - recurringType - which recurringtype is selected
		 */changeRecurringTypesUIStyles:function changeRecurringTypesUIStyles(recurringType){var container=this.getForm();"DAILY"==recurringType||"YEARLY"==recurringType?(container.find(".repeatWeekUI").removeClass("show").addClass("d-none"),container.find(".repeatMonthUI").removeClass("show").addClass("d-none")):"WEEKLY"==recurringType?(container.find(".repeatWeekUI").removeClass("d-none").addClass("show"),container.find(".repeatMonthUI").removeClass("show").addClass("d-none")):"MONTHLY"==recurringType&&(container.find(".repeatWeekUI").removeClass("show").addClass("d-none"),container.find(".repeatMonthUI").removeClass("d-none").addClass("show"));},setDefaultEndTime:function setDefaultEndTime(container){var self=this;if(container.find(".js-autofill").is(":checked"))self.getFreeTime(container);else {if("1"===$("[name=\"userChangedEndDateTime\"]").val())return;var dateStartElement=container.find("[name=\"date_start\"]"),startTimeElement=container.find("[name=\"time_start\"]"),endTimeElement=container.find("[name=\"time_end\"]"),endDateElement=container.find("[name=\"due_date\"]"),startDate=dateStartElement.val(),startTime=startTimeElement.val(),result=Vtiger_Time_Validator_Js.invokeValidation(startTimeElement);if(!0!==result)return;var activityType=container.find("[name=\"activitytype\"]"),activityTypeValue=activityType.val();activityType.is("[type=\"radio\"]")&&(activityTypeValue=activityType.filter(":checked").val());var dateFormat=container.find("[name=\"due_date\"]").data("dateFormat").toUpperCase(),timeFormat=endTimeElement.data("format"),activityDurations=JSON.parse(container.find("[name=\"defaultOtherEventDuration\"]").val()),minutes=0;for(var i in activityDurations)if(activityDurations[i].activitytype===activityTypeValue){minutes=parseInt(activityDurations[i].duration);break}var defaultTimeFormat="HH:mm";12===timeFormat&&(defaultTimeFormat="hh:mm A");var endDate=moment(startDate+" "+startTime,dateFormat+" "+defaultTimeFormat).add(minutes,"minutes");endDateElement.val(endDate.format(dateFormat)),endTimeElement.val(endDate.format(defaultTimeFormat));}},/**
		 * Function to change the end time based on default call duration
		 */registerActivityTypeChangeEvent:function registerActivityTypeChangeEvent(container){var thisInstance=this;container.on("change","[name=\"activitytype\"]",function(){thisInstance.setDefaultEndTime(container);});},/**
		 * Function to change the end time based on default call duration
		 */registerTimeStartChangeEvent:function registerTimeStartChangeEvent(container){var thisInstance=this;container.find("input[name=\"time_start\"]").on("change",function(){thisInstance.setDefaultEndTime(container);}),container.find("[name=\"date_start\"]").on("change",function(){var endDateElement=container.find("[name=\"due_date\"]"),start=thisInstance.getDateInstance(container,"start"),end=thisInstance.getDateInstance(container,"end"),dateFormat=CONFIG.dateFormat.toUpperCase();container.find(".js-autofill").trigger("change"),start>end&&(end=start,endDateElement.val(moment(end).format(dateFormat)),App.Fields.Date.register(container));}),container.find("input[name=\"time_start\"]").on("focus",function(e){var element=$(e.currentTarget);element.data("prevValue",element.val());}),container.find("input[name=\"time_start\"]").on("blur",function(e,data){"undefined"==typeof data&&(data={}),"undefined"==typeof data.forceChange&&(data.forceChange=!1);var element=$(e.currentTarget);(element.val()!==element.data("prevValue")||data.forceChange)&&(e=$.Event("keydown"),e.which=13,e.keyCode=13,element.trigger(e));});},registerEndDateTimeChangeLogger:function registerEndDateTimeChangeLogger(container){container.find("[name=\"time_end\"]").on("change",function(e){var timeElement=jQuery(e.currentTarget),result=Vtiger_Time_Validator_Js.invokeValidation(timeElement);if(!0==result){var timeDateElement=timeElement.closest(".fieldValue").find("[name=\"due_date\"]");jQuery("[name=\"userChangedEndDateTime\"]").val("1"),timeDateElement.data("userChangedTime",!0);}}),container.find("[name=\"due_date\"]").on("change",function(e){var dueDateElement=jQuery(e.currentTarget),result=Vtiger_Date_Validator_Js.invokeValidation(dueDateElement);!0!=result||(jQuery("[name=\"userChangedEndDateTime\"]").val("1"),dueDateElement.data("userChangedTime",!0));});},/**
		 *
		 * @returns {String}
		 */getRule:function getRule(){var form=this.getForm(),freq=form.find(".recurringType").val(),rule="FREQ="+freq;rule+=";INTERVAL="+form.find(".repeatFrequency").val();var endValue=form.find(".js-repeat-ui [name=\"calendarEndType\"]:checked").val();if("count"===endValue)rule+=";COUNT="+form.find(".countEvents").val();else if("until"===endValue){var date=App.Fields.Date.dateToDbFormat(App.Fields.Date.getDateInstance(form.find(".calendarUntil").val()));rule+=";UNTIL="+date.replace(/-/gi,"")+"T235959";}if("WEEKLY"===freq){var checkedElements=[];form.find(".repeatWeekUI [type=\"checkbox\"]").each(function(){var currentTarget=$(this);currentTarget.is(":checked")&&checkedElements.push(currentTarget.val());}),0<checkedElements.length&&(rule+=";BYDAY="+checkedElements.join(","));}if("MONTHLY"===freq){var dateInstance=App.Fields.Date.getDateInstance(form.find("[name=\"date_start\"]").val()),dayOfMonth=dateInstance.getDate();if("DAY"==form.find(".calendarMontlyType:checked").val()){var dayOfWeekLabel="";switch(dateInstance.getDay()){case 0:dayOfWeekLabel="SU";break;case 1:dayOfWeekLabel="MO";break;case 2:dayOfWeekLabel="TU";break;case 3:dayOfWeekLabel="WE";break;case 4:dayOfWeekLabel="TU";break;case 5:dayOfWeekLabel="FR";break;case 6:dayOfWeekLabel="SA";}rule+=";BYDAY="+(parseInt((dayOfMonth-1)/7)+1)+dayOfWeekLabel;}else rule+=";BYMONTHDAY="+dayOfMonth;}return rule},/**
		 * This function will register the submit event on form
		 * @param {jQuery} form
		 */registerFormSubmitEvent:function registerFormSubmitEvent(form){var thisInstance=this;form.on("submit",function(){var recurringCheck=form.find("input[name=\"reapeat\"]").is(":checked");recurringCheck&&form.find("[name=\"recurrence\"]").val(thisInstance.getRule());var rows=form.find(".js-participants-content .js-participant-row"),invitees=[];rows.each(function(index,domElement){var row=$(domElement);row.data("email")&&invitees.push([row.data("email"),row.data("crmid"),row.data("ivid"),row.data("name")]);}),$("<input type=\"hidden\" name=\"inviteesid\" />").appendTo(form).val(JSON.stringify(invitees));});},getFreeTime:function getFreeTime(container){var ownerId=container.find("[name=\"assigned_user_id\"], [data-element-name=\"assigned_user_id\"]");if(0!==ownerId.length&&ownerId.val()){var timeStart=container.find("[name=\"time_start\"], [data-element-name=\"time_start\"]"),timeEnd=container.find("[name=\"time_end\"], [data-element-name=\"time_end\"]"),dateStart=container.find("[name=\"date_start\"], [data-element-name=\"date_start\"]"),params={module:"Calendar",action:"GetFreeTime",dateStart:dateStart.val(),ownerId:ownerId.val(),activitytype:container.find("[name=\"activitytype\"]").val()},progress=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request(params).done(function(data){progress.progressIndicator({mode:"hide"}),null===data.result.date_start?(app.showNotify({text:app.vtranslate("JS_ERROR_MAX_VALUE"),type:"error"}),container.find(".js-autofill").prop("checked",!1).trigger("change")):(timeStart.val(data.result.time_start),timeEnd.val(data.result.time_end),dateStart.val(data.result.date_start),container.find("[name=\"due_date\"]").val(data.result.date_start));});}},registerAutoFillHours:function registerAutoFillHours(container){var thisInstance=this,allDay=container.find("[name=\"allday\"]"),timeStart=container.find("[name=\"time_start\"]"),timeEnd=container.find("[name=\"time_end\"]"),dateEnd=container.find("[name=\"due_date\"]"),autoFill=container.find(".js-autofill");container.find(".js-autofill__icon").on("click",function(e){autoFill.is(":checked")?($(e.currentTarget).closest(".input-group-text").removeClass("bg-color-blue-700").removeClass("text-white"),autoFill.prop("checked",!1).trigger("change")):($(e.currentTarget).closest(".input-group-text").addClass("bg-color-blue-700").addClass("text-white"),autoFill.prop("checked",!0).trigger("change"));}),container.find(".js-autofill").on("change",function(e){var currentTarget=$(e.currentTarget);currentTarget.is(":checked")?(container.find(".js-autofill").prop("checked",!0),thisInstance.getFreeTime(container),timeStart.attr("readonly","readonly"),timeEnd.attr("readonly","readonly"),timeStart.clockpicker("remove"),timeEnd.clockpicker("remove"),allDay.attr("disabled","disabled"),allDay.prop("checked",!1),allDay.trigger("change"),dateEnd.attr("readonly","readonly")):(container.find(".js-autofill").prop("checked",!1),allDay.removeAttr("disabled"),timeStart.removeAttr("readonly"),timeEnd.removeAttr("readonly"),dateEnd.removeAttr("readonly"),app.registerEventForClockPicker(timeStart),app.registerEventForClockPicker(timeEnd));});},registerMarkAsCompletedBtn:function registerMarkAsCompletedBtn(container){container.find(".js-btn--mark-as-completed").on("click",function(){var self=$(this);self.hasClass("active")?container.find(".js-completed").remove():container.append("<input class=\"js-completed\" type=hidden name=\"activitystatus\" value=\"PLL_COMPLETED\" data-js=\"remove\">");});},registerBasicEvents:function registerBasicEvents(container){this._super(container),this.toggleTimesInputs(container),this.registerTimesInputs(container),this.registerTimeStartChangeEvent(container),this.registerActivityTypeChangeEvent(container),this.registerEndDateTimeChangeLogger(container),this.registerAutoFillHours(container),this.registerMarkAsCompletedBtn(container),this.registerInviteEvent(container),this.registerAddInvitation(container),this.registerFormSubmitEvent(container),this.registerReminderFieldCheckBox();},toggleTimesInputs:function toggleTimesInputs(container){container.find(":checkbox").on("change",function(){var checkboxName=$(this).attr("name");if("allday"==checkboxName){var checkboxIsChecked=$(this).is(":checked");container.find("#quickCreate").length||(checkboxIsChecked?container.find(".time").hide():container.find(".time").show());}});},registerTimesInputs:function registerTimesInputs(container){var allday=container.find("[name=\"allday\"]:checkbox");allday.prop("checked")&&container.find(".time").hide();},getDateInstance:function getDateInstance(container,type){var startDateElement=container.find("[name=\"date_start\"]"),endDateElement=container.find("[name=\"due_date\"]"),endTimeElement=container.find("[name=\"time_end\"]"),startTimeElement=container.find("[name=\"time_start\"]"),startDate=startDateElement.val(),startTime=startTimeElement.val(),endTime=endTimeElement.val(),endDate=endDateElement.val(),dateFormat=CONFIG.dateFormat;return "start"==type?App.Fields.Date.getDateInstance(startDate+" "+startTime,dateFormat):"end"==type?App.Fields.Date.getDateInstance(endDate+" "+endTime,dateFormat):void 0},emailExists:function emailExists(email){email=email.toLowerCase();var recordExist=!1;return this.getForm().find(".js-participants-content").find(".js-participant-row").each(function(index,element){if($(element).data("email").toLowerCase()===email)return recordExist=!0,!1}),recordExist},registerAddInvitation:function registerAddInvitation(container){container.find(".js-btn-add-invitation").on("click",function(){var progressIndicatorElement=$.progressIndicator();app.showModalWindow(null,"index.php?module=Calendar&view=InviteEmail",function(data){data.find(".js-modal__save").on("click",function(){var email=data.find(".js-invite-email-input").val(),nameAttendee=data.find(".js-invite-name-input").val(),participantsContent=container.find(".js-participants-content"),formEmail=data.find(".js-form");if(formEmail.validationEngine(app.validationEngineOptions),formEmail.validationEngine("validate")){var participantRow=participantsContent.find(".d-none .js-participant-row").clone(!0,!0);participantRow.data("crmid",0),participantRow.data("email",email),nameAttendee?(participantRow.find(".js-participant-name").data("content",nameAttendee).text(nameAttendee),participantRow.data("name",nameAttendee)):(participantRow.find(".js-participant-name").data("content",email).text(email),participantRow.data("name","")),participantsContent.append(participantRow),app.hideModalWindow();}}),progressIndicatorElement.progressIndicator({mode:"hide"});});});},registerInviteEvent:function registerInviteEvent(editViewForm){this.registerRow(editViewForm);var participantsContent=editViewForm.find(".js-participants-content"),participantsSearch=editViewForm.find(".js-participants-search");$.widget("custom.ivAutocomplete",$.ui.autocomplete,{_create:function _create(){this._super(),this.widget().menu("option","items","> :not(.ui-autocomplete-category)");},_renderMenu:function _renderMenu(ul,items){var that=this,currentCategory="";$.each(items,function(_index,item){item.category!=currentCategory&&(ul.append("<li class='ui-autocomplete-category'>"+item.category+"</li>"),currentCategory=item.category),that._renderItemData(ul,item);});},_renderItemData:function _renderItemData(ul,item){return this._renderItem(ul,item).data("ui-autocomplete-item",item)},_renderItem:function _renderItem(ul,item){return $("<li>").data("item.autocomplete",item).append($("<a></a>").html(item.label)).appendTo(ul)}}),participantsSearch.ivAutocomplete({delay:"600",minLength:"3",source:function source(request,response){AppConnector.request({module:"Calendar",action:"Invitees",mode:"find",value:request.term}).done(function(result){var reponseDataList=result.result;0>=reponseDataList.length&&reponseDataList.push({label:app.vtranslate("JS_NO_RESULTS_FOUND"),type:"no results",category:""}),response(reponseDataList);});},select:function select(event,ui){var selected=ui.item;//To stop selection if no results is selected
if("undefined"!=typeof selected.type&&"no results"==selected.type)return !1;var recordExist=!0;if(participantsContent.find(".js-participant-row").each(function(){$(this).data("crmid")==selected.id&&(recordExist=!1);}),recordExist){var participantRow=participantsContent.find(".d-none .js-participant-row").clone(!0,!0);Vtiger_Index_Js.getEmailFromRecord(selected.id,selected.module).done(function(email){participantRow.data("crmid",selected.id),participantRow.data("email",email),participantRow.find(".js-participant-name").data("content",selected.fullLabel+email).text(selected.label),participantRow.find(".js-participant-icon .c-badge__icon").removeClass("fas fa-envelope").addClass("yfm-"+selected.module),participantsContent.append(participantRow);});}else app.showNotify({text:app.vtranslate("JS_DUPLICATE_RECORD")+": "+selected.fullLabel,type:"info"});},close:function close(){participantsSearch.val("");}});},registerRow:function registerRow(row){row.on("click",".js-participant-remove",function(e){$(e.target).closest(".js-participant-row").remove();});},registerEvents:function registerEvents(){this.proceedRegisterEvents()&&(this.registerRecurrenceFieldCheckBox(),this.registerRecurringTypeChangeEvent(),this._super());}});
//# sourceMappingURL=Edit.min.js.map
