'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";Settings_Vtiger_Edit_Js("Settings_Workflows_Edit_Js",{instance:{}},{currentInstance:!1,workFlowsContainer:!1,init:function init(){this.initiate();},/**
		 * Function to get the container which holds all the workflow elements
		 * @return jQuery object
		 */getContainer:function getContainer(){return this.workFlowsContainer},/**
		 * Function to set the reports container
		 * @params : element - which represents the workflow container
		 * @return : current instance
		 */setContainer:function setContainer(element){return this.workFlowsContainer=element,this},/*
		 * Function to return the instance based on the step of the Workflow
		 */getInstance:function getInstance(step){if(step in Settings_Workflows_Edit_Js.instance)return Settings_Workflows_Edit_Js.instance[step];return Settings_Workflows_Edit_Js.instance[step]=new window["Settings_Workflows_Edit"+step+"_Js"],Settings_Workflows_Edit_Js.instance[step]},/*
		 * Function to get the value of the step
		 * returns 1 or 2 or 3
		 */getStepValue:function getStepValue(){var container=this.currentInstance.getContainer();return jQuery(".step",container).val()},/*
		 * Function to initiate the step 1 instance
		 */initiate:function initiate(container){"undefined"==typeof container&&(container=jQuery(".workFlowContents")),container.is(".workFlowContents")?this.setContainer(container):this.setContainer(jQuery(".workFlowContents",container)),this.initiateStep("1"),this.currentInstance.registerEvents();},/*
		 * Function to initiate all the operations for a step
		 * @params step value
		 */initiateStep:function initiateStep(stepVal){this.activateHeader("step"+stepVal);var currentInstance=this.getInstance(stepVal);this.currentInstance=currentInstance;},/*
		 * Function to activate the header based on the class
		 * @params class name
		 */activateHeader:function activateHeader(step){var headersContainer=jQuery(".crumbs ");headersContainer.find(".active").removeClass("active"),jQuery("#"+step,headersContainer).addClass("active");},/*
		 * Function to register the click event for next button
		 */registerFormSubmitEvent:function registerFormSubmitEvent(form){var thisInstance=this;jQuery.isFunction(thisInstance.currentInstance.submit)&&form.on("submit",function(e){var specialValidation=!0;jQuery.isFunction(thisInstance.currentInstance.isFormValidate)&&(specialValidation=thisInstance.currentInstance.isFormValidate()),jQuery(e.currentTarget).validationEngine("validate")&&specialValidation&&thisInstance.currentInstance.submit().done(function(data){thisInstance.getContainer().append(data),thisInstance.initiateStep(parseInt(thisInstance.getStepValue())+1),thisInstance.currentInstance.initialize(),thisInstance.registerFormSubmitEvent(thisInstance.currentInstance.getContainer()),thisInstance.currentInstance.registerEvents();}),e.preventDefault();});},back:function back(){var step=this.getStepValue(),prevStep=parseInt(step)-1;this.currentInstance.initialize();var container=this.currentInstance.getContainer(),workflowRecordElement=jQuery("[name=\"record\"]",container),workFlowId=workflowRecordElement.val();container.remove(),this.initiateStep(prevStep);var currentContainer=this.currentInstance.getContainer();currentContainer.show(),jQuery("[name=\"record\"]",currentContainer).val(workFlowId);var modulesList=jQuery("#moduleName",currentContainer);0<modulesList.length&&""!=workFlowId&&modulesList.attr("disabled","disabled").trigger("change");},/**
		 * Get popup with value
		 * @param container
		 */getPopUp:function getPopUp(container){var _this=this;"undefined"==typeof container&&(container=this.getContainer()),container.on("click",".getPopupUi",function(e){if(6==container.find("[name=\"execution_condition\"]").val())return !1;var fieldValueElement=jQuery(e.currentTarget),fieldValue=fieldValueElement.val(),fieldUiHolder=fieldValueElement.closest(".fieldUiHolder"),valueType=fieldUiHolder.find("[name=\"valuetype\"]").val();""===valueType&&(valueType="rawtext");var conditionsContainer=fieldValueElement.closest(".js-conditions-container"),conditionRow=fieldValueElement.closest(".js-conditions-row"),clonedPopupUi=conditionsContainer.find(".popupUi").clone(!0,!0).removeClass("popupUi").addClass("clonedPopupUi");clonedPopupUi.find("select").addClass("select2"),clonedPopupUi.find(".fieldValue").val(fieldValue);var value;if(fieldValueElement.hasClass("date")){clonedPopupUi.find(".textType").find("option[value=\"rawtext\"]").attr("data-ui","input");var dataFormat=fieldValueElement.data("date-format");value="rawtext"===valueType?fieldValueElement.val():"";var clonedDateElement="<input type=\"text\" class=\"dateField fieldValue col-md-4 form-control\" value=\""+value+"\" data-date-format=\""+dataFormat+"\" data-input=\"true\" >";clonedPopupUi.find(".fieldValueContainer").prepend(clonedDateElement);}else if(fieldValueElement.hasClass("time")){clonedPopupUi.find(".textType").find("option[value=\"rawtext\"]").attr("data-ui","input"),value="rawtext"===valueType?fieldValueElement.val():"";var clonedTimeElement="<input type=\"text\" class=\"timepicker-default fieldValue col-md-4 form-control\" value=\""+value+"\" data-input=\"true\" >";clonedPopupUi.find(".fieldValueContainer").prepend(clonedTimeElement);}else if(fieldValueElement.hasClass("boolean")){clonedPopupUi.find(".textType").find("option[value=\"rawtext\"]").attr("data-ui","input"),value="rawtext"===valueType?fieldValueElement.val():"";var clonedBooleanElement="<input type=\"checkbox\" class=\"fieldValue col-md-4 form-control\" value=\""+value+"\" data-input=\"true\" >";clonedPopupUi.find(".fieldValueContainer").prepend(clonedBooleanElement),"true:boolean"===value||""===value?clonedPopupUi.find(".fieldValueContainer input").attr("checked","checked"):clonedPopupUi.find(".fieldValueContainer input").removeAttr("checked");}conditionsContainer.find(".clonedPopUp").html(clonedPopupUi);var clonedPopupElement=$(".clonedPopUp",conditionsContainer).find(".clonedPopupUi");$(".clonedPopupUi",conditionsContainer).on("shown.bs.modal",function(){var data=$(".clonedPopupUi",conditionsContainer);data.find(".clonedPopupUi").removeClass("d-none");var moduleNameElement=conditionRow.find("[name=\"modulename\"]");if(0<moduleNameElement.length){var moduleName=moduleNameElement.val();data.find(".useFieldElement").addClass("d-none"),data.find("[name=\""+moduleName+"\"]").removeClass("d-none");}App.Fields.Picklist.changeSelectElementView(data),App.Fields.Date.register(data),app.registerEventForClockPicker(data),_this.postShowModalAction(data,valueType),_this.registerChangeFieldEvent(data),_this.registerSelectOptionEvent(data),_this.registerPopUpSaveEvent(data,fieldUiHolder),data.find(".fieldValue").filter(":visible").trigger("focus"),clonedPopupElement.find("[data-close-modal=\"modal\"], [data-dismiss=\"modal\"]").off("click").on("click",function(e){e.preventDefault(),e.stopPropagation(),$(this).closest(".modal").removeClass("in").css("display","none");});}),clonedPopupElement.modal();});},registerRemoveModalEvent:function registerRemoveModalEvent(data){data.on("click",".closeModal",function(){data.modal("hide");});},registerPopUpSaveEvent:function registerPopUpSaveEvent(data,fieldUiHolder){jQuery("[name=\"saveButton\"]",data).on("click",function(){var valueType=jQuery(".textType",data).val();fieldUiHolder.find("[name=\"valuetype\"]").val(valueType);var fieldValueElement=fieldUiHolder.find(".getPopupUi");"rawtext"==valueType?(fieldValueElement.addClass("validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]"),fieldValueElement.attr("data-validation-engine","validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]")):(fieldValueElement.removeAttr("data-validation-engine"),fieldValueElement.removeClass("validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]"));var fieldType=data.find(".fieldValue").filter(":visible").attr("type"),fieldValue=data.find(".fieldValue").filter(":visible").val();//For checkbox field type, handling fieldValue
"checkbox"==fieldType&&(data.find(".fieldValue").filter(":visible").is(":checked")?fieldValue="true:boolean":fieldValue="false:boolean"),fieldValueElement.val(fieldValue),fieldValueElement.validationEngine("hide"),data.remove();});},registerSelectOptionEvent:function registerSelectOptionEvent(data){$(".useField,.useFunction",data).on("change",function(e){var concatenatedValue,currentElement=$(e.currentTarget),newValue=currentElement.val(),oldValue=data.find(".fieldValue").filter(":visible").val();concatenatedValue=currentElement.hasClass("useField")?""==oldValue?newValue:oldValue+" "+newValue:oldValue+newValue,data.find(".fieldValue").val(concatenatedValue),currentElement.val("").trigger("change.select2");});},registerChangeFieldEvent:function registerChangeFieldEvent(data){jQuery(".textType",data).on("change",function(e){var valueType=jQuery(e.currentTarget).val(),useFieldContainer=jQuery(".useFieldContainer",data),useFunctionContainer=jQuery(".useFunctionContainer",data),uiType=jQuery(e.currentTarget).find("option:selected").data("ui");jQuery(".fieldValue",data).hide(),jQuery("[data-"+uiType+"]",data).show(),"fieldname"==valueType?(useFieldContainer.removeClass("d-none"),useFunctionContainer.addClass("d-none")):"expression"==valueType?(useFieldContainer.removeClass("d-none"),useFunctionContainer.removeClass("d-none")):(useFieldContainer.addClass("d-none"),useFunctionContainer.addClass("d-none")),jQuery(".helpmessagebox",data).addClass("d-none"),jQuery("#"+valueType+"_help",data).removeClass("d-none"),data.find(".fieldValue").val("");});},postShowModalAction:function postShowModalAction(data,valueType){"fieldname"==valueType?(jQuery(".useFieldContainer",data).removeClass("d-none"),jQuery(".textType",data).val(valueType).trigger("change")):"expression"==valueType&&(jQuery(".useFieldContainer",data).removeClass("d-none"),jQuery(".useFunctionContainer",data).removeClass("d-none"),jQuery(".textType",data).val(valueType).trigger("change")),jQuery("#"+valueType+"_help",data).removeClass("d-none");var uiType=jQuery(".textType",data).find("option:selected").data("ui");jQuery(".fieldValue",data).hide(),jQuery("[data-"+uiType+"]",data).show();},/*
		 * Function to register the click event for back step
		 */registerBackStepClickEvent:function registerBackStepClickEvent(){var thisInstance=this,container=this.getContainer();container.on("click",".backStep",function(){thisInstance.back();});},registerEvents:function registerEvents(){var form=this.currentInstance.getContainer();this.registerFormSubmitEvent(form),this.registerBackStepClickEvent();}});
//# sourceMappingURL=Edit.min.js.map
