'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";Vtiger_BasicSearch_Js("Vtiger_AdvanceSearch_Js",{//cache will store the search data
cache:{}},{//container which will store the search elements
elementContainer:!1,//instance which represents advance filter
advanceFilter:!1,//states whether the validation is registred for filter elements
filterValidationRegistered:!1,//contains the filter form element
filterForm:!1,//container which will store the parent elements
parentContainer:!1,/**
		 * Function which will give the container
		 */getContainer:function getContainer(){return this.elementContainer},/**
		 *Function which is used to set the continaer
		 *@params : container - element which represent the container
		 *@return current instance
		 */setContainer:function setContainer(container){return this.elementContainer=container,this},/**
		 * Function which will give the parent container
		 */getParentContainer:function getParentContainer(){return this.parentContainer},/**
		 *Function which is used to set the continaer
		 *@params : container - element which represent the container
		 *@return current instance
		 */setParentContainer:function setParentContainer(container){return this.setMainContainer(container),this.parentContainer=container,this},getFilterForm:function getFilterForm(){return $("form[name=\"advanceFilterForm\"]",this.getContainer())},/**
		 * Function used to get the advance search ui
		 * @return : deferred promise
		 */getAdvanceSearch:function getAdvanceSearch(){var aDeferred=$.Deferred(),searchModule=this.getSearchModule();//Exists in the cache
if(searchModule in Vtiger_AdvanceSearch_Js.cache)return aDeferred.resolve(Vtiger_AdvanceSearch_Js.cache[searchModule]),aDeferred.promise();var searchableModulesParams={module:app.getModuleName(),searchModule:searchModule,view:"BasicAjax",mode:"showAdvancedSearch"};app.getParentModuleName()&&(searchableModulesParams.parent=app.getParentModuleName());var progressInstance=$.progressIndicator();return AppConnector.request(searchableModulesParams).done(function(data){progressInstance.hide(),Vtiger_AdvanceSearch_Js.cache[searchModule]=data,aDeferred.resolve(data);}).fail(function(error){aDeferred.reject(error);}),aDeferred.promise()},/**
		 * Function which intializes search
		 */initiateSearch:function initiateSearch(){var aDeferred=$.Deferred(),thisInstance=this,postLoad=function(){thisInstance.setContainer($("#advanceSearchContainer")),thisInstance.filterValidationRegistered=!1,thisInstance.registerEvents(),thisInstance.advanceFilter=new Vtiger_ConditionBuilder_Js(thisInstance.getContainer().find(".js-condition-builder"),thisInstance.getSearchModule()),thisInstance.advanceFilter.registerEvents(),aDeferred.resolve();};return thisInstance.getAdvanceSearch().done(function(data){var params={};params.data=data,params.cb=postLoad,app.hideModalWindow(),app.showModalWindow(params);}).fail(function(){aDeferred.reject();}),aDeferred.promise()},/**
		 * Function which invokes search
		 */search:function search(){var conditionValues=this.advanceFilter.getConditions(),module=this.getSearchModule();return this._search({module:app.getModuleName(),searchModule:module,advfilterlist:JSON.stringify(conditionValues)})},/**
		 * Function which shows search results in proper manner
		 * @params : data to be shown
		 */showSearchResults:function showSearchResults(data){var aDeferred=$.Deferred(),postLoad=function postLoad(data){aDeferred.resolve(data);},jQhtml=$("<div class=\"row\"><span class=\"col-md-4 searchHolder\"></span><span class=\"col-md-8 filterHolder marginLeftZero d-none\"></span></div>");$(".searchHolder",jQhtml).html(data),data=jQhtml;var params={};return params.data=data,params.cb=postLoad,app.showModalWindow(params),aDeferred.promise()},/**
		 * Function which will save the filter
		 */saveFilter:function saveFilter(params){var aDeferred=$.Deferred();return params.source_module=this.getSearchModule(),params.status=1,params.advfilterlist=JSON.stringify(this.advanceFilter.getConditions()),params.module="CustomView",params.action="Save",AppConnector.request(params).done(function(data){if(!data.success){var params={title:app.vtranslate("JS_MESSAGE"),text:data.error.message,type:"error"};app.showNotify(params);}aDeferred.resolve(data);}),aDeferred.promise()},/**
		 * Function which will save the filter and show the list view of new custom view
		 */saveAndViewFilter:function saveAndViewFilter(params){this.saveFilter(params).done(function(response){var url=response.result.listviewurl;window.location.href=url;},function(error){});},/**
		 * Function which specify whether the search component and filter component both are shown
		 */isSearchAndFilterComponentsShown:function isSearchAndFilterComponentsShown(){var modalData=$("#"+Window.lastModalId),filterComponent=$(".filterHolder",modalData).find("#advanceSearchContainer");return !(0>=filterComponent.length)},/**
		 * Function which will perform search and other operaions
		 */performSearch:function performSearch(){var thisInstance=this,isSearchResultsAndFilterShown=this.isSearchAndFilterComponentsShown();this.search().done(function(data){thisInstance.setContainer(thisInstance.getContainer().detach()),thisInstance.showSearchResults(data).done(function(modalBlock){thisInstance.registerShowFiler(),isSearchResultsAndFilterShown&&thisInstance.showFilter();});});},/**
		 * Function which will show the advance filter next to search results
		 */showFilter:function showFilter(){var thisInstance=this,callback=function callback(){app.showModalWindow(thisInstance.getContainer());};app.hideModalWindow(callback);},/**
		 * Function which will perform the validation for the advance filter fields
		 * @return : deferred promise - resolves if validation succeded if not failure
		 */performValidation:function performValidation(){var thisInstance=this;this.formValidationDeferred=$.Deferred();var controlForm=this.getFilterForm(),validationDone=function validationDone(form,status){status?thisInstance.formValidationDeferred.resolve():thisInstance.formValidationDeferred.reject();};//To perform validation registration only once
return this.filterValidationRegistered||(this.filterValidationRegistered=!0,controlForm.validationEngine({onValidationComplete:validationDone})),controlForm.submit(),this.formValidationDeferred.promise()},/**
		 * Function which will register the show filer invocation
		 */registerShowFiler:function registerShowFiler(){var thisInstance=this;$("#showFilter").on("click",function(e){thisInstance.showFilter();});},/**
		 * Function which will register events
		 */registerEvents:function registerEvents(){var thisInstance=this,container=this.getContainer();//DO nothing on submit of filter form
//To set the search module with the currently selected values.
container.on("change","#searchModuleList",function(e){var selectElement=$(e.currentTarget),selectedModuleName=selectElement.val();thisInstance.setSearchModule(selectedModuleName),thisInstance.initiateSearch();}),$("#advanceSearchButton").on("click",function(e){var searchModule=thisInstance.getSearchModule();//If no module is selected
return 0>=searchModule.length?void app.getChosenElementFromSelect($("#searchModuleList")).validationEngine("showPrompt",app.vtranslate("JS_SELECT_MODULE"),"error","topRight",!0):void thisInstance.performValidation().done(function(){thisInstance.performSearch();}).fail(function(){})}),$("#advanceIntiateSave").on("click",function(e){var currentElement=$(e.currentTarget);currentElement.addClass("d-none");var actionsContainer=currentElement.closest(".actions");$(".js-name-filter",actionsContainer).removeClass("d-none").focus(),$("#advanceSave").removeClass("d-none");}),$("#advanceSave").on("click",function(e){var actionsContainer=$(e.currentTarget).closest(".actions"),filterNameField=$("input[name=\"viewname\"]",actionsContainer),value=filterNameField.val();if(0>=value.length)return void filterNameField.validationEngine("showPrompt",app.vtranslate("JS_REQUIRED_FIELD"),"error","topRight",!0);var searchModule=thisInstance.getSearchModule();//If no module is selected
return 0>=searchModule.length?void app.getChosenElementFromSelect($("#searchModuleList")).validationEngine("showPrompt",app.vtranslate("JS_SELECT_MODULE"),"error","topRight",!0):void thisInstance.performValidation().done(function(){var params={};params.viewname=value,thisInstance.saveAndViewFilter(params);})}),this.getFilterForm().on("submit",function(e){e.preventDefault();}),this.setSearchModule($("#searchModuleList").val());}});
//# sourceMappingURL=AdvanceSearch.min.js.map
