アプリケーションを走らせる
==========================

Yii のインストールが終ると、実際に動く Yii のアプリケーションにアクセスすることが出来ます。
その URL は、`https://hostname/basic/web/index.php` あるいは `https://hostname/index.php` など、設定によって異なります。
このセクションでは、アプリケーションに組み込み済みの機能を紹介し、コードがどのように編成されているか、
そして、一般にアプリケーションがリクエストをどのように処理するかを説明します。

> Info: 話を簡単にするために、この「始めよう」のチュートリアルを通じて、`basic/web`
  をウェブ・サーバのドキュメント・ルートとして設定したと仮定します。
  そして、アプリケーションにアクセスするための URL は `https://hostname/index.php` またはそれに似たものになるように設定したと仮定します。
  必要に応じて、説明の中の URL を読み替えてください。

フレームワークそのものとは異なり、プロジェクト・テンプレートはインストール後は完全にあなたのものであることに注意してください。
必要に応じてコードを追加したり削除したり、完全に書き換えたりするのはあなたの自由です。


機能 <span id="functionality"></span>
----

インストールされたベーシック・アプリケーションは四つのページを持っています。

* ホームページ: `https://hostname/index.php` の URL にアクセスすると表示されます。
* 「について」のページ。
* 「コンタクト」のページ: エンド・ユーザがメールであなたに連絡を取ることが出来るコンタクト・フォームが表示されます。
* 「ログイン」ページ: エンド・ユーザを認証するためのログイン・フォームが表示されます。
  "admin/admin" でログインしてみてください。「ログイン」のメイン・メニュー項目が「ログアウト」に変ることに気付くでしょう。

これらのページは共通のヘッダとフッタを持っています。
ヘッダには、異なるページ間を行き来することを可能にするメイン・メニュー・バーがあります。

ブラウザのウィンドウの下部にツールバーがあることにも気がつくはずです。
これは Yii によって提供される便利な [デバッグ・ツール](https://github.com/yiisoft/yii2-debug/blob/master/docs/guide-ja/README.md) であり、たくさんのデバッグ情報、例えば、ログ・メッセージ、レスポンスのステータス、実行されたデータベース・クエリなどを記録して表示するものです。

ウェブ・アプリケーションに加えて、`yii` というコンソール・スクリプトがアプリケーションのベース・ディレクトリにあります。
このスクリプトは、バックグラウンドのタスクまたはメンテナンスのタスクを実行するために使用することが出来ます。
これについては、[コンソール・アプリケーションのセクション](tutorial-console.md) で説明されています。


アプリケーションの構造 <span id="application-structure"></span>
----------------------

アプリケーションにとって最も重要なディレクトリとファイルは (アプリケーションのルート・ディレクトリが `basic` だと仮定すると) 以下の通りです。

```
basic/                  アプリケーションのベース・パス
    composer.json       Composer によって使用される。パッケージ情報を記述
    config/             アプリケーションその他の構成情報を格納
        console.php     コンソール・アプリケーションの構成情報
        web.php         ウェブ・アプリケーションの構成情報
    commands/           コンソール・コマンドのクラスを格納
    controllers/        コントローラのクラスを格納
    models/             モデルのクラスを格納
    runtime/            実行時に Yii によって生成されるファイル (ログやキャッシュなど) を格納
    vendor/             インストールされた Composer パッケージ (Yii フレームワークそのものを含む) を格納
    views/              ビュー・ファイルを格納
    web/                アプリケーションのウェブ・ルート。ウェブ・アクセス可能なファイルを格納
        assets/         Yii によって発行されるアセット・ファイル (javascript と CSS) を格納
        index.php       アプリケーションのエントリ・スクリプト (ブートストラップ・スクリプト)
    yii                 Yii コンソール・コマンド実行スクリプト
```

一般に、アプリケーションのファイルは二種類に分けることが出来ます。すなわち、`basic/web` の下にあるファイルとその他のディレクトリの下にあるファイルです。
前者は HTTP で (すなわちブラウザで) 直接にアクセスすることが出来ますが、後者は直接のアクセスは出来ませんし、許可すべきでもありません。

Yii は [モデル・ビュー・コントローラ (MVC)](https://wikipedia.org/wiki/Model-view-controller) アーキテクチャ・パターンを実装していますが、
それが上記のディレクトリ構成にも反映されています。
`models` ディレクトリが全ての [モデル・クラス](structure-models.md) を格納し、`views` ディレクトリが全ての [ビュー・スクリプト](structure-views.md) を格納し、
`controllers` ディレクトリが全ての [コントローラ・クラス](structure-controllers.md) を格納しています。

次の図がアプリケーションの静的な構造を示すものです。

![アプリケーションの静的な構造](images/application-structure.png)

各アプリケーションは一つのエントリ・スクリプト `web/index.php` を持ちます。
これはアプリケーション中で唯一ウェブ・アクセス可能な PHP スクリプトです。
エントリ・スクリプトは入力されたリクエストを受け取って、[アプリケーション](structure-applications.md) のインスタンスを作成します。
[アプリケーション](structure-applications.md) は [コンポーネント](concept-components.md) の助力を得てリクエストを解決し、リクエストを MVC に送付します。
[ウィジェット](structure-widgets.md) は、複雑で動的なユーザ・インタフェイス要素を構築するために、[ビュー](structure-views.md) の中で使われます。


リクエストのライフサイクル <span id="request-lifecycle"></span>
--------------------------

次の図は、アプリケーションがどのようにリクエストを処理するかを示すものです。

![リクエストのライフサイクル](images/request-lifecycle.png)

1. ユーザが [エントリ・スクリプト](structure-entry-scripts.md) `web/index.php` に対してリクエストを出します。
2. エントリ・スクリプトはアプリケーションの [構成情報](concept-configurations.md) を読み出して、
  リクエストを処理する [アプリケーション](structure-applications.md) のインスタンスを作成します。
3. アプリケーションは、[リクエスト](runtime-requests.md) アプリケーション・コンポーネントの助力を得て、
  リクエストされた [ルート](runtime-routing.md) を解決します。
4. アプリケーションがリクエストを処理する [コントローラ](structure-controllers.md) のインスタンスを作成します。
5. コントローラが [アクション](structure-controllers.md) のインスタンスを作成し、アクションのためのフィルタを実行します。
6. 一つでもフィルタが失敗したときは、アクションはキャンセルされます。
7. すべてのフィルタを通ったとき、アクションが実行されます。
8. アクションはデータ・モデルを、おそらくはデータベースから、読み出します。
9. アクションはデータ・モデルをビューに提供して、ビューをレンダリングします。
10. レンダリング結果が [レスポンス](runtime-responses.md) アプリケーション・コンポーネントに返されます。
11. レスポンス・コンポーネントがレンダリング結果をユーザのブラウザに送信します。

