Обработка ошибок
================

Если при обработке запроса к RESTful API в запросе пользователя обнаруживается ошибка или происходит 
что-то непредвиденное на сервере, вы можете просто выбрасывать исключение, чтобы уведомить пользователя о нештатной ситуации.
Если вы можете установить конкретную причину ошибки (например, запрошенный ресурс не существует), вам следует подумать
о том, чтобы выбрасывать исключение с соответствующим кодом состояния HTTP (например, [[yii\web\NotFoundHttpException]],
соответствующее коду состояния 404). Yii отправит ответ с соответствующим 
HTTP-кодом и текстом. Он также включит в тело ответа сериализованное представление 
исключения. Например:

```
HTTP/1.1 404 Not Found
Date: Sun, 02 Mar 2014 05:31:43 GMT
Server: Apache/2.2.26 (Unix) DAV/2 PHP/5.4.20 mod_ssl/2.2.26 OpenSSL/0.9.8y
Transfer-Encoding: chunked
Content-Type: application/json; charset=UTF-8

{
    "name": "Not Found Exception",
    "message": "The requested resource was not found.",
    "code": 0,
    "status": 404
}
```

Сводный список кодов состояния HTTP, используемых REST-фреймворком Yii:

* `200`: OK. Все сработало именно так, как и ожидалось.
* `201`: Ресурс был успешно создан в ответ на `POST`-запрос. Заголовок `Location`
   содержит URL, указывающий на только что созданный ресурс.
* `204`: Запрос обработан успешно, и в ответе нет содержимого (для запроса `DELETE`, например).
* `304`: Ресурс не изменялся. Можно использовать закэшированную версию.
* `400`: Неверный запрос. Может быть связано с разнообразными проблемами на стороне пользователя, такими как неверные JSON-данные
   в теле запроса, неправильные параметры действия, и т.д.
* `401`: Аутентификация завершилась неудачно.
* `403`: Аутентифицированному пользователю не разрешен доступ к указанной точке входа API.
* `404`: Запрошенный ресурс не существует.
* `405`: Метод не поддерживается. Сверьтесь со списком поддерживаемых HTTP-методов в заголовке `Allow`.
* `415`: Не поддерживаемый тип данных. Запрашивается неправильный тип данных или номер версии.
* `422`: Проверка данных завершилась неудачно (в ответе на `POST`-запрос, например). Подробные сообщения об ошибках смотрите в теле ответа.
* `429`: Слишком много запросов. Запрос отклонен из-за превышения ограничения частоты запросов.
* `500`: Внутренняя ошибка сервера. Возможная причина — ошибки в самой программе.

## Свой формат ответа с ошибкой <span id="customizing-error-response"></span>

Вам может понадобиться изменить формат ответа с ошибкой. Например, вместо использования разных статусов ответа HTTP
для разных ошибок, вы можете всегда отдавать статус 200, а реальный код статуса отдавать как часть JSON ответа:

```
HTTP/1.1 200 OK
Date: Sun, 02 Mar 2014 05:31:43 GMT
Server: Apache/2.2.26 (Unix) DAV/2 PHP/5.4.20 mod_ssl/2.2.26 OpenSSL/0.9.8y
Transfer-Encoding: chunked
Content-Type: application/json; charset=UTF-8

{
    "success": false,
    "data": {
        "name": "Not Found Exception",
        "message": "The requested resource was not found.",
        "code": 0,
        "status": 404
    }
}
```

Для этого можно использовать событие `beforeSend` компонента `response` прямо в конфигурации приложения:

```php
return [
    // ...
    'components' => [
        'response' => [
            'class' => 'yii\web\Response',
            'on beforeSend' => function ($event) {
                $response = $event->sender;
                if ($response->data !== null && !empty(Yii::$app->request->get('suppress_response_code'))) {
                    $response->data = [
                        'success' => $response->isSuccessful,
                        'data' => $response->data,
                    ];
                    $response->statusCode = 200;
                }
            },
        ],
    ],
];
```

Приведённый выше код изменит формат ответа (как для удачного запроса, так и для ошибок) если передан `GET`-параметр
`suppress_response_code`.
