Сортировка
=======

Иногда выводимые данные требуется отсортировать в соответствии с одним или несколькими атрибутами. 
Если вы используете [провайдер данных](output-data-providers.md) с одним из [виджетов данных](output-data-widgets.md), 
сортировка будет применена автоматически. В противном случае вы должны создать экземпляр [[yii\data\Sort]], 
настроить его и применить к запросу. Он также может быть передан в представление, где будет использован 
для создания ссылок на сортировку по определенным атрибутам.

Ниже приведен типичный пример использование сортировки,

```php
function actionIndex()
{
    $sort = new Sort([
        'attributes' => [
            'age',
            'name' => [
                'asc' => ['first_name' => SORT_ASC, 'last_name' => SORT_ASC],
                'desc' => ['first_name' => SORT_DESC, 'last_name' => SORT_DESC],
                'default' => SORT_DESC,
                'label' => 'Name',
            ],
        ],
    ]);

    $models = Article::find()
        ->where(['status' => 1])
        ->orderBy($sort->orders)
        ->all();

    return $this->render('index', [
         'models' => $models,
         'sort' => $sort,
    ]);
}
```

В представлении:

```php
// Отображение ссылок на различные действия сортировок
echo $sort->link('name') . ' | ' . $sort->link('age');

foreach ($models as $model) {
    // здесь отображаем модель $model
}
```

В примере выше, мы объявляем два атрибута, которые поддерживают сортировку: `name` и `age`.
Мы передаем информацию о сортировке в запрос статьи, поэтому результаты запроса будут отсортированы 
согласно сортировке, установленной в объекте Sort. В представлении, мы отображаем две ссылки, 
которые ведут на страницы с данными, отсортированными по соответствующим атрибутам.

Класс [[yii\data\Sort|Sort]] будет автоматически принимать параметры, переданные с запросом 
и в соответствии с ними настраивать параметры сортировки. Вы можете регулировать список принимаемых 
параметров через настройку свойства  [[yii\data\Sort::$params|$params]].
