Псевдоніми
==========

Псевдоніми використовуються для представлення шляхів до файлів або URL адрес 
і допомагають уникнути використання абсолютних шляхів або URL у коді. 
Для того, щоб не переплутати псевдонім із звичайним шляхом до файлу або URL, 
він повинен починатися із символу `@`. Якщо псевдонім не починається із
символу `@` - його буде додано автоматично.

В Yii є багато заздалегідь визначених псевдонімів. Наприклад, 
`@yii` вказує на директорію, в яку був встановлений  Yii framework, 
а `@web` можна використовувати для отримання базового URL поточного додатку.
 
Створення псевдонімів <span id="defining-aliases"></span>
---------------------

Для створення псевдоніма шляху до файлу або URL використовується метод [[Yii::setAlias()]]:

```php
// псевдонім шляху до файлу
Yii::setAlias('@foo', '/path/to/foo');

// псевдонім URL
Yii::setAlias('@bar', 'https://www.example.com');
```

> Note: псевдонім шляху до файлу або URL *не* обовʼязково вказує на наявний файл або ресурс.

Використовуючи вже заданий псевдонім, ви можете отримати на основі нього новий (без виклику [[Yii::setAlias()]]),
додавши в його кінець `/`, за яким слідує один або більше сегментів шляху. Псевдоніми, визначені за допомогою
[[Yii::setAlias()]], є *кореневими псевдонімами*, в той час як отримані з них називаються *похідними псевдонімами*.
На приклад, `@foo` є кореневим псевдонімом, а `@foo/bar/file.php` — похідним.

Ви можете задати новий псевдонім, використовуючи раніше створений псевдонім (не важливо, кореневий він чи похідний):

```php
Yii::setAlias('@foobar', '@foo/bar');
```

Кореневі псевдоніми, як правило, створюються на етапі [попереднього завантаження (bootstrapping)](runtime-bootstrapping.md).
Наприклад, ви можете викликати [[Yii::setAlias()]] у [вхідному скрипті](structure-entry-scripts.md). Для зручності, в
[додатку (Application)](structure-applications.md) передбачено властивість `aliases`, яке можна задати через
[конфігурацію додатку](concept-configurations.md):

```php
return [
    // ...
    'aliases' => [
        '@foo' => '/path/to/foo',
        '@bar' => 'https://www.example.com',
    ],
];
```


Перетворення псевдонімів <span id="resolving-aliases"></span>
------------------------

Виклик [[Yii::getAlias()]] перетворює кореневий псевдонім в шлях до файлу або URL, який цей псевдонім представляє.
Цей же метод може працювати і з похідними псевдонімами:

```php
echo Yii::getAlias('@foo');               // виведе: /path/to/foo
echo Yii::getAlias('@bar');               // виведе: https://www.example.com
echo Yii::getAlias('@foo/bar/file.php');  // виведе: /path/to/foo/bar/file.php
```

Шлях або URL, представлений похідним псевдонімом, визначається шляхом заміни в ньому частині, що відповідає кореневого псевдоніму, 
на відповідний йому шлях або URL.

> Note: Метод [[Yii::getAlias()]] не перевіряє фактичного існування одержуваного шляху або URL.

Кореневий псевдонім може містити знаки `/`. При цьому метод [[Yii::getAlias()]] коректно визначить, яка частина 
псевдоніма є кореневої і вірно сформує шлях або URL:

```php
Yii::setAlias('@foo', '/path/to/foo');
Yii::setAlias('@foo/bar', '/path2/bar');
Yii::getAlias('@foo/test/file.php');  // виведе: /path/to/foo/test/file.php
Yii::getAlias('@foo/bar/file.php');   // виведе: /path2/bar/file.php
```

Якби `@foo/bar` не був оголошений кореневим псевдонімом, остання строка вивела б `/path/to/foo/bar/file.php`.


Використання псевдонімів <span id="using-aliases"></span>
------------------------

Псевдоніми розпізнаються в багатьох частинах Yii без необхідності попереднього виклику [[Yii::getAlias()]]
для отримання шляху або URL. Наприклад, [[yii\caching\FileCache::cachePath]] приймає як звичайний шлях до файлу, 
так і псевдонім шляху завдяки префіксу `@`, який дозволяє їх розрізняти.

```php
use yii\caching\FileCache;

$cache = new FileCache([
    'cachePath' => '@runtime/cache',
]);
```

Для того, щоб дізнатися чи підтримує метод або властивість псевдоніми, зверніться до документації API.


Заздалегідь визначені псевдоніми <span id="predefined-aliases"></span>
--------------------------------

В Yii заздалегідь визначені псевдоніми для часто використовуваних шляхів до файлів і URL:

- `@yii`: директорія, в якій знаходиться файл `BaseYii.php` (директорія фреймворку).
- `@app`: [[yii\base\Application::basePath|базовий шлях]] поточного додатку.
- `@runtime`: [[yii\base\Application::runtimePath|директорія runtime]] поточного додатку. За замовчуванням `@app/runtime`.
- `@webroot`, коренева веб-директорія поточного веб-додатку. Визначається на основі директорії розташування [вхідного скрипта](structure-entry-scripts.md).
- `@web`, базовий URL поточного додатку. Має таке ж значення, як і [[yii\web\Request::baseUrl]].
- `@vendor`, [[yii\base\Application::vendorPath|директорія vendor Composer]]. За замовчуванням `@app/vendor`.
- `@bower`, директорія, що містить [пакунки Bower](https://bower.io/). За замовчуванням `@vendor/bower`.
- `@npm`, директорія, що містить [пакунки NPM](https://www.npmjs.com/). За замовчуванням `@vendor/npm`.

Псевдонім `@yii` задається в момент підключення файлу `Yii.php` у [вхідному скрипті](structure-entry-scripts.md).
Решта псевдонімів задаються в конструкторі додатка в момент застосування [конфигурації](concept-configurations.md).


Псевдоніми розширень <span id="extension-aliases"></span>
--------------------

Для кожного [розширення](structure-extensions.md), що встановлюється через Composer, автоматично задається псевдонім. 
Його імʼя відповідає кореневому простору імен розширення відповідно до його `composer.json`, і кожен псевдонім представляє 
шлях до кореневої директорії пакунка. Наприклад, якщо ви встановите розширення `yiisoft/yii2-jui`, 
то вам автоматично стане доступним псевдонім `@yii/jui`, який будет створено на етапі 
[первинного завантаження (bootstrapping)](runtime-bootstrapping.md) наступним чином:

```php
Yii::setAlias('@yii/jui', 'VendorPath/yiisoft/yii2-jui');
```
