Встановлення Yii
================

Ви можете встановити Yii двома шляхами: використовуючи менеджер пакунків [Composer](https://getcomposer.org/) або завантаживши файл архіву.
Перший варіант є бажанішим, тому що дозволяє встановлювати нові [розширення](structure-extensions.md) або оновлювати Yii простим виконанням однієї команди.

Після стандартного встановлення Yii ми отримуємо як фреймворк, так і шаблон проекту. Шаблон проекту - це робочий проект Yii,
в якому реалізовано деякий базовий функціонал, такий як система входу/виходу користувачів, форма зворотнього зв’язку і т. д.
Його код організовано в рекомендований спосіб. Таким чином, це може слугувати гарною відправною точкою для ваших проектів.

У цьому та у наступних кількох розділах буде описано, як встановити Yii з так званим *Базовим шаблоном проекту* та
як реалізувати нові можливості на базі цього шаблону. Також Yii надає інший шаблон із назвою
[Розширений шаблон проекту](https://github.com/yiisoft/yii2-app-advanced/blob/master/docs/guide-uk/README.md), який краще використовувати у середовищі розробки в команді
для розробки складних додатків.

> Info: Базовий шаблон проекту підходить для розробки 90 відсотків веб-додатків. Він відрізняється
  від Розширеного шаблону проекту в основному організацією коду. Якщо ви малознайомі з Yii, наполегливо
  рекомендується використовувати Базовий шаблон проекту із-за його простоти, але й достатньої функціональності.


Встановлення за допомогою Composer <span id="installing-via-composer"></span>
----------------------------------

Якщо у вас все ще не встановлено Composer, то це можна зробити за допомогою інструкції на
[getcomposer.org](https://getcomposer.org/download/). Користувачам Linux та Mac OS X потрібно виконати наступні команди:

```bash
    curl -sS https://getcomposer.org/installer | php
    mv composer.phar /usr/local/bin/composer
```

При роботі з Windows, необхідно завантажити та запустити [Composer-Setup.exe](https://getcomposer.org/Composer-Setup.exe).

В разі наявності проблем або якщо вам необхідна додаткова інформація,
зверніться до [документації Composer](https://getcomposer.org/doc/).

Якщо ж Composer вже було встановлено раніше, переконайтесь, що використовуєте його останню версію.
Ви можете оновити Composer простою командою `composer self-update`.

Після встановлення Composer, встановити Yii можна виконавши наступну команду з директорії, яка доступна через Web:

```bash
    composer global require "fxp/composer-asset-plugin:^1.4.1"
    composer create-project --prefer-dist yiisoft/yii2-app-basic basic
```

Перша команда встановить [плагін ресурсів composer (composer-asset-plugin)](https://github.com/fxpio/composer-asset-plugin),
що дозволить керувати залежностями пакунків Bower та NPM за допомогою Composer. Цю команду потрібно виконати лише
один раз. Друга команда встановить Yii у директорію під назвою `basic`. За бажанням, ви можете обрати інше ім’я для директорії.

> Note: Під час встановлення може статися так, що Composer запитає облікові дані від вашого профілю на GitHub,
через встановлені обмеження запитів GitHub API. Це є нормальним, оскільки Composer повинен отримати багато інформації
для всіх пакунків із GitHub. Надання облікових даних профілю GitHub збільшить кількість запитів до API, потрібних для
подальшої роботи Composer. Для більш детальної інформації, будь ласка, зверніться до
[документації Composer](https://getcomposer.org/doc/articles/troubleshooting.md#api-rate-limit-and-oauth-tokens).


> Tip: Якщо ви хочете встановити останню нестабільну версію Yii, ви можете виконати наступну команду,
яка додає опцію [stability](https://getcomposer.org/doc/04-schema.md#minimum-stability):
```bash
    composer create-project --prefer-dist --stability=dev yiisoft/yii2-app-basic basic
```
Варто зауважити, що нестабільну версію Yii не можна використовувати на робочому сервері, оскільки вона може порушити
виконання робочого коду.


Встановлення з архіву <span id="installing-from-archive-file"></span>
---------------------

Встановлення Yii з архіву складається з трьох кроків:

1. Завантажте архів за адресою [yiiframework.com](https://www.yiiframework.com/download/);
2. Розпакуйте архів в директорію, доступну через Web.
3. Відредагуйте файл конфігурації `config/web.php` - необхідно ввести таємний ключ до пункту `cookieValidationKey`
   (це виконується автоматично при вставленні Yii через Composer):

   ```php
   // !!! встановити таємний ключ до наступного пункту (якщо порожній) - це необхідно для перевірки кукі
   'cookieValidationKey' => 'enter your secret key here',
   ```


Інші параметри встановлення <span id="other-installation-options"></span>
---------------------------

Вище наведені інструкції показують як встановити Yii та створити базовий веб-додаток, який працює "з коробки".
Цей підхід є гарною відправною точкою для більшості проектів, як малих так і великих. Це особливо підходить для тих, хто тільки
розпочинає вивчати Yii.

Але є ще й інші варіанти встановлення:

* Якщо вам потрібен тільки один фреймворк і ви хотіли б створити додаток з нуля, використовуйте інструкцію, 
  що описана у розділі [Створення додатка з нуля](tutorial-start-from-scratch.md).
* Якщо ви хочете розпочати з більш складного додатка, який краще підходить для роботи в команді, використовуйте
  [Розширений шаблон проекту](https://github.com/yiisoft/yii2-app-advanced/blob/master/docs/guide-uk/README.md).


Перевірка встановлення <span id="verifying-installation"></span>
----------------------

Після успішного встановлення ви можете налаштувати свій веб-сервер (див. наступний розділ)
або використати [вбудований веб-сервер PHP](https://www.php.net/manual/en/features.commandline.webserver.php),
виконавши наступну консольну команду із директорії `web`:

```bash
php yii serve
```

> Note: За замовчуванням, HTTP-server буде прослуховувати порт 8080. Проте, 
якщо цей порт вже використовується, або ви бажаєте таким чинов використовувати 
кілька додатків одразу - ви можете встановити, який саме порт використовувати.
Тільки додайтие аргумент --port:

```bash
php yii serve --port=8888
```

Тепер ви можете використати свій браузер для доступу до встановленого Yii додатку
за наступним посиланням:

```
http://localhost:8080/
```

![Успішно встановлений Yii](images/start-app-installed.png)

Ви повинні побачити сторінку із привітанням "Congratulations!" у вашому браузері. Якщо ж ні, будь ласка, перевірте, чи задовольняють
налаштування PHP вимоги Yii. Це можна зробити одним із наведених способів:

* Скопіюйте файл `/requirements.php` до `/web/requirements.php` та використайте браузер для доступу до URL `http://localhost/requirements.php`
* Виконайте наступні команди в консолі: 

  ```bash
  cd basic
  php requirements.php
  ```

Необхідно налаштувати PHP таким чином, щоб він відповідав мінімальним вимогам Yii. Основна вимога — PHP версії 5.4 або вище.
Якщо ваш додаток працює з базою даних, необхідно встановити [розширення PHP PDO](https://www.php.net/manual/en/pdo.installation.php)
та відповідний драйвер (наприклад, `pdo_mysql` для MySQL).


Налаштування веб-серверів <span id="configuring-web-servers"></span>
-------------------------

> Info: можете пропустити даний підрозділ, якщо ви тільки розпочали знайомитися з фреймворком
  і не розгортаєте його на робочому сервері.

Додаток, встановлений за інструкціями, наведеними вище, буде працювати одразу як
з [Apache HTTP server](https://httpd.apache.org/), так і з [Nginx HTTP server](https://nginx.org/) на
Windows, Mac OS X чи Linux із встановленим PHP 5.4 або вище. Yii 2.0 також сумісний із віртуальною машиною Фейсбука
[HHVM](https://hhvm.com/), однак є деякі крайні випадки, де HHVM поводиться інакше,
ніж рідний PHP, тому ви повинні бути дуже уважними при використанні HHVM.  

На робочому сервері вам напевно захочеться змінити URL додатку з `https://www.example.com/basic/web/index.php`
на `https://www.example.com/index.php`. Для цього необхідно змінити кореневу директорію в налаштуваннях веб-сервера на `basic/web`.
Додатково можна сховати `index.php` із URL, як це описано у розділі [Маршрутизація та створення URL](runtime-routing.md). 
Далі буде описано як налаштувати Apache або Nginx для цих цілей.

> Info: Встановлюючи `basic/web` кореневою директорією веб-сервера, ви забороняєте кінцевим користувачам доступ
  до приватного коду додатка та важливих даних, які знаходяться на одному рівні
  з `basic/web`. Це робить додаток більш захищеним.

> Info: Якщо додаток працює на хостингу, де немає доступу
  до налаштувань сервера, ви все ще можете змінити структуру додатка для покращення безпеки,
  як описано в розділі [Робота на віртуальному хостингу](tutorial-shared-hosting.md).


### Рекомендовані налаштування Apache <span id="recommended-apache-configuration"></span>

Додайте наступний код до файлу конфігурації `httpd.conf` веб-сервера Apache або в конфігурацію віртуального хоста. 
Не забудьте замінити `path/to/basic/web` на коректний шлях до `basic/web`.

```
# Встановлюємо кореневою директорією "basic/web"
DocumentRoot "path/to/basic/web"

<Directory "path/to/basic/web">
    # використаємо mod_rewrite для підтримки гарних URL
    RewriteEngine on
    # Якщо запитуваний файл або директорія існують - звертаємось до них напряму
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    # Якщо ні - перенаправляємо запит на index.php
    RewriteRule . index.php

    # ...інші налаштування...
</Directory>
```


### Рекомендовані налаштування Nginx <span id="recommended-nginx-configuration"></span>

Для використання [Nginx](https://wiki.nginx.org/) вам потрібно встановити PHP як [FPM SAPI](https://www.php.net/install.fpm).
Використовуйте наступні параметри Nginx, замінивши `path/to/basic/web` на коректний шлях до
`basic/web`, а `mysite.test` на актуальний домен.

```
server {
    charset utf-8;
    client_max_body_size 128M;

    listen 80; ## "слухаємо порт" для ipv4
    #listen [::]:80 default_server ipv6only=on; ## "слухаємо порт" для ipv6

    server_name mysite.test;
    root        /path/to/basic/web;
    index       index.php;

    access_log  /path/to/basic/log/access.log;
    error_log   /path/to/basic/log/error.log;

    location / {
        # Перенаправляємо всі запити на index.php, якщо це не наявна директорія або файл
        try_files $uri $uri/ /index.php?$args;
    }

    # розкоментуйте рядки нижче для запобігання обробки звернень Yii до не наявних статичних файлів
    #location ~ \.(js|css|png|jpg|gif|swf|ico|pdf|mov|fla|zip|rar)$ {
    #    try_files $uri =404;
    #}
    #error_page 404 /404.html;

    location ~ \.php$ {
        include fastcgi.conf;
        fastcgi_pass   127.0.0.1:9000;
        #fastcgi_pass unix:/var/run/php5-fpm.sock;
        try_files $uri =404;
    }

    location ~ /\.(ht|svn|git) {
        deny all;
    }
}
```

Використовуючи дану конфігурацію встановіть `cgi.fix_pathinfo=0` у файлі `php.ini`,
щоб запобігти зайвим системним викликам `stat()`.

Врахуйте також, що при використанні HTTPS необхідно задавати `fastcgi_param HTTPS on;` щоб Yii
міг коректно визначати захищене з’єднання.
