Как работать над переводом на русский
=====================================

Yii переводится на множество языков, в том числе и на русский. Перевод включает в себя документацию и сообщения.

Сообщения фреймворка
--------------------

Есть два типа сообщений: исключения, которые нацелены на разработчиков и не переводятся, и сообщения, которые показываются
пользователям. Например, ошибки валидации.

Для того, чтобы обновить перевод:

1. Открываем в консоли директорию `framework`, запускаем `./yii message/extract @yii/messages/config.php --languages=ru`.
3. Переводим сообщения в `framework/messages/ru/yii.php`. Важно чтобы файлы были в кодировке UTF-8.
4. [Делаем pull request](https://github.com/yiisoft/yii2/blob/master/docs/internals-ru/git-workflow.md) с переводом из `ru`,
остальные языки не трогаем.

В файле перевода находится массив. Его ключи — исходные строки, значения — перевод. Если значение пусто, сообщение
считается не переведённым. Переводы сообщений, которые больше не встречаются в коде, обрамлены `@@`. Для некоторых сообщений
необходимо использовать [специальный формат для поддержки употребления с числительными](../guide-ru/tutorial-i18n.md).

Документация
------------

Перевод документации находится в `docs/<original>-ru`, где `<original>` соответствует оригинальной директории, например
`guide` или `internals`.

Если перевод документа завершён, можно получить diff изменений в оригинале со времени последнего перевода, открыв консоль
в директории `build` и выполнив:

```
php build translation "../docs/guide" "../docs/guide-ru" "Russian guide translation report" > report_guide_ru.html
```

Если ругается на composer, выполните `composer install` в корневой директории.

Информацию о синтаксисе и стиле документации можно найти в [documentation_style_guide.md](../documentation_style_guide.md).

Перед тем, как начать перевод, убедитесь, что никто им ещё не занимается и запишите себя в
[список всех переводимых документов](https://docs.google.com/spreadsheets/d/1uxV0LwmR-8XXqlT8C6VqWllZjuoyIj-UkYpAQPWyUzE/edit?usp=sharing).

Все изменения оформляем в виде [pull request](https://github.com/yiisoft/yii2/blob/master/docs/internals-ru/git-workflow.md).


### Общие правила

- Многие термины не имеют однозначного и широко распространенного перевода на русский язык, поэтому, если в тексте
  встречается такой термин, в скобках возле первого упоминания необходимо указать английский вариант; (список используемых
  вариантов перевода терминов см. ниже); 
- Если кажется, что при переводе какая-то часть текста теряет смысл и вы не уверены в том, как ее правильно перевести,
  заключайте эту часть текста в * (внешне шрифт станет наклонным). Это позволит при вычитке/корректуре обратить на эту
  часть текста особое внимание; 
- При переводе избегайте фактических ошибок! 
- В тексте встречаются ссылки на внешние источники, если ссылка ведет на статью, определение термина и т.п., то при
  наличии русского варианта на этом же ресурсе или ином авторитетном ресурсе, даем ссылку на русский вариант.
  Например `https://en.wikipedia.org/wiki/Captcha` → `https://ru.wikipedia.org/wiki/Captcha`. 
- Комментарии в коде переводятся, если не искажают первоначального смысла; временные комментарии в тексте желательно
  использовать только локально! иначе есть вероятность попадания в релиз; 
- При переводе названий разделов придерживаемся перевода в `README.md`; 
- Добавление собственных комментариев-дополнений возможно, но не приветствуется поскольку во избежание хаоса оригинал
  должен быть один. В случае такой необходимости в конце комментария нужно добавить "(прим. пер.)"; 
- После проведения общей правки документа настоятельно рекомендуется самостоятельно вносить исправления только
  грамматических, а также фактических ошибок, имеющих отношение только к данному разделу. В остальных случаях необходимо
  вынести предложение по исправлению, улучшению на обсуждение и в случае необходимости централизованно внести коррективы
  во все разделы документа.
   

### Структура документа

При переводе необходимо правильно именовать структурные единицы документы. Следуем структуре, приведенной ниже:

- Глава 1 
  - Раздел 1 
  - Раздел 2 
    - Подраздел 1 
  - ... 
  - Раздел N 
- Глава 2 
- ... 
- Глава N
 
### Перевод специальных сообщений

Специальные сообщения `Tip:`, `Note:`, `Info:`, `Warning:` не переводятся.

### Перевод рисунков

Рисунки к документации содержатся в подпапке `images`. Все они созданы в [yED](https://www.yworks.com/en/products_yed_about.html).
При необходимости перевода исходный файл копируется в директорию `images` перевода, переводится и сохраняется в формате png.

Подписи к рисункам переводятся.

### Грамматика


Обращайте внимание на общую стилистику, орфографию и пунктуацию, перед заливкой конечного варианта перевод можно прогнать
через любую программу с встроенной проверкой, например, Microsoft Word;

### Список терминов

- action — действие. 
- active record — без перевода. 
- attach handler — «назначить обработчик». 
- attribute of the model — атрибут модели.
- cache — кэш.
- camel case — без перевода. 
- customization — (тонкая) настройка //Ранее встречался перевод "кастомизация", желательно этот вариант по возможности не использовать. 
- column — столбец (если речь про БД).
- configuration — конфигурация.  
- content — содержимое. 
- controller — контроллер. 
- debug (mode) — отладочный (режим) (см. production mode). 
- eager loading — метод жадной загрузки/жадная загрузка (см. lazy loading).
- environment — окружение.
- PHP extension — расширение PHP. 
- field (of the table) — поле (или атрибут) таблицы. 
- framework — фреймворк. 
- front-controller — фронт-контроллер. 
- getter — геттер. 
- (event) handler — обработчик (события). 
- hash — хэш. 
- helper - помощник. 
- id — идентификатор. 
- instance — экземпляр. 
- junction table — промежуточная таблица.
- lazy loading — отложенная загрузка (загрузим как понадобится и не раньше). 
- method — метод (объекта) //Внимание! У объекта/класса нет функций, есть только методы. 
- model — модель, модель данных. 
- model form — модель формы. 
- parameter — параметр (у метода или функции, никак не у класса). 
- to parse — обрабатывать, если контекст непонятен — парсить. 
- placeholder — маркер. 
- production (mode) — производственный (режим) (см. debug mode). 
- property — свойство (объекта). 
- to render — рендерить, формировать. 
- related, relation — связанный, связь.
- resolve request — предварительная обработка запроса. 
- route — маршрут. 
- row (of the table) — строка (таблицы). 
- setter — сеттер. 
- tabular input — табличный ввод. 
- to validate — проверять. 
- valid — корректный. 
- validator — валидатор. 
- validator class — класс валидатора. 
- view — представление.
- query builder — конструктор запросов.
- time zone — часовой пояс.
- to trigger — инициализировать
- event — событие
- to implement (class implements interface) — реализовывать (класс реализует интерфейс)
