Робота з Git для учасників Yii 2
================================

Ви бажаєте взяти участь в розробці Yii? Чудово! Але, щоб підвищити шанси швидкого прийняття ваших змін, будь ласка,
дотримуйтесь наступних кроків. Якщо ви новачок у Git та GitHub, спершу можете ознайомитись із
[довідкою GitHub](https://help.github.com/), [тренером Git](https://try.github.com), [інтерактивним туром Git How To](https://githowto.com/)
або почитати книгу [Магія Git](https://www-cs-students.stanford.edu/~blynn/gitmagic/intl/uk/)
чи [Розділ Git у Вікіпідручнику](https://uk.wikibooks.org/wiki/Git), щоб краще зрозуміти внутрішню структуру Git.

Підготовка вашого середовища розробки
-------------------------------------

Наступні кроки створять середовище розробки для Yii, яке ви зможете використовувати для роботи
над основним кодом фреймворку Yii. Ці кроки необхідні лише тоді, коли ви вперше долучаєтесь до співпраці.

### 1. [Створіть форк](https://help.github.com/fork-a-repo/) репозиторію Yii на GitHub та клонуйте свій форк у своє середовище розробки

```
git clone git@github.com:ВАШЕ-ІМ’Я-НА-GITHUB/yii2.git
```

Якщо у вас виникли проблеми із роботою Git з GitHub в Linux, або ви отримали помилку заборони доступу "Permission Denied (publickey)",
то вам необхідно [налаштувати Git для роботи з GitHub](https://help.github.com/articles/set-up-git/#platform-linux).

### 2. Додайте головний репозиторій Yii як додатковий віддалений репозиторій із назвою "upstream"

Перейдіть у директорію, в яку ви клонували Yii, зазвичай "yii2". Потім виконайте наведену команду:

```
git remote add upstream https://github.com/yiisoft/yii2.git
```

### 3. Підготуйте середовище тестування

Наступні кроки не обов'язкові, якщо ви хочете працювати лише над перекладом або документацією.

- виконайте `composer update` для встановлення залежностей (припускається, що ви маєте [глобально встановлений composer](https://getcomposer.org/doc/00-intro.md#globally)).
- виконайте `php build/build dev/app basic` для клонування базового додатку та встановлення його залежностей.
  Ця команда встановить сторонні пакунки composer як завжди, а також створить посилання з репозиторію yii2
  на поточний репозиторій. Таким чином ви будете мати один екземпляр встановленого коду.

Якщо необхідно, зробіть те ж саме для розширеного додатку: `php build/build dev/app advanced`.

Ця команда може використовуватись для оновлення залежностей, вона викликає `composer update` в процесі виконання.

**Тепер ви маєте робочий майданчик для експериментів з Yii 2.**

Наступні кроки не обов’язкові.

### Модульні тести

Ви можете виконати модульні тести, запустивши `phpunit` у кореневій директорії репозиторію. Якщо у вас phpunit не встановлений глобально,
ви можете запускати `php vendor/bin/phpunit`.

Деякі тести потребують додатково встановлення та налаштування баз даних. Ви можете створити `tests/data/config.local.php` для перевизначення
налаштувань сконфігурованих у `tests/data/config.php`.

Можливо обмежити тести групою тестів, що покривають область над якою ви працюєте, наприклад, щоб запустити тести для валідаторів
та redis, виконайте `phpunit --group=validators,redis`. Для отримання списку доступних груп виконайте `phpunit --list-groups`.

### Розширення

Для роботи з розширеннями необхідно клонувати відповідні репозиторії. Наступна команда зробить це для вас:

```
php build/build dev/ext <extension-name>
```

де `<extension-name>` є назвою розширення, наприклад `redis`.

Якщо бажаєте протестувати розширення в одному із шаблонів додатку, просто додайте його до `composer.json` додатку, як ви будете
робити зазвичай. Наприклад, додайте `"yiisoft/yii2-redis": "~2.0.0"` до секції `require` базового додатку.
Команда `php build/build dev/app basic` встановить розширення та його залежності й створить
символьне посилання на `extensions/redis`, тому ви можете працювати безпосередньо в директорії репозиторію yii2,
а не у специфічній для composer директорії vendor.


Робота з помилками та функціоналом
----------------------------------

Отримавши середовище розробки, як було описано вище, ви можете розпочати роботу над функціоналом або виправленням помилок.

### 1. Переконайтесь, що створено питання стосовно речі, над якою ви працюєте, якщо це потребує багатьох зусиль для виконання

Усі нові можливості та виправлення помилок повинні мати пов’язане запитання, яке забезпечує єдину точку посилання для обговорення
та документації. Витратьте декілька хвилин на перегляд списку створених питань, щоб знайти ті, що стосуються внеску, який ви
збираєтесь зробити. Якщо знайдете таке у списку запитань, потім, будь ласка, залиште коментар із зазначенням, що ви
збираєтесь працювати над цим. Якщо не знайшли створеного питання, що стосується того, над чим ви збираєтесь працювати, будь ласка
[створіть нове запитання](report-an-issue.md) або відправте "pull request" безпосередньо, якщо це не складне виправлення. Це дозволить команді
розробників розглянути вашу пропозицію та надавати відповідний зворотний зв’язок протягом шляху.

> Для невеликих змін, проблем документації або простих виправлень нема потреби створювати питання, достатньо відправити "pull request" у цих випадках.

### 2. Отримайте останній код з головної гілки Yii

```
git fetch upstream
```

З цього необхідно розпочинати кожний новий внесок, щоб бути впевненим, що ви працюєте з найновішим кодом.

### 3. Створіть нову гілку для вашого внеску на базі поточної основної гілки Yii

> Це дуже важливо, тому що ви не зможете відправляти більше, ніж один "pull request" від вашого імені, у разі
  використання основної (master) гілки.

Кожні окремі виправлення помилок або зміни повинні мати власні гілки. Назви гілок повинні бути наочними та починатись з
номеру питання, яке пов’язане із вашим кодом. Якщо ви працюєте не над специфічним питанням, просто пропустіть номер.
Наприклад:

```
git checkout upstream/master
git checkout -b 999-name-of-your-branch-goes-here
```

### 4. Робіть вашу магію, пишіть ваш код

Переконайтесь, що він працює :)

Модульні тести завжди вітаються. Протестований та добре покритий код надзвичайно полегшує перевірку вашого внеску.
Провальні модульні тести як опис проблеми також приймаються.

### 5. Оновіть журнал змін (CHANGELOG)

Додайте до файлу CHANGELOG зроблені вами зміни у верхній частині документу під заголовком
"Work in progress", запис у журналі змін повинен виглядати подібно до наведеного прикладу:

```
Bug #999: a description of the bug fix (Your Name)
Enh #999: a description of the enhancement (Your Name)
```

`#999` - це номер питання, на яке посилається виправлення помилки (`Bug`) або покращення (`Enh`).

Записи журналу змін повинні бути згруповані за типом (`Bug`, `Enh`) та сортовані за номером питання.

Для дуже малих виправлень, наприклад, друкарських помилок та змін у документації, нема потреби оновлювати CHANGELOG.

### 6. Створіть комміт ваших змін

Додайте файли/зміни, призначені для комміту, в [буферну зону](https://git.github.io/git-reference/basic/#add) за допомогою команди:

```
git add path/to/my/file.php
```

Використовуйте опцію `-p` для відбору змін, які ви бажаєте додати до вашого комміту.

Створіть комміт з описовим повідомленням. Переконайтесь, що вказали номер питання як `#XXX`, щоб GitHub
автоматично пов’язав ваш комміт із питанням:

```
git commit -m "A brief description of this change which fixes #999 goes here"
```

### 7. Додайте останній код Yii з upstream до вашої гілки

```
git pull upstream master
```

Це гарантує, що ви матимете останній код у вашій гілці перед тим, як відправити "pull request". Якщо є будь-які конфлікти поєднання,
треба виправити їх одразу та знову створити комміт. Це забезпечить команду розробників Yii можливістю легко приєднати ваші зміни
одним натисканням кнопки.

### 8. Вирішивши будь-які конфлікти, відправте ваш код до GitHub

```
git push -u origin 999-name-of-your-branch-goes-here
```

Опція `-u` забезпечує те, що ваша гілка відтепер оброблятиметься автоматично при запитах push та pull до GitHub гілки.
Це означає, якщо ви виконаєте `git push` наступного разу, програма буде знати куди відправляти. Це корисно, якщо ви
бажаєте пізніше додавати більше коммітів у "pull request".

### 9. Відправте ["pull request"](https://help.github.com/articles/creating-a-pull-request-from-a-fork/) до upstream.

Перейдіть до вашого репозиторію на GitHub та натисніть "Pull Request", оберіть вашу гілку справа та внесіть трохи деталей
у полі коментарю. Щоб пов’язати "pull request" із запитанням, внесіть десь у коментарі `#999`, де 999 - це номер питання.

> Зауважте, що кожний "pull request" повинен стосуватись окремої зміни. Для багатьох змін, не пов’язаних між собою,
  будь ласка, відправляйте "pull request" окремо для кожної.

### 10. Дехто перевірить ваш код

Дехто перевірить ваш код, й, можливо, вас попросять внести деякі зміни. У цьому випадку перейдіть до кроку #6 (нема потреби
відправляти інший "pull request", якщо ваш поточний досі відкритий). Якщо ваш код прийнято, то він буде поєднаний з головною гілкою
та стане частиною наступного релізу Yii. Якщо ж ні, не сумуйте, різні люди потребують різних можливостей, та Yii
не може бути всім для всіх, ваш код залишатиметься доступним на GitHub для людей, які його потребують.

### 11. Проведіть чистку

Після того, як ваш код був прийнятий або відхилений, можете видалити гілки, над якими ви працювали, із локального репозиторію
та з `origin`.

```
git checkout master
git branch -D 999-name-of-your-branch-goes-here
git push origin --delete 999-name-of-your-branch-goes-here
```

### Примітка:

Для виявлення регресу на ранніх стадіях кожне поєднання з кодовою базою Yii на GitHub опрацьовується у
[Travis CI](https://travis-ci.com) для автоматичного запуску тестів. Оскільки основна команда розробників не бажає
перевантажувати сервіс, додавайте [`[ci skip]`](https://docs.travis-ci.com/user/customizing-the-build/#Skipping-a-build) до
опису поєднання, якщо ваш "pull request":

* зачіпає лише файли javascript, css або файли зображень,
* оновлює документацію,
* змінює лише фіксовані текстові рядки (наприклад, оновлення перекладу)

Це захистить travis від запуску тестів на змінах, які не покриті тестами.

### Огляд команд (для досвідчених учасників)

```
git clone git@github.com:YOUR-GITHUB-USERNAME/yii2.git
git remote add upstream https://github.com/yiisoft/yii2.git
```

```
git fetch upstream
git checkout upstream/master
git checkout -b 999-name-of-your-branch-goes-here

/* робіть вашу магію; оновіть журнал змін, якщо необхідно */

git add path/to/my/file.php
git commit -m "A brief description of this change which fixes #999 goes here"
git pull upstream master
git push -u origin 999-name-of-your-branch-goes-here
```
