<?php

namespace Spiral\RoadRunner\Http;

use Spiral\RoadRunner\WorkerAwareInterface;

/**
 * @psalm-import-type HeadersList from Request
 */
interface HttpWorkerInterface extends WorkerAwareInterface
{
    /**
     * Wait for incoming http request.
     *
     * @return Request|null
     */
    public function waitRequest();

    /**
    * Send response to the application server.
    *
    * @param int               $status  Http status code
    * @param string            $body    Body of response
     * @param mixed[] $headers An associative array of the message's headers. Each key MUST be a header name,
                                 and each value MUST be an array of strings for that header.
    */
    public function respond($status, $body, $headers = []);
}
