<?php
namespace zin\utils;

/**
 * 对数据进行HTML实体转为字符。
 * Un HTML array.
 *
 * @param  mixed  $data
 * @access public
 * @return mixed
 */
function unHTMLArray($data, $processed = array())
{
    if(is_string($data)) return htmlspecialchars_decode($data);

    if(is_array($data) || is_object($data))
    {
        if(in_array($data, $processed, true)) return $data;

        $processed[] = $data;
        foreach($data as &$value) $value = unHTMLArray($value, $processed);
    }
    return $data;
}


/**
 * @return string|false
 */
function jsonEncode($data, $flags = 0, $depth = 512)
{
    $data = unHTMLArray($data);
    return json_encode($data, $flags, $depth);
}
