<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>TIMER TRAVEL & TOURS</title>
    <meta name="description" content="Plan Your Journey With Us">
    <meta name="keywords" content="">

    <!-- Mobile Specific Metas -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Favicons - Place favicon.ico in the root directory -->
    <link rel="icon" type="image/png" href="assets/img/favicon.png">


 <!-- Social Share Data -->

    <meta content="text/html; charset=utf-8" name="Content-Type">

     <meta property="og:type" content="article">

    <meta property="og:image" content="https://timertraveltours.com/assets/img/card/1.png">

    <!--  Less than 65 characters -->
    <meta property="og:title" content="TIMER TRAVEL & TOURS &copy;">

    <meta property="og:url" content="https://timertraveltours.com/">

 <!--  Less than 300 characters -->
    <meta property="og:description" content="Plan Your Journey With Us">

    <meta property="og:site_name" content="TIMER TRAVEL & TOURS &copy;">
    
    <!-- Twitter Cards -->

    <meta name="twitter:card" content="summary_large_image">

    <meta name="twitter:url" content="https://timertraveltours.com/">

    <meta name="twitter:title" content="TIMER TRAVEL & TOURS &copy;">

    <meta name="twitter:description" content="Plan Your Journey With Us">

    <meta name="twitter:image" content="https://timertraveltours.com/assets/img/card/1.png">

    <meta name="twitter:site" content="@timer_travel_and_tours">

    <meta name="twitter:creator" content="@iann_thecreator">

    <!--==============================
      Google Fonts
    ============================== -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100..900&family=Manrope:wght@200..800&family=Montez&display=swap" rel="stylesheet">

    <!--==============================
        All CSS File
    ============================== -->
    <!-- Bootstrap -->
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <!-- Fontawesome Icon -->
    <link rel="stylesheet" href="assets/css/fontawesome.min.css">
    <!-- Magnific Popup -->
    <link rel="stylesheet" href="assets/css/magnific-popup.min.css">

    <!-- Swiper css -->
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css">

    <!-- Theme Custom CSS -->
    <link rel="stylesheet" href="assets/css/style.css">   

    <!--Animations-->
    <link rel="stylesheet" type="text/css" href="assets/css/animations/style.css"> 

    <!--Fontawesome 6-->
    <link href="assets/css/fontawesome/css/all.css" rel="stylesheet">


    <!-- Google Translate Script -->
    <script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

</head>

<body>

    <!--[if lte IE 9]>
        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>
    <![endif]-->


    <!--********************************
        Code Start From Here 
    ******************************** -->

    <!-- <div class="magic-cursor relative z-10">  
        <div class="cursor"></div>
        <div class="cursor-follower"></div> 
    </div> -->


    <!--==============================
     Preloader
  ==============================-->
    <div id="preloader" class="preloader ">
        <div class="preloader-inner">
            <img src="assets/img/logo/1.png" alt="Timer Tours & Travel">
        </div>

        <div id="loader" class="th-preloader">
            <div class="animation-preloader">
                <div class="txt-loading">
                    <span preloader-text="T" class="characters">T </span>

                    <span preloader-text="I" class="characters">I </span>

                    <span preloader-text="M" class="characters">M </span>

                    <span preloader-text="E" class="characters">E </span>

                    <span preloader-text="R" class="characters">R </span>
                </div>
            </div>
        </div>

    </div>

    
    <!--==============================
    Mobile Menu
  ============================== -->
    <div class="th-menu-wrapper onepage-nav">
        <div class="th-menu-area text-center">
            <button class="th-menu-toggle"><i class="fal fa-times"></i></button>
            <div class="mobile-logo">
                <a href="#!"><img src="assets/img/logo/1.png" alt="Timer Tours & Travel"></a>
            </div>
            <div class="th-mobile-menu">
                <ul>
                    <li><a class="active" href="#!">Home</a></li>
                    <li class="menu-item-has-children">
                        <a href="#">Services</a>
                        <ul class="sub-menu">
                            <li><a href="services/">All Services</a></li>
                            <li><a href="services/tour-packages">Tour Packages</a></li>
                            <li><a href="services/accommodation">Hotel & Accommodation</a></li>
                            <li><a href="services/airline-ticketing">Airline Ticketing</a></li>
                            <li><a href="services/visit-visa">Visit Visa</a></li>
                            <li><a href="services/family-visa">Family Visa</a></li>
                            <li><a href="services/employment-visa">Employment Visa</a></li>
                            <li><a href="services/airport-transfers">Airport Transfers & Transportation</a></li>
                            <li><a href="services/pro-services">Document Clearing and PRO Services</a></li>
                            <!--<li><a href="services/visa-change">Airport to Airport (A2A) Visa Change</a></li>-->
                        </ul>
                    </li>
                    <li class="menu-item-has-children">
                        <a href="#">Visa Assistance</a>
                        <ul class="sub-menu">
                            <li><a href="services/visit-visa">Visit Visa</a></li>
                            <li><a href="services/family-visa">Family Visa</a></li>
                            <li><a href="services/employment-visa">Employment Visa</a></li>
                            <li><a href="services/travel-consultation">Travel Consultation</a></li>
                        </ul>
                    </li>
                    <li><a href="services">Packages</a></li>
                    <li><a href="about-us">About Us</a></li>
                    <li><a href="contact-us">Contact us</a></li>
                </ul>
            </div>
        </div>
    </div> 


    <!--==============================
    Header Area  
==============================-->
    <header class="th-header header-layout1 header-layout2">
        <div class="header-top">
            <div class="container th-container">
                <div class="row justify-content-center justify-content-lg-between align-items-center">
                    <div class="col-auto d-none d-md-block">
                        <div class="header-links">
                            <ul>
                                <li class="d-none d-xl-inline-block"><i class="fa-sharp fa-light fa-map-marker"></i>
                                    <span><a href="https://maps.app.goo.gl/sYjoRd6zaUzn7GPP6" target="_blank">DIP1, CEO building Office 508</a></span>
                                </li>
                                <li class="d-none d-xl-inline-block"><i class="fa fa-phone"></i>
                                    <span><a href="tel:+971527625056">+971 527625056</a> | <a href="tel:+9710521762038">+971 0521762038</a></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-auto">
                        <div class="header-right">
                            <div class="">

                <div id="google_translate_element"></div>

  <script type="text/javascript">
    function googleTranslateElementInit() {
      new google.translate.TranslateElement({ pageLanguage: 'en' }, 'google_translate_element');
    }
  </script>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="sticky-wrapper">
            <!-- Main Menu Area -->
            <div class="menu-area background-overlay-white" data-bg-src="assets/img/stock/header/5.png">
                <div class="container th-container">
                    <div class="row align-items-center justify-content-between">
                        <div class="col-auto">
                            <div class="header-logo">
                                <a href="#!"><img src="assets/img/logo/1.png" alt="Timer Tours & Travel"></a>
                            </div>
                        </div>
                        <div class="col-auto">
                            <nav class="main-menu d-none d-xl-inline-block">
                                <ul>
                                    <li><a class="active" href="#!">Home</a></li>
                                    <li class="menu-item-has-children mega-menu-wrap">
                                        <a href="#!">Services</a>
                                        <ul class="mega-menu mega-menu-content">
                                            <li>
                                                <div class="container">
                                                    <div class="row gy-4">
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/1.png" alt="Tour Packages">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/tour-packages">Tour Packages</a></h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/2.png" alt="Hotel & Accommodation">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/accommodation">Hotel & Accommodation</a></h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/3.png" alt="Airline Ticketing">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/airline-ticketing">Airline Ticketing</a>
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/4.png" alt="Visit Visa">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/visit-visa">Visit Visa</a>
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/5.png" alt="Family Visa">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/family-visa">Family Visa</a>
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/6.png" alt="Employment Visa">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/employment-visa">Employment Visa</a>
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/8.png" alt="Airport Transfers & Transportation">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/airport-transfers">Airport Transfers & Transportation</a>
                                                                </h3>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/7.png" alt="Document Clearing and PRO Services">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/pro-services">Document Clearing and PRO Services</a></h3>
                                                            </div>
                                                        </div>
                                                        <!--<div class="col-lg-3">
                                                            <div class="mega-menu-box">
                                                                <div class="mega-menu-img">
                                                                    <img src="assets/img/stock/dropdown/9.png" alt="Airport to Airport (A2A) Visa Change">
                                                                </div>
                                                                <h3 class="mega-menu-title"><a href="services/visa-change">Airport to Airport (A2A) Visa Change</a>
                                                                </h3>
                                                            </div>
                                                        </div>-->

                                                    </div>
                                                </div>
                                            </li>
                                        </ul>
                                    </li>
                                    <li class="menu-item-has-children">
                                        <a href="#">Visa Assistance</a>
                                        <ul class="sub-menu">
                                            <li><a href="services/visit-visa">Visit Visa</a></li>
                                            <li><a href="services/family-visa">Family Visa</a></li>
                                            <li><a href="services/employment-visa">Employment Visa</a></li>
                                            <li><a href="services/travel-consultation">Travel Consultation</a></li>
                                            <!--<li><a href="services/visa-change">Airport to Airport (A2A) Visa Change</a></li>-->
                                        </ul>
                                    </li>
                                    <li><a href="services">Packages</a></li>
                                    <li><a href="about-us">About Us</a></li>
                                    <li><a href="contact-us">Contact us</a></li>
                                </ul>
                            </nav>
                            <button type="button" class="th-menu-toggle d-block d-xl-none"><i class="fa fa-bars"></i></button>
                        </div>
                        <div class="col-auto d-none d-xl-block">
                            <div class="header-button">
                                <a href="#!" class="th-btn style3 th-icon">Book Now</a>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </header>
    <!--==============================
Hero Area
==============================-->
    <div class="hero-2" id="hero">
        <div class="hero2-overlay" data-bg-src="assets/img/bg/line-pattern.png"></div>
        <div class="swiper hero-slider-2" id="heroSlide2">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg" data-bg-src="assets/img/stock/hero/4.png">
                        </div>
                        <div class="container">
                            <div class="hero-style2">
                                <h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">
                                    Discover <span class="hero-text">The beauty of Dubai</span>
                                </h1>
                                <p class="hero-desc" data-ani="slideinup" data-ani-delay="0.5s">
                                    With a rapidly grown to become a trusted name in the travel industry, providing personalized and seamless services that cater to the diverse needs of our clients.
                                </p>
                                <div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">
                                    <a href="services/tour-packages" class="th-btn white-btn th-icon">Explore Dubai</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <video autoplay loop muted>
                            <source src="assets/img/hero/hero-video.mp4" type="video/mp4">
                        </video>

                        <div class="container">
                            <div class="hero-style2">
                                <h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">
                                    Explore<span class="hero-text">Beauty of the whole Dubai</span>
                                </h1>
                                <p class="hero-desc" data-ani="slideinup" data-ani-delay="0.5s">
                                    Provide a detailed itinerary of the tour, including the places you'll visit each day,
                                    any activities planned approximate times.
                                </p>
                                <div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">
                                    <a href="services/tour-packages" class="th-btn white-btn th-icon">Discover beauty</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="th-hero-bg" data-bg-src="assets/img/stock/hero/7.png">
                        </div>

                        <div class="container">
                            <div class="hero-style2">
                                <h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">
                                    VISA <span class="hero-text">Assistance on Visit, Family & Employment </span>
                                </h1>
                                <p class="hero-desc" data-ani="slideinup" data-ani-delay="0.5s" style="font-size: 16px;">
                                    Obtain a hassle-free Visit Visa for those wishing to travel to Dubai or the UAE, Employment Visas for individuals who have secured a job in Dubai or the UAE or individuals who meet the income requirements to sponsor their families Visas in Dubai. 
                                </p>
                                <div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">
                                    <a href="services/visit-visa" class="th-btn white-btn th-icon">Explore Visas</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <video autoplay loop muted>
                            <source src="assets/img/hero/hero-video.mp4" type="video/mp4">
                        </video>

                        <div class="container">
                            <div class="hero-style2">
                                <h1 class="hero-title" data-ani="slideinup" data-ani-delay="0.4s">
                                    Discounted<span class="hero-text">Hotel/ Resort Bookings & Town Tours</span>
                                </h1>
                                <p class="hero-desc" data-ani="slideinup" data-ani-delay="0.5s" style="font-size: 16px;">
                                    Book hotels & Resorts of your choice with exclusive complimentary luxury rooms and suites, private beach, picture perfect pools & tour around Dubai, Beaches and desert safari inclusive at an affordable price
                                </p>
                                <div class="btn-group" data-ani="slideinup" data-ani-delay="0.6s">
                                    <a href="services/accommodation" class="th-btn white-btn th-icon">Explore Accomodations</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="th-swiper-custom">
                <div class="swiper-pagination"></div>
                <div class="hero-icon">
                    <button data-slider-prev="#heroSlide2, #heroSlide3" class="hero-arrow slider-prev"><img src="assets/img/icon/hero-arrow-left.svg" alt=""></button>
                    <button data-slider-next="#heroSlide2, #heroSlide3" class="hero-arrow slider-next"><img src="assets/img/icon/hero-arrow-right.svg" alt=""></button>
                </div>
            </div>
        </div>
        <div class="swiper heroThumbs style2" id="heroSlide3">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="hero-card">
                            <div class="hero-img">
                                <img src="assets/img/stock/top-slider/2.png" alt="Museum of the future">
                            </div>
                            <div class="hero-card_content">
                                <h3 class="box-title mb-2 mt-2" style="font-size: 14px;">Museum of the future</h3>
                                <p class="text-white" style="font-size: 10px;line-height: 15px;padding: 0;margin: 0;">Journey 50 years into the future to get an imaginative glimpse of what the world will be like.</p>
                                <a href="services/tour-packages" class="th-btn style2">Book Now</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="hero-card">
                            <div class="hero-img">
                                <img src="assets/img/stock/top-slider/5.png" alt="Desert Safari">
                            </div>
                            <div class="hero-card_content">
                                <h3 class="box-title mb-2 mt-2" style="font-size: 14px;">Desert Safari, Quad Bike, Camel Ride & Al Khayma Camp</h3>
                                <p class="text-white" style="font-size: 10px;line-height: 15px;padding: 0;margin: 0;">Enjoy desert sports like dune bashing and sandboarding on this desert safari. Add to the thrills with optional quad bike and camel rides, and savor an optional BBQ.</p>
                                <a href="services/tour-packages" class="th-btn style2">Book Now</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="hero-card">
                            <div class="hero-img">
                                <img src="assets/img/stock/top-slider/9.png" alt="Luxury Yacht Tour">
                            </div>
                            <div class="hero-card_content">
                                <h3 class="box-title mb-2 mt-2" style="font-size: 14px;">Luxury Yacht Tour with Options to Add a BBQ Lunch</h3>
                                <p class="text-white" style="font-size: 10px;line-height: 15px;padding: 0;margin: 0;">Dubai's magnificent coastline on a guided luxury yacht tour. With onboard food and complimentary drink service as you pass iconic landmarks.</p>
                                <a href="services/tour-packages" class="th-btn style2">Book Now</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide">
                    <div class="hero-inner">
                        <div class="hero-card">
                            <div class="hero-img">
                                <img src="assets/img/stock/top-slider/10.png" alt="Full Day Tour to Burj Khalifa">
                            </div>
                            <div class="hero-card_content">
                                <h3 class="box-title mb-2 mt-2" style="font-size: 14px;">Full Day Tour with Entry to Burj Khalifa at the Top</h3>
                                <p class="text-white" style="font-size: 10px;line-height: 15px;padding: 0;margin: 0;">Ascend to the spectacular Burj Khalifa on an 8-hour sightseeing tour. Explore the old Al Bastakiya quarter and ride an ‘abra’ boat across Dubai Creek.</p>
                                <a href="services/tour-packages" class="th-btn style2">Book Now</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="scroll-down">
            <a href="#destination-sec" class="scroll-wrap"><span><img src="assets/img/icon/down-arrow.svg" alt=""></span>
                Scroll
                Down</a>
        </div>
    </div>




    <!--==============================
Gallery Area  
==============================-->
    <div class="gallery-area2 bg-top-center space" data-bg-src="assets/img/stock/welcome/9.png">
        <div class="container">
            <div class="row justify-content-lg-between justify-content-center align-items-center">
                <div class="col-lg-7">
                    <div class="title-area text-center text-lg-start mb-20 pe-xl-5 me-xl-5">
                        <span class="sub-title">Best Memorable Places</span>
                        <h2 class="sec-title text-white">Explore the most amazing places in the Dubai.<span class="flash">.</span></h2>
                    </div>
                    <!--<p class="sec-text style2 text-title text-white mb-50">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                        eiusmod tempor incididunt labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud
                        exercitation.</p>-->
                </div>
                <div class="col-auto">
                    <div class="sec-btn">
                        <a href="services/tour-packages" class="th-btn style3 th-icon">Let's take you there</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="container th-container2">
            <div class="shape-mockup movingX d-none d-xl-block" data-bottom="35%" data-right="-4%">
                <img src="assets/img/shape/shape_2_1.png" alt="shape">
            </div>
            <div class="shape-mockup movingX d-none d-xl-block" data-bottom="8%" data-left="-10%">
                <img src="assets/img/shape/shape_2_4.png" alt="shape">
            </div>
        </div>
    </div>
  

  <!--==============================
Service Area  
==============================-->

    <section class="tour-sec2 position-relative overflow-hidden bg-top-center z-index-3 space-top" id="tour-sec" data-pos-for=".counter-sec2" data-sec-pos="bottom-half" data-bg-src="">
        <div class="container">
            <div class="title-area mb-15 text-center">
                <span class="sub-title">Best Recommended Places</span>
                <h2 class="sec-title">Popular Destination we offer for all</h2>
            </div>
            <div class="slider-area tour-slider">
                <div class="swiper th-slider tourSlider2 slider-drag-wrap has-shadow" id="tourSlider2" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"480":{"slidesPerView":2},"576":{"slidesPerView":"2"},"1199":{"slidesPerView":"3"},"1400":{"slidesPerView":"4"}}}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="tour-card th-ani  gsap-cursor">
                                <div class="tour-card_img global-img">
                                    <img src="assets/img/stock/recon/1/2.png" alt="Museum of the future">
                                </div>
                                <div class="tour-content">
                                    <h3 class="box-title"><a href="services/tour-packages">Museum of the future</a></h3>
                                    <p class="text-white" style="font-size: 14px;line-height: 15px;padding-bottom: 20px;">Journey 50 years into the future to get an imaginative glimpse of what the world will be like.</p>
                                    <div class="tour-action">
                                        <span><i class="fa-light fa-map-marker"></i>Dubai</span>
                                        <a href="services/tour-packages" class="th-btn style4">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="tour-card th-ani  gsap-cursor">
                                <div class="tour-card_img global-img">
                                    <img src="assets/img/stock/recon/2/5.png" alt="Desert Safari">
                                </div>
                                <div class="tour-content">
                                    <h3 class="box-title"><a href="services/tour-packages">Desert Safari, Quad Bike, Camel Ride & Al Khayma Camp</a></h3>
                                    <p class="text-white" style="font-size: 14px;line-height: 15px;padding-bottom: 20px;">Enjoy desert sports like dune bashing and sandboarding on this desert safari. Add to the thrills with optional quad bike and camel rides, and savor an optional BBQ.</p>
                                    <div class="tour-action">
                                        <span><i class="fa-light fa-map-marker"></i>Dubai</span>
                                        <a href="services/tour-packages" class="th-btn style4">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="tour-card th-ani  gsap-cursor">
                                <div class="tour-card_img global-img">
                                    <img src="assets/img/stock/recon/1/7.png" alt="Luxury Yacht Tour">
                                </div>
                                <div class="tour-content">
                                    <h3 class="box-title"><a href="services/tour-packages">Luxury Yacht Tour with Options to Add a BBQ Lunch</a></h3>
                                    <p class="text-white" style="font-size: 14px;line-height: 15px;padding-bottom: 20px;">Dubai's magnificent coastline on a guided luxury yacht tour. With onboard food and complimentary drink service as you pass iconic landmarks.</p>
                                    <div class="tour-action">
                                        <span><i class="fa-light fa-map-marker"></i>Dubai</span>
                                        <a href="services/tour-packages" class="th-btn style4">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="tour-card th-ani  gsap-cursor">
                                <div class="tour-card_img global-img">
                                    <img src="assets/img/stock/recon/2/9.png" alt="Full Day Tour to Burj Khalifa">
                                </div>
                                <div class="tour-content">
                                    <h3 class="box-title"><a href="services/tour-packages">Full Day Tour with Entry to Burj Khalifa at the Top</a></h3>
                                    <p class="text-white" style="font-size: 14px;line-height: 15px;padding-bottom: 20px;">Ascend to the spectacular Burj Khalifa on an 8-hour sightseeing tour. Explore the old Al Bastakiya quarter and ride an ‘abra’ boat across Dubai Creek.</p>
                                    <div class="tour-action">
                                        <span><i class="fa-light fa-map-marker"></i>Dubai</span>
                                        <a href="services/tour-packages" class="th-btn style4">Book Now</a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <!--==============================
Counter Area  
==============================-->
    <div class="counter-sec2 space" data-bg-src="assets/img/stock/header/3.png"style="background-attachment: fixed;">
        <div class="container">
            <div class="shape-mockup shape1 d-none d-xl-block" data-top="40%" data-left="-15%">
                <img src="assets/img/shape/shape_1.png" alt="shape">
            </div>
            <div class="shape-mockup shape2 d-none d-xl-block" data-top="50%" data-left="-14%">
                <img src="assets/img/shape/shape_2.png" alt="shape">
            </div>
            <div class="shape-mockup shape3 d-none d-xl-block" data-top="47%" data-left="-7%">
                <img src="assets/img/shape/shape_3.png" alt="shape">
            </div>
            <div class="shape-mockup spin d-none d-xl-block" data-bottom="0%" data-right="12%">
                <img src="assets/img/shape/shape_2_3.png" alt="shape">
            </div>
            <div class="shape-mockup jump d-none d-xl-block" data-top="30%" data-right="-13%">
                <img src="assets/img/shape/shape_2_2.png" alt="shape">
            </div>
            <div class="shape-mockup dance2 d-none d-xl-block" data-bottom="0%" data-right="-15%">
                <img src="assets/img/shape/shape_2_5.png" alt="shape">
            </div>
        </div>

    </div>


    <!--==============================
Cta Area  
==============================-->
    <div class="space-extra2 position-relative overflow-hidden">
        <div class="cta-sec5 bg-title" data-bg-src="assets/img/stock/welcome/6.png" style="background-attachment: fixed;">
            <div class="container">
                <div class="row align-items-center justify-content-center">
                    <div class="col-lg-7">
                        <div class="space">
                            <div class="title-area mb-40">
                                <span class="sub-title style1 text-white">Season Offers</span>
                                <h2 class="sec-title cta-title text-white">Get 30% Off</h2>
                                <h2 class="sec-title text-white">Your Next trip, With Your Friends & Family</h2>
                                <p class="text-white">Take advantage of our Group Tours & Corporate Travel offers on our Customized Tour Packages
                                </p>
                            </div>
                            <div class="btn-group">
                                <a href="services/tour-packages" class="th-btn style2 th-icon">Learn More</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5">
                        <div class="app-mockup movingX">
                            <img src="assets/img/stock/long/5.png" alt="app mockup">
                        </div>
                    </div>
                </div>
            </div>
            <div class="shape-mockup d-none d-xxl-block" data-bottom="0%" data-right="0%"><img src="assets/img/normal/about-slide-img3.png" alt="">
            </div>
        </div>
    </div>
    


    <!--==============================
destination Area  
==============================-->
    <div class="destination-area position-relative overflow-hidden ">
        <div class="container">
            <div class="title-area text-center">
                <span class="sub-title">Top Offerings</span>
                <h2 class="sec-title">Popular Services</h2>

            </div>
            <div class="swiper th-slider destination-slider slider-drag-wrap" id="aboutSlider1" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"3"}},"effect":"coverflow","coverflowEffect":{"rotate":"0","stretch":"95","depth":"212","modifier":"1"},"centeredSlides":"true"}'>
                <div class="swiper-wrapper">
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/1.png" alt="Tour Packages">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/tour-packages">Tour</a>
                                        </h4>
                                        <span class="destination-subtitle">Packages</span>
                                    </div>
                                    <div class="">
                                        <a href="services/tour-packages" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/9.png" alt="Hotel & Accommodation">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/accommodation"> Hotel &</a>
                                        </h4>
                                        <span class="destination-subtitle">Accommodation</span>
                                    </div>
                                    <div class="">
                                        <a href="services/accommodation" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/10.png" alt=" Airport Transfers">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/airport-transfers">Airport</a>
                                        </h4>
                                        <span class="destination-subtitle">Transfers</span>
                                    </div>
                                    <div class="">
                                        <a href="services/airport-transfers" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/12.png" alt=" Airport Transportation">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/airport-transfers">Airport</a>
                                        </h4>
                                        <span class="destination-subtitle">Transportation</span>
                                    </div>
                                    <div class="">
                                        <a href="services/airport-transfers" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/17.png" alt="Group Tours">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/tour-packages">Group</a>
                                        </h4>
                                        <span class="destination-subtitle">Tours</span>
                                    </div>
                                    <div class="">
                                        <a href="services/tour-packages" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/18.png" alt="Corporate Travel">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/">Corporate</a>
                                        </h4>
                                        <span class="destination-subtitle">Travel</span>
                                    </div>
                                    <div class="">
                                        <a href="services/" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/24.png" alt="Visa Assistance">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/visit-visa">Visa</a>
                                        </h4>
                                        <span class="destination-subtitle">Assistance</span>
                                    </div>
                                    <div class="">
                                        <a href="services/visit-visa" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/20.png" alt="Travel Consultation">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="contact-us">Travel</a>
                                        </h4>
                                        <span class="destination-subtitle">Consultation</span>
                                    </div>
                                    <div class="">
                                        <a href="contact-us" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/25.png" alt="Family Visa Services">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/family-visa">Family Visa</a>
                                        </h4>
                                        <span class="destination-subtitle">Services</span>
                                    </div>
                                    <div class="">
                                        <a href="services/family-visa" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="destination-box gsap-cursor">
                            <div class="destination-img">
                                <img src="assets/img/stock/block/28.png" alt="Document Clearing">
                                <div class="destination-content">
                                    <div class="media-left">
                                        <h4 class="box-title">
                                            <a href="services/pro-services">Document</a>
                                        </h4>
                                        <span class="destination-subtitle">Clearing</span>
                                    </div>
                                    <div class="">
                                        <a href="services/pro-services" class="th-btn style2 th-icon">Explore</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <!--==============================
elements Area  
==============================-->
    <div class="elements-sec bg-white">
        <div class="container-fluid">
            <div class="tags-container relative"></div>
        </div>
        <!-- <div class="feature-wrap1" data-throwable-scene="true">
        <p data-throwable-el="">
            <span class="feature-item">Learn</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item text-white" data-bg-color="#13182B">Enjoy</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item text-white" data-bg-color="#FF4F38">Passion</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item text-white" data-bg-color="#3282FB">Honesty</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item">Accountability</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item text-white" data-bg-color="#13182B">Integrity</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item text-white" data-bg-color="#FF4F38">Solicitory</span>
        </p>
        <p data-throwable-el="">
            <span class="feature-item text-white" data-bg-color="#3282FB">Compliance</span>
        </p>
    </div> -->

    </div>

    <!--==============================
About Area  
==============================-->
    <div class="bg-smoke position-relative overflow-hidden space" id="about-sec" data-bg-src="assets/img/bg/shape_bg_1.png">
        <div class="container">
            <div class="row gy-4 align-items-center">
                <div class="col-xl-4">
                    <div class="about-area6">
                        <div class="title-area mb-30">
                            <span class="sub-title style1 ">About Us</span>
                            <h2 class="sec-title mb-20">Timer Tours & Travel</h2>
                        </div>
                        <p class="sec-text mb-30">A premier travel agency based in Dubai, UAE, offering exceptional travel experiences for both leisure and business travelers.</p>
                        <p>Established in 2019, we have rapidly grown to become a trusted name in the travel industry, providing personalized and seamless services that cater to the diverse needs of our clients.</p>
                        
                        <div class="mt-35"><a href="about-us" class="th-btn style3 th-icon">Know More</a></div>
                    </div>
                </div>
                <div class="col-xl-8">
                    <div class="img-box5">
                        <div class="img1">
                            <img src="assets/img/stock/about/1.png" alt="About">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!--==============================
Contact Area  
==============================-->
    <div class="cantact-area6 position-relative overflow-hidden background-overlay" data-bg-src="assets/img/stock/welcome/3.png" style="background-attachment: fixed; background-size: cover;">
        <div class="container">
            <div class="row gy-4 justify-content-between align-items-center">
                <div class="col-lg-6">
                    <div class="text-center text-lg-start">
                        <div class="title-area pe-xl-5">
                            <span class="sub-title text-white">Get in touch</span>
                            <h2 class="sec-title text-white">Where in Dubai can we take you?</h2>
                            <p class="contact-text2 text-white">We’d love to hear from you. Our friendly team is always here to take you around.<span class="flash">.</span></p>
                        </div>
                        <a href="contact-us" class="th-btn style7 th-icon">Reach Us</a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="video-box4">
                        <a href="https://www.youtube.com/watch?v=cQfIUPw72Dk" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div><!--==============================
Cat Area  
==============================-->
    <div class="overflow-hidden space-extra2-top space">
        <div class="container th-container">
            <div class="title-area text-center">
                <span class="sub-title">Visa Assistance</span>
            </div>
            <hr>
            <div class="choose-item_wrapper">

                <div class="choose-item style3">
                    <div class="box-icon">
                        <img src="assets/img/icon/choose_4_1.svg" alt="Visit Visa">
                    </div>
                    <div class="media-body">
                        <h3 class="box-title"><a href="services/visit-visa">Visit Visa</a></h3>
                    </div>
                </div>

                <div class="choose-item style3">
                    <div class="box-icon">
                        <img src="assets/img/icon/choose_4_2.svg" alt="Family Visa">
                    </div>
                    <div class="media-body">
                        <h3 class="box-title"><a href="services/family-visa">Family Visa</a></h3>
                    </div>
                </div>

                <div class="choose-item style3">
                    <div class="box-icon">
                        <img src="assets/img/icon/choose_4_3.svg" alt="Employment Visa">
                    </div>
                    <div class="media-body">
                        <h3 class="box-title"><a href="services/employment-visa">Employment Visa</a></h3>
                    </div>
                </div>

                <div class="choose-item style3">
                    <div class="box-icon">
                        <img src="assets/img/icon/choose_4_4.svg" alt="Document Clearing">
                    </div>
                    <div class="media-body">
                        <h3 class="box-title"><a href="services/pro-services">Document Clearing</a></h3>
                    </div>
                </div>

                <div class="choose-item style3">
                    <div class="box-icon">
                        <img src="assets/img/icon/choose_4_5.svg" alt="Travel Consultation">
                    </div>
                    <div class="media-body">
                        <h3 class="box-title"><a href="services">Travel Consultation</a></h3>
                    </div>
                </div>
            </div>
            <hr>
        </div>

    </div>

    <!--==============================
Destination Area  
==============================-->

    <section class="position-relative overflow-hidden bg-top-center space-top background-overlay" id="destination-sec" data-bg-src="assets/img/stock/welcome/3.png" style="background-attachment: fixed;">
        <div class="container">
            <div class="title-area text-center">
                <span class="sub-title text-white">Top Spot</span>
                <h2 class="sec-title text-white">Customized Packages</h2>
            </div>
            <div class="slider-area">
                <div class="swiper th-slider has-shadow" id="destinationSlider6" data-slider-options='{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1300":{"slidesPerView":"3"}}}'>
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="destination-item2 th-ani">
                                <div class="box-img global-img">
                                    <img src="assets/img/stock/block/14.png" alt="Group Travel">
                                </div>
                                <div class="box-content">
                                    <h3 class="box-title"><a href="services/tour-packages">Group Travel</a></h3>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="destination-item2 th-ani">
                                <div class="box-img global-img">
                                    <img src="assets/img/stock/block/19.png" alt="Corporate Travel">
                                </div>
                                <div class="box-content">
                                    <h3 class="box-title"><a href="services/">Corporate Travel</a></h3>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="destination-item2 th-ani">
                                <div class="box-img global-img">
                                    <img src="assets/img/stock/block/27.png" alt="Family Visa">
                                </div>
                                <div class="box-content">
                                    <h3 class="box-title"><a href="services/family-visa">Family Visa</a></h3>
                                </div>
                            </div>
                        </div>

                        <div class="swiper-slide">
                            <div class="destination-item2 th-ani">
                                <div class="box-img global-img">
                                    <img src="assets/img/stock/block/16.png" alt="Group Accommodation">
                                </div>
                                <div class="box-content">
                                    <h3 class="box-title"><a href="services/accommodation">Group Accommodation</a></h3>
                                </div>
                            </div>
                        </div>

                    </div>

                    <button data-slider-prev="#destinationSlider6" class="slider-arrow slider-prev"><img src="assets/img/icon/right-arrow2.svg" alt=""></button>
                    <button data-slider-next="#destinationSlider6" class="slider-arrow slider-next"><img src="assets/img/icon/left-arrow2.svg" alt=""></button>
                </div>
            </div>
        </div>

    </section>

<!--==============================
Offer Area  
==============================-->
    <div class="newsletter-area space">
        <div class="container th-container">
            <div class="newsletter-sec background-overlay" data-bg-src="assets/img/stock/welcome/1.png">
                <div class="row justify-content-between align-items-center">
                    <div class="col-xl-6">
                        <div class="newsletter-wrapper ps-xl-4">
                            <h4 class="h2 newsletter-title text-white">Grab up to <span class="sec-title2">35% off</span><span class="d-block"> on your favorite </span>Destination</h4>
                            <p class="newsletter-text text-white">Limited time offer, don't miss the opportunity</p>
                        </div>
                        <div class="btn-group">
                                <a href="contact-us" class="th-btn th-icon">Book Now</a>
                            </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="newsletter-image">
                            <img src="assets/img/stock/float/1.png" alt="Image" class="float-bounce">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    


    <!--==============================
About Area  
==============================-->
    <div class="overflow-hidden space overflow-hidden">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="title-area text-center">
                        <span class="sub-title">Feature of the Timer</span>
                        <h2 class="sec-title">Revolutionizing the ways
                            we travel</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="choose-area2 background-overlay" data-bg-src="assets/img/stock/hero/4.png" style="background-attachment: fixed;">
            <div class="container">
                <div class="row gy-4 justify-content-center justify-content-lg-between">
                    <div class="col-lg-4 col-md-6 choose-feature_wrapp">
                        <div class="choose-feature">
                            <div class="box-img">
                                <img src="assets/img/stock/features/1.png" alt="Single Entry Visa">
                            </div>
                            <div class="choose-feature_content">
                                <h3 class="box-title text-white"><a href="services/visit-visa">Single Entry Visa</a></h3>
                                <span class="text-white" style="background: var(--title-color);padding: 7px 10px;border-radius: 5px;">500 USD for 60 days</span>
                                <p class="text-white mt-4" style="font-size: 14px;">Enjoy 24 hours express service as standard without paying extra. No hidden charges with us and you get full tracking.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 choose-feature_wrapp">
                        <div class="choose-feature">
                            <div class="box-img">
                                <img src="assets/img/stock/features/14.png" alt="Hotel Bookings">
                            </div>
                            <div class="choose-feature_content">
                                <h3 class="box-title text-white"><a href="services/accommodation">Hotel Bookings</a></h3>
                                <span class="text-white" style="background: var(--title-color);padding: 7px 10px;border-radius: 5px;">Discounted</span>
                                <p class="text-white mt-4" style="font-size: 14px;">We help you book hotels & Resorts of your choice Enjoy exclusive complimentary Luxury rooms and suites. privatebeach,Pictureperfect pools.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6 choose-feature_wrapp">
                        <div class="choose-feature">
                            <div class="box-img">
                                <img src="assets/img/stock/features/16.png" alt="Town Tours">
                            </div>
                            <div class="choose-feature_content">
                                <h3 class="box-title text-white"><a href="services/tour-packages">Town Tours</a></h3>
                                <span class="text-white" style="background: var(--title-color);padding: 7px 10px;border-radius: 5px;">Discounted</span>
                                <p class="text-white mt-4" style="font-size: 14px;"> We help you tour around around Dubai, Beaches and desert safari inclusive at an affordable price.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <!--==============================
    Footer Area
==============================-->
    <footer class="footer-wrapper bg-title footer-layout2">
        <div class="widget-area">
            <div class="container">
                <div class="row justify-content-between">
                    <div class="col-md-6 col-xl-3">
                        <div class="widget footer-widget">
                            <div class="th-widget-about">
                                <div class="about-logo">
                                    <a href="#!"><img src="assets/img/logo/2.png" alt="Timer Tours & Travel"></a>
                                </div>
                                <p class="about-text">A premier travel agency based in Dubai, UAE, offering exceptional travel experiences for both leisure and business travelers. </p>
                                <div class="th-social">
                                    <a href="https://www.facebook.com/"><i class="fab fa-facebook-f"></i></a>
                                    <a href="https://www.twitter.com/"><i class="fab fa-twitter"></i></a>
                                    <a href="https://www.linkedin.com/"><i class="fab fa-linkedin-in"></i></a>
                                    <a href="https://www.whatsapp.com/"><i class="fab fa-whatsapp"></i></a>
                                    <a href="https://instagram.com/"><i class="fab fa-instagram"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-auto">
                        <div class="widget widget_nav_menu footer-widget">
                            <h3 class="widget_title">Quick Links</h3>
                            <div class="menu-all-pages-container">
                                <ul class="menu">

                                    <li><a href="./">Home</a></li>
                                    <li><a href="about-us">About us</a></li>
                                    <li><a href="contact-us">Contact Us</a></li>
                                    <li><a href="services">Our Services</a></li>
                                    <li><a href="services">Our Packages</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-auto">
                        <div class="widget footer-widget">
                            <h3 class="widget_title">Get In Touch</h3>
                            <div class="th-widget-contact">
                                <div class="info-box_text">
                                    <div class="icon">
                                        <img src="assets/img/icon/phone.svg" alt="img">
                                    </div>
                                    <div class="details">
                                        <p><a href="tel:+971527625056" class="info-box_link">+971 527625056</a></p>
                                        <p><a href="tel:+9710521762038" class="info-box_link">+971 0521762038</a></p>
                                    </div>
                                </div>
                                <div class="info-box_text">
                                    <div class="icon">
                                        <img src="assets/img/icon/envelope.svg" alt="img">
                                    </div>
                                    <div class="details mt-1">
                                        <p><a href="mailto:timertours0@gmail.com" class="info-box_link">timertours0@gmail.com</a></p>
                                    </div>
                                </div>
                                <div class="info-box_text">
                                    <div class="icon"><img src="assets/img/icon/location-dot.svg" alt="img"></div>
                                    <div class="details">
                                        <p><a href="https://maps.app.goo.gl/sYjoRd6zaUzn7GPP6" target="_blank">CEO Building, Office 508, Dubai Invest Park 1, Dubai</a></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-xl-auto">
                        <div class="widget footer-widget">
                            <h3 class="widget_title">Gallery</h3>
                            <div class="sidebar-gallery">
                                <div class="gallery-thumb">
                                    <img src="assets/img/stock/footer-grid/1.png" alt="Gallery Image">
                                </div>
                                <div class="gallery-thumb">
                                    <img src="assets/img/stock/footer-grid/2.png" alt="Gallery Image">
                                </div>
                                <div class="gallery-thumb">
                                    <img src="assets/img/stock/footer-grid/3.png" alt="Gallery Image">
                                </div>
                                <div class="gallery-thumb">
                                    <img src="assets/img/stock/footer-grid/6.png" alt="Gallery Image">
                                </div>
                                <div class="gallery-thumb">
                                    <img src="assets/img/stock/footer-grid/5.png" alt="Gallery Image">
                                </div>
                                <div class="gallery-thumb">
                                    <img src="assets/img/stock/footer-grid/4.png" alt="Gallery Image">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="copyright-wrap">
            <div class="container">
                <div class="row justify-content-between align-items-center">
                    <div class="col-md-6">
                        <p class="copyright-text"><a href="#!">TIMER TOURS & TRAVEL</a> &copy; <script>document.write(new Date().getFullYear());</script>, All Rights Reserved.</p>
                    </div>
                    <div class="col-md-6 text-end d-none d-md-block">
                        <div class="footer-card">
                            <span class="title" style="font-size: 10px;">Powered by Custom Assist Inc<span class="flash">.</span></span>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <div class="shape-mockup movingX d-none d-xxl-block" data-top="24%" data-left="5%">
            <img src="assets/img/shape/shape_8.png" alt="shape">
        </div>
    </footer>

    <!--********************************
            Code End  Here 
    ******************************** -->

    <!-- Scroll To Top -->
    <div class="scroll-top">
        <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
            </path>
        </svg>
    </div>
    <!--==============================
modal Area  
==============================-->
    <div id="login-form" class="popup-login-register mfp-hide">
        <ul class="nav" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-menu" id="pills-home-tab" data-bs-toggle="pill" data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home" aria-selected="false">Login</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-menu active" id="pills-profile-tab" data-bs-toggle="pill" data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile" aria-selected="true">Register</button>
            </li>
        </ul>
        <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
                <h3 class="box-title mb-30">Sign in to your account</h3>
                <div class="th-login-form">
                    <form action="mail.php" method="POST" class="login-form ajax-contact">
                        <div class="row">
                            <div class="form-group col-12">
                                <label>Username or email</label>
                                <input type="text" class="form-control" name="email" id="email" required="required">
                            </div>
                            <div class="form-group col-12">
                                <label>Password</label>
                                <input type="password" class="form-control" name="pasword" id="pasword" required="required">
                            </div>

                            <div class="form-btn mb-20 col-12">
                                <button class="th-btn btn-fw th-radius2 ">Send Message</button>
                            </div>
                        </div>
                        <div id="forgot_url">
                            <a href="my-account.html">Forgot password?</a>
                        </div>
                        <p class="form-messages mb-0 mt-3"></p>
                    </form>
                </div>
            </div>
            <div class="tab-pane fade active show" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
                <h3 class="th-form-title mb-30">Sign in to your account</h3>
                <form action="mail.php" method="POST" class="login-form ajax-contact">
                    <div class="row">
                        <div class="form-group col-12">
                            <label>Username*</label>
                            <input type="text" class="form-control" name="usename" id="usename" required="required">
                        </div>
                        <div class="form-group col-12">
                            <label>First name*</label>
                            <input type="text" class="form-control" name="firstname" id="firstname" required="required">
                        </div>
                        <div class="form-group col-12">
                            <label>Last name*</label>
                            <input type="text" class="form-control" name="lastname" id="lastname" required="required">
                        </div>
                        <div class="form-group col-12">
                            <label for="new_email">Your email*</label>
                            <input type="text" class="form-control" name="new_email" id="new_email" required="required">
                        </div>
                        <div class="form-group col-12">
                            <label for="new_email_confirm">Confirm email*</label>
                            <input type="text" class="form-control" name="new_email_confirm" id="new_email_confirm" required="required">
                        </div>
                        <div class="statement">
                            <span class="register-notes">A password will be emailed to you.</span>
                        </div>

                        <div class="form-btn mt-20 col-12">
                            <button class="th-btn btn-fw th-radius2 ">Sign up</button>
                        </div>
                    </div>
                    <p class="form-messages mb-0 mt-3"></p>
                </form>
            </div>
        </div>
    </div>

    <!--==============================
    All Js File
============================== -->
    <!-- Jquery -->
    <!-- Jquery -->
    <script src="assets/js/vendor/jquery-3.6.0.min.js"></script>
    <!-- Swiper Js -->
    <script src="assets/js/swiper-bundle.min.js"></script>
    <!-- Bootstrap -->
    <script src="assets/js/bootstrap.min.js"></script>
    <!-- Magnific Popup -->
    <script src="assets/js/jquery.magnific-popup.min.js"></script>
    <!-- Counter Up -->
    <script src="assets/js/jquery.counterup.min.js"></script>
    <!-- Range Slider -->
    <script src="assets/js/jquery-ui.min.js"></script>
    <!-- imagesloaded -->
    <script src="assets/js/imagesloaded.pkgd.min.js"></script>
    <!-- isotope -->
    <script src="assets/js/isotope.pkgd.min.js"></script>
    <!-- gsap -->
    <script src="assets/js/gsap.min.js"></script>

    <!-- circle-progress -->
    <script src="assets/js/circle-progress.js"></script>

    <script src="assets/js/matter.min.js"></script>
    <script src="assets/js/matterjs-custom.js"></script>


    <!-- nice select -->
    <script src="assets/js/nice-select.min.js"></script>

    <!-- Main Js File -->
    <script src="assets/js/main.js"></script>
</body>

</html>